DROP TABLE IF EXISTS academic_years;

CREATE TABLE `academic_years` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `school_id` int(11) NOT NULL,
  `year` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO academic_years VALUES('1','2021-2022','1','2021-2022','2021-06-16 23:40:09','2021-06-16 23:40:09');
INSERT INTO academic_years VALUES('2','SEPTEMBER','1','2021','2021-09-09 16:19:39','2021-09-09 16:19:39');



DROP TABLE IF EXISTS assign_subjects;

CREATE TABLE `assign_subjects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject_id` int(11) NOT NULL,
  `teacher_id` int(11) DEFAULT NULL,
  `section_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS assignments;

CREATE TABLE `assignments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deadline` date NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS bank_cash_accounts;

CREATE TABLE `bank_cash_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `account_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_balance` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_user_id` int(11) NOT NULL,
  `update_user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO bank_cash_accounts VALUES('3','1','Ahmed Madni Bank Al Falah','318412.00','ELECTRIC PAY BILL 91835
ELECTRIC PAY BILL 132253
TOTAL AMOUNT=542500-91835-132253=318412','158','158','2021-06-21 21:37:25','2021-06-25 21:14:11');
INSERT INTO bank_cash_accounts VALUES('2','1','CASH IN HAND','0.00','','158','','2021-06-20 20:49:26','2021-06-20 20:49:26');
INSERT INTO bank_cash_accounts VALUES('4','1','Abid Ali Account','208000.00','DEPOSIT SHAHBAZ','158','158','2021-06-21 21:38:08','2021-06-25 20:44:16');



DROP TABLE IF EXISTS book_categories;

CREATE TABLE `book_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `category_name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS book_issues;

CREATE TABLE `book_issues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `library_id` int(11) NOT NULL,
  `book_id` int(11) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `return_date` date DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS books;

CREATE TABLE `books` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` int(11) NOT NULL,
  `author` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publisher` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rack_no` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publish_date` date NOT NULL,
  `photo` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'book.png',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS chart_of_accounts;

CREATE TABLE `chart_of_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO chart_of_accounts VALUES('1','1','MONTHLY RENT','income','2021-06-17 01:31:53','2021-06-17 01:31:53');
INSERT INTO chart_of_accounts VALUES('2','1','PRE ARREARS','income','2021-06-17 01:32:17','2021-06-17 01:32:17');
INSERT INTO chart_of_accounts VALUES('3','1','SECURITY','assets','2021-06-17 01:32:30','2022-04-28 21:23:20');
INSERT INTO chart_of_accounts VALUES('4','1','AC SECURITY','income','2021-06-17 01:32:45','2021-06-17 01:32:45');
INSERT INTO chart_of_accounts VALUES('5','1','AC CHARGES','assets','2021-06-17 01:34:27','2022-04-28 21:23:31');
INSERT INTO chart_of_accounts VALUES('6','1','KITCHEN EXPENSE','expense','2021-06-17 01:35:35','2021-06-17 01:35:35');
INSERT INTO chart_of_accounts VALUES('7','1','UTILITY BILL','expense','2021-06-17 01:35:59','2021-06-17 01:35:59');
INSERT INTO chart_of_accounts VALUES('8','1','DAILY EXPENSE','expense','2021-06-17 01:36:18','2021-08-01 20:57:32');
INSERT INTO chart_of_accounts VALUES('9','1','MAINTAINANCE','expense','2021-06-17 01:36:57','2021-06-17 01:36:57');
INSERT INTO chart_of_accounts VALUES('10','1','MISC EXPENSE','income','2021-06-17 01:37:21','2021-06-17 01:37:21');
INSERT INTO chart_of_accounts VALUES('11','1','BUILDING RENT','expense','2021-06-17 01:37:51','2021-06-17 01:37:51');
INSERT INTO chart_of_accounts VALUES('12','1','SALARY & WAGES','expense','2021-06-17 01:39:15','2021-06-17 01:39:15');
INSERT INTO chart_of_accounts VALUES('13','1','NEW PURCHASE','expense','2021-06-17 01:40:52','2021-06-17 01:40:52');
INSERT INTO chart_of_accounts VALUES('14','1','SEC REFUND','expense','2021-08-01 20:55:17','2021-08-01 20:58:48');



DROP TABLE IF EXISTS class_days;

CREATE TABLE `class_days` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `day` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS class_routines;

CREATE TABLE `class_routines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `day` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS classes;

CREATE TABLE `classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `class_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO classes VALUES('1','1','Ground Floor Lobby','1','2021-06-17 00:46:30','2021-06-17 00:46:30');
INSERT INTO classes VALUES('2','1','Ground Floor Back Side','1','2021-06-17 00:46:50','2021-06-17 00:46:50');
INSERT INTO classes VALUES('3','1','First Floor','1','2021-06-17 00:47:02','2021-06-17 00:47:02');
INSERT INTO classes VALUES('4','1','Extra seat','1','2021-06-30 23:03:14','2021-06-30 23:03:14');



DROP TABLE IF EXISTS custom_fields;

CREATE TABLE `custom_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `field_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS departments;

CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `school_logo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_logo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES('1','1','Jobian','','','','','','');
INSERT INTO departments VALUES('2','1','Students','','','','','','');



DROP TABLE IF EXISTS email_logs;

CREATE TABLE `email_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `receiver_email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS events;

CREATE TABLE `events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS exam_attendances;

CREATE TABLE `exam_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `attendance` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS exam_schedules;

CREATE TABLE `exam_schedules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `room` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS exams;

CREATE TABLE `exams` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS fee_types;

CREATE TABLE `fee_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `fee_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO fee_types VALUES('1','1','MONTHLY RENT','00M-01','','2021-06-17 01:17:33','2021-08-01 18:05:23');
INSERT INTO fee_types VALUES('2','1','SEC FEE','S-001','','2021-06-17 01:18:01','2021-06-27 09:39:54');
INSERT INTO fee_types VALUES('3','1','ADM','AD-001','','2021-06-17 01:18:23','2021-06-27 09:39:26');
INSERT INTO fee_types VALUES('4','1','PRE ARREARS','PA-001','','2021-06-17 01:18:58','2021-06-17 01:18:58');
INSERT INTO fee_types VALUES('5','1','AC Bill','AC-001','','2021-06-17 01:19:20','2021-06-27 09:39:11');
INSERT INTO fee_types VALUES('6','1','AC SEC','AS-001','','2021-06-17 01:19:38','2021-06-27 09:38:53');



DROP TABLE IF EXISTS grades;

CREATE TABLE `grades` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `grade_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `marks_from` decimal(8,2) NOT NULL,
  `marks_to` decimal(8,2) NOT NULL,
  `point` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS hostel_categories;

CREATE TABLE `hostel_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `hostel_id` int(11) NOT NULL,
  `standard` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hostel_fee` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS hostel_members;

CREATE TABLE `hostel_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `hostel_id` int(11) NOT NULL,
  `hostel_category_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS hostels;

CREATE TABLE `hostels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL DEFAULT 0,
  `hostel_name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS invoice_items;

CREATE TABLE `invoice_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `fee_id` int(11) NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `discount` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2596 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO invoice_items VALUES('1','1','1','4','15000.00','0.00','2021-06-20 19:47:29','2021-06-20 19:47:29');
INSERT INTO invoice_items VALUES('2','1','2','4','6500.00','0.00','2021-06-20 19:51:52','2021-06-20 19:51:52');
INSERT INTO invoice_items VALUES('3','1','3','4','14000.00','4000.00','2021-06-20 19:59:29','2021-06-20 19:59:29');
INSERT INTO invoice_items VALUES('4','1','4','4','14000.00','0.00','2021-06-20 20:02:37','2021-06-20 20:02:37');
INSERT INTO invoice_items VALUES('5','1','5','4','7000.00','0.00','2021-06-20 20:03:27','2021-06-20 20:03:27');
INSERT INTO invoice_items VALUES('1713','1','1098','1','10000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('7','1','7','4','10000.00','0.00','2021-06-20 20:04:52','2021-06-20 20:04:52');
INSERT INTO invoice_items VALUES('163','1','148','1','16500.00','0.00','2021-06-21 19:52:12','2021-06-21 19:52:12');
INSERT INTO invoice_items VALUES('9','1','9','4','7250.00','0.00','2021-06-20 20:08:49','2021-06-20 20:08:49');
INSERT INTO invoice_items VALUES('443','1','263','5','1940.00','0.00','2021-07-17 19:32:28','2021-07-17 19:32:28');
INSERT INTO invoice_items VALUES('1850','1','1215','1','15000.00','0.00','2022-03-27 12:38:15','2022-03-27 12:38:15');
INSERT INTO invoice_items VALUES('12','1','12','4','6500.00','0.00','2021-06-20 20:13:30','2021-06-20 20:13:30');
INSERT INTO invoice_items VALUES('13','1','13','4','6500.00','0.00','2021-06-20 20:14:01','2021-06-20 20:14:01');
INSERT INTO invoice_items VALUES('14','1','14','4','1000.00','0.00','2021-06-20 20:15:33','2021-06-20 20:15:33');
INSERT INTO invoice_items VALUES('15','1','15','4','8000.00','0.00','2021-06-20 20:16:18','2021-06-20 20:16:18');
INSERT INTO invoice_items VALUES('16','1','16','4','1000.00','0.00','2021-06-20 20:17:22','2021-06-20 20:17:22');
INSERT INTO invoice_items VALUES('19','1','20','4','2000.00','0.00','2021-06-20 20:30:08','2021-06-20 20:30:08');
INSERT INTO invoice_items VALUES('20','1','21','4','1000.00','0.00','2021-06-20 20:31:12','2021-06-20 20:31:12');
INSERT INTO invoice_items VALUES('21','1','22','4','8000.00','0.00','2021-06-20 20:31:50','2021-06-20 20:31:50');
INSERT INTO invoice_items VALUES('22','1','23','4','7250.00','0.00','2021-06-20 20:33:31','2021-06-20 20:33:31');
INSERT INTO invoice_items VALUES('23','1','24','4','2750.00','0.00','2021-06-20 20:34:24','2021-06-20 20:34:24');
INSERT INTO invoice_items VALUES('24','1','25','4','7250.00','0.00','2021-06-20 20:35:11','2021-06-20 20:35:11');
INSERT INTO invoice_items VALUES('25','1','26','4','2000.00','0.00','2021-06-20 20:36:18','2021-06-20 20:36:18');
INSERT INTO invoice_items VALUES('26','1','27','4','2000.00','0.00','2021-06-20 20:37:19','2021-06-20 20:37:19');
INSERT INTO invoice_items VALUES('401','1','168','5','340.00','0.00','2021-07-10 13:51:44','2021-07-10 13:51:44');
INSERT INTO invoice_items VALUES('28','1','29','4','9500.00','0.00','2021-06-20 20:38:36','2021-06-20 20:38:36');
INSERT INTO invoice_items VALUES('29','1','30','4','500.00','0.00','2021-06-20 20:39:18','2021-06-20 20:39:18');
INSERT INTO invoice_items VALUES('30','1','31','4','31000.00','0.00','2021-06-20 20:40:29','2021-06-20 20:40:29');
INSERT INTO invoice_items VALUES('212','1','42','2','10000.00','0.00','2021-06-25 19:07:54','2021-06-25 19:07:54');
INSERT INTO invoice_items VALUES('32','1','33','4','5000.00','0.00','2021-06-20 20:41:28','2021-06-20 20:41:28');
INSERT INTO invoice_items VALUES('33','1','34','4','10000.00','0.00','2021-06-20 20:43:13','2021-06-20 20:43:13');
INSERT INTO invoice_items VALUES('34','1','35','4','10000.00','0.00','2021-06-20 20:43:45','2021-06-20 20:43:45');
INSERT INTO invoice_items VALUES('158','1','36','1','15000.00','7500.00','2021-06-21 18:20:41','2021-06-21 18:20:41');
INSERT INTO invoice_items VALUES('183','1','37','1','17000.00','4800.00','2021-06-25 17:45:38','2021-06-25 17:45:38');
INSERT INTO invoice_items VALUES('160','1','38','1','14500.00','0.00','2021-06-21 18:42:22','2021-06-21 18:42:22');
INSERT INTO invoice_items VALUES('152','1','39','1','13000.00','0.00','2021-06-21 18:12:49','2021-06-21 18:12:49');
INSERT INTO invoice_items VALUES('196','1','40','1','13000.00','0.00','2021-06-25 18:12:11','2021-06-25 18:12:11');
INSERT INTO invoice_items VALUES('198','1','41','1','13000.00','0.00','2021-06-25 18:17:34','2021-06-25 18:17:34');
INSERT INTO invoice_items VALUES('211','1','42','1','16500.00','0.00','2021-06-25 19:07:54','2021-06-25 19:07:54');
INSERT INTO invoice_items VALUES('146','1','43','1','16500.00','0.00','2021-06-20 20:54:39','2021-06-20 20:54:39');
INSERT INTO invoice_items VALUES('181','1','44','1','24000.00','0.00','2021-06-25 17:39:05','2021-06-25 17:39:05');
INSERT INTO invoice_items VALUES('44','1','45','1','21000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('45','1','46','1','21000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('210','1','47','1','17000.00','8500.00','2021-06-25 18:52:34','2021-06-25 18:52:34');
INSERT INTO invoice_items VALUES('47','1','48','1','12000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('208','1','49','1','31000.00','0.00','2021-06-25 18:49:10','2021-06-25 18:49:10');
INSERT INTO invoice_items VALUES('49','1','50','1','18000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('50','1','51','1','19000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('51','1','52','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('52','1','53','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('53','1','54','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('54','1','55','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('55','1','56','1','13000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('56','1','57','1','18000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('57','1','58','1','12500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('58','1','59','1','12500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('206','1','60','1','13000.00','0.00','2021-06-25 18:38:21','2021-06-25 18:38:21');
INSERT INTO invoice_items VALUES('204','1','61','1','13000.00','0.00','2021-06-25 18:37:52','2021-06-25 18:37:52');
INSERT INTO invoice_items VALUES('202','1','62','1','13000.00','0.00','2021-06-25 18:37:17','2021-06-25 18:37:17');
INSERT INTO invoice_items VALUES('62','1','63','1','19000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('63','1','64','1','19000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('64','1','65','1','13000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('65','1','66','1','13000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('200','1','67','1','13000.00','0.00','2021-06-25 18:24:10','2021-06-25 18:24:10');
INSERT INTO invoice_items VALUES('194','1','68','1','13500.00','0.00','2021-06-25 18:04:24','2021-06-25 18:04:24');
INSERT INTO invoice_items VALUES('68','1','69','1','14500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('69','1','70','1','14500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('192','1','71','1','14500.00','0.00','2021-06-25 18:03:40','2021-06-25 18:03:40');
INSERT INTO invoice_items VALUES('190','1','72','1','14500.00','0.00','2021-06-25 18:02:49','2021-06-25 18:02:49');
INSERT INTO invoice_items VALUES('72','1','73','1','12000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('73','1','74','1','12000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('74','1','75','1','12000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('75','1','76','1','15000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('76','1','77','1','15000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('913','1','490','1','10000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('189','1','79','1','16000.00','0.00','2021-06-25 17:55:24','2021-06-25 17:55:24');
INSERT INTO invoice_items VALUES('79','1','80','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('80','1','81','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('81','1','82','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('173','1','83','1','16000.00','0.00','2021-06-21 20:14:41','2021-06-21 20:14:41');
INSERT INTO invoice_items VALUES('167','1','84','1','14000.00','0.00','2021-06-21 20:02:54','2021-06-21 20:02:54');
INSERT INTO invoice_items VALUES('84','1','85','1','16500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('188','1','86','5','1330.00','0.00','2021-06-25 17:47:40','2021-06-25 17:47:40');
INSERT INTO invoice_items VALUES('86','1','87','1','16500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('87','1','88','1','16500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('88','1','89','1','15000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('89','1','90','1','16000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('180','1','91','1','17000.00','500.00','2021-06-25 17:37:33','2021-06-25 17:37:33');
INSERT INTO invoice_items VALUES('91','1','92','1','17000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('92','1','93','1','16500.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('93','1','94','1','17000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('94','1','95','1','12000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('95','1','96','1','12000.00','0.00','2021-06-20 20:45:49','2021-06-20 20:45:49');
INSERT INTO invoice_items VALUES('96','1','97','1','12000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('177','1','98','1','21000.00','0.00','2021-06-25 17:29:54','2021-06-25 17:29:54');
INSERT INTO invoice_items VALUES('98','1','99','1','21000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('99','1','100','1','16000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('100','1','101','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('101','1','102','1','16000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('102','1','103','1','15000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('175','1','104','1','16000.00','0.00','2021-06-21 20:15:36','2021-06-21 20:15:36');
INSERT INTO invoice_items VALUES('171','1','105','1','16000.00','0.00','2021-06-21 20:13:31','2021-06-21 20:13:31');
INSERT INTO invoice_items VALUES('105','1','106','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('106','1','107','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('107','1','108','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('169','1','109','1','16000.00','0.00','2021-06-21 20:07:30','2021-06-21 20:07:30');
INSERT INTO invoice_items VALUES('377','1','110','1','13000.00','6500.00','2021-07-06 20:26:21','2021-07-06 20:26:21');
INSERT INTO invoice_items VALUES('110','1','111','1','13000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('111','1','112','1','13000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('112','1','113','1','16000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('113','1','114','1','16000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('165','1','115','1','16000.00','0.00','2021-06-21 20:00:16','2021-06-21 20:00:16');
INSERT INTO invoice_items VALUES('115','1','116','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('116','1','117','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('117','1','118','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('118','1','119','1','14000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('119','1','120','1','14000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('120','1','121','1','14000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('121','1','122','1','14000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('122','1','123','1','14500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('123','1','124','1','14500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('124','1','125','1','14500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('157','1','126','2','12000.00','0.00','2021-06-21 18:19:10','2021-06-21 18:19:10');
INSERT INTO invoice_items VALUES('126','1','127','1','13000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('127','1','128','1','13000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('128','1','129','1','13000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('129','1','130','1','13000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('130','1','131','1','16500.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('131','1','132','1','18000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('1704','1','1092','2','15000.00','0.00','2022-02-11 20:34:54','2022-02-11 20:34:54');
INSERT INTO invoice_items VALUES('133','1','134','1','16000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('134','1','135','1','16000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('135','1','136','1','16000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('136','1','137','1','18000.00','0.00','2021-06-20 20:45:50','2021-06-20 20:45:50');
INSERT INTO invoice_items VALUES('137','1','138','1','18000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('138','1','139','1','16000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('139','1','140','1','16500.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('140','1','141','1','14000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('141','1','142','1','14000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('142','1','143','1','14000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('143','1','144','1','14000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('144','1','145','1','13000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('145','1','146','1','13000.00','0.00','2021-06-20 20:45:51','2021-06-20 20:45:51');
INSERT INTO invoice_items VALUES('147','1','43','2','10000.00','0.00','2021-06-20 20:54:39','2021-06-20 20:54:39');
INSERT INTO invoice_items VALUES('148','1','147','1','16000.00','0.00','2021-06-20 21:35:41','2021-06-20 21:35:41');
INSERT INTO invoice_items VALUES('149','1','147','6','3000.00','0.00','2021-06-20 21:35:41','2021-06-20 21:35:41');
INSERT INTO invoice_items VALUES('1694','1','1015','3','500.00','0.00','2022-02-08 20:10:24','2022-02-08 20:10:24');
INSERT INTO invoice_items VALUES('153','1','39','2','5000.00','0.00','2021-06-21 18:12:49','2021-06-21 18:12:49');
INSERT INTO invoice_items VALUES('156','1','126','1','16000.00','0.00','2021-06-21 18:19:10','2021-06-21 18:19:10');
INSERT INTO invoice_items VALUES('159','1','36','2','5000.00','0.00','2021-06-21 18:20:41','2021-06-21 18:20:41');
INSERT INTO invoice_items VALUES('161','1','38','2','10000.00','0.00','2021-06-21 18:42:22','2021-06-21 18:42:22');
INSERT INTO invoice_items VALUES('164','1','148','2','10000.00','0.00','2021-06-21 19:52:12','2021-06-21 19:52:12');
INSERT INTO invoice_items VALUES('166','1','115','5','900.00','0.00','2021-06-21 20:00:16','2021-06-21 20:00:16');
INSERT INTO invoice_items VALUES('168','1','84','2','2500.00','0.00','2021-06-21 20:02:54','2021-06-21 20:02:54');
INSERT INTO invoice_items VALUES('170','1','109','5','900.00','0.00','2021-06-21 20:07:30','2021-06-21 20:07:30');
INSERT INTO invoice_items VALUES('172','1','105','5','1000.00','0.00','2021-06-21 20:13:31','2021-06-21 20:13:31');
INSERT INTO invoice_items VALUES('174','1','83','5','1000.00','0.00','2021-06-21 20:14:41','2021-06-21 20:14:41');
INSERT INTO invoice_items VALUES('176','1','104','5','970.00','0.00','2021-06-21 20:15:36','2021-06-21 20:15:36');
INSERT INTO invoice_items VALUES('178','1','98','5','2000.00','0.00','2021-06-25 17:29:54','2021-06-25 17:29:54');
INSERT INTO invoice_items VALUES('182','1','44','2','11000.00','0.00','2021-06-25 17:39:05','2021-06-25 17:39:05');
INSERT INTO invoice_items VALUES('184','1','37','2','5000.00','0.00','2021-06-25 17:45:38','2021-06-25 17:45:38');
INSERT INTO invoice_items VALUES('187','1','86','1','16500.00','0.00','2021-06-25 17:47:40','2021-06-25 17:47:40');
INSERT INTO invoice_items VALUES('191','1','72','5','3000.00','0.00','2021-06-25 18:02:49','2021-06-25 18:02:49');
INSERT INTO invoice_items VALUES('193','1','71','5','3000.00','0.00','2021-06-25 18:03:40','2021-06-25 18:03:40');
INSERT INTO invoice_items VALUES('195','1','68','5','3000.00','0.00','2021-06-25 18:04:24','2021-06-25 18:04:24');
INSERT INTO invoice_items VALUES('197','1','40','2','10000.00','0.00','2021-06-25 18:12:11','2021-06-25 18:12:11');
INSERT INTO invoice_items VALUES('199','1','41','2','10000.00','0.00','2021-06-25 18:17:34','2021-06-25 18:17:34');
INSERT INTO invoice_items VALUES('201','1','67','2','10000.00','0.00','2021-06-25 18:24:10','2021-06-25 18:24:10');
INSERT INTO invoice_items VALUES('203','1','62','2','5000.00','0.00','2021-06-25 18:37:17','2021-06-25 18:37:17');
INSERT INTO invoice_items VALUES('205','1','61','2','5000.00','0.00','2021-06-25 18:37:52','2021-06-25 18:37:52');
INSERT INTO invoice_items VALUES('207','1','60','2','5000.00','0.00','2021-06-25 18:38:21','2021-06-25 18:38:21');
INSERT INTO invoice_items VALUES('209','1','49','5','1220.00','0.00','2021-06-25 18:49:10','2021-06-25 18:49:10');
INSERT INTO invoice_items VALUES('213','1','149','1','15000.00','11500.00','2021-06-28 20:57:18','2021-06-28 20:57:18');
INSERT INTO invoice_items VALUES('214','1','149','2','5000.00','0.00','2021-06-28 20:57:18','2021-06-28 20:57:18');
INSERT INTO invoice_items VALUES('215','1','150','1','4000.00','0.00','2021-06-30 23:13:44','2021-06-30 23:13:44');
INSERT INTO invoice_items VALUES('217','1','152','1','15000.00','0.00','2021-07-01 19:36:25','2021-07-01 19:36:25');
INSERT INTO invoice_items VALUES('358','1','153','1','15000.00','0.00','2021-07-05 20:45:57','2021-07-05 20:45:57');
INSERT INTO invoice_items VALUES('219','1','154','1','17000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('454','1','220','5','1320.00','0.00','2021-07-17 19:38:51','2021-07-17 19:38:51');
INSERT INTO invoice_items VALUES('384','1','156','1','10000.00','0.00','2021-07-08 16:35:10','2021-07-08 16:35:10');
INSERT INTO invoice_items VALUES('380','1','157','1','13000.00','0.00','2021-07-08 16:05:14','2021-07-08 16:05:14');
INSERT INTO invoice_items VALUES('336','1','158','1','13000.00','0.00','2021-07-03 16:40:32','2021-07-03 16:40:32');
INSERT INTO invoice_items VALUES('224','1','159','1','24000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('1976','1','1335','1','16500.00','0.00','2022-04-24 10:31:50','2022-04-24 10:31:50');
INSERT INTO invoice_items VALUES('433','1','161','1','21000.00','0.00','2021-07-10 15:04:40','2021-07-10 15:04:40');
INSERT INTO invoice_items VALUES('227','1','162','1','17000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('432','1','163','1','13000.00','0.00','2021-07-10 15:02:53','2021-07-10 15:02:53');
INSERT INTO invoice_items VALUES('460','1','164','1','31000.00','0.00','2021-08-01 17:46:32','2021-08-01 17:46:32');
INSERT INTO invoice_items VALUES('230','1','165','1','18000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('231','1','166','1','19000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('402','1','167','1','16000.00','10000.00','2021-07-10 13:57:47','2021-07-10 13:57:47');
INSERT INTO invoice_items VALUES('400','1','168','1','16000.00','0.00','2021-07-10 13:51:44','2021-07-10 13:51:44');
INSERT INTO invoice_items VALUES('404','1','169','1','16000.00','10000.00','2021-07-10 14:00:22','2021-07-10 14:00:22');
INSERT INTO invoice_items VALUES('399','1','170','1','16000.00','6000.00','2021-07-10 13:49:19','2021-07-10 13:49:19');
INSERT INTO invoice_items VALUES('349','1','171','5','1000.00','0.00','2021-07-05 19:58:45','2021-07-05 19:58:45');
INSERT INTO invoice_items VALUES('237','1','172','1','18000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('238','1','173','1','12500.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('461','1','164','5','490.00','0.00','2021-08-01 17:46:32','2021-08-01 17:46:32');
INSERT INTO invoice_items VALUES('435','1','175','1','13000.00','5000.00','2021-07-10 15:40:47','2021-07-10 15:40:47');
INSERT INTO invoice_items VALUES('459','1','176','1','13000.00','5000.00','2021-07-17 19:55:10','2021-07-17 19:55:10');
INSERT INTO invoice_items VALUES('462','1','177','1','13000.00','5800.00','2021-08-01 17:58:13','2021-08-01 17:58:13');
INSERT INTO invoice_items VALUES('431','1','178','1','19000.00','5500.00','2021-07-10 14:59:39','2021-07-10 14:59:39');
INSERT INTO invoice_items VALUES('429','1','179','1','19000.00','1000.00','2021-07-10 14:58:36','2021-07-10 14:58:36');
INSERT INTO invoice_items VALUES('415','1','180','1','13000.00','0.00','2021-07-10 14:41:07','2021-07-10 14:41:07');
INSERT INTO invoice_items VALUES('365','1','181','5','1000.00','0.00','2021-07-05 21:46:57','2021-07-05 21:46:57');
INSERT INTO invoice_items VALUES('417','1','182','1','13000.00','0.00','2021-07-10 14:42:44','2021-07-10 14:42:44');
INSERT INTO invoice_items VALUES('675','1','183','5','920.00','0.00','2021-08-15 16:16:29','2021-08-15 16:16:29');
INSERT INTO invoice_items VALUES('439','1','184','5','920.00','0.00','2021-07-17 19:15:18','2021-07-17 19:15:18');
INSERT INTO invoice_items VALUES('350','1','185','1','14500.00','0.00','2021-07-05 20:02:10','2021-07-05 20:02:10');
INSERT INTO invoice_items VALUES('368','1','186','1','14500.00','0.00','2021-07-06 19:14:15','2021-07-06 19:14:15');
INSERT INTO invoice_items VALUES('366','1','187','1','14500.00','0.00','2021-07-06 19:13:36','2021-07-06 19:13:36');
INSERT INTO invoice_items VALUES('1712','1','1097','1','17000.00','0.00','2022-03-02 17:32:34','2022-03-02 17:32:34');
INSERT INTO invoice_items VALUES('254','1','189','1','12000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('255','1','190','1','12000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('256','1','191','1','15000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('257','1','192','1','15000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('258','1','193','1','15000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('419','1','194','1','16000.00','0.00','2021-07-10 14:49:33','2021-07-10 14:49:33');
INSERT INTO invoice_items VALUES('423','1','195','1','16000.00','0.00','2021-07-10 14:51:41','2021-07-10 14:51:41');
INSERT INTO invoice_items VALUES('378','1','196','1','16000.00','0.00','2021-07-06 20:48:38','2021-07-06 20:48:38');
INSERT INTO invoice_items VALUES('421','1','197','1','16000.00','0.00','2021-07-10 14:50:45','2021-07-10 14:50:45');
INSERT INTO invoice_items VALUES('410','1','198','1','16000.00','0.00','2021-07-10 14:12:59','2021-07-10 14:12:59');
INSERT INTO invoice_items VALUES('264','1','199','1','14000.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('265','1','200','1','16500.00','0.00','2021-07-01 19:40:26','2021-07-01 19:40:26');
INSERT INTO invoice_items VALUES('344','1','201','1','16500.00','0.00','2021-07-05 19:17:32','2021-07-05 19:17:32');
INSERT INTO invoice_items VALUES('267','1','202','1','16500.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('268','1','203','1','16500.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('269','1','204','1','15000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('412','1','205','1','16000.00','10000.00','2021-07-10 14:16:03','2021-07-10 14:16:03');
INSERT INTO invoice_items VALUES('395','1','206','1','17000.00','0.00','2021-07-08 17:47:12','2021-07-08 17:47:12');
INSERT INTO invoice_items VALUES('391','1','207','1','17000.00','0.00','2021-07-08 17:21:45','2021-07-08 17:21:45');
INSERT INTO invoice_items VALUES('371','1','208','5','525.00','0.00','2021-07-06 19:17:33','2021-07-06 19:17:33');
INSERT INTO invoice_items VALUES('413','1','209','1','17000.00','8500.00','2021-07-10 14:18:29','2021-07-10 14:18:29');
INSERT INTO invoice_items VALUES('275','1','210','1','12000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('276','1','211','1','12000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('277','1','212','1','12000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('455','1','213','1','21000.00','9440.00','2021-07-17 19:42:38','2021-07-17 19:42:38');
INSERT INTO invoice_items VALUES('436','1','214','1','21000.00','0.00','2021-07-12 21:05:41','2021-07-12 21:05:41');
INSERT INTO invoice_items VALUES('389','1','215','1','16000.00','0.00','2021-07-08 17:15:29','2021-07-08 17:15:29');
INSERT INTO invoice_items VALUES('375','1','216','1','16500.00','0.00','2021-07-06 20:05:19','2021-07-06 20:05:19');
INSERT INTO invoice_items VALUES('372','1','217','1','16000.00','0.00','2021-07-06 19:19:08','2021-07-06 19:19:08');
INSERT INTO invoice_items VALUES('451','1','218','1','15000.00','0.00','2021-07-17 19:37:33','2021-07-17 19:37:33');
INSERT INTO invoice_items VALUES('357','1','219','5','1320.00','0.00','2021-07-05 20:41:15','2021-07-05 20:41:15');
INSERT INTO invoice_items VALUES('453','1','220','1','16000.00','0.00','2021-07-17 19:38:51','2021-07-17 19:38:51');
INSERT INTO invoice_items VALUES('360','1','221','1','16500.00','0.00','2021-07-05 20:58:33','2021-07-05 20:58:33');
INSERT INTO invoice_items VALUES('382','1','222','1','16500.00','0.00','2021-07-08 16:22:06','2021-07-08 16:22:06');
INSERT INTO invoice_items VALUES('393','1','223','1','16500.00','0.00','2021-07-08 17:24:35','2021-07-08 17:24:35');
INSERT INTO invoice_items VALUES('388','1','224','5','2060.00','0.00','2021-07-08 17:12:57','2021-07-08 17:12:57');
INSERT INTO invoice_items VALUES('914','1','491','1','14000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('291','1','226','1','13000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('292','1','227','1','13000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('293','1','228','1','16000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('294','1','229','1','16000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('295','1','230','1','16000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('445','1','231','1','16500.00','0.00','2021-07-17 19:33:10','2021-07-17 19:33:10');
INSERT INTO invoice_items VALUES('447','1','232','1','16500.00','0.00','2021-07-17 19:33:44','2021-07-17 19:33:44');
INSERT INTO invoice_items VALUES('449','1','233','1','16500.00','0.00','2021-07-17 19:34:28','2021-07-17 19:34:28');
INSERT INTO invoice_items VALUES('446','1','231','5','1940.00','0.00','2021-07-17 19:33:10','2021-07-17 19:33:10');
INSERT INTO invoice_items VALUES('448','1','232','5','1940.00','0.00','2021-07-17 19:33:44','2021-07-17 19:33:44');
INSERT INTO invoice_items VALUES('450','1','233','5','1940.00','0.00','2021-07-17 19:34:28','2021-07-17 19:34:28');
INSERT INTO invoice_items VALUES('452','1','218','5','1320.00','0.00','2021-07-17 19:37:33','2021-07-17 19:37:33');
INSERT INTO invoice_items VALUES('303','1','238','1','14500.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('304','1','239','1','14500.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('456','1','213','5','3440.00','0.00','2021-07-17 19:42:38','2021-07-17 19:42:38');
INSERT INTO invoice_items VALUES('306','1','241','1','16000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('307','1','242','1','13000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('308','1','243','1','13000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('309','1','244','1','13000.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('441','1','245','1','13000.00','10000.00','2021-07-17 19:24:48','2021-07-17 19:24:48');
INSERT INTO invoice_items VALUES('311','1','246','1','16500.00','0.00','2021-07-01 19:40:27','2021-07-01 19:40:27');
INSERT INTO invoice_items VALUES('312','1','247','1','18000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('313','1','248','1','17000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('314','1','249','1','16000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('332','1','250','1','16000.00','0.00','2021-07-03 16:02:20','2021-07-03 16:02:20');
INSERT INTO invoice_items VALUES('408','1','251','1','16000.00','0.00','2021-07-10 14:04:23','2021-07-10 14:04:23');
INSERT INTO invoice_items VALUES('406','1','252','1','16000.00','0.00','2021-07-10 14:03:47','2021-07-10 14:03:47');
INSERT INTO invoice_items VALUES('2110','1','1344','1','16000.00','0.00','2022-05-08 15:22:33','2022-05-08 15:22:33');
INSERT INTO invoice_items VALUES('319','1','254','1','18000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('915','1','492','1','14000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('339','1','256','1','16500.00','10000.00','2021-07-03 18:48:50','2021-07-03 18:48:50');
INSERT INTO invoice_items VALUES('322','1','257','1','14000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('323','1','258','1','14000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('324','1','259','1','14000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('325','1','260','1','14000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('326','1','261','1','13000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('327','1','262','1','13000.00','0.00','2021-07-01 19:40:28','2021-07-01 19:40:28');
INSERT INTO invoice_items VALUES('442','1','263','1','16500.00','0.00','2021-07-17 19:32:28','2021-07-17 19:32:28');
INSERT INTO invoice_items VALUES('335','1','264','2','5000.00','0.00','2021-07-03 16:09:09','2021-07-03 16:09:09');
INSERT INTO invoice_items VALUES('334','1','264','1','15000.00','0.00','2021-07-03 16:09:09','2021-07-03 16:09:09');
INSERT INTO invoice_items VALUES('387','1','224','1','16000.00','10000.00','2021-07-08 17:12:57','2021-07-08 17:12:57');
INSERT INTO invoice_items VALUES('333','1','250','5','140.00','0.00','2021-07-03 16:02:20','2021-07-03 16:02:20');
INSERT INTO invoice_items VALUES('337','1','158','5','1000.00','0.00','2021-07-03 16:40:32','2021-07-03 16:40:32');
INSERT INTO invoice_items VALUES('340','1','266','1','16500.00','0.00','2021-07-03 19:41:37','2021-07-03 19:41:37');
INSERT INTO invoice_items VALUES('341','1','267','1','16500.00','0.00','2021-07-03 19:42:11','2021-07-03 19:42:11');
INSERT INTO invoice_items VALUES('370','1','208','1','16500.00','16500.00','2021-07-06 19:17:33','2021-07-06 19:17:33');
INSERT INTO invoice_items VALUES('345','1','201','5','2240.00','0.00','2021-07-05 19:17:32','2021-07-05 19:17:32');
INSERT INTO invoice_items VALUES('348','1','171','1','13000.00','0.00','2021-07-05 19:58:45','2021-07-05 19:58:45');
INSERT INTO invoice_items VALUES('351','1','185','5','1000.00','0.00','2021-07-05 20:02:10','2021-07-05 20:02:10');
INSERT INTO invoice_items VALUES('356','1','219','1','16000.00','0.00','2021-07-05 20:41:15','2021-07-05 20:41:15');
INSERT INTO invoice_items VALUES('359','1','153','5','500.00','0.00','2021-07-05 20:45:57','2021-07-05 20:45:57');
INSERT INTO invoice_items VALUES('361','1','221','5','1060.00','0.00','2021-07-05 20:58:33','2021-07-05 20:58:33');
INSERT INTO invoice_items VALUES('364','1','181','1','13000.00','0.00','2021-07-05 21:46:57','2021-07-05 21:46:57');
INSERT INTO invoice_items VALUES('367','1','187','5','900.00','0.00','2021-07-06 19:13:36','2021-07-06 19:13:36');
INSERT INTO invoice_items VALUES('369','1','186','5','900.00','0.00','2021-07-06 19:14:15','2021-07-06 19:14:15');
INSERT INTO invoice_items VALUES('373','1','217','5','525.00','0.00','2021-07-06 19:19:08','2021-07-06 19:19:08');
INSERT INTO invoice_items VALUES('376','1','216','5','525.00','0.00','2021-07-06 20:05:19','2021-07-06 20:05:19');
INSERT INTO invoice_items VALUES('379','1','196','5','385.00','0.00','2021-07-06 20:48:38','2021-07-06 20:48:38');
INSERT INTO invoice_items VALUES('381','1','157','5','1000.00','0.00','2021-07-08 16:05:14','2021-07-08 16:05:14');
INSERT INTO invoice_items VALUES('383','1','222','5','2050.00','0.00','2021-07-08 16:22:06','2021-07-08 16:22:06');
INSERT INTO invoice_items VALUES('390','1','215','5','525.00','0.00','2021-07-08 17:15:29','2021-07-08 17:15:29');
INSERT INTO invoice_items VALUES('392','1','207','5','2465.00','0.00','2021-07-08 17:21:45','2021-07-08 17:21:45');
INSERT INTO invoice_items VALUES('394','1','223','5','2060.00','0.00','2021-07-08 17:24:35','2021-07-08 17:24:35');
INSERT INTO invoice_items VALUES('396','1','206','5','2465.00','0.00','2021-07-08 17:47:12','2021-07-08 17:47:12');
INSERT INTO invoice_items VALUES('403','1','167','5','340.00','0.00','2021-07-10 13:57:47','2021-07-10 13:57:47');
INSERT INTO invoice_items VALUES('405','1','169','5','340.00','0.00','2021-07-10 14:00:22','2021-07-10 14:00:22');
INSERT INTO invoice_items VALUES('407','1','252','5','140.00','0.00','2021-07-10 14:03:47','2021-07-10 14:03:47');
INSERT INTO invoice_items VALUES('409','1','251','5','140.00','0.00','2021-07-10 14:04:23','2021-07-10 14:04:23');
INSERT INTO invoice_items VALUES('411','1','198','5','1320.00','0.00','2021-07-10 14:12:59','2021-07-10 14:12:59');
INSERT INTO invoice_items VALUES('414','1','268','1','13000.00','0.00','2021-07-10 14:31:06','2021-07-10 14:31:06');
INSERT INTO invoice_items VALUES('416','1','180','5','1000.00','0.00','2021-07-10 14:41:07','2021-07-10 14:41:07');
INSERT INTO invoice_items VALUES('418','1','182','5','1000.00','0.00','2021-07-10 14:42:44','2021-07-10 14:42:44');
INSERT INTO invoice_items VALUES('420','1','194','5','385.00','0.00','2021-07-10 14:49:33','2021-07-10 14:49:33');
INSERT INTO invoice_items VALUES('422','1','197','5','385.00','0.00','2021-07-10 14:50:45','2021-07-10 14:50:45');
INSERT INTO invoice_items VALUES('424','1','195','5','385.00','0.00','2021-07-10 14:51:41','2021-07-10 14:51:41');
INSERT INTO invoice_items VALUES('438','1','184','1','14500.00','0.00','2021-07-17 19:15:18','2021-07-17 19:15:18');
INSERT INTO invoice_items VALUES('674','1','183','1','13500.00','0.00','2021-08-15 16:16:29','2021-08-15 16:16:29');
INSERT INTO invoice_items VALUES('430','1','179','5','1365.00','0.00','2021-07-10 14:58:36','2021-07-10 14:58:36');
INSERT INTO invoice_items VALUES('434','1','161','5','280.00','0.00','2021-07-10 15:04:40','2021-07-10 15:04:40');
INSERT INTO invoice_items VALUES('437','1','214','5','3440.00','0.00','2021-07-12 21:05:41','2021-07-12 21:05:41');
INSERT INTO invoice_items VALUES('574','1','269','1','15000.00','0.00','2021-08-03 20:49:08','2021-08-03 20:49:08');
INSERT INTO invoice_items VALUES('464','1','270','1','17000.00','0.00','2021-08-01 18:52:06','2021-08-01 18:52:06');
INSERT INTO invoice_items VALUES('578','1','271','1','10000.00','0.00','2021-08-04 18:37:59','2021-08-04 18:37:59');
INSERT INTO invoice_items VALUES('661','1','272','1','13000.00','6500.00','2021-08-12 19:49:29','2021-08-12 19:49:29');
INSERT INTO invoice_items VALUES('659','1','273','1','13000.00','6500.00','2021-08-12 19:48:37','2021-08-12 19:48:37');
INSERT INTO invoice_items VALUES('468','1','274','1','24000.00','0.00','2021-08-01 18:52:06','2021-08-01 18:52:06');
INSERT INTO invoice_items VALUES('1986','1','1343','1','10000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1983','1','1340','2','10000.00','0.00','2022-04-28 16:57:36','2022-04-28 16:57:36');
INSERT INTO invoice_items VALUES('687','1','277','1','17000.00','8500.00','2021-08-26 18:59:30','2021-08-26 18:59:30');
INSERT INTO invoice_items VALUES('571','1','278','1','13000.00','0.00','2021-08-03 19:05:29','2021-08-03 19:05:29');
INSERT INTO invoice_items VALUES('670','1','279','1','31000.00','0.00','2021-08-12 20:04:06','2021-08-12 20:04:06');
INSERT INTO invoice_items VALUES('474','1','280','1','18000.00','0.00','2021-08-01 18:52:06','2021-08-01 18:52:06');
INSERT INTO invoice_items VALUES('685','1','281','1','19000.00','9500.00','2021-08-24 19:45:30','2021-08-24 19:45:30');
INSERT INTO invoice_items VALUES('599','1','282','1','16000.00','0.00','2021-08-08 20:37:19','2021-08-08 20:37:19');
INSERT INTO invoice_items VALUES('690','1','283','1','16000.00','8000.00','2021-08-26 19:16:08','2021-08-26 19:16:08');
INSERT INTO invoice_items VALUES('665','1','284','1','16000.00','0.00','2021-08-12 19:55:21','2021-08-12 19:55:21');
INSERT INTO invoice_items VALUES('683','1','285','1','16000.00','8000.00','2021-08-17 16:33:14','2021-08-17 16:33:14');
INSERT INTO invoice_items VALUES('657','1','286','1','13000.00','6500.00','2021-08-12 19:45:27','2021-08-12 19:45:27');
INSERT INTO invoice_items VALUES('595','1','287','1','18000.00','0.00','2021-08-06 17:24:53','2021-08-06 17:24:53');
INSERT INTO invoice_items VALUES('669','1','288','1','19000.00','9500.00','2021-08-12 20:01:21','2021-08-12 20:01:21');
INSERT INTO invoice_items VALUES('667','1','289','1','19000.00','9500.00','2021-08-12 20:00:23','2021-08-12 20:00:23');
INSERT INTO invoice_items VALUES('655','1','290','1','13000.00','6500.00','2021-08-12 19:44:37','2021-08-12 19:44:37');
INSERT INTO invoice_items VALUES('653','1','291','1','13000.00','6500.00','2021-08-12 19:43:41','2021-08-12 19:43:41');
INSERT INTO invoice_items VALUES('651','1','292','1','13000.00','6500.00','2021-08-12 19:42:48','2021-08-12 19:42:48');
INSERT INTO invoice_items VALUES('677','1','293','5','5394.00','0.00','2021-08-15 16:17:37','2021-08-15 16:17:37');
INSERT INTO invoice_items VALUES('647','1','294','1','14500.00','0.00','2021-08-12 19:35:16','2021-08-12 19:35:16');
INSERT INTO invoice_items VALUES('645','1','295','1','14500.00','0.00','2021-08-12 19:34:28','2021-08-12 19:34:28');
INSERT INTO invoice_items VALUES('643','1','296','1','14500.00','0.00','2021-08-12 19:33:44','2021-08-12 19:33:44');
INSERT INTO invoice_items VALUES('641','1','297','1','14500.00','7500.00','2021-08-12 19:33:04','2021-08-12 19:33:04');
INSERT INTO invoice_items VALUES('642','1','297','5','5394.00','0.00','2021-08-12 19:33:04','2021-08-12 19:33:04');
INSERT INTO invoice_items VALUES('1711','1','1096','1','8000.00','0.00','2022-02-25 17:47:13','2022-02-25 17:47:13');
INSERT INTO invoice_items VALUES('494','1','300','1','12000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('495','1','301','1','15000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('640','1','302','1','15000.00','1500.00','2021-08-12 19:29:29','2021-08-12 19:29:29');
INSERT INTO invoice_items VALUES('644','1','296','5','5394.00','0.00','2021-08-12 19:33:44','2021-08-12 19:33:44');
INSERT INTO invoice_items VALUES('630','1','304','1','16000.00','1500.00','2021-08-12 19:18:24','2021-08-12 19:18:24');
INSERT INTO invoice_items VALUES('637','1','305','1','16000.00','0.00','2021-08-12 19:25:33','2021-08-12 19:25:33');
INSERT INTO invoice_items VALUES('635','1','306','1','16000.00','6000.00','2021-08-12 19:23:41','2021-08-12 19:23:41');
INSERT INTO invoice_items VALUES('633','1','307','1','16000.00','1500.00','2021-08-12 19:22:20','2021-08-12 19:22:20');
INSERT INTO invoice_items VALUES('620','1','308','1','16000.00','0.00','2021-08-12 18:48:19','2021-08-12 18:48:19');
INSERT INTO invoice_items VALUES('503','1','309','1','14000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('504','1','310','1','16500.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('591','1','311','1','16500.00','0.00','2021-08-05 18:04:31','2021-08-05 18:04:31');
INSERT INTO invoice_items VALUES('506','1','312','1','16500.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('629','1','313','1','16500.00','8000.00','2021-08-12 19:16:35','2021-08-12 19:16:35');
INSERT INTO invoice_items VALUES('628','1','314','1','15000.00','7500.00','2021-08-12 19:14:49','2021-08-12 19:14:49');
INSERT INTO invoice_items VALUES('597','1','315','1','16000.00','0.00','2021-08-06 19:33:35','2021-08-06 19:33:35');
INSERT INTO invoice_items VALUES('602','1','316','1','17000.00','0.00','2021-08-08 21:50:52','2021-08-08 21:50:52');
INSERT INTO invoice_items VALUES('626','1','317','1','17000.00','0.00','2021-08-12 19:10:50','2021-08-12 19:10:50');
INSERT INTO invoice_items VALUES('863','1','318','1','17000.00','8500.00','2021-09-13 17:45:28','2021-09-13 17:45:28');
INSERT INTO invoice_items VALUES('513','1','319','1','12000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('514','1','320','1','12000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('515','1','321','1','12000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('624','1','322','1','21000.00','0.00','2021-08-12 19:09:32','2021-08-12 19:09:32');
INSERT INTO invoice_items VALUES('688','1','323','1','21000.00','5250.00','2021-08-26 19:02:13','2021-08-26 19:02:13');
INSERT INTO invoice_items VALUES('579','1','324','1','16000.00','0.00','2021-08-04 21:09:46','2021-08-04 21:09:46');
INSERT INTO invoice_items VALUES('583','1','325','1','16500.00','0.00','2021-08-04 21:11:37','2021-08-04 21:11:37');
INSERT INTO invoice_items VALUES('581','1','326','1','16000.00','0.00','2021-08-04 21:11:01','2021-08-04 21:11:01');
INSERT INTO invoice_items VALUES('616','1','327','1','15000.00','0.00','2021-08-12 18:45:50','2021-08-12 18:45:50');
INSERT INTO invoice_items VALUES('622','1','328','1','16000.00','0.00','2021-08-12 18:49:24','2021-08-12 18:49:24');
INSERT INTO invoice_items VALUES('618','1','329','1','16000.00','0.00','2021-08-12 18:47:40','2021-08-12 18:47:40');
INSERT INTO invoice_items VALUES('614','1','330','1','16500.00','1000.00','2021-08-12 18:41:57','2021-08-12 18:41:57');
INSERT INTO invoice_items VALUES('572','1','331','1','16500.00','0.00','2021-08-03 20:03:23','2021-08-03 20:03:23');
INSERT INTO invoice_items VALUES('1091','1','509','5','1870.00','0.00','2021-10-07 17:05:17','2021-10-07 17:05:17');
INSERT INTO invoice_items VALUES('593','1','333','1','16000.00','0.00','2021-08-06 17:19:32','2021-08-06 17:19:32');
INSERT INTO invoice_items VALUES('912','1','489','1','17000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('529','1','335','1','13000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('679','1','336','1','13000.00','6500.00','2021-08-15 16:27:46','2021-08-15 16:27:46');
INSERT INTO invoice_items VALUES('682','1','337','1','16000.00','4000.00','2021-08-17 16:24:07','2021-08-17 16:24:07');
INSERT INTO invoice_items VALUES('532','1','338','1','16000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('533','1','339','1','16000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('606','1','340','1','18000.00','0.00','2021-08-12 18:30:24','2021-08-12 18:30:24');
INSERT INTO invoice_items VALUES('608','1','341','1','18000.00','0.00','2021-08-12 18:31:08','2021-08-12 18:31:08');
INSERT INTO invoice_items VALUES('612','1','342','1','18000.00','0.00','2021-08-12 18:32:40','2021-08-12 18:32:40');
INSERT INTO invoice_items VALUES('605','1','343','1','14500.00','7250.00','2021-08-12 18:28:48','2021-08-12 18:28:48');
INSERT INTO invoice_items VALUES('538','1','344','1','14500.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('539','1','345','1','16000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('540','1','346','1','13000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('541','1','347','1','16500.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('692','1','348','1','18000.00','9000.00','2021-08-28 16:52:48','2021-08-28 16:52:48');
INSERT INTO invoice_items VALUES('543','1','349','1','17000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('544','1','350','1','16000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('569','1','351','1','16000.00','8000.00','2021-08-03 19:02:29','2021-08-03 19:02:29');
INSERT INTO invoice_items VALUES('588','1','352','5','1160.00','0.00','2021-08-05 17:24:50','2021-08-05 17:24:50');
INSERT INTO invoice_items VALUES('589','1','353','1','16000.00','0.00','2021-08-05 17:25:33','2021-08-05 17:25:33');
INSERT INTO invoice_items VALUES('548','1','354','1','18000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('549','1','355','1','18000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('916','1','493','1','24000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('686','1','357','1','14000.00','7000.00','2021-08-24 20:13:36','2021-08-24 20:13:36');
INSERT INTO invoice_items VALUES('694','1','358','1','14000.00','7000.00','2021-08-30 18:30:10','2021-08-30 18:30:10');
INSERT INTO invoice_items VALUES('611','1','363','5','1760.00','0.00','2021-08-12 18:31:51','2021-08-12 18:31:51');
INSERT INTO invoice_items VALUES('678','1','360','1','14000.00','7000.00','2021-08-15 16:21:07','2021-08-15 16:21:07');
INSERT INTO invoice_items VALUES('604','1','361','1','13000.00','6500.00','2021-08-12 18:12:45','2021-08-12 18:12:45');
INSERT INTO invoice_items VALUES('556','1','362','1','13000.00','0.00','2021-08-01 18:52:07','2021-08-01 18:52:07');
INSERT INTO invoice_items VALUES('610','1','363','1','18000.00','0.00','2021-08-12 18:31:51','2021-08-12 18:31:51');
INSERT INTO invoice_items VALUES('663','1','364','1','17000.00','0.00','2021-08-12 19:53:17','2021-08-12 19:53:17');
INSERT INTO invoice_items VALUES('576','1','365','1','15000.00','0.00','2021-08-04 18:26:33','2021-08-04 18:26:33');
INSERT INTO invoice_items VALUES('1080','1','494','1','32000.00','0.00','2021-10-06 18:01:56','2021-10-06 18:01:56');
INSERT INTO invoice_items VALUES('607','1','340','5','1770.00','0.00','2021-08-12 18:30:24','2021-08-12 18:30:24');
INSERT INTO invoice_items VALUES('609','1','341','5','1760.00','0.00','2021-08-12 18:31:08','2021-08-12 18:31:08');
INSERT INTO invoice_items VALUES('918','1','495','1','18000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('568','1','370','2','13000.00','0.00','2021-08-01 20:13:53','2021-08-01 20:13:53');
INSERT INTO invoice_items VALUES('567','1','370','1','13000.00','0.00','2021-08-01 20:13:53','2021-08-01 20:13:53');
INSERT INTO invoice_items VALUES('570','1','351','5','1150.00','0.00','2021-08-03 19:02:29','2021-08-03 19:02:29');
INSERT INTO invoice_items VALUES('573','1','331','5','3260.00','0.00','2021-08-03 20:03:23','2021-08-03 20:03:23');
INSERT INTO invoice_items VALUES('575','1','269','5','500.00','0.00','2021-08-03 20:49:08','2021-08-03 20:49:08');
INSERT INTO invoice_items VALUES('577','1','365','5','500.00','0.00','2021-08-04 18:26:33','2021-08-04 18:26:33');
INSERT INTO invoice_items VALUES('580','1','324','5','1080.00','0.00','2021-08-04 21:09:46','2021-08-04 21:09:46');
INSERT INTO invoice_items VALUES('582','1','326','5','1080.00','0.00','2021-08-04 21:11:01','2021-08-04 21:11:01');
INSERT INTO invoice_items VALUES('584','1','325','5','1080.00','0.00','2021-08-04 21:11:37','2021-08-04 21:11:37');
INSERT INTO invoice_items VALUES('587','1','352','1','16000.00','0.00','2021-08-05 17:24:50','2021-08-05 17:24:50');
INSERT INTO invoice_items VALUES('590','1','353','5','1160.00','0.00','2021-08-05 17:25:33','2021-08-05 17:25:33');
INSERT INTO invoice_items VALUES('592','1','311','5','2380.00','0.00','2021-08-05 18:04:31','2021-08-05 18:04:31');
INSERT INTO invoice_items VALUES('594','1','333','5','3210.00','0.00','2021-08-06 17:19:32','2021-08-06 17:19:32');
INSERT INTO invoice_items VALUES('596','1','287','5','500.00','0.00','2021-08-06 17:24:53','2021-08-06 17:24:53');
INSERT INTO invoice_items VALUES('598','1','315','2','16000.00','0.00','2021-08-06 19:33:35','2021-08-06 19:33:35');
INSERT INTO invoice_items VALUES('600','1','282','2','6000.00','0.00','2021-08-08 20:37:19','2021-08-08 20:37:19');
INSERT INTO invoice_items VALUES('601','1','282','5','400.00','0.00','2021-08-08 20:37:19','2021-08-08 20:37:19');
INSERT INTO invoice_items VALUES('603','1','316','5','1840.00','0.00','2021-08-08 21:50:52','2021-08-08 21:50:52');
INSERT INTO invoice_items VALUES('613','1','342','5','1760.00','0.00','2021-08-12 18:32:40','2021-08-12 18:32:40');
INSERT INTO invoice_items VALUES('615','1','330','5','3210.00','0.00','2021-08-12 18:41:57','2021-08-12 18:41:57');
INSERT INTO invoice_items VALUES('617','1','327','5','1330.00','0.00','2021-08-12 18:45:50','2021-08-12 18:45:50');
INSERT INTO invoice_items VALUES('619','1','329','5','1330.00','0.00','2021-08-12 18:47:40','2021-08-12 18:47:40');
INSERT INTO invoice_items VALUES('621','1','308','5','1330.00','0.00','2021-08-12 18:48:19','2021-08-12 18:48:19');
INSERT INTO invoice_items VALUES('623','1','328','5','1330.00','0.00','2021-08-12 18:49:24','2021-08-12 18:49:24');
INSERT INTO invoice_items VALUES('625','1','322','5','3000.00','0.00','2021-08-12 19:09:32','2021-08-12 19:09:32');
INSERT INTO invoice_items VALUES('627','1','317','5','1840.00','0.00','2021-08-12 19:10:50','2021-08-12 19:10:50');
INSERT INTO invoice_items VALUES('631','1','304','5','560.00','0.00','2021-08-12 19:18:24','2021-08-12 19:18:24');
INSERT INTO invoice_items VALUES('634','1','307','5','560.00','0.00','2021-08-12 19:22:20','2021-08-12 19:22:20');
INSERT INTO invoice_items VALUES('636','1','306','5','560.00','0.00','2021-08-12 19:23:41','2021-08-12 19:23:41');
INSERT INTO invoice_items VALUES('638','1','305','5','560.00','0.00','2021-08-12 19:25:33','2021-08-12 19:25:33');
INSERT INTO invoice_items VALUES('646','1','295','5','5394.00','0.00','2021-08-12 19:34:28','2021-08-12 19:34:28');
INSERT INTO invoice_items VALUES('648','1','294','5','5394.00','0.00','2021-08-12 19:35:16','2021-08-12 19:35:16');
INSERT INTO invoice_items VALUES('676','1','293','1','13500.00','6750.00','2021-08-15 16:17:37','2021-08-15 16:17:37');
INSERT INTO invoice_items VALUES('652','1','292','5','1000.00','0.00','2021-08-12 19:42:48','2021-08-12 19:42:48');
INSERT INTO invoice_items VALUES('654','1','291','5','1000.00','0.00','2021-08-12 19:43:41','2021-08-12 19:43:41');
INSERT INTO invoice_items VALUES('656','1','290','5','1000.00','0.00','2021-08-12 19:44:37','2021-08-12 19:44:37');
INSERT INTO invoice_items VALUES('658','1','286','5','1000.00','0.00','2021-08-12 19:45:27','2021-08-12 19:45:27');
INSERT INTO invoice_items VALUES('660','1','273','5','1500.00','0.00','2021-08-12 19:48:37','2021-08-12 19:48:37');
INSERT INTO invoice_items VALUES('662','1','272','5','1500.00','0.00','2021-08-12 19:49:29','2021-08-12 19:49:29');
INSERT INTO invoice_items VALUES('664','1','364','2','5000.00','0.00','2021-08-12 19:53:17','2021-08-12 19:53:17');
INSERT INTO invoice_items VALUES('666','1','284','5','400.00','0.00','2021-08-12 19:55:21','2021-08-12 19:55:21');
INSERT INTO invoice_items VALUES('668','1','289','5','1000.00','0.00','2021-08-12 20:00:23','2021-08-12 20:00:23');
INSERT INTO invoice_items VALUES('671','1','279','5','1440.00','0.00','2021-08-12 20:04:06','2021-08-12 20:04:06');
INSERT INTO invoice_items VALUES('672','1','371','1','13000.00','0.00','2021-08-12 20:33:16','2021-08-12 20:33:16');
INSERT INTO invoice_items VALUES('673','1','372','1','16500.00','0.00','2021-08-12 20:34:18','2021-08-12 20:34:18');
INSERT INTO invoice_items VALUES('1982','1','1339','2','10000.00','0.00','2022-04-28 16:55:53','2022-04-28 16:55:53');
INSERT INTO invoice_items VALUES('684','1','285','5','400.00','0.00','2021-08-17 16:33:14','2021-08-17 16:33:14');
INSERT INTO invoice_items VALUES('689','1','323','5','3000.00','0.00','2021-08-26 19:02:13','2021-08-26 19:02:13');
INSERT INTO invoice_items VALUES('691','1','283','5','400.00','0.00','2021-08-26 19:16:08','2021-08-26 19:16:08');
INSERT INTO invoice_items VALUES('695','1','373','1','18000.00','0.00','2021-08-31 20:05:17','2021-08-31 20:05:17');
INSERT INTO invoice_items VALUES('919','1','496','1','20000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('697','1','375','1','17000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('698','1','376','1','10000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('893','1','377','1','14000.00','0.00','2021-09-23 16:36:00','2021-09-23 16:36:00');
INSERT INTO invoice_items VALUES('1098','1','378','1','14000.00','7000.00','2021-10-07 19:59:08','2021-10-07 19:59:08');
INSERT INTO invoice_items VALUES('701','1','379','1','24000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('702','1','380','1','21000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('865','1','381','1','18000.00','0.00','2021-09-13 19:45:37','2021-09-13 19:45:37');
INSERT INTO invoice_items VALUES('1059','1','497','1','17000.00','0.00','2021-10-05 21:11:35','2021-10-05 21:11:35');
INSERT INTO invoice_items VALUES('856','1','383','1','31000.00','15500.00','2021-09-12 21:15:54','2021-09-12 21:15:54');
INSERT INTO invoice_items VALUES('706','1','384','1','18000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('1138','1','385','1','15000.00','0.00','2021-10-25 16:48:34','2021-10-25 16:48:34');
INSERT INTO invoice_items VALUES('815','1','386','1','17000.00','0.00','2021-09-09 20:37:26','2021-09-09 20:37:26');
INSERT INTO invoice_items VALUES('852','1','387','1','17000.00','8500.00','2021-09-12 21:08:08','2021-09-12 21:08:08');
INSERT INTO invoice_items VALUES('817','1','388','1','17000.00','0.00','2021-09-09 20:38:44','2021-09-09 20:38:44');
INSERT INTO invoice_items VALUES('851','1','389','1','17000.00','8900.00','2021-09-12 21:05:06','2021-09-12 21:05:06');
INSERT INTO invoice_items VALUES('895','1','390','1','14000.00','7000.00','2021-09-23 16:38:33','2021-09-23 16:38:33');
INSERT INTO invoice_items VALUES('806','1','391','1','19000.00','0.00','2021-09-08 20:17:54','2021-09-08 20:17:54');
INSERT INTO invoice_items VALUES('855','1','392','1','20000.00','0.00','2021-09-12 21:13:12','2021-09-12 21:13:12');
INSERT INTO invoice_items VALUES('853','1','393','1','20000.00','0.00','2021-09-12 21:11:38','2021-09-12 21:11:38');
INSERT INTO invoice_items VALUES('892','1','394','1','14000.00','0.00','2021-09-23 16:34:39','2021-09-23 16:34:39');
INSERT INTO invoice_items VALUES('891','1','395','1','13000.00','6000.00','2021-09-23 16:32:36','2021-09-23 16:32:36');
INSERT INTO invoice_items VALUES('894','1','396','1','14000.00','0.00','2021-09-23 16:37:20','2021-09-23 16:37:20');
INSERT INTO invoice_items VALUES('813','1','397','1','13500.00','0.00','2021-09-09 20:31:42','2021-09-09 20:31:42');
INSERT INTO invoice_items VALUES('879','1','398','1','14500.00','0.00','2021-09-20 20:20:57','2021-09-20 20:20:57');
INSERT INTO invoice_items VALUES('811','1','399','1','14500.00','0.00','2021-09-09 20:28:09','2021-09-09 20:28:09');
INSERT INTO invoice_items VALUES('877','1','400','1','14500.00','0.00','2021-09-20 20:18:16','2021-09-20 20:18:16');
INSERT INTO invoice_items VALUES('850','1','401','1','15500.00','7750.00','2021-09-12 21:00:23','2021-09-12 21:00:23');
INSERT INTO invoice_items VALUES('858','1','406','5','3565.00','0.00','2021-09-13 16:43:57','2021-09-13 16:43:57');
INSERT INTO invoice_items VALUES('803','1','403','1','16000.00','0.00','2021-09-07 21:16:19','2021-09-07 21:16:19');
INSERT INTO invoice_items VALUES('800','1','404','1','16000.00','0.00','2021-09-07 20:49:33','2021-09-07 20:49:33');
INSERT INTO invoice_items VALUES('801','1','405','1','17000.00','0.00','2021-09-07 20:58:37','2021-09-07 20:58:37');
INSERT INTO invoice_items VALUES('857','1','406','1','17000.00','0.00','2021-09-13 16:43:57','2021-09-13 16:43:57');
INSERT INTO invoice_items VALUES('848','1','407','1','16000.00','0.00','2021-09-12 20:55:32','2021-09-12 20:55:32');
INSERT INTO invoice_items VALUES('921','1','498','1','17000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('843','1','409','1','16000.00','0.00','2021-09-12 20:40:38','2021-09-12 20:40:38');
INSERT INTO invoice_items VALUES('732','1','410','1','14000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('804','1','411','1','17500.00','0.00','2021-09-08 18:23:59','2021-09-08 18:23:59');
INSERT INTO invoice_items VALUES('796','1','412','1','17500.00','0.00','2021-09-06 20:16:22','2021-09-06 20:16:22');
INSERT INTO invoice_items VALUES('846','1','413','1','17500.00','0.00','2021-09-12 20:52:07','2021-09-12 20:52:07');
INSERT INTO invoice_items VALUES('845','1','414','1','17500.00','8750.00','2021-09-12 20:50:50','2021-09-12 20:50:50');
INSERT INTO invoice_items VALUES('790','1','415','1','17000.00','0.00','2021-09-04 19:54:12','2021-09-04 19:54:12');
INSERT INTO invoice_items VALUES('821','1','416','1','17000.00','0.00','2021-09-09 21:08:53','2021-09-09 21:08:53');
INSERT INTO invoice_items VALUES('829','1','417','1','17000.00','0.00','2021-09-11 19:55:17','2021-09-11 19:55:17');
INSERT INTO invoice_items VALUES('827','1','418','1','17000.00','0.00','2021-09-11 19:53:48','2021-09-11 19:53:48');
INSERT INTO invoice_items VALUES('741','1','419','1','12000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('742','1','420','1','12000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('743','1','421','1','12000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('923','1','500','1','17000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('1071','1','499','2','10000.00','0.00','2021-10-05 21:28:18','2021-10-05 21:28:18');
INSERT INTO invoice_items VALUES('746','1','424','1','16000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('924','1','501','1','14000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('890','1','426','1','16000.00','8000.00','2021-09-23 16:24:31','2021-09-23 16:24:31');
INSERT INTO invoice_items VALUES('888','1','427','1','16000.00','0.00','2021-09-20 20:30:41','2021-09-20 20:30:41');
INSERT INTO invoice_items VALUES('791','1','428','1','16000.00','0.00','2021-09-04 20:01:52','2021-09-04 20:01:52');
INSERT INTO invoice_items VALUES('1974','1','1284','6','10000.00','0.00','2022-04-16 06:32:59','2022-04-16 06:32:59');
INSERT INTO invoice_items VALUES('834','1','430','1','17000.00','0.00','2021-09-12 18:52:00','2021-09-12 18:52:00');
INSERT INTO invoice_items VALUES('793','1','431','1','17500.00','0.00','2021-09-06 19:46:52','2021-09-06 19:46:52');
INSERT INTO invoice_items VALUES('925','1','502','1','19000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('841','1','433','1','17000.00','0.00','2021-09-12 20:39:26','2021-09-12 20:39:26');
INSERT INTO invoice_items VALUES('874','1','476','2','15000.00','0.00','2021-09-20 20:10:04','2021-09-20 20:10:04');
INSERT INTO invoice_items VALUES('840','1','435','1','140000.00','0.00','2021-09-12 20:34:41','2021-09-12 20:34:41');
INSERT INTO invoice_items VALUES('758','1','436','1','16000.00','0.00','2021-09-02 20:14:38','2021-09-02 20:14:38');
INSERT INTO invoice_items VALUES('759','1','437','1','16000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('760','1','438','1','16000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('826','1','439','1','17000.00','0.00','2021-09-11 19:43:24','2021-09-11 19:43:24');
INSERT INTO invoice_items VALUES('825','1','440','1','17000.00','0.00','2021-09-11 19:42:44','2021-09-11 19:42:44');
INSERT INTO invoice_items VALUES('824','1','441','1','17000.00','0.00','2021-09-11 19:41:57','2021-09-11 19:41:57');
INSERT INTO invoice_items VALUES('1119','1','442','1','7750.00','0.00','2021-10-11 17:35:26','2021-10-11 17:35:26');
INSERT INTO invoice_items VALUES('1836','1','1099','1','16000.00','0.00','2022-03-08 16:14:08','2022-03-08 16:14:08');
INSERT INTO invoice_items VALUES('926','1','503','1','20000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('767','1','445','1','13000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('768','1','446','1','16500.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('910','1','447','1','18000.00','3000.00','2021-09-30 19:59:58','2021-09-30 19:59:58');
INSERT INTO invoice_items VALUES('889','1','448','1','18000.00','9000.00','2021-09-23 16:20:45','2021-09-23 16:20:45');
INSERT INTO invoice_items VALUES('833','1','449','1','17000.00','0.00','2021-09-12 18:50:21','2021-09-12 18:50:21');
INSERT INTO invoice_items VALUES('868','1','450','1','17000.00','8500.00','2021-09-20 19:42:19','2021-09-20 19:42:19');
INSERT INTO invoice_items VALUES('897','1','451','1','17000.00','6230.00','2021-09-29 20:06:03','2021-09-29 20:06:03');
INSERT INTO invoice_items VALUES('809','1','452','1','17000.00','0.00','2021-09-09 16:44:17','2021-09-09 16:44:17');
INSERT INTO invoice_items VALUES('775','1','453','1','18000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('776','1','454','1','18000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('927','1','504','1','20000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('778','1','456','1','14000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('1133','1','457','1','6000.00','0.00','2021-10-14 22:48:27','2021-10-14 22:48:27');
INSERT INTO invoice_items VALUES('838','1','458','1','15000.00','7500.00','2021-09-12 20:06:26','2021-09-12 20:06:26');
INSERT INTO invoice_items VALUES('781','1','459','1','13000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('782','1','460','1','13000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('822','1','461','1','17000.00','0.00','2021-09-11 19:39:04','2021-09-11 19:39:04');
INSERT INTO invoice_items VALUES('784','1','462','1','17000.00','0.00','2021-09-02 20:14:39','2021-09-02 20:14:39');
INSERT INTO invoice_items VALUES('795','1','463','1','15500.00','0.00','2021-09-06 20:07:56','2021-09-06 20:07:56');
INSERT INTO invoice_items VALUES('798','1','464','1','17000.00','0.00','2021-09-07 19:47:36','2021-09-07 19:47:36');
INSERT INTO invoice_items VALUES('881','1','465','1','17000.00','0.00','2021-09-20 20:23:14','2021-09-20 20:23:14');
INSERT INTO invoice_items VALUES('832','1','466','2','10000.00','0.00','2021-09-12 16:48:04','2021-09-12 16:48:04');
INSERT INTO invoice_items VALUES('831','1','466','1','17500.00','0.00','2021-09-12 16:48:04','2021-09-12 16:48:04');
INSERT INTO invoice_items VALUES('792','1','428','5','740.00','0.00','2021-09-04 20:01:52','2021-09-04 20:01:52');
INSERT INTO invoice_items VALUES('794','1','431','5','2800.00','0.00','2021-09-06 19:46:52','2021-09-06 19:46:52');
INSERT INTO invoice_items VALUES('797','1','412','5','7300.00','0.00','2021-09-06 20:16:22','2021-09-06 20:16:22');
INSERT INTO invoice_items VALUES('799','1','464','2','17000.00','0.00','2021-09-07 19:47:36','2021-09-07 19:47:36');
INSERT INTO invoice_items VALUES('802','1','405','5','3565.00','0.00','2021-09-07 20:58:37','2021-09-07 20:58:37');
INSERT INTO invoice_items VALUES('805','1','411','5','7300.00','0.00','2021-09-08 18:23:59','2021-09-08 18:23:59');
INSERT INTO invoice_items VALUES('807','1','467','1','17000.00','0.00','2021-09-08 20:50:47','2021-09-08 20:50:47');
INSERT INTO invoice_items VALUES('808','1','467','2','17000.00','0.00','2021-09-08 20:50:47','2021-09-08 20:50:47');
INSERT INTO invoice_items VALUES('810','1','452','5','2260.00','0.00','2021-09-09 16:44:17','2021-09-09 16:44:17');
INSERT INTO invoice_items VALUES('812','1','399','5','1875.00','0.00','2021-09-09 20:28:09','2021-09-09 20:28:09');
INSERT INTO invoice_items VALUES('814','1','397','5','1875.00','0.00','2021-09-09 20:31:42','2021-09-09 20:31:42');
INSERT INTO invoice_items VALUES('816','1','386','5','8840.00','0.00','2021-09-09 20:37:26','2021-09-09 20:37:26');
INSERT INTO invoice_items VALUES('818','1','388','5','8840.00','0.00','2021-09-09 20:38:44','2021-09-09 20:38:44');
INSERT INTO invoice_items VALUES('819','1','468','1','17000.00','0.00','2021-09-09 21:00:11','2021-09-09 21:00:11');
INSERT INTO invoice_items VALUES('820','1','469','1','17000.00','0.00','2021-09-09 21:01:14','2021-09-09 21:01:14');
INSERT INTO invoice_items VALUES('823','1','461','5','3480.00','0.00','2021-09-11 19:39:04','2021-09-11 19:39:04');
INSERT INTO invoice_items VALUES('828','1','418','5','270.00','0.00','2021-09-11 19:53:48','2021-09-11 19:53:48');
INSERT INTO invoice_items VALUES('830','1','417','5','270.00','0.00','2021-09-11 19:55:17','2021-09-11 19:55:17');
INSERT INTO invoice_items VALUES('835','1','430','5','4200.00','0.00','2021-09-12 18:52:00','2021-09-12 18:52:00');
INSERT INTO invoice_items VALUES('836','1','470','2','15000.00','0.00','2021-09-12 20:04:21','2021-09-12 20:04:21');
INSERT INTO invoice_items VALUES('837','1','470','1','15000.00','0.00','2021-09-12 20:04:21','2021-09-12 20:04:21');
INSERT INTO invoice_items VALUES('842','1','433','5','4200.00','0.00','2021-09-12 20:39:26','2021-09-12 20:39:26');
INSERT INTO invoice_items VALUES('844','1','409','5','740.00','0.00','2021-09-12 20:40:38','2021-09-12 20:40:38');
INSERT INTO invoice_items VALUES('847','1','413','5','7300.00','0.00','2021-09-12 20:52:07','2021-09-12 20:52:07');
INSERT INTO invoice_items VALUES('849','1','407','5','3560.00','0.00','2021-09-12 20:55:32','2021-09-12 20:55:32');
INSERT INTO invoice_items VALUES('861','1','471','2','12000.00','0.00','2021-09-13 17:17:48','2021-09-13 17:17:48');
INSERT INTO invoice_items VALUES('862','1','472','1','17000.00','0.00','2021-09-13 17:18:11','2021-09-13 17:18:11');
INSERT INTO invoice_items VALUES('1835','1','1100','1','16000.00','0.00','2022-03-08 16:13:32','2022-03-08 16:13:32');
INSERT INTO invoice_items VALUES('887','1','427','5','740.00','0.00','2021-09-20 20:30:41','2021-09-20 20:30:41');
INSERT INTO invoice_items VALUES('869','1','450','5','2260.00','0.00','2021-09-20 19:42:19','2021-09-20 19:42:19');
INSERT INTO invoice_items VALUES('870','1','474','1','6000.00','0.00','2021-09-20 19:58:24','2021-09-20 19:58:24');
INSERT INTO invoice_items VALUES('871','1','474','2','15000.00','0.00','2021-09-20 19:58:24','2021-09-20 19:58:24');
INSERT INTO invoice_items VALUES('872','1','475','1','6240.00','0.00','2021-09-20 20:04:27','2021-09-20 20:04:27');
INSERT INTO invoice_items VALUES('873','1','475','2','10000.00','0.00','2021-09-20 20:04:27','2021-09-20 20:04:27');
INSERT INTO invoice_items VALUES('875','1','477','1','17000.00','0.00','2021-09-20 20:15:10','2021-09-20 20:15:10');
INSERT INTO invoice_items VALUES('876','1','477','2','12000.00','0.00','2021-09-20 20:15:10','2021-09-20 20:15:10');
INSERT INTO invoice_items VALUES('878','1','400','5','1875.00','0.00','2021-09-20 20:18:16','2021-09-20 20:18:16');
INSERT INTO invoice_items VALUES('880','1','398','5','1875.00','0.00','2021-09-20 20:20:57','2021-09-20 20:20:57');
INSERT INTO invoice_items VALUES('882','1','465','2','17000.00','0.00','2021-09-20 20:23:14','2021-09-20 20:23:14');
INSERT INTO invoice_items VALUES('883','1','478','1','6500.00','0.00','2021-09-20 20:27:53','2021-09-20 20:27:53');
INSERT INTO invoice_items VALUES('884','1','478','2','17000.00','0.00','2021-09-20 20:27:53','2021-09-20 20:27:53');
INSERT INTO invoice_items VALUES('899','1','479','2','5000.00','0.00','2021-09-29 20:18:30','2021-09-29 20:18:30');
INSERT INTO invoice_items VALUES('900','1','480','2','2500.00','0.00','2021-09-29 20:21:49','2021-09-29 20:21:49');
INSERT INTO invoice_items VALUES('901','1','481','2','2500.00','0.00','2021-09-29 20:23:05','2021-09-29 20:23:05');
INSERT INTO invoice_items VALUES('902','1','482','1','5000.00','0.00','2021-09-29 20:33:55','2021-09-29 20:33:55');
INSERT INTO invoice_items VALUES('903','1','482','2','10000.00','0.00','2021-09-29 20:33:55','2021-09-29 20:33:55');
INSERT INTO invoice_items VALUES('904','1','483','2','5000.00','0.00','2021-09-29 20:40:17','2021-09-29 20:40:17');
INSERT INTO invoice_items VALUES('905','1','484','2','19000.00','0.00','2021-09-29 20:53:32','2021-09-29 20:53:32');
INSERT INTO invoice_items VALUES('906','1','485','2','10000.00','0.00','2021-09-29 20:54:33','2021-09-29 20:54:33');
INSERT INTO invoice_items VALUES('907','1','486','2','21000.00','0.00','2021-09-29 21:13:16','2021-09-29 21:13:16');
INSERT INTO invoice_items VALUES('908','1','487','2','21000.00','0.00','2021-09-29 21:13:58','2021-09-29 21:13:58');
INSERT INTO invoice_items VALUES('911','1','488','5','3325.00','0.00','2021-09-30 20:51:07','2021-09-30 20:51:07');
INSERT INTO invoice_items VALUES('928','1','505','1','14000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('929','1','506','1','14000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('930','1','507','1','14000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('1124','1','508','1','15500.00','0.00','2021-10-12 20:59:19','2021-10-12 20:59:19');
INSERT INTO invoice_items VALUES('1090','1','509','1','15500.00','0.00','2021-10-07 17:05:17','2021-10-07 17:05:17');
INSERT INTO invoice_items VALUES('1114','1','510','1','15500.00','0.00','2021-10-11 16:36:14','2021-10-11 16:36:14');
INSERT INTO invoice_items VALUES('934','1','511','1','15500.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('935','1','512','1','16000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('1065','1','513','1','16000.00','0.00','2021-10-05 21:23:09','2021-10-05 21:23:09');
INSERT INTO invoice_items VALUES('937','1','514','1','17000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('938','1','515','1','17000.00','0.00','2021-10-03 21:02:36','2021-10-03 21:02:36');
INSERT INTO invoice_items VALUES('1062','1','516','1','16000.00','0.00','2021-10-05 21:18:52','2021-10-05 21:18:52');
INSERT INTO invoice_items VALUES('1072','1','517','1','16000.00','0.00','2021-10-06 17:24:36','2021-10-06 17:24:36');
INSERT INTO invoice_items VALUES('1136','1','518','1','13000.00','0.00','2021-10-22 17:52:39','2021-10-22 17:52:39');
INSERT INTO invoice_items VALUES('1056','1','519','1','17500.00','0.00','2021-10-05 20:58:48','2021-10-05 20:58:48');
INSERT INTO invoice_items VALUES('1052','1','520','1','17500.00','0.00','2021-10-05 20:56:34','2021-10-05 20:56:34');
INSERT INTO invoice_items VALUES('1054','1','521','1','17500.00','0.00','2021-10-05 20:58:04','2021-10-05 20:58:04');
INSERT INTO invoice_items VALUES('1051','1','522','1','17500.00','0.00','2021-10-05 20:55:40','2021-10-05 20:55:40');
INSERT INTO invoice_items VALUES('946','1','523','1','17000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('1041','1','524','1','17000.00','0.00','2021-10-05 18:36:05','2021-10-05 18:36:05');
INSERT INTO invoice_items VALUES('1082','1','525','1','17000.00','0.00','2021-10-06 19:57:33','2021-10-06 19:57:33');
INSERT INTO invoice_items VALUES('1134','1','526','1','17000.00','0.00','2021-10-20 20:18:00','2021-10-20 20:18:00');
INSERT INTO invoice_items VALUES('950','1','527','1','15000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('951','1','528','1','12000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('952','1','529','1','12000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('953','1','530','1','12000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('1122','1','531','1','8000.00','0.00','2021-10-12 20:52:53','2021-10-12 20:52:53');
INSERT INTO invoice_items VALUES('1016','1','532','1','16000.00','0.00','2021-10-04 17:58:39','2021-10-04 17:58:39');
INSERT INTO invoice_items VALUES('1563','1','977','1','17000.00','0.00','2022-02-01 20:15:02','2022-02-01 20:15:02');
INSERT INTO invoice_items VALUES('1127','1','534','1','17000.00','0.00','2021-10-13 16:29:15','2021-10-13 16:29:15');
INSERT INTO invoice_items VALUES('1088','1','535','1','17500.00','0.00','2021-10-07 15:55:13','2021-10-07 15:55:13');
INSERT INTO invoice_items VALUES('1034','1','536','1','17000.00','0.00','2021-10-05 18:30:02','2021-10-05 18:30:02');
INSERT INTO invoice_items VALUES('1058','1','537','1','14000.00','0.00','2021-10-05 21:02:54','2021-10-05 21:02:54');
INSERT INTO invoice_items VALUES('961','1','538','1','15500.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('962','1','539','1','15500.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('1047','1','540','1','17000.00','0.00','2021-10-05 19:51:16','2021-10-05 19:51:16');
INSERT INTO invoice_items VALUES('1078','1','541','1','14000.00','0.00','2021-10-06 17:54:36','2021-10-06 17:54:36');
INSERT INTO invoice_items VALUES('1076','1','542','1','14000.00','0.00','2021-10-06 17:45:46','2021-10-06 17:45:46');
INSERT INTO invoice_items VALUES('1075','1','543','1','14000.00','0.00','2021-10-06 17:44:35','2021-10-06 17:44:35');
INSERT INTO invoice_items VALUES('1118','1','544','1','15500.00','0.00','2021-10-11 17:34:37','2021-10-11 17:34:37');
INSERT INTO invoice_items VALUES('968','1','545','1','14000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('969','1','546','1','16500.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('970','1','547','1','18000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('971','1','548','1','18000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('972','1','549','1','17000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('973','1','550','1','17000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('974','1','551','1','17000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('1120','1','552','1','17000.00','0.00','2021-10-11 17:39:08','2021-10-11 17:39:08');
INSERT INTO invoice_items VALUES('1106','1','600','1','13000.00','0.00','2021-10-09 21:40:27','2021-10-09 21:40:27');
INSERT INTO invoice_items VALUES('977','1','554','1','18000.00','0.00','2021-10-03 21:02:37','2021-10-03 21:02:37');
INSERT INTO invoice_items VALUES('978','1','555','1','15000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('979','1','556','1','15000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('980','1','557','1','15000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('981','1','558','1','14000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('982','1','559','1','14000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1074','1','560','1','14000.00','0.00','2021-10-06 17:42:17','2021-10-06 17:42:17');
INSERT INTO invoice_items VALUES('1108','1','587','2','5000.00','0.00','2021-10-09 21:45:57','2021-10-09 21:45:57');
INSERT INTO invoice_items VALUES('985','1','562','1','15500.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('986','1','563','1','17000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1109','1','564','1','18000.00','0.00','2021-10-10 19:02:43','2021-10-10 19:02:43');
INSERT INTO invoice_items VALUES('1050','1','589','2','15000.00','0.00','2021-10-05 20:44:34','2021-10-05 20:44:34');
INSERT INTO invoice_items VALUES('1048','1','565','1','17500.00','0.00','2021-10-05 20:33:50','2021-10-05 20:33:50');
INSERT INTO invoice_items VALUES('990','1','566','1','17000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1718','1','1103','1','32000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1720','1','1105','1','20000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('993','1','569','1','15000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1045','1','570','1','22000.00','0.00','2021-10-05 19:21:46','2021-10-05 19:21:46');
INSERT INTO invoice_items VALUES('995','1','571','1','15000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1043','1','572','1','21000.00','0.00','2021-10-05 18:42:32','2021-10-05 18:42:32');
INSERT INTO invoice_items VALUES('997','1','573','1','17000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('998','1','574','1','17000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('999','1','575','1','15000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1000','1','576','1','17000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1018','1','577','1','15000.00','0.00','2021-10-05 16:50:16','2021-10-05 16:50:16');
INSERT INTO invoice_items VALUES('1032','1','578','1','21000.00','0.00','2021-10-05 18:27:18','2021-10-05 18:27:18');
INSERT INTO invoice_items VALUES('1037','1','579','1','17000.00','0.00','2021-10-05 18:33:52','2021-10-05 18:33:52');
INSERT INTO invoice_items VALUES('1004','1','580','1','19000.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1005','1','581','1','17500.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1006','1','582','1','17500.00','0.00','2021-10-03 21:02:38','2021-10-03 21:02:38');
INSERT INTO invoice_items VALUES('1092','1','583','1','17500.00','0.00','2021-10-07 18:29:53','2021-10-07 18:29:53');
INSERT INTO invoice_items VALUES('1141','1','584','1','13000.00','0.00','2021-11-01 17:49:00','2021-11-01 17:49:00');
INSERT INTO invoice_items VALUES('1096','1','585','1','17500.00','0.00','2021-10-07 18:44:48','2021-10-07 18:44:48');
INSERT INTO invoice_items VALUES('1094','1','586','1','17500.00','0.00','2021-10-07 18:44:04','2021-10-07 18:44:04');
INSERT INTO invoice_items VALUES('1107','1','587','1','15500.00','0.00','2021-10-09 21:45:57','2021-10-09 21:45:57');
INSERT INTO invoice_items VALUES('1012','1','588','1','17000.00','0.00','2021-10-03 21:02:39','2021-10-03 21:02:39');
INSERT INTO invoice_items VALUES('1049','1','589','1','18000.00','0.00','2021-10-05 20:44:34','2021-10-05 20:44:34');
INSERT INTO invoice_items VALUES('1022','1','590','1','17000.00','0.00','2021-10-05 17:48:05','2021-10-05 17:48:05');
INSERT INTO invoice_items VALUES('1024','1','591','1','17000.00','0.00','2021-10-05 18:05:09','2021-10-05 18:05:09');
INSERT INTO invoice_items VALUES('1017','1','532','5','500.00','0.00','2021-10-04 17:58:39','2021-10-04 17:58:39');
INSERT INTO invoice_items VALUES('1019','1','577','2','2000.00','0.00','2021-10-05 16:50:16','2021-10-05 16:50:16');
INSERT INTO invoice_items VALUES('1020','1','592','1','14000.00','0.00','2021-10-05 17:37:35','2021-10-05 17:37:35');
INSERT INTO invoice_items VALUES('1021','1','592','2','14000.00','0.00','2021-10-05 17:37:35','2021-10-05 17:37:35');
INSERT INTO invoice_items VALUES('1023','1','590','2','13000.00','0.00','2021-10-05 17:48:05','2021-10-05 17:48:05');
INSERT INTO invoice_items VALUES('1025','1','591','2','17000.00','0.00','2021-10-05 18:05:09','2021-10-05 18:05:09');
INSERT INTO invoice_items VALUES('1031','1','593','6','5000.00','0.00','2021-10-05 18:26:28','2021-10-05 18:26:28');
INSERT INTO invoice_items VALUES('1030','1','593','1','21000.00','0.00','2021-10-05 18:26:28','2021-10-05 18:26:28');
INSERT INTO invoice_items VALUES('1033','1','578','6','5000.00','0.00','2021-10-05 18:27:18','2021-10-05 18:27:18');
INSERT INTO invoice_items VALUES('1035','1','536','2','10000.00','0.00','2021-10-05 18:30:02','2021-10-05 18:30:02');
INSERT INTO invoice_items VALUES('1036','1','536','5','2825.00','0.00','2021-10-05 18:30:02','2021-10-05 18:30:02');
INSERT INTO invoice_items VALUES('1038','1','579','2','17000.00','0.00','2021-10-05 18:33:52','2021-10-05 18:33:52');
INSERT INTO invoice_items VALUES('1717','1','1102','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1042','1','524','2','2000.00','0.00','2021-10-05 18:36:05','2021-10-05 18:36:05');
INSERT INTO invoice_items VALUES('1044','1','572','5','3700.00','0.00','2021-10-05 18:42:32','2021-10-05 18:42:32');
INSERT INTO invoice_items VALUES('1046','1','570','5','2135.00','0.00','2021-10-05 19:21:46','2021-10-05 19:21:46');
INSERT INTO invoice_items VALUES('1053','1','520','5','5090.00','0.00','2021-10-05 20:56:34','2021-10-05 20:56:34');
INSERT INTO invoice_items VALUES('1055','1','521','5','5090.00','0.00','2021-10-05 20:58:04','2021-10-05 20:58:04');
INSERT INTO invoice_items VALUES('1057','1','519','5','5090.00','0.00','2021-10-05 20:58:48','2021-10-05 20:58:48');
INSERT INTO invoice_items VALUES('1060','1','497','5','1140.00','0.00','2021-10-05 21:11:35','2021-10-05 21:11:35');
INSERT INTO invoice_items VALUES('1061','1','497','2','4000.00','0.00','2021-10-05 21:11:35','2021-10-05 21:11:35');
INSERT INTO invoice_items VALUES('1063','1','516','5','520.00','0.00','2021-10-05 21:18:52','2021-10-05 21:18:52');
INSERT INTO invoice_items VALUES('1070','1','499','5','1160.00','0.00','2021-10-05 21:28:18','2021-10-05 21:28:18');
INSERT INTO invoice_items VALUES('1069','1','499','1','17000.00','0.00','2021-10-05 21:28:18','2021-10-05 21:28:18');
INSERT INTO invoice_items VALUES('1073','1','517','5','470.00','0.00','2021-10-06 17:24:36','2021-10-06 17:24:36');
INSERT INTO invoice_items VALUES('1079','1','541','5','3000.00','0.00','2021-10-06 17:54:36','2021-10-06 17:54:36');
INSERT INTO invoice_items VALUES('1081','1','494','5','650.00','0.00','2021-10-06 18:01:56','2021-10-06 18:01:56');
INSERT INTO invoice_items VALUES('1083','1','525','5','1120.00','0.00','2021-10-06 19:57:33','2021-10-06 19:57:33');
INSERT INTO invoice_items VALUES('1084','1','594','1','17000.00','0.00','2021-10-06 20:05:52','2021-10-06 20:05:52');
INSERT INTO invoice_items VALUES('1085','1','594','2','10000.00','0.00','2021-10-06 20:05:52','2021-10-06 20:05:52');
INSERT INTO invoice_items VALUES('1719','1','1104','1','18000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1089','1','535','5','2830.00','0.00','2021-10-07 15:55:13','2021-10-07 15:55:13');
INSERT INTO invoice_items VALUES('1093','1','583','2','12000.00','0.00','2021-10-07 18:29:53','2021-10-07 18:29:53');
INSERT INTO invoice_items VALUES('1095','1','586','2','12000.00','0.00','2021-10-07 18:44:04','2021-10-07 18:44:04');
INSERT INTO invoice_items VALUES('1097','1','585','2','12000.00','0.00','2021-10-07 18:44:48','2021-10-07 18:44:48');
INSERT INTO invoice_items VALUES('1099','1','595','1','17000.00','0.00','2021-10-09 19:16:05','2021-10-09 19:16:05');
INSERT INTO invoice_items VALUES('1100','1','595','2','17000.00','0.00','2021-10-09 19:16:05','2021-10-09 19:16:05');
INSERT INTO invoice_items VALUES('1103','1','598','1','14000.00','0.00','2021-10-09 19:35:10','2021-10-09 19:35:10');
INSERT INTO invoice_items VALUES('1102','1','597','1','14000.00','0.00','2021-10-09 19:29:11','2021-10-09 19:29:11');
INSERT INTO invoice_items VALUES('1104','1','599','1','18000.00','0.00','2021-10-09 20:08:09','2021-10-09 20:08:09');
INSERT INTO invoice_items VALUES('1105','1','599','2','18000.00','0.00','2021-10-09 20:08:09','2021-10-09 20:08:09');
INSERT INTO invoice_items VALUES('1110','1','601','1','22000.00','0.00','2021-10-10 21:29:29','2021-10-10 21:29:29');
INSERT INTO invoice_items VALUES('1111','1','601','2','22000.00','0.00','2021-10-10 21:29:29','2021-10-10 21:29:29');
INSERT INTO invoice_items VALUES('1112','1','602','1','22000.00','0.00','2021-10-10 21:30:08','2021-10-10 21:30:08');
INSERT INTO invoice_items VALUES('1113','1','602','2','22000.00','0.00','2021-10-10 21:30:08','2021-10-10 21:30:08');
INSERT INTO invoice_items VALUES('1115','1','510','5','1870.00','0.00','2021-10-11 16:36:14','2021-10-11 16:36:14');
INSERT INTO invoice_items VALUES('1116','1','603','1','16000.00','2500.00','2021-10-11 17:10:36','2021-10-11 17:10:36');
INSERT INTO invoice_items VALUES('1117','1','603','2','16000.00','0.00','2021-10-11 17:10:36','2021-10-11 17:10:36');
INSERT INTO invoice_items VALUES('1121','1','552','2','3260.00','0.00','2021-10-11 17:39:08','2021-10-11 17:39:08');
INSERT INTO invoice_items VALUES('1123','1','531','5','470.00','0.00','2021-10-12 20:52:53','2021-10-12 20:52:53');
INSERT INTO invoice_items VALUES('1125','1','508','5','1870.00','0.00','2021-10-12 20:59:19','2021-10-12 20:59:19');
INSERT INTO invoice_items VALUES('1126','1','604','1','1000.00','0.00','2021-10-13 16:15:46','2021-10-13 16:15:46');
INSERT INTO invoice_items VALUES('1128','1','534','5','2825.00','0.00','2021-10-13 16:29:15','2021-10-13 16:29:15');
INSERT INTO invoice_items VALUES('1129','1','605','1','10200.00','0.00','2021-10-13 16:35:47','2021-10-13 16:35:47');
INSERT INTO invoice_items VALUES('1130','1','605','2','17000.00','0.00','2021-10-13 16:35:47','2021-10-13 16:35:47');
INSERT INTO invoice_items VALUES('1131','1','606','1','10800.00','0.00','2021-10-13 19:31:00','2021-10-13 19:31:00');
INSERT INTO invoice_items VALUES('1132','1','607','2','19000.00','0.00','2021-10-13 19:33:36','2021-10-13 19:33:36');
INSERT INTO invoice_items VALUES('1135','1','526','5','1120.00','0.00','2021-10-20 20:18:00','2021-10-20 20:18:00');
INSERT INTO invoice_items VALUES('1137','1','608','1','1000.00','0.00','2021-10-22 17:56:45','2021-10-22 17:56:45');
INSERT INTO invoice_items VALUES('1139','1','609','1','15500.00','0.00','2021-10-25 20:47:01','2021-10-25 20:47:01');
INSERT INTO invoice_items VALUES('1140','1','609','2','1000.00','0.00','2021-10-25 20:47:02','2021-10-25 20:47:02');
INSERT INTO invoice_items VALUES('1142','1','610','2','9800.00','0.00','2021-11-01 18:02:37','2021-11-01 18:02:37');
INSERT INTO invoice_items VALUES('1143','1','611','2','6500.00','0.00','2021-11-01 18:09:27','2021-11-01 18:09:27');
INSERT INTO invoice_items VALUES('1144','1','612','1','17000.00','0.00','2021-11-01 19:58:36','2021-11-01 19:58:36');
INSERT INTO invoice_items VALUES('1145','1','613','1','10000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1146','1','614','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1147','1','615','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1148','1','616','1','24000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1279','1','617','1','17500.00','0.00','2021-11-09 20:37:56','2021-11-09 20:37:56');
INSERT INTO invoice_items VALUES('1264','1','618','1','32000.00','0.00','2021-11-02 19:51:12','2021-11-02 19:51:12');
INSERT INTO invoice_items VALUES('1151','1','619','1','18000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1152','1','620','1','20000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1153','1','621','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1154','1','622','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1155','1','623','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1156','1','624','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1157','1','625','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1158','1','626','1','19000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1159','1','627','1','20000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1160','1','628','1','20000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1161','1','629','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1162','1','630','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1163','1','631','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1164','1','632','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1165','1','633','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1166','1','634','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1167','1','635','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1168','1','636','1','16000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1169','1','637','1','16000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1170','1','638','1','16000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1171','1','639','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1172','1','640','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1173','1','641','1','16000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1174','1','642','1','16000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1175','1','643','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1176','1','644','1','17500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1177','1','645','1','17500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1178','1','646','1','17500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1179','1','647','1','17500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1180','1','648','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1271','1','649','1','17500.00','8500.00','2021-11-07 14:16:14','2021-11-07 14:16:14');
INSERT INTO invoice_items VALUES('1182','1','650','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1183','1','651','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1184','1','652','1','12000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1286','1','653','1','13000.00','0.00','2021-11-17 18:41:53','2021-11-17 18:41:53');
INSERT INTO invoice_items VALUES('1285','1','654','1','13000.00','0.00','2021-11-17 18:41:12','2021-11-17 18:41:12');
INSERT INTO invoice_items VALUES('1187','1','655','1','22000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1273','1','656','1','16000.00','0.00','2021-11-07 14:56:24','2021-11-07 14:56:24');
INSERT INTO invoice_items VALUES('1189','1','657','1','16000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1417','1','856','1','17000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1191','1','659','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1192','1','660','1','17500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1193','1','661','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1194','1','662','1','15000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1195','1','663','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1196','1','664','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1197','1','665','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1198','1','666','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1275','1','667','1','14500.00','0.00','2021-11-07 21:49:00','2021-11-07 21:49:00');
INSERT INTO invoice_items VALUES('1278','1','668','1','14500.00','0.00','2021-11-08 18:32:10','2021-11-08 18:32:10');
INSERT INTO invoice_items VALUES('1287','1','669','1','14500.00','0.00','2021-11-22 20:24:02','2021-11-22 20:24:02');
INSERT INTO invoice_items VALUES('1274','1','734','1','15500.00','0.00','2021-11-07 17:08:00','2021-11-07 17:08:00');
INSERT INTO invoice_items VALUES('1203','1','671','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1204','1','672','1','16500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1205','1','673','1','18000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1206','1','674','1','18000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1207','1','675','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1208','1','676','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1209','1','677','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1210','1','678','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1281','1','735','5','2980.00','0.00','2021-11-10 18:39:46','2021-11-10 18:39:46');
INSERT INTO invoice_items VALUES('1212','1','680','1','18000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1213','1','681','1','15000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1214','1','682','1','15000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1215','1','683','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1216','1','684','1','15000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1217','1','685','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1218','1','686','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1277','1','687','1','14500.00','0.00','2021-11-08 18:20:48','2021-11-08 18:20:48');
INSERT INTO invoice_items VALUES('1220','1','688','1','19000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1221','1','689','1','15500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1985','1','1342','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1223','1','691','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1224','1','692','1','14000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1276','1','693','1','24000.00','0.00','2021-11-08 17:41:33','2021-11-08 17:41:33');
INSERT INTO invoice_items VALUES('1226','1','694','1','17500.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1227','1','695','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1228','1','696','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1229','1','697','1','17000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1230','1','698','1','15000.00','0.00','2021-11-01 19:58:37','2021-11-01 19:58:37');
INSERT INTO invoice_items VALUES('1231','1','699','1','22000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1232','1','700','1','15000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1280','1','701','1','19500.00','0.00','2021-11-09 20:45:00','2021-11-09 20:45:00');
INSERT INTO invoice_items VALUES('1234','1','702','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1235','1','703','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1236','1','704','1','15000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1237','1','705','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1238','1','706','1','15000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1239','1','707','1','21000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1240','1','708','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1241','1','709','1','19000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1242','1','710','1','17500.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1259','1','711','1','16500.00','0.00','2021-11-01 20:02:45','2021-11-01 20:02:45');
INSERT INTO invoice_items VALUES('1244','1','712','1','17500.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1245','1','713','1','18000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1246','1','714','1','17500.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1247','1','715','1','17500.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1248','1','716','1','15500.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1249','1','717','1','21000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1250','1','718','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1251','1','719','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1252','1','720','1','18000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1253','1','721','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1254','1','722','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1255','1','723','1','22000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1283','1','724','1','14500.00','0.00','2021-11-11 18:43:15','2021-11-11 18:43:15');
INSERT INTO invoice_items VALUES('1257','1','725','1','22000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1258','1','726','1','17000.00','0.00','2021-11-01 19:58:38','2021-11-01 19:58:38');
INSERT INTO invoice_items VALUES('1266','1','730','1','15500.00','0.00','2021-11-02 20:16:57','2021-11-02 20:16:57');
INSERT INTO invoice_items VALUES('1265','1','729','1','15500.00','0.00','2021-11-02 20:16:16','2021-11-02 20:16:16');
INSERT INTO invoice_items VALUES('1262','1','728','1','15500.00','0.00','2021-11-02 17:49:21','2021-11-02 17:49:21');
INSERT INTO invoice_items VALUES('1263','1','728','2','15500.00','0.00','2021-11-02 17:49:21','2021-11-02 17:49:21');
INSERT INTO invoice_items VALUES('1267','1','730','2','10000.00','0.00','2021-11-02 20:16:57','2021-11-02 20:16:57');
INSERT INTO invoice_items VALUES('1268','1','731','1','15500.00','0.00','2021-11-02 20:17:34','2021-11-02 20:17:34');
INSERT INTO invoice_items VALUES('1269','1','731','2','10000.00','0.00','2021-11-02 20:17:34','2021-11-02 20:17:34');
INSERT INTO invoice_items VALUES('1270','1','732','2','10000.00','0.00','2021-11-02 20:18:01','2021-11-02 20:18:01');
INSERT INTO invoice_items VALUES('1272','1','733','5','8820.00','0.00','2021-11-07 14:25:03','2021-11-07 14:25:03');
INSERT INTO invoice_items VALUES('1282','1','736','1','14500.00','0.00','2021-11-11 18:41:58','2021-11-11 18:41:58');
INSERT INTO invoice_items VALUES('1284','1','737','1','10300.00','0.00','2021-11-11 19:01:34','2021-11-11 19:01:34');
INSERT INTO invoice_items VALUES('1288','1','738','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1289','1','739','1','10000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1290','1','740','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1291','1','741','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1292','1','742','1','24000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1293','1','743','1','17500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1294','1','744','1','32000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1295','1','745','1','18000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1296','1','746','1','20000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1297','1','747','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1298','1','748','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1299','1','749','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1300','1','750','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1301','1','751','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1302','1','752','1','19000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1303','1','753','1','20000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1304','1','754','1','20000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1305','1','755','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1306','1','756','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1307','1','757','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1308','1','758','1','15500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1309','1','759','1','15500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1310','1','760','1','15500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1311','1','761','1','15500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1312','1','762','1','16000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1313','1','763','1','16000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1314','1','764','1','16000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1315','1','765','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1316','1','766','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1317','1','767','1','16000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1318','1','768','1','16000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1319','1','769','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1320','1','770','1','17500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1321','1','771','1','17500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1322','1','772','1','17500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1323','1','773','1','17500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1324','1','774','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1410','1','775','1','17000.00','0.00','2021-12-07 17:24:07','2021-12-07 17:24:07');
INSERT INTO invoice_items VALUES('1326','1','776','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1327','1','777','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1407','1','778','1','13000.00','0.00','2021-12-02 18:07:07','2021-12-02 18:07:07');
INSERT INTO invoice_items VALUES('1408','1','779','1','13000.00','0.00','2021-12-03 20:04:02','2021-12-03 20:04:02');
INSERT INTO invoice_items VALUES('1416','1','780','1','13000.00','0.00','2021-12-14 19:14:43','2021-12-14 19:14:43');
INSERT INTO invoice_items VALUES('1331','1','781','1','22000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1332','1','782','1','16000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1333','1','783','1','16000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1334','1','784','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1335','1','785','1','17500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1336','1','786','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1337','1','787','1','15000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1338','1','788','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1339','1','789','1','15500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1340','1','790','1','15500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1341','1','791','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1548','1','858','1','14000.00','0.00','2022-01-10 17:33:14','2022-01-10 17:33:14');
INSERT INTO invoice_items VALUES('1418','1','857','1','10000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1415','1','794','1','17500.00','0.00','2021-12-13 17:45:56','2021-12-13 17:45:56');
INSERT INTO invoice_items VALUES('1345','1','795','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1346','1','796','1','16500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1347','1','797','1','18000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1348','1','798','1','18000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1349','1','799','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1350','1','800','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1351','1','801','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1352','1','802','1','17000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1353','1','803','1','18000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1354','1','804','1','15000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1355','1','805','1','15000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1356','1','806','1','15500.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1357','1','807','1','15000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1358','1','808','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1359','1','809','1','14000.00','0.00','2021-12-01 17:40:00','2021-12-01 17:40:00');
INSERT INTO invoice_items VALUES('1411','1','810','1','17500.00','0.00','2021-12-09 19:35:06','2021-12-09 19:35:06');
INSERT INTO invoice_items VALUES('1361','1','811','1','19000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1362','1','812','1','15500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1363','1','813','1','15500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1409','1','814','1','17000.00','7000.00','2021-12-06 17:51:44','2021-12-06 17:51:44');
INSERT INTO invoice_items VALUES('1365','1','815','1','14000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1412','1','816','1','21000.00','0.00','2021-12-13 17:32:41','2021-12-13 17:32:41');
INSERT INTO invoice_items VALUES('1367','1','817','1','17500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1368','1','818','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1369','1','819','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1370','1','820','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1371','1','821','1','15000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1372','1','822','1','22000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1373','1','823','1','15000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1374','1','824','1','19500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1375','1','825','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1376','1','826','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1377','1','827','1','15000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1378','1','828','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1379','1','829','1','15000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1380','1','830','1','21000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1381','1','831','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1382','1','832','1','19000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1383','1','833','1','17500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1384','1','834','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1385','1','835','1','17500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1386','1','836','1','18000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1387','1','837','1','17500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1388','1','838','1','17500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1389','1','839','1','15500.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1390','1','840','1','21000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1391','1','841','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1392','1','842','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1393','1','843','1','18000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1564','1','978','1','10000.00','0.00','2022-02-01 20:15:02','2022-02-01 20:15:02');
INSERT INTO invoice_items VALUES('1395','1','845','1','17000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1396','1','846','1','22000.00','0.00','2021-12-01 17:40:01','2021-12-01 17:40:01');
INSERT INTO invoice_items VALUES('1565','1','979','1','14000.00','0.00','2022-02-01 20:15:02','2022-02-01 20:15:02');
INSERT INTO invoice_items VALUES('1413','1','848','1','17500.00','0.00','2021-12-13 17:43:44','2021-12-13 17:43:44');
INSERT INTO invoice_items VALUES('1399','1','849','1','22000.00','0.00','2021-12-01 17:40:02','2021-12-01 17:40:02');
INSERT INTO invoice_items VALUES('1400','1','850','1','17000.00','0.00','2021-12-01 17:40:02','2021-12-01 17:40:02');
INSERT INTO invoice_items VALUES('1401','1','851','1','15500.00','0.00','2021-12-01 17:40:02','2021-12-01 17:40:02');
INSERT INTO invoice_items VALUES('1402','1','852','1','15500.00','0.00','2021-12-01 17:40:02','2021-12-01 17:40:02');
INSERT INTO invoice_items VALUES('1406','1','853','1','15500.00','0.00','2021-12-02 17:57:25','2021-12-02 17:57:25');
INSERT INTO invoice_items VALUES('1404','1','854','1','15500.00','0.00','2021-12-01 17:40:02','2021-12-01 17:40:02');
INSERT INTO invoice_items VALUES('1405','1','855','1','15500.00','0.00','2021-12-01 17:40:02','2021-12-01 17:40:02');
INSERT INTO invoice_items VALUES('1546','1','859','1','14000.00','0.00','2022-01-10 17:21:39','2022-01-10 17:21:39');
INSERT INTO invoice_items VALUES('1421','1','860','1','24000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1422','1','861','1','17500.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1423','1','862','1','32000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1424','1','863','1','18000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1425','1','864','1','20000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1426','1','865','1','17000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1427','1','866','1','17000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1428','1','867','1','17000.00','0.00','2022-01-03 18:39:45','2022-01-03 18:39:45');
INSERT INTO invoice_items VALUES('1429','1','868','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1545','1','869','1','14300.00','0.00','2022-01-09 19:16:04','2022-01-09 19:16:04');
INSERT INTO invoice_items VALUES('1431','1','870','1','19000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1432','1','871','1','20000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1433','1','872','1','20000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1561','1','873','1','14500.00','0.00','2022-01-13 18:23:45','2022-01-13 18:23:45');
INSERT INTO invoice_items VALUES('1544','1','874','1','14300.00','0.00','2022-01-09 19:14:20','2022-01-09 19:14:20');
INSERT INTO invoice_items VALUES('1552','1','875','1','14000.00','0.00','2022-01-10 21:36:10','2022-01-10 21:36:10');
INSERT INTO invoice_items VALUES('1437','1','876','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1438','1','877','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1439','1','878','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1440','1','879','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1441','1','880','1','16000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1442','1','881','1','16000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1443','1','882','1','16000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1444','1','883','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1445','1','884','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1446','1','885','1','16000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1536','1','886','1','17000.00','0.00','2022-01-04 20:45:47','2022-01-04 20:45:47');
INSERT INTO invoice_items VALUES('1448','1','887','1','14000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1449','1','888','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1450','1','889','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1451','1','890','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1452','1','891','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1453','1','892','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1539','1','893','1','17000.00','0.00','2022-01-08 14:54:55','2022-01-08 14:54:55');
INSERT INTO invoice_items VALUES('1550','1','894','1','17000.00','0.00','2022-01-10 21:26:21','2022-01-10 21:26:21');
INSERT INTO invoice_items VALUES('1456','1','895','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1542','1','896','1','13000.00','0.00','2022-01-08 15:22:37','2022-01-08 15:22:37');
INSERT INTO invoice_items VALUES('1541','1','897','1','13000.00','0.00','2022-01-08 15:07:32','2022-01-08 15:07:32');
INSERT INTO invoice_items VALUES('1540','1','898','1','13000.00','0.00','2022-01-08 15:06:13','2022-01-08 15:06:13');
INSERT INTO invoice_items VALUES('1460','1','899','1','22000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1461','1','900','1','16000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1462','1','901','1','16000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1555','1','976','1','18000.00','0.00','2022-01-12 19:31:35','2022-01-12 19:31:35');
INSERT INTO invoice_items VALUES('1464','1','903','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1465','1','904','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1466','1','905','1','15000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1467','1','906','1','14000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1468','1','907','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1469','1','908','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1470','1','909','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1560','1','910','1','15500.00','0.00','2022-01-12 19:43:31','2022-01-12 19:43:31');
INSERT INTO invoice_items VALUES('1559','1','911','1','15500.00','0.00','2022-01-12 19:42:42','2022-01-12 19:42:42');
INSERT INTO invoice_items VALUES('1558','1','912','1','15500.00','0.00','2022-01-12 19:41:04','2022-01-12 19:41:04');
INSERT INTO invoice_items VALUES('1474','1','913','1','14000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1475','1','914','1','16500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1476','1','915','1','18000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1569','1','983','1','32000.00','0.00','2022-02-01 20:15:02','2022-02-01 20:15:02');
INSERT INTO invoice_items VALUES('1478','1','917','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1479','1','918','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1480','1','919','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1481','1','920','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1482','1','921','1','18000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1483','1','922','1','15000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1484','1','923','1','15000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1485','1','924','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1547','1','859','3','300.00','0.00','2022-01-10 17:21:39','2022-01-10 17:21:39');
INSERT INTO invoice_items VALUES('1487','1','926','1','14000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1488','1','927','1','14000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1557','1','928','1','15500.00','0.00','2022-01-12 19:39:55','2022-01-12 19:39:55');
INSERT INTO invoice_items VALUES('1490','1','929','1','19000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1491','1','930','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1716','1','1101','1','24000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1493','1','932','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1566','1','980','1','14000.00','0.00','2022-02-01 20:15:02','2022-02-01 20:15:02');
INSERT INTO invoice_items VALUES('1562','1','934','1','24000.00','0.00','2022-01-14 18:25:19','2022-01-14 18:25:19');
INSERT INTO invoice_items VALUES('1496','1','935','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1497','1','936','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1498','1','937','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1499','1','938','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1500','1','939','1','15000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1501','1','940','1','22000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1502','1','941','1','15000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1503','1','942','1','19500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1504','1','943','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1505','1','944','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1506','1','945','1','15000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1507','1','946','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1508','1','947','1','15000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1509','1','948','1','21000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1510','1','949','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1511','1','950','1','19000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1512','1','951','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1513','1','952','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1514','1','953','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1515','1','954','1','18000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1516','1','955','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1517','1','956','1','17500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1518','1','957','1','15500.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1519','1','958','1','21000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1520','1','959','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1521','1','960','1','17000.00','0.00','2022-01-03 18:39:46','2022-01-03 18:39:46');
INSERT INTO invoice_items VALUES('1537','1','961','1','18000.00','0.00','2022-01-05 20:10:16','2022-01-05 20:10:16');
INSERT INTO invoice_items VALUES('1567','1','981','1','24000.00','0.00','2022-02-01 20:15:02','2022-02-01 20:15:02');
INSERT INTO invoice_items VALUES('1524','1','963','1','17000.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1525','1','964','1','22000.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1568','1','982','1','17500.00','0.00','2022-02-01 20:15:02','2022-02-01 20:15:02');
INSERT INTO invoice_items VALUES('1556','1','966','1','15500.00','0.00','2022-01-12 19:38:59','2022-01-12 19:38:59');
INSERT INTO invoice_items VALUES('1528','1','967','1','22000.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1529','1','968','1','17000.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1543','1','975','1','16000.00','0.00','2022-01-08 19:14:10','2022-01-08 19:14:10');
INSERT INTO invoice_items VALUES('1531','1','970','1','15500.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1532','1','971','1','15500.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1533','1','972','1','15500.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1534','1','973','1','15500.00','0.00','2022-01-03 18:39:47','2022-01-03 18:39:47');
INSERT INTO invoice_items VALUES('1535','1','974','5','500.00','0.00','2022-01-04 20:43:35','2022-01-04 20:43:35');
INSERT INTO invoice_items VALUES('1538','1','961','3','1000.00','0.00','2022-01-05 20:10:17','2022-01-05 20:10:17');
INSERT INTO invoice_items VALUES('1549','1','858','3','300.00','0.00','2022-01-10 17:33:14','2022-01-10 17:33:14');
INSERT INTO invoice_items VALUES('1551','1','894','3','500.00','0.00','2022-01-10 21:26:21','2022-01-10 21:26:21');
INSERT INTO invoice_items VALUES('1553','1','875','3','300.00','0.00','2022-01-10 21:36:10','2022-01-10 21:36:10');
INSERT INTO invoice_items VALUES('1570','1','984','1','18000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1571','1','985','1','20000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1572','1','986','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1573','1','987','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1574','1','988','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1575','1','989','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1703','1','1092','1','10000.00','0.00','2022-02-11 20:34:54','2022-02-11 20:34:54');
INSERT INTO invoice_items VALUES('1577','1','991','1','19000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1578','1','992','1','20000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1579','1','993','1','20000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1580','1','994','1','14000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1702','1','1091','1','9000.00','0.00','2022-02-11 19:04:39','2022-02-11 19:04:39');
INSERT INTO invoice_items VALUES('1680','1','996','1','14000.00','0.00','2022-02-04 19:42:00','2022-02-04 19:42:00');
INSERT INTO invoice_items VALUES('1583','1','997','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1584','1','998','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1585','1','999','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1586','1','1000','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1587','1','1001','1','16000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1588','1','1002','1','16000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1589','1','1003','1','16000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1590','1','1004','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1591','1','1005','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1592','1','1006','1','16000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1678','1','1007','1','17500.00','0.00','2022-02-03 20:25:11','2022-02-03 20:25:11');
INSERT INTO invoice_items VALUES('1594','1','1008','1','14000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1595','1','1009','1','17500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1596','1','1010','1','17500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1597','1','1011','1','17500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1598','1','1012','1','17500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1599','1','1013','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1691','1','1014','1','17000.00','0.00','2022-02-07 18:21:27','2022-02-07 18:21:27');
INSERT INTO invoice_items VALUES('1693','1','1015','1','17000.00','0.00','2022-02-08 20:10:24','2022-02-08 20:10:24');
INSERT INTO invoice_items VALUES('1675','1','1016','1','17000.00','0.00','2022-02-02 21:05:09','2022-02-02 21:05:09');
INSERT INTO invoice_items VALUES('1705','1','1017','1','13000.00','0.00','2022-02-12 20:48:43','2022-02-12 20:48:43');
INSERT INTO invoice_items VALUES('1698','1','1018','1','13000.00','0.00','2022-02-09 21:24:00','2022-02-09 21:24:00');
INSERT INTO invoice_items VALUES('1700','1','1019','1','13000.00','0.00','2022-02-10 18:33:45','2022-02-10 18:33:45');
INSERT INTO invoice_items VALUES('1606','1','1020','1','22000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1607','1','1021','1','16000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1677','1','1022','1','17500.00','0.00','2022-02-02 22:39:05','2022-02-02 22:39:05');
INSERT INTO invoice_items VALUES('1609','1','1023','1','17500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1610','1','1024','1','17500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1611','1','1025','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1612','1','1026','1','15000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1613','1','1027','1','14000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1614','1','1028','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1615','1','1029','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1616','1','1030','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1701','1','1031','1','15500.00','0.00','2022-02-10 18:56:00','2022-02-10 18:56:00');
INSERT INTO invoice_items VALUES('1679','1','1032','1','15500.00','0.00','2022-02-04 17:44:59','2022-02-04 17:44:59');
INSERT INTO invoice_items VALUES('1696','1','1033','1','15500.00','0.00','2022-02-09 18:20:39','2022-02-09 18:20:39');
INSERT INTO invoice_items VALUES('1620','1','1034','1','14000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1621','1','1035','1','16500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1622','1','1036','1','18000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1699','1','1037','1','17500.00','0.00','2022-02-09 21:41:35','2022-02-09 21:41:35');
INSERT INTO invoice_items VALUES('1624','1','1038','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1625','1','1039','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1626','1','1040','1','17000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1627','1','1041','1','18000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1628','1','1042','1','15000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1629','1','1043','1','15000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1630','1','1044','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1631','1','1045','1','14000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1632','1','1046','1','14000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1695','1','1047','1','15500.00','0.00','2022-02-08 21:43:18','2022-02-08 21:43:18');
INSERT INTO invoice_items VALUES('1634','1','1048','1','19000.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1635','1','1049','1','15500.00','0.00','2022-02-01 20:15:03','2022-02-01 20:15:03');
INSERT INTO invoice_items VALUES('1722','1','1107','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1637','1','1051','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1638','1','1052','1','24000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1639','1','1053','1','17500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1721','1','1106','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1641','1','1055','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1642','1','1056','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1643','1','1057','1','15000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1644','1','1058','1','22000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1645','1','1059','1','15000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1646','1','1060','1','19500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1647','1','1061','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1648','1','1062','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1692','1','1090','1','15000.00','0.00','2022-02-07 20:20:54','2022-02-07 20:20:54');
INSERT INTO invoice_items VALUES('1650','1','1064','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1651','1','1065','1','15000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1652','1','1066','1','21000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1653','1','1067','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1654','1','1068','1','19000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1655','1','1069','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1656','1','1070','1','17500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1657','1','1071','1','18000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1658','1','1072','1','17500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1659','1','1073','1','17500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1660','1','1074','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1661','1','1075','1','21000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1662','1','1076','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1663','1','1077','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1664','1','1078','1','18000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1665','1','1079','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1666','1','1080','1','22000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1697','1','1081','1','15500.00','0.00','2022-02-09 18:23:27','2022-02-09 18:23:27');
INSERT INTO invoice_items VALUES('1668','1','1082','1','22000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1669','1','1083','1','17000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1670','1','1084','1','16000.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1671','1','1085','1','15500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1672','1','1086','1','15500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1673','1','1087','1','15500.00','0.00','2022-02-01 20:15:04','2022-02-01 20:15:04');
INSERT INTO invoice_items VALUES('1682','1','1088','1','15500.00','0.00','2022-02-06 18:29:24','2022-02-06 18:29:24');
INSERT INTO invoice_items VALUES('1676','1','1016','3','500.00','0.00','2022-02-02 21:05:09','2022-02-02 21:05:09');
INSERT INTO invoice_items VALUES('1681','1','996','3','300.00','0.00','2022-02-04 19:42:00','2022-02-04 19:42:00');
INSERT INTO invoice_items VALUES('1683','1','1088','3','500.00','0.00','2022-02-06 18:29:24','2022-02-06 18:29:24');
INSERT INTO invoice_items VALUES('1706','1','1093','1','11000.00','0.00','2022-02-13 18:49:20','2022-02-13 18:49:20');
INSERT INTO invoice_items VALUES('1707','1','1093','2','17000.00','0.00','2022-02-13 18:49:20','2022-02-13 18:49:20');
INSERT INTO invoice_items VALUES('1708','1','1094','1','12200.00','0.00','2022-02-13 20:55:51','2022-02-13 20:55:51');
INSERT INTO invoice_items VALUES('1709','1','1094','2','19000.00','0.00','2022-02-13 20:55:51','2022-02-13 20:55:51');
INSERT INTO invoice_items VALUES('1723','1','1108','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1724','1','1109','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1725','1','1110','1','19000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1726','1','1111','1','20000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1727','1','1112','1','20000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1834','1','1113','1','15500.00','0.00','2022-03-08 16:12:53','2022-03-08 16:12:53');
INSERT INTO invoice_items VALUES('1729','1','1114','1','15500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1843','1','1212','2','15500.00','0.00','2022-03-11 18:41:31','2022-03-11 18:41:31');
INSERT INTO invoice_items VALUES('1731','1','1116','1','15500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1732','1','1117','1','15500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1733','1','1118','1','16000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1734','1','1119','1','16000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1735','1','1120','1','16000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1736','1','1121','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1737','1','1122','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1738','1','1123','1','16000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1739','1','1124','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1740','1','1125','1','14000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1741','1','1126','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1742','1','1127','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1743','1','1128','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1744','1','1129','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1745','1','1130','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1828','1','1131','1','17000.00','0.00','2022-03-06 19:12:01','2022-03-06 19:12:01');
INSERT INTO invoice_items VALUES('1747','1','1132','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1748','1','1133','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1749','1','1134','1','13000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1750','1','1135','1','13000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1751','1','1136','1','13000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1752','1','1137','1','22000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1823','1','1138','1','17500.00','0.00','2022-03-02 21:35:30','2022-03-02 21:35:30');
INSERT INTO invoice_items VALUES('1822','1','1139','1','17500.00','0.00','2022-03-02 21:20:01','2022-03-02 21:20:01');
INSERT INTO invoice_items VALUES('1755','1','1140','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1756','1','1141','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1757','1','1142','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1758','1','1143','1','15000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1759','1','1144','1','14000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1760','1','1145','1','15500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1761','1','1146','1','15500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1762','1','1147','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1832','1','1148','1','17500.00','0.00','2022-03-07 19:35:20','2022-03-07 19:35:20');
INSERT INTO invoice_items VALUES('1831','1','1149','1','17500.00','0.00','2022-03-07 19:33:32','2022-03-07 19:33:32');
INSERT INTO invoice_items VALUES('1765','1','1150','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1766','1','1151','1','14000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1767','1','1152','1','16500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1768','1','1153','1','18000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1841','1','1154','1','17500.00','0.00','2022-03-10 20:02:45','2022-03-10 20:02:45');
INSERT INTO invoice_items VALUES('1770','1','1155','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1771','1','1156','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1772','1','1157','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1773','1','1158','1','18000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1774','1','1159','1','15000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1775','1','1160','1','15000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1844','1','1213','1','10650.00','0.00','2022-03-11 18:46:35','2022-03-11 18:46:35');
INSERT INTO invoice_items VALUES('1777','1','1162','1','14000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1778','1','1163','1','14000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1779','1','1164','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1780','1','1165','1','19000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1781','1','1166','1','15500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1842','1','1212','1','10500.00','0.00','2022-03-11 18:41:31','2022-03-11 18:41:31');
INSERT INTO invoice_items VALUES('1783','1','1168','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1784','1','1169','1','24000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1785','1','1170','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1837','1','1210','1','19000.00','0.00','2022-03-09 21:04:32','2022-03-09 21:04:32');
INSERT INTO invoice_items VALUES('1787','1','1172','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1788','1','1173','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1789','1','1174','1','15000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1790','1','1175','1','22000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1791','1','1176','1','15000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1792','1','1177','1','19500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1793','1','1178','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1794','1','1179','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1795','1','1180','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1796','1','1181','1','15000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1797','1','1182','1','21000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1798','1','1183','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1799','1','1184','1','16500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1800','1','1185','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1801','1','1186','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1802','1','1187','1','18000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1803','1','1188','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1804','1','1189','1','17500.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1805','1','1190','1','17000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1806','1','1191','1','21000.00','0.00','2022-03-02 17:32:35','2022-03-02 17:32:35');
INSERT INTO invoice_items VALUES('1833','1','1192','1','16000.00','0.00','2022-03-08 16:12:03','2022-03-08 16:12:03');
INSERT INTO invoice_items VALUES('1808','1','1193','1','17000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1809','1','1194','1','18000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1810','1','1195','1','17000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1811','1','1196','1','22000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1812','1','1197','1','22000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1813','1','1198','1','17000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1814','1','1199','1','15500.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1815','1','1200','1','15500.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1847','1','1201','1','14000.00','0.00','2022-03-11 18:58:15','2022-03-11 18:58:15');
INSERT INTO invoice_items VALUES('1817','1','1202','1','15500.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1845','1','1213','2','15000.00','0.00','2022-03-11 18:46:35','2022-03-11 18:46:35');
INSERT INTO invoice_items VALUES('1819','1','1204','1','15000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1820','1','1205','1','17000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1821','1','1206','1','17000.00','0.00','2022-03-02 17:32:36','2022-03-02 17:32:36');
INSERT INTO invoice_items VALUES('1824','1','1207','1','15000.00','0.00','2022-03-05 21:10:23','2022-03-05 21:10:23');
INSERT INTO invoice_items VALUES('1825','1','1207','2','15000.00','0.00','2022-03-05 21:10:23','2022-03-05 21:10:23');
INSERT INTO invoice_items VALUES('1826','1','1208','1','19000.00','0.00','2022-03-06 18:26:03','2022-03-06 18:26:03');
INSERT INTO invoice_items VALUES('1827','1','1208','2','19000.00','0.00','2022-03-06 18:26:03','2022-03-06 18:26:03');
INSERT INTO invoice_items VALUES('1829','1','1209','1','15000.00','0.00','2022-03-06 19:35:37','2022-03-06 19:35:37');
INSERT INTO invoice_items VALUES('1830','1','1209','2','15000.00','0.00','2022-03-06 19:35:37','2022-03-06 19:35:37');
INSERT INTO invoice_items VALUES('1838','1','1210','2','10000.00','0.00','2022-03-09 21:04:32','2022-03-09 21:04:32');
INSERT INTO invoice_items VALUES('1839','1','1211','1','19000.00','0.00','2022-03-09 21:05:13','2022-03-09 21:05:13');
INSERT INTO invoice_items VALUES('1840','1','1211','2','10000.00','0.00','2022-03-09 21:05:13','2022-03-09 21:05:13');
INSERT INTO invoice_items VALUES('1848','1','1214','1','11500.00','0.00','2022-03-11 19:09:48','2022-03-11 19:09:48');
INSERT INTO invoice_items VALUES('1849','1','1214','2','15500.00','0.00','2022-03-11 19:09:48','2022-03-11 19:09:48');
INSERT INTO invoice_items VALUES('1851','1','1216','1','17000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1852','1','1217','1','10000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1971','1','1218','1','16000.00','0.00','2022-04-14 18:32:05','2022-04-14 18:32:05');
INSERT INTO invoice_items VALUES('1972','1','1219','1','16000.00','0.00','2022-04-14 18:33:48','2022-04-14 18:33:48');
INSERT INTO invoice_items VALUES('1855','1','1220','1','24000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1856','1','1221','1','17500.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1857','1','1222','1','18000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1858','1','1223','1','20000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1859','1','1224','1','17000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1860','1','1225','1','17000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1861','1','1226','1','17000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1862','1','1227','1','17000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1863','1','1228','1','19000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1864','1','1229','1','20000.00','0.00','2022-04-02 11:08:09','2022-04-02 11:08:09');
INSERT INTO invoice_items VALUES('1865','1','1230','1','20000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1989','1','1346','1','24000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1867','1','1232','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1868','1','1233','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1869','1','1234','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1870','1','1235','1','16000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1871','1','1236','1','16000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1872','1','1237','1','16000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1873','1','1238','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1874','1','1239','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1875','1','1240','1','16000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1876','1','1241','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1975','1','1242','1','14000.00','6500.00','2022-04-20 15:37:05','2022-04-20 15:37:05');
INSERT INTO invoice_items VALUES('1878','1','1243','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1879','1','1244','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1880','1','1245','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1881','1','1246','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1882','1','1247','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1883','1','1248','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1884','1','1249','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1885','1','1250','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1886','1','1251','1','13000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1887','1','1252','1','13000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1888','1','1253','1','13000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1889','1','1254','1','22000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1890','1','1255','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1891','1','1256','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1892','1','1257','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1893','1','1258','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1894','1','1259','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1895','1','1260','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1896','1','1261','1','14000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1897','1','1262','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1898','1','1263','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1977','1','1264','1','17000.00','15000.00','2022-04-24 10:43:56','2022-04-24 10:43:56');
INSERT INTO invoice_items VALUES('1900','1','1265','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1901','1','1266','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1902','1','1267','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1903','1','1268','1','14000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1904','1','1269','1','16500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1905','1','1270','1','18000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1906','1','1271','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1907','1','1272','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1908','1','1273','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1909','1','1274','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1910','1','1275','1','18000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1911','1','1276','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1912','1','1277','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1913','1','1278','1','14000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1914','1','1279','1','14000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1915','1','1280','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1916','1','1281','1','19000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1917','1','1282','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1918','1','1283','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1973','1','1284','1','18000.00','0.00','2022-04-16 06:32:59','2022-04-16 06:32:59');
INSERT INTO invoice_items VALUES('1981','1','1338','2','19000.00','0.00','2022-04-28 16:44:06','2022-04-28 16:44:06');
INSERT INTO invoice_items VALUES('1921','1','1286','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1922','1','1287','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1923','1','1288','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1924','1','1289','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1925','1','1290','1','19500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1926','1','1291','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1927','1','1292','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1928','1','1293','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1929','1','1294','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1984','1','1341','2','17500.00','0.00','2022-04-28 17:10:22','2022-04-28 17:10:22');
INSERT INTO invoice_items VALUES('1931','1','1296','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1932','1','1297','1','16500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1933','1','1298','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1934','1','1299','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1935','1','1300','1','18000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1936','1','1301','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1937','1','1302','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1938','1','1303','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1980','1','1337','2','10000.00','0.00','2022-04-28 16:43:27','2022-04-28 16:43:27');
INSERT INTO invoice_items VALUES('1970','1','1305','1','16000.00','0.00','2022-04-14 18:30:37','2022-04-14 18:30:37');
INSERT INTO invoice_items VALUES('1941','1','1306','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1942','1','1307','1','18000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1943','1','1308','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1944','1','1309','1','22000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1945','1','1310','1','22000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1946','1','1311','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1947','1','1312','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1948','1','1313','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1949','1','1314','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1950','1','1315','1','17500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1991','1','1348','1','18000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1952','1','1317','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1953','1','1318','1','17000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1954','1','1319','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1955','1','1320','1','19000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1956','1','1321','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('2109','1','1345','1','16000.00','0.00','2022-05-08 15:22:04','2022-05-08 15:22:04');
INSERT INTO invoice_items VALUES('1990','1','1347','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1959','1','1324','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1960','1','1325','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1961','1','1326','1','15500.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1962','1','1327','1','15000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1963','1','1328','1','19000.00','0.00','2022-04-02 11:08:10','2022-04-02 11:08:10');
INSERT INTO invoice_items VALUES('1964','1','1329','1','19000.00','0.00','2022-04-02 11:08:11','2022-04-02 11:08:11');
INSERT INTO invoice_items VALUES('1965','1','1330','1','16000.00','0.00','2022-04-02 11:08:11','2022-04-02 11:08:11');
INSERT INTO invoice_items VALUES('1966','1','1331','2','16000.00','0.00','2022-04-02 11:10:32','2022-04-02 11:10:32');
INSERT INTO invoice_items VALUES('1967','1','1332','2','19000.00','0.00','2022-04-02 11:12:14','2022-04-02 11:12:14');
INSERT INTO invoice_items VALUES('1968','1','1333','2','19000.00','0.00','2022-04-02 11:13:55','2022-04-02 11:13:55');
INSERT INTO invoice_items VALUES('1969','1','1334','1','500.00','0.00','2022-04-04 14:28:51','2022-04-04 14:28:51');
INSERT INTO invoice_items VALUES('1992','1','1349','1','20000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1993','1','1350','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1994','1','1351','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1995','1','1352','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('1996','1','1353','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2107','1','1354','1','19000.00','0.00','2022-05-08 15:09:50','2022-05-08 15:09:50');
INSERT INTO invoice_items VALUES('2122','1','1355','1','20000.00','0.00','2022-05-13 14:37:25','2022-05-13 14:37:25');
INSERT INTO invoice_items VALUES('1999','1','1356','1','20000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2141','1','1357','1','15500.00','0.00','2022-05-22 06:37:36','2022-05-22 06:37:36');
INSERT INTO invoice_items VALUES('2114','1','1358','1','15500.00','0.00','2022-05-09 16:26:58','2022-05-09 16:26:58');
INSERT INTO invoice_items VALUES('2002','1','1359','1','15500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2003','1','1360','1','16000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2004','1','1361','1','16000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2005','1','1362','1','16000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2006','1','1363','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2007','1','1364','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2008','1','1365','1','16000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2009','1','1366','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2010','1','1367','1','14000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2011','1','1368','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2012','1','1369','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2013','1','1370','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2014','1','1371','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2015','1','1372','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2016','1','1373','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2017','1','1374','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2018','1','1375','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2019','1','1376','1','13000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2020','1','1377','1','13000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2021','1','1378','1','13000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2134','1','1379','1','17000.00','0.00','2022-05-17 17:13:35','2022-05-17 17:13:35');
INSERT INTO invoice_items VALUES('2023','1','1380','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2024','1','1381','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2025','1','1382','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2116','1','1383','1','17500.00','0.00','2022-05-09 16:45:30','2022-05-09 16:45:30');
INSERT INTO invoice_items VALUES('2154','1','1384','5','950.00','0.00','2022-05-22 07:25:07','2022-05-22 07:25:07');
INSERT INTO invoice_items VALUES('2028','1','1385','1','15000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2029','1','1386','1','14000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2030','1','1387','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2031','1','1388','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2032','1','1389','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2033','1','1390','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2034','1','1391','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2035','1','1392','1','14000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2294','1','1393','1','16500.00','9000.00','2022-06-03 17:08:36','2022-06-03 17:08:36');
INSERT INTO invoice_items VALUES('2037','1','1394','1','18000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2038','1','1395','1','17500.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2039','1','1396','1','19000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2289','1','1515','5','820.00','0.00','2022-06-02 13:29:58','2022-06-02 13:29:58');
INSERT INTO invoice_items VALUES('2041','1','1398','1','17000.00','0.00','2022-05-06 13:18:06','2022-05-06 13:18:06');
INSERT INTO invoice_items VALUES('2042','1','1399','1','18000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2043','1','1400','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2044','1','1401','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2045','1','1402','1','14000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2046','1','1403','1','14000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2047','1','1404','1','17500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2048','1','1405','1','19000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2049','1','1406','1','15500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2112','1','1407','1','17000.00','0.00','2022-05-09 15:27:54','2022-05-09 15:27:54');
INSERT INTO invoice_items VALUES('2119','1','1408','1','18000.00','0.00','2022-05-11 16:15:31','2022-05-11 16:15:31');
INSERT INTO invoice_items VALUES('2052','1','1409','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2053','1','1410','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2054','1','1411','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2148','1','1412','1','22000.00','0.00','2022-05-22 06:50:09','2022-05-22 06:50:09');
INSERT INTO invoice_items VALUES('2056','1','1413','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2057','1','1414','1','19500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2166','1','1490','5','1000.00','0.00','2022-05-28 14:46:06','2022-05-28 14:46:06');
INSERT INTO invoice_items VALUES('2059','1','1416','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2060','1','1417','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2061','1','1418','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2104','1','1459','1','16000.00','0.00','2022-05-08 13:38:45','2022-05-08 13:38:45');
INSERT INTO invoice_items VALUES('2063','1','1420','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2136','1','1421','1','16500.00','0.00','2022-05-22 06:31:16','2022-05-22 06:31:16');
INSERT INTO invoice_items VALUES('2065','1','1422','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2066','1','1423','1','17500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2067','1','1424','1','18000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2160','1','1486','5','300.00','0.00','2022-05-22 07:36:57','2022-05-22 07:36:57');
INSERT INTO invoice_items VALUES('2069','1','1426','1','17500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2120','1','1427','1','17000.00','0.00','2022-05-11 16:32:38','2022-05-11 16:32:38');
INSERT INTO invoice_items VALUES('2103','1','1458','1','16000.00','0.00','2022-05-08 13:38:45','2022-05-08 13:38:45');
INSERT INTO invoice_items VALUES('2111','1','1429','1','16000.00','0.00','2022-05-08 15:23:31','2022-05-08 15:23:31');
INSERT INTO invoice_items VALUES('2073','1','1430','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2074','1','1431','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2075','1','1432','1','22000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2126','1','1433','1','22000.00','0.00','2022-05-14 12:11:08','2022-05-14 12:11:08');
INSERT INTO invoice_items VALUES('2077','1','1434','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2113','1','1407','5','950.00','0.00','2022-05-09 15:27:54','2022-05-09 15:27:54');
INSERT INTO invoice_items VALUES('2106','1','1461','1','16000.00','0.00','2022-05-08 13:38:45','2022-05-08 13:38:45');
INSERT INTO invoice_items VALUES('2105','1','1460','1','16000.00','0.00','2022-05-08 13:38:45','2022-05-08 13:38:45');
INSERT INTO invoice_items VALUES('2081','1','1438','1','17500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2082','1','1439','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2083','1','1440','1','17000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2084','1','1441','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2085','1','1442','1','19000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2086','1','1443','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2087','1','1444','1','16500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2088','1','1445','1','15000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2089','1','1446','1','15500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2090','1','1447','1','15500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2108','1','1354','5','1790.00','0.00','2022-05-08 15:09:50','2022-05-08 15:09:50');
INSERT INTO invoice_items VALUES('2092','1','1449','1','19000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2093','1','1450','1','19000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2094','1','1451','1','16000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2095','1','1452','1','19000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2096','1','1453','1','19000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2118','1','1454','1','17000.00','0.00','2022-05-10 16:55:29','2022-05-10 16:55:29');
INSERT INTO invoice_items VALUES('2098','1','1455','1','19000.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2099','1','1456','1','17500.00','0.00','2022-05-06 13:18:07','2022-05-06 13:18:07');
INSERT INTO invoice_items VALUES('2100','1','1457','5','2345.00','0.00','2022-05-06 15:48:27','2022-05-06 15:48:27');
INSERT INTO invoice_items VALUES('2153','1','1384','1','17000.00','0.00','2022-05-22 07:25:07','2022-05-22 07:25:07');
INSERT INTO invoice_items VALUES('2115','1','1358','5','380.00','0.00','2022-05-09 16:26:58','2022-05-09 16:26:58');
INSERT INTO invoice_items VALUES('2117','1','1383','5','950.00','0.00','2022-05-09 16:45:30','2022-05-09 16:45:30');
INSERT INTO invoice_items VALUES('2121','1','1427','5','480.00','0.00','2022-05-11 16:32:38','2022-05-11 16:32:38');
INSERT INTO invoice_items VALUES('2123','1','1355','5','4920.00','0.00','2022-05-13 14:37:25','2022-05-13 14:37:25');
INSERT INTO invoice_items VALUES('2124','1','1462','5','680.00','0.00','2022-05-13 15:00:48','2022-05-13 15:00:48');
INSERT INTO invoice_items VALUES('2125','1','1463','5','13480.00','0.00','2022-05-13 15:36:37','2022-05-13 15:36:37');
INSERT INTO invoice_items VALUES('2127','1','1433','5','5360.00','0.00','2022-05-14 12:11:08','2022-05-14 12:11:08');
INSERT INTO invoice_items VALUES('2128','1','1464','5','2920.00','0.00','2022-05-14 13:08:08','2022-05-14 13:08:08');
INSERT INTO invoice_items VALUES('2129','1','1465','6','1000.00','0.00','2022-05-15 14:34:17','2022-05-15 14:34:17');
INSERT INTO invoice_items VALUES('2130','1','1466','6','1000.00','0.00','2022-05-15 14:34:42','2022-05-15 14:34:42');
INSERT INTO invoice_items VALUES('2131','1','1467','5','480.00','0.00','2022-05-15 15:50:03','2022-05-15 15:50:03');
INSERT INTO invoice_items VALUES('2132','1','1468','6','10000.00','0.00','2022-05-16 15:16:29','2022-05-16 15:16:29');
INSERT INTO invoice_items VALUES('2133','1','1469','6','10000.00','0.00','2022-05-16 15:17:10','2022-05-16 15:17:10');
INSERT INTO invoice_items VALUES('2135','1','1379','5','1520.00','0.00','2022-05-17 17:13:35','2022-05-17 17:13:35');
INSERT INTO invoice_items VALUES('2137','1','1421','5','1530.00','0.00','2022-05-22 06:31:16','2022-05-22 06:31:16');
INSERT INTO invoice_items VALUES('2138','1','1470','5','1530.00','0.00','2022-05-22 06:32:11','2022-05-22 06:32:11');
INSERT INTO invoice_items VALUES('2139','1','1471','5','1530.00','0.00','2022-05-22 06:32:40','2022-05-22 06:32:40');
INSERT INTO invoice_items VALUES('2140','1','1472','5','1530.00','0.00','2022-05-22 06:33:08','2022-05-22 06:33:08');
INSERT INTO invoice_items VALUES('2142','1','1357','5','380.00','0.00','2022-05-22 06:37:36','2022-05-22 06:37:36');
INSERT INTO invoice_items VALUES('2143','1','1473','5','380.00','0.00','2022-05-22 06:38:15','2022-05-22 06:38:15');
INSERT INTO invoice_items VALUES('2144','1','1474','5','380.00','0.00','2022-05-22 06:38:45','2022-05-22 06:38:45');
INSERT INTO invoice_items VALUES('2145','1','1475','5','380.00','0.00','2022-05-22 06:39:17','2022-05-22 06:39:17');
INSERT INTO invoice_items VALUES('2146','1','1476','5','480.00','0.00','2022-05-22 06:45:26','2022-05-22 06:45:26');
INSERT INTO invoice_items VALUES('2147','1','1477','5','480.00','0.00','2022-05-22 06:45:58','2022-05-22 06:45:58');
INSERT INTO invoice_items VALUES('2149','1','1412','5','1520.00','0.00','2022-05-22 06:50:09','2022-05-22 06:50:09');
INSERT INTO invoice_items VALUES('2150','1','1478','1','5000.00','0.00','2022-05-22 06:55:57','2022-05-22 06:55:57');
INSERT INTO invoice_items VALUES('2151','1','1479','1','15600.00','0.00','2022-05-22 07:11:12','2022-05-22 07:11:12');
INSERT INTO invoice_items VALUES('2152','1','1480','4','500.00','0.00','2022-05-22 07:16:56','2022-05-22 07:16:56');
INSERT INTO invoice_items VALUES('2155','1','1481','5','950.00','0.00','2022-05-22 07:26:00','2022-05-22 07:26:00');
INSERT INTO invoice_items VALUES('2156','1','1482','5','160.00','0.00','2022-05-22 07:27:32','2022-05-22 07:27:32');
INSERT INTO invoice_items VALUES('2157','1','1483','5','160.00','0.00','2022-05-22 07:27:53','2022-05-22 07:27:53');
INSERT INTO invoice_items VALUES('2158','1','1484','5','160.00','0.00','2022-05-22 07:28:42','2022-05-22 07:28:42');
INSERT INTO invoice_items VALUES('2159','1','1485','5','160.00','0.00','2022-05-22 07:29:04','2022-05-22 07:29:04');
INSERT INTO invoice_items VALUES('2161','1','1487','5','300.00','0.00','2022-05-22 07:37:22','2022-05-22 07:37:22');
INSERT INTO invoice_items VALUES('2162','1','1488','5','300.00','0.00','2022-05-22 07:37:44','2022-05-22 07:37:44');
INSERT INTO invoice_items VALUES('2163','1','1489','5','300.00','0.00','2022-05-22 07:38:12','2022-05-22 07:38:12');
INSERT INTO invoice_items VALUES('2165','1','1491','5','240.00','0.00','2022-05-22 07:47:00','2022-05-22 07:47:00');
INSERT INTO invoice_items VALUES('2167','1','1492','6','6000.00','0.00','2022-05-31 13:34:53','2022-05-31 13:34:53');
INSERT INTO invoice_items VALUES('2168','1','1493','6','6000.00','0.00','2022-05-31 13:35:25','2022-05-31 13:35:25');
INSERT INTO invoice_items VALUES('2169','1','1494','6','6000.00','0.00','2022-05-31 13:35:49','2022-05-31 13:35:49');
INSERT INTO invoice_items VALUES('2170','1','1495','2','10000.00','0.00','2022-05-31 13:58:25','2022-05-31 13:58:25');
INSERT INTO invoice_items VALUES('2171','1','1496','2','10000.00','0.00','2022-05-31 13:58:58','2022-05-31 13:58:58');
INSERT INTO invoice_items VALUES('2172','1','1497','2','10000.00','0.00','2022-05-31 13:59:35','2022-05-31 13:59:35');
INSERT INTO invoice_items VALUES('2173','1','1498','2','10000.00','0.00','2022-05-31 14:00:43','2022-05-31 14:00:43');
INSERT INTO invoice_items VALUES('2174','1','1499','1','17000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2175','1','1500','1','10000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2328','1','1501','1','16000.00','6400.00','2022-06-06 17:29:58','2022-06-06 17:29:58');
INSERT INTO invoice_items VALUES('2314','1','1502','1','16000.00','6400.00','2022-06-06 15:51:53','2022-06-06 15:51:53');
INSERT INTO invoice_items VALUES('2178','1','1503','1','24000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2179','1','1504','1','17500.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2180','1','1505','1','18000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2181','1','1506','1','20000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2182','1','1507','1','17000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2339','1','1508','1','17000.00','0.00','2022-06-07 14:50:59','2022-06-07 14:50:59');
INSERT INTO invoice_items VALUES('2374','1','1509','1','17000.00','0.00','2022-06-10 16:50:21','2022-06-10 16:50:21');
INSERT INTO invoice_items VALUES('2185','1','1510','1','17000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2298','1','1511','1','19000.00','0.00','2022-06-05 15:26:27','2022-06-05 15:26:27');
INSERT INTO invoice_items VALUES('2337','1','1512','1','20000.00','0.00','2022-06-07 14:14:32','2022-06-07 14:14:32');
INSERT INTO invoice_items VALUES('2188','1','1513','1','20000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2398','1','1514','1','15500.00','0.00','2022-06-23 15:12:32','2022-06-23 15:12:32');
INSERT INTO invoice_items VALUES('2288','1','1515','1','15500.00','0.00','2022-06-02 13:29:58','2022-06-02 13:29:58');
INSERT INTO invoice_items VALUES('2370','1','1516','1','15500.00','0.00','2022-06-10 16:27:22','2022-06-10 16:27:22');
INSERT INTO invoice_items VALUES('2326','1','1517','1','16000.00','0.00','2022-06-06 17:15:17','2022-06-06 17:15:17');
INSERT INTO invoice_items VALUES('2193','1','1518','1','16000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2307','1','1519','1','16000.00','0.00','2022-06-06 14:53:29','2022-06-06 14:53:29');
INSERT INTO invoice_items VALUES('2335','1','1520','1','17000.00','0.00','2022-06-07 14:07:31','2022-06-07 14:07:31');
INSERT INTO invoice_items VALUES('2309','1','1521','1','17000.00','0.00','2022-06-06 15:10:38','2022-06-06 15:10:38');
INSERT INTO invoice_items VALUES('2292','1','1522','1','16000.00','0.00','2022-06-03 16:41:00','2022-06-03 16:41:00');
INSERT INTO invoice_items VALUES('2198','1','1523','1','17500.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2199','1','1524','1','14000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2373','1','1525','5','4980.00','0.00','2022-06-10 16:30:36','2022-06-10 16:30:36');
INSERT INTO invoice_items VALUES('2318','1','1526','1','17500.00','0.00','2022-06-06 15:57:25','2022-06-06 15:57:25');
INSERT INTO invoice_items VALUES('2322','1','1527','1','17500.00','0.00','2022-06-06 15:58:33','2022-06-06 15:58:33');
INSERT INTO invoice_items VALUES('2324','1','1528','1','17500.00','0.00','2022-06-06 15:59:05','2022-06-06 15:59:05');
INSERT INTO invoice_items VALUES('2204','1','1529','1','17000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2205','1','1530','1','17000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2206','1','1531','1','17000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2207','1','1532','1','17000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2208','1','1533','1','13000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2209','1','1534','1','13000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2210','1','1535','1','13000.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2389','1','1536','1','22000.00','0.00','2022-06-20 17:10:02','2022-06-20 17:10:02');
INSERT INTO invoice_items VALUES('2385','1','1623','5','520.00','0.00','2022-06-14 12:03:51','2022-06-14 12:03:51');
INSERT INTO invoice_items VALUES('2363','1','1538','5','520.00','0.00','2022-06-10 12:58:18','2022-06-10 12:58:18');
INSERT INTO invoice_items VALUES('2214','1','1539','1','17500.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2215','1','1540','1','17500.00','0.00','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoice_items VALUES('2303','1','1541','1','17000.00','0.00','2022-06-05 17:34:36','2022-06-05 17:34:36');
INSERT INTO invoice_items VALUES('2217','1','1542','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2218','1','1543','1','14000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2219','1','1544','1','17500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2220','1','1545','1','17500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2352','1','1546','1','17500.00','0.00','2022-06-10 12:26:41','2022-06-10 12:26:41');
INSERT INTO invoice_items VALUES('2354','1','1547','1','17500.00','0.00','2022-06-10 12:27:53','2022-06-10 12:27:53');
INSERT INTO invoice_items VALUES('2356','1','1548','1','17500.00','0.00','2022-06-10 12:28:52','2022-06-10 12:28:52');
INSERT INTO invoice_items VALUES('2224','1','1549','1','14000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2225','1','1550','1','16500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2226','1','1551','1','18000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2227','1','1552','1','17500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2295','1','1553','1','19000.00','0.00','2022-06-04 17:13:14','2022-06-04 17:13:14');
INSERT INTO invoice_items VALUES('2229','1','1554','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2230','1','1555','1','18000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2231','1','1556','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2232','1','1557','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2233','1','1558','1','14000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2234','1','1559','1','14000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2358','1','1560','1','17500.00','0.00','2022-06-10 12:30:19','2022-06-10 12:30:19');
INSERT INTO invoice_items VALUES('2301','1','1561','1','19000.00','0.00','2022-06-05 16:59:42','2022-06-05 16:59:42');
INSERT INTO invoice_items VALUES('2237','1','1562','1','15500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2344','1','1563','1','17000.00','0.00','2022-06-07 16:44:57','2022-06-07 16:44:57');
INSERT INTO invoice_items VALUES('2381','1','1564','1','21000.00','0.00','2022-06-13 13:38:23','2022-06-13 13:38:23');
INSERT INTO invoice_items VALUES('2376','1','1565','1','17000.00','0.00','2022-06-10 16:51:47','2022-06-10 16:51:47');
INSERT INTO invoice_items VALUES('2241','1','1566','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2242','1','1567','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2390','1','1536','5','4940.00','0.00','2022-06-20 17:10:02','2022-06-20 17:10:02');
INSERT INTO invoice_items VALUES('2244','1','1569','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2245','1','1570','1','19500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2297','1','1613','5','1540.00','0.00','2022-06-04 17:35:15','2022-06-04 17:35:15');
INSERT INTO invoice_items VALUES('2247','1','1572','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2248','1','1573','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2341','1','1574','1','17000.00','0.00','2022-06-07 16:21:01','2022-06-07 16:21:01');
INSERT INTO invoice_items VALUES('2384','1','1622','1','22000.00','0.00','2022-06-13 14:55:46','2022-06-13 14:55:46');
INSERT INTO invoice_items VALUES('2311','1','1576','1','17000.00','0.00','2022-06-06 15:13:14','2022-06-06 15:13:14');
INSERT INTO invoice_items VALUES('2252','1','1577','1','17500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2253','1','1578','1','18000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2254','1','1579','1','17500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2348','1','1580','1','17000.00','0.00','2022-06-07 17:09:08','2022-06-07 17:09:08');
INSERT INTO invoice_items VALUES('2392','1','1581','1','16000.00','6400.00','2022-06-22 12:57:00','2022-06-22 12:57:00');
INSERT INTO invoice_items VALUES('2257','1','1582','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2258','1','1583','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2259','1','1584','1','22000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2386','1','1585','1','22000.00','0.00','2022-06-14 12:41:45','2022-06-14 12:41:45');
INSERT INTO invoice_items VALUES('2261','1','1586','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2262','1','1587','1','16000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2263','1','1588','1','16000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2264','1','1589','1','16000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2265','1','1590','1','17500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2266','1','1591','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2267','1','1592','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2268','1','1593','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2366','1','1594','1','19000.00','0.00','2022-06-10 16:22:55','2022-06-10 16:22:55');
INSERT INTO invoice_items VALUES('2270','1','1595','1','15000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2334','1','1596','5','1920.00','0.00','2022-06-06 18:15:10','2022-06-06 18:15:10');
INSERT INTO invoice_items VALUES('2364','1','1597','1','15000.00','0.00','2022-06-10 16:18:16','2022-06-10 16:18:16');
INSERT INTO invoice_items VALUES('2368','1','1598','1','15500.00','0.00','2022-06-10 16:25:39','2022-06-10 16:25:39');
INSERT INTO invoice_items VALUES('2290','1','1599','1','15500.00','0.00','2022-06-02 14:13:59','2022-06-02 14:13:59');
INSERT INTO invoice_items VALUES('2275','1','1600','1','16000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2382','1','1601','1','19000.00','0.00','2022-06-13 13:54:04','2022-06-13 13:54:04');
INSERT INTO invoice_items VALUES('2305','1','1602','1','19000.00','0.00','2022-06-06 11:49:50','2022-06-06 11:49:50');
INSERT INTO invoice_items VALUES('2278','1','1603','1','16000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2279','1','1604','1','19000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2280','1','1605','1','19000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2347','1','1606','1','17000.00','0.00','2022-06-07 16:59:30','2022-06-07 16:59:30');
INSERT INTO invoice_items VALUES('2282','1','1607','1','19000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2283','1','1608','1','17500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2284','1','1609','1','17000.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2346','1','1610','1','15500.00','0.00','2022-06-07 16:50:20','2022-06-07 16:50:20');
INSERT INTO invoice_items VALUES('2286','1','1611','1','15500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2287','1','1612','1','15500.00','0.00','2022-06-01 14:35:54','2022-06-01 14:35:54');
INSERT INTO invoice_items VALUES('2291','1','1599','5','820.00','0.00','2022-06-02 14:13:59','2022-06-02 14:13:59');
INSERT INTO invoice_items VALUES('2293','1','1522','5','300.00','0.00','2022-06-03 16:41:00','2022-06-03 16:41:00');
INSERT INTO invoice_items VALUES('2296','1','1553','5','1540.00','0.00','2022-06-04 17:13:14','2022-06-04 17:13:14');
INSERT INTO invoice_items VALUES('2299','1','1511','5','1120.00','0.00','2022-06-05 15:26:27','2022-06-05 15:26:27');
INSERT INTO invoice_items VALUES('2300','1','1614','5','520.00','0.00','2022-06-05 16:02:10','2022-06-05 16:02:10');
INSERT INTO invoice_items VALUES('2302','1','1561','5','800.00','0.00','2022-06-05 16:59:42','2022-06-05 16:59:42');
INSERT INTO invoice_items VALUES('2304','1','1541','5','1500.00','0.00','2022-06-05 17:34:36','2022-06-05 17:34:36');
INSERT INTO invoice_items VALUES('2306','1','1602','5','520.00','0.00','2022-06-06 11:49:50','2022-06-06 11:49:50');
INSERT INTO invoice_items VALUES('2308','1','1519','5','500.00','0.00','2022-06-06 14:53:29','2022-06-06 14:53:29');
INSERT INTO invoice_items VALUES('2310','1','1521','5','600.00','0.00','2022-06-06 15:10:38','2022-06-06 15:10:38');
INSERT INTO invoice_items VALUES('2312','1','1576','5','600.00','0.00','2022-06-06 15:13:14','2022-06-06 15:13:14');
INSERT INTO invoice_items VALUES('2313','1','1615','5','2930.00','0.00','2022-06-06 15:45:26','2022-06-06 15:45:26');
INSERT INTO invoice_items VALUES('2315','1','1502','5','1920.00','0.00','2022-06-06 15:51:53','2022-06-06 15:51:53');
INSERT INTO invoice_items VALUES('2319','1','1526','5','4980.00','0.00','2022-06-06 15:57:25','2022-06-06 15:57:25');
INSERT INTO invoice_items VALUES('2372','1','1525','1','17500.00','0.00','2022-06-10 16:30:36','2022-06-10 16:30:36');
INSERT INTO invoice_items VALUES('2323','1','1527','5','4980.00','0.00','2022-06-06 15:58:33','2022-06-06 15:58:33');
INSERT INTO invoice_items VALUES('2325','1','1528','5','4980.00','0.00','2022-06-06 15:59:05','2022-06-06 15:59:05');
INSERT INTO invoice_items VALUES('2327','1','1517','5','500.00','0.00','2022-06-06 17:15:17','2022-06-06 17:15:17');
INSERT INTO invoice_items VALUES('2329','1','1501','5','1920.00','0.00','2022-06-06 17:29:58','2022-06-06 17:29:58');
INSERT INTO invoice_items VALUES('2333','1','1596','1','16500.00','0.00','2022-06-06 18:15:10','2022-06-06 18:15:10');
INSERT INTO invoice_items VALUES('2336','1','1520','5','600.00','0.00','2022-06-07 14:07:31','2022-06-07 14:07:31');
INSERT INTO invoice_items VALUES('2338','1','1512','5','6880.00','0.00','2022-06-07 14:14:32','2022-06-07 14:14:32');
INSERT INTO invoice_items VALUES('2340','1','1508','5','900.00','0.00','2022-06-07 14:50:59','2022-06-07 14:50:59');
INSERT INTO invoice_items VALUES('2342','1','1574','5','900.00','0.00','2022-06-07 16:21:01','2022-06-07 16:21:01');
INSERT INTO invoice_items VALUES('2343','1','1616','5','900.00','0.00','2022-06-07 16:22:38','2022-06-07 16:22:38');
INSERT INTO invoice_items VALUES('2345','1','1563','5','2930.00','0.00','2022-06-07 16:44:57','2022-06-07 16:44:57');
INSERT INTO invoice_items VALUES('2349','1','1580','5','900.00','0.00','2022-06-07 17:09:08','2022-06-07 17:09:08');
INSERT INTO invoice_items VALUES('2350','1','1617','1','17000.00','0.00','2022-06-10 12:19:39','2022-06-10 12:19:39');
INSERT INTO invoice_items VALUES('2401','1','1618','4','17000.00','5000.00','2022-06-27 12:26:30','2022-06-27 12:26:30');
INSERT INTO invoice_items VALUES('2353','1','1546','5','730.00','0.00','2022-06-10 12:26:41','2022-06-10 12:26:41');
INSERT INTO invoice_items VALUES('2355','1','1547','5','730.00','0.00','2022-06-10 12:27:53','2022-06-10 12:27:53');
INSERT INTO invoice_items VALUES('2357','1','1548','5','730.00','0.00','2022-06-10 12:28:52','2022-06-10 12:28:52');
INSERT INTO invoice_items VALUES('2359','1','1560','5','730.00','0.00','2022-06-10 12:30:19','2022-06-10 12:30:19');
INSERT INTO invoice_items VALUES('2362','1','1538','1','17500.00','0.00','2022-06-10 12:58:18','2022-06-10 12:58:18');
INSERT INTO invoice_items VALUES('2365','1','1597','5','1340.00','0.00','2022-06-10 16:18:16','2022-06-10 16:18:16');
INSERT INTO invoice_items VALUES('2367','1','1594','5','800.00','0.00','2022-06-10 16:22:55','2022-06-10 16:22:55');
INSERT INTO invoice_items VALUES('2369','1','1598','5','820.00','0.00','2022-06-10 16:25:39','2022-06-10 16:25:39');
INSERT INTO invoice_items VALUES('2371','1','1516','5','820.00','0.00','2022-06-10 16:27:22','2022-06-10 16:27:22');
INSERT INTO invoice_items VALUES('2375','1','1509','6','5000.00','0.00','2022-06-10 16:50:21','2022-06-10 16:50:21');
INSERT INTO invoice_items VALUES('2377','1','1565','6','5000.00','0.00','2022-06-10 16:51:47','2022-06-10 16:51:47');
INSERT INTO invoice_items VALUES('2378','1','1619','6','5000.00','0.00','2022-06-12 12:37:46','2022-06-12 12:37:46');
INSERT INTO invoice_items VALUES('2379','1','1620','5','5320.00','0.00','2022-06-12 14:41:14','2022-06-12 14:41:14');
INSERT INTO invoice_items VALUES('2380','1','1621','5','520.00','0.00','2022-06-12 17:02:15','2022-06-12 17:02:15');
INSERT INTO invoice_items VALUES('2383','1','1601','5','500.00','0.00','2022-06-13 13:54:04','2022-06-13 13:54:04');
INSERT INTO invoice_items VALUES('2387','1','1585','5','6760.00','0.00','2022-06-14 12:41:45','2022-06-14 12:41:45');
INSERT INTO invoice_items VALUES('2388','1','1624','6','5000.00','0.00','2022-06-14 12:44:10','2022-06-14 12:44:10');
INSERT INTO invoice_items VALUES('2391','1','1625','5','2480.00','0.00','2022-06-20 17:14:39','2022-06-20 17:14:39');
INSERT INTO invoice_items VALUES('2393','1','1581','5','1920.00','0.00','2022-06-22 12:57:00','2022-06-22 12:57:00');
INSERT INTO invoice_items VALUES('2394','1','1626','2','8000.00','0.00','2022-06-22 14:14:40','2022-06-22 14:14:40');
INSERT INTO invoice_items VALUES('2395','1','1627','2','17500.00','0.00','2022-06-22 15:03:03','2022-06-22 15:03:03');
INSERT INTO invoice_items VALUES('2396','1','1628','2','17000.00','0.00','2022-06-22 15:03:40','2022-06-22 15:03:40');
INSERT INTO invoice_items VALUES('2397','1','1629','5','500.00','0.00','2022-06-23 14:46:28','2022-06-23 14:46:28');
INSERT INTO invoice_items VALUES('2399','1','1514','5','820.00','0.00','2022-06-23 15:12:32','2022-06-23 15:12:32');
INSERT INTO invoice_items VALUES('2400','1','1630','1','15000.00','0.00','2022-06-23 16:55:52','2022-06-23 16:55:52');
INSERT INTO invoice_items VALUES('2402','1','1631','1','17000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2403','1','1632','1','10000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2404','1','1633','1','24000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2560','1','1634','1','17500.00','0.00','2022-07-05 14:18:24','2022-07-05 14:18:24');
INSERT INTO invoice_items VALUES('2406','1','1635','1','18000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2407','1','1636','1','20000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2583','1','1637','5','4633.00','0.00','2022-07-07 10:47:57','2022-07-07 10:47:57');
INSERT INTO invoice_items VALUES('2518','1','1638','1','17000.00','8500.00','2022-07-03 14:13:13','2022-07-03 14:13:13');
INSERT INTO invoice_items VALUES('2589','1','1639','1','17000.00','8500.00','2022-07-07 10:50:44','2022-07-07 10:50:44');
INSERT INTO invoice_items VALUES('2411','1','1640','1','17000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2412','1','1641','1','19000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2413','1','1642','1','20000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2414','1','1643','1','20000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2415','1','1644','1','15500.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2516','1','1645','1','15500.00','0.00','2022-07-03 14:09:27','2022-07-03 14:09:27');
INSERT INTO invoice_items VALUES('2514','1','1646','1','15500.00','0.00','2022-07-03 14:03:07','2022-07-03 14:03:07');
INSERT INTO invoice_items VALUES('2418','1','1647','1','16000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2419','1','1648','1','16000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2420','1','1649','1','17000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2421','1','1650','1','17000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2422','1','1651','1','16000.00','0.00','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoice_items VALUES('2520','1','1652','1','17500.00','0.00','2022-07-03 15:19:40','2022-07-03 15:19:40');
INSERT INTO invoice_items VALUES('2424','1','1653','1','14000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2573','1','1654','1','17500.00','0.00','2022-07-07 10:06:45','2022-07-07 10:06:45');
INSERT INTO invoice_items VALUES('2533','1','1655','1','17500.00','0.00','2022-07-04 15:37:46','2022-07-04 15:37:46');
INSERT INTO invoice_items VALUES('2531','1','1656','1','17500.00','0.00','2022-07-04 15:05:25','2022-07-04 15:05:25');
INSERT INTO invoice_items VALUES('2527','1','1657','1','17500.00','0.00','2022-07-04 12:31:01','2022-07-04 12:31:01');
INSERT INTO invoice_items VALUES('2513','1','1658','1','17000.00','8500.00','2022-07-03 13:58:56','2022-07-03 13:58:56');
INSERT INTO invoice_items VALUES('2591','1','1659','1','17000.00','8500.00','2022-07-07 10:51:19','2022-07-07 10:51:19');
INSERT INTO invoice_items VALUES('2593','1','1660','1','17000.00','0.00','2022-07-07 10:55:00','2022-07-07 10:55:00');
INSERT INTO invoice_items VALUES('2548','1','1661','1','17000.00','2000.00','2022-07-05 14:06:37','2022-07-05 14:06:37');
INSERT INTO invoice_items VALUES('2433','1','1662','1','13000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2434','1','1663','1','13000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2435','1','1664','1','13000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2535','1','1665','1','22000.00','0.00','2022-07-04 15:41:40','2022-07-04 15:41:40');
INSERT INTO invoice_items VALUES('2522','1','1666','1','17500.00','0.00','2022-07-03 16:58:26','2022-07-03 16:58:26');
INSERT INTO invoice_items VALUES('2438','1','1667','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2578','1','1668','1','17500.00','0.00','2022-07-07 10:43:38','2022-07-07 10:43:38');
INSERT INTO invoice_items VALUES('2511','1','1669','1','17000.00','8500.00','2022-07-03 13:57:41','2022-07-03 13:57:41');
INSERT INTO invoice_items VALUES('2441','1','1670','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2577','1','1671','1','14000.00','7000.00','2022-07-07 10:41:51','2022-07-07 10:41:51');
INSERT INTO invoice_items VALUES('2443','1','1672','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2575','1','1673','1','17500.00','0.00','2022-07-07 10:40:03','2022-07-07 10:40:03');
INSERT INTO invoice_items VALUES('2445','1','1674','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2446','1','1675','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2544','1','1676','1','17500.00','0.00','2022-07-05 14:01:58','2022-07-05 14:01:58');
INSERT INTO invoice_items VALUES('2448','1','1677','1','14000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2449','1','1678','1','16500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2450','1','1679','1','18000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2451','1','1680','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2550','1','1681','1','19000.00','0.00','2022-07-05 14:08:52','2022-07-05 14:08:52');
INSERT INTO invoice_items VALUES('2453','1','1682','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2541','1','1683','1','17000.00','0.00','2022-07-05 13:56:29','2022-07-05 13:56:29');
INSERT INTO invoice_items VALUES('2455','1','1684','1','18000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2456','1','1685','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2457','1','1686','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2566','1','1687','1','14000.00','7000.00','2022-07-05 15:34:14','2022-07-05 15:34:14');
INSERT INTO invoice_items VALUES('2459','1','1688','1','14000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2460','1','1689','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2562','1','1690','1','19000.00','0.00','2022-07-05 14:19:54','2022-07-05 14:19:54');
INSERT INTO invoice_items VALUES('2462','1','1691','1','15500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2546','1','1692','1','17000.00','8500.00','2022-07-05 14:04:47','2022-07-05 14:04:47');
INSERT INTO invoice_items VALUES('2464','1','1693','1','24000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2587','1','1694','1','17000.00','8500.00','2022-07-07 10:50:06','2022-07-07 10:50:06');
INSERT INTO invoice_items VALUES('2585','1','1695','1','17000.00','8500.00','2022-07-07 10:49:30','2022-07-07 10:49:30');
INSERT INTO invoice_items VALUES('2467','1','1696','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2468','1','1697','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2469','1','1698','1','19500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2595','1','1699','1','17000.00','8500.00','2022-07-07 11:02:20','2022-07-07 11:02:20');
INSERT INTO invoice_items VALUES('2471','1','1700','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2472','1','1701','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2473','1','1702','1','22000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2474','1','1703','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2475','1','1704','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2476','1','1705','1','18000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2477','1','1706','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2571','1','1707','1','17000.00','0.00','2022-07-05 16:16:37','2022-07-05 16:16:37');
INSERT INTO invoice_items VALUES('2479','1','1708','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2480','1','1709','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2481','1','1710','1','22000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2482','1','1711','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2483','1','1712','1','16000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2484','1','1713','1','16000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2485','1','1714','1','16000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2569','1','1715','1','17500.00','0.00','2022-07-05 16:05:36','2022-07-05 16:05:36');
INSERT INTO invoice_items VALUES('2487','1','1716','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2526','1','1717','1','17000.00','8500.00','2022-07-04 12:29:12','2022-07-04 12:29:12');
INSERT INTO invoice_items VALUES('2489','1','1718','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2529','1','1719','1','19000.00','0.00','2022-07-04 12:58:58','2022-07-04 12:58:58');
INSERT INTO invoice_items VALUES('2491','1','1720','1','15000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2556','1','1721','1','16500.00','8250.00','2022-07-05 14:14:31','2022-07-05 14:14:31');
INSERT INTO invoice_items VALUES('2567','1','1722','1','15000.00','0.00','2022-07-05 16:02:07','2022-07-05 16:02:07');
INSERT INTO invoice_items VALUES('2494','1','1723','1','15500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2564','1','1724','1','15500.00','7750.00','2022-07-05 15:31:09','2022-07-05 15:31:09');
INSERT INTO invoice_items VALUES('2496','1','1725','1','16000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2537','1','1726','1','19000.00','0.00','2022-07-05 13:42:45','2022-07-05 13:42:45');
INSERT INTO invoice_items VALUES('2498','1','1727','1','19000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2499','1','1728','1','16000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2540','1','1740','1','17500.00','8750.00','2022-07-05 13:54:26','2022-07-05 13:54:26');
INSERT INTO invoice_items VALUES('2501','1','1730','1','19000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2558','1','1731','1','16500.00','8250.00','2022-07-05 14:15:08','2022-07-05 14:15:08');
INSERT INTO invoice_items VALUES('2503','1','1732','1','19000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2504','1','1733','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2552','1','1734','1','16500.00','8250.00','2022-07-05 14:12:35','2022-07-05 14:12:35');
INSERT INTO invoice_items VALUES('2543','1','1735','1','17000.00','8500.00','2022-07-05 14:00:18','2022-07-05 14:00:18');
INSERT INTO invoice_items VALUES('2554','1','1736','1','16500.00','8250.00','2022-07-05 14:13:16','2022-07-05 14:13:16');
INSERT INTO invoice_items VALUES('2524','1','1737','1','16500.00','8250.00','2022-07-03 17:42:42','2022-07-03 17:42:42');
INSERT INTO invoice_items VALUES('2509','1','1738','1','17000.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2510','1','1739','1','17500.00','0.00','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoice_items VALUES('2512','1','1669','5','4633.00','0.00','2022-07-03 13:57:41','2022-07-03 13:57:41');
INSERT INTO invoice_items VALUES('2515','1','1646','5','1060.00','0.00','2022-07-03 14:03:07','2022-07-03 14:03:07');
INSERT INTO invoice_items VALUES('2517','1','1645','5','1060.00','0.00','2022-07-03 14:09:27','2022-07-03 14:09:27');
INSERT INTO invoice_items VALUES('2519','1','1638','5','290.00','0.00','2022-07-03 14:13:13','2022-07-03 14:13:13');
INSERT INTO invoice_items VALUES('2521','1','1652','5','450.00','0.00','2022-07-03 15:19:40','2022-07-03 15:19:40');
INSERT INTO invoice_items VALUES('2523','1','1666','5','450.00','0.00','2022-07-03 16:58:26','2022-07-03 16:58:26');
INSERT INTO invoice_items VALUES('2525','1','1737','5','700.00','0.00','2022-07-03 17:42:42','2022-07-03 17:42:42');
INSERT INTO invoice_items VALUES('2528','1','1657','5','6580.00','0.00','2022-07-04 12:31:01','2022-07-04 12:31:01');
INSERT INTO invoice_items VALUES('2530','1','1719','5','4200.00','0.00','2022-07-04 12:58:58','2022-07-04 12:58:58');
INSERT INTO invoice_items VALUES('2532','1','1656','5','6580.00','0.00','2022-07-04 15:05:25','2022-07-04 15:05:25');
INSERT INTO invoice_items VALUES('2534','1','1655','5','6580.00','0.00','2022-07-04 15:37:46','2022-07-04 15:37:46');
INSERT INTO invoice_items VALUES('2536','1','1665','5','3280.00','0.00','2022-07-04 15:41:40','2022-07-04 15:41:40');
INSERT INTO invoice_items VALUES('2538','1','1726','5','3500.00','0.00','2022-07-05 13:42:45','2022-07-05 13:42:45');
INSERT INTO invoice_items VALUES('2542','1','1683','5','8400.00','0.00','2022-07-05 13:56:29','2022-07-05 13:56:29');
INSERT INTO invoice_items VALUES('2545','1','1676','5','500.00','0.00','2022-07-05 14:01:58','2022-07-05 14:01:58');
INSERT INTO invoice_items VALUES('2547','1','1692','5','4635.00','0.00','2022-07-05 14:04:47','2022-07-05 14:04:47');
INSERT INTO invoice_items VALUES('2549','1','1661','5','1330.00','0.00','2022-07-05 14:06:37','2022-07-05 14:06:37');
INSERT INTO invoice_items VALUES('2551','1','1681','5','1910.00','0.00','2022-07-05 14:08:52','2022-07-05 14:08:52');
INSERT INTO invoice_items VALUES('2553','1','1734','5','700.00','0.00','2022-07-05 14:12:35','2022-07-05 14:12:35');
INSERT INTO invoice_items VALUES('2555','1','1736','5','700.00','0.00','2022-07-05 14:13:16','2022-07-05 14:13:16');
INSERT INTO invoice_items VALUES('2557','1','1721','5','700.00','0.00','2022-07-05 14:14:31','2022-07-05 14:14:31');
INSERT INTO invoice_items VALUES('2559','1','1731','5','700.00','0.00','2022-07-05 14:15:08','2022-07-05 14:15:08');
INSERT INTO invoice_items VALUES('2561','1','1634','5','450.00','0.00','2022-07-05 14:18:24','2022-07-05 14:18:24');
INSERT INTO invoice_items VALUES('2563','1','1690','5','4200.00','0.00','2022-07-05 14:19:54','2022-07-05 14:19:54');
INSERT INTO invoice_items VALUES('2565','1','1724','5','1060.00','0.00','2022-07-05 15:31:09','2022-07-05 15:31:09');
INSERT INTO invoice_items VALUES('2568','1','1722','5','1730.00','0.00','2022-07-05 16:02:07','2022-07-05 16:02:07');
INSERT INTO invoice_items VALUES('2570','1','1715','5','1330.00','0.00','2022-07-05 16:05:36','2022-07-05 16:05:36');
INSERT INTO invoice_items VALUES('2572','1','1707','5','290.00','0.00','2022-07-05 16:16:37','2022-07-05 16:16:37');
INSERT INTO invoice_items VALUES('2574','1','1654','5','6580.00','0.00','2022-07-07 10:06:45','2022-07-07 10:06:45');
INSERT INTO invoice_items VALUES('2576','1','1673','5','1310.00','0.00','2022-07-07 10:40:03','2022-07-07 10:40:03');
INSERT INTO invoice_items VALUES('2579','1','1668','5','4633.00','0.00','2022-07-07 10:43:38','2022-07-07 10:43:38');
INSERT INTO invoice_items VALUES('2582','1','1637','1','17000.00','8500.00','2022-07-07 10:47:57','2022-07-07 10:47:57');
INSERT INTO invoice_items VALUES('2584','1','1637','4','2930.00','0.00','2022-07-07 10:47:57','2022-07-07 10:47:57');
INSERT INTO invoice_items VALUES('2586','1','1695','5','1100.00','0.00','2022-07-07 10:49:30','2022-07-07 10:49:30');
INSERT INTO invoice_items VALUES('2588','1','1694','5','1100.00','0.00','2022-07-07 10:50:06','2022-07-07 10:50:06');
INSERT INTO invoice_items VALUES('2590','1','1639','5','1100.00','0.00','2022-07-07 10:50:44','2022-07-07 10:50:44');
INSERT INTO invoice_items VALUES('2592','1','1659','5','1100.00','0.00','2022-07-07 10:51:19','2022-07-07 10:51:19');
INSERT INTO invoice_items VALUES('2594','1','1660','5','1330.00','0.00','2022-07-07 10:55:00','2022-07-07 10:55:00');



DROP TABLE IF EXISTS invoices;

CREATE TABLE `invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `payment_date` datetime DEFAULT NULL,
  `receipt_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(8,2) NOT NULL,
  `paid` decimal(8,2) DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1741 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO invoices VALUES('1','1','109','1','1','1','2021-06-10','2021-10-25 16:48:26','','ARREARS PREVIUOS','','15000.00','15000.00','Paid','2021-06-20 19:47:29','2021-10-25 20:48:26');
INSERT INTO invoices VALUES('2','1','111','1','1','1','2021-06-10','2021-07-08 13:17:42','','ARREARS PREVIOUS','','6500.00','6500.00','Paid','2021-06-20 19:51:52','2021-07-08 17:17:42');
INSERT INTO invoices VALUES('3','1','107','1','1','1','2021-06-10','2021-07-08 12:31:55','','ARREARS PREVIOUS','','10000.00','10000.00','Paid','2021-06-20 19:59:29','2021-07-08 16:31:55');
INSERT INTO invoices VALUES('4','1','108','1','1','1','2021-06-10','2021-06-20 17:11:45','','ARREARS PREVIOUS','','14000.00','14000.00','Paid','2021-06-20 20:02:37','2021-06-20 21:11:45');
INSERT INTO invoices VALUES('5','1','103','1','2','1','2021-06-10','2021-07-17 15:17:49','','ARREARS PREVIOUS','','7000.00','7000.00','Paid','2021-06-20 20:03:27','2021-07-17 19:17:49');
INSERT INTO invoices VALUES('1097','1','2','2','23','1','2022-03-01','2022-03-05 10:18:23','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:34','2022-03-05 15:18:23');
INSERT INTO invoices VALUES('7','1','106','1','4','1','2021-06-10','2021-06-20 17:26:06','','ARREARS PREVIOUS','','10000.00','10000.00','Paid','2021-06-20 20:04:52','2021-06-20 21:26:06');
INSERT INTO invoices VALUES('148','1','81','1','12','1','2021-06-10','2021-06-21 15:53:55','','M/O JUNE','SECURITY','26500.00','26500.00','Paid','2021-06-21 19:50:35','2021-06-21 19:53:55');
INSERT INTO invoices VALUES('9','1','90','2','10','1','2021-06-10','2021-06-21 14:38:54','','ARREARS PREVIOUS','','7250.00','7250.00','Paid','2021-06-20 20:08:49','2021-06-21 18:38:54');
INSERT INTO invoices VALUES('1215','1','178','3','44','1','2022-03-16','2022-03-27 12:39:10','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-27 12:38:15','2022-03-27 12:39:10');
INSERT INTO invoices VALUES('12','1','76','2','14','1','2021-06-10','2022-05-09 16:39:36','','ARREARS PREVIOUS','','6500.00','6500.00','Paid','2021-06-20 20:13:30','2022-05-09 16:39:36');
INSERT INTO invoices VALUES('13','1','75','2','14','1','2021-06-10','2021-08-01 13:21:19','','ARREARS PREVIOUS','','6500.00','6500.00','Paid','2021-06-20 20:14:01','2021-08-01 17:21:19');
INSERT INTO invoices VALUES('14','1','68','1','16','1','2021-06-10','2021-06-21 16:11:14','','ARREARS PREVIOUS','','1000.00','1000.00','Paid','2021-06-20 20:15:33','2021-06-21 20:11:14');
INSERT INTO invoices VALUES('15','1','58','1','17','1','2021-06-10','2021-06-21 16:32:19','','ARREARS PREVIOUS','','8000.00','8000.00','Paid','2021-06-20 20:16:18','2021-06-21 20:32:19');
INSERT INTO invoices VALUES('16','1','67','1','17','1','2021-06-10','2021-07-06 15:18:11','','ARREARS PREVIOUS','','1000.00','1000.00','Paid','2021-06-20 20:17:22','2021-07-06 19:18:11');
INSERT INTO invoices VALUES('17','1','59','2','21','1','2021-06-10','2021-07-10 10:17:46','','ARREARS PREVIOUS','','2000.00','2000.00','Paid','2021-06-20 20:27:15','2021-07-10 14:17:46');
INSERT INTO invoices VALUES('20','1','60','2','22','1','2021-06-10','','','ARREARS PREVIOUS','','2000.00','','Unpaid','2021-06-20 20:30:08','2021-06-20 20:30:08');
INSERT INTO invoices VALUES('21','1','47','3','26','1','2021-06-10','2021-07-17 15:47:14','','ARREARS PREVIOUS','','1000.00','1000.00','Paid','2021-06-20 20:31:12','2021-07-17 19:47:14');
INSERT INTO invoices VALUES('22','1','45','3','26','1','2021-06-10','2021-07-17 15:48:59','','ARREARS PREVIOUS','','8000.00','8000.00','Paid','2021-06-20 20:31:50','2021-07-17 19:48:59');
INSERT INTO invoices VALUES('23','1','31','3','30','1','2021-06-10','2021-07-05 17:43:23','','ARREARS PREVIOUS','','7250.00','7250.00','Paid','2021-06-20 20:33:31','2021-07-05 21:43:23');
INSERT INTO invoices VALUES('24','1','30','3','30','1','2021-06-10','2021-06-25 14:10:35','','ARREARS PREVIOUS','','2750.00','2750.00','Paid','2021-06-20 20:34:24','2021-06-25 18:10:35');
INSERT INTO invoices VALUES('25','1','21','3','30','1','2021-06-10','2021-06-25 14:14:56','','ARREARS PREVIOUS','','7250.00','7250.00','Paid','2021-06-20 20:35:11','2021-06-25 18:14:56');
INSERT INTO invoices VALUES('26','1','17','3','33','1','2021-06-10','2021-07-10 09:56:13','','ARREARS PREVIOUS','','2000.00','2000.00','Paid','2021-06-20 20:36:18','2021-07-10 13:56:13');
INSERT INTO invoices VALUES('27','1','19','3','33','1','2021-06-10','2021-07-10 09:58:48','','ARREARS PREVIOUS','','2000.00','2000.00','Paid','2021-06-20 20:37:19','2021-07-10 13:58:48');
INSERT INTO invoices VALUES('29','1','16','3','34','1','2021-06-10','2021-06-25 14:45:24','','ARREARS PREVIOUS','','9500.00','9500.00','Paid','2021-06-20 20:38:36','2021-06-25 18:45:24');
INSERT INTO invoices VALUES('30','1','22','3','35','1','2021-06-10','2021-07-08 15:18:11','','ARREARS PREVIOUS','','500.00','500.00','Paid','2021-06-20 20:39:18','2021-07-08 19:18:11');
INSERT INTO invoices VALUES('31','1','14','3','37','1','2021-06-10','2021-06-25 14:51:37','','ARREARS PREVIOUS','','31000.00','31000.00','Paid','2021-06-20 20:40:29','2021-06-25 18:51:37');
INSERT INTO invoices VALUES('149','1','114','2','24','1','2021-06-28','2021-06-28 16:58:50','','M/O JUNE','7 DAYS RENT','8500.00','8500.00','Paid','2021-06-28 20:57:18','2021-06-28 20:58:50');
INSERT INTO invoices VALUES('33','1','13','2','39','1','2021-06-10','2021-06-25 14:54:18','','ARREARS PREVIOUS','','5000.00','5000.00','Paid','2021-06-20 20:41:28','2021-06-25 18:54:18');
INSERT INTO invoices VALUES('34','1','10','3','40','1','2021-06-10','2021-06-28 16:05:10','','ARREARS PREVIOUS','','10000.00','10000.00','Paid','2021-06-20 20:43:13','2021-06-28 20:05:10');
INSERT INTO invoices VALUES('35','1','11','3','40','1','2021-06-10','2021-06-28 16:04:49','','ARREARS PREVIOUS','','10000.00','10000.00','Paid','2021-06-20 20:43:45','2021-06-28 20:04:49');
INSERT INTO invoices VALUES('36','1','1','1','9','1','2021-06-10','2021-06-21 14:24:17','','M/O JUNE','MONTHLY RENT','12500.00','12500.00','Paid','2021-06-20 20:45:49','2021-06-21 18:24:17');
INSERT INTO invoices VALUES('37','1','2','2','23','1','2021-06-10','2021-06-25 13:46:13','','M/O JUNE','MONTHLY RENT','17200.00','17200.00','Paid','2021-06-20 20:45:49','2021-06-25 17:46:13');
INSERT INTO invoices VALUES('38','1','3','2','10','1','2021-06-10','2021-06-21 15:39:54','','M/O JUNE','SECURITY','24500.00','24500.00','Paid','2021-06-20 20:45:49','2021-06-21 19:39:54');
INSERT INTO invoices VALUES('39','1','4','1','8','1','2021-06-10','2021-06-21 14:16:13','','M/O JUNE','SECURITY','18000.00','18000.00','Paid','2021-06-20 20:45:49','2021-06-21 18:16:13');
INSERT INTO invoices VALUES('40','1','5','3','30','1','2021-06-10','2021-06-25 14:12:58','','M/O JUNE','MONTHLY RENT','23000.00','23000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:12:58');
INSERT INTO invoices VALUES('41','1','6','3','30','1','2021-06-10','2021-06-25 14:23:16','','M/O JUNE','MONTHLY RENT','23000.00','23000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:23:16');
INSERT INTO invoices VALUES('42','1','7','1','4','1','2021-06-10','2021-07-03 12:26:51','','M/O JUNE','MONTHLY RENT','26500.00','26500.00','Paid','2021-06-20 20:45:49','2021-07-03 16:26:51');
INSERT INTO invoices VALUES('43','1','8','1','4','1','2021-06-10','2021-07-03 12:25:17','','M/O JUNE','MONTHLY RENT','26500.00','26500.00','Paid','2021-06-20 20:45:49','2021-07-03 16:25:17');
INSERT INTO invoices VALUES('44','1','9','2','20','1','2021-06-10','2021-06-25 13:39:32','','M/O JUNE','MONTHLY RENT','35000.00','35000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:39:32');
INSERT INTO invoices VALUES('45','1','10','3','40','1','2021-06-10','2021-06-25 14:55:10','','M/O JUNE','MONTHLY RENT','21000.00','21000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:55:10');
INSERT INTO invoices VALUES('46','1','11','3','40','1','2021-06-10','2021-06-25 14:54:45','','M/O JUNE','MONTHLY RENT','21000.00','21000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:54:45');
INSERT INTO invoices VALUES('47','1','12','2','38','1','2021-06-10','2021-06-25 14:53:14','','M/O JUNE','MONTHLY RENT','8500.00','8500.00','Paid','2021-06-20 20:45:49','2021-06-25 18:53:14');
INSERT INTO invoices VALUES('48','1','13','2','39','1','2021-06-10','2021-06-25 14:53:50','','M/O JUNE','MONTHLY RENT','12000.00','12000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:53:50');
INSERT INTO invoices VALUES('49','1','14','3','37','1','2021-06-10','2021-06-25 14:49:52','','M/O JUNE','MONTHLY RENT','32220.00','32220.00','Paid','2021-06-20 20:45:49','2021-06-25 18:49:52');
INSERT INTO invoices VALUES('50','1','15','1','41','1','2021-06-10','2021-06-25 14:56:12','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:56:12');
INSERT INTO invoices VALUES('51','1','16','3','34','1','2021-06-10','2021-06-25 14:44:59','','M/O JUNE','MONTHLY RENT','19000.00','19000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:44:59');
INSERT INTO invoices VALUES('52','1','17','3','33','1','2021-06-10','2021-06-25 14:40:00','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:40:00');
INSERT INTO invoices VALUES('53','1','18','3','33','1','2021-06-10','2021-06-25 14:41:00','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:41:00');
INSERT INTO invoices VALUES('54','1','19','3','33','1','2021-06-10','2021-06-25 14:40:31','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:40:31');
INSERT INTO invoices VALUES('55','1','20','3','33','1','2021-06-10','2021-07-10 09:50:15','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-07-10 13:50:15');
INSERT INTO invoices VALUES('56','1','21','3','30','1','2021-06-10','2021-06-25 14:14:20','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:14:20');
INSERT INTO invoices VALUES('57','1','22','3','35','1','2021-06-10','2021-07-08 15:18:37','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:49','2021-07-08 19:18:37');
INSERT INTO invoices VALUES('58','1','23','3','36','1','2021-06-10','2021-06-25 14:47:29','','M/O JUNE','MONTHLY RENT','12500.00','12500.00','Paid','2021-06-20 20:45:49','2021-06-25 18:47:29');
INSERT INTO invoices VALUES('59','1','24','3','36','1','2021-06-10','2021-06-25 14:47:06','','M/O JUNE','MONTHLY RENT','12500.00','12500.00','Paid','2021-06-20 20:45:49','2021-06-25 18:47:06');
INSERT INTO invoices VALUES('60','1','25','3','32','1','2021-06-10','2021-06-25 14:38:50','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:38:50');
INSERT INTO invoices VALUES('61','1','26','3','32','1','2021-06-10','2021-06-28 16:42:26','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:49','2021-06-28 20:42:26');
INSERT INTO invoices VALUES('62','1','27','3','32','1','2021-06-10','2021-06-25 14:39:18','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:39:18');
INSERT INTO invoices VALUES('63','1','28','3','34','1','2021-06-10','2021-06-25 14:44:36','','M/O JUNE','MONTHLY RENT','19000.00','19000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:44:36');
INSERT INTO invoices VALUES('64','1','29','3','34','1','2021-06-10','2021-06-25 14:44:07','','M/O JUNE','MONTHLY RENT','19000.00','19000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:44:07');
INSERT INTO invoices VALUES('65','1','30','3','30','1','2021-06-10','2021-06-25 14:09:50','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:09:50');
INSERT INTO invoices VALUES('66','1','31','3','30','1','2021-06-10','2021-06-25 14:08:20','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:08:20');
INSERT INTO invoices VALUES('67','1','32','3','30','1','2021-06-10','2021-06-25 14:25:29','','M/O JUNE','MONTHLY RENT','23000.00','23000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:25:29');
INSERT INTO invoices VALUES('68','1','33','3','29','1','2021-06-10','2021-08-15 12:20:08','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:49','2021-08-15 16:20:08');
INSERT INTO invoices VALUES('69','1','34','3','29','1','2021-06-10','2021-06-25 14:06:50','','M/O JUNE','MONTHLY RENT','14500.00','14500.00','Paid','2021-06-20 20:45:49','2021-06-25 18:06:50');
INSERT INTO invoices VALUES('70','1','35','3','29','1','2021-06-10','2021-06-25 14:05:19','','M/O JUNE','MONTHLY RENT','14500.00','14500.00','Paid','2021-06-20 20:45:49','2021-06-25 18:05:19');
INSERT INTO invoices VALUES('71','1','36','3','29','1','2021-06-10','2021-06-25 14:06:18','','M/O JUNE','MONTHLY RENT','17500.00','17500.00','Paid','2021-06-20 20:45:49','2021-06-25 18:06:18');
INSERT INTO invoices VALUES('72','1','37','3','29','1','2021-06-10','2021-06-25 14:05:53','','M/O JUNE','MONTHLY RENT','17500.00','17500.00','Paid','2021-06-20 20:45:49','2021-06-25 18:05:53');
INSERT INTO invoices VALUES('73','1','38','3','28','1','2021-06-10','2021-06-30 18:53:13','','M/O JUNE','MONTHLY RENT','12000.00','12000.00','Paid','2021-06-20 20:45:49','2021-06-30 22:53:13');
INSERT INTO invoices VALUES('74','1','39','3','28','1','2021-06-10','2021-06-25 14:01:46','','M/O JUNE','MONTHLY RENT','12000.00','12000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:01:46');
INSERT INTO invoices VALUES('75','1','40','3','28','1','2021-06-10','2021-06-25 14:01:20','','M/O JUNE','MONTHLY RENT','12000.00','12000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:01:20');
INSERT INTO invoices VALUES('76','1','41','3','27','1','2021-06-10','2021-06-25 14:00:46','','M/O JUNE','MONTHLY RENT','15000.00','15000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:00:46');
INSERT INTO invoices VALUES('77','1','42','3','27','1','2021-06-10','2021-06-25 14:00:11','','M/O JUNE','MONTHLY RENT','15000.00','15000.00','Paid','2021-06-20 20:45:49','2021-06-25 18:00:11');
INSERT INTO invoices VALUES('490','1','4','1','8','1','2021-10-01','2021-10-06 15:53:56','','M/O OCTOBER','M/O OCTOBER','10000.00','10000.00','Paid','2021-10-03 21:02:36','2021-10-06 19:53:56');
INSERT INTO invoices VALUES('79','1','44','3','26','1','2021-06-10','2021-06-25 13:56:08','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:56:08');
INSERT INTO invoices VALUES('80','1','45','3','26','1','2021-06-10','2021-06-25 13:58:51','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:58:51');
INSERT INTO invoices VALUES('81','1','46','3','26','1','2021-06-10','2021-06-25 13:58:04','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:58:04');
INSERT INTO invoices VALUES('82','1','47','3','26','1','2021-06-10','2021-06-25 13:57:37','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:57:37');
INSERT INTO invoices VALUES('83','1','48','1','16','1','2021-06-10','2021-06-21 16:15:04','','M/O JUNE','MONTHLY RENT','17000.00','17000.00','Paid','2021-06-20 20:45:49','2021-06-21 20:15:04');
INSERT INTO invoices VALUES('84','1','49','2','14','1','2021-06-10','2021-06-21 16:03:39','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:49','2021-06-21 20:03:39');
INSERT INTO invoices VALUES('85','1','50','3','25','1','2021-06-10','2021-06-25 13:49:26','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:49','2021-06-25 17:49:26');
INSERT INTO invoices VALUES('86','1','51','3','25','1','2021-06-10','2021-06-25 13:49:03','','M/O JUNE','MONTHLY RENT','17830.00','17830.00','Paid','2021-06-20 20:45:49','2021-06-25 17:49:03');
INSERT INTO invoices VALUES('87','1','52','3','25','1','2021-06-10','2021-06-25 13:48:38','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:49','2021-06-25 17:48:38');
INSERT INTO invoices VALUES('88','1','53','3','25','1','2021-06-10','2021-06-25 13:48:10','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:49','2021-06-25 17:48:10');
INSERT INTO invoices VALUES('89','1','54','2','23','1','2021-06-10','2021-06-25 13:43:54','','M/O JUNE','MONTHLY RENT','15000.00','15000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:43:54');
INSERT INTO invoices VALUES('90','1','55','2','21','1','2021-06-10','2021-06-25 13:41:39','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:41:39');
INSERT INTO invoices VALUES('91','1','56','1','19','1','2021-06-10','2021-06-25 13:38:11','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:49','2021-06-25 17:38:11');
INSERT INTO invoices VALUES('92','1','57','1','19','1','2021-06-10','2021-06-25 13:33:36','','M/O JUNE','MONTHLY RENT','17000.00','17000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:33:36');
INSERT INTO invoices VALUES('93','1','58','1','17','1','2021-06-10','2021-06-21 16:31:45','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:49','2021-06-21 20:31:45');
INSERT INTO invoices VALUES('94','1','59','2','21','1','2021-06-10','2021-06-25 13:40:34','','M/O JUNE','MONTHLY RENT','17000.00','17000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:40:34');
INSERT INTO invoices VALUES('95','1','60','2','22','1','2021-06-10','2021-06-25 13:43:06','','M/O JUNE','MONTHLY RENT','12000.00','12000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:43:06');
INSERT INTO invoices VALUES('96','1','61','2','22','1','2021-06-10','2021-06-25 13:42:39','','M/O JUNE','MONTHLY RENT','12000.00','12000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:42:39');
INSERT INTO invoices VALUES('97','1','62','2','22','1','2021-06-10','2021-06-25 13:42:13','','M/O JUNE','MONTHLY RENT','12000.00','12000.00','Paid','2021-06-20 20:45:49','2021-06-25 17:42:13');
INSERT INTO invoices VALUES('98','1','63','1','18','1','2021-06-10','2021-06-25 13:31:17','','M/O JUNE','MONTHLY RENT','23000.00','23000.00','Paid','2021-06-20 20:45:50','2021-06-25 17:31:17');
INSERT INTO invoices VALUES('99','1','64','1','18','1','2021-06-10','2021-06-25 13:30:38','','M/O JUNE','MONTHLY RENT','21000.00','21000.00','Paid','2021-06-20 20:45:50','2021-06-25 17:30:38');
INSERT INTO invoices VALUES('100','1','65','1','17','1','2021-06-10','2021-06-25 13:28:27','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:50','2021-06-25 17:28:27');
INSERT INTO invoices VALUES('101','1','66','1','17','1','2021-06-10','2021-06-25 13:27:26','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-25 17:27:26');
INSERT INTO invoices VALUES('102','1','67','1','17','1','2021-06-10','2021-06-21 16:33:40','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:50','2021-06-21 20:33:40');
INSERT INTO invoices VALUES('103','1','68','1','16','1','2021-06-10','2021-06-21 16:10:49','','M/O JUNE','MONTHLY RENT','15000.00','15000.00','Paid','2021-06-20 20:45:50','2021-06-21 20:10:49');
INSERT INTO invoices VALUES('104','1','48','1','16','1','2021-06-10','2021-06-21 16:16:07','','M/O JUNE','MONTHLY RENT','16970.00','16970.00','Paid','2021-06-20 20:45:50','2021-06-21 20:16:07');
INSERT INTO invoices VALUES('105','1','70','1','16','1','2021-06-10','2021-06-21 16:13:58','','M/O JUNE','MONTHLY RENT','17000.00','17000.00','Paid','2021-06-20 20:45:50','2021-06-21 20:13:58');
INSERT INTO invoices VALUES('106','1','71','1','15','1','2021-06-10','2021-06-21 16:09:38','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-21 20:09:38');
INSERT INTO invoices VALUES('107','1','72','1','15','1','2021-06-10','2021-06-21 16:09:13','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-21 20:09:13');
INSERT INTO invoices VALUES('108','1','73','1','15','1','2021-06-10','2021-06-21 16:08:42','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-21 20:08:42');
INSERT INTO invoices VALUES('109','1','71','1','15','1','2021-06-10','2021-06-21 16:08:09','','M/O JUNE','MONTHLY RENT','16900.00','16900.00','Paid','2021-06-20 20:45:50','2021-06-21 20:08:09');
INSERT INTO invoices VALUES('110','1','75','2','14','1','2021-06-10','2021-11-01 12:38:32','','M/O JUNE','MONTHLY RENT','6500.00','6500.00','Paid','2021-06-20 20:45:50','2021-11-01 17:38:32');
INSERT INTO invoices VALUES('111','1','76','2','14','1','2021-06-10','2021-06-21 16:04:48','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:50','2021-06-21 20:04:48');
INSERT INTO invoices VALUES('112','1','77','2','14','1','2021-06-10','2021-06-21 16:06:06','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:50','2021-06-21 20:06:06');
INSERT INTO invoices VALUES('113','1','78','2','13','1','2021-06-10','2021-06-21 15:57:52','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:50','2021-06-21 19:57:52');
INSERT INTO invoices VALUES('114','1','79','2','13','1','2021-06-10','2021-06-21 15:58:43','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:50','2021-06-21 19:58:43');
INSERT INTO invoices VALUES('115','1','80','2','13','1','2021-06-10','2021-06-21 16:01:08','','M/O JUNE','MONTHLY RENT','16900.00','16900.00','Paid','2021-06-20 20:45:50','2021-06-21 20:01:08');
INSERT INTO invoices VALUES('116','1','81','1','12','1','2021-06-10','2021-06-21 15:56:50','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-21 19:56:50');
INSERT INTO invoices VALUES('117','1','82','1','12','1','2021-06-10','2021-06-21 15:55:54','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-21 19:55:54');
INSERT INTO invoices VALUES('118','1','83','1','12','1','2021-06-10','2021-06-21 15:55:19','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-21 19:55:19');
INSERT INTO invoices VALUES('119','1','84','2','11','1','2021-06-10','2021-06-21 15:43:31','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:50','2021-06-21 19:43:31');
INSERT INTO invoices VALUES('120','1','85','2','11','1','2021-06-10','2021-06-21 15:45:43','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:50','2021-06-21 19:45:43');
INSERT INTO invoices VALUES('121','1','86','2','11','1','2021-06-10','2021-06-21 15:46:49','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:50','2021-06-21 19:46:49');
INSERT INTO invoices VALUES('122','1','87','2','11','1','2021-06-10','2021-06-21 15:47:37','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:50','2021-06-21 19:47:37');
INSERT INTO invoices VALUES('123','1','88','2','10','1','2021-06-10','2021-06-21 14:39:33','','M/O JUNE','MONTHLY RENT','14500.00','14500.00','Paid','2021-06-20 20:45:50','2021-06-21 18:39:33');
INSERT INTO invoices VALUES('124','1','89','2','10','1','2021-06-10','2021-07-10 10:24:27','','M/O JUNE','MONTHLY RENT','14500.00','14500.00','Paid','2021-06-20 20:45:50','2021-07-10 14:24:27');
INSERT INTO invoices VALUES('125','1','90','2','10','1','2021-06-10','2021-06-21 14:38:09','','M/O JUNE','MONTHLY RENT','14500.00','14500.00','Paid','2021-06-20 20:45:50','2021-06-21 18:38:09');
INSERT INTO invoices VALUES('126','1','91','1','9','1','2021-06-10','2021-06-21 14:22:02','','M/O JUNE','MONTHLY RENT','28000.00','28000.00','Paid','2021-06-20 20:45:50','2021-06-21 18:22:02');
INSERT INTO invoices VALUES('127','1','92','1','8','1','2021-06-10','2021-06-21 14:07:05','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:50','2021-06-21 18:07:05');
INSERT INTO invoices VALUES('128','1','93','1','8','1','2021-06-10','2021-07-12 15:24:48','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:50','2021-07-12 19:24:48');
INSERT INTO invoices VALUES('129','1','94','1','8','1','2021-06-10','2021-06-21 14:09:19','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:50','2021-06-21 18:09:19');
INSERT INTO invoices VALUES('130','1','95','1','8','1','2021-06-10','2021-06-21 14:10:32','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:50','2021-06-21 18:10:32');
INSERT INTO invoices VALUES('131','1','96','1','7','1','2021-06-10','2021-06-21 14:06:00','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:50','2021-06-21 18:06:00');
INSERT INTO invoices VALUES('132','1','97','1','7','1','2021-06-10','2021-06-21 14:05:03','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:50','2021-06-21 18:05:03');
INSERT INTO invoices VALUES('134','1','99','1','6','1','2021-06-10','2021-06-21 14:01:27','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:50','2021-06-21 18:01:27');
INSERT INTO invoices VALUES('135','1','100','1','5','1','2021-06-10','2021-06-20 17:40:08','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:50','2021-06-20 21:40:08');
INSERT INTO invoices VALUES('136','1','101','1','5','1','2021-06-10','2021-06-20 17:39:22','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:50','2021-06-20 21:39:22');
INSERT INTO invoices VALUES('137','1','103','1','2','1','2021-06-10','2021-06-20 17:15:59','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:50','2021-06-20 21:15:59');
INSERT INTO invoices VALUES('138','1','104','1','3','1','2021-06-10','2021-06-20 17:18:06','','M/O JUNE','MONTHLY RENT','18000.00','18000.00','Paid','2021-06-20 20:45:51','2021-06-20 21:18:06');
INSERT INTO invoices VALUES('139','1','105','1','4','1','2021-06-10','2021-06-20 17:22:47','','M/O JUNE','MONTHLY RENT','16000.00','16000.00','Paid','2021-06-20 20:45:51','2021-06-20 21:22:47');
INSERT INTO invoices VALUES('140','1','106','1','4','1','2021-06-10','2021-06-20 17:25:13','','M/O JUNE','MONTHLY RENT','16500.00','16500.00','Paid','2021-06-20 20:45:51','2021-06-20 21:25:13');
INSERT INTO invoices VALUES('141','1','107','1','1','1','2021-06-10','2021-06-20 17:13:10','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:51','2021-06-20 21:13:10');
INSERT INTO invoices VALUES('142','1','108','1','1','1','2021-06-10','2021-06-20 17:11:10','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:51','2021-06-20 21:11:10');
INSERT INTO invoices VALUES('143','1','109','1','1','1','2021-06-10','2021-06-20 16:50:45','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:51','2021-06-20 20:50:45');
INSERT INTO invoices VALUES('144','1','110','1','1','1','2021-06-10','2021-07-05 15:25:14','','M/O JUNE','MONTHLY RENT','14000.00','14000.00','Paid','2021-06-20 20:45:51','2021-07-05 19:25:14');
INSERT INTO invoices VALUES('145','1','111','1','1','1','2021-06-10','2021-06-20 17:09:28','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:51','2021-06-20 21:09:28');
INSERT INTO invoices VALUES('146','1','112','1','1','1','2021-06-10','2021-06-20 17:12:13','','M/O JUNE','MONTHLY RENT','13000.00','13000.00','Paid','2021-06-20 20:45:51','2021-06-20 21:12:13');
INSERT INTO invoices VALUES('147','1','102','1','5','1','2021-06-10','2021-06-20 17:38:08','','M/O JUNE2021','','19000.00','19000.00','Paid','2021-06-20 21:35:41','2021-06-20 21:38:08');
INSERT INTO invoices VALUES('150','1','116','4','42','1','2021-06-30','2021-06-30 19:14:32','','extra seat payment','','4000.00','4000.00','Paid','2021-06-30 23:13:44','2021-06-30 23:14:32');
INSERT INTO invoices VALUES('152','1','115','1','9','1','2021-07-01','2021-07-08 13:05:56','','M/O JULY','','15000.00','15000.00','Paid','2021-07-01 19:36:25','2021-07-08 17:05:56');
INSERT INTO invoices VALUES('153','1','1','1','9','1','2021-07-01','2021-07-05 16:49:56','','M/O JULY','JULY','15500.00','15500.00','Paid','2021-07-01 19:40:26','2021-07-05 20:49:56');
INSERT INTO invoices VALUES('154','1','2','2','23','1','2021-07-01','2021-07-10 10:21:09','','M/O JULY','JULY','17000.00','17000.00','Paid','2021-07-01 19:40:26','2021-07-10 14:21:09');
INSERT INTO invoices VALUES('156','1','4','1','8','1','2021-07-01','2021-07-08 12:35:40','','M/O JULY','JULY','10000.00','10000.00','Paid','2021-07-01 19:40:26','2021-07-08 16:35:40');
INSERT INTO invoices VALUES('157','1','5','3','30','1','2021-07-01','2021-07-08 12:05:47','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:26','2021-07-08 16:05:47');
INSERT INTO invoices VALUES('158','1','6','3','30','1','2021-07-01','2021-07-03 12:41:14','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:26','2021-07-03 16:41:14');
INSERT INTO invoices VALUES('159','1','9','2','20','1','2021-07-01','2021-07-10 10:14:39','','M/O JULY','JULY','24000.00','24000.00','Paid','2021-07-01 19:40:26','2021-07-10 14:14:39');
INSERT INTO invoices VALUES('1335','1','174','3','30','1','2022-04-01','2022-04-24 10:32:35','','M/O APRIL','','16500.00','16500.00','Paid','2022-04-24 10:31:50','2022-04-24 10:32:35');
INSERT INTO invoices VALUES('161','1','11','3','40','1','2021-07-01','2021-08-15 12:57:45','','M/O JULY','JULY','21280.00','21280.00','Paid','2021-07-01 19:40:26','2021-08-15 16:57:45');
INSERT INTO invoices VALUES('162','1','12','2','38','1','2021-07-01','2021-07-10 11:02:14','','M/O JULY','JULY','17000.00','17000.00','Paid','2021-07-01 19:40:26','2021-07-10 15:02:14');
INSERT INTO invoices VALUES('163','1','13','2','39','1','2021-07-01','2021-07-10 11:03:15','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:26','2021-07-10 15:03:15');
INSERT INTO invoices VALUES('164','1','14','3','37','1','2021-07-01','2021-10-06 14:00:58','','M/O JULY','JULY','31490.00','31490.00','Paid','2021-07-01 19:40:26','2021-10-06 18:00:58');
INSERT INTO invoices VALUES('165','1','15','1','41','1','2021-07-01','2021-07-06 16:01:01','','M/O JULY','JULY','18000.00','18000.00','Paid','2021-07-01 19:40:26','2021-07-06 20:01:01');
INSERT INTO invoices VALUES('166','1','16','3','34','1','2021-07-01','2021-07-10 10:56:06','','M/O JULY','JULY','19000.00','19000.00','Paid','2021-07-01 19:40:26','2021-07-10 14:56:06');
INSERT INTO invoices VALUES('167','1','17','3','33','1','2021-07-01','2021-07-10 09:58:17','','M/O JULY sec adj 10000','JULY','6340.00','6340.00','Paid','2021-07-01 19:40:26','2021-07-10 13:58:17');
INSERT INTO invoices VALUES('168','1','18','3','33','1','2021-07-01','2021-07-10 09:52:07','','M/O JULY','JULY','16340.00','16340.00','Paid','2021-07-01 19:40:26','2021-07-10 13:52:07');
INSERT INTO invoices VALUES('169','1','19','3','33','1','2021-07-01','2021-07-10 10:00:50','','M/O JULY sec adj10000','JULY','6340.00','6340.00','Paid','2021-07-01 19:40:26','2021-07-10 14:00:50');
INSERT INTO invoices VALUES('170','1','20','3','33','1','2021-07-01','2021-08-17 12:34:21','','M/O JULY','JULY','10000.00','10000.00','Paid','2021-07-01 19:40:26','2021-08-17 16:34:21');
INSERT INTO invoices VALUES('171','1','21','3','30','1','2021-07-01','2021-07-05 15:59:20','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:26','2021-07-05 19:59:20');
INSERT INTO invoices VALUES('172','1','22','3','35','1','2021-07-01','2021-08-06 13:26:45','','M/O JULY','JULY','18000.00','18000.00','Paid','2021-07-01 19:40:26','2021-08-06 17:26:45');
INSERT INTO invoices VALUES('173','1','23','3','36','1','2021-07-01','2021-07-17 15:57:45','','M/O JULY','JULY','12500.00','12500.00','Paid','2021-07-01 19:40:26','2021-07-17 19:57:45');
INSERT INTO invoices VALUES('273','1','6','3','30','1','2021-08-01','2021-08-24 13:47:32','','M/O August','','8000.00','8000.00','Paid','2021-08-01 18:52:06','2021-08-24 17:47:32');
INSERT INTO invoices VALUES('175','1','25','3','32','1','2021-07-01','2021-07-10 11:41:12','','M/O JULY sec adj 5000','JULY','8000.00','8000.00','Paid','2021-07-01 19:40:26','2021-07-10 15:41:12');
INSERT INTO invoices VALUES('176','1','26','3','32','1','2021-07-01','2021-08-01 14:01:05','','M/O JULY sec adj 5000 last month','JULY','8000.00','8000.00','Paid','2021-07-01 19:40:26','2021-08-01 18:01:05');
INSERT INTO invoices VALUES('177','1','27','3','32','1','2021-07-01','2021-08-01 14:00:39','','M/O JULY sec adj 5000 last month','JULY','7200.00','7200.00','Paid','2021-07-01 19:40:26','2021-08-01 18:00:39');
INSERT INTO invoices VALUES('178','1','28','3','34','1','2021-07-01','2021-07-10 11:00:07','','M/O JULY','JULY','13500.00','13500.00','Paid','2021-07-01 19:40:26','2021-07-10 15:00:07');
INSERT INTO invoices VALUES('179','1','29','3','34','1','2021-07-01','2021-07-17 15:56:16','','M/O JULY','JULY','19365.00','19365.00','Paid','2021-07-01 19:40:26','2021-07-17 19:56:16');
INSERT INTO invoices VALUES('180','1','30','3','30','1','2021-07-01','2021-07-10 10:41:35','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:26','2021-07-10 14:41:35');
INSERT INTO invoices VALUES('181','1','31','3','30','1','2021-07-01','2021-07-05 17:47:43','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:26','2021-07-05 21:47:43');
INSERT INTO invoices VALUES('182','1','32','3','30','1','2021-07-01','2021-07-10 10:43:07','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:26','2021-07-10 14:43:07');
INSERT INTO invoices VALUES('183','1','33','3','29','1','2021-07-01','2021-08-15 12:19:20','','M/O JULY','JULY','14420.00','14420.00','Paid','2021-07-01 19:40:26','2021-08-15 16:19:20');
INSERT INTO invoices VALUES('184','1','34','3','29','1','2021-07-01','2021-08-24 13:42:20','','M/O JULY','JULY','15420.00','15420.00','Paid','2021-07-01 19:40:26','2021-08-24 17:42:20');
INSERT INTO invoices VALUES('185','1','35','3','29','1','2021-07-01','2021-07-05 16:03:21','','M/O JULY','JULY','15500.00','15500.00','Paid','2021-07-01 19:40:26','2021-07-05 20:03:21');
INSERT INTO invoices VALUES('186','1','36','3','29','1','2021-07-01','2021-07-06 15:15:20','','M/O JULY','JULY','15400.00','15400.00','Paid','2021-07-01 19:40:26','2021-07-06 19:15:20');
INSERT INTO invoices VALUES('187','1','37','3','29','1','2021-07-01','2021-07-06 15:14:44','','M/O JULY','JULY','15400.00','15400.00','Paid','2021-07-01 19:40:26','2021-07-06 19:14:44');
INSERT INTO invoices VALUES('1096','1','153','1','9','1','2022-02-15','2022-02-25 12:48:16','','M/O FEB','','8000.00','8000.00','Paid','2022-02-25 17:47:13','2022-02-25 17:48:16');
INSERT INTO invoices VALUES('189','1','39','3','28','1','2021-07-01','2021-07-10 10:52:25','','M/O JULY','JULY','12000.00','12000.00','Paid','2021-07-01 19:40:26','2021-07-10 14:52:25');
INSERT INTO invoices VALUES('190','1','40','3','28','1','2021-07-01','2021-07-17 15:51:55','','M/O JULY','JULY','12000.00','12000.00','Paid','2021-07-01 19:40:26','2021-07-17 19:51:55');
INSERT INTO invoices VALUES('191','1','41','3','27','1','2021-07-01','2021-07-06 16:11:02','','M/O JULY','JULY','15000.00','15000.00','Paid','2021-07-01 19:40:26','2021-07-06 20:11:02');
INSERT INTO invoices VALUES('192','1','42','3','27','1','2021-07-01','2021-07-03 16:58:41','','M/O JULY','JULY','15000.00','15000.00','Paid','2021-07-01 19:40:26','2021-07-03 20:58:41');
INSERT INTO invoices VALUES('193','1','43','3','27','1','2021-07-01','2021-07-06 16:15:46','','M/O JULY','JULY','15000.00','15000.00','Paid','2021-07-01 19:40:26','2021-07-06 20:15:46');
INSERT INTO invoices VALUES('194','1','44','3','26','1','2021-07-01','2021-08-12 15:19:04','','M/O JULY','JULY','16385.00','16385.00','Paid','2021-07-01 19:40:26','2021-08-12 19:19:04');
INSERT INTO invoices VALUES('195','1','45','3','26','1','2021-07-01','2021-08-12 15:24:54','','M/O JULY','JULY','16385.00','16385.00','Paid','2021-07-01 19:40:26','2021-08-12 19:24:54');
INSERT INTO invoices VALUES('196','1','46','3','26','1','2021-07-01','2021-07-06 16:50:25','','M/O JULY','JULY','16385.00','16385.00','Paid','2021-07-01 19:40:26','2021-07-06 20:50:25');
INSERT INTO invoices VALUES('197','1','47','3','26','1','2021-07-01','2021-08-17 12:31:05','','M/O JULY','JULY','16385.00','16385.00','Paid','2021-07-01 19:40:26','2021-08-17 16:31:05');
INSERT INTO invoices VALUES('198','1','48','1','16','1','2021-07-01','2021-07-10 10:13:26','','M/O JULY','JULY','17320.00','17320.00','Paid','2021-07-01 19:40:26','2021-07-10 14:13:26');
INSERT INTO invoices VALUES('199','1','49','2','14','1','2021-07-01','2021-07-08 14:16:10','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:26','2021-07-08 18:16:10');
INSERT INTO invoices VALUES('200','1','50','3','25','1','2021-07-01','2021-07-08 15:34:04','','M/O JULY','JULY','16500.00','16500.00','Paid','2021-07-01 19:40:26','2021-07-08 19:34:04');
INSERT INTO invoices VALUES('201','1','51','3','25','1','2021-07-01','2021-07-08 15:37:33','','M/O JULY','JULY','18740.00','18740.00','Paid','2021-07-01 19:40:27','2021-07-08 19:37:33');
INSERT INTO invoices VALUES('202','1','52','3','25','1','2021-07-01','2021-07-08 15:39:23','','M/O JULY','JULY','16500.00','16500.00','Paid','2021-07-01 19:40:27','2021-07-08 19:39:23');
INSERT INTO invoices VALUES('203','1','53','3','25','1','2021-07-01','2021-08-01 13:28:50','','M/O JULY','JULY','16500.00','16500.00','Paid','2021-07-01 19:40:27','2021-08-01 17:28:50');
INSERT INTO invoices VALUES('204','1','54','2','23','1','2021-07-01','2021-07-03 15:49:31','','M/O JULY','JULY','15000.00','15000.00','Paid','2021-07-01 19:40:27','2021-07-03 19:49:31');
INSERT INTO invoices VALUES('205','1','55','2','21','1','2021-07-01','2021-07-10 10:17:06','','M/O JULY sec adj 10000','JULY','6000.00','6000.00','Paid','2021-07-01 19:40:27','2021-07-10 14:17:06');
INSERT INTO invoices VALUES('206','1','56','1','19','1','2021-07-01','2021-07-08 16:55:23','','M/O JULY','JULY','19465.00','19465.00','Paid','2021-07-01 19:40:27','2021-07-08 20:55:23');
INSERT INTO invoices VALUES('207','1','57','1','19','1','2021-07-01','2021-07-08 13:22:54','','M/O JULY','JULY','19465.00','19465.00','Paid','2021-07-01 19:40:27','2021-07-08 17:22:54');
INSERT INTO invoices VALUES('208','1','58','1','17','1','2021-07-01','2021-07-06 15:21:04','','M/O JULY','adjustment sec 16500','525.00','525.00','Paid','2021-07-01 19:40:27','2021-07-06 19:21:04');
INSERT INTO invoices VALUES('209','1','59','2','21','1','2021-07-01','2021-09-13 13:47:07','','M/O JULY','JULY','8500.00','8500.00','Paid','2021-07-01 19:40:27','2021-09-13 17:47:07');
INSERT INTO invoices VALUES('210','1','60','2','22','1','2021-07-01','2021-07-10 10:20:30','','M/O JULY','JULY','12000.00','12000.00','Paid','2021-07-01 19:40:27','2021-07-10 14:20:30');
INSERT INTO invoices VALUES('211','1','61','2','22','1','2021-07-01','2021-07-10 10:19:58','','M/O JULY','JULY','12000.00','12000.00','Paid','2021-07-01 19:40:27','2021-07-10 14:19:58');
INSERT INTO invoices VALUES('212','1','62','2','22','1','2021-07-01','2021-07-17 15:44:08','','M/O JULY','JULY','12000.00','12000.00','Paid','2021-07-01 19:40:27','2021-07-17 19:44:08');
INSERT INTO invoices VALUES('213','1','63','1','18','1','2021-07-01','2021-07-17 15:43:11','','M/O JULY','JULY','15000.00','15000.00','Paid','2021-07-01 19:40:27','2021-07-17 19:43:11');
INSERT INTO invoices VALUES('214','1','64','1','18','1','2021-07-01','2021-07-12 17:06:28','','M/O JULY','JULY','24440.00','24440.00','Paid','2021-07-01 19:40:27','2021-07-12 21:06:28');
INSERT INTO invoices VALUES('215','1','65','1','17','1','2021-07-01','2021-07-08 13:16:00','','M/O JULY','JULY','16525.00','16525.00','Paid','2021-07-01 19:40:27','2021-07-08 17:16:00');
INSERT INTO invoices VALUES('216','1','66','1','17','1','2021-07-01','2021-07-06 16:05:53','','M/O JULY','JULY','17025.00','17025.00','Paid','2021-07-01 19:40:27','2021-07-06 20:05:53');
INSERT INTO invoices VALUES('217','1','67','1','17','1','2021-07-01','2021-07-06 15:19:39','','M/O JULY','JULY','16525.00','16525.00','Paid','2021-07-01 19:40:27','2021-07-06 19:19:39');
INSERT INTO invoices VALUES('218','1','68','1','16','1','2021-07-01','2021-08-12 15:06:00','','M/O JULY','JULY','16320.00','16320.00','Paid','2021-07-01 19:40:27','2021-08-12 19:06:00');
INSERT INTO invoices VALUES('219','1','69','1','16','1','2021-07-01','2021-07-05 16:43:01','','M/O JULY','JULY','17320.00','17320.00','Paid','2021-07-01 19:40:27','2021-07-05 20:43:01');
INSERT INTO invoices VALUES('220','1','70','1','16','1','2021-07-01','2021-07-26 15:15:19','','M/O JULY','JULY','17320.00','17320.00','Paid','2021-07-01 19:40:27','2021-07-26 19:15:19');
INSERT INTO invoices VALUES('221','1','71','1','15','1','2021-07-01','2021-07-05 16:59:08','','M/O JULY','JULY','17560.00','17560.00','Paid','2021-07-01 19:40:27','2021-07-05 20:59:08');
INSERT INTO invoices VALUES('222','1','72','1','15','1','2021-07-01','2021-07-08 12:22:47','','M/O JULY','JULY','18550.00','18550.00','Paid','2021-07-01 19:40:27','2021-07-08 16:22:47');
INSERT INTO invoices VALUES('223','1','73','1','15','1','2021-07-01','2021-07-10 10:09:33','','M/O JULY','JULY','18560.00','18560.00','Paid','2021-07-01 19:40:27','2021-07-10 14:09:33');
INSERT INTO invoices VALUES('224','1','74','1','15','1','2021-07-01','2021-07-08 13:13:24','','M/O JULY sec adj 10000','JULY','8060.00','8060.00','Paid','2021-07-01 19:40:27','2021-07-08 17:13:24');
INSERT INTO invoices VALUES('226','1','76','2','14','1','2021-07-01','2021-07-08 13:09:39','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:27','2021-07-08 17:09:39');
INSERT INTO invoices VALUES('227','1','77','2','14','1','2021-07-01','2021-07-02 12:37:07','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:27','2021-07-02 16:37:07');
INSERT INTO invoices VALUES('228','1','78','2','13','1','2021-07-01','2021-07-06 16:54:52','','M/O JULY','JULY','16000.00','16000.00','Paid','2021-07-01 19:40:27','2021-07-06 20:54:52');
INSERT INTO invoices VALUES('229','1','79','2','13','1','2021-07-01','2021-07-03 16:33:59','','M/O JULY','JULY','16000.00','16000.00','Paid','2021-07-01 19:40:27','2021-07-03 20:33:59');
INSERT INTO invoices VALUES('230','1','80','2','13','1','2021-07-01','2021-07-06 16:52:16','','M/O JULY','JULY','16000.00','16000.00','Paid','2021-07-01 19:40:27','2021-07-06 20:52:16');
INSERT INTO invoices VALUES('231','1','81','1','12','1','2021-07-01','2021-08-01 13:19:30','','M/O JULY','JULY','18440.00','18440.00','Paid','2021-07-01 19:40:27','2021-08-01 17:19:30');
INSERT INTO invoices VALUES('232','1','82','1','12','1','2021-07-01','2021-08-01 13:18:54','','M/O JULY','JULY','18440.00','18440.00','Paid','2021-07-01 19:40:27','2021-08-01 17:18:54');
INSERT INTO invoices VALUES('233','1','83','1','12','1','2021-07-01','2021-08-01 13:17:57','','M/O JULY','JULY','18440.00','18440.00','Paid','2021-07-01 19:40:27','2021-08-01 17:17:57');
INSERT INTO invoices VALUES('269','1','1','1','9','1','2021-08-01','2021-08-03 16:49:45','','M/O August','','15500.00','15500.00','Paid','2021-08-01 18:52:06','2021-08-03 20:49:45');
INSERT INTO invoices VALUES('270','1','2','2','23','1','2021-08-01','2021-08-12 15:15:40','','M/O August','','17000.00','17000.00','Paid','2021-08-01 18:52:06','2021-08-12 19:15:40');
INSERT INTO invoices VALUES('271','1','4','1','8','1','2021-08-01','2021-08-04 14:39:04','','M/O August','','10000.00','10000.00','Paid','2021-08-01 18:52:06','2021-08-04 18:39:04');
INSERT INTO invoices VALUES('272','1','5','3','30','1','2021-08-01','2021-08-24 13:48:05','','M/O August','','8000.00','8000.00','Paid','2021-08-01 18:52:06','2021-08-24 17:48:05');
INSERT INTO invoices VALUES('238','1','88','2','10','1','2021-07-01','2021-07-08 13:04:41','','M/O JULY','JULY','14500.00','14500.00','Paid','2021-07-01 19:40:27','2021-07-08 17:04:41');
INSERT INTO invoices VALUES('239','1','89','2','10','1','2021-07-01','2021-07-10 10:24:59','','M/O JULY','JULY','14500.00','14500.00','Paid','2021-07-01 19:40:27','2021-07-10 14:24:59');
INSERT INTO invoices VALUES('274','1','9','2','20','1','2021-08-01','2021-08-01 14:53:01','','M/O August','','24000.00','24000.00','Paid','2021-08-01 18:52:06','2021-08-01 18:53:01');
INSERT INTO invoices VALUES('241','1','91','1','9','1','2021-07-01','2021-07-17 15:26:41','','M/O JULY','JULY','16000.00','16000.00','Paid','2021-07-01 19:40:27','2021-07-17 19:26:41');
INSERT INTO invoices VALUES('242','1','92','1','8','1','2021-07-01','2021-07-06 16:14:59','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:27','2021-07-06 20:14:59');
INSERT INTO invoices VALUES('243','1','93','1','8','1','2021-07-01','2021-07-08 12:36:14','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:27','2021-07-08 16:36:14');
INSERT INTO invoices VALUES('244','1','94','1','8','1','2021-07-01','2021-07-10 10:05:38','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:27','2021-07-10 14:05:38');
INSERT INTO invoices VALUES('245','1','95','1','8','1','2021-07-01','2021-07-17 15:25:17','','M/O JULY sec adjesment','JULY','3000.00','3000.00','Paid','2021-07-01 19:40:27','2021-07-17 19:25:17');
INSERT INTO invoices VALUES('246','1','96','1','7','1','2021-07-01','2021-07-10 10:04:53','','M/O JULY','JULY','16500.00','16500.00','Paid','2021-07-01 19:40:27','2021-07-10 14:04:53');
INSERT INTO invoices VALUES('247','1','97','1','7','1','2021-07-01','2021-07-14 15:22:59','','M/O JULY','JULY','18000.00','18000.00','Paid','2021-07-01 19:40:28','2021-07-14 19:22:59');
INSERT INTO invoices VALUES('248','1','98','1','6','1','2021-07-01','2021-07-05 16:43:46','','M/O JULY','JULY','17000.00','17000.00','Paid','2021-07-01 19:40:28','2021-07-05 20:43:46');
INSERT INTO invoices VALUES('249','1','99','1','6','1','2021-07-01','2021-07-02 12:41:53','','M/O JULY','JULY','16000.00','16000.00','Paid','2021-07-01 19:40:28','2021-07-02 16:41:53');
INSERT INTO invoices VALUES('250','1','100','1','5','1','2021-07-03','2021-07-03 12:03:14','','M/O JULY','JULY','16140.00','16140.00','Paid','2021-07-01 19:40:28','2021-07-03 16:03:14');
INSERT INTO invoices VALUES('251','1','101','1','5','1','2021-07-01','2021-08-15 12:24:10','','M/O JULY','JULY','16140.00','16140.00','Paid','2021-07-01 19:40:28','2021-08-15 16:24:10');
INSERT INTO invoices VALUES('252','1','102','1','5','1','2021-07-01','2021-08-12 14:19:29','','M/O JULY','JULY','16140.00','16140.00','Paid','2021-07-01 19:40:28','2021-08-12 18:19:29');
INSERT INTO invoices VALUES('1462','1','163','2','13','1','2022-05-13','2022-05-13 15:01:33','','M/O MAY','','680.00','680.00','Paid','2022-05-13 15:00:48','2022-05-13 15:01:33');
INSERT INTO invoices VALUES('1343','1','4','1','8','1','2022-05-01','2022-05-13 15:40:40','','MAY/22','M/O MAY','10000.00','10000.00','Paid','2022-05-06 13:18:06','2022-05-13 15:40:40');
INSERT INTO invoices VALUES('254','1','104','1','3','1','2021-07-01','2021-07-14 16:31:38','','M/O JULY','JULY','18000.00','18000.00','Paid','2021-07-01 19:40:28','2021-07-14 20:31:38');
INSERT INTO invoices VALUES('491','1','5','3','30','1','2021-10-01','2021-10-08 11:10:31','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:36','2021-10-08 15:10:31');
INSERT INTO invoices VALUES('256','1','106','1','4','1','2021-07-01','2021-07-03 14:49:55','','M/O JULY sec adj 10000','JULY','6500.00','6500.00','Paid','2021-07-01 19:40:28','2021-07-03 18:49:55');
INSERT INTO invoices VALUES('257','1','107','1','1','1','2021-07-01','2021-07-08 12:33:01','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:28','2021-07-08 16:33:01');
INSERT INTO invoices VALUES('258','1','108','1','1','1','2021-07-01','2021-08-30 14:29:29','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:28','2021-08-30 18:29:29');
INSERT INTO invoices VALUES('259','1','109','1','1','1','2021-07-01','2021-07-08 12:32:31','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:28','2021-07-08 16:32:31');
INSERT INTO invoices VALUES('260','1','110','1','1','1','2021-07-01','2021-07-05 15:24:24','','M/O JULY','JULY','14000.00','14000.00','Paid','2021-07-01 19:40:28','2021-07-05 19:24:24');
INSERT INTO invoices VALUES('261','1','111','1','1','1','2021-07-01','2021-07-08 12:29:56','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:28','2021-07-08 16:29:56');
INSERT INTO invoices VALUES('262','1','112','1','1','1','2021-07-01','2021-07-06 15:46:26','','M/O JULY','JULY','13000.00','13000.00','Paid','2021-07-01 19:40:28','2021-07-06 19:46:26');
INSERT INTO invoices VALUES('263','1','113','1','12','1','2021-07-01','2021-08-01 13:16:39','','M/O JULY','JULY','18440.00','18440.00','Paid','2021-07-01 19:40:28','2021-08-01 17:16:39');
INSERT INTO invoices VALUES('264','1','114','2','24','1','2021-07-01','2021-07-03 12:10:26','','M/O JULY','P MONTH SEC5000
TOTAL 5000+5000=10000','20000.00','20000.00','Paid','2021-07-01 19:40:28','2021-07-03 16:10:26');
INSERT INTO invoices VALUES('266','1','117','1','4','1','2021-07-03','2021-07-03 15:43:34','','M/O JULY','','16500.00','16500.00','Paid','2021-07-03 19:41:37','2021-07-03 19:43:34');
INSERT INTO invoices VALUES('267','1','118','1','4','1','2021-07-03','2021-07-03 15:43:06','','M/O JULY','','16500.00','16500.00','Paid','2021-07-03 19:42:11','2021-07-03 19:43:06');
INSERT INTO invoices VALUES('268','1','119','2','24','1','2021-07-07','2021-07-10 10:31:36','','M/O JULY','','13000.00','13000.00','Paid','2021-07-10 14:31:06','2021-07-10 14:31:36');
INSERT INTO invoices VALUES('1342','1','2','2','23','1','2022-05-01','2022-05-10 17:17:14','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-10 17:17:14');
INSERT INTO invoices VALUES('1338','1','183','2','21','1','2022-04-28','2022-04-28 17:01:57','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-28 16:44:06','2022-04-28 17:01:57');
INSERT INTO invoices VALUES('277','1','12','2','38','1','2021-08-01','2021-08-26 15:00:32','','M/O August','','8500.00','8500.00','Paid','2021-08-01 18:52:06','2021-08-26 19:00:32');
INSERT INTO invoices VALUES('278','1','13','2','39','1','2021-08-01','2021-08-12 16:05:27','','M/O August','','13000.00','13000.00','Paid','2021-08-01 18:52:06','2021-08-12 20:05:27');
INSERT INTO invoices VALUES('279','1','14','3','37','1','2021-08-01','2021-08-12 16:06:03','','M/O August','','32440.00','32440.00','Paid','2021-08-01 18:52:06','2021-08-12 20:06:03');
INSERT INTO invoices VALUES('280','1','15','1','41','1','2021-08-01','2021-08-03 16:46:01','','M/O August','','18000.00','18000.00','Paid','2021-08-01 18:52:06','2021-08-03 20:46:01');
INSERT INTO invoices VALUES('281','1','16','3','34','1','2021-08-01','2021-08-24 15:46:41','','M/O August','','9500.00','9500.00','Paid','2021-08-01 18:52:06','2021-08-24 19:46:41');
INSERT INTO invoices VALUES('282','1','17','3','33','1','2021-08-01','2021-08-08 16:38:11','','M/O August','','22400.00','22400.00','Paid','2021-08-01 18:52:07','2021-08-08 20:38:11');
INSERT INTO invoices VALUES('283','1','18','3','33','1','2021-08-01','2021-08-26 15:17:19','','M/O August','','8400.00','8400.00','Paid','2021-08-01 18:52:07','2021-08-26 19:17:19');
INSERT INTO invoices VALUES('284','1','19','3','33','1','2021-08-01','2021-08-12 15:55:48','','M/O August','','16400.00','16400.00','Paid','2021-08-01 18:52:07','2021-08-12 19:55:48');
INSERT INTO invoices VALUES('285','1','20','3','33','1','2021-08-01','2021-09-12 17:06:09','','M/O August','','8400.00','8400.00','Paid','2021-08-01 18:52:07','2021-09-12 21:06:09');
INSERT INTO invoices VALUES('286','1','21','3','30','1','2021-08-01','2021-08-15 12:29:38','','M/O August','','7500.00','7500.00','Paid','2021-08-01 18:52:07','2021-08-15 16:29:38');
INSERT INTO invoices VALUES('287','1','22','3','35','1','2021-08-01','2021-08-06 13:25:45','','M/O August','','18500.00','18500.00','Paid','2021-08-01 18:52:07','2021-08-06 17:25:45');
INSERT INTO invoices VALUES('288','1','28','3','34','1','2021-08-01','2021-08-12 16:02:29','','M/O August','','9500.00','9500.00','Paid','2021-08-01 18:52:07','2021-08-12 20:02:29');
INSERT INTO invoices VALUES('289','1','29','3','34','1','2021-08-01','2021-08-12 16:02:02','','M/O August','','10500.00','10500.00','Paid','2021-08-01 18:52:07','2021-08-12 20:02:02');
INSERT INTO invoices VALUES('290','1','30','3','30','1','2021-08-01','2021-08-12 15:50:09','','M/O August','','7500.00','7500.00','Paid','2021-08-01 18:52:07','2021-08-12 19:50:09');
INSERT INTO invoices VALUES('291','1','31','3','30','1','2021-08-01','2021-08-12 15:50:38','','M/O August','','7500.00','7500.00','Paid','2021-08-01 18:52:07','2021-08-12 19:50:38');
INSERT INTO invoices VALUES('292','1','32','3','30','1','2021-08-01','2021-10-09 14:59:57','','M/O August','','7500.00','7500.00','Paid','2021-08-01 18:52:07','2021-10-09 18:59:57');
INSERT INTO invoices VALUES('293','1','33','3','29','1','2021-08-01','2021-08-15 12:18:38','','M/O August','','12144.00','12144.00','Paid','2021-08-01 18:52:07','2021-08-15 16:18:38');
INSERT INTO invoices VALUES('294','1','34','3','29','1','2021-08-01','2021-08-24 13:42:50','','M/O August','','19894.00','19894.00','Paid','2021-08-01 18:52:07','2021-08-24 17:42:50');
INSERT INTO invoices VALUES('295','1','35','3','29','1','2021-08-01','2021-09-09 16:25:58','','M/O August','','19894.00','19894.00','Paid','2021-08-01 18:52:07','2021-09-09 20:25:58');
INSERT INTO invoices VALUES('296','1','36','3','29','1','2021-08-01','2021-08-12 15:36:13','','M/O August','','19894.00','19894.00','Paid','2021-08-01 18:52:07','2021-08-12 19:36:13');
INSERT INTO invoices VALUES('297','1','37','3','29','1','2021-08-01','2021-08-12 15:35:45','','M/O August','','12394.00','12394.00','Paid','2021-08-01 18:52:07','2021-08-12 19:35:45');
INSERT INTO invoices VALUES('371','1','122','1','8','1','2021-08-11','2021-08-12 16:35:32','','M/O AUGUST','','13000.00','13000.00','Paid','2021-08-12 20:33:16','2021-08-12 20:35:32');
INSERT INTO invoices VALUES('472','1','129','3','28','1','2021-09-01','2021-09-13 13:19:02','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-13 17:18:11','2021-09-13 17:19:02');
INSERT INTO invoices VALUES('300','1','40','3','28','1','2021-08-01','2021-08-17 12:25:54','','M/O August','','12000.00','12000.00','Paid','2021-08-01 18:52:07','2021-08-17 16:25:54');
INSERT INTO invoices VALUES('301','1','41','3','27','1','2021-08-01','2021-08-05 14:32:02','','M/O August','','15000.00','15000.00','Paid','2021-08-01 18:52:07','2021-08-05 18:32:02');
INSERT INTO invoices VALUES('302','1','42','3','27','1','2021-08-01','2021-08-12 15:29:58','','M/O August','','13500.00','13500.00','Paid','2021-08-01 18:52:07','2021-08-12 19:29:58');
INSERT INTO invoices VALUES('372','1','121','1','4','1','2021-08-12','2021-08-12 16:35:00','','M/O AUGUST','','16500.00','16500.00','Paid','2021-08-12 20:34:18','2021-08-12 20:35:00');
INSERT INTO invoices VALUES('304','1','44','3','26','1','2021-08-01','2021-09-07 16:54:35','','M/O August','','15060.00','15060.00','Paid','2021-08-01 18:52:07','2021-09-07 20:54:35');
INSERT INTO invoices VALUES('305','1','45','3','26','1','2021-08-01','2021-09-13 12:45:26','','M/O August','','16560.00','16560.00','Paid','2021-08-01 18:52:07','2021-09-13 16:45:26');
INSERT INTO invoices VALUES('306','1','46','3','26','1','2021-08-01','2021-08-12 15:24:12','','M/O August','','10560.00','10560.00','Paid','2021-08-01 18:52:07','2021-08-12 19:24:12');
INSERT INTO invoices VALUES('307','1','47','3','26','1','2021-08-01','2021-11-01 12:39:26','','M/O August','','15060.00','15060.00','Paid','2021-08-01 18:52:07','2021-11-01 17:39:26');
INSERT INTO invoices VALUES('308','1','48','1','16','1','2021-08-01','2021-08-12 15:07:37','','M/O August','','17330.00','17330.00','Paid','2021-08-01 18:52:07','2021-08-12 19:07:37');
INSERT INTO invoices VALUES('309','1','49','2','14','1','2021-08-01','2021-08-08 15:12:18','','M/O August','','14000.00','14000.00','Paid','2021-08-01 18:52:07','2021-08-08 19:12:18');
INSERT INTO invoices VALUES('310','1','50','3','25','1','2021-08-01','2021-08-05 14:05:10','','M/O August','','16500.00','16500.00','Paid','2021-08-01 18:52:07','2021-08-05 18:05:10');
INSERT INTO invoices VALUES('311','1','51','3','25','1','2021-08-01','2021-08-08 16:44:58','','M/O August','','18880.00','18880.00','Paid','2021-08-01 18:52:07','2021-08-08 20:44:58');
INSERT INTO invoices VALUES('312','1','52','3','25','1','2021-08-01','2021-08-08 16:46:28','','M/O August','','16500.00','16500.00','Paid','2021-08-01 18:52:07','2021-08-08 20:46:28');
INSERT INTO invoices VALUES('313','1','53','3','25','1','2021-08-01','2021-08-15 12:33:43','','M/O August','','8500.00','8500.00','Paid','2021-08-01 18:52:07','2021-08-15 16:33:43');
INSERT INTO invoices VALUES('314','1','54','2','23','1','2021-08-01','2021-08-12 15:15:14','','M/O August','','7500.00','7500.00','Paid','2021-08-01 18:52:07','2021-08-12 19:15:14');
INSERT INTO invoices VALUES('315','1','55','2','21','1','2021-08-01','2021-11-07 09:14:18','','M/O August','','32000.00','32000.00','Paid','2021-08-01 18:52:07','2021-11-07 14:14:18');
INSERT INTO invoices VALUES('316','1','56','1','19','1','2021-08-01','2021-08-08 17:51:30','','M/O August','','18840.00','18840.00','Paid','2021-08-01 18:52:07','2021-08-08 21:51:30');
INSERT INTO invoices VALUES('317','1','57','1','19','1','2021-08-01','2021-09-04 16:04:28','','M/O August','','18840.00','18840.00','Paid','2021-08-01 18:52:07','2021-09-04 20:04:28');
INSERT INTO invoices VALUES('318','1','59','2','14','1','2021-08-01','2021-09-13 13:48:16','','M/O August','','8500.00','8500.00','Paid','2021-08-01 18:52:07','2021-09-13 17:48:16');
INSERT INTO invoices VALUES('319','1','60','2','22','1','2021-08-01','2021-08-04 16:42:15','','M/O August','','12000.00','12000.00','Paid','2021-08-01 18:52:07','2021-08-04 20:42:15');
INSERT INTO invoices VALUES('320','1','61','2','22','1','2021-08-01','2021-08-04 16:41:43','','M/O August','','12000.00','12000.00','Paid','2021-08-01 18:52:07','2021-08-04 20:41:43');
INSERT INTO invoices VALUES('321','1','62','2','22','1','2021-08-01','2021-08-12 15:12:56','','M/O August','','12000.00','12000.00','Paid','2021-08-01 18:52:07','2021-08-12 19:12:56');
INSERT INTO invoices VALUES('322','1','63','1','18','1','2021-08-01','2021-08-12 15:09:57','','M/O August','','24000.00','24000.00','Paid','2021-08-01 18:52:07','2021-08-12 19:09:57');
INSERT INTO invoices VALUES('323','1','64','1','18','1','2021-08-01','2021-08-26 15:02:44','','M/O August','','18750.00','18750.00','Paid','2021-08-01 18:52:07','2021-08-26 19:02:44');
INSERT INTO invoices VALUES('324','1','65','1','17','1','2021-08-01','2021-08-04 17:10:14','','M/O August','','17080.00','17080.00','Paid','2021-08-01 18:52:07','2021-08-04 21:10:14');
INSERT INTO invoices VALUES('325','1','66','1','17','1','2021-08-01','2021-08-12 15:08:46','','M/O August','','17580.00','17580.00','Paid','2021-08-01 18:52:07','2021-08-12 19:08:46');
INSERT INTO invoices VALUES('326','1','67','1','17','1','2021-08-01','2021-08-12 15:08:21','','M/O August','','17080.00','17080.00','Paid','2021-08-01 18:52:07','2021-08-12 19:08:21');
INSERT INTO invoices VALUES('327','1','68','1','16','1','2021-08-01','2021-10-20 13:06:46','','M/O August','','16330.00','16330.00','Paid','2021-08-01 18:52:07','2021-10-20 17:06:46');
INSERT INTO invoices VALUES('328','1','69','1','16','1','2021-08-01','2021-08-12 15:07:09','','M/O August','','17330.00','17330.00','Paid','2021-08-01 18:52:07','2021-08-12 19:07:09');
INSERT INTO invoices VALUES('329','1','70','1','16','1','2021-08-01','2021-08-24 14:20:31','','M/O August','','17330.00','17330.00','Paid','2021-08-01 18:52:07','2021-08-24 18:20:31');
INSERT INTO invoices VALUES('330','1','71','1','15','1','2021-08-01','2021-08-12 14:42:29','','M/O August','','18710.00','18710.00','Paid','2021-08-01 18:52:07','2021-08-12 18:42:29');
INSERT INTO invoices VALUES('331','1','72','1','15','1','2021-08-01','2021-08-03 16:05:05','','M/O August','','19760.00','19760.00','Paid','2021-08-01 18:52:07','2021-08-03 20:05:05');
INSERT INTO invoices VALUES('595','1','150','2','11','1','2021-10-01','2021-10-09 15:16:45','','M/O OCTOBER','M/O OCTOBER','34000.00','34000.00','Paid','2021-10-09 19:16:05','2021-10-09 19:16:45');
INSERT INTO invoices VALUES('333','1','74','1','15','1','2021-08-01','2021-08-06 13:20:03','','M/O August','','19210.00','19210.00','Paid','2021-08-01 18:52:07','2021-08-06 17:20:03');
INSERT INTO invoices VALUES('489','1','2','2','23','1','2021-10-01','2021-10-05 16:48:53','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:36','2021-10-05 20:48:53');
INSERT INTO invoices VALUES('335','1','76','2','14','1','2021-08-01','2021-08-12 14:39:45','','M/O August','','13000.00','13000.00','Paid','2021-08-01 18:52:07','2021-08-12 18:39:45');
INSERT INTO invoices VALUES('336','1','77','2','14','1','2021-08-01','2021-08-15 12:28:25','','M/O August','','6500.00','6500.00','Paid','2021-08-01 18:52:07','2021-08-15 16:28:25');
INSERT INTO invoices VALUES('337','1','78','2','13','1','2021-08-01','2021-08-17 12:24:43','','M/O August','','12000.00','12000.00','Paid','2021-08-01 18:52:07','2021-08-17 16:24:43');
INSERT INTO invoices VALUES('338','1','79','2','13','1','2021-08-01','2021-08-05 13:44:51','','M/O August','','16000.00','16000.00','Paid','2021-08-01 18:52:07','2021-08-05 17:44:51');
INSERT INTO invoices VALUES('339','1','80','2','13','1','2021-08-01','2021-08-12 14:37:09','','M/O August','','16000.00','16000.00','Paid','2021-08-01 18:52:07','2021-08-12 18:37:09');
INSERT INTO invoices VALUES('340','1','81','1','12','1','2021-08-01','2021-08-12 14:34:44','','M/O August','','19770.00','19770.00','Paid','2021-08-01 18:52:07','2021-08-12 18:34:44');
INSERT INTO invoices VALUES('341','1','82','1','12','1','2021-08-01','2021-08-12 14:34:04','','M/O August','','19760.00','19760.00','Paid','2021-08-01 18:52:07','2021-08-12 18:34:04');
INSERT INTO invoices VALUES('342','1','83','1','12','1','2021-08-01','2021-08-12 14:33:38','','M/O August','','19760.00','19760.00','Paid','2021-08-01 18:52:07','2021-08-12 18:33:38');
INSERT INTO invoices VALUES('343','1','88','2','10','1','2021-08-01','2021-08-12 14:29:11','','M/O August','','7250.00','7250.00','Paid','2021-08-01 18:52:07','2021-08-12 18:29:11');
INSERT INTO invoices VALUES('344','1','89','2','10','1','2021-08-01','2021-09-29 16:13:16','','M/O August','','14500.00','14500.00','Paid','2021-08-01 18:52:07','2021-09-29 20:13:16');
INSERT INTO invoices VALUES('345','1','91','1','9','1','2021-08-01','2021-08-12 14:27:01','','M/O August','','16000.00','16000.00','Paid','2021-08-01 18:52:07','2021-08-12 18:27:01');
INSERT INTO invoices VALUES('346','1','93','1','8','1','2021-08-01','2021-08-12 14:26:25','','M/O August','','13000.00','13000.00','Paid','2021-08-01 18:52:07','2021-08-12 18:26:25');
INSERT INTO invoices VALUES('347','1','96','1','7','1','2021-08-01','2021-08-17 12:44:16','','M/O August','','16500.00','16500.00','Paid','2021-08-01 18:52:07','2021-08-17 16:44:16');
INSERT INTO invoices VALUES('348','1','97','1','7','1','2021-08-01','2021-08-28 12:53:18','','M/O August','','9000.00','9000.00','Paid','2021-08-01 18:52:07','2021-08-28 16:53:18');
INSERT INTO invoices VALUES('349','1','98','1','6','1','2021-08-01','2021-08-10 14:37:23','','M/O August','','17000.00','17000.00','Paid','2021-08-01 18:52:07','2021-08-10 18:37:23');
INSERT INTO invoices VALUES('350','1','99','1','6','1','2021-08-01','2021-08-04 15:25:31','','M/O August','','16000.00','16000.00','Paid','2021-08-01 18:52:07','2021-08-04 19:25:31');
INSERT INTO invoices VALUES('351','1','100','1','5','1','2021-08-01','2021-09-20 15:50:52','','M/O August','','9150.00','9150.00','Paid','2021-08-01 18:52:07','2021-09-20 19:50:52');
INSERT INTO invoices VALUES('352','1','101','1','5','1','2021-08-01','2021-09-29 16:07:25','','M/O August','','17160.00','17160.00','Paid','2021-08-01 18:52:07','2021-09-29 20:07:25');
INSERT INTO invoices VALUES('353','1','102','1','5','1','2021-08-01','2021-08-12 14:18:36','','M/O August','','17160.00','17160.00','Paid','2021-08-01 18:52:07','2021-08-12 18:18:36');
INSERT INTO invoices VALUES('354','1','103','1','2','1','2021-08-01','2021-08-26 15:05:04','','M/O August','','18000.00','18000.00','Paid','2021-08-01 18:52:07','2021-08-26 19:05:04');
INSERT INTO invoices VALUES('355','1','104','1','3','1','2021-08-01','2021-08-12 14:16:43','','M/O August','','18000.00','18000.00','Paid','2021-08-01 18:52:07','2021-08-12 18:16:43');
INSERT INTO invoices VALUES('492','1','6','3','30','1','2021-10-01','2021-10-08 12:40:50','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:36','2021-10-08 16:40:50');
INSERT INTO invoices VALUES('357','1','107','1','1','1','2021-08-01','2021-09-20 15:31:06','','M/O August','','7000.00','7000.00','Paid','2021-08-01 18:52:07','2021-09-20 19:31:06');
INSERT INTO invoices VALUES('358','1','108','1','1','1','2021-08-01','2021-10-14 18:51:46','','M/O August','','7000.00','7000.00','Paid','2021-08-01 18:52:07','2021-10-14 22:51:46');
INSERT INTO invoices VALUES('494','1','14','3','37','1','2021-10-01','2022-03-27 12:32:35','','M/O OCTOBER','M/O OCTOBER','32650.00','32650.00','Paid','2021-10-03 21:02:36','2022-03-27 12:32:35');
INSERT INTO invoices VALUES('360','1','110','1','1','1','2021-08-01','2021-09-12 16:07:12','','M/O August','','7000.00','7000.00','Paid','2021-08-01 18:52:07','2021-09-12 20:07:12');
INSERT INTO invoices VALUES('361','1','111','1','1','1','2021-08-01','2021-08-12 14:13:36','','M/O August','','6500.00','6500.00','Paid','2021-08-01 18:52:07','2021-08-12 18:13:36');
INSERT INTO invoices VALUES('362','1','112','1','1','1','2021-08-01','2021-08-05 14:31:11','','M/O August','','13000.00','13000.00','Paid','2021-08-01 18:52:07','2021-08-05 18:31:11');
INSERT INTO invoices VALUES('363','1','113','1','12','1','2021-08-01','2021-08-12 14:33:11','','M/O August','','19760.00','19760.00','Paid','2021-08-01 18:52:07','2021-08-12 18:33:11');
INSERT INTO invoices VALUES('364','1','114','3','32','1','2021-08-01','2021-08-17 11:55:45','','M/O August','','22000.00','22000.00','Paid','2021-08-01 18:52:07','2021-08-17 15:55:45');
INSERT INTO invoices VALUES('365','1','115','1','9','1','2021-08-01','2021-09-06 16:08:41','','M/O August','','15500.00','15500.00','Paid','2021-08-01 18:52:07','2021-09-06 20:08:41');
INSERT INTO invoices VALUES('373','1','123','3','36','1','2021-08-30','2021-08-31 16:32:31','','M/O AUGUST','','18000.00','18000.00','Paid','2021-08-31 20:05:17','2021-08-31 20:32:31');
INSERT INTO invoices VALUES('493','1','9','2','20','1','2021-10-01','2021-10-05 15:47:33','','M/O OCTOBER','M/O OCTOBER','24000.00','24000.00','Paid','2021-10-03 21:02:36','2021-10-05 19:47:33');
INSERT INTO invoices VALUES('370','1','120','1','8','1','2021-08-01','2021-11-01 13:10:29','','M/O August','13000-sec instalment 4000','26000.00','26000.00','Paid','2021-08-01 20:13:01','2021-11-01 18:10:29');
INSERT INTO invoices VALUES('375','1','2','2','23','1','2021-09-01','2021-09-04 15:55:06','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:38','2021-09-04 19:55:06');
INSERT INTO invoices VALUES('376','1','4','1','8','1','2021-09-01','2021-09-12 16:19:47','','M/O SEPTEMBER','M/O SEPTEMBER','10000.00','10000.00','Paid','2021-09-02 20:14:38','2021-09-12 20:19:47');
INSERT INTO invoices VALUES('377','1','5','3','30','1','2021-09-01','2021-09-23 12:36:33','','M/O SEPTEMBER','M/O SEPTEMBER','14000.00','14000.00','Paid','2021-09-02 20:14:38','2021-09-23 16:36:33');
INSERT INTO invoices VALUES('378','1','6','3','30','1','2021-09-01','2021-10-07 15:59:54','','M/O SEPTEMBER','M/O SEPTEMBER','7000.00','7000.00','Paid','2021-09-02 20:14:38','2021-10-07 19:59:54');
INSERT INTO invoices VALUES('379','1','9','2','20','1','2021-09-01','2021-09-03 15:10:14','','M/O SEPTEMBER','M/O SEPTEMBER','24000.00','24000.00','Paid','2021-09-02 20:14:38','2021-09-03 19:10:14');
INSERT INTO invoices VALUES('380','1','11','3','40','1','2021-09-01','2021-09-28 15:16:57','','M/O SEPTEMBER','M/O SEPTEMBER','21000.00','21000.00','Paid','2021-09-02 20:14:38','2021-09-28 19:16:57');
INSERT INTO invoices VALUES('381','1','12','2','38','1','2021-09-01','2021-09-13 15:46:24','','M/O SEPTEMBER','M/O SEPTEMBER','18000.00','18000.00','Paid','2021-09-02 20:14:38','2021-09-13 19:46:24');
INSERT INTO invoices VALUES('495','1','15','1','41','1','2021-10-01','2021-10-05 16:18:13','','M/O OCTOBER','M/O OCTOBER','18000.00','18000.00','Paid','2021-10-03 21:02:36','2021-10-05 20:18:13');
INSERT INTO invoices VALUES('383','1','14','3','37','1','2021-09-01','2021-09-12 17:16:33','','M/O SEPTEMBER','M/O SEPTEMBER','15500.00','15500.00','Paid','2021-09-02 20:14:38','2021-09-12 21:16:33');
INSERT INTO invoices VALUES('384','1','15','1','41','1','2021-09-01','2021-09-07 15:29:38','','M/O SEPTEMBER','M/O SEPTEMBER','18000.00','18000.00','Paid','2021-09-02 20:14:38','2021-09-07 19:29:38');
INSERT INTO invoices VALUES('385','1','16','3','34','1','2021-09-01','2021-11-01 12:43:48','','M/O SEPTEMBER','M/O SEPTEMBER','15000.00','15000.00','Paid','2021-09-02 20:14:38','2021-11-01 17:43:48');
INSERT INTO invoices VALUES('386','1','17','3','33','1','2021-09-01','2021-10-05 17:13:20','','M/O SEPTEMBER','M/O SEPTEMBER','25840.00','25840.00','Paid','2021-09-02 20:14:38','2021-10-05 21:13:20');
INSERT INTO invoices VALUES('387','1','18','3','33','1','2021-09-01','2021-09-12 17:10:20','','M/O SEPTEMBER','M/O SEPTEMBER','8500.00','8500.00','Paid','2021-09-02 20:14:38','2021-09-12 21:10:20');
INSERT INTO invoices VALUES('388','1','19','3','33','1','2021-09-01','2021-10-05 17:37:12','','M/O SEPTEMBER','M/O SEPTEMBER','25840.00','25840.00','Paid','2021-09-02 20:14:38','2021-10-05 21:37:12');
INSERT INTO invoices VALUES('389','1','20','3','33','1','2021-09-01','2021-10-05 17:05:36','','M/O SEPTEMBER','M/O SEPTEMBER','8100.00','8100.00','Paid','2021-09-02 20:14:38','2021-10-05 21:05:36');
INSERT INTO invoices VALUES('390','1','21','3','30','1','2021-09-01','2021-09-23 12:39:20','','M/O SEPTEMBER','M/O SEPTEMBER','7000.00','7000.00','Paid','2021-09-02 20:14:38','2021-09-23 16:39:20');
INSERT INTO invoices VALUES('391','1','22','3','35','1','2021-09-01','2021-09-08 16:18:39','','M/O SEPTEMBER','M/O SEPTEMBER','19000.00','19000.00','Paid','2021-09-02 20:14:38','2021-09-08 20:18:39');
INSERT INTO invoices VALUES('392','1','28','3','34','1','2021-09-01','2021-09-12 17:14:31','','M/O SEPTEMBER','M/O SEPTEMBER','20000.00','20000.00','Paid','2021-09-02 20:14:38','2021-09-12 21:14:31');
INSERT INTO invoices VALUES('393','1','29','3','34','1','2021-09-01','2021-09-12 17:13:47','','M/O SEPTEMBER','M/O SEPTEMBER','20000.00','20000.00','Paid','2021-09-02 20:14:38','2021-09-12 21:13:47');
INSERT INTO invoices VALUES('394','1','30','3','30','1','2021-09-01','2021-09-23 12:35:14','','M/O SEPTEMBER','M/O SEPTEMBER','14000.00','14000.00','Paid','2021-09-02 20:14:38','2021-09-23 16:35:14');
INSERT INTO invoices VALUES('395','1','31','3','30','1','2021-09-01','2021-09-23 12:33:20','','M/O SEPTEMBER','M/O SEPTEMBER','7000.00','7000.00','Paid','2021-09-02 20:14:38','2021-09-23 16:33:20');
INSERT INTO invoices VALUES('396','1','32','3','30','1','2021-09-01','2021-09-23 12:39:58','','M/O SEPTEMBER','M/O SEPTEMBER','14000.00','14000.00','Paid','2021-09-02 20:14:38','2021-09-23 16:39:58');
INSERT INTO invoices VALUES('397','1','33','3','29','1','2021-09-01','2021-09-09 16:32:27','','M/O SEPTEMBER','M/O SEPTEMBER','15375.00','15375.00','Paid','2021-09-02 20:14:38','2021-09-09 20:32:27');
INSERT INTO invoices VALUES('398','1','34','3','29','1','2021-09-01','2021-09-20 16:21:35','','M/O SEPTEMBER','M/O SEPTEMBER','16375.00','16375.00','Paid','2021-09-02 20:14:38','2021-09-20 20:21:35');
INSERT INTO invoices VALUES('399','1','35','3','29','1','2021-09-01','2021-10-07 13:08:04','','M/O SEPTEMBER','M/O SEPTEMBER','16375.00','16375.00','Paid','2021-09-02 20:14:38','2021-10-07 17:08:04');
INSERT INTO invoices VALUES('400','1','36','3','29','1','2021-09-01','2021-10-11 12:37:32','','M/O SEPTEMBER','M/O SEPTEMBER','16375.00','16375.00','Paid','2021-09-02 20:14:38','2021-10-11 16:37:32');
INSERT INTO invoices VALUES('401','1','37','3','29','1','2021-09-01','2021-09-12 17:01:04','','M/O SEPTEMBER','M/O SEPTEMBER','7750.00','7750.00','Paid','2021-09-02 20:14:38','2021-09-12 21:01:04');
INSERT INTO invoices VALUES('471','1','129','3','28','1','2021-09-01','2021-09-20 16:16:45','','M/O SEPTEMBER','M/O SEPTEMBER','12000.00','6000.00','Unpaid','2021-09-13 17:17:48','2021-09-20 20:16:45');
INSERT INTO invoices VALUES('403','1','41','3','27','1','2021-09-01','2021-09-07 17:17:03','','M/O SEPTEMBER','M/O SEPTEMBER','16000.00','16000.00','Paid','2021-09-02 20:14:38','2021-09-07 21:17:03');
INSERT INTO invoices VALUES('404','1','42','3','27','1','2021-09-01','2021-09-07 16:50:35','','M/O SEPTEMBER','M/O SEPTEMBER','16000.00','16000.00','Paid','2021-09-02 20:14:38','2021-09-07 20:50:35');
INSERT INTO invoices VALUES('405','1','44','3','26','1','2021-09-01','2021-10-07 16:05:46','','M/O SEPTEMBER','M/O SEPTEMBER','20565.00','20565.00','Paid','2021-09-02 20:14:38','2021-10-07 20:05:46');
INSERT INTO invoices VALUES('406','1','45','3','26','1','2021-09-01','2022-06-06 15:11:27','','M/O SEPTEMBER','M/O SEPTEMBER','20565.00','20565.00','Paid','2021-09-02 20:14:38','2022-06-06 15:11:27');
INSERT INTO invoices VALUES('407','1','46','3','26','1','2021-09-01','2021-11-03 16:22:07','','M/O SEPTEMBER','M/O SEPTEMBER','19560.00','17480.00','Unpaid','2021-09-02 20:14:38','2021-11-03 21:22:07');
INSERT INTO invoices VALUES('496','1','16','3','34','1','2021-10-01','2021-11-19 12:33:08','','M/O OCTOBER','M/O OCTOBER','20000.00','20000.00','Paid','2021-10-03 21:02:36','2021-11-19 17:33:08');
INSERT INTO invoices VALUES('409','1','48','1','16','1','2021-09-01','2021-09-12 16:42:50','','M/O SEPTEMBER','M/O SEPTEMBER','16740.00','16740.00','Paid','2021-09-02 20:14:38','2021-09-12 20:42:50');
INSERT INTO invoices VALUES('410','1','49','2','14','1','2021-09-01','2021-10-22 13:53:44','','M/O SEPTEMBER','M/O SEPTEMBER','14000.00','14000.00','Paid','2021-09-02 20:14:38','2021-10-22 17:53:44');
INSERT INTO invoices VALUES('411','1','50','3','25','1','2021-09-01','2021-09-14 12:31:08','','M/O SEPTEMBER','M/O SEPTEMBER','24800.00','24800.00','Paid','2021-09-02 20:14:38','2021-09-14 16:31:08');
INSERT INTO invoices VALUES('412','1','51','3','25','1','2021-09-01','2021-09-06 16:17:21','','M/O SEPTEMBER','M/O SEPTEMBER','24800.00','24800.00','Paid','2021-09-02 20:14:38','2021-09-06 20:17:21');
INSERT INTO invoices VALUES('413','1','52','3','25','1','2021-09-01','2021-09-14 12:30:34','','M/O SEPTEMBER','M/O SEPTEMBER','24800.00','24800.00','Paid','2021-09-02 20:14:38','2021-09-14 16:30:34');
INSERT INTO invoices VALUES('414','1','53','3','25','1','2021-09-01','2021-09-12 16:54:19','','M/O SEPTEMBER','M/O SEPTEMBER','8750.00','8750.00','Paid','2021-09-02 20:14:38','2021-09-12 20:54:19');
INSERT INTO invoices VALUES('415','1','54','2','23','1','2021-09-01','2021-09-04 15:54:41','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:38','2021-09-04 19:54:41');
INSERT INTO invoices VALUES('416','1','55','2','21','1','2021-09-01','2021-10-05 14:38:13','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:38','2021-10-05 18:38:13');
INSERT INTO invoices VALUES('417','1','56','1','19','1','2021-09-01','2021-09-11 15:55:48','','M/O SEPTEMBER','M/O SEPTEMBER','17270.00','17270.00','Paid','2021-09-02 20:14:38','2021-09-11 19:55:48');
INSERT INTO invoices VALUES('418','1','57','1','19','1','2021-09-01','2021-09-11 15:54:28','','M/O SEPTEMBER','M/O SEPTEMBER','17270.00','17270.00','Paid','2021-09-02 20:14:38','2021-09-11 19:54:28');
INSERT INTO invoices VALUES('419','1','60','2','22','1','2021-09-01','2021-09-04 16:05:37','','M/O SEPTEMBER','M/O SEPTEMBER','12000.00','10000.00','Unpaid','2021-09-02 20:14:38','2021-09-04 20:05:37');
INSERT INTO invoices VALUES('420','1','61','2','22','1','2021-09-01','2021-09-12 16:49:06','','M/O SEPTEMBER','M/O SEPTEMBER','12000.00','12000.00','Paid','2021-09-02 20:14:38','2021-09-12 20:49:06');
INSERT INTO invoices VALUES('421','1','62','2','22','1','2021-09-01','2021-09-12 16:48:38','','M/O SEPTEMBER','M/O SEPTEMBER','12000.00','12000.00','Paid','2021-09-02 20:14:38','2021-09-12 20:48:38');
INSERT INTO invoices VALUES('498','1','18','3','33','1','2021-10-01','2021-10-05 17:09:39','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:36','2021-10-05 21:09:39');
INSERT INTO invoices VALUES('497','1','17','3','33','1','2021-10-01','2021-10-05 17:12:30','','M/O OCTOBER','M/O OCTOBER','22140.00','22140.00','Paid','2021-10-03 21:02:36','2021-10-05 21:12:30');
INSERT INTO invoices VALUES('424','1','65','1','17','1','2021-09-01','2021-09-12 16:45:12','','M/O SEPTEMBER','M/O SEPTEMBER','16000.00','16000.00','Paid','2021-09-02 20:14:38','2021-09-12 20:45:12');
INSERT INTO invoices VALUES('499','1','19','3','33','1','2021-10-01','2021-10-20 13:35:30','','M/O OCTOBER','M/O OCTOBER','28160.00','28160.00','Paid','2021-10-03 21:02:36','2021-10-20 17:35:30');
INSERT INTO invoices VALUES('426','1','67','1','17','1','2021-09-01','2021-09-23 12:28:55','','M/O SEPTEMBER','M/O SEPTEMBER','8000.00','8000.00','Paid','2021-09-02 20:14:38','2021-09-23 16:28:55');
INSERT INTO invoices VALUES('427','1','68','1','16','1','2021-09-01','2021-10-12 16:53:44','','M/O SEPTEMBER','M/O SEPTEMBER','16740.00','16740.00','Paid','2021-09-02 20:14:38','2021-10-12 20:53:44');
INSERT INTO invoices VALUES('428','1','69','1','16','1','2021-09-01','2021-09-04 16:02:29','','M/O SEPTEMBER','M/O SEPTEMBER','16740.00','16740.00','Paid','2021-09-02 20:14:38','2021-09-04 20:02:29');
INSERT INTO invoices VALUES('1345','1','6','3','30','1','2022-05-01','2022-05-08 15:27:34','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:06','2022-05-08 15:27:34');
INSERT INTO invoices VALUES('430','1','71','1','15','1','2021-09-01','2021-09-13 14:00:19','','M/O SEPTEMBER','M/O SEPTEMBER','21200.00','21200.00','Paid','2021-09-02 20:14:38','2021-09-13 18:00:19');
INSERT INTO invoices VALUES('431','1','72','1','15','1','2021-09-01','2021-09-12 14:54:51','','M/O SEPTEMBER','M/O SEPTEMBER','20300.00','20300.00','Paid','2021-09-02 20:14:38','2021-09-12 18:54:51');
INSERT INTO invoices VALUES('500','1','20','3','33','1','2021-10-01','2021-10-05 17:06:32','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:36','2021-10-05 21:06:32');
INSERT INTO invoices VALUES('433','1','74','1','15','1','2021-09-01','2021-09-13 12:40:07','','M/O SEPTEMBER','M/O SEPTEMBER','21200.00','21200.00','Paid','2021-09-02 20:14:38','2021-09-13 16:40:07');
INSERT INTO invoices VALUES('476','1','134','2','14','1','2021-09-20','2021-09-20 16:10:50','','M/O SEPTEMBER','M/O SEPTEMBER','15000.00','15000.00','Paid','2021-09-20 20:10:04','2021-09-20 20:10:50');
INSERT INTO invoices VALUES('435','1','77','2','14','1','2021-09-01','2021-10-09 15:02:26','','M/O SEPTEMBER','M/O SEPTEMBER','14000.00','14000.00','Paid','2021-09-02 20:14:38','2021-10-09 19:02:26');
INSERT INTO invoices VALUES('436','1','78','2','13','1','2021-09-01','2021-09-12 16:30:29','','M/O SEPTEMBER','M/O SEPTEMBER','16000.00','16000.00','Paid','2021-09-02 20:14:38','2021-09-12 20:30:29');
INSERT INTO invoices VALUES('437','1','79','2','13','1','2021-09-01','2021-09-12 16:28:43','','M/O SEPTEMBER','M/O SEPTEMBER','16000.00','16000.00','Paid','2021-09-02 20:14:39','2021-09-12 20:28:43');
INSERT INTO invoices VALUES('438','1','80','2','13','1','2021-09-01','2021-10-05 15:54:17','','M/O SEPTEMBER','M/O SEPTEMBER','16000.00','16000.00','Paid','2021-09-02 20:14:39','2021-10-05 19:54:17');
INSERT INTO invoices VALUES('439','1','81','1','12','1','2021-09-01','2021-09-11 15:47:47','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:39','2021-09-11 19:47:47');
INSERT INTO invoices VALUES('440','1','82','1','12','1','2021-09-01','2021-09-11 15:46:41','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:39','2021-09-11 19:46:41');
INSERT INTO invoices VALUES('441','1','83','1','12','1','2021-09-01','2021-09-11 15:45:45','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:39','2021-09-11 19:45:45');
INSERT INTO invoices VALUES('442','1','88','2','10','1','2021-09-01','2021-10-11 13:36:15','','M/O SEPTEMBER','M/O SEPTEMBER','7750.00','7750.00','Paid','2021-09-02 20:14:39','2021-10-11 17:36:15');
INSERT INTO invoices VALUES('1098','1','4','1','8','1','2022-03-01','2022-03-03 16:28:15','','M/O MARCH','','10000.00','10000.00','Paid','2022-03-02 17:32:35','2022-03-03 21:28:15');
INSERT INTO invoices VALUES('501','1','21','3','30','1','2021-10-01','2021-10-07 12:13:23','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:36','2021-10-07 16:13:23');
INSERT INTO invoices VALUES('445','1','93','1','8','1','2021-09-01','2021-09-16 15:08:04','','M/O SEPTEMBER','M/O SEPTEMBER','13000.00','13000.00','Paid','2021-09-02 20:14:39','2021-09-16 19:08:04');
INSERT INTO invoices VALUES('446','1','96','1','7','1','2021-09-01','2021-09-11 15:50:30','','M/O SEPTEMBER','M/O SEPTEMBER','16500.00','16500.00','Paid','2021-09-02 20:14:39','2021-09-11 19:50:30');
INSERT INTO invoices VALUES('447','1','97','1','7','1','2021-09-01','2021-09-30 16:00:50','','M/O SEPTEMBER','M/O SEPTEMBER','15000.00','15000.00','Paid','2021-09-02 20:14:39','2021-09-30 20:00:50');
INSERT INTO invoices VALUES('448','1','98','1','6','1','2021-09-01','2021-09-23 12:21:25','','M/O SEPTEMBER','M/O SEPTEMBER','9000.00','9000.00','Paid','2021-09-02 20:14:39','2021-09-23 16:21:25');
INSERT INTO invoices VALUES('449','1','99','1','6','1','2021-09-01','2021-09-12 14:51:04','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:39','2021-09-12 18:51:04');
INSERT INTO invoices VALUES('450','1','100','1','5','1','2021-09-01','2021-09-23 12:19:41','','M/O SEPTEMBER','M/O SEPTEMBER','10760.00','10760.00','Paid','2021-09-02 20:14:39','2021-09-23 16:19:41');
INSERT INTO invoices VALUES('451','1','101','1','5','1','2021-09-01','2021-10-04 15:25:12','','M/O SEPTEMBER','M/O SEPTEMBER','10770.00','10770.00','Paid','2021-09-02 20:14:39','2021-10-04 19:25:12');
INSERT INTO invoices VALUES('452','1','102','1','5','1','2021-09-01','2021-09-09 12:45:00','','M/O SEPTEMBER','M/O SEPTEMBER','19260.00','19260.00','Paid','2021-09-02 20:14:39','2021-09-09 16:45:00');
INSERT INTO invoices VALUES('453','1','103','1','2','1','2021-09-01','2021-09-12 16:11:16','','M/O SEPTEMBER','M/O SEPTEMBER','18000.00','18000.00','Paid','2021-09-02 20:14:39','2021-09-12 20:11:16');
INSERT INTO invoices VALUES('454','1','104','1','3','1','2021-09-01','2021-09-16 15:05:45','','M/O SEPTEMBER','M/O SEPTEMBER','18000.00','18000.00','Paid','2021-09-02 20:14:39','2021-09-16 19:05:45');
INSERT INTO invoices VALUES('502','1','22','3','35','1','2021-10-01','2021-11-09 15:18:01','','M/O OCTOBER','M/O OCTOBER','19000.00','19000.00','Paid','2021-10-03 21:02:36','2021-11-09 20:18:01');
INSERT INTO invoices VALUES('456','1','107','1','1','1','2021-09-01','2021-09-20 15:32:47','','M/O SEPTEMBER','M/O SEPTEMBER','14000.00','14000.00','Paid','2021-09-02 20:14:39','2021-09-20 19:32:47');
INSERT INTO invoices VALUES('457','1','108','1','1','1','2021-09-01','2021-10-14 18:51:11','','M/O SEPTEMBER','M/O SEPTEMBER','6000.00','6000.00','Paid','2021-09-02 20:14:39','2021-10-14 22:51:11');
INSERT INTO invoices VALUES('458','1','110','1','1','1','2021-09-01','2021-09-12 16:09:27','','M/O SEPTEMBER','M/O SEPTEMBER','7500.00','7500.00','Paid','2021-09-02 20:14:39','2021-09-12 20:09:27');
INSERT INTO invoices VALUES('459','1','111','1','1','1','2021-09-01','2021-09-08 14:06:32','','M/O SEPTEMBER','M/O SEPTEMBER','13000.00','13000.00','Paid','2021-09-02 20:14:39','2021-09-08 18:06:32');
INSERT INTO invoices VALUES('460','1','112','1','1','1','2021-09-01','2021-09-08 13:35:38','','M/O SEPTEMBER','M/O SEPTEMBER','13000.00','13000.00','Paid','2021-09-02 20:14:39','2021-09-08 17:35:38');
INSERT INTO invoices VALUES('461','1','113','1','12','1','2021-09-01','2021-09-11 15:43:59','','M/O SEPTEMBER','M/O SEPTEMBER','20480.00','20480.00','Paid','2021-09-02 20:14:39','2021-09-11 19:43:59');
INSERT INTO invoices VALUES('462','1','114','3','32','1','2021-09-01','2021-09-08 16:42:45','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-02 20:14:39','2021-09-08 20:42:45');
INSERT INTO invoices VALUES('463','1','115','1','9','1','2021-09-01','2021-09-06 16:09:23','','M/O SEPTEMBER','M/O SEPTEMBER','15500.00','15500.00','Paid','2021-09-02 20:14:39','2021-09-06 20:09:23');
INSERT INTO invoices VALUES('464','1','121','1','4','1','2021-09-01','2021-12-06 12:50:24','','M/O SEPTEMBER','M/O SEPTEMBER','34000.00','34000.00','Paid','2021-09-02 20:14:39','2021-12-06 17:50:24');
INSERT INTO invoices VALUES('465','1','123','3','36','1','2021-09-01','2021-10-10 15:04:15','','M/O SEPTEMBER','M/O SEPTEMBER','34000.00','34000.00','Paid','2021-09-02 20:14:39','2021-10-10 19:04:15');
INSERT INTO invoices VALUES('466','1','124','2','21','1','2021-09-01','2021-09-12 12:49:49','','M/O SEPTEMBER','M/O SEPTEMBER','27500.00','27500.00','Paid','2021-09-02 20:14:39','2021-09-12 16:49:49');
INSERT INTO invoices VALUES('467','1','125','3','32','1','2021-09-01','2021-09-08 16:51:58','','M/O SEPTEMBER','M/O SEPTEMBER','34000.00','34000.00','Paid','2021-09-08 20:50:47','2021-09-08 20:51:58');
INSERT INTO invoices VALUES('468','1','126','1','4','1','2021-09-01','2021-09-09 17:04:06','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-09 21:00:11','2021-09-09 21:04:06');
INSERT INTO invoices VALUES('469','1','127','1','4','1','2021-09-01','2021-09-09 17:02:35','','M/O SEPTEMBER','M/O SEPTEMBER','17000.00','17000.00','Paid','2021-09-09 21:01:14','2021-09-09 21:02:35');
INSERT INTO invoices VALUES('470','1','128','1','1','1','2021-09-01','2021-11-08 15:55:19','','M/O SEPTEMBER','M/O SEPTEMBER','30000.00','30000.00','Paid','2021-09-12 20:04:21','2021-11-08 20:55:19');
INSERT INTO invoices VALUES('1099','1','5','3','30','1','2022-03-01','2022-03-08 11:15:43','','M/O MARCH','','16000.00','16000.00','Paid','2022-03-02 17:32:35','2022-03-08 16:15:43');
INSERT INTO invoices VALUES('474','1','130','1','8','1','2021-09-18','2021-09-20 16:00:00','','M/O SEPTEMBER','M/O SEPTEMBER','21000.00','21000.00','Paid','2021-09-20 19:58:24','2021-09-20 20:00:00');
INSERT INTO invoices VALUES('475','1','135','2','11','1','2021-09-17','2021-09-20 16:05:14','','M/O SEPTEMBER','M/O SEPTEMBER','16240.00','16240.00','Paid','2021-09-20 20:04:27','2021-09-20 20:05:14');
INSERT INTO invoices VALUES('477','1','131','3','28','1','2021-09-01','2021-11-01 13:03:11','','M/O SEPTEMBER','M/O SEPTEMBER','29000.00','29000.00','Paid','2021-09-20 20:15:10','2021-11-01 18:03:11');
INSERT INTO invoices VALUES('478','1','132','2','24','1','2021-09-18','2021-09-20 16:28:30','','M/O SEPTEMBER','M/O SEPTEMBER','23500.00','23500.00','Paid','2021-09-20 20:27:53','2021-09-20 20:28:30');
INSERT INTO invoices VALUES('479','1','147','2','11','1','2021-09-28','2021-09-29 16:19:39','','M/O SEPTEMBER','M/O SEPTEMBER','5000.00','5000.00','Paid','2021-09-29 20:18:30','2021-09-29 20:19:39');
INSERT INTO invoices VALUES('480','1','149','2','24','1','2021-09-27','2021-09-29 16:30:14','','M/O SEPTEMBER','M/O SEPTEMBER','2500.00','2500.00','Paid','2021-09-29 20:21:49','2021-09-29 20:30:14');
INSERT INTO invoices VALUES('481','1','150','2','24','1','2021-09-27','2021-09-29 16:24:01','','M/O SEPTEMBER','M/O SEPTEMBER','2500.00','2500.00','Paid','2021-09-29 20:23:05','2021-09-29 20:24:01');
INSERT INTO invoices VALUES('482','1','141','3','26','1','2021-09-20','2021-10-05 17:17:00','','M/O SEPTEMBER','M/O SEPTEMBER','15000.00','15000.00','Paid','2021-09-29 20:33:55','2021-10-05 21:17:00');
INSERT INTO invoices VALUES('483','1','143','2','39','1','2021-09-26','2021-09-29 16:44:09','','M/O SEPTEMBER','M/O SEPTEMBER','5000.00','5000.00','Paid','2021-09-29 20:40:17','2021-09-29 20:44:09');
INSERT INTO invoices VALUES('484','1','139','3','28','1','2021-09-27','2021-09-29 16:55:41','','M/O SEPTEMBER','M/O SEPTEMBER','19000.00','19000.00','Paid','2021-09-29 20:53:32','2021-09-29 20:55:41');
INSERT INTO invoices VALUES('485','1','140','3','28','1','2021-09-27','2021-09-29 16:56:10','','M/O SEPTEMBER','M/O SEPTEMBER','10000.00','10000.00','Paid','2021-09-29 20:54:33','2021-09-29 20:56:10');
INSERT INTO invoices VALUES('486','1','137','2','13','1','2021-09-27','2021-09-29 17:15:37','','M/O SEPTEMBER','M/O SEPTEMBER','21000.00','21000.00','Paid','2021-09-29 21:13:16','2021-09-29 21:15:37');
INSERT INTO invoices VALUES('487','1','148','2','13','1','2021-09-28','2021-09-29 17:15:04','','M/O SEPTEMBER','M/O SEPTEMBER','21000.00','21000.00','Paid','2021-09-29 21:13:58','2021-09-29 21:15:04');
INSERT INTO invoices VALUES('488','1','131','1','18','1','2021-09-29','2021-09-30 16:51:31','','M/O SEPTEMBER','M/O SEPTEMBER','3325.00','3325.00','Paid','2021-09-30 20:51:07','2021-09-30 20:51:31');
INSERT INTO invoices VALUES('503','1','28','3','34','1','2021-10-01','2021-10-09 15:26:44','','M/O OCTOBER','M/O OCTOBER','20000.00','20000.00','Paid','2021-10-03 21:02:36','2021-10-09 19:26:44');
INSERT INTO invoices VALUES('504','1','29','3','34','1','2021-10-01','2021-10-09 15:26:05','','M/O OCTOBER','M/O OCTOBER','20000.00','20000.00','Paid','2021-10-03 21:02:36','2021-10-09 19:26:05');
INSERT INTO invoices VALUES('505','1','30','3','30','1','2021-10-01','2021-10-08 11:09:38','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:36','2021-10-08 15:09:38');
INSERT INTO invoices VALUES('506','1','31','3','30','1','2021-10-01','2021-10-09 14:56:22','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:36','2021-10-09 18:56:22');
INSERT INTO invoices VALUES('507','1','32','3','30','1','2021-10-01','2021-10-09 15:00:35','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:36','2021-10-09 19:00:35');
INSERT INTO invoices VALUES('508','1','34','3','29','1','2021-10-01','2021-11-10 13:43:34','','M/O OCTOBER','M/O OCTOBER','17370.00','17370.00','Paid','2021-10-03 21:02:36','2021-11-10 18:43:34');
INSERT INTO invoices VALUES('509','1','35','3','29','1','2021-10-01','2021-11-10 15:11:25','','M/O OCTOBER','M/O OCTOBER','17370.00','17370.00','Paid','2021-10-03 21:02:36','2021-11-10 20:11:25');
INSERT INTO invoices VALUES('510','1','36','3','29','1','2021-10-01','2021-10-14 18:22:52','','M/O OCTOBER','M/O OCTOBER','17370.00','17370.00','Paid','2021-10-03 21:02:36','2021-10-14 22:22:52');
INSERT INTO invoices VALUES('511','1','37','3','29','1','2021-10-01','2021-10-05 17:26:41','','M/O OCTOBER','M/O OCTOBER','15500.00','15500.00','Paid','2021-10-03 21:02:36','2021-10-05 21:26:41');
INSERT INTO invoices VALUES('512','1','41','3','27','1','2021-10-01','2021-10-05 17:20:22','','M/O OCTOBER','M/O OCTOBER','16000.00','16000.00','Paid','2021-10-03 21:02:36','2021-10-05 21:20:22');
INSERT INTO invoices VALUES('513','1','42','3','27','1','2021-10-01','2021-10-05 17:23:50','','M/O OCTOBER','M/O OCTOBER','16000.00','16000.00','Paid','2021-10-03 21:02:36','2021-10-05 21:23:50');
INSERT INTO invoices VALUES('514','1','44','3','26','1','2021-10-01','2021-10-09 14:45:28','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:36','2021-10-09 18:45:28');
INSERT INTO invoices VALUES('515','1','45','3','26','1','2021-10-01','2021-10-07 16:02:58','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:36','2021-10-07 20:02:58');
INSERT INTO invoices VALUES('516','1','46','3','26','1','2021-10-01','2021-11-03 16:21:15','','M/O OCTOBER','M/O OCTOBER','16520.00','16520.00','Paid','2021-10-03 21:02:36','2021-11-03 21:21:15');
INSERT INTO invoices VALUES('517','1','48','1','16','1','2021-10-01','2021-10-06 13:26:58','','M/O OCTOBER','M/O OCTOBER','16470.00','16470.00','Paid','2021-10-03 21:02:37','2021-10-06 17:26:58');
INSERT INTO invoices VALUES('518','1','49','2','14','1','2021-10-01','2021-10-22 13:54:20','','M/O OCTOBER','M/O OCTOBER','13000.00','13000.00','Paid','2021-10-03 21:02:37','2021-10-22 17:54:20');
INSERT INTO invoices VALUES('519','1','50','3','25','1','2021-10-01','2021-10-11 12:35:20','','M/O OCTOBER','M/O OCTOBER','22590.00','22590.00','Paid','2021-10-03 21:02:37','2021-10-11 16:35:20');
INSERT INTO invoices VALUES('520','1','51','3','25','1','2021-10-01','2021-10-06 15:27:45','','M/O OCTOBER','M/O OCTOBER','22590.00','22590.00','Paid','2021-10-03 21:02:37','2021-10-06 19:27:45');
INSERT INTO invoices VALUES('521','1','52','3','25','1','2021-10-01','2021-10-22 13:55:15','','M/O OCTOBER','M/O OCTOBER','22590.00','22590.00','Paid','2021-10-03 21:02:37','2021-10-22 17:55:15');
INSERT INTO invoices VALUES('522','1','53','3','25','1','2021-10-01','2021-10-05 16:59:36','','M/O OCTOBER','M/O OCTOBER','17500.00','17500.00','Paid','2021-10-03 21:02:37','2021-10-05 20:59:36');
INSERT INTO invoices VALUES('523','1','54','2','23','1','2021-10-01','2021-10-03 18:01:33','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:37','2021-10-03 22:01:33');
INSERT INTO invoices VALUES('524','1','55','1','17','1','2021-10-01','2021-10-05 14:38:56','','M/O OCTOBER','M/O OCTOBER','19000.00','19000.00','Paid','2021-10-03 21:02:37','2021-10-05 18:38:56');
INSERT INTO invoices VALUES('525','1','56','1','19','1','2021-10-01','2021-10-07 12:18:40','','M/O OCTOBER','M/O OCTOBER','18120.00','18120.00','Paid','2021-10-03 21:02:37','2021-10-07 16:18:40');
INSERT INTO invoices VALUES('526','1','57','1','19','1','2021-10-01','2021-10-20 16:18:42','','M/O OCTOBER','M/O OCTOBER','18120.00','18120.00','Paid','2021-10-03 21:02:37','2021-10-20 20:18:42');
INSERT INTO invoices VALUES('527','1','59','2','14','1','2021-10-01','2021-10-05 13:06:20','','M/O OCTOBER','M/O OCTOBER','15000.00','15000.00','Paid','2021-10-03 21:02:37','2021-10-05 17:06:20');
INSERT INTO invoices VALUES('528','1','60','2','22','1','2021-10-01','2021-10-05 16:46:34','','M/O OCTOBER','M/O OCTOBER','12000.00','12000.00','Paid','2021-10-03 21:02:37','2021-10-05 20:46:34');
INSERT INTO invoices VALUES('529','1','61','2','22','1','2021-10-01','2021-10-06 14:05:46','','M/O OCTOBER','M/O OCTOBER','12000.00','12000.00','Paid','2021-10-03 21:02:37','2021-10-06 18:05:46');
INSERT INTO invoices VALUES('530','1','62','2','22','1','2021-10-01','2021-10-20 13:34:50','','M/O OCTOBER','M/O OCTOBER','12000.00','12000.00','Paid','2021-10-03 21:02:37','2021-10-20 17:34:50');
INSERT INTO invoices VALUES('531','1','68','1','16','1','2021-10-01','2021-10-20 13:07:21','','M/O OCTOBER','M/O OCTOBER','8470.00','8470.00','Paid','2021-10-03 21:02:37','2021-10-20 17:07:21');
INSERT INTO invoices VALUES('532','1','69','1','16','1','2021-10-01','2021-10-04 13:59:09','','M/O OCTOBER','M/O OCTOBER','16500.00','16500.00','Paid','2021-10-03 21:02:37','2021-10-04 17:59:09');
INSERT INTO invoices VALUES('977','1','2','2','23','1','2022-02-01','2022-02-06 13:00:54','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:02','2022-02-06 18:00:54');
INSERT INTO invoices VALUES('534','1','71','1','15','1','2021-10-01','2021-10-13 12:29:43','','M/O OCTOBER','M/O OCTOBER','19825.00','19825.00','Paid','2021-10-03 21:02:37','2021-10-13 16:29:43');
INSERT INTO invoices VALUES('535','1','72','1','15','1','2021-10-01','2021-10-07 11:55:47','','M/O OCTOBER','M/O OCTOBER','20330.00','20330.00','Paid','2021-10-03 21:02:37','2021-10-07 15:55:47');
INSERT INTO invoices VALUES('536','1','74','1','15','1','2021-10-01','2021-11-01 15:59:25','','M/O OCTOBER','M/O OCTOBER','29825.00','29825.00','Paid','2021-10-03 21:02:37','2021-11-01 20:59:25');
INSERT INTO invoices VALUES('537','1','77','2','14','1','2021-10-01','2021-10-05 17:03:34','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:37','2021-10-05 21:03:34');
INSERT INTO invoices VALUES('538','1','78','2','10','1','2021-10-01','2021-10-07 16:13:08','','M/O OCTOBER','M/O OCTOBER','15500.00','15500.00','Paid','2021-10-03 21:02:37','2021-10-07 20:13:08');
INSERT INTO invoices VALUES('539','1','79','2','10','1','2021-10-01','2021-10-05 14:07:02','','M/O OCTOBER','M/O OCTOBER','15500.00','15500.00','Paid','2021-10-03 21:02:37','2021-10-05 18:07:02');
INSERT INTO invoices VALUES('540','1','80','1','4','1','2021-10-01','2022-04-24 10:43:00','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:37','2022-04-24 10:43:00');
INSERT INTO invoices VALUES('541','1','81','1','12','1','2021-10-01','2021-10-06 13:55:20','','M/O OCTOBER','M/O OCTOBER','17000.00','14000.00','Unpaid','2021-10-03 21:02:37','2021-10-06 17:55:20');
INSERT INTO invoices VALUES('542','1','82','1','12','1','2021-10-01','2021-10-06 13:48:49','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:37','2021-10-06 17:48:49');
INSERT INTO invoices VALUES('543','1','83','1','12','1','2021-10-01','2021-10-09 15:36:24','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:37','2021-10-09 19:36:24');
INSERT INTO invoices VALUES('544','1','88','2','10','1','2021-10-01','2021-11-19 12:37:55','','M/O OCTOBER','M/O OCTOBER','15500.00','15500.00','Paid','2021-10-03 21:02:37','2021-11-19 17:37:55');
INSERT INTO invoices VALUES('545','1','93','1','8','1','2021-10-01','2021-10-04 17:41:15','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:37','2021-10-04 21:41:15');
INSERT INTO invoices VALUES('546','1','96','1','7','1','2021-10-01','2021-10-06 13:50:04','','M/O OCTOBER','M/O OCTOBER','16500.00','16500.00','Paid','2021-10-03 21:02:37','2021-10-06 17:50:04');
INSERT INTO invoices VALUES('547','1','97','1','7','1','2021-10-01','2021-11-19 12:20:54','','M/O OCTOBER','M/O OCTOBER','18000.00','18000.00','Paid','2021-10-03 21:02:37','2021-11-19 17:20:54');
INSERT INTO invoices VALUES('548','1','98','1','6','1','2021-10-01','2021-10-13 16:54:45','','M/O OCTOBER','M/O OCTOBER','18000.00','18000.00','Paid','2021-10-03 21:02:37','2021-10-13 20:54:45');
INSERT INTO invoices VALUES('549','1','99','1','6','1','2021-10-01','2021-10-04 17:38:35','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:37','2021-10-04 21:38:35');
INSERT INTO invoices VALUES('550','1','100','1','5','1','2021-10-01','2021-10-06 13:33:11','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:37','2021-10-06 17:33:11');
INSERT INTO invoices VALUES('551','1','101','1','5','1','2021-10-01','2022-02-16 14:34:50','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:37','2022-02-16 19:34:50');
INSERT INTO invoices VALUES('552','1','102','1','5','1','2021-10-01','2021-10-20 16:53:05','','M/O OCTOBER','M/O OCTOBER','20260.00','20260.00','Paid','2021-10-03 21:02:37','2021-10-20 20:53:05');
INSERT INTO invoices VALUES('600','1','76','2','14','1','2021-10-01','2021-10-09 17:41:36','','M/O OCTOBER','M/O OCTOBER','13000.00','13000.00','Paid','2021-10-09 21:40:27','2021-10-09 21:41:36');
INSERT INTO invoices VALUES('554','1','104','1','3','1','2021-10-01','2021-10-06 13:20:42','','M/O OCTOBER','M/O OCTOBER','18000.00','18000.00','Paid','2021-10-03 21:02:37','2021-10-06 17:20:42');
INSERT INTO invoices VALUES('555','1','107','1','1','1','2021-10-01','2021-10-22 14:46:41','','M/O OCTOBER','M/O OCTOBER','15000.00','15000.00','Paid','2021-10-03 21:02:38','2021-10-22 18:46:41');
INSERT INTO invoices VALUES('556','1','108','1','1','1','2021-10-01','2021-10-14 18:50:38','','M/O OCTOBER','M/O OCTOBER','15000.00','15000.00','Paid','2021-10-03 21:02:38','2021-10-14 22:50:38');
INSERT INTO invoices VALUES('557','1','110','1','1','1','2021-10-01','2021-11-01 15:08:35','','M/O OCTOBER','M/O OCTOBER','15000.00','15000.00','Paid','2021-10-03 21:02:38','2021-11-01 20:08:35');
INSERT INTO invoices VALUES('558','1','111','1','1','1','2021-10-01','2021-10-09 16:03:12','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:38','2021-10-09 20:03:12');
INSERT INTO invoices VALUES('559','1','112','1','1','1','2021-10-01','2021-10-12 16:50:04','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:38','2021-10-12 20:50:04');
INSERT INTO invoices VALUES('560','1','113','1','12','1','2021-10-01','2021-10-14 19:24:24','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-03 21:02:38','2021-10-14 23:24:24');
INSERT INTO invoices VALUES('601','1','155','3','43','1','2021-10-01','2021-10-10 17:33:35','','M/O OCTOBER','M/O OCTOBER','44000.00','44000.00','Paid','2021-10-10 21:29:29','2021-10-10 21:33:35');
INSERT INTO invoices VALUES('562','1','115','1','9','1','2021-10-01','2021-10-05 16:05:21','','M/O OCTOBER','M/O OCTOBER','15500.00','15500.00','Paid','2021-10-03 21:02:38','2021-10-05 20:05:21');
INSERT INTO invoices VALUES('563','1','121','1','15','1','2021-10-01','2021-10-04 14:31:39','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:38','2021-10-04 18:31:39');
INSERT INTO invoices VALUES('564','1','123','3','36','1','2021-10-01','2021-12-13 12:34:02','','M/O OCTOBER','M/O OCTOBER','18000.00','18000.00','Paid','2021-10-03 21:02:38','2021-12-13 17:34:02');
INSERT INTO invoices VALUES('565','1','124','2','21','1','2021-10-01','2021-10-05 16:43:26','','M/O OCTOBER','M/O OCTOBER','17500.00','17500.00','Paid','2021-10-03 21:02:38','2021-10-05 20:43:26');
INSERT INTO invoices VALUES('566','1','125','3','32','1','2021-10-01','2021-10-13 14:57:28','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:38','2021-10-13 18:57:28');
INSERT INTO invoices VALUES('1101','1','9','2','20','1','2022-03-01','2022-03-02 12:33:52','','M/O MARCH','','24000.00','24000.00','Paid','2022-03-02 17:32:35','2022-03-02 17:33:52');
INSERT INTO invoices VALUES('1102','1','12','1','16','1','2022-03-01','2022-03-08 17:28:15','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-08 22:28:15');
INSERT INTO invoices VALUES('569','1','128','1','1','1','2021-10-01','2021-10-09 15:03:23','','M/O OCTOBER','M/O OCTOBER','15000.00','15000.00','Paid','2021-10-03 21:02:38','2021-10-09 19:03:23');
INSERT INTO invoices VALUES('570','1','129','1','18','1','2021-10-01','2021-10-05 15:46:28','','M/O OCTOBER','M/O OCTOBER','24135.00','24135.00','Paid','2021-10-03 21:02:38','2021-10-05 19:46:28');
INSERT INTO invoices VALUES('571','1','130','1','8','1','2021-10-01','2021-10-04 17:39:52','','M/O OCTOBER','M/O OCTOBER','15000.00','15000.00','Paid','2021-10-03 21:02:38','2021-10-04 21:39:52');
INSERT INTO invoices VALUES('572','1','131','1','18','1','2021-10-01','2021-11-01 13:03:58','','M/O OCTOBER','M/O OCTOBER','24700.00','24700.00','Paid','2021-10-03 21:02:38','2021-11-01 18:03:58');
INSERT INTO invoices VALUES('573','1','132','2','24','1','2021-10-01','2021-10-09 15:50:40','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:38','2021-10-09 19:50:40');
INSERT INTO invoices VALUES('574','1','133','2','11','1','2021-10-01','2021-10-07 15:40:29','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:38','2021-10-07 19:40:29');
INSERT INTO invoices VALUES('575','1','134','2','14','1','2021-10-01','2021-10-07 16:09:03','','M/O OCTOBER','M/O OCTOBER','15000.00','15000.00','Paid','2021-10-03 21:02:38','2021-10-07 20:09:03');
INSERT INTO invoices VALUES('576','1','135','2','11','1','2021-10-01','2021-10-05 14:08:09','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:38','2021-10-05 18:08:09');
INSERT INTO invoices VALUES('577','1','136','1','8','1','2021-10-01','2021-11-07 13:29:25','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:38','2021-11-07 18:29:25');
INSERT INTO invoices VALUES('578','1','137','2','13','1','2021-10-01','2021-10-05 14:28:03','','M/O OCTOBER','M/O OCTOBER','26000.00','26000.00','Paid','2021-10-03 21:02:38','2021-10-05 18:28:03');
INSERT INTO invoices VALUES('579','1','138','1','17','1','2021-10-01','2021-10-09 15:39:02','','M/O OCTOBER','M/O OCTOBER','34000.00','34000.00','Paid','2021-10-03 21:02:38','2021-10-09 19:39:02');
INSERT INTO invoices VALUES('580','1','139','3','28','1','2021-10-01','2021-10-05 17:25:08','','M/O OCTOBER','M/O OCTOBER','19000.00','19000.00','Paid','2021-10-03 21:02:38','2021-10-05 21:25:08');
INSERT INTO invoices VALUES('581','1','140','3','28','1','2021-10-01','2021-10-05 17:24:38','','M/O OCTOBER','M/O OCTOBER','17500.00','17500.00','Paid','2021-10-03 21:02:38','2021-10-05 21:24:38');
INSERT INTO invoices VALUES('582','1','141','3','26','1','2021-10-01','2021-10-05 17:17:40','','M/O OCTOBER','M/O OCTOBER','17500.00','17500.00','Paid','2021-10-03 21:02:38','2021-10-05 21:17:40');
INSERT INTO invoices VALUES('583','1','142','1','4','1','2021-10-01','2021-12-09 14:58:25','','M/O OCTOBER','M/O OCTOBER','29500.00','29500.00','Paid','2021-10-03 21:02:38','2021-12-09 19:58:25');
INSERT INTO invoices VALUES('584','1','143','2','39','1','2021-10-01','2022-02-15 12:34:47','','M/O OCTOBER','M/O OCTOBER','13000.00','11000.00','Unpaid','2021-10-03 21:02:38','2022-02-15 17:34:47');
INSERT INTO invoices VALUES('585','1','144','1','4','1','2021-10-01','2021-10-13 12:16:52','','M/O OCTOBER','M/O OCTOBER','29500.00','29500.00','Paid','2021-10-03 21:02:38','2021-10-13 16:16:52');
INSERT INTO invoices VALUES('586','1','145','1','4','1','2021-10-01','2021-12-09 14:57:30','','M/O OCTOBER','M/O OCTOBER','29500.00','29500.00','Paid','2021-10-03 21:02:38','2021-12-09 19:57:30');
INSERT INTO invoices VALUES('587','1','146','2','10','1','2021-10-01','2021-10-09 17:47:17','','M/O OCTOBER','M/O OCTOBER','20500.00','20500.00','Paid','2021-10-03 21:02:38','2021-10-09 21:47:17');
INSERT INTO invoices VALUES('588','1','147','2','11','1','2021-10-01','2021-10-06 13:47:26','','M/O OCTOBER','M/O OCTOBER','17000.00','17000.00','Paid','2021-10-03 21:02:39','2021-10-06 17:47:26');
INSERT INTO invoices VALUES('589','1','152','2','21','1','2021-10-01','2021-10-05 16:45:33','','M/O OCTOBER','M/O OCTOBER','33000.00','33000.00','Paid','2021-10-03 21:02:39','2021-10-05 20:45:33');
INSERT INTO invoices VALUES('590','1','153','1','9','1','2021-10-01','2021-10-05 13:54:32','','M/O OCTOBER','M/O OCTOBER','30000.00','30000.00','Paid','2021-10-03 21:02:39','2021-10-05 17:54:32');
INSERT INTO invoices VALUES('591','1','154','1','9','1','2021-10-01','2021-10-06 13:21:34','','M/O OCTOBER','M/O OCTOBER','34000.00','34000.00','Paid','2021-10-03 21:02:39','2021-10-06 17:21:34');
INSERT INTO invoices VALUES('592','1','122','1','8','1','2021-10-01','2021-10-05 15:52:33','','M/O OCTOBER','M/O OCTOBER','28000.00','28000.00','Paid','2021-10-05 17:37:35','2021-10-05 19:52:33');
INSERT INTO invoices VALUES('593','1','148','2','13','1','2021-10-01','2021-10-07 12:12:40','','M/O OCTOBER','M/O OCTOBER','26000.00','26000.00','Paid','2021-10-05 18:25:30','2021-10-07 16:12:40');
INSERT INTO invoices VALUES('594','1','149','2','24','1','2021-10-04','2021-10-25 12:43:41','','M/O OCTOBER','M/O OCTOBER','27000.00','27000.00','Paid','2021-10-06 20:05:52','2021-10-25 16:43:41');
INSERT INTO invoices VALUES('598','1','157','1','12','1','2021-10-01','2021-10-09 15:35:49','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-09 19:35:10','2021-10-09 19:35:49');
INSERT INTO invoices VALUES('597','1','156','1','12','1','2021-10-01','2021-10-12 16:56:40','','M/O OCTOBER','M/O OCTOBER','14000.00','14000.00','Paid','2021-10-09 19:29:11','2021-10-12 20:56:40');
INSERT INTO invoices VALUES('599','1','12','2','38','1','2021-10-01','2021-11-09 15:38:38','','M/O OCTOBER','M/O OCTOBER','36000.00','36000.00','Paid','2021-10-09 20:08:09','2021-11-09 20:38:38');
INSERT INTO invoices VALUES('602','1','158','3','43','1','2021-10-01','2021-10-10 17:32:13','','M/O OCTOBER','M/O OCTOBER','44000.00','44000.00','Paid','2021-10-10 21:30:08','2021-10-10 21:32:13');
INSERT INTO invoices VALUES('603','1','43','3','27','1','2021-10-11','2021-10-11 13:11:14','','M/O OCTOBER','M/O OCTOBER','29500.00','29500.00','Paid','2021-10-11 17:10:36','2021-10-11 17:11:14');
INSERT INTO invoices VALUES('604','1','144','1','4','1','2021-10-13','2021-10-13 12:16:20','','M/O OCTOBER','CHANGE FAIZAN TO YOUSAF  FAIZAN PAY 6000 AND YOUSAF PAY 7000+17500 ADJUST FAUZAN PAYMENT','1000.00','1000.00','Paid','2021-10-13 16:15:46','2021-10-13 16:16:20');
INSERT INTO invoices VALUES('605','1','159','2','24','1','2021-10-13','2021-10-13 12:37:24','','M/O OCTOBER','18 DAYS','27200.00','27200.00','Paid','2021-10-13 16:35:47','2021-10-13 16:37:24');
INSERT INTO invoices VALUES('606','1','114','3','32','1','2021-10-13','2021-10-13 15:34:07','','M/O OCTOBER','REPLACE ABDUL REHMAN','10800.00','10800.00','Paid','2021-10-13 19:31:00','2021-10-13 19:34:07');
INSERT INTO invoices VALUES('607','1','114','3','32','1','2021-10-13','2021-10-14 14:46:37','','M/O OCTOBER','','19000.00','19000.00','Paid','2021-10-13 19:33:36','2021-10-14 18:46:37');
INSERT INTO invoices VALUES('608','1','116','4','42','1','2021-10-21','2021-10-22 13:57:20','','M/O OCTOBER','M/O OCTOBER','1000.00','1000.00','Paid','2021-10-22 17:56:45','2021-10-22 17:57:20');
INSERT INTO invoices VALUES('609','1','109','3','29','1','2021-10-25','2021-12-12 12:04:06','','M/O OCTOBER','AQIB REPLACE  EHSAN 9000 PRE BALANCE AQIB
SEC 1000+9000','16500.00','16500.00','Paid','2021-10-25 20:47:01','2021-12-12 17:04:06');
INSERT INTO invoices VALUES('610','1','131','3','44','1','2021-10-31','2021-11-01 13:03:33','','M/O OCTOBER SEC FEE','M/O OCTOBER SEC FEE REPLACE ATTAULLAH 3000+3700+9800','9800.00','9800.00','Paid','2021-11-01 18:02:37','2021-11-01 18:03:33');
INSERT INTO invoices VALUES('611','1','120','3','44','1','2021-10-31','2021-11-01 13:10:03','','M/O OCTOBER SEC FEE','M/O OCTOBER SEC FEE 9000+6500 REPLACE AIMAL KHAN','6500.00','6500.00','Paid','2021-11-01 18:09:27','2021-11-01 18:10:03');
INSERT INTO invoices VALUES('612','1','2','2','23','1','2021-11-01','2021-11-05 15:46:21','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:36','2021-11-05 20:46:21');
INSERT INTO invoices VALUES('613','1','4','1','8','1','2021-11-01','2021-11-03 16:46:42','','M/O NOVEMBER','M/O NOVEMBER','10000.00','10000.00','Paid','2021-11-01 19:58:37','2021-11-03 21:46:42');
INSERT INTO invoices VALUES('614','1','5','3','30','1','2021-11-01','2021-11-15 13:20:26','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-15 18:20:26');
INSERT INTO invoices VALUES('615','1','6','3','30','1','2021-11-01','2021-11-05 15:25:17','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-05 20:25:17');
INSERT INTO invoices VALUES('616','1','9','2','20','1','2021-11-01','2021-11-01 15:05:42','','M/O NOVEMBER','M/O NOVEMBER','24000.00','24000.00','Paid','2021-11-01 19:58:37','2021-11-01 20:05:42');
INSERT INTO invoices VALUES('617','1','12','1','16','1','2021-11-01','2022-01-03 14:26:16','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:37','2022-01-03 19:26:16');
INSERT INTO invoices VALUES('618','1','14','3','37','1','2021-11-01','2021-11-02 14:51:49','','M/O NOVEMBER','M/O NOVEMBER','32000.00','32000.00','Paid','2021-11-01 19:58:37','2021-11-02 19:51:49');
INSERT INTO invoices VALUES('619','1','15','1','41','1','2021-11-01','2021-11-01 16:30:37','','M/O NOVEMBER','M/O NOVEMBER','18000.00','18000.00','Paid','2021-11-01 19:58:37','2021-11-01 21:30:37');
INSERT INTO invoices VALUES('620','1','16','3','34','1','2021-11-01','2021-11-21 15:43:17','','M/O NOVEMBER','M/O NOVEMBER','20000.00','20000.00','Paid','2021-11-01 19:58:37','2021-11-21 20:43:17');
INSERT INTO invoices VALUES('621','1','17','3','33','1','2021-11-01','2021-11-05 17:06:34','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-05 22:06:34');
INSERT INTO invoices VALUES('622','1','18','3','33','1','2021-11-01','2021-11-07 09:20:26','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-07 14:20:26');
INSERT INTO invoices VALUES('623','1','19','3','33','1','2021-11-01','2021-11-08 12:31:52','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-08 17:31:52');
INSERT INTO invoices VALUES('624','1','20','3','33','1','2021-11-01','2021-11-07 14:25:53','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-07 19:25:53');
INSERT INTO invoices VALUES('625','1','21','3','30','1','2021-11-01','2021-11-07 09:37:48','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-07 14:37:48');
INSERT INTO invoices VALUES('626','1','22','3','35','1','2021-11-01','2021-11-09 15:17:19','','M/O NOVEMBER','M/O NOVEMBER','19000.00','19000.00','Paid','2021-11-01 19:58:37','2021-11-09 20:17:19');
INSERT INTO invoices VALUES('627','1','28','3','34','1','2021-11-01','2021-11-07 09:26:25','','M/O NOVEMBER','M/O NOVEMBER','20000.00','20000.00','Paid','2021-11-01 19:58:37','2021-11-07 14:26:25');
INSERT INTO invoices VALUES('628','1','29','3','34','1','2021-11-01','2021-11-09 12:28:56','','M/O NOVEMBER','M/O NOVEMBER','20000.00','20000.00','Paid','2021-11-01 19:58:37','2021-11-09 17:28:56');
INSERT INTO invoices VALUES('629','1','30','3','30','1','2021-11-01','2021-11-07 11:27:18','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-07 16:27:18');
INSERT INTO invoices VALUES('630','1','31','3','30','1','2021-11-01','2021-11-07 09:36:56','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-07 14:36:56');
INSERT INTO invoices VALUES('631','1','32','3','30','1','2021-11-01','2021-11-12 13:10:44','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-12 18:10:44');
INSERT INTO invoices VALUES('632','1','34','3','29','1','2021-11-01','2022-05-22 06:41:11','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2022-05-22 06:41:11');
INSERT INTO invoices VALUES('633','1','35','3','29','1','2021-11-01','2021-11-10 15:10:50','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2021-11-10 20:10:50');
INSERT INTO invoices VALUES('634','1','36','3','29','1','2021-11-01','2021-11-08 15:09:56','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2021-11-08 20:09:56');
INSERT INTO invoices VALUES('635','1','37','3','29','1','2021-11-01','2021-11-07 09:21:08','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2021-11-07 14:21:08');
INSERT INTO invoices VALUES('636','1','41','3','27','1','2021-11-01','2021-11-07 10:47:06','','M/O NOVEMBER','M/O NOVEMBER','16000.00','16000.00','Paid','2021-11-01 19:58:37','2021-11-07 15:47:06');
INSERT INTO invoices VALUES('637','1','42','3','27','1','2021-11-01','2021-11-09 14:33:00','','M/O NOVEMBER','M/O NOVEMBER','16000.00','16000.00','Paid','2021-11-01 19:58:37','2021-11-09 19:33:00');
INSERT INTO invoices VALUES('638','1','43','3','27','1','2021-11-01','2021-11-08 13:06:15','','M/O NOVEMBER','M/O NOVEMBER','16000.00','16000.00','Paid','2021-11-01 19:58:37','2021-11-08 18:06:15');
INSERT INTO invoices VALUES('639','1','44','3','26','1','2021-11-01','2021-11-03 13:42:28','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-03 18:42:28');
INSERT INTO invoices VALUES('640','1','45','3','26','1','2021-11-01','2021-11-08 12:45:57','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-08 17:45:57');
INSERT INTO invoices VALUES('641','1','46','3','26','1','2021-11-01','2021-11-03 16:20:18','','M/O NOVEMBER','M/O NOVEMBER','16000.00','16000.00','Paid','2021-11-01 19:58:37','2021-11-03 21:20:18');
INSERT INTO invoices VALUES('642','1','48','1','16','1','2021-11-01','2021-11-04 16:06:03','','M/O NOVEMBER','M/O NOVEMBER','16000.00','16000.00','Paid','2021-11-01 19:58:37','2021-11-04 21:06:03');
INSERT INTO invoices VALUES('643','1','49','2','14','1','2021-11-01','2022-03-05 16:17:38','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2022-03-05 21:17:38');
INSERT INTO invoices VALUES('644','1','50','3','25','1','2021-11-01','2021-11-09 13:33:32','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:37','2021-11-09 18:33:32');
INSERT INTO invoices VALUES('645','1','51','3','25','1','2021-11-01','2021-11-05 16:03:47','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:37','2021-11-05 21:03:47');
INSERT INTO invoices VALUES('646','1','52','3','25','1','2021-11-01','2021-11-05 16:03:01','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:37','2021-11-05 21:03:01');
INSERT INTO invoices VALUES('647','1','53','3','25','1','2021-11-01','2021-11-10 13:38:05','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:37','2021-11-10 18:38:05');
INSERT INTO invoices VALUES('648','1','54','2','23','1','2021-11-01','2021-11-02 12:27:53','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-02 17:27:53');
INSERT INTO invoices VALUES('649','1','55','1','17','1','2021-11-01','2021-11-07 09:16:51','','M/O NOVEMBER','M/O NOVEMBER SEC ADJUSTMENT PAY ONLY 10000 THOUSAND NOT PAID 18000','9000.00','9000.00','Paid','2021-11-01 19:58:37','2021-11-07 14:16:51');
INSERT INTO invoices VALUES('650','1','56','1','19','1','2021-11-01','2021-11-04 15:30:22','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-04 20:30:22');
INSERT INTO invoices VALUES('651','1','57','1','19','1','2021-11-01','2021-11-02 17:23:47','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-02 22:23:47');
INSERT INTO invoices VALUES('652','1','60','2','22','1','2021-11-01','2021-11-11 13:52:00','','M/O NOVEMBER','M/O NOVEMBER','12000.00','12000.00','Paid','2021-11-01 19:58:37','2021-11-11 18:52:00');
INSERT INTO invoices VALUES('653','1','61','2','22','1','2021-11-01','2021-12-03 15:05:05','','M/O NOVEMBER','M/O NOVEMBER','13000.00','13000.00','Paid','2021-11-01 19:58:37','2021-12-03 20:05:05');
INSERT INTO invoices VALUES('654','1','62','2','22','1','2021-11-01','2021-11-17 13:43:52','','M/O NOVEMBER','M/O NOVEMBER','13000.00','13000.00','Paid','2021-11-01 19:58:37','2021-11-17 18:43:52');
INSERT INTO invoices VALUES('655','1','64','1','18','1','2021-11-01','2021-11-08 16:21:42','','M/O NOVEMBER','M/O NOVEMBER','22000.00','22000.00','Paid','2021-11-01 19:58:37','2021-11-08 21:21:42');
INSERT INTO invoices VALUES('656','1','68','1','16','1','2021-11-01','2021-11-07 09:57:08','','M/O NOVEMBER','M/O NOVEMBER','16000.00','16000.00','Paid','2021-11-01 19:58:37','2021-11-07 14:57:08');
INSERT INTO invoices VALUES('657','1','69','1','16','1','2021-11-01','2021-11-04 14:49:34','','M/O NOVEMBER','M/O NOVEMBER','16000.00','16000.00','Paid','2021-11-01 19:58:37','2021-11-04 19:49:34');
INSERT INTO invoices VALUES('856','1','2','2','23','1','2022-01-01','2022-01-05 13:19:42','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:45','2022-01-05 18:19:42');
INSERT INTO invoices VALUES('659','1','71','1','15','1','2021-11-01','2021-11-02 14:48:03','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-02 19:48:03');
INSERT INTO invoices VALUES('660','1','72','1','15','1','2021-11-01','2021-11-10 12:38:56','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:37','2021-11-10 17:38:56');
INSERT INTO invoices VALUES('661','1','74','1','15','1','2021-11-01','2021-11-01 16:00:22','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-01 21:00:22');
INSERT INTO invoices VALUES('662','1','76','2','14','1','2021-11-01','2021-11-09 12:45:26','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:37','2021-11-09 17:45:26');
INSERT INTO invoices VALUES('663','1','77','2','14','1','2021-11-01','2021-11-07 11:02:06','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-07 16:02:06');
INSERT INTO invoices VALUES('664','1','78','2','10','1','2021-11-01','2021-11-15 13:18:06','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2021-11-15 18:18:06');
INSERT INTO invoices VALUES('665','1','79','2','10','1','2021-11-01','2021-11-01 16:40:52','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2021-11-01 21:40:52');
INSERT INTO invoices VALUES('666','1','80','1','4','1','2021-11-01','2021-11-07 17:14:30','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-07 22:14:30');
INSERT INTO invoices VALUES('667','1','81','1','12','1','2021-11-01','2021-11-07 16:49:50','','M/O NOVEMBER','M/O NOVEMBER','14500.00','14500.00','Paid','2021-11-01 19:58:37','2021-11-07 21:49:50');
INSERT INTO invoices VALUES('668','1','82','1','12','1','2021-11-01','2021-11-08 13:33:17','','M/O NOVEMBER','M/O NOVEMBER','14500.00','14500.00','Paid','2021-11-01 19:58:37','2021-11-08 18:33:17');
INSERT INTO invoices VALUES('669','1','83','1','12','1','2021-11-01','2021-11-27 13:57:53','','M/O NOVEMBER','M/O NOVEMBER','14500.00','14500.00','Paid','2021-11-01 19:58:37','2021-11-27 18:57:53');
INSERT INTO invoices VALUES('734','1','164','2','10','1','2021-11-01','2021-11-10 13:29:15','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-07 17:08:00','2021-11-10 18:29:15');
INSERT INTO invoices VALUES('671','1','93','1','8','1','2021-11-01','2021-11-02 16:21:19','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-02 21:21:19');
INSERT INTO invoices VALUES('672','1','96','1','7','1','2021-11-01','2021-11-05 15:45:40','','M/O NOVEMBER','M/O NOVEMBER','16500.00','16500.00','Paid','2021-11-01 19:58:37','2021-11-05 20:45:40');
INSERT INTO invoices VALUES('673','1','97','1','7','1','2021-11-01','2021-12-06 12:19:28','','M/O NOVEMBER','M/O NOVEMBER','18000.00','18000.00','Paid','2021-11-01 19:58:37','2021-12-06 17:19:28');
INSERT INTO invoices VALUES('674','1','98','1','6','1','2021-11-01','2021-11-01 16:33:25','','M/O NOVEMBER','M/O NOVEMBER','18000.00','18000.00','Paid','2021-11-01 19:58:37','2021-11-01 21:33:25');
INSERT INTO invoices VALUES('675','1','99','1','6','1','2021-11-01','2021-11-02 14:45:02','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-02 19:45:02');
INSERT INTO invoices VALUES('676','1','100','1','5','1','2021-11-01','2021-11-04 14:56:26','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-04 19:56:26');
INSERT INTO invoices VALUES('677','1','101','1','5','1','2021-11-01','2021-11-09 12:31:13','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-09 17:31:13');
INSERT INTO invoices VALUES('678','1','102','1','5','1','2021-11-01','2021-11-08 12:33:04','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-08 17:33:04');
INSERT INTO invoices VALUES('735','1','53','3','25','1','2021-11-10','2021-11-10 13:40:19','','M/O NOVEMBER','','2980.00','2980.00','Paid','2021-11-10 18:39:46','2021-11-10 18:40:19');
INSERT INTO invoices VALUES('680','1','104','1','3','1','2021-11-01','2021-11-15 15:01:38','','M/O NOVEMBER','M/O NOVEMBER','18000.00','18000.00','Paid','2021-11-01 19:58:37','2021-11-15 20:01:38');
INSERT INTO invoices VALUES('681','1','107','1','1','1','2021-11-01','2021-11-08 13:43:18','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:37','2021-11-08 18:43:18');
INSERT INTO invoices VALUES('682','1','108','1','1','1','2021-11-01','2021-11-12 15:00:12','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:37','2021-11-12 20:00:12');
INSERT INTO invoices VALUES('683','1','109','3','29','1','2021-11-01','2021-11-10 15:11:59','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2021-11-10 20:11:59');
INSERT INTO invoices VALUES('684','1','110','1','1','1','2021-11-01','2021-11-01 15:09:21','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:37','2021-11-01 20:09:21');
INSERT INTO invoices VALUES('685','1','111','1','1','1','2021-11-01','2021-11-07 09:21:50','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-07 14:21:50');
INSERT INTO invoices VALUES('686','1','112','1','1','1','2021-11-01','2021-11-04 14:53:26','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-04 19:53:26');
INSERT INTO invoices VALUES('687','1','113','1','12','1','2021-11-01','2021-11-08 13:25:15','','M/O NOVEMBER','M/O NOVEMBER','14500.00','14500.00','Paid','2021-11-01 19:58:37','2021-11-08 18:25:15');
INSERT INTO invoices VALUES('688','1','114','3','32','1','2021-11-01','2021-11-10 15:41:00','','M/O NOVEMBER','M/O NOVEMBER','19000.00','19000.00','Paid','2021-11-01 19:58:37','2021-11-10 20:41:00');
INSERT INTO invoices VALUES('689','1','115','1','9','1','2021-11-01','2021-11-03 15:04:16','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:37','2021-11-03 20:04:16');
INSERT INTO invoices VALUES('1341','1','186','1','4','1','2022-04-28','2022-04-28 17:10:48','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-28 17:10:22','2022-04-28 17:10:48');
INSERT INTO invoices VALUES('691','1','121','1','15','1','2021-11-01','2021-11-05 17:08:43','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-05 22:08:43');
INSERT INTO invoices VALUES('692','1','122','1','8','1','2021-11-01','2021-11-04 14:46:19','','M/O NOVEMBER','M/O NOVEMBER','14000.00','14000.00','Paid','2021-11-01 19:58:37','2021-11-04 19:46:19');
INSERT INTO invoices VALUES('693','1','123','3','36','1','2021-11-01','2021-11-08 12:42:09','','M/O NOVEMBER','M/O NOVEMBER','24000.00','24000.00','Paid','2021-11-01 19:58:37','2021-11-08 17:42:09');
INSERT INTO invoices VALUES('694','1','124','2','21','1','2021-11-01','2021-11-01 15:05:00','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:37','2021-11-01 20:05:00');
INSERT INTO invoices VALUES('695','1','125','3','32','1','2021-11-01','2021-11-15 13:19:20','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-15 18:19:20');
INSERT INTO invoices VALUES('696','1','126','1','17','1','2021-11-01','2021-11-07 15:10:37','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-07 20:10:37');
INSERT INTO invoices VALUES('697','1','127','1','17','1','2021-11-01','2021-11-07 15:11:23','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:37','2021-11-07 20:11:23');
INSERT INTO invoices VALUES('698','1','128','1','1','1','2021-11-01','2021-11-08 15:55:59','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:37','2021-11-08 20:55:59');
INSERT INTO invoices VALUES('699','1','129','1','18','1','2021-11-01','2021-11-08 12:30:05','','M/O NOVEMBER','M/O NOVEMBER','22000.00','22000.00','Paid','2021-11-01 19:58:38','2021-11-08 17:30:05');
INSERT INTO invoices VALUES('700','1','130','1','8','1','2021-11-01','2021-11-03 13:36:19','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:38','2021-11-03 18:36:19');
INSERT INTO invoices VALUES('701','1','131','2','38','1','2021-11-01','2021-11-12 13:13:13','','M/O NOVEMBER','M/O NOVEMBER','19500.00','19500.00','Paid','2021-11-01 19:58:38','2021-11-12 18:13:13');
INSERT INTO invoices VALUES('702','1','132','2','24','1','2021-11-01','2021-11-07 16:41:35','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-07 21:41:35');
INSERT INTO invoices VALUES('703','1','133','2','11','1','2021-11-01','2021-11-07 15:21:53','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-07 20:21:53');
INSERT INTO invoices VALUES('704','1','134','2','14','1','2021-11-01','2021-12-07 12:29:41','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:38','2021-12-07 17:29:41');
INSERT INTO invoices VALUES('705','1','135','2','11','1','2021-11-01','2021-11-03 15:32:56','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-03 20:32:56');
INSERT INTO invoices VALUES('706','1','136','1','8','1','2021-11-01','2021-11-01 15:30:33','','M/O NOVEMBER','M/O NOVEMBER','15000.00','15000.00','Paid','2021-11-01 19:58:38','2021-11-01 20:30:33');
INSERT INTO invoices VALUES('707','1','137','2','13','1','2021-11-01','2021-11-03 13:38:40','','M/O NOVEMBER','M/O NOVEMBER','21000.00','21000.00','Paid','2021-11-01 19:58:38','2021-11-03 18:38:40');
INSERT INTO invoices VALUES('708','1','138','1','17','1','2021-11-01','2021-11-11 13:38:00','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-11 18:38:00');
INSERT INTO invoices VALUES('709','1','139','3','28','1','2021-11-01','2021-11-01 15:19:54','','M/O NOVEMBER','M/O NOVEMBER','19000.00','19000.00','Paid','2021-11-01 19:58:38','2021-11-01 20:19:54');
INSERT INTO invoices VALUES('710','1','140','3','28','1','2021-11-01','2021-11-04 14:57:54','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:38','2021-11-04 19:57:54');
INSERT INTO invoices VALUES('711','1','141','3','26','1','2021-11-01','2021-11-01 15:03:43','','M/O NOVEMBER','M/O NOVEMBER','16500.00','16500.00','Paid','2021-11-01 19:58:38','2021-11-01 20:03:43');
INSERT INTO invoices VALUES('712','1','142','1','4','1','2021-11-01','2021-11-10 13:14:51','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:38','2021-11-10 18:14:51');
INSERT INTO invoices VALUES('713','1','143','2','39','1','2021-11-01','2021-11-10 12:37:41','','M/O NOVEMBER','M/O NOVEMBER','18000.00','18000.00','Paid','2021-11-01 19:58:38','2021-11-10 17:37:41');
INSERT INTO invoices VALUES('714','1','144','1','4','1','2021-11-01','2021-11-02 12:46:18','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:38','2021-11-02 17:46:18');
INSERT INTO invoices VALUES('715','1','145','1','4','1','2021-11-01','2021-11-10 13:14:15','','M/O NOVEMBER','M/O NOVEMBER','17500.00','17500.00','Paid','2021-11-01 19:58:38','2021-11-10 18:14:15');
INSERT INTO invoices VALUES('716','1','146','2','10','1','2021-11-01','2021-11-12 13:24:41','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-01 19:58:38','2021-11-12 18:24:41');
INSERT INTO invoices VALUES('717','1','148','2','13','1','2021-11-01','2021-11-04 15:37:54','','M/O NOVEMBER','M/O NOVEMBER','21000.00','21000.00','Paid','2021-11-01 19:58:38','2021-11-04 20:37:54');
INSERT INTO invoices VALUES('718','1','149','2','24','1','2021-11-01','2021-11-08 15:44:30','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-08 20:44:30');
INSERT INTO invoices VALUES('719','1','150','2','11','1','2021-11-01','2021-11-07 13:21:46','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-07 18:21:46');
INSERT INTO invoices VALUES('720','1','152','2','21','1','2021-11-01','2021-11-07 09:32:35','','M/O NOVEMBER','M/O NOVEMBER','18000.00','18000.00','Paid','2021-11-01 19:58:38','2021-11-07 14:32:35');
INSERT INTO invoices VALUES('721','1','153','1','9','1','2021-11-01','2021-11-17 13:43:10','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-17 18:43:10');
INSERT INTO invoices VALUES('722','1','154','1','9','1','2021-11-01','2021-11-09 14:54:24','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-09 19:54:24');
INSERT INTO invoices VALUES('723','1','155','3','43','1','2021-11-01','2021-11-08 12:40:05','','M/O NOVEMBER','M/O NOVEMBER','22000.00','22000.00','Paid','2021-11-01 19:58:38','2021-11-08 17:40:05');
INSERT INTO invoices VALUES('724','1','156','1','12','1','2021-11-01','2021-11-11 13:43:52','','M/O NOVEMBER','M/O NOVEMBER','14500.00','14500.00','Paid','2021-11-01 19:58:38','2021-11-11 18:43:52');
INSERT INTO invoices VALUES('725','1','158','3','43','1','2021-11-01','2021-11-08 12:50:33','','M/O NOVEMBER','M/O NOVEMBER','22000.00','22000.00','Paid','2021-11-01 19:58:38','2021-11-08 17:50:33');
INSERT INTO invoices VALUES('726','1','159','2','24','1','2021-11-01','2021-11-07 09:34:09','','M/O NOVEMBER','M/O NOVEMBER','17000.00','17000.00','Paid','2021-11-01 19:58:38','2021-11-07 14:34:09');
INSERT INTO invoices VALUES('729','1','161','3','44','1','2021-11-02','2021-11-12 14:51:01','','M/O NOVEMBER','M/O NOVEMBER','15500.00','15500.00','Paid','2021-11-02 20:16:16','2021-11-12 19:51:01');
INSERT INTO invoices VALUES('728','1','160','3','44','1','2021-11-02','2021-11-08 12:53:02','','M/O NOVEMBER','','31000.00','31000.00','Paid','2021-11-02 17:49:21','2021-11-08 17:53:02');
INSERT INTO invoices VALUES('730','1','162','3','44','1','2021-11-02','2021-11-07 09:31:50','','M/O NOVEMBER','M/O NOVEMBER','25500.00','25500.00','Paid','2021-11-02 20:16:57','2021-11-07 14:31:50');
INSERT INTO invoices VALUES('731','1','163','3','44','1','2021-11-02','2021-11-12 12:59:46','','M/O NOVEMBER','M/O NOVEMBER','25500.00','25500.00','Paid','2021-11-02 20:17:34','2021-11-12 17:59:46');
INSERT INTO invoices VALUES('732','1','161','3','44','1','2021-11-02','2021-11-02 15:18:54','','M/O NOVEMBER','M/O NOVEMBER','10000.00','10000.00','Paid','2021-11-02 20:18:01','2021-11-02 20:18:54');
INSERT INTO invoices VALUES('733','1','28','3','34','1','2021-10-31','2022-04-14 18:38:17','','M/O OCTOBER','','8820.00','8820.00','Paid','2021-11-07 14:25:03','2022-04-14 18:38:17');
INSERT INTO invoices VALUES('736','1','157','1','12','1','2021-11-01','2021-11-15 13:21:48','','M/O NOVEMBER','M/O NOVEMBER','14500.00','14500.00','Paid','2021-11-11 18:41:58','2021-11-15 18:21:48');
INSERT INTO invoices VALUES('737','1','165','3','44','1','2021-11-11','2021-11-11 14:02:10','','M/O NOVEMBER','20 DAYS RENT','10300.00','10300.00','Paid','2021-11-11 19:01:34','2021-11-11 19:02:10');
INSERT INTO invoices VALUES('738','1','2','2','23','1','2021-12-01','2021-12-06 11:43:19','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-06 16:43:19');
INSERT INTO invoices VALUES('739','1','4','1','8','1','2021-12-01','2021-12-15 12:38:41','','M/O DECEMBER','','10000.00','10000.00','Paid','2021-12-01 17:40:00','2021-12-15 17:38:41');
INSERT INTO invoices VALUES('740','1','5','3','30','1','2021-12-01','2021-12-13 12:31:24','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-13 17:31:24');
INSERT INTO invoices VALUES('741','1','6','3','30','1','2021-12-01','2021-12-03 16:15:12','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-03 21:15:12');
INSERT INTO invoices VALUES('742','1','9','2','20','1','2021-12-01','2021-12-01 15:48:44','','M/O DECEMBER','','24000.00','24000.00','Paid','2021-12-01 17:40:00','2021-12-01 20:48:44');
INSERT INTO invoices VALUES('743','1','12','1','16','1','2021-12-01','2022-01-03 14:25:31','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:00','2022-01-03 19:25:31');
INSERT INTO invoices VALUES('744','1','14','3','37','1','2021-12-01','2021-12-30 12:35:24','','M/O DECEMBER','','32000.00','32000.00','Paid','2021-12-01 17:40:00','2021-12-30 17:35:24');
INSERT INTO invoices VALUES('745','1','15','1','41','1','2021-12-01','2021-12-07 13:23:44','','M/O DECEMBER','','18000.00','18000.00','Paid','2021-12-01 17:40:00','2021-12-07 18:23:44');
INSERT INTO invoices VALUES('746','1','16','3','34','1','2021-12-01','2021-12-23 12:33:33','','M/O DECEMBER','','20000.00','15000.00','Unpaid','2021-12-01 17:40:00','2021-12-23 17:33:33');
INSERT INTO invoices VALUES('747','1','17','3','33','1','2021-12-01','2021-12-09 13:32:28','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-09 18:32:28');
INSERT INTO invoices VALUES('748','1','18','3','33','1','2021-12-01','2021-12-07 12:26:17','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:26:17');
INSERT INTO invoices VALUES('749','1','19','3','33','1','2021-12-01','2021-12-06 15:05:46','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-06 20:05:46');
INSERT INTO invoices VALUES('750','1','20','3','33','1','2021-12-01','2021-12-11 09:32:02','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-11 14:32:02');
INSERT INTO invoices VALUES('751','1','21','3','30','1','2021-12-01','2021-12-08 13:53:17','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-08 18:53:17');
INSERT INTO invoices VALUES('752','1','22','3','35','1','2021-12-01','2021-12-09 13:29:18','','M/O DECEMBER','','19000.00','19000.00','Paid','2021-12-01 17:40:00','2021-12-09 18:29:18');
INSERT INTO invoices VALUES('753','1','28','3','34','1','2021-12-01','2021-12-06 14:33:34','','M/O DECEMBER','','20000.00','20000.00','Paid','2021-12-01 17:40:00','2021-12-06 19:33:34');
INSERT INTO invoices VALUES('754','1','29','3','34','1','2021-12-01','2021-12-06 14:32:20','','M/O DECEMBER','','20000.00','20000.00','Paid','2021-12-01 17:40:00','2021-12-06 19:32:20');
INSERT INTO invoices VALUES('755','1','30','3','30','1','2021-12-01','2021-12-08 13:54:01','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-08 18:54:01');
INSERT INTO invoices VALUES('756','1','31','3','30','1','2021-12-01','2021-12-08 13:52:30','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-08 18:52:30');
INSERT INTO invoices VALUES('757','1','32','3','30','1','2021-12-01','2021-12-06 14:51:37','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-06 19:51:37');
INSERT INTO invoices VALUES('758','1','34','3','29','1','2021-12-01','2021-12-11 09:31:27','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:00','2021-12-11 14:31:27');
INSERT INTO invoices VALUES('759','1','35','3','29','1','2021-12-01','2022-01-06 14:36:48','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:00','2022-01-06 19:36:48');
INSERT INTO invoices VALUES('760','1','36','3','29','1','2021-12-01','2021-12-09 14:51:46','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:00','2021-12-09 19:51:46');
INSERT INTO invoices VALUES('761','1','37','3','29','1','2021-12-01','2021-12-06 13:55:21','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:00','2021-12-06 18:55:21');
INSERT INTO invoices VALUES('762','1','41','3','27','1','2021-12-01','2021-12-03 15:53:52','','M/O DECEMBER','','16000.00','16000.00','Paid','2021-12-01 17:40:00','2021-12-03 20:53:52');
INSERT INTO invoices VALUES('763','1','42','3','27','1','2021-12-01','2021-12-09 12:33:04','','M/O DECEMBER','','16000.00','16000.00','Paid','2021-12-01 17:40:00','2021-12-09 17:33:04');
INSERT INTO invoices VALUES('764','1','43','3','27','1','2021-12-01','2021-12-07 11:57:31','','M/O DECEMBER','','16000.00','16000.00','Paid','2021-12-01 17:40:00','2021-12-07 16:57:31');
INSERT INTO invoices VALUES('765','1','44','3','26','1','2021-12-01','2021-12-12 12:03:22','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-12 17:03:22');
INSERT INTO invoices VALUES('766','1','45','3','26','1','2021-12-01','2021-12-23 12:36:54','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-23 17:36:54');
INSERT INTO invoices VALUES('767','1','46','3','26','1','2021-12-01','2021-12-03 16:00:00','','M/O DECEMBER','','16000.00','16000.00','Paid','2021-12-01 17:40:00','2021-12-03 21:00:00');
INSERT INTO invoices VALUES('768','1','48','1','16','1','2021-12-01','2021-12-07 12:55:12','','M/O DECEMBER','','16000.00','16000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:55:12');
INSERT INTO invoices VALUES('769','1','49','2','14','1','2021-12-01','2021-12-07 12:04:23','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:04:23');
INSERT INTO invoices VALUES('770','1','50','3','25','1','2021-12-01','2021-12-12 12:02:16','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:00','2021-12-12 17:02:16');
INSERT INTO invoices VALUES('771','1','51','3','25','1','2021-12-01','2021-12-07 14:42:19','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:00','2021-12-07 19:42:19');
INSERT INTO invoices VALUES('772','1','52','3','25','1','2021-12-01','2021-12-09 13:16:34','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:00','2021-12-09 18:16:34');
INSERT INTO invoices VALUES('773','1','53','3','25','1','2021-12-01','2021-12-08 13:56:45','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:00','2021-12-08 18:56:45');
INSERT INTO invoices VALUES('774','1','54','2','23','1','2021-12-01','2021-12-02 16:10:07','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-02 21:10:07');
INSERT INTO invoices VALUES('775','1','55','1','17','1','2021-12-01','2021-12-07 12:24:55','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:24:55');
INSERT INTO invoices VALUES('776','1','56','1','19','1','2021-12-01','2021-12-06 11:46:21','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-06 16:46:21');
INSERT INTO invoices VALUES('777','1','57','1','19','1','2021-12-01','2021-12-03 12:28:41','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-03 17:28:41');
INSERT INTO invoices VALUES('778','1','60','2','22','1','2021-12-01','2021-12-02 13:08:33','','M/O DECEMBER','','13000.00','13000.00','Paid','2021-12-01 17:40:00','2021-12-02 18:08:33');
INSERT INTO invoices VALUES('779','1','61','2','22','1','2021-12-01','2021-12-03 15:04:33','','M/O DECEMBER','','13000.00','13000.00','Paid','2021-12-01 17:40:00','2021-12-03 20:04:33');
INSERT INTO invoices VALUES('780','1','62','2','22','1','2021-12-01','2021-12-14 14:15:33','','M/O DECEMBER','','13000.00','13000.00','Paid','2021-12-01 17:40:00','2021-12-14 19:15:33');
INSERT INTO invoices VALUES('781','1','64','1','18','1','2021-12-01','2021-12-12 13:19:40','','M/O DECEMBER','','22000.00','22000.00','Paid','2021-12-01 17:40:00','2021-12-12 18:19:40');
INSERT INTO invoices VALUES('782','1','68','1','16','1','2021-12-01','2021-12-11 09:37:48','','M/O DECEMBER','','16000.00','16000.00','Paid','2021-12-01 17:40:00','2021-12-11 14:37:48');
INSERT INTO invoices VALUES('783','1','69','1','16','1','2021-12-01','2021-12-01 14:50:00','','M/O DECEMBER','','16000.00','16000.00','Paid','2021-12-01 17:40:00','2021-12-01 19:50:00');
INSERT INTO invoices VALUES('784','1','71','1','15','1','2021-12-01','2021-12-13 15:04:24','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-13 20:04:24');
INSERT INTO invoices VALUES('785','1','72','1','15','1','2021-12-01','2021-12-08 13:50:44','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:00','2021-12-08 18:50:44');
INSERT INTO invoices VALUES('786','1','74','1','15','1','2021-12-01','2021-12-23 12:32:37','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-23 17:32:37');
INSERT INTO invoices VALUES('787','1','76','2','14','1','2021-12-01','2021-12-09 12:32:24','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:00','2021-12-09 17:32:24');
INSERT INTO invoices VALUES('788','1','77','2','14','1','2021-12-01','2021-12-07 12:27:35','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:27:35');
INSERT INTO invoices VALUES('789','1','78','2','10','1','2021-12-01','2021-12-09 15:16:56','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:00','2021-12-09 20:16:56');
INSERT INTO invoices VALUES('790','1','79','2','10','1','2021-12-01','2021-12-02 12:54:58','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:00','2021-12-02 17:54:58');
INSERT INTO invoices VALUES('791','1','80','1','4','1','2021-12-01','2021-12-07 13:23:11','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-07 18:23:11');
INSERT INTO invoices VALUES('858','1','5','3','30','1','2022-01-01','2022-01-10 12:35:24','','M/O JANUARY','','14300.00','14300.00','Paid','2022-01-03 18:39:45','2022-01-10 17:35:24');
INSERT INTO invoices VALUES('857','1','4','1','8','1','2022-01-01','2022-01-04 15:23:08','','M/O JANUARY','','10000.00','10000.00','Paid','2022-01-03 18:39:45','2022-01-04 20:23:08');
INSERT INTO invoices VALUES('794','1','83','1','12','1','2021-12-01','2021-12-13 12:47:49','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:00','2021-12-13 17:47:49');
INSERT INTO invoices VALUES('795','1','93','1','8','1','2021-12-01','2021-12-06 13:59:35','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-06 18:59:35');
INSERT INTO invoices VALUES('796','1','96','1','7','1','2021-12-01','2021-12-15 12:44:54','','M/O DECEMBER','','16500.00','16500.00','Paid','2021-12-01 17:40:00','2021-12-15 17:44:54');
INSERT INTO invoices VALUES('797','1','97','1','7','1','2021-12-01','2022-01-08 10:01:26','','M/O DECEMBER','','18000.00','18000.00','Paid','2021-12-01 17:40:00','2022-01-08 15:01:26');
INSERT INTO invoices VALUES('798','1','98','1','6','1','2021-12-01','2021-12-07 12:19:48','','M/O DECEMBER','','18000.00','18000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:19:48');
INSERT INTO invoices VALUES('799','1','99','1','6','1','2021-12-01','2021-12-08 13:55:47','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-08 18:55:47');
INSERT INTO invoices VALUES('800','1','100','1','5','1','2021-12-01','2021-12-02 12:54:09','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-02 17:54:09');
INSERT INTO invoices VALUES('801','1','101','1','5','1','2021-12-01','2021-12-07 12:03:08','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:03:08');
INSERT INTO invoices VALUES('802','1','102','1','5','1','2021-12-01','2021-12-15 12:43:28','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:00','2021-12-15 17:43:28');
INSERT INTO invoices VALUES('803','1','104','1','3','1','2021-12-01','2021-12-09 12:34:04','','M/O DECEMBER','','18000.00','18000.00','Paid','2021-12-01 17:40:00','2021-12-09 17:34:04');
INSERT INTO invoices VALUES('804','1','107','1','1','1','2021-12-01','2021-12-07 12:41:00','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:00','2021-12-07 17:41:00');
INSERT INTO invoices VALUES('805','1','108','1','1','1','2021-12-01','2021-12-13 14:39:07','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:00','2021-12-13 19:39:07');
INSERT INTO invoices VALUES('806','1','109','3','29','1','2021-12-01','2021-12-12 12:15:10','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:00','2021-12-12 17:15:10');
INSERT INTO invoices VALUES('807','1','110','1','1','1','2021-12-01','2021-12-01 15:06:47','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:00','2021-12-01 20:06:47');
INSERT INTO invoices VALUES('808','1','111','1','1','1','2021-12-01','2021-12-07 14:20:24','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-07 19:20:24');
INSERT INTO invoices VALUES('809','1','112','1','1','1','2021-12-01','2021-12-12 11:59:13','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:00','2021-12-12 16:59:13');
INSERT INTO invoices VALUES('810','1','113','1','12','1','2021-12-01','2021-12-09 14:35:47','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:01','2021-12-09 19:35:47');
INSERT INTO invoices VALUES('811','1','114','3','32','1','2021-12-01','2021-12-08 13:54:41','','M/O DECEMBER','','19000.00','19000.00','Paid','2021-12-01 17:40:01','2021-12-08 18:54:41');
INSERT INTO invoices VALUES('812','1','115','1','9','1','2021-12-01','2021-12-06 14:39:26','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:01','2021-12-06 19:39:26');
INSERT INTO invoices VALUES('813','1','120','3','44','1','2021-12-01','2021-12-15 12:40:30','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:01','2021-12-15 17:40:30');
INSERT INTO invoices VALUES('814','1','121','1','15','1','2021-12-01','2021-12-06 12:56:38','','M/O DECEMBER','sec discount 7000','10000.00','10000.00','Paid','2021-12-01 17:40:01','2021-12-06 17:56:38');
INSERT INTO invoices VALUES('815','1','122','1','8','1','2021-12-01','2021-12-08 13:49:58','','M/O DECEMBER','','14000.00','14000.00','Paid','2021-12-01 17:40:01','2021-12-08 18:49:58');
INSERT INTO invoices VALUES('816','1','123','3','36','1','2021-12-01','2021-12-13 12:33:21','','M/O DECEMBER','','21000.00','21000.00','Paid','2021-12-01 17:40:01','2021-12-13 17:33:21');
INSERT INTO invoices VALUES('817','1','124','2','21','1','2021-12-01','2021-12-07 14:59:21','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:01','2021-12-07 19:59:21');
INSERT INTO invoices VALUES('818','1','125','3','32','1','2021-12-01','2021-12-15 12:41:19','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-15 17:41:19');
INSERT INTO invoices VALUES('819','1','126','1','17','1','2021-12-01','2022-02-14 16:17:41','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2022-02-14 21:17:41');
INSERT INTO invoices VALUES('820','1','127','1','17','1','2021-12-01','2021-12-06 14:00:11','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-06 19:00:11');
INSERT INTO invoices VALUES('821','1','128','1','1','1','2021-12-01','2021-12-06 11:41:08','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:01','2021-12-06 16:41:08');
INSERT INTO invoices VALUES('822','1','129','1','18','1','2021-12-01','2021-12-17 14:52:29','','M/O DECEMBER','','22000.00','9000.00','Unpaid','2021-12-01 17:40:01','2021-12-17 19:52:29');
INSERT INTO invoices VALUES('823','1','130','1','8','1','2021-12-01','2021-12-09 12:52:34','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:01','2021-12-09 17:52:34');
INSERT INTO invoices VALUES('824','1','131','2','38','1','2021-12-01','2021-12-07 15:02:02','','M/O DECEMBER','','19500.00','19500.00','Paid','2021-12-01 17:40:01','2021-12-07 20:02:02');
INSERT INTO invoices VALUES('825','1','132','2','24','1','2021-12-01','2021-12-11 09:35:50','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-11 14:35:50');
INSERT INTO invoices VALUES('826','1','133','2','11','1','2021-12-01','2021-12-07 13:55:43','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-07 18:55:43');
INSERT INTO invoices VALUES('827','1','134','2','14','1','2021-12-01','2021-12-07 12:28:56','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:01','2021-12-07 17:28:56');
INSERT INTO invoices VALUES('828','1','135','2','11','1','2021-12-01','2021-12-06 11:50:14','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-06 16:50:14');
INSERT INTO invoices VALUES('829','1','136','1','8','1','2021-12-01','2022-01-12 14:51:49','','M/O DECEMBER','','15000.00','15000.00','Paid','2021-12-01 17:40:01','2022-01-12 19:51:49');
INSERT INTO invoices VALUES('830','1','137','2','13','1','2021-12-01','2021-12-06 11:45:40','','M/O DECEMBER','','21000.00','21000.00','Paid','2021-12-01 17:40:01','2021-12-06 16:45:40');
INSERT INTO invoices VALUES('831','1','138','1','17','1','2021-12-01','2021-12-13 12:30:42','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-13 17:30:42');
INSERT INTO invoices VALUES('832','1','139','3','28','1','2021-12-01','2021-12-06 12:05:02','','M/O DECEMBER','','19000.00','19000.00','Paid','2021-12-01 17:40:01','2021-12-06 17:05:02');
INSERT INTO invoices VALUES('833','1','140','3','28','1','2021-12-01','2021-12-03 12:18:07','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:01','2021-12-03 17:18:07');
INSERT INTO invoices VALUES('834','1','141','3','26','1','2021-12-01','2021-12-06 11:47:18','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-06 16:47:18');
INSERT INTO invoices VALUES('835','1','142','1','4','1','2021-12-01','2021-12-09 14:59:35','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:01','2021-12-09 19:59:35');
INSERT INTO invoices VALUES('836','1','143','2','39','1','2021-12-01','2021-12-09 13:10:38','','M/O DECEMBER','','18000.00','18000.00','Paid','2021-12-01 17:40:01','2021-12-09 18:10:38');
INSERT INTO invoices VALUES('837','1','144','1','4','1','2021-12-01','2021-12-06 12:16:07','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:01','2021-12-06 17:16:07');
INSERT INTO invoices VALUES('838','1','145','1','4','1','2021-12-01','2021-12-09 14:59:05','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:01','2021-12-09 19:59:05');
INSERT INTO invoices VALUES('839','1','146','2','10','1','2021-12-01','2021-12-07 12:37:00','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:01','2021-12-07 17:37:00');
INSERT INTO invoices VALUES('840','1','148','2','13','1','2021-12-01','2021-12-06 11:44:30','','M/O DECEMBER','','21000.00','21000.00','Paid','2021-12-01 17:40:01','2021-12-06 16:44:30');
INSERT INTO invoices VALUES('841','1','149','2','24','1','2021-12-01','2021-12-12 12:01:32','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-12 17:01:32');
INSERT INTO invoices VALUES('842','1','150','2','11','1','2021-12-01','2021-12-07 14:44:48','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-07 19:44:48');
INSERT INTO invoices VALUES('843','1','152','2','21','1','2021-12-01','2021-12-12 12:00:40','','M/O DECEMBER','','18000.00','18000.00','Paid','2021-12-01 17:40:01','2021-12-12 17:00:40');
INSERT INTO invoices VALUES('978','1','4','1','8','1','2022-02-01','2022-02-05 14:40:11','','M/O FEBRUARY','','10000.00','10000.00','Paid','2022-02-01 20:15:02','2022-02-05 19:40:11');
INSERT INTO invoices VALUES('845','1','154','1','9','1','2021-12-01','2021-12-12 13:09:02','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:01','2021-12-12 18:09:02');
INSERT INTO invoices VALUES('846','1','155','3','43','1','2021-12-01','2022-05-10 15:32:42','','M/O DECEMBER','','22000.00','22000.00','Paid','2021-12-01 17:40:01','2022-05-10 15:32:42');
INSERT INTO invoices VALUES('979','1','5','3','30','1','2022-02-01','2022-02-09 13:39:05','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:02','2022-02-09 18:39:05');
INSERT INTO invoices VALUES('848','1','157','1','12','1','2021-12-01','2021-12-13 12:47:15','','M/O DECEMBER','','17500.00','17500.00','Paid','2021-12-01 17:40:01','2021-12-13 17:47:15');
INSERT INTO invoices VALUES('849','1','158','3','43','1','2021-12-01','2021-12-17 14:40:17','','M/O DECEMBER','','22000.00','22000.00','Paid','2021-12-01 17:40:02','2021-12-17 19:40:17');
INSERT INTO invoices VALUES('850','1','159','2','24','1','2021-12-01','2021-12-06 16:01:27','','M/O DECEMBER','','17000.00','17000.00','Paid','2021-12-01 17:40:02','2021-12-06 21:01:27');
INSERT INTO invoices VALUES('851','1','160','3','44','1','2021-12-01','2021-12-09 15:08:07','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:02','2021-12-09 20:08:07');
INSERT INTO invoices VALUES('852','1','161','3','44','1','2021-12-01','2021-12-09 15:01:04','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:02','2021-12-09 20:01:04');
INSERT INTO invoices VALUES('853','1','162','3','44','1','2021-12-01','2021-12-09 15:01:38','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:02','2021-12-09 20:01:38');
INSERT INTO invoices VALUES('854','1','163','3','44','1','2021-12-01','2021-12-11 09:34:25','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:02','2021-12-11 14:34:25');
INSERT INTO invoices VALUES('855','1','164','2','10','1','2021-12-01','2021-12-06 11:51:10','','M/O DECEMBER','','15500.00','15500.00','Paid','2021-12-01 17:40:02','2021-12-06 16:51:10');
INSERT INTO invoices VALUES('859','1','6','3','30','1','2022-01-01','2022-01-10 12:34:37','','M/O JANUARY','','14300.00','14300.00','Paid','2022-01-03 18:39:45','2022-01-10 17:34:37');
INSERT INTO invoices VALUES('860','1','9','2','20','1','2022-01-01','2022-01-03 14:12:29','','M/O JANUARY','','24000.00','24000.00','Paid','2022-01-03 18:39:45','2022-01-03 19:12:29');
INSERT INTO invoices VALUES('861','1','12','1','16','1','2022-01-01','2022-01-10 16:19:02','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:45','2022-01-10 21:19:02');
INSERT INTO invoices VALUES('862','1','14','3','37','1','2022-01-01','2022-01-30 11:42:53','','M/O JANUARY','','32000.00','32000.00','Paid','2022-01-03 18:39:45','2022-01-30 16:42:53');
INSERT INTO invoices VALUES('863','1','15','1','41','1','2022-01-01','2022-01-10 13:02:30','','M/O JANUARY','','18000.00','18000.00','Paid','2022-01-03 18:39:45','2022-01-10 18:02:30');
INSERT INTO invoices VALUES('864','1','16','3','34','1','2022-01-01','2022-02-01 12:55:10','','M/O JANUARY','','20000.00','20000.00','Paid','2022-01-03 18:39:45','2022-02-01 17:55:10');
INSERT INTO invoices VALUES('865','1','17','3','33','1','2022-01-01','2022-01-08 09:52:09','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:45','2022-01-08 14:52:09');
INSERT INTO invoices VALUES('866','1','18','3','33','1','2022-01-01','2022-01-05 15:12:14','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:45','2022-01-05 20:12:14');
INSERT INTO invoices VALUES('867','1','19','3','33','1','2022-01-01','2022-01-10 12:58:20','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:45','2022-01-10 17:58:20');
INSERT INTO invoices VALUES('868','1','20','3','33','1','2022-01-01','2022-01-08 11:12:40','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:45','2022-01-08 16:12:40');
INSERT INTO invoices VALUES('869','1','21','3','30','1','2022-01-01','2022-01-09 14:18:25','','M/O JANUARY','','14300.00','14300.00','Paid','2022-01-03 18:39:46','2022-01-09 19:18:25');
INSERT INTO invoices VALUES('870','1','22','3','35','1','2022-01-01','2022-01-05 13:17:16','','M/O JANUARY','','19000.00','19000.00','Paid','2022-01-03 18:39:46','2022-01-05 18:17:16');
INSERT INTO invoices VALUES('871','1','28','3','34','1','2022-01-01','2022-02-07 12:25:35','','M/O JANUARY','','20000.00','20000.00','Paid','2022-01-03 18:39:46','2022-02-07 17:25:35');
INSERT INTO invoices VALUES('872','1','29','3','34','1','2022-01-01','2022-01-10 16:05:16','','M/O JANUARY','','20000.00','20000.00','Paid','2022-01-03 18:39:46','2022-01-10 21:05:16');
INSERT INTO invoices VALUES('873','1','30','3','30','1','2022-01-01','2022-01-13 13:26:13','','M/O JANUARY','','14500.00','14500.00','Paid','2022-01-03 18:39:46','2022-01-13 18:26:13');
INSERT INTO invoices VALUES('874','1','31','3','30','1','2022-01-01','2022-01-09 14:17:00','','M/O JANUARY','','14300.00','14300.00','Paid','2022-01-03 18:39:46','2022-01-09 19:17:00');
INSERT INTO invoices VALUES('875','1','32','3','30','1','2022-01-01','2022-01-11 12:25:32','','M/O JANUARY','','14300.00','14300.00','Paid','2022-01-03 18:39:46','2022-01-11 17:25:32');
INSERT INTO invoices VALUES('876','1','34','3','29','1','2022-01-01','2022-01-10 15:50:43','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-10 20:50:43');
INSERT INTO invoices VALUES('877','1','35','3','29','1','2022-01-01','2022-01-14 13:35:57','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-14 18:35:57');
INSERT INTO invoices VALUES('878','1','36','3','29','1','2022-01-01','2022-01-05 13:21:13','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-05 18:21:13');
INSERT INTO invoices VALUES('879','1','37','3','29','1','2022-01-01','2022-01-04 15:36:24','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-04 20:36:24');
INSERT INTO invoices VALUES('880','1','41','3','27','1','2022-01-01','2022-01-04 15:30:03','','M/O JANUARY','','16000.00','16000.00','Paid','2022-01-03 18:39:46','2022-01-04 20:30:03');
INSERT INTO invoices VALUES('881','1','42','3','27','1','2022-01-01','2022-01-06 13:05:15','','M/O JANUARY','','16000.00','16000.00','Paid','2022-01-03 18:39:46','2022-01-06 18:05:15');
INSERT INTO invoices VALUES('882','1','43','3','27','1','2022-01-01','2022-01-05 16:35:38','','M/O JANUARY','','16000.00','16000.00','Paid','2022-01-03 18:39:46','2022-01-05 21:35:38');
INSERT INTO invoices VALUES('883','1','44','3','26','1','2022-01-01','2022-01-11 12:49:25','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-11 17:49:25');
INSERT INTO invoices VALUES('884','1','45','3','26','1','2022-01-01','2022-01-11 12:22:15','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-11 17:22:15');
INSERT INTO invoices VALUES('885','1','46','3','26','1','2022-01-01','2022-01-12 14:53:24','','M/O JANUARY','','16000.00','16000.00','Paid','2022-01-03 18:39:46','2022-01-12 19:53:24');
INSERT INTO invoices VALUES('886','1','48','1','16','1','2022-01-01','2022-01-04 15:48:10','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-04 20:48:10');
INSERT INTO invoices VALUES('887','1','49','2','14','1','2022-01-01','2022-01-12 14:33:59','','M/O JANUARY','','14000.00','14000.00','Paid','2022-01-03 18:39:46','2022-01-12 19:33:59');
INSERT INTO invoices VALUES('888','1','50','3','25','1','2022-01-01','2022-01-11 12:20:53','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-11 17:20:53');
INSERT INTO invoices VALUES('889','1','51','3','25','1','2022-01-01','2022-01-06 14:53:11','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-06 19:53:11');
INSERT INTO invoices VALUES('890','1','52','3','25','1','2022-01-01','2022-01-06 14:54:36','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-06 19:54:36');
INSERT INTO invoices VALUES('891','1','53','3','25','1','2022-01-01','2022-01-11 13:22:50','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-11 18:22:50');
INSERT INTO invoices VALUES('892','1','54','2','23','1','2022-01-01','2022-01-04 15:11:13','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-04 20:11:13');
INSERT INTO invoices VALUES('893','1','55','1','17','1','2022-01-01','2022-01-08 09:55:47','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-08 14:55:47');
INSERT INTO invoices VALUES('894','1','56','1','19','1','2022-01-01','2022-01-10 16:27:22','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-10 21:27:22');
INSERT INTO invoices VALUES('895','1','57','1','19','1','2022-01-01','2022-01-04 15:26:11','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-04 20:26:11');
INSERT INTO invoices VALUES('896','1','60','2','22','1','2022-01-01','2022-01-08 10:23:41','','M/O JANUARY','','13000.00','13000.00','Paid','2022-01-03 18:39:46','2022-01-08 15:23:41');
INSERT INTO invoices VALUES('897','1','61','2','22','1','2022-01-01','2022-01-08 10:09:18','','M/O JANUARY','','13000.00','13000.00','Paid','2022-01-03 18:39:46','2022-01-08 15:09:18');
INSERT INTO invoices VALUES('898','1','62','2','22','1','2022-01-01','2022-01-08 10:08:19','','M/O JANUARY','','13000.00','13000.00','Paid','2022-01-03 18:39:46','2022-01-08 15:08:19');
INSERT INTO invoices VALUES('899','1','64','1','18','1','2022-01-01','2022-01-10 12:10:32','','M/O JANUARY','','22000.00','22000.00','Paid','2022-01-03 18:39:46','2022-01-10 17:10:32');
INSERT INTO invoices VALUES('900','1','68','1','16','1','2022-01-01','2022-01-11 13:00:17','','M/O JANUARY','','16000.00','16000.00','Paid','2022-01-03 18:39:46','2022-01-11 18:00:17');
INSERT INTO invoices VALUES('901','1','69','1','16','1','2022-01-01','2022-01-03 14:27:10','','M/O JANUARY','','16000.00','16000.00','Paid','2022-01-03 18:39:46','2022-01-03 19:27:10');
INSERT INTO invoices VALUES('976','1','71','1','6','1','2022-01-01','2022-01-12 14:32:11','','M/O JANUARY','','18000.00','18000.00','Paid','2022-01-12 19:30:18','2022-01-12 19:32:11');
INSERT INTO invoices VALUES('903','1','72','1','15','1','2022-01-01','2022-01-10 15:10:48','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-10 20:10:48');
INSERT INTO invoices VALUES('904','1','74','1','15','1','2022-01-01','2022-01-06 12:45:45','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-06 17:45:45');
INSERT INTO invoices VALUES('905','1','76','2','14','1','2022-01-01','2022-01-06 14:52:10','','M/O JANUARY','','15000.00','15000.00','Paid','2022-01-03 18:39:46','2022-01-06 19:52:10');
INSERT INTO invoices VALUES('906','1','77','2','14','1','2022-01-01','2022-01-04 13:28:35','','M/O JANUARY','','14000.00','14000.00','Paid','2022-01-03 18:39:46','2022-01-04 18:28:35');
INSERT INTO invoices VALUES('907','1','78','2','10','1','2022-01-01','2022-01-05 15:05:30','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-05 20:05:30');
INSERT INTO invoices VALUES('908','1','79','2','10','1','2022-01-01','2022-01-05 15:04:28','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-05 20:04:28');
INSERT INTO invoices VALUES('909','1','80','1','4','1','2022-01-01','2022-01-03 13:41:51','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-03 18:41:51');
INSERT INTO invoices VALUES('910','1','81','1','12','1','2022-01-01','2022-01-12 14:47:09','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-12 19:47:09');
INSERT INTO invoices VALUES('911','1','82','1','12','1','2022-01-01','2022-01-12 14:46:19','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-12 19:46:19');
INSERT INTO invoices VALUES('912','1','83','1','12','1','2022-01-01','2022-01-12 14:45:33','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-12 19:45:33');
INSERT INTO invoices VALUES('913','1','93','1','8','1','2022-01-01','2022-01-05 13:18:09','','M/O JANUARY','','14000.00','14000.00','Paid','2022-01-03 18:39:46','2022-01-05 18:18:09');
INSERT INTO invoices VALUES('914','1','96','1','7','1','2022-01-01','2022-01-20 14:14:17','','M/O JANUARY','','16500.00','16500.00','Paid','2022-01-03 18:39:46','2022-01-20 19:14:17');
INSERT INTO invoices VALUES('915','1','97','1','7','1','2022-01-01','2022-01-08 09:59:06','','M/O JANUARY','','18000.00','18000.00','Paid','2022-01-03 18:39:46','2022-01-08 14:59:06');
INSERT INTO invoices VALUES('983','1','14','3','37','1','2022-02-01','2022-02-28 17:28:27','','M/O FEBRUARY','','32000.00','32000.00','Paid','2022-02-01 20:15:02','2022-02-28 22:28:27');
INSERT INTO invoices VALUES('917','1','99','1','6','1','2022-01-01','2022-01-10 15:39:26','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-10 20:39:26');
INSERT INTO invoices VALUES('918','1','100','1','5','1','2022-01-01','2022-01-08 09:57:05','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-08 14:57:05');
INSERT INTO invoices VALUES('919','1','101','1','5','1','2022-01-01','2022-01-11 12:16:21','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-11 17:16:21');
INSERT INTO invoices VALUES('920','1','102','1','5','1','2022-01-01','2022-01-06 12:40:03','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-06 17:40:03');
INSERT INTO invoices VALUES('921','1','104','1','3','1','2022-01-01','2022-01-08 10:12:16','','M/O JANUARY','','18000.00','18000.00','Paid','2022-01-03 18:39:46','2022-01-08 15:12:16');
INSERT INTO invoices VALUES('922','1','107','1','1','1','2022-01-01','2022-01-08 16:57:10','','M/O JANUARY','','15000.00','15000.00','Paid','2022-01-03 18:39:46','2022-01-08 21:57:10');
INSERT INTO invoices VALUES('923','1','108','1','1','1','2022-01-01','2022-01-14 12:55:48','','M/O JANUARY','','15000.00','15000.00','Paid','2022-01-03 18:39:46','2022-01-14 17:55:48');
INSERT INTO invoices VALUES('924','1','109','3','29','1','2022-01-01','2022-01-06 14:40:57','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-06 19:40:57');
INSERT INTO invoices VALUES('984','1','15','1','41','1','2022-02-01','2022-02-07 12:27:41','','M/O FEBRUARY','','18000.00','18000.00','Paid','2022-02-01 20:15:03','2022-02-07 17:27:41');
INSERT INTO invoices VALUES('926','1','111','1','1','1','2022-01-01','2022-01-08 09:58:18','','M/O JANUARY','','14000.00','14000.00','Paid','2022-01-03 18:39:46','2022-01-08 14:58:18');
INSERT INTO invoices VALUES('927','1','112','1','1','1','2022-01-01','2022-01-14 13:55:28','','M/O JANUARY','','14000.00','14000.00','Paid','2022-01-03 18:39:46','2022-01-14 18:55:28');
INSERT INTO invoices VALUES('928','1','113','1','12','1','2022-01-01','2022-01-12 14:44:42','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-12 19:44:42');
INSERT INTO invoices VALUES('929','1','114','3','32','1','2022-01-01','2022-01-10 12:38:15','','M/O JANUARY','','19000.00','19000.00','Paid','2022-01-03 18:39:46','2022-01-10 17:38:15');
INSERT INTO invoices VALUES('930','1','115','1','9','1','2022-01-01','2022-01-08 11:28:33','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-08 16:28:33');
INSERT INTO invoices VALUES('1100','1','6','3','30','1','2022-03-01','2022-03-08 11:14:49','','M/O MARCH','','16000.00','16000.00','Paid','2022-03-02 17:32:35','2022-03-08 16:14:49');
INSERT INTO invoices VALUES('932','1','121','1','15','1','2022-01-01','2022-01-06 12:41:01','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-06 17:41:01');
INSERT INTO invoices VALUES('980','1','6','3','30','1','2022-02-01','2022-02-09 13:37:26','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:02','2022-02-09 18:37:26');
INSERT INTO invoices VALUES('934','1','123','3','36','1','2022-01-01','2022-01-14 13:25:55','','M/O JANUARY','','24000.00','24000.00','Paid','2022-01-03 18:39:46','2022-01-14 18:25:55');
INSERT INTO invoices VALUES('935','1','124','2','21','1','2022-01-01','2022-01-05 14:30:27','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-05 19:30:27');
INSERT INTO invoices VALUES('936','1','125','3','32','1','2022-01-01','2022-02-01 12:54:13','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-02-01 17:54:13');
INSERT INTO invoices VALUES('937','1','126','1','17','1','2022-01-01','2022-01-11 15:43:44','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-11 20:43:44');
INSERT INTO invoices VALUES('938','1','127','1','17','1','2022-01-01','2022-01-10 15:37:48','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-10 20:37:48');
INSERT INTO invoices VALUES('939','1','128','1','1','1','2022-01-01','2022-01-04 12:48:17','','M/O JANUARY','','15000.00','15000.00','Paid','2022-01-03 18:39:46','2022-01-04 17:48:17');
INSERT INTO invoices VALUES('940','1','129','1','18','1','2022-01-01','2022-01-30 11:43:29','','M/O JANUARY','','22000.00','22000.00','Paid','2022-01-03 18:39:46','2022-01-30 16:43:29');
INSERT INTO invoices VALUES('941','1','130','1','8','1','2022-01-01','2022-01-10 16:51:27','','M/O JANUARY','','15000.00','15000.00','Paid','2022-01-03 18:39:46','2022-01-10 21:51:27');
INSERT INTO invoices VALUES('942','1','131','2','38','1','2022-01-01','2022-01-08 10:04:30','','M/O JANUARY','','19500.00','19500.00','Paid','2022-01-03 18:39:46','2022-01-08 15:04:30');
INSERT INTO invoices VALUES('943','1','132','2','24','1','2022-01-01','2022-01-10 16:32:58','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-10 21:32:58');
INSERT INTO invoices VALUES('944','1','133','2','11','1','2022-01-01','2022-01-05 14:42:51','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-05 19:42:51');
INSERT INTO invoices VALUES('945','1','134','2','14','1','2022-01-01','2022-01-08 10:14:10','','M/O JANUARY','','15000.00','15000.00','Paid','2022-01-03 18:39:46','2022-01-08 15:14:10');
INSERT INTO invoices VALUES('946','1','135','2','11','1','2022-01-01','2022-01-05 14:51:53','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-05 19:51:53');
INSERT INTO invoices VALUES('947','1','136','1','8','1','2022-01-01','2022-01-04 12:12:07','','M/O JANUARY','','15000.00','15000.00','Paid','2022-01-03 18:39:46','2022-01-04 17:12:07');
INSERT INTO invoices VALUES('948','1','137','2','13','1','2022-01-01','2022-01-11 15:42:04','','M/O JANUARY','','21000.00','21000.00','Paid','2022-01-03 18:39:46','2022-01-11 20:42:04');
INSERT INTO invoices VALUES('949','1','138','1','17','1','2022-01-01','2022-01-11 12:19:53','','M/O JANUARY','','17000.00','14500.00','Unpaid','2022-01-03 18:39:46','2022-01-11 17:19:53');
INSERT INTO invoices VALUES('950','1','139','3','28','1','2022-01-01','2022-01-12 14:54:49','','M/O JANUARY','','19000.00','19000.00','Paid','2022-01-03 18:39:46','2022-01-12 19:54:49');
INSERT INTO invoices VALUES('951','1','140','3','28','1','2022-01-01','2022-01-05 15:02:15','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-05 20:02:15');
INSERT INTO invoices VALUES('952','1','141','3','26','1','2022-01-01','2022-01-03 13:42:53','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-03 18:42:53');
INSERT INTO invoices VALUES('953','1','142','1','4','1','2022-01-01','2022-01-08 10:20:13','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-08 15:20:13');
INSERT INTO invoices VALUES('954','1','143','2','39','1','2022-01-01','2022-01-08 10:03:38','','M/O JANUARY','','18000.00','18000.00','Paid','2022-01-03 18:39:46','2022-01-08 15:03:38');
INSERT INTO invoices VALUES('955','1','144','1','4','1','2022-01-01','2022-01-03 13:40:59','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-03 18:40:59');
INSERT INTO invoices VALUES('956','1','145','1','4','1','2022-01-01','2022-01-04 12:41:34','','M/O JANUARY','','17500.00','17500.00','Paid','2022-01-03 18:39:46','2022-01-04 17:41:34');
INSERT INTO invoices VALUES('957','1','146','2','10','1','2022-01-01','2022-01-08 09:32:21','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:46','2022-01-08 14:32:21');
INSERT INTO invoices VALUES('958','1','148','2','13','1','2022-01-01','2022-01-11 15:41:21','','M/O JANUARY','','21000.00','21000.00','Paid','2022-01-03 18:39:46','2022-01-11 20:41:21');
INSERT INTO invoices VALUES('959','1','149','2','24','1','2022-01-01','2022-01-09 14:09:57','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-09 19:09:57');
INSERT INTO invoices VALUES('960','1','150','2','11','1','2022-01-01','2022-01-10 12:42:02','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:46','2022-01-10 17:42:02');
INSERT INTO invoices VALUES('961','1','152','2','21','1','2022-01-01','2022-01-05 15:11:03','','M/O JANUARY','','19000.00','19000.00','Paid','2022-01-03 18:39:46','2022-01-05 20:11:03');
INSERT INTO invoices VALUES('981','1','9','2','20','1','2022-02-01','2022-02-01 15:35:55','','M/O FEBRUARY','','24000.00','24000.00','Paid','2022-02-01 20:15:02','2022-02-01 20:35:55');
INSERT INTO invoices VALUES('963','1','154','1','9','1','2022-01-01','2022-01-10 12:09:33','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:47','2022-01-10 17:09:33');
INSERT INTO invoices VALUES('964','1','155','3','43','1','2022-01-01','2022-01-13 13:14:58','','M/O JANUARY','','22000.00','22000.00','Paid','2022-01-03 18:39:47','2022-01-13 18:14:58');
INSERT INTO invoices VALUES('982','1','12','1','16','1','2022-02-01','2022-02-08 15:33:48','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:02','2022-02-08 20:33:48');
INSERT INTO invoices VALUES('966','1','157','1','12','1','2022-01-01','2022-01-12 15:50:29','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:47','2022-01-12 20:50:29');
INSERT INTO invoices VALUES('967','1','158','3','43','1','2022-01-01','2022-01-10 12:11:35','','M/O JANUARY','','22000.00','22000.00','Paid','2022-01-03 18:39:47','2022-01-10 17:11:35');
INSERT INTO invoices VALUES('968','1','159','2','24','1','2022-01-01','2022-01-08 10:16:54','','M/O JANUARY','','17000.00','17000.00','Paid','2022-01-03 18:39:47','2022-01-08 15:16:54');
INSERT INTO invoices VALUES('975','1','160','1','1','1','2022-01-01','2022-01-08 14:15:07','','M/O JANUARY','','16000.00','16000.00','Paid','2022-01-08 19:14:10','2022-01-08 19:15:07');
INSERT INTO invoices VALUES('970','1','161','3','44','1','2022-01-01','2022-01-18 13:04:22','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:47','2022-01-18 18:04:22');
INSERT INTO invoices VALUES('971','1','162','3','44','1','2022-01-01','2022-01-20 11:46:13','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:47','2022-01-20 16:46:13');
INSERT INTO invoices VALUES('972','1','163','3','44','1','2022-01-01','2022-01-18 13:01:32','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:47','2022-01-18 18:01:32');
INSERT INTO invoices VALUES('973','1','164','2','10','1','2022-01-01','2022-01-04 15:38:40','','M/O JANUARY','','15500.00','15500.00','Paid','2022-01-03 18:39:47','2022-01-04 20:38:40');
INSERT INTO invoices VALUES('974','1','57','1','19','1','2022-01-04','2022-01-04 15:44:40','','M/O JANUARY','','500.00','500.00','Paid','2022-01-04 20:43:35','2022-01-04 20:44:40');
INSERT INTO invoices VALUES('985','1','16','3','34','1','2022-02-01','2022-03-03 13:40:48','','M/O FEBRUARY','','20000.00','20000.00','Paid','2022-02-01 20:15:03','2022-03-03 18:40:48');
INSERT INTO invoices VALUES('986','1','17','1','15','1','2022-02-01','2022-02-03 13:35:14','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-03 18:35:14');
INSERT INTO invoices VALUES('987','1','18','3','33','1','2022-02-01','2022-02-08 13:47:12','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-08 18:47:12');
INSERT INTO invoices VALUES('988','1','19','1','17','1','2022-02-01','2022-02-08 13:44:13','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-08 18:44:13');
INSERT INTO invoices VALUES('989','1','20','3','33','1','2022-02-01','2022-02-07 15:34:11','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-07 20:34:11');
INSERT INTO invoices VALUES('1092','1','166','2','10','1','2022-02-11','2022-02-11 15:35:57','','M/O FEBRUARY','','25000.00','25000.00','Paid','2022-02-11 20:34:54','2022-02-11 20:35:57');
INSERT INTO invoices VALUES('991','1','22','3','35','1','2022-02-01','2022-05-08 15:10:17','','M/O FEBRUARY','','19000.00','19000.00','Paid','2022-02-01 20:15:03','2022-05-08 15:10:17');
INSERT INTO invoices VALUES('992','1','28','3','34','1','2022-02-01','2022-02-07 12:19:55','','M/O FEBRUARY','','20000.00','20000.00','Paid','2022-02-01 20:15:03','2022-02-07 17:19:55');
INSERT INTO invoices VALUES('993','1','29','3','34','1','2022-02-01','2022-02-07 12:19:07','','M/O FEBRUARY','','20000.00','20000.00','Paid','2022-02-01 20:15:03','2022-02-07 17:19:07');
INSERT INTO invoices VALUES('994','1','30','3','30','1','2022-02-01','2022-02-08 16:14:01','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:03','2022-02-08 21:14:01');
INSERT INTO invoices VALUES('1091','1','116','1','8','1','2022-02-11','2022-02-11 14:05:29','','M/O FEB','17 DAYS RENT','9000.00','9000.00','Paid','2022-02-11 19:04:39','2022-02-11 19:05:29');
INSERT INTO invoices VALUES('996','1','32','3','30','1','2022-02-01','2022-02-04 14:43:15','','M/O FEBRUARY','','14300.00','14300.00','Paid','2022-02-01 20:15:03','2022-02-04 19:43:15');
INSERT INTO invoices VALUES('997','1','34','3','29','1','2022-02-01','2022-05-22 06:41:32','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-05-22 06:41:32');
INSERT INTO invoices VALUES('998','1','35','3','29','1','2022-02-01','2022-02-11 13:27:01','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-11 18:27:01');
INSERT INTO invoices VALUES('999','1','36','3','29','1','2022-02-01','2022-02-03 15:22:44','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-03 20:22:44');
INSERT INTO invoices VALUES('1000','1','37','3','29','1','2022-02-01','2022-02-03 13:27:49','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-03 18:27:49');
INSERT INTO invoices VALUES('1001','1','41','3','27','1','2022-02-01','2022-02-05 14:18:34','','M/O FEBRUARY','','16000.00','16000.00','Paid','2022-02-01 20:15:03','2022-02-05 19:18:34');
INSERT INTO invoices VALUES('1002','1','42','3','27','1','2022-02-01','2022-02-01 15:35:05','','M/O FEBRUARY','','16000.00','16000.00','Paid','2022-02-01 20:15:03','2022-02-01 20:35:05');
INSERT INTO invoices VALUES('1003','1','43','3','27','1','2022-02-01','2022-02-05 15:22:02','','M/O FEBRUARY','','16000.00','16000.00','Paid','2022-02-01 20:15:03','2022-02-05 20:22:02');
INSERT INTO invoices VALUES('1004','1','44','3','26','1','2022-02-01','2022-02-09 13:43:28','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-09 18:43:28');
INSERT INTO invoices VALUES('1005','1','45','3','26','1','2022-02-01','2022-02-04 12:39:37','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-04 17:39:37');
INSERT INTO invoices VALUES('1006','1','46','3','26','1','2022-02-01','2022-02-03 13:40:14','','M/O FEBRUARY','','16000.00','16000.00','Paid','2022-02-01 20:15:03','2022-02-03 18:40:14');
INSERT INTO invoices VALUES('1007','1','48','1','16','1','2022-02-01','2022-02-03 15:26:34','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-03 20:26:34');
INSERT INTO invoices VALUES('1008','1','49','2','14','1','2022-02-01','2022-02-09 16:47:21','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:03','2022-02-09 21:47:21');
INSERT INTO invoices VALUES('1009','1','50','3','25','1','2022-02-01','2022-02-11 13:29:25','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-11 18:29:25');
INSERT INTO invoices VALUES('1010','1','51','3','25','1','2022-02-01','2022-02-06 13:02:57','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-06 18:02:57');
INSERT INTO invoices VALUES('1011','1','52','3','25','1','2022-02-01','2022-02-06 15:42:15','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-06 20:42:15');
INSERT INTO invoices VALUES('1012','1','53','3','25','1','2022-02-01','2022-02-09 15:05:15','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-09 20:05:15');
INSERT INTO invoices VALUES('1013','1','54','2','23','1','2022-02-01','2022-02-04 13:21:03','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-04 18:21:03');
INSERT INTO invoices VALUES('1014','1','55','1','17','1','2022-02-01','2022-02-07 13:25:11','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-07 18:25:11');
INSERT INTO invoices VALUES('1015','1','56','1','19','1','2022-02-01','2022-02-08 15:11:24','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-08 20:11:24');
INSERT INTO invoices VALUES('1016','1','57','1','19','1','2022-02-01','2022-02-02 16:05:59','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-02 21:05:59');
INSERT INTO invoices VALUES('1017','1','60','2','22','1','2022-02-01','2022-02-12 15:49:18','','M/O FEBRUARY','','13000.00','13000.00','Paid','2022-02-01 20:15:03','2022-02-12 20:49:18');
INSERT INTO invoices VALUES('1018','1','61','2','22','1','2022-02-01','2022-02-09 16:25:02','','M/O FEBRUARY','','13000.00','13000.00','Paid','2022-02-01 20:15:03','2022-02-09 21:25:02');
INSERT INTO invoices VALUES('1019','1','62','2','22','1','2022-02-01','2022-02-10 13:34:29','','M/O FEBRUARY','','13000.00','13000.00','Paid','2022-02-01 20:15:03','2022-02-10 18:34:29');
INSERT INTO invoices VALUES('1020','1','64','1','18','1','2022-02-01','2022-02-09 16:20:58','','M/O FEBRUARY','','22000.00','22000.00','Paid','2022-02-01 20:15:03','2022-02-09 21:20:58');
INSERT INTO invoices VALUES('1021','1','68','1','16','1','2022-02-01','2022-05-08 17:04:57','','M/O FEBRUARY','','16000.00','16000.00','Paid','2022-02-01 20:15:03','2022-05-08 17:04:57');
INSERT INTO invoices VALUES('1022','1','69','1','16','1','2022-02-01','2022-02-02 17:39:43','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-02 22:39:43');
INSERT INTO invoices VALUES('1023','1','71','1','6','1','2022-02-01','2022-02-09 16:40:24','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-09 21:40:24');
INSERT INTO invoices VALUES('1024','1','72','1','15','1','2022-02-01','2022-02-08 15:05:56','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-08 20:05:56');
INSERT INTO invoices VALUES('1025','1','74','1','15','1','2022-02-01','2022-02-03 15:31:46','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-03 20:31:46');
INSERT INTO invoices VALUES('1026','1','76','2','14','1','2022-02-01','2022-02-03 15:04:24','','M/O FEBRUARY','','15000.00','15000.00','Paid','2022-02-01 20:15:03','2022-02-03 20:04:24');
INSERT INTO invoices VALUES('1027','1','77','2','14','1','2022-02-01','2022-02-06 13:02:02','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:03','2022-02-06 18:02:02');
INSERT INTO invoices VALUES('1028','1','78','2','10','1','2022-02-01','2022-02-09 12:39:01','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-09 17:39:01');
INSERT INTO invoices VALUES('1029','1','79','2','10','1','2022-02-01','2022-02-03 14:00:14','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-03 19:00:14');
INSERT INTO invoices VALUES('1030','1','80','1','4','1','2022-02-01','2022-02-17 13:46:03','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-17 18:46:03');
INSERT INTO invoices VALUES('1031','1','81','1','12','1','2022-02-01','2022-02-10 13:56:45','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-10 18:56:45');
INSERT INTO invoices VALUES('1032','1','82','1','12','1','2022-02-01','2022-05-15 14:37:14','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-05-15 14:37:14');
INSERT INTO invoices VALUES('1033','1','83','1','12','1','2022-02-01','2022-02-09 13:22:15','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-09 18:22:15');
INSERT INTO invoices VALUES('1034','1','93','1','8','1','2022-02-01','2022-02-05 13:26:10','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:03','2022-02-05 18:26:10');
INSERT INTO invoices VALUES('1035','1','96','1','7','1','2022-02-01','2022-02-15 15:57:48','','M/O FEBRUARY','','16500.00','16500.00','Paid','2022-02-01 20:15:03','2022-02-15 20:57:48');
INSERT INTO invoices VALUES('1036','1','97','1','7','1','2022-02-01','2022-02-08 13:48:02','','M/O FEBRUARY','','18000.00','18000.00','Paid','2022-02-01 20:15:03','2022-02-08 18:48:02');
INSERT INTO invoices VALUES('1037','1','99','1','6','1','2022-02-01','2022-02-09 16:45:31','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:03','2022-02-09 21:45:31');
INSERT INTO invoices VALUES('1038','1','100','1','5','1','2022-02-01','2022-02-07 16:05:31','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-07 21:05:31');
INSERT INTO invoices VALUES('1039','1','101','1','5','1','2022-02-01','2022-06-10 12:24:30','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-06-10 12:24:30');
INSERT INTO invoices VALUES('1040','1','102','1','5','1','2022-02-01','2022-02-15 13:32:42','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:03','2022-02-15 18:32:42');
INSERT INTO invoices VALUES('1041','1','104','1','3','1','2022-02-01','2022-03-02 15:01:33','','M/O FEBRUARY','','18000.00','18000.00','Paid','2022-02-01 20:15:03','2022-03-02 20:01:33');
INSERT INTO invoices VALUES('1042','1','107','1','1','1','2022-02-01','2022-02-05 13:27:58','','M/O FEBRUARY','','15000.00','15000.00','Paid','2022-02-01 20:15:03','2022-02-05 18:27:58');
INSERT INTO invoices VALUES('1043','1','108','1','1','1','2022-02-01','2022-02-17 12:08:16','','M/O FEBRUARY','','15000.00','15000.00','Paid','2022-02-01 20:15:03','2022-02-17 17:08:16');
INSERT INTO invoices VALUES('1044','1','109','3','29','1','2022-02-01','2022-02-11 13:26:04','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-11 18:26:04');
INSERT INTO invoices VALUES('1045','1','111','1','1','1','2022-02-01','2022-02-03 15:27:36','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:03','2022-02-03 20:27:36');
INSERT INTO invoices VALUES('1046','1','112','1','1','1','2022-02-01','2022-02-16 14:33:05','','M/O FEBRUARY','','14000.00','14000.00','Paid','2022-02-01 20:15:03','2022-02-16 19:33:05');
INSERT INTO invoices VALUES('1047','1','113','1','12','1','2022-02-01','2022-02-08 16:44:04','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-02-08 21:44:04');
INSERT INTO invoices VALUES('1048','1','114','3','32','1','2022-02-01','2022-02-07 13:59:34','','M/O FEBRUARY','','19000.00','19000.00','Paid','2022-02-01 20:15:03','2022-02-07 18:59:34');
INSERT INTO invoices VALUES('1049','1','115','1','9','1','2022-02-01','2022-03-15 14:53:40','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:03','2022-03-15 14:53:40');
INSERT INTO invoices VALUES('1104','1','15','1','41','1','2022-03-01','2022-03-07 15:31:36','','M/O MARCH','','18000.00','18000.00','Paid','2022-03-02 17:32:35','2022-03-07 20:31:36');
INSERT INTO invoices VALUES('1051','1','121','1','15','1','2022-02-01','2022-02-03 13:10:47','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-03 18:10:47');
INSERT INTO invoices VALUES('1052','1','123','3','36','1','2022-02-01','2022-02-08 15:05:02','','M/O FEBRUARY','','24000.00','24000.00','Paid','2022-02-01 20:15:04','2022-02-08 20:05:02');
INSERT INTO invoices VALUES('1053','1','124','2','21','1','2022-02-01','2022-04-28 17:03:01','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:04','2022-04-28 17:03:01');
INSERT INTO invoices VALUES('1103','1','14','3','37','1','2022-03-01','2022-03-27 12:33:10','','M/O MARCH','','32000.00','32000.00','Paid','2022-03-02 17:32:35','2022-03-27 12:33:10');
INSERT INTO invoices VALUES('1055','1','126','1','17','1','2022-02-01','2022-02-09 16:38:19','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-09 21:38:19');
INSERT INTO invoices VALUES('1056','1','127','1','17','1','2022-02-01','2022-02-08 15:29:59','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-08 20:29:59');
INSERT INTO invoices VALUES('1057','1','128','1','1','1','2022-02-01','2022-02-11 16:11:59','','M/O FEBRUARY','','15000.00','15000.00','Paid','2022-02-01 20:15:04','2022-02-11 21:11:59');
INSERT INTO invoices VALUES('1058','1','129','1','18','1','2022-02-01','2022-02-08 16:25:06','','M/O FEBRUARY','','22000.00','22000.00','Paid','2022-02-01 20:15:04','2022-02-08 21:25:06');
INSERT INTO invoices VALUES('1059','1','130','1','8','1','2022-02-01','2022-02-08 14:21:33','','M/O FEBRUARY','','15000.00','15000.00','Paid','2022-02-01 20:15:04','2022-02-08 19:21:33');
INSERT INTO invoices VALUES('1060','1','131','2','38','1','2022-02-01','2022-02-07 12:28:45','','M/O FEBRUARY','','19500.00','19500.00','Paid','2022-02-01 20:15:04','2022-02-07 17:28:45');
INSERT INTO invoices VALUES('1061','1','132','2','24','1','2022-02-01','2022-02-08 14:07:16','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-08 19:07:16');
INSERT INTO invoices VALUES('1062','1','133','2','11','1','2022-02-01','2022-02-03 13:28:54','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-03 18:28:54');
INSERT INTO invoices VALUES('1090','1','167','2','14','1','2022-02-01','2022-02-07 15:23:18','','M/O FEBRUARY','','15000.00','15000.00','Paid','2022-02-07 20:20:53','2022-02-07 20:23:18');
INSERT INTO invoices VALUES('1064','1','135','2','11','1','2022-02-01','2022-02-03 15:32:32','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-03 20:32:32');
INSERT INTO invoices VALUES('1065','1','136','1','8','1','2022-02-01','2022-02-09 13:35:47','','M/O FEBRUARY','','15000.00','15000.00','Paid','2022-02-01 20:15:04','2022-02-09 18:35:47');
INSERT INTO invoices VALUES('1066','1','137','2','13','1','2022-02-01','2022-02-06 15:08:40','','M/O FEBRUARY','','21000.00','21000.00','Paid','2022-02-01 20:15:04','2022-02-06 20:08:40');
INSERT INTO invoices VALUES('1067','1','138','3','33','1','2022-02-01','2022-02-14 17:11:12','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-14 22:11:12');
INSERT INTO invoices VALUES('1068','1','139','3','28','1','2022-02-01','2022-02-05 13:27:07','','M/O FEBRUARY','','19000.00','19000.00','Paid','2022-02-01 20:15:04','2022-02-05 18:27:07');
INSERT INTO invoices VALUES('1069','1','141','3','26','1','2022-02-01','2022-02-01 15:40:10','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-01 20:40:10');
INSERT INTO invoices VALUES('1070','1','142','1','4','1','2022-02-01','2022-02-07 14:20:15','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:04','2022-02-07 19:20:15');
INSERT INTO invoices VALUES('1071','1','143','2','39','1','2022-02-01','2022-02-14 16:00:21','','M/O FEBRUARY','','18000.00','18000.00','Paid','2022-02-01 20:15:04','2022-02-14 21:00:21');
INSERT INTO invoices VALUES('1072','1','144','1','4','1','2022-02-01','2022-02-01 15:39:27','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:04','2022-02-01 20:39:27');
INSERT INTO invoices VALUES('1073','1','145','1','4','1','2022-02-01','2022-02-11 14:11:18','','M/O FEBRUARY','','17500.00','17500.00','Paid','2022-02-01 20:15:04','2022-02-11 19:11:18');
INSERT INTO invoices VALUES('1074','1','146','3','33','1','2022-02-01','2022-02-13 10:07:26','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-13 15:07:26');
INSERT INTO invoices VALUES('1075','1','148','2','13','1','2022-02-01','2022-02-06 15:09:33','','M/O FEBRUARY','','21000.00','21000.00','Paid','2022-02-01 20:15:04','2022-02-06 20:09:33');
INSERT INTO invoices VALUES('1076','1','149','2','24','1','2022-02-01','2022-02-09 16:22:24','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-09 21:22:24');
INSERT INTO invoices VALUES('1077','1','150','2','11','1','2022-02-01','2022-02-09 12:35:31','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-09 17:35:31');
INSERT INTO invoices VALUES('1078','1','152','2','21','1','2022-02-01','2022-02-01 15:38:31','','M/O FEBRUARY','','18000.00','18000.00','Paid','2022-02-01 20:15:04','2022-02-01 20:38:31');
INSERT INTO invoices VALUES('1079','1','154','1','9','1','2022-02-01','2022-06-03 17:36:17','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-06-03 17:36:17');
INSERT INTO invoices VALUES('1080','1','155','3','43','1','2022-02-01','2022-02-17 12:09:20','','M/O FEBRUARY','','22000.00','22000.00','Paid','2022-02-01 20:15:04','2022-02-17 17:09:20');
INSERT INTO invoices VALUES('1081','1','157','1','12','1','2022-02-01','2022-02-09 13:24:17','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:04','2022-02-09 18:24:17');
INSERT INTO invoices VALUES('1082','1','158','3','43','1','2022-02-01','2022-02-15 12:35:36','','M/O FEBRUARY','','22000.00','22000.00','Paid','2022-02-01 20:15:04','2022-02-15 17:35:36');
INSERT INTO invoices VALUES('1083','1','159','2','24','1','2022-02-01','2022-02-05 14:11:12','','M/O FEBRUARY','','17000.00','17000.00','Paid','2022-02-01 20:15:04','2022-02-05 19:11:12');
INSERT INTO invoices VALUES('1084','1','160','1','1','1','2022-02-01','2022-02-07 14:36:42','','M/O FEBRUARY','','16000.00','16000.00','Paid','2022-02-01 20:15:04','2022-02-07 19:36:42');
INSERT INTO invoices VALUES('1085','1','161','3','44','1','2022-02-01','2022-04-20 16:08:15','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:04','2022-04-20 16:08:15');
INSERT INTO invoices VALUES('1086','1','162','3','44','1','2022-02-01','2022-02-18 12:15:21','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:04','2022-02-18 17:15:21');
INSERT INTO invoices VALUES('1087','1','163','3','44','1','2022-02-01','2022-02-14 16:03:04','','M/O FEBRUARY','','15500.00','15500.00','Paid','2022-02-01 20:15:04','2022-02-14 21:03:04');
INSERT INTO invoices VALUES('1088','1','164','2','10','1','2022-02-01','2022-02-06 13:30:06','','M/O FEBRUARY','','16000.00','16000.00','Paid','2022-02-01 20:15:04','2022-02-06 18:30:06');
INSERT INTO invoices VALUES('1093','1','169','2','24','1','2022-02-13','2022-02-13 13:50:08','','M/O FEBRUARY','','28000.00','28000.00','Paid','2022-02-13 18:49:20','2022-02-13 18:50:08');
INSERT INTO invoices VALUES('1094','1','168','3','28','1','2022-02-11','2022-02-13 15:56:53','','M/O FEBRUARY','','31200.00','31200.00','Paid','2022-02-13 20:55:51','2022-02-13 20:56:53');
INSERT INTO invoices VALUES('1105','1','16','3','34','1','2022-03-01','2022-04-14 18:36:43','','M/O MARCH','','20000.00','20000.00','Paid','2022-03-02 17:32:35','2022-04-14 18:36:43');
INSERT INTO invoices VALUES('1106','1','17','1','15','1','2022-03-01','2022-03-04 14:32:56','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-04 19:32:56');
INSERT INTO invoices VALUES('1107','1','18','3','33','1','2022-03-01','2022-03-07 16:01:09','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-07 21:01:09');
INSERT INTO invoices VALUES('1108','1','19','1','17','1','2022-03-01','2022-03-06 15:34:08','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-06 20:34:08');
INSERT INTO invoices VALUES('1109','1','20','3','33','1','2022-03-01','2022-03-08 16:44:36','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-08 21:44:36');
INSERT INTO invoices VALUES('1110','1','22','3','35','1','2022-03-01','2022-03-08 11:06:49','','M/O MARCH','','19000.00','19000.00','Paid','2022-03-02 17:32:35','2022-03-08 16:06:49');
INSERT INTO invoices VALUES('1111','1','28','3','34','1','2022-03-01','2022-04-14 18:38:49','','M/O MARCH','','20000.00','20000.00','Paid','2022-03-02 17:32:35','2022-04-14 18:38:49');
INSERT INTO invoices VALUES('1112','1','29','3','34','1','2022-03-01','2022-03-27 12:35:29','','M/O MARCH','','20000.00','20000.00','Paid','2022-03-02 17:32:35','2022-03-27 12:35:29');
INSERT INTO invoices VALUES('1113','1','30','3','30','1','2022-03-01','2022-03-08 16:48:09','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:35','2022-03-08 21:48:09');
INSERT INTO invoices VALUES('1114','1','34','3','29','1','2022-03-01','2022-04-14 18:27:49','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:35','2022-04-14 18:27:49');
INSERT INTO invoices VALUES('1213','1','175','3','44','1','2022-03-09','2022-03-11 13:47:40','','M/O MARCH','','25650.00','25650.00','Paid','2022-03-11 18:46:35','2022-03-11 18:47:40');
INSERT INTO invoices VALUES('1116','1','36','3','29','1','2022-03-01','2022-03-11 13:09:37','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:35','2022-03-11 18:09:37');
INSERT INTO invoices VALUES('1117','1','37','3','29','1','2022-03-01','2022-03-11 14:50:45','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:35','2022-03-11 19:50:45');
INSERT INTO invoices VALUES('1118','1','41','3','27','1','2022-03-01','2022-03-03 14:01:13','','M/O MARCH','','16000.00','16000.00','Paid','2022-03-02 17:32:35','2022-03-03 19:01:13');
INSERT INTO invoices VALUES('1119','1','42','3','27','1','2022-03-01','2022-03-08 11:09:41','','M/O MARCH','','16000.00','16000.00','Paid','2022-03-02 17:32:35','2022-03-08 16:09:41');
INSERT INTO invoices VALUES('1120','1','43','3','27','1','2022-03-01','2022-03-15 14:23:30','','M/O MARCH','','16000.00','16000.00','Paid','2022-03-02 17:32:35','2022-03-15 14:23:30');
INSERT INTO invoices VALUES('1121','1','44','3','26','1','2022-03-01','2022-03-05 15:12:47','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-05 20:12:47');
INSERT INTO invoices VALUES('1122','1','45','3','26','1','2022-03-01','2022-03-08 17:00:31','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-08 22:00:31');
INSERT INTO invoices VALUES('1123','1','46','3','26','1','2022-03-01','2022-03-10 15:09:38','','M/O MARCH','','16000.00','16000.00','Paid','2022-03-02 17:32:35','2022-03-10 20:09:38');
INSERT INTO invoices VALUES('1124','1','48','1','16','1','2022-03-01','2022-03-03 16:27:22','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-03 21:27:22');
INSERT INTO invoices VALUES('1125','1','49','2','14','1','2022-03-01','2022-03-05 15:15:22','','M/O MARCH','','14000.00','14000.00','Paid','2022-03-02 17:32:35','2022-03-05 20:15:22');
INSERT INTO invoices VALUES('1126','1','50','3','25','1','2022-03-01','2022-03-10 14:58:24','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-10 19:58:24');
INSERT INTO invoices VALUES('1127','1','51','3','25','1','2022-03-01','2022-03-06 11:32:15','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-06 16:32:15');
INSERT INTO invoices VALUES('1128','1','52','3','25','1','2022-03-01','2022-03-06 11:37:05','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-06 16:37:05');
INSERT INTO invoices VALUES('1129','1','53','3','25','1','2022-03-01','2022-03-06 14:22:06','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-06 19:22:06');
INSERT INTO invoices VALUES('1130','1','54','2','23','1','2022-03-01','2022-03-02 15:14:08','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-02 20:14:08');
INSERT INTO invoices VALUES('1131','1','55','1','17','1','2022-03-01','2022-03-06 14:12:41','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-06 19:12:41');
INSERT INTO invoices VALUES('1132','1','56','1','19','1','2022-03-01','2022-03-08 17:01:38','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-08 22:01:38');
INSERT INTO invoices VALUES('1133','1','57','1','19','1','2022-03-01','2022-03-03 13:39:36','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-03 18:39:36');
INSERT INTO invoices VALUES('1134','1','60','2','22','1','2022-03-01','2022-03-11 13:07:15','','M/O MARCH','','13000.00','13000.00','Paid','2022-03-02 17:32:35','2022-03-11 18:07:15');
INSERT INTO invoices VALUES('1135','1','61','2','22','1','2022-03-01','2022-03-08 16:51:22','','M/O MARCH','','13000.00','13000.00','Paid','2022-03-02 17:32:35','2022-03-08 21:51:22');
INSERT INTO invoices VALUES('1136','1','62','2','22','1','2022-03-01','2022-03-15 14:21:32','','M/O MARCH','','13000.00','13000.00','Paid','2022-03-02 17:32:35','2022-03-15 14:21:32');
INSERT INTO invoices VALUES('1137','1','64','1','18','1','2022-03-01','2022-03-15 14:54:21','','M/O MARCH','','22000.00','22000.00','Paid','2022-03-02 17:32:35','2022-03-15 14:54:21');
INSERT INTO invoices VALUES('1138','1','68','1','16','1','2022-03-01','2022-03-08 11:17:09','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-08 16:17:09');
INSERT INTO invoices VALUES('1139','1','69','1','16','1','2022-03-01','2022-03-02 16:21:01','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-02 21:21:01');
INSERT INTO invoices VALUES('1140','1','71','1','6','1','2022-03-01','2022-03-18 13:40:50','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-18 13:40:50');
INSERT INTO invoices VALUES('1141','1','72','1','15','1','2022-03-01','2022-03-11 13:06:15','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-11 18:06:15');
INSERT INTO invoices VALUES('1142','1','74','1','15','1','2022-03-01','2022-03-03 14:14:28','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-03 19:14:28');
INSERT INTO invoices VALUES('1143','1','76','2','14','1','2022-03-01','2022-03-06 14:10:58','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-02 17:32:35','2022-03-06 19:10:58');
INSERT INTO invoices VALUES('1144','1','77','2','14','1','2022-03-01','2022-03-06 14:10:16','','M/O MARCH','','14000.00','14000.00','Paid','2022-03-02 17:32:35','2022-03-06 19:10:16');
INSERT INTO invoices VALUES('1145','1','78','2','10','1','2022-03-01','2022-03-15 14:19:46','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:35','2022-03-15 14:19:46');
INSERT INTO invoices VALUES('1146','1','79','2','10','1','2022-03-01','2022-03-05 10:16:35','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:35','2022-03-05 15:16:35');
INSERT INTO invoices VALUES('1147','1','80','1','4','1','2022-03-01','2022-03-08 16:46:40','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-08 21:46:40');
INSERT INTO invoices VALUES('1148','1','81','1','12','1','2022-03-01','2022-03-07 14:38:05','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-07 19:38:05');
INSERT INTO invoices VALUES('1149','1','82','1','12','1','2022-03-01','2022-03-07 14:37:26','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-07 19:37:26');
INSERT INTO invoices VALUES('1150','1','83','1','12','1','2022-03-01','2022-03-10 15:00:25','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-10 20:00:25');
INSERT INTO invoices VALUES('1151','1','93','1','8','1','2022-03-01','2022-03-03 16:32:08','','M/O MARCH','','14000.00','14000.00','Paid','2022-03-02 17:32:35','2022-03-03 21:32:08');
INSERT INTO invoices VALUES('1152','1','96','1','7','1','2022-03-01','2022-04-14 18:04:58','','M/O MARCH','','16500.00','16500.00','Paid','2022-03-02 17:32:35','2022-04-14 18:04:58');
INSERT INTO invoices VALUES('1153','1','97','1','7','1','2022-03-01','2022-03-09 15:43:59','','M/O MARCH','','18000.00','18000.00','Paid','2022-03-02 17:32:35','2022-03-09 20:43:59');
INSERT INTO invoices VALUES('1154','1','99','1','6','1','2022-03-01','2022-03-10 15:03:20','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-10 20:03:20');
INSERT INTO invoices VALUES('1155','1','100','1','5','1','2022-03-01','2022-03-07 14:43:03','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-07 19:43:03');
INSERT INTO invoices VALUES('1156','1','101','1','5','1','2022-03-01','2022-03-31 14:23:59','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-31 14:23:59');
INSERT INTO invoices VALUES('1157','1','102','1','5','1','2022-03-01','2022-04-20 15:33:30','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-04-20 15:33:30');
INSERT INTO invoices VALUES('1158','1','104','1','3','1','2022-03-01','2022-03-10 15:01:17','','M/O MARCH','','18000.00','18000.00','Paid','2022-03-02 17:32:35','2022-03-10 20:01:17');
INSERT INTO invoices VALUES('1159','1','107','1','1','1','2022-03-01','2022-03-03 16:55:07','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-02 17:32:35','2022-03-03 21:55:07');
INSERT INTO invoices VALUES('1160','1','108','1','1','1','2022-03-01','2022-03-11 13:28:40','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-02 17:32:35','2022-03-11 18:28:40');
INSERT INTO invoices VALUES('1162','1','111','1','1','1','2022-03-01','2022-03-05 10:15:09','','M/O MARCH','','14000.00','14000.00','Paid','2022-03-02 17:32:35','2022-03-05 15:15:09');
INSERT INTO invoices VALUES('1163','1','112','1','1','1','2022-03-01','2022-03-08 11:36:31','','M/O MARCH','','14000.00','14000.00','Paid','2022-03-02 17:32:35','2022-03-08 16:36:31');
INSERT INTO invoices VALUES('1164','1','113','1','12','1','2022-03-01','2022-03-12 15:43:05','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-12 20:43:05');
INSERT INTO invoices VALUES('1165','1','114','3','32','1','2022-03-01','2022-03-07 15:13:39','','M/O MARCH','','19000.00','19000.00','Paid','2022-03-02 17:32:35','2022-03-07 20:13:39');
INSERT INTO invoices VALUES('1166','1','115','1','9','1','2022-03-01','2022-03-15 14:53:02','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:35','2022-03-15 14:53:02');
INSERT INTO invoices VALUES('1212','1','176','3','29','1','2022-03-11','2022-03-11 13:42:50','','M/O MARCH','','26000.00','26000.00','Paid','2022-03-11 18:41:31','2022-03-11 18:42:50');
INSERT INTO invoices VALUES('1168','1','121','1','15','1','2022-03-01','2022-03-03 13:25:26','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-03 18:25:26');
INSERT INTO invoices VALUES('1169','1','123','3','36','1','2022-03-01','2022-06-13 13:39:04','','M/O MARCH','','24000.00','24000.00','Paid','2022-03-02 17:32:35','2022-06-13 13:39:04');
INSERT INTO invoices VALUES('1170','1','124','2','21','1','2022-03-01','2022-03-02 14:56:56','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-02 19:56:56');
INSERT INTO invoices VALUES('1210','1','173','3','28','1','2022-03-01','2022-03-09 16:12:57','','M/O MARCH','','29000.00','29000.00','Paid','2022-03-09 21:04:32','2022-03-09 21:12:57');
INSERT INTO invoices VALUES('1172','1','126','1','17','1','2022-03-01','2022-03-08 11:08:59','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-08 16:08:59');
INSERT INTO invoices VALUES('1173','1','127','1','17','1','2022-03-01','2022-03-04 14:39:44','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-04 19:39:44');
INSERT INTO invoices VALUES('1174','1','128','1','1','1','2022-03-01','2022-04-20 15:18:03','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-02 17:32:35','2022-04-20 15:18:03');
INSERT INTO invoices VALUES('1175','1','129','1','18','1','2022-03-01','2022-03-02 14:53:04','','M/O MARCH','','22000.00','22000.00','Paid','2022-03-02 17:32:35','2022-03-02 19:53:04');
INSERT INTO invoices VALUES('1176','1','130','1','8','1','2022-03-01','2022-03-03 16:49:23','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-02 17:32:35','2022-03-03 21:49:23');
INSERT INTO invoices VALUES('1177','1','131','2','38','1','2022-03-01','2022-03-06 15:34:40','','M/O MARCH','','19500.00','19500.00','Paid','2022-03-02 17:32:35','2022-03-06 20:34:40');
INSERT INTO invoices VALUES('1178','1','132','2','24','1','2022-03-01','2022-03-09 15:43:07','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-09 20:43:07');
INSERT INTO invoices VALUES('1179','1','133','2','11','1','2022-03-01','2022-03-15 14:57:22','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-15 14:57:22');
INSERT INTO invoices VALUES('1180','1','135','2','11','1','2022-03-01','2022-03-03 14:04:57','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-03 19:04:57');
INSERT INTO invoices VALUES('1181','1','136','1','8','1','2022-03-01','2022-03-04 14:33:40','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-02 17:32:35','2022-03-04 19:33:40');
INSERT INTO invoices VALUES('1182','1','137','2','13','1','2022-03-01','2022-03-04 15:39:03','','M/O MARCH','','21000.00','21000.00','Paid','2022-03-02 17:32:35','2022-03-04 20:39:03');
INSERT INTO invoices VALUES('1183','1','138','3','33','1','2022-03-01','2022-03-18 13:19:23','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-18 13:19:23');
INSERT INTO invoices VALUES('1184','1','139','3','30','1','2022-03-01','2022-03-15 14:22:22','','M/O MARCH','','16500.00','16500.00','Paid','2022-03-02 17:32:35','2022-03-15 14:22:22');
INSERT INTO invoices VALUES('1185','1','141','3','26','1','2022-03-01','2022-03-29 16:56:48','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-29 16:56:48');
INSERT INTO invoices VALUES('1186','1','142','1','4','1','2022-03-01','2022-03-08 16:59:02','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-08 21:59:02');
INSERT INTO invoices VALUES('1187','1','143','2','39','1','2022-03-01','2022-03-11 13:05:16','','M/O MARCH','','18000.00','18000.00','Paid','2022-03-02 17:32:35','2022-03-11 18:05:16');
INSERT INTO invoices VALUES('1188','1','144','1','4','1','2022-03-01','2022-03-04 14:31:44','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-04 19:31:44');
INSERT INTO invoices VALUES('1189','1','145','1','4','1','2022-03-01','2022-03-08 16:58:31','','M/O MARCH','','17500.00','17500.00','Paid','2022-03-02 17:32:35','2022-03-08 21:58:31');
INSERT INTO invoices VALUES('1190','1','146','3','33','1','2022-03-01','2022-03-08 16:43:44','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-08 21:43:44');
INSERT INTO invoices VALUES('1191','1','148','2','13','1','2022-03-01','2022-03-04 15:38:07','','M/O MARCH','','21000.00','21000.00','Paid','2022-03-02 17:32:35','2022-03-04 20:38:07');
INSERT INTO invoices VALUES('1192','1','149','3','30','1','2022-03-01','2022-03-09 17:34:07','','M/O MARCH','','16000.00','16000.00','Paid','2022-03-02 17:32:35','2022-03-09 22:34:07');
INSERT INTO invoices VALUES('1193','1','150','2','11','1','2022-03-01','2022-03-11 14:42:13','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:35','2022-03-11 19:42:13');
INSERT INTO invoices VALUES('1194','1','152','2','21','1','2022-03-01','2022-03-06 11:29:50','','M/O MARCH','','18000.00','18000.00','Paid','2022-03-02 17:32:36','2022-03-06 16:29:50');
INSERT INTO invoices VALUES('1195','1','154','1','9','1','2022-03-01','2022-03-27 12:34:36','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:36','2022-03-27 12:34:36');
INSERT INTO invoices VALUES('1196','1','155','3','43','1','2022-03-01','2022-03-27 12:30:47','','M/O MARCH','','22000.00','22000.00','Paid','2022-03-02 17:32:36','2022-03-27 12:30:47');
INSERT INTO invoices VALUES('1197','1','158','3','43','1','2022-03-01','2022-03-08 16:52:09','','M/O MARCH','','22000.00','22000.00','Paid','2022-03-02 17:32:36','2022-03-08 21:52:09');
INSERT INTO invoices VALUES('1198','1','159','2','24','1','2022-03-01','2022-03-08 11:57:30','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:36','2022-03-08 16:57:30');
INSERT INTO invoices VALUES('1199','1','161','3','44','1','2022-03-01','2022-03-11 13:14:28','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:36','2022-03-11 18:14:28');
INSERT INTO invoices VALUES('1200','1','162','3','44','1','2022-03-01','2022-03-11 13:13:44','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:36','2022-03-11 18:13:44');
INSERT INTO invoices VALUES('1201','1','163','3','44','1','2022-03-01','2022-03-15 14:24:20','','M/O MARCH','EXTRA AMOUNT ADD NOUMAN AND AFAN','14000.00','14000.00','Paid','2022-03-02 17:32:36','2022-03-15 14:24:20');
INSERT INTO invoices VALUES('1202','1','164','2','10','1','2022-03-01','2022-03-03 13:29:20','','M/O MARCH','','15500.00','15500.00','Paid','2022-03-02 17:32:36','2022-03-03 18:29:20');
INSERT INTO invoices VALUES('1214','1','177','3','29','1','2022-03-08','2022-03-11 14:10:24','','M/O MARCH','','27000.00','27000.00','Paid','2022-03-11 19:09:48','2022-03-11 19:10:24');
INSERT INTO invoices VALUES('1204','1','167','2','14','1','2022-03-01','2022-03-08 11:59:57','','M/O MARCH','','15000.00','15000.00','Paid','2022-03-02 17:32:36','2022-03-08 16:59:57');
INSERT INTO invoices VALUES('1205','1','168','1','9','1','2022-03-01','2022-03-02 14:51:57','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:36','2022-03-02 19:51:57');
INSERT INTO invoices VALUES('1206','1','169','2','24','1','2022-03-01','2022-03-07 14:39:33','','M/O MARCH','','17000.00','17000.00','Paid','2022-03-02 17:32:36','2022-03-07 19:39:33');
INSERT INTO invoices VALUES('1207','1','170','1','1','1','2022-03-05','2022-03-05 16:12:43','','M/O MARCH','','30000.00','30000.00','Paid','2022-03-05 21:10:23','2022-03-05 21:12:43');
INSERT INTO invoices VALUES('1208','1','171','3','32','1','2022-03-06','2022-03-06 13:27:38','','M/O MARCH','','38000.00','38000.00','Paid','2022-03-06 18:26:03','2022-03-06 18:27:38');
INSERT INTO invoices VALUES('1209','1','172','1','8','1','2022-03-01','2022-03-06 14:36:54','','M/O MARCH','','30000.00','27000.00','Unpaid','2022-03-06 19:35:37','2022-03-06 19:36:54');
INSERT INTO invoices VALUES('1211','1','174','3','28','1','2022-03-01','2022-03-09 16:05:51','','M/O MARCH','','29000.00','29000.00','Paid','2022-03-09 21:05:13','2022-03-09 21:05:51');
INSERT INTO invoices VALUES('1216','1','2','2','23','1','2022-04-01','2022-04-05 14:32:32','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:09','2022-04-05 14:32:32');
INSERT INTO invoices VALUES('1217','1','4','1','8','1','2022-04-01','2022-04-04 14:32:38','','M/O APRIL','','10000.00','10000.00','Paid','2022-04-02 11:08:09','2022-04-04 14:32:38');
INSERT INTO invoices VALUES('1218','1','5','3','30','1','2022-04-01','2022-04-14 18:34:12','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:09','2022-04-14 18:34:12');
INSERT INTO invoices VALUES('1219','1','6','3','30','1','2022-04-01','2022-04-14 18:34:53','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:09','2022-04-14 18:34:53');
INSERT INTO invoices VALUES('1220','1','9','2','20','1','2022-04-01','2022-04-02 15:15:56','','M/O APRIL','','24000.00','24000.00','Paid','2022-04-02 11:08:09','2022-04-02 15:15:56');
INSERT INTO invoices VALUES('1221','1','12','1','16','1','2022-04-01','2022-04-14 18:18:34','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:09','2022-04-14 18:18:34');
INSERT INTO invoices VALUES('1222','1','15','1','41','1','2022-04-01','2022-04-14 18:46:28','','M/O APRIL','','18000.00','18000.00','Paid','2022-04-02 11:08:09','2022-04-14 18:46:28');
INSERT INTO invoices VALUES('1223','1','16','3','34','1','2022-04-01','2022-06-10 16:19:17','','M/O APRIL','','20000.00','20000.00','Paid','2022-04-02 11:08:09','2022-06-10 16:19:17');
INSERT INTO invoices VALUES('1224','1','17','1','15','1','2022-04-01','2022-04-05 14:29:20','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:09','2022-04-05 14:29:20');
INSERT INTO invoices VALUES('1225','1','18','3','33','1','2022-04-01','2022-04-04 14:43:40','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:09','2022-04-04 14:43:40');
INSERT INTO invoices VALUES('1226','1','19','1','17','1','2022-04-01','2022-04-06 17:16:28','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:09','2022-04-06 17:16:28');
INSERT INTO invoices VALUES('1227','1','20','3','33','1','2022-04-01','2022-04-21 15:08:30','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:09','2022-04-21 15:08:30');
INSERT INTO invoices VALUES('1228','1','22','3','35','1','2022-04-01','2022-04-05 14:34:53','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-02 11:08:09','2022-04-05 14:34:53');
INSERT INTO invoices VALUES('1229','1','28','3','34','1','2022-04-01','2022-06-07 14:20:26','','M/O APRIL','','20000.00','20000.00','Paid','2022-04-02 11:08:09','2022-06-07 14:20:26');
INSERT INTO invoices VALUES('1230','1','29','3','34','1','2022-04-01','2022-05-13 14:33:00','','M/O APRIL','','20000.00','20000.00','Paid','2022-04-02 11:08:10','2022-05-13 14:33:00');
INSERT INTO invoices VALUES('1344','1','5','3','30','1','2022-05-01','2022-05-09 14:24:14','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:06','2022-05-09 14:24:14');
INSERT INTO invoices VALUES('1232','1','34','3','29','1','2022-04-01','2022-04-14 18:27:20','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:27:20');
INSERT INTO invoices VALUES('1233','1','36','3','29','1','2022-04-01','2022-04-04 14:42:08','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-04 14:42:08');
INSERT INTO invoices VALUES('1234','1','37','3','29','1','2022-04-01','2022-04-04 14:41:31','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-04 14:41:31');
INSERT INTO invoices VALUES('1235','1','41','3','27','1','2022-04-01','2022-04-05 14:33:21','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:33:21');
INSERT INTO invoices VALUES('1236','1','42','3','27','1','2022-04-01','2022-04-20 16:03:37','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:10','2022-04-20 16:03:37');
INSERT INTO invoices VALUES('1237','1','43','3','27','1','2022-04-01','2022-05-06 13:44:33','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:10','2022-05-06 13:44:33');
INSERT INTO invoices VALUES('1238','1','44','3','26','1','2022-04-01','2022-04-14 18:23:52','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:23:52');
INSERT INTO invoices VALUES('1239','1','45','3','26','1','2022-04-01','2022-04-14 18:25:56','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:25:56');
INSERT INTO invoices VALUES('1240','1','46','3','26','1','2022-04-01','2022-04-14 18:25:16','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:25:16');
INSERT INTO invoices VALUES('1241','1','48','1','16','1','2022-04-01','2022-04-04 14:38:12','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-04 14:38:12');
INSERT INTO invoices VALUES('1242','1','49','2','14','1','2022-04-01','2022-07-04 15:45:18','','M/O APRIL','TRANSECTION HISTORY ISSUEE','7500.00','7500.00','Paid','2022-04-02 11:08:10','2022-07-04 15:45:18');
INSERT INTO invoices VALUES('1243','1','50','3','25','1','2022-04-01','2022-04-07 16:54:05','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-07 16:54:05');
INSERT INTO invoices VALUES('1244','1','51','3','25','1','2022-04-01','2022-04-05 14:38:12','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-05 14:38:12');
INSERT INTO invoices VALUES('1245','1','52','3','25','1','2022-04-01','2022-04-14 18:23:02','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:23:02');
INSERT INTO invoices VALUES('1246','1','53','3','25','1','2022-04-01','2022-04-07 16:54:28','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-07 16:54:28');
INSERT INTO invoices VALUES('1247','1','54','2','23','1','2022-04-01','2022-04-04 14:56:06','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:56:06');
INSERT INTO invoices VALUES('1248','1','55','1','17','1','2022-04-01','2022-04-04 14:39:07','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:39:07');
INSERT INTO invoices VALUES('1249','1','56','1','19','1','2022-04-01','2022-04-07 15:10:35','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-07 15:10:35');
INSERT INTO invoices VALUES('1250','1','57','1','19','1','2022-04-01','2022-04-04 14:39:53','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:39:53');
INSERT INTO invoices VALUES('1251','1','60','2','22','1','2022-04-01','2022-04-14 18:20:16','','M/O APRIL','','13000.00','13000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:20:16');
INSERT INTO invoices VALUES('1252','1','61','2','22','1','2022-04-01','2022-04-04 14:46:46','','M/O APRIL','','13000.00','13000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:46:46');
INSERT INTO invoices VALUES('1253','1','62','2','22','1','2022-04-01','2022-04-14 18:21:07','','M/O APRIL','','13000.00','13000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:21:07');
INSERT INTO invoices VALUES('1254','1','64','1','18','1','2022-04-01','2022-04-06 17:09:34','','M/O APRIL','','22000.00','22000.00','Paid','2022-04-02 11:08:10','2022-04-06 17:09:34');
INSERT INTO invoices VALUES('1255','1','68','1','16','1','2022-04-01','2022-04-07 17:03:15','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-07 17:03:15');
INSERT INTO invoices VALUES('1256','1','69','1','16','1','2022-04-01','2022-04-04 14:37:39','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-04 14:37:39');
INSERT INTO invoices VALUES('1257','1','71','1','6','1','2022-04-01','2022-04-14 18:03:30','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:03:30');
INSERT INTO invoices VALUES('1258','1','72','1','15','1','2022-04-01','2022-04-07 17:16:28','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-07 17:16:28');
INSERT INTO invoices VALUES('1259','1','74','1','15','1','2022-04-01','2022-04-05 14:28:34','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:28:34');
INSERT INTO invoices VALUES('1260','1','76','2','14','1','2022-04-01','2022-04-04 14:36:30','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:36:30');
INSERT INTO invoices VALUES('1261','1','77','2','14','1','2022-04-01','2022-04-04 14:36:55','','M/O APRIL','','14000.00','14000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:36:55');
INSERT INTO invoices VALUES('1262','1','78','2','10','1','2022-04-01','2022-04-08 17:18:37','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-08 17:18:37');
INSERT INTO invoices VALUES('1263','1','79','2','10','1','2022-04-01','2022-05-07 16:16:58','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-05-07 16:16:58');
INSERT INTO invoices VALUES('1264','1','80','1','4','1','2022-04-01','2022-04-24 10:44:34','','M/O APRIL','','2000.00','2000.00','Paid','2022-04-02 11:08:10','2022-04-24 10:44:34');
INSERT INTO invoices VALUES('1265','1','81','1','12','1','2022-04-01','2022-04-05 14:27:46','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-05 14:27:46');
INSERT INTO invoices VALUES('1266','1','82','1','12','1','2022-04-01','2022-04-14 19:26:49','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-14 19:26:49');
INSERT INTO invoices VALUES('1267','1','83','1','12','1','2022-04-01','2022-04-14 19:26:23','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-14 19:26:23');
INSERT INTO invoices VALUES('1268','1','93','1','8','1','2022-04-01','2022-04-07 14:09:15','','M/O APRIL','','14000.00','14000.00','Paid','2022-04-02 11:08:10','2022-04-07 14:09:15');
INSERT INTO invoices VALUES('1269','1','96','1','7','1','2022-04-01','2022-06-03 16:54:38','','M/O APRIL','','16500.00','16500.00','Paid','2022-04-02 11:08:10','2022-06-03 16:54:38');
INSERT INTO invoices VALUES('1270','1','97','1','7','1','2022-04-01','2022-04-14 18:04:14','','M/O APRIL','','18000.00','18000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:04:14');
INSERT INTO invoices VALUES('1271','1','99','1','6','1','2022-04-01','2022-04-04 14:27:35','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:27:35');
INSERT INTO invoices VALUES('1272','1','100','1','5','1','2022-04-01','2022-04-04 14:27:05','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:27:05');
INSERT INTO invoices VALUES('1273','1','101','1','5','1','2022-04-01','2022-04-20 15:29:57','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-20 15:29:57');
INSERT INTO invoices VALUES('1274','1','102','1','5','1','2022-04-01','2022-04-20 15:34:04','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-20 15:34:04');
INSERT INTO invoices VALUES('1275','1','104','1','3','1','2022-04-01','2022-04-14 19:22:09','','M/O APRIL','','18000.00','18000.00','Paid','2022-04-02 11:08:10','2022-04-14 19:22:09');
INSERT INTO invoices VALUES('1276','1','107','1','1','1','2022-04-01','2022-04-05 14:25:11','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:25:11');
INSERT INTO invoices VALUES('1277','1','108','1','1','1','2022-04-01','2022-04-14 18:52:06','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:52:06');
INSERT INTO invoices VALUES('1278','1','111','1','1','1','2022-04-01','2022-04-05 14:25:47','','M/O APRIL','','14000.00','14000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:25:47');
INSERT INTO invoices VALUES('1279','1','112','1','1','1','2022-04-01','2022-04-05 14:26:41','','M/O APRIL','','14000.00','14000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:26:41');
INSERT INTO invoices VALUES('1280','1','113','1','12','1','2022-04-01','2022-04-07 17:00:49','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-07 17:00:49');
INSERT INTO invoices VALUES('1281','1','114','3','32','1','2022-04-01','2022-04-14 19:34:12','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-02 11:08:10','2022-04-14 19:34:12');
INSERT INTO invoices VALUES('1282','1','115','1','9','1','2022-04-01','2022-04-08 17:30:15','','M/O APRIL','','15500.00','15000.00','Unpaid','2022-04-02 11:08:10','2022-04-08 17:30:15');
INSERT INTO invoices VALUES('1283','1','121','1','15','1','2022-04-01','2022-04-14 18:18:01','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:18:01');
INSERT INTO invoices VALUES('1284','1','123','3','36','1','2022-04-01','2022-06-13 13:39:25','','M/O APRIL','','28000.00','28000.00','Paid','2022-04-02 11:08:10','2022-06-13 13:39:25');
INSERT INTO invoices VALUES('1337','1','182','2','21','1','2022-04-28','2022-04-28 17:02:35','','M/O APRIL','','10000.00','10000.00','Paid','2022-04-28 16:43:27','2022-04-28 17:02:35');
INSERT INTO invoices VALUES('1286','1','126','1','17','1','2022-04-01','2022-04-05 14:30:53','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:30:53');
INSERT INTO invoices VALUES('1287','1','127','1','17','1','2022-04-01','2022-04-05 14:31:11','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:31:11');
INSERT INTO invoices VALUES('1288','1','128','1','1','1','2022-04-01','2022-04-05 14:27:02','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:27:02');
INSERT INTO invoices VALUES('1289','1','130','1','8','1','2022-04-01','2022-04-04 14:30:58','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:30:58');
INSERT INTO invoices VALUES('1290','1','131','2','38','1','2022-04-01','2022-04-04 14:45:21','','M/O APRIL','','19500.00','19500.00','Paid','2022-04-02 11:08:10','2022-04-04 14:45:21');
INSERT INTO invoices VALUES('1291','1','132','2','24','1','2022-04-01','2022-04-08 17:19:20','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-08 17:19:20');
INSERT INTO invoices VALUES('1292','1','133','2','11','1','2022-04-01','2022-04-14 19:35:43','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-14 19:35:43');
INSERT INTO invoices VALUES('1293','1','135','2','11','1','2022-04-01','2022-04-04 14:35:36','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:35:36');
INSERT INTO invoices VALUES('1294','1','136','1','8','1','2022-04-01','2022-04-14 19:31:28','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-14 19:31:28');
INSERT INTO invoices VALUES('1340','1','184','1','5','1','2022-04-28','2022-04-28 17:00:04','','M/O APRIL','','10000.00','10000.00','Paid','2022-04-28 16:57:36','2022-04-28 17:00:04');
INSERT INTO invoices VALUES('1296','1','138','3','33','1','2022-04-01','2022-04-08 17:20:44','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-08 17:20:44');
INSERT INTO invoices VALUES('1297','1','139','3','30','1','2022-04-01','2022-04-04 14:43:05','','M/O APRIL','','16500.00','16500.00','Paid','2022-04-02 11:08:10','2022-04-04 14:43:05');
INSERT INTO invoices VALUES('1298','1','141','3','26','1','2022-04-01','2022-04-14 18:24:44','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:24:44');
INSERT INTO invoices VALUES('1299','1','142','1','4','1','2022-04-01','2022-04-14 18:54:02','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:54:02');
INSERT INTO invoices VALUES('1300','1','143','2','39','1','2022-04-01','2022-04-14 18:45:28','','M/O APRIL','','18000.00','18000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:45:28');
INSERT INTO invoices VALUES('1301','1','144','1','4','1','2022-04-01','2022-04-05 17:25:46','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-05 17:25:46');
INSERT INTO invoices VALUES('1302','1','145','1','4','1','2022-04-01','2022-04-14 18:53:16','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:53:16');
INSERT INTO invoices VALUES('1303','1','146','3','33','1','2022-04-01','2022-04-08 17:20:16','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-08 17:20:16');
INSERT INTO invoices VALUES('1339','1','185','3','28','1','2022-04-28','2022-04-28 17:04:48','','M/O APRIL','','10000.00','10000.00','Paid','2022-04-28 16:55:53','2022-04-28 17:04:48');
INSERT INTO invoices VALUES('1305','1','149','3','30','1','2022-04-01','2022-04-14 18:31:12','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:31:12');
INSERT INTO invoices VALUES('1306','1','150','2','11','1','2022-04-01','2022-04-16 06:40:38','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-16 06:40:38');
INSERT INTO invoices VALUES('1307','1','152','2','21','1','2022-04-01','2022-04-07 16:58:10','','M/O APRIL','','18000.00','18000.00','Paid','2022-04-02 11:08:10','2022-04-07 16:58:10');
INSERT INTO invoices VALUES('1308','1','154','1','9','1','2022-04-01','2022-04-20 15:59:25','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-20 15:59:25');
INSERT INTO invoices VALUES('1309','1','155','3','43','1','2022-04-01','2022-04-21 13:29:31','','M/O APRIL','','22000.00','22000.00','Paid','2022-04-02 11:08:10','2022-04-21 13:29:31');
INSERT INTO invoices VALUES('1310','1','158','3','43','1','2022-04-01','2022-04-16 09:14:59','','M/O APRIL','','22000.00','22000.00','Paid','2022-04-02 11:08:10','2022-04-16 09:14:59');
INSERT INTO invoices VALUES('1311','1','159','2','24','1','2022-04-01','2022-04-04 17:42:42','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-04 17:42:42');
INSERT INTO invoices VALUES('1312','1','161','3','44','1','2022-04-01','2022-04-20 16:06:11','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-20 16:06:11');
INSERT INTO invoices VALUES('1313','1','162','3','44','1','2022-04-01','2022-04-14 18:43:05','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:43:05');
INSERT INTO invoices VALUES('1314','1','163','3','44','1','2022-04-01','2022-04-14 18:43:37','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:43:37');
INSERT INTO invoices VALUES('1315','1','164','2','10','1','2022-04-01','2022-04-07 17:02:24','','M/O APRIL','','17500.00','17500.00','Paid','2022-04-02 11:08:10','2022-04-07 17:02:24');
INSERT INTO invoices VALUES('1317','1','168','1','9','1','2022-04-01','2022-04-05 14:29:56','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:29:56');
INSERT INTO invoices VALUES('1318','1','169','2','24','1','2022-04-01','2022-04-05 14:32:02','','M/O APRIL','','17000.00','17000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:32:02');
INSERT INTO invoices VALUES('1319','1','170','1','1','1','2022-04-01','2022-04-05 14:26:16','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-05 14:26:16');
INSERT INTO invoices VALUES('1320','1','171','3','32','1','2022-04-01','2022-04-14 19:23:27','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-02 11:08:10','2022-04-14 19:23:27');
INSERT INTO invoices VALUES('1321','1','172','2','14','1','2022-04-01','2022-04-07 16:52:16','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-07 16:52:16');
INSERT INTO invoices VALUES('1324','1','175','3','44','1','2022-04-01','2022-04-14 18:42:17','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-14 18:42:17');
INSERT INTO invoices VALUES('1325','1','176','3','29','1','2022-04-01','2022-04-14 18:28:25','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-14 18:28:25');
INSERT INTO invoices VALUES('1326','1','177','3','29','1','2022-04-01','2022-04-05 12:59:06','','M/O APRIL','','15500.00','15500.00','Paid','2022-04-02 11:08:10','2022-04-05 12:59:06');
INSERT INTO invoices VALUES('1327','1','178','3','44','1','2022-04-01','2022-04-04 14:44:46','','M/O APRIL','','15000.00','15000.00','Paid','2022-04-02 11:08:10','2022-04-04 14:44:46');
INSERT INTO invoices VALUES('1328','1','179','3','37','1','2022-04-01','2022-04-07 16:55:41','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-02 11:08:10','2022-04-07 16:55:41');
INSERT INTO invoices VALUES('1329','1','180','3','37','1','2022-04-01','2022-04-07 16:56:03','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-02 11:08:11','2022-04-07 16:56:03');
INSERT INTO invoices VALUES('1330','1','181','1','8','1','2022-04-01','2022-04-04 14:31:54','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:08:11','2022-04-04 14:31:54');
INSERT INTO invoices VALUES('1331','1','181','1','8','1','2022-04-01','2022-04-04 14:32:13','','M/O APRIL','','16000.00','16000.00','Paid','2022-04-02 11:10:32','2022-04-04 14:32:13');
INSERT INTO invoices VALUES('1332','1','179','3','37','1','2022-04-02','2022-04-07 16:56:38','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-02 11:12:14','2022-04-07 16:56:38');
INSERT INTO invoices VALUES('1333','1','180','3','37','1','2022-04-02','2022-04-07 16:57:11','','M/O APRIL','','19000.00','19000.00','Paid','2022-04-02 11:13:55','2022-04-07 16:57:11');
INSERT INTO invoices VALUES('1334','1','99','1','6','1','2022-04-01','2022-04-04 14:30:26','','M/O APRIL','','500.00','500.00','Paid','2022-04-04 14:28:51','2022-04-04 14:30:26');
INSERT INTO invoices VALUES('1346','1','9','2','20','1','2022-05-01','2022-05-06 13:39:45','','MAY/22','M/O MAY','24000.00','24000.00','Paid','2022-05-06 13:18:06','2022-05-06 13:39:45');
INSERT INTO invoices VALUES('1347','1','12','1','16','1','2022-05-01','2022-05-06 13:36:03','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-06 13:36:03');
INSERT INTO invoices VALUES('1348','1','15','1','41','1','2022-05-01','2022-05-15 14:32:02','','MAY/22','M/O MAY','18000.00','18000.00','Paid','2022-05-06 13:18:06','2022-05-15 14:32:02');
INSERT INTO invoices VALUES('1349','1','16','3','34','1','2022-05-01','2022-06-27 12:23:24','','MAY/22','M/O MAY','20000.00','20000.00','Paid','2022-05-06 13:18:06','2022-06-27 12:23:24');
INSERT INTO invoices VALUES('1350','1','17','1','15','1','2022-05-01','2022-05-06 13:34:16','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-06 13:34:16');
INSERT INTO invoices VALUES('1351','1','18','3','33','1','2022-05-01','2022-05-06 13:46:02','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-06 13:46:02');
INSERT INTO invoices VALUES('1352','1','19','1','17','1','2022-05-01','2022-05-11 16:24:50','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-11 16:24:50');
INSERT INTO invoices VALUES('1353','1','20','3','33','1','2022-05-01','2022-05-06 13:46:24','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-06 13:46:24');
INSERT INTO invoices VALUES('1354','1','22','3','35','1','2022-05-01','2022-05-08 15:10:40','','MAY/22','M/O MAY','20790.00','20790.00','Paid','2022-05-06 13:18:06','2022-05-08 15:10:40');
INSERT INTO invoices VALUES('1355','1','28','3','34','1','2022-05-01','2022-06-07 14:21:03','','MAY/22','M/O MAY','24920.00','24920.00','Paid','2022-05-06 13:18:06','2022-06-07 14:21:03');
INSERT INTO invoices VALUES('1356','1','29','3','34','1','2022-05-01','2022-05-13 14:33:55','','MAY/22','M/O MAY','20000.00','20000.00','Paid','2022-05-06 13:18:06','2022-05-13 14:33:55');
INSERT INTO invoices VALUES('1357','1','34','3','29','1','2022-05-01','2022-06-23 15:13:25','','MAY/22','M/O MAY','15880.00','15880.00','Paid','2022-05-06 13:18:06','2022-06-23 15:13:25');
INSERT INTO invoices VALUES('1358','1','36','3','29','1','2022-05-01','2022-05-09 16:27:39','','MAY/22','M/O MAY','15880.00','15880.00','Paid','2022-05-06 13:18:06','2022-05-09 16:27:39');
INSERT INTO invoices VALUES('1359','1','37','3','29','1','2022-05-01','2022-05-06 15:57:48','','MAY/22','M/O MAY','15500.00','15500.00','Paid','2022-05-06 13:18:06','2022-05-06 15:57:48');
INSERT INTO invoices VALUES('1360','1','41','3','27','1','2022-05-01','2022-05-07 14:34:38','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:06','2022-05-07 14:34:38');
INSERT INTO invoices VALUES('1361','1','42','3','27','1','2022-05-01','2022-05-11 16:26:54','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:06','2022-05-11 16:26:54');
INSERT INTO invoices VALUES('1362','1','43','3','27','1','2022-05-01','2022-05-08 13:33:22','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:06','2022-05-08 13:33:22');
INSERT INTO invoices VALUES('1363','1','44','3','26','1','2022-05-01','2022-05-11 16:28:22','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-11 16:28:22');
INSERT INTO invoices VALUES('1364','1','45','3','26','1','2022-05-01','2022-05-11 13:21:42','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-11 13:21:42');
INSERT INTO invoices VALUES('1365','1','46','3','26','1','2022-05-01','2022-05-06 13:42:38','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:06','2022-05-06 13:42:38');
INSERT INTO invoices VALUES('1366','1','48','1','16','1','2022-05-01','2022-05-06 13:37:07','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-06 13:37:07');
INSERT INTO invoices VALUES('1367','1','49','2','14','1','2022-05-01','2022-05-13 14:04:52','','MAY/22','M/O MAY','14000.00','14000.00','Paid','2022-05-06 13:18:06','2022-05-13 14:04:52');
INSERT INTO invoices VALUES('1368','1','50','3','25','1','2022-05-01','2022-05-13 15:37:24','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-13 15:37:24');
INSERT INTO invoices VALUES('1369','1','51','3','25','1','2022-05-01','2022-05-06 14:24:17','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-06 14:24:17');
INSERT INTO invoices VALUES('1370','1','52','3','25','1','2022-05-01','2022-05-07 15:47:50','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-07 15:47:50');
INSERT INTO invoices VALUES('1371','1','53','3','25','1','2022-05-01','2022-05-09 17:15:49','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-09 17:15:49');
INSERT INTO invoices VALUES('1372','1','54','2','23','1','2022-05-01','2022-05-10 14:38:04','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-10 14:38:04');
INSERT INTO invoices VALUES('1373','1','55','1','17','1','2022-05-01','2022-05-09 13:47:47','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-09 13:47:47');
INSERT INTO invoices VALUES('1374','1','56','1','19','1','2022-05-01','2022-05-06 13:38:43','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-06 13:38:43');
INSERT INTO invoices VALUES('1375','1','57','1','19','1','2022-05-01','2022-05-06 13:39:09','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-06 13:39:09');
INSERT INTO invoices VALUES('1376','1','60','2','22','1','2022-05-01','2022-05-13 15:03:55','','MAY/22','M/O MAY','13000.00','13000.00','Paid','2022-05-06 13:18:06','2022-05-13 15:03:55');
INSERT INTO invoices VALUES('1377','1','61','2','22','1','2022-05-01','2022-05-13 15:04:19','','MAY/22','M/O MAY','13000.00','13000.00','Paid','2022-05-06 13:18:06','2022-05-13 15:04:19');
INSERT INTO invoices VALUES('1378','1','62','2','22','1','2022-05-01','2022-05-13 15:04:49','','MAY/22','M/O MAY','13000.00','13000.00','Paid','2022-05-06 13:18:06','2022-05-13 15:04:49');
INSERT INTO invoices VALUES('1379','1','64','1','18','1','2022-05-01','2022-05-17 17:14:56','','MAY/22','M/O MAY','18520.00','18520.00','Paid','2022-05-06 13:18:06','2022-05-17 17:14:56');
INSERT INTO invoices VALUES('1380','1','68','1','16','1','2022-05-01','2022-05-08 17:05:19','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-08 17:05:19');
INSERT INTO invoices VALUES('1381','1','69','1','16','1','2022-05-01','2022-05-06 13:35:34','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-06 13:35:34');
INSERT INTO invoices VALUES('1382','1','71','1','6','1','2022-05-01','2022-05-22 07:00:08','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-22 07:00:08');
INSERT INTO invoices VALUES('1383','1','72','1','15','1','2022-05-01','2022-05-09 16:45:58','','MAY/22','M/O MAY','18450.00','18450.00','Paid','2022-05-06 13:18:06','2022-05-09 16:45:58');
INSERT INTO invoices VALUES('1384','1','74','1','15','1','2022-05-01','2022-06-05 17:34:06','','MAY/22','M/O MAY','17950.00','17950.00','Paid','2022-05-06 13:18:06','2022-06-05 17:34:06');
INSERT INTO invoices VALUES('1385','1','76','2','14','1','2022-05-01','2022-05-07 15:11:39','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:06','2022-05-07 15:11:39');
INSERT INTO invoices VALUES('1386','1','77','2','14','1','2022-05-01','2022-05-09 16:39:06','','MAY/22','M/O MAY','14000.00','14000.00','Paid','2022-05-06 13:18:06','2022-05-09 16:39:06');
INSERT INTO invoices VALUES('1387','1','78','2','10','1','2022-05-01','2022-05-07 16:17:30','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-07 16:17:30');
INSERT INTO invoices VALUES('1388','1','79','2','10','1','2022-05-01','2022-05-07 16:17:56','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-07 16:17:56');
INSERT INTO invoices VALUES('1389','1','81','1','12','1','2022-05-01','2022-05-12 14:03:18','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-12 14:03:18');
INSERT INTO invoices VALUES('1390','1','82','1','12','1','2022-05-01','2022-05-15 14:37:47','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-15 14:37:47');
INSERT INTO invoices VALUES('1391','1','83','1','12','1','2022-05-01','2022-05-28 14:46:34','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-28 14:46:34');
INSERT INTO invoices VALUES('1392','1','93','1','8','1','2022-05-01','2022-05-13 15:41:05','','MAY/22','M/O MAY','14000.00','14000.00','Paid','2022-05-06 13:18:06','2022-05-13 15:41:05');
INSERT INTO invoices VALUES('1393','1','96','1','7','1','2022-05-01','2022-06-03 17:09:09','','MAY/22','M/O MAY','7500.00','7500.00','Paid','2022-05-06 13:18:06','2022-06-03 17:09:09');
INSERT INTO invoices VALUES('1394','1','97','1','7','1','2022-05-01','2022-05-11 14:24:36','','MAY/22','M/O MAY','18000.00','18000.00','Paid','2022-05-06 13:18:06','2022-05-11 14:24:36');
INSERT INTO invoices VALUES('1395','1','99','1','6','1','2022-05-01','2022-05-06 13:18:47','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:06','2022-05-06 13:18:47');
INSERT INTO invoices VALUES('1396','1','100','3','28','1','2022-05-01','2022-05-07 15:13:39','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:06','2022-05-07 15:13:39');
INSERT INTO invoices VALUES('1614','1','48','1','16','1','2022-06-01','2022-06-05 16:02:39','','JUNE/22','','520.00','520.00','Paid','2022-06-05 16:02:10','2022-06-05 16:02:39');
INSERT INTO invoices VALUES('1398','1','102','1','5','1','2022-05-01','2022-05-15 14:55:13','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:06','2022-05-15 14:55:13');
INSERT INTO invoices VALUES('1399','1','104','1','3','1','2022-05-01','2022-05-27 15:57:52','','MAY/22','M/O MAY','18000.00','18000.00','Paid','2022-05-06 13:18:07','2022-05-27 15:57:52');
INSERT INTO invoices VALUES('1400','1','107','1','1','1','2022-05-01','2022-05-08 15:19:00','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-08 15:19:00');
INSERT INTO invoices VALUES('1401','1','108','1','1','1','2022-05-01','2022-05-13 13:36:47','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-13 13:36:47');
INSERT INTO invoices VALUES('1402','1','111','1','1','1','2022-05-01','2022-05-07 14:37:54','','MAY/22','M/O MAY','14000.00','14000.00','Paid','2022-05-06 13:18:07','2022-05-07 14:37:54');
INSERT INTO invoices VALUES('1403','1','112','1','1','1','2022-05-01','2022-05-13 13:37:16','','MAY/22','M/O MAY','14000.00','14000.00','Paid','2022-05-06 13:18:07','2022-05-13 13:37:16');
INSERT INTO invoices VALUES('1404','1','113','1','12','1','2022-05-01','2022-05-12 14:02:44','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:07','2022-05-12 14:02:44');
INSERT INTO invoices VALUES('1405','1','114','3','32','1','2022-05-01','2022-05-09 13:50:47','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:07','2022-05-09 13:50:47');
INSERT INTO invoices VALUES('1406','1','115','1','9','1','2022-05-01','2022-05-11 13:16:35','','MAY/22','M/O MAY','15500.00','15000.00','Unpaid','2022-05-06 13:18:07','2022-05-11 13:16:35');
INSERT INTO invoices VALUES('1407','1','121','1','15','1','2022-05-01','2022-05-09 15:28:20','','MAY/22','M/O MAY','17950.00','17950.00','Paid','2022-05-06 13:18:07','2022-05-09 15:28:20');
INSERT INTO invoices VALUES('1408','1','123','3','36','1','2022-05-01','2022-05-11 16:18:31','','MAY/22','M/O MAY','18000.00','18000.00','Paid','2022-05-06 13:18:07','2022-05-11 16:18:31');
INSERT INTO invoices VALUES('1409','1','126','1','17','1','2022-05-01','2022-05-10 17:28:04','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-10 17:28:04');
INSERT INTO invoices VALUES('1410','1','127','1','17','1','2022-05-01','2022-05-11 13:20:07','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-11 13:20:07');
INSERT INTO invoices VALUES('1411','1','128','1','1','1','2022-05-01','2022-05-13 13:37:36','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-13 13:37:36');
INSERT INTO invoices VALUES('1412','1','129','1','18','1','2022-05-01','2022-05-22 06:53:54','','MAY/22','M/O MAY','23520.00','23310.00','Unpaid','2022-05-06 13:18:07','2022-05-22 06:53:54');
INSERT INTO invoices VALUES('1413','1','130','1','8','1','2022-05-01','2022-05-06 13:29:58','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-06 13:29:58');
INSERT INTO invoices VALUES('1414','1','131','2','38','1','2022-05-01','2022-05-06 13:46:55','','MAY/22','M/O MAY','19500.00','19500.00','Paid','2022-05-06 13:18:07','2022-05-06 13:46:55');
INSERT INTO invoices VALUES('1490','1','82','1','12','1','2022-05-01','2022-05-28 14:46:56','','MAY/22','','1000.00','1000.00','Paid','2022-05-22 07:41:52','2022-05-28 14:46:56');
INSERT INTO invoices VALUES('1416','1','133','2','11','1','2022-05-01','2022-05-28 14:43:56','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-28 14:43:56');
INSERT INTO invoices VALUES('1417','1','135','2','11','1','2022-05-01','2022-05-07 14:37:07','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-07 14:37:07');
INSERT INTO invoices VALUES('1418','1','136','1','8','1','2022-05-01','2022-05-06 15:42:52','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-06 15:42:52');
INSERT INTO invoices VALUES('1459','1','162','2','13','1','2022-05-01','2022-05-10 15:11:18','','MAY/22','','16000.00','16000.00','Paid','2022-05-08 13:38:45','2022-05-10 15:11:18');
INSERT INTO invoices VALUES('1420','1','138','3','33','1','2022-05-01','2022-05-11 16:35:23','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-11 16:35:23');
INSERT INTO invoices VALUES('1421','1','139','3','30','1','2022-05-01','2022-05-22 06:34:00','','MAY/22','M/O MAY','18030.00','18030.00','Paid','2022-05-06 13:18:07','2022-05-22 06:34:00');
INSERT INTO invoices VALUES('1422','1','141','3','26','1','2022-05-01','2022-05-06 13:41:57','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-06 13:41:57');
INSERT INTO invoices VALUES('1423','1','142','1','4','1','2022-05-01','2022-05-10 14:23:20','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:07','2022-05-10 14:23:20');
INSERT INTO invoices VALUES('1424','1','143','2','39','1','2022-05-01','2022-05-22 06:36:03','','MAY/22','M/O MAY','18000.00','18000.00','Paid','2022-05-06 13:18:07','2022-05-22 06:36:03');
INSERT INTO invoices VALUES('1486','1','19','1','17','1','2022-05-01','','','MAY/22','','300.00','','Unpaid','2022-05-22 07:36:57','2022-05-22 07:36:57');
INSERT INTO invoices VALUES('1426','1','145','1','4','1','2022-05-01','2022-05-10 14:23:55','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:07','2022-05-10 14:23:55');
INSERT INTO invoices VALUES('1427','1','146','3','33','1','2022-05-01','2022-05-11 16:33:39','','MAY/22','M/O MAY','17480.00','17480.00','Paid','2022-05-06 13:18:07','2022-05-11 16:33:39');
INSERT INTO invoices VALUES('1458','1','161','2','13','1','2022-05-01','2022-05-22 07:01:32','','MAY/22','','16000.00','16000.00','Paid','2022-05-08 13:38:45','2022-05-22 07:01:32');
INSERT INTO invoices VALUES('1429','1','149','3','30','1','2022-05-01','2022-05-10 16:00:51','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:07','2022-05-10 16:00:51');
INSERT INTO invoices VALUES('1430','1','150','2','11','1','2022-05-01','2022-05-07 14:40:01','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-07 14:40:01');
INSERT INTO invoices VALUES('1431','1','154','1','9','1','2022-05-01','2022-06-03 17:36:48','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-06-03 17:36:48');
INSERT INTO invoices VALUES('1432','1','155','3','43','1','2022-05-01','2022-05-10 15:33:27','','MAY/22','M/O MAY','22000.00','22000.00','Paid','2022-05-06 13:18:07','2022-05-10 15:33:27');
INSERT INTO invoices VALUES('1433','1','158','3','43','1','2022-05-01','2022-06-29 16:19:22','','MAY/22','M/O MAY','27360.00','27360.00','Paid','2022-05-06 13:18:07','2022-06-29 16:19:22');
INSERT INTO invoices VALUES('1434','1','159','2','24','1','2022-05-01','2022-05-06 16:19:24','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-06 16:19:24');
INSERT INTO invoices VALUES('1463','1','50','3','25','1','2022-05-01','2022-06-10 16:46:29','','MAY/22','','13480.00','13480.00','Paid','2022-05-13 15:36:37','2022-06-10 16:46:29');
INSERT INTO invoices VALUES('1461','1','178','2','13','1','2022-05-01','2022-05-09 15:48:22','','MAY/22','','16000.00','16000.00','Paid','2022-05-08 13:38:45','2022-05-09 15:48:22');
INSERT INTO invoices VALUES('1460','1','163','2','13','1','2022-05-01','2022-05-13 15:01:12','','MAY/22','','16000.00','16000.00','Paid','2022-05-08 13:38:45','2022-05-13 15:01:12');
INSERT INTO invoices VALUES('1438','1','164','2','10','1','2022-05-01','2022-05-08 13:40:47','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:07','2022-05-08 13:40:47');
INSERT INTO invoices VALUES('1439','1','168','1','9','1','2022-05-01','2022-05-06 13:30:58','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-06 13:30:58');
INSERT INTO invoices VALUES('1440','1','169','2','24','1','2022-05-01','2022-05-06 13:40:21','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-06 13:40:21');
INSERT INTO invoices VALUES('1441','1','170','1','1','1','2022-05-01','2022-05-08 17:13:20','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-08 17:13:20');
INSERT INTO invoices VALUES('1442','1','171','3','32','1','2022-05-01','2022-05-08 17:10:00','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:07','2022-05-08 17:10:00');
INSERT INTO invoices VALUES('1443','1','172','2','14','1','2022-05-01','2022-05-09 16:40:23','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-09 16:40:23');
INSERT INTO invoices VALUES('1444','1','174','3','30','1','2022-05-01','2022-05-09 13:45:40','','MAY/22','M/O MAY','16500.00','16500.00','Paid','2022-05-06 13:18:07','2022-05-09 13:45:40');
INSERT INTO invoices VALUES('1445','1','175','3','44','1','2022-05-01','2022-05-13 14:44:35','','MAY/22','M/O MAY','15000.00','15000.00','Paid','2022-05-06 13:18:07','2022-05-13 14:44:35');
INSERT INTO invoices VALUES('1446','1','176','3','29','1','2022-05-01','2022-05-07 16:41:58','','MAY/22','M/O MAY','15500.00','15500.00','Paid','2022-05-06 13:18:07','2022-05-07 16:41:58');
INSERT INTO invoices VALUES('1447','1','177','3','29','1','2022-05-01','2022-05-06 13:45:29','','MAY/22','M/O MAY','15500.00','15500.00','Paid','2022-05-06 13:18:07','2022-05-06 13:45:29');
INSERT INTO invoices VALUES('1449','1','179','3','37','1','2022-05-01','2022-05-09 15:24:12','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:07','2022-05-09 15:24:12');
INSERT INTO invoices VALUES('1450','1','180','3','37','1','2022-05-01','2022-05-09 15:24:56','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:07','2022-05-09 15:24:56');
INSERT INTO invoices VALUES('1451','1','181','1','8','1','2022-05-01','2022-05-06 13:19:49','','MAY/22','M/O MAY','16000.00','16000.00','Paid','2022-05-06 13:18:07','2022-05-06 13:19:49');
INSERT INTO invoices VALUES('1452','1','182','2','21','1','2022-05-01','2022-05-11 16:13:51','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:07','2022-05-11 16:13:51');
INSERT INTO invoices VALUES('1453','1','183','2','21','1','2022-05-01','2022-05-08 16:54:00','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:07','2022-05-08 16:54:00');
INSERT INTO invoices VALUES('1454','1','184','1','5','1','2022-05-01','2022-05-10 16:56:10','','MAY/22','M/O MAY','17000.00','17000.00','Paid','2022-05-06 13:18:07','2022-05-10 16:56:10');
INSERT INTO invoices VALUES('1455','1','185','3','28','1','2022-05-01','2022-05-08 17:40:56','','MAY/22','M/O MAY','19000.00','19000.00','Paid','2022-05-06 13:18:07','2022-05-08 17:40:56');
INSERT INTO invoices VALUES('1456','1','186','1','4','1','2022-05-01','2022-05-16 15:18:41','','MAY/22','M/O MAY','17500.00','17500.00','Paid','2022-05-06 13:18:07','2022-05-16 15:18:41');
INSERT INTO invoices VALUES('1457','1','57','1','19','1','2022-05-05','2022-05-06 15:48:54','','M/O MAY','','2345.00','2345.00','Paid','2022-05-06 15:48:27','2022-05-06 15:48:54');
INSERT INTO invoices VALUES('1464','1','102','1','5','1','2022-05-01','2022-05-15 14:54:43','','MAY/22','','2920.00','2920.00','Paid','2022-05-14 13:08:08','2022-05-15 14:54:43');
INSERT INTO invoices VALUES('1465','1','42','3','27','1','2022-05-14','2022-05-15 14:35:25','','M/O MAY','','1000.00','1000.00','Paid','2022-05-15 14:34:17','2022-05-15 14:35:25');
INSERT INTO invoices VALUES('1466','1','43','3','27','1','2022-05-14','2022-05-15 14:36:14','','M/O MAY','','1000.00','1000.00','Paid','2022-05-15 14:34:42','2022-05-15 14:36:14');
INSERT INTO invoices VALUES('1467','1','138','3','33','1','2022-05-13','2022-05-15 15:50:39','','MAY/22','','480.00','480.00','Paid','2022-05-15 15:50:03','2022-05-15 15:50:39');
INSERT INTO invoices VALUES('1468','1','114','3','32','1','2022-05-15','2022-05-16 15:17:35','','MAY/22','','10000.00','10000.00','Paid','2022-05-16 15:16:29','2022-05-16 15:17:35');
INSERT INTO invoices VALUES('1469','1','171','3','32','1','2022-05-15','2022-05-16 15:18:04','','MAY/22','','10000.00','10000.00','Paid','2022-05-16 15:17:10','2022-05-16 15:18:04');
INSERT INTO invoices VALUES('1470','1','6','3','30','1','2022-05-01','2022-05-22 06:34:29','','MAY/22','','1530.00','1530.00','Paid','2022-05-22 06:32:11','2022-05-22 06:34:29');
INSERT INTO invoices VALUES('1471','1','5','3','30','1','2022-05-01','2022-05-22 06:34:47','','MAY/22','','1530.00','1530.00','Paid','2022-05-22 06:32:40','2022-05-22 06:34:47');
INSERT INTO invoices VALUES('1472','1','149','3','30','1','2022-05-01','2022-05-22 06:35:06','','MAY/22','','1530.00','1530.00','Paid','2022-05-22 06:33:08','2022-05-22 06:35:06');
INSERT INTO invoices VALUES('1473','1','37','3','29','1','2022-05-01','2022-07-03 14:04:43','','MAY/22','','380.00','380.00','Paid','2022-05-22 06:38:15','2022-07-03 14:04:43');
INSERT INTO invoices VALUES('1474','1','176','3','29','1','2022-05-01','2022-05-31 13:32:56','','MAY/22','','380.00','380.00','Paid','2022-05-22 06:38:45','2022-05-31 13:32:56');
INSERT INTO invoices VALUES('1475','1','177','3','29','1','2022-05-01','2022-05-22 06:42:34','','MAY/22','','380.00','380.00','Paid','2022-05-22 06:39:17','2022-05-22 06:42:34');
INSERT INTO invoices VALUES('1476','1','18','3','33','1','2022-05-01','2022-06-07 15:30:48','','MAY/22','','480.00','480.00','Paid','2022-05-22 06:45:26','2022-06-07 15:30:48');
INSERT INTO invoices VALUES('1477','1','20','3','33','1','2022-05-01','2022-05-22 06:46:29','','MAY/22','','480.00','480.00','Paid','2022-05-22 06:45:58','2022-05-22 06:46:29');
INSERT INTO invoices VALUES('1478','1','64','1','18','1','2022-05-01','2022-05-22 06:58:45','','MAY/22','','5000.00','5000.00','Paid','2022-05-22 06:55:57','2022-05-22 06:58:45');
INSERT INTO invoices VALUES('1479','1','116','4','42','1','2022-05-01','2022-05-22 07:11:43','','MAY/22 (211 3 SAETS)','','15600.00','15600.00','Paid','2022-05-22 07:11:12','2022-05-22 07:11:43');
INSERT INTO invoices VALUES('1480','1','161','2','13','1','2022-05-01','2022-05-22 07:18:04','','MAY/22','','500.00','500.00','Paid','2022-05-22 07:16:56','2022-05-22 07:18:04');
INSERT INTO invoices VALUES('1481','1','17','1','15','1','2022-05-01','2022-06-07 16:41:38','','MAY/22','','950.00','950.00','Paid','2022-05-22 07:26:00','2022-06-07 16:41:38');
INSERT INTO invoices VALUES('1482','1','12','1','16','1','2022-05-01','2022-06-12 17:00:02','','MAY/22','','160.00','160.00','Paid','2022-05-22 07:27:32','2022-06-12 17:00:02');
INSERT INTO invoices VALUES('1483','1','48','1','16','1','2022-05-01','2022-05-22 07:29:43','','MAY/22','','160.00','160.00','Paid','2022-05-22 07:27:53','2022-05-22 07:29:43');
INSERT INTO invoices VALUES('1484','1','68','1','16','1','2022-05-01','2022-06-14 12:04:30','','MAY/22','','160.00','160.00','Paid','2022-05-22 07:28:42','2022-06-14 12:04:30');
INSERT INTO invoices VALUES('1485','1','69','1','16','1','2022-05-01','2022-05-22 07:30:08','','MAY/22','','160.00','160.00','Paid','2022-05-22 07:29:04','2022-05-22 07:30:08');
INSERT INTO invoices VALUES('1487','1','55','1','17','1','2022-05-01','','','MAY/22','','300.00','','Unpaid','2022-05-22 07:37:22','2022-05-22 07:37:22');
INSERT INTO invoices VALUES('1488','1','126','1','17','1','2022-05-02','','','MAY/22','','300.00','','Unpaid','2022-05-22 07:37:44','2022-05-22 07:37:44');
INSERT INTO invoices VALUES('1489','1','127','1','17','1','2022-05-01','','','MAY/22','','300.00','','Unpaid','2022-05-22 07:38:12','2022-05-22 07:38:12');
INSERT INTO invoices VALUES('1491','1','100','3','28','1','2022-05-01','2022-05-22 07:47:25','','MAY/22','','240.00','240.00','Paid','2022-05-22 07:47:00','2022-05-22 07:47:25');
INSERT INTO invoices VALUES('1492','1','78','2','10','1','2022-05-01','2022-05-31 13:36:19','','M/O MAY','','6000.00','6000.00','Paid','2022-05-31 13:34:53','2022-05-31 13:36:19');
INSERT INTO invoices VALUES('1493','1','79','2','10','1','2022-05-01','2022-05-31 13:36:43','','M/O MAY','','6000.00','6000.00','Paid','2022-05-31 13:35:25','2022-05-31 13:36:43');
INSERT INTO invoices VALUES('1494','1','164','2','10','1','2022-05-01','2022-05-31 13:37:02','','M/O MAY','','6000.00','6000.00','Paid','2022-05-31 13:35:49','2022-05-31 13:37:02');
INSERT INTO invoices VALUES('1495','1','187','1','4','1','2022-05-01','2022-05-31 14:01:12','','MAY/22','','10000.00','10000.00','Paid','2022-05-31 13:58:25','2022-05-31 14:01:12');
INSERT INTO invoices VALUES('1496','1','188','2','24','1','2022-05-01','2022-05-31 14:01:32','','MAY/22','','10000.00','10000.00','Paid','2022-05-31 13:58:58','2022-05-31 14:01:32');
INSERT INTO invoices VALUES('1497','1','189','3','44','1','2022-05-01','2022-05-31 14:02:09','','MAY/22','','10000.00','10000.00','Paid','2022-05-31 13:59:35','2022-05-31 14:02:09');
INSERT INTO invoices VALUES('1498','1','190','3','44','1','2022-05-01','2022-05-31 14:02:36','','MAY/22','','10000.00','10000.00','Paid','2022-05-31 14:00:43','2022-05-31 14:02:36');
INSERT INTO invoices VALUES('1499','1','2','2','23','1','2022-06-01','2022-06-05 17:05:48','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:53','2022-06-05 17:05:48');
INSERT INTO invoices VALUES('1500','1','4','1','8','1','2022-06-01','2022-06-03 18:15:11','','JUN/22','','10000.00','10000.00','Paid','2022-06-01 14:35:53','2022-06-03 18:15:11');
INSERT INTO invoices VALUES('1501','1','5','3','30','1','2022-06-01','2022-06-06 17:31:44','','JUN/22','18 DAYS RENT SEAT CANCEL','11520.00','11520.00','Paid','2022-06-01 14:35:53','2022-06-06 17:31:44');
INSERT INTO invoices VALUES('1502','1','6','3','30','1','2022-06-01','2022-06-06 15:53:29','','JUN/22','LEAVE 18 DATE','11520.00','11520.00','Paid','2022-06-01 14:35:53','2022-06-06 15:53:29');
INSERT INTO invoices VALUES('1503','1','9','2','20','1','2022-06-01','2022-06-01 14:52:43','','JUN/22','','24000.00','24000.00','Paid','2022-06-01 14:35:53','2022-06-01 14:52:43');
INSERT INTO invoices VALUES('1504','1','12','1','16','1','2022-06-01','2022-06-06 18:48:55','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:53','2022-06-06 18:48:55');
INSERT INTO invoices VALUES('1505','1','15','1','41','1','2022-06-01','2022-06-07 15:41:17','','JUN/22','','18000.00','18000.00','Paid','2022-06-01 14:35:53','2022-06-07 15:41:17');
INSERT INTO invoices VALUES('1506','1','16','3','34','1','2022-06-01','','','JUN/22','','20000.00','','Unpaid','2022-06-01 14:35:53','2022-06-01 14:35:53');
INSERT INTO invoices VALUES('1507','1','17','1','15','1','2022-06-01','2022-06-07 16:41:14','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:53','2022-06-07 16:41:14');
INSERT INTO invoices VALUES('1508','1','18','3','33','1','2022-06-01','2022-06-07 15:31:43','','JUN/22','','17900.00','17900.00','Paid','2022-06-01 14:35:53','2022-06-07 15:31:43');
INSERT INTO invoices VALUES('1509','1','19','1','17','1','2022-06-01','2022-06-10 16:52:27','','JUN/22','','22000.00','22000.00','Paid','2022-06-01 14:35:53','2022-06-10 16:52:27');
INSERT INTO invoices VALUES('1510','1','20','3','33','1','2022-06-01','2022-06-04 17:15:08','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:53','2022-06-04 17:15:08');
INSERT INTO invoices VALUES('1511','1','22','3','35','1','2022-06-01','2022-06-05 15:27:18','','JUN/22','','20120.00','20120.00','Paid','2022-06-01 14:35:53','2022-06-05 15:27:18');
INSERT INTO invoices VALUES('1512','1','28','3','34','1','2022-06-01','2022-07-05 14:21:27','','JUN/22','','26880.00','23160.00','Unpaid','2022-06-01 14:35:53','2022-07-05 14:21:27');
INSERT INTO invoices VALUES('1513','1','29','3','34','1','2022-06-01','2022-06-07 14:12:15','','JUN/22','','20000.00','20000.00','Paid','2022-06-01 14:35:53','2022-06-07 14:12:15');
INSERT INTO invoices VALUES('1514','1','34','3','29','1','2022-06-01','2022-06-23 15:14:21','','JUN/22','','16320.00','14750.00','Unpaid','2022-06-01 14:35:53','2022-06-23 15:14:21');
INSERT INTO invoices VALUES('1515','1','36','3','29','1','2022-06-01','2022-06-02 13:30:29','','JUN/22','','16320.00','16320.00','Paid','2022-06-01 14:35:53','2022-06-02 13:30:29');
INSERT INTO invoices VALUES('1516','1','37','3','29','1','2022-06-01','2022-07-03 14:05:48','','JUN/22','','16320.00','16320.00','Paid','2022-06-01 14:35:53','2022-07-03 14:05:48');
INSERT INTO invoices VALUES('1517','1','41','3','27','1','2022-06-01','2022-06-21 14:59:36','','JUN/22','','16500.00','16500.00','Paid','2022-06-01 14:35:53','2022-06-21 14:59:36');
INSERT INTO invoices VALUES('1518','1','42','3','27','1','2022-06-01','2022-06-12 13:33:21','','JUN/22','','16000.00','16000.00','Paid','2022-06-01 14:35:53','2022-06-12 13:33:21');
INSERT INTO invoices VALUES('1519','1','43','3','27','1','2022-06-01','2022-06-21 14:59:08','','JUN/22','','16500.00','16500.00','Paid','2022-06-01 14:35:53','2022-06-21 14:59:08');
INSERT INTO invoices VALUES('1520','1','44','3','26','1','2022-06-01','2022-06-07 14:09:08','','JUN/22','','17600.00','17500.00','Unpaid','2022-06-01 14:35:53','2022-06-07 14:09:08');
INSERT INTO invoices VALUES('1521','1','45','3','26','1','2022-06-01','2022-06-29 16:17:11','','JUN/22','','17600.00','17500.00','Unpaid','2022-06-01 14:35:53','2022-06-29 16:17:11');
INSERT INTO invoices VALUES('1522','1','46','3','26','1','2022-06-01','2022-06-03 16:44:55','','JUN/22','','16300.00','16300.00','Paid','2022-06-01 14:35:53','2022-06-03 16:44:55');
INSERT INTO invoices VALUES('1523','1','48','1','16','1','2022-06-01','2022-06-04 17:14:43','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:53','2022-06-04 17:14:43');
INSERT INTO invoices VALUES('1524','1','49','2','14','1','2022-06-01','2022-06-07 18:02:34','','JUN/22','','14000.00','14000.00','Paid','2022-06-01 14:35:53','2022-06-07 18:02:34');
INSERT INTO invoices VALUES('1525','1','50','3','25','1','2022-06-01','2022-06-17 13:54:10','','JUN/22','','22480.00','22480.00','Paid','2022-06-01 14:35:53','2022-06-17 13:54:10');
INSERT INTO invoices VALUES('1526','1','51','3','25','1','2022-06-01','2022-06-06 15:59:47','','JUN/22','','22480.00','22480.00','Paid','2022-06-01 14:35:53','2022-06-06 15:59:47');
INSERT INTO invoices VALUES('1527','1','52','3','25','1','2022-06-01','2022-06-07 15:11:33','','JUN/22','','22480.00','22480.00','Paid','2022-06-01 14:35:53','2022-06-07 15:11:33');
INSERT INTO invoices VALUES('1528','1','53','3','25','1','2022-06-01','2022-06-10 16:32:08','','JUN/22','','22480.00','22480.00','Paid','2022-06-01 14:35:53','2022-06-10 16:32:08');
INSERT INTO invoices VALUES('1529','1','54','2','23','1','2022-06-01','2022-06-02 17:14:57','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:53','2022-06-02 17:14:57');
INSERT INTO invoices VALUES('1530','1','55','1','17','1','2022-06-01','2022-06-07 17:21:46','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:53','2022-06-07 17:21:46');
INSERT INTO invoices VALUES('1531','1','56','1','19','1','2022-06-01','2022-06-12 12:40:19','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:53','2022-06-12 12:40:19');
INSERT INTO invoices VALUES('1532','1','57','1','19','1','2022-06-01','2022-06-20 17:15:09','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:53','2022-06-20 17:15:09');
INSERT INTO invoices VALUES('1533','1','60','2','22','1','2022-06-01','2022-06-20 16:51:17','','JUN/22','','13000.00','13000.00','Paid','2022-06-01 14:35:53','2022-06-20 16:51:17');
INSERT INTO invoices VALUES('1534','1','61','2','22','1','2022-06-01','2022-06-12 12:39:04','','JUN/22','','13000.00','13000.00','Paid','2022-06-01 14:35:53','2022-06-12 12:39:04');
INSERT INTO invoices VALUES('1535','1','62','2','22','1','2022-06-01','2022-06-12 12:39:23','','JUN/22','','13000.00','13000.00','Paid','2022-06-01 14:35:53','2022-06-12 12:39:23');
INSERT INTO invoices VALUES('1536','1','64','1','18','1','2022-06-01','2022-06-20 17:12:03','','JUN/22','','26940.00','26940.00','Paid','2022-06-01 14:35:53','2022-06-20 17:12:03');
INSERT INTO invoices VALUES('1623','1','68','1','16','1','2022-06-01','2022-06-14 12:04:49','','JUN/22','','520.00','520.00','Paid','2022-06-14 12:03:51','2022-06-14 12:04:49');
INSERT INTO invoices VALUES('1538','1','69','1','16','1','2022-06-01','2022-06-12 17:01:00','','JUN/22','','18020.00','18020.00','Paid','2022-06-01 14:35:53','2022-06-12 17:01:00');
INSERT INTO invoices VALUES('1539','1','71','1','6','1','2022-06-01','2022-06-13 15:27:00','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:53','2022-06-13 15:27:00');
INSERT INTO invoices VALUES('1540','1','72','1','15','1','2022-06-01','2022-06-06 15:42:10','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:53','2022-06-06 15:42:10');
INSERT INTO invoices VALUES('1541','1','74','1','15','1','2022-06-01','2022-06-05 17:35:00','','JUN/22','','18500.00','18500.00','Paid','2022-06-01 14:35:53','2022-06-05 17:35:00');
INSERT INTO invoices VALUES('1542','1','76','2','14','1','2022-06-01','2022-06-12 14:48:57','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-12 14:48:57');
INSERT INTO invoices VALUES('1543','1','77','2','14','1','2022-06-01','2022-06-04 17:29:34','','JUN/22','','14000.00','14000.00','Paid','2022-06-01 14:35:54','2022-06-04 17:29:34');
INSERT INTO invoices VALUES('1544','1','78','2','10','1','2022-06-01','2022-06-22 14:12:17','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:54','2022-06-22 14:12:17');
INSERT INTO invoices VALUES('1545','1','79','2','10','1','2022-06-01','2022-06-22 14:12:41','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:54','2022-06-22 14:12:41');
INSERT INTO invoices VALUES('1546','1','81','1','12','1','2022-06-01','2022-06-27 12:27:51','','JUN/22','','18230.00','18010.00','Unpaid','2022-06-01 14:35:54','2022-06-27 12:27:51');
INSERT INTO invoices VALUES('1547','1','82','1','12','1','2022-06-01','2022-06-10 12:32:26','','JUN/22','','18230.00','18000.00','Unpaid','2022-06-01 14:35:54','2022-06-10 12:32:26');
INSERT INTO invoices VALUES('1548','1','83','1','12','1','2022-06-01','2022-07-05 14:02:38','','JUN/22','','18230.00','18230.00','Paid','2022-06-01 14:35:54','2022-07-05 14:02:38');
INSERT INTO invoices VALUES('1549','1','93','1','8','1','2022-06-01','2022-06-07 14:46:07','','JUN/22','','14000.00','14000.00','Paid','2022-06-01 14:35:54','2022-06-07 14:46:07');
INSERT INTO invoices VALUES('1550','1','96','1','7','1','2022-06-01','2022-06-03 16:55:15','','JUN/22','','16500.00','16500.00','Paid','2022-06-01 14:35:54','2022-06-03 16:55:15');
INSERT INTO invoices VALUES('1551','1','97','1','7','1','2022-06-01','2022-06-10 12:11:33','','JUN/22','','18000.00','18000.00','Paid','2022-06-01 14:35:54','2022-06-10 12:11:33');
INSERT INTO invoices VALUES('1552','1','99','1','6','1','2022-06-01','2022-06-14 12:42:55','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:54','2022-06-14 12:42:55');
INSERT INTO invoices VALUES('1553','1','100','3','28','1','2022-06-01','2022-06-04 17:13:42','','JUN/22','','20540.00','20500.00','Unpaid','2022-06-01 14:35:54','2022-06-04 17:13:42');
INSERT INTO invoices VALUES('1554','1','102','1','5','1','2022-06-01','2022-06-23 16:25:04','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-23 16:25:04');
INSERT INTO invoices VALUES('1555','1','104','1','3','1','2022-06-01','2022-06-22 14:11:24','','JUN/22','','18000.00','18000.00','Paid','2022-06-01 14:35:54','2022-06-22 14:11:24');
INSERT INTO invoices VALUES('1556','1','107','1','1','1','2022-06-01','2022-06-05 17:05:11','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-05 17:05:11');
INSERT INTO invoices VALUES('1557','1','108','1','1','1','2022-06-01','2022-06-13 15:26:38','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-13 15:26:38');
INSERT INTO invoices VALUES('1558','1','111','1','1','1','2022-06-01','2022-06-20 16:47:48','','JUN/22','','14000.00','14000.00','Paid','2022-06-01 14:35:54','2022-06-20 16:47:48');
INSERT INTO invoices VALUES('1559','1','112','1','1','1','2022-06-01','2022-06-20 16:48:11','','JUN/22','','14000.00','14000.00','Paid','2022-06-01 14:35:54','2022-06-20 16:48:11');
INSERT INTO invoices VALUES('1560','1','113','1','12','1','2022-06-01','2022-06-10 12:32:55','','JUN/22','','18230.00','17500.00','Unpaid','2022-06-01 14:35:54','2022-06-10 12:32:55');
INSERT INTO invoices VALUES('1561','1','114','3','32','1','2022-06-01','2022-06-05 17:00:39','','JUN/22','','19800.00','19800.00','Paid','2022-06-01 14:35:54','2022-06-05 17:00:39');
INSERT INTO invoices VALUES('1562','1','115','1','9','1','2022-06-01','2022-06-10 12:12:31','','JUN/22','','15500.00','15000.00','Unpaid','2022-06-01 14:35:54','2022-06-10 12:12:31');
INSERT INTO invoices VALUES('1563','1','121','1','15','1','2022-06-01','2022-06-07 16:45:41','','JUN/22','','19930.00','19930.00','Paid','2022-06-01 14:35:54','2022-06-07 16:45:41');
INSERT INTO invoices VALUES('1564','1','123','3','36','1','2022-06-01','2022-06-13 13:40:37','','JUN/22','','21000.00','18000.00','Unpaid','2022-06-01 14:35:54','2022-06-13 13:40:37');
INSERT INTO invoices VALUES('1565','1','126','1','17','1','2022-06-01','2022-06-10 16:52:54','','JUN/22','','22000.00','22000.00','Paid','2022-06-01 14:35:54','2022-06-10 16:52:54');
INSERT INTO invoices VALUES('1566','1','127','1','17','1','2022-06-01','2022-06-03 17:38:14','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-03 17:38:14');
INSERT INTO invoices VALUES('1567','1','128','1','1','1','2022-06-01','2022-06-05 17:24:06','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-05 17:24:06');
INSERT INTO invoices VALUES('1625','1','56','1','19','1','2022-06-01','2022-06-20 17:15:31','','JUNE/22','','2480.00','2480.00','Paid','2022-06-20 17:14:39','2022-06-20 17:15:31');
INSERT INTO invoices VALUES('1569','1','130','1','8','1','2022-06-01','2022-06-03 16:37:32','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-03 16:37:32');
INSERT INTO invoices VALUES('1570','1','131','2','38','1','2022-06-01','2022-06-06 11:59:33','','JUN/22','','19500.00','19500.00','Paid','2022-06-01 14:35:54','2022-06-06 11:59:33');
INSERT INTO invoices VALUES('1613','1','185','3','28','1','2022-06-01','2022-06-04 17:36:15','','JUN/22','','1540.00','1540.00','Paid','2022-06-04 17:35:15','2022-06-04 17:36:15');
INSERT INTO invoices VALUES('1572','1','135','2','11','1','2022-06-01','2022-06-04 17:17:25','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-04 17:17:25');
INSERT INTO invoices VALUES('1573','1','136','1','8','1','2022-06-01','2022-06-10 17:04:43','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-10 17:04:43');
INSERT INTO invoices VALUES('1574','1','138','3','33','1','2022-06-01','2022-06-17 14:29:08','','JUN/22','','17900.00','17900.00','Paid','2022-06-01 14:35:54','2022-06-17 14:29:08');
INSERT INTO invoices VALUES('1622','1','139','1','18','1','2022-06-01','2022-06-13 14:57:00','','JUN/22','','22000.00','22000.00','Paid','2022-06-13 14:55:46','2022-06-13 14:57:00');
INSERT INTO invoices VALUES('1576','1','141','3','26','1','2022-06-01','2022-06-06 15:13:40','','JUN/22','','17600.00','17600.00','Paid','2022-06-01 14:35:54','2022-06-06 15:13:40');
INSERT INTO invoices VALUES('1577','1','142','1','4','1','2022-06-01','2022-06-10 16:55:14','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:54','2022-06-10 16:55:14');
INSERT INTO invoices VALUES('1578','1','143','2','39','1','2022-06-01','2022-06-16 14:37:05','','JUN/22','','18000.00','18000.00','Paid','2022-06-01 14:35:54','2022-06-16 14:37:05');
INSERT INTO invoices VALUES('1579','1','145','1','4','1','2022-06-01','2022-06-10 12:04:25','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:54','2022-06-10 12:04:25');
INSERT INTO invoices VALUES('1580','1','146','3','33','1','2022-06-01','2022-06-17 14:29:45','','JUN/22','','17900.00','17900.00','Paid','2022-06-01 14:35:54','2022-06-17 14:29:45');
INSERT INTO invoices VALUES('1581','1','149','3','30','1','2022-06-01','2022-06-22 12:57:28','','JUN/22','','11520.00','11520.00','Paid','2022-06-01 14:35:54','2022-06-22 12:57:28');
INSERT INTO invoices VALUES('1582','1','150','2','11','1','2022-06-01','2022-06-05 17:57:22','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-05 17:57:22');
INSERT INTO invoices VALUES('1583','1','154','1','9','1','2022-06-01','2022-06-29 16:16:30','','JUN/22','','17000.00','11500.00','Unpaid','2022-06-01 14:35:54','2022-06-29 16:16:30');
INSERT INTO invoices VALUES('1584','1','155','3','43','1','2022-06-01','2022-06-13 12:21:47','','JUN/22','','22000.00','22000.00','Paid','2022-06-01 14:35:54','2022-06-13 12:21:47');
INSERT INTO invoices VALUES('1585','1','158','3','43','1','2022-06-01','2022-06-30 15:42:13','','JUN/22','','28760.00','28760.00','Paid','2022-06-01 14:35:54','2022-06-30 15:42:13');
INSERT INTO invoices VALUES('1586','1','159','2','24','1','2022-06-01','2022-06-03 17:39:03','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-03 17:39:03');
INSERT INTO invoices VALUES('1587','1','161','2','13','1','2022-06-01','2022-06-22 14:15:04','','JUN/22','','16000.00','16000.00','Paid','2022-06-01 14:35:54','2022-06-22 14:15:04');
INSERT INTO invoices VALUES('1588','1','162','2','13','1','2022-06-01','2022-06-22 14:15:25','','JUN/22','','16000.00','16000.00','Paid','2022-06-01 14:35:54','2022-06-22 14:15:25');
INSERT INTO invoices VALUES('1589','1','163','2','13','1','2022-06-01','2022-06-07 16:15:41','','JUN/22','','16000.00','16000.00','Paid','2022-06-01 14:35:54','2022-06-07 16:15:41');
INSERT INTO invoices VALUES('1590','1','164','2','10','1','2022-06-01','2022-06-05 18:12:31','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:54','2022-06-05 18:12:31');
INSERT INTO invoices VALUES('1591','1','168','1','9','1','2022-06-01','2022-06-02 17:07:13','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-02 17:07:13');
INSERT INTO invoices VALUES('1592','1','169','2','24','1','2022-06-01','2022-06-03 17:42:33','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-03 17:42:33');
INSERT INTO invoices VALUES('1593','1','170','1','1','1','2022-06-01','2022-06-06 12:15:08','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-06 12:15:08');
INSERT INTO invoices VALUES('1594','1','171','3','32','1','2022-06-01','2022-06-14 12:36:20','','JUN/22','','19800.00','19800.00','Paid','2022-06-01 14:35:54','2022-06-14 12:36:20');
INSERT INTO invoices VALUES('1595','1','172','2','14','1','2022-06-01','2022-06-10 12:59:57','','JUN/22','','15000.00','15000.00','Paid','2022-06-01 14:35:54','2022-06-10 12:59:57');
INSERT INTO invoices VALUES('1596','1','174','3','30','1','2022-06-01','2022-06-06 18:16:47','','JUN/22','','18420.00','18420.00','Paid','2022-06-01 14:35:54','2022-06-06 18:16:47');
INSERT INTO invoices VALUES('1597','1','175','3','44','1','2022-06-01','2022-06-10 16:18:36','','JUN/22','','16340.00','16340.00','Paid','2022-06-01 14:35:54','2022-06-10 16:18:36');
INSERT INTO invoices VALUES('1598','1','176','3','29','1','2022-06-01','2022-06-10 16:26:32','','JUN/22','','16320.00','15500.00','Unpaid','2022-06-01 14:35:54','2022-06-10 16:26:32');
INSERT INTO invoices VALUES('1599','1','177','3','29','1','2022-06-01','2022-06-02 14:14:34','','JUN/22','','16320.00','16320.00','Paid','2022-06-01 14:35:54','2022-06-02 14:14:34');
INSERT INTO invoices VALUES('1600','1','178','2','13','1','2022-06-01','2022-06-07 16:16:18','','JUN/22','','16000.00','16000.00','Paid','2022-06-01 14:35:54','2022-06-07 16:16:18');
INSERT INTO invoices VALUES('1601','1','179','3','37','1','2022-06-01','2022-06-13 13:54:32','','JUN/22','','19500.00','19500.00','Paid','2022-06-01 14:35:54','2022-06-13 13:54:32');
INSERT INTO invoices VALUES('1602','1','180','3','37','1','2022-06-01','2022-06-06 11:56:38','','JUN/22','','19520.00','19520.00','Paid','2022-06-01 14:35:54','2022-06-06 11:56:38');
INSERT INTO invoices VALUES('1603','1','181','1','8','1','2022-06-01','2022-06-01 14:39:23','','JUN/22','','16000.00','16000.00','Paid','2022-06-01 14:35:54','2022-06-01 14:39:23');
INSERT INTO invoices VALUES('1604','1','182','2','21','1','2022-06-01','2022-06-07 15:22:57','','JUN/22','','19000.00','19000.00','Paid','2022-06-01 14:35:54','2022-06-07 15:22:57');
INSERT INTO invoices VALUES('1605','1','183','2','21','1','2022-06-01','2022-06-10 16:48:02','','JUN/22','','19000.00','19000.00','Paid','2022-06-01 14:35:54','2022-06-10 16:48:02');
INSERT INTO invoices VALUES('1606','1','184','2','11','1','2022-06-01','2022-06-07 17:00:00','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-07 17:00:00');
INSERT INTO invoices VALUES('1607','1','185','3','28','1','2022-06-01','2022-06-02 17:08:41','','JUN/22','','19000.00','19000.00','Paid','2022-06-01 14:35:54','2022-06-02 17:08:41');
INSERT INTO invoices VALUES('1608','1','186','1','4','1','2022-06-01','2022-06-12 13:25:25','','JUN/22','','17500.00','17500.00','Paid','2022-06-01 14:35:54','2022-06-12 13:25:25');
INSERT INTO invoices VALUES('1609','1','187','1','5','1','2022-06-01','2022-06-01 14:45:25','','JUN/22','','17000.00','17000.00','Paid','2022-06-01 14:35:54','2022-06-01 14:45:25');
INSERT INTO invoices VALUES('1610','1','188','2','24','1','2022-06-01','2022-06-07 16:50:53','','JUN/22','','15500.00','15500.00','Paid','2022-06-01 14:35:54','2022-06-07 16:50:53');
INSERT INTO invoices VALUES('1611','1','189','3','44','1','2022-06-01','2022-06-01 14:36:36','','JUN/22','','15500.00','15500.00','Paid','2022-06-01 14:35:54','2022-06-01 14:36:36');
INSERT INTO invoices VALUES('1612','1','190','3','44','1','2022-06-01','2022-06-01 14:42:46','','JUN/22','','15500.00','15500.00','Paid','2022-06-01 14:35:54','2022-06-01 14:42:46');
INSERT INTO invoices VALUES('1615','1','72','1','15','1','2022-06-01','2022-06-07 16:36:55','','JUN/22','','2930.00','2930.00','Paid','2022-06-06 15:45:26','2022-06-07 16:36:55');
INSERT INTO invoices VALUES('1616','1','20','3','33','1','2022-06-01','2022-06-07 16:23:24','','JUN/22','','900.00','900.00','Paid','2022-06-07 16:22:38','2022-06-07 16:23:24');
INSERT INTO invoices VALUES('1617','1','101','1','5','1','2022-06-01','2022-06-10 12:23:35','','JUN/22','','17000.00','17000.00','Paid','2022-06-10 12:19:39','2022-06-10 12:23:35');
INSERT INTO invoices VALUES('1618','1','101','1','5','1','2022-06-01','2022-06-27 12:26:59','','JUN/22','4 months not available','12000.00','12000.00','Paid','2022-06-10 12:21:29','2022-06-27 12:26:59');
INSERT INTO invoices VALUES('1619','1','55','1','17','1','2022-06-12','2022-06-12 12:38:10','','JUN/22','','5000.00','5000.00','Paid','2022-06-12 12:37:46','2022-06-12 12:38:10');
INSERT INTO invoices VALUES('1620','1','102','1','5','1','2022-06-01','2022-06-23 16:25:25','','JUN/22','','5320.00','5320.00','Paid','2022-06-12 14:41:14','2022-06-23 16:25:25');
INSERT INTO invoices VALUES('1621','1','12','1','16','1','2022-06-01','2022-06-12 17:02:57','','JUN/22','','520.00','520.00','Paid','2022-06-12 17:02:15','2022-06-12 17:02:57');
INSERT INTO invoices VALUES('1624','1','127','1','17','1','2022-06-01','2022-06-14 12:44:59','','JUN/22','','5000.00','5000.00','Paid','2022-06-14 12:44:10','2022-06-14 12:44:59');
INSERT INTO invoices VALUES('1626','1','178','2','13','1','2022-06-15','2022-06-22 14:15:45','','JUNE/22','','8000.00','8000.00','Paid','2022-06-22 14:14:40','2022-06-22 14:15:45');
INSERT INTO invoices VALUES('1627','1','192','1','16','1','2022-06-22','2022-06-22 15:07:23','','JUNE/22','','17500.00','17500.00','Paid','2022-06-22 15:03:03','2022-06-22 15:07:23');
INSERT INTO invoices VALUES('1628','1','191','1','5','1','2022-06-22','2022-06-22 15:06:51','','JUNE/22','','17000.00','17000.00','Paid','2022-06-22 15:03:40','2022-06-22 15:06:51');
INSERT INTO invoices VALUES('1629','1','42','3','27','1','2022-06-01','2022-06-23 14:47:54','','JUN/22','','500.00','500.00','Paid','2022-06-23 14:46:28','2022-06-23 14:47:54');
INSERT INTO invoices VALUES('1630','1','116','4','42','1','2022-06-23','2022-06-23 16:56:51','','JUN/22','','15000.00','15000.00','Paid','2022-06-23 16:55:52','2022-06-23 16:56:51');
INSERT INTO invoices VALUES('1631','1','2','2','23','1','2022-07-07','2022-07-07 10:56:00','','JUL/22','','17000.00','17000.00','Paid','2022-07-01 16:48:42','2022-07-07 10:56:00');
INSERT INTO invoices VALUES('1632','1','4','1','8','1','2022-07-07','','','JUL/22','','10000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1633','1','9','2','20','1','2022-07-07','2022-07-03 14:10:38','','JUL/22','','24000.00','24000.00','Paid','2022-07-01 16:48:42','2022-07-03 14:10:38');
INSERT INTO invoices VALUES('1634','1','12','1','16','1','2022-07-07','2022-07-05 14:18:59','','JUL/22','','17950.00','17500.00','Unpaid','2022-07-01 16:48:42','2022-07-05 14:18:59');
INSERT INTO invoices VALUES('1635','1','15','1','41','1','2022-07-07','2022-07-03 14:14:57','','JUL/22','','18000.00','18000.00','Paid','2022-07-01 16:48:42','2022-07-03 14:14:57');
INSERT INTO invoices VALUES('1636','1','16','3','34','1','2022-07-07','','','JUL/22','','20000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1637','1','17','1','15','1','2022-07-07','2022-07-07 10:48:15','','JUL/22','','16063.00','16063.00','Paid','2022-07-01 16:48:42','2022-07-07 10:48:15');
INSERT INTO invoices VALUES('1638','1','18','3','33','1','2022-07-07','2022-07-03 14:13:58','','JUL/22','','8790.00','8790.00','Paid','2022-07-01 16:48:42','2022-07-03 14:13:58');
INSERT INTO invoices VALUES('1639','1','19','1','17','1','2022-07-07','2022-07-07 10:54:22','','JUL/22','','9600.00','9600.00','Paid','2022-07-01 16:48:42','2022-07-07 10:54:22');
INSERT INTO invoices VALUES('1640','1','20','3','33','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1641','1','22','3','35','1','2022-07-07','','','JUL/22','','19000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1642','1','28','3','34','1','2022-07-07','','','JUL/22','','20000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1643','1','29','3','34','1','2022-07-07','','','JUL/22','','20000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1644','1','34','3','29','1','2022-07-07','','','JUL/22','','15500.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1645','1','36','3','29','1','2022-07-07','2022-07-03 14:10:10','','JUL/22','','16560.00','16560.00','Paid','2022-07-01 16:48:42','2022-07-03 14:10:10');
INSERT INTO invoices VALUES('1646','1','37','3','29','1','2022-07-07','2022-07-03 14:06:46','','JUL/22','','16560.00','16560.00','Paid','2022-07-01 16:48:42','2022-07-03 14:06:46');
INSERT INTO invoices VALUES('1647','1','42','3','27','1','2022-07-07','2022-07-07 10:56:39','','JUL/22','','16000.00','13500.00','Unpaid','2022-07-01 16:48:42','2022-07-07 10:56:39');
INSERT INTO invoices VALUES('1648','1','43','3','27','1','2022-07-07','','','JUL/22','','16000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1649','1','44','3','26','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1650','1','45','3','26','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1651','1','46','3','26','1','2022-07-07','','','JUL/22','','16000.00','','Unpaid','2022-07-01 16:48:42','2022-07-01 16:48:42');
INSERT INTO invoices VALUES('1652','1','48','1','16','1','2022-07-07','2022-07-03 15:51:46','','JUL/22','','17950.00','17950.00','Paid','2022-07-01 16:48:43','2022-07-03 15:51:46');
INSERT INTO invoices VALUES('1653','1','49','2','14','1','2022-07-07','2022-07-04 15:45:49','','JUL/22','','14000.00','14000.00','Paid','2022-07-01 16:48:43','2022-07-04 15:45:49');
INSERT INTO invoices VALUES('1654','1','50','3','25','1','2022-07-07','2022-07-07 10:11:50','','JUL/22','','24080.00','21080.00','Unpaid','2022-07-01 16:48:43','2022-07-07 10:11:50');
INSERT INTO invoices VALUES('1655','1','51','3','25','1','2022-07-07','2022-07-04 15:38:08','','JUL/22','','24080.00','24080.00','Paid','2022-07-01 16:48:43','2022-07-04 15:38:08');
INSERT INTO invoices VALUES('1656','1','52','3','25','1','2022-07-07','2022-07-07 10:06:00','','JUL/22','','24080.00','24080.00','Paid','2022-07-01 16:48:43','2022-07-07 10:06:00');
INSERT INTO invoices VALUES('1657','1','53','3','25','1','2022-07-07','2022-07-04 12:31:50','','JUL/22','','24080.00','17500.00','Unpaid','2022-07-01 16:48:43','2022-07-04 12:31:50');
INSERT INTO invoices VALUES('1658','1','54','2','23','1','2022-07-07','2022-07-03 13:59:25','','JUL/22','','8500.00','8500.00','Paid','2022-07-01 16:48:43','2022-07-03 13:59:25');
INSERT INTO invoices VALUES('1659','1','55','1','17','1','2022-07-07','','','JUL/22','','9600.00','','Unpaid','2022-07-01 16:48:43','2022-07-07 10:51:19');
INSERT INTO invoices VALUES('1660','1','56','1','19','1','2022-07-07','2022-07-07 10:55:24','','JUL/22','','18330.00','18330.00','Paid','2022-07-01 16:48:43','2022-07-07 10:55:24');
INSERT INTO invoices VALUES('1661','1','57','1','19','1','2022-07-07','2022-07-05 14:07:03','','JUL/22','','16330.00','16330.00','Paid','2022-07-01 16:48:43','2022-07-05 14:07:03');
INSERT INTO invoices VALUES('1662','1','60','2','22','1','2022-07-07','','','JUL/22','','13000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1663','1','61','2','22','1','2022-07-07','2022-07-05 14:33:18','','JUL/22','','13000.00','13000.00','Paid','2022-07-01 16:48:43','2022-07-05 14:33:18');
INSERT INTO invoices VALUES('1664','1','62','2','22','1','2022-07-07','','','JUL/22','','13000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1665','1','64','1','18','1','2022-07-07','2022-07-04 15:42:14','','JUL/22','','25280.00','21000.00','Unpaid','2022-07-01 16:48:43','2022-07-04 15:42:14');
INSERT INTO invoices VALUES('1666','1','69','1','16','1','2022-07-07','2022-07-03 16:58:57','','JUL/22','','17950.00','17950.00','Paid','2022-07-01 16:48:43','2022-07-03 16:58:57');
INSERT INTO invoices VALUES('1667','1','71','1','6','1','2022-07-07','','','JUL/22','','17500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1668','1','72','1','15','1','2022-07-07','2022-07-07 10:48:33','','JUL/22','','22133.00','22133.00','Paid','2022-07-01 16:48:43','2022-07-07 10:48:33');
INSERT INTO invoices VALUES('1669','1','74','1','15','1','2022-07-07','2022-07-03 13:58:06','','JUL/22','','13133.00','13133.00','Paid','2022-07-01 16:48:43','2022-07-03 13:58:06');
INSERT INTO invoices VALUES('1670','1','76','2','14','1','2022-07-07','2022-07-07 10:41:16','','JUL/22','','15000.00','15000.00','Paid','2022-07-01 16:48:43','2022-07-07 10:41:16');
INSERT INTO invoices VALUES('1671','1','77','2','14','1','2022-07-07','2022-07-07 10:42:12','','JUL/22','','7000.00','7000.00','Paid','2022-07-01 16:48:43','2022-07-07 10:42:12');
INSERT INTO invoices VALUES('1672','1','78','2','10','1','2022-07-07','','','JUL/22','','17500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1673','1','79','2','10','1','2022-07-07','2022-07-07 10:40:30','','JUL/22','','18810.00','18500.00','Unpaid','2022-07-01 16:48:43','2022-07-07 10:40:30');
INSERT INTO invoices VALUES('1674','1','81','1','12','1','2022-07-07','','','JUL/22','','17500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1675','1','82','1','12','1','2022-07-07','','','JUL/22','','17500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1676','1','83','1','12','1','2022-07-07','2022-07-05 14:03:25','','JUL/22','','18000.00','500.00','Unpaid','2022-07-01 16:48:43','2022-07-05 14:03:25');
INSERT INTO invoices VALUES('1677','1','93','1','8','1','2022-07-07','','','JUL/22','','14000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1678','1','96','1','7','1','2022-07-07','2022-07-05 15:18:39','','JUL/22','','16500.00','16500.00','Paid','2022-07-01 16:48:43','2022-07-05 15:18:39');
INSERT INTO invoices VALUES('1679','1','97','1','7','1','2022-07-07','2022-07-04 13:55:01','','JUL/22','','18000.00','18000.00','Paid','2022-07-01 16:48:43','2022-07-04 13:55:01');
INSERT INTO invoices VALUES('1680','1','99','1','6','1','2022-07-07','2022-07-03 13:55:51','','JUL/22','','17500.00','17500.00','Paid','2022-07-01 16:48:43','2022-07-03 13:55:51');
INSERT INTO invoices VALUES('1681','1','100','3','28','1','2022-07-07','2022-07-05 14:11:12','','JUL/22','','20910.00','19000.00','Unpaid','2022-07-01 16:48:43','2022-07-05 14:11:12');
INSERT INTO invoices VALUES('1682','1','101','1','5','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1683','1','102','1','5','1','2022-07-07','2022-07-05 13:57:05','','JUL/22','','25400.00','10000.00','Unpaid','2022-07-01 16:48:43','2022-07-05 13:57:05');
INSERT INTO invoices VALUES('1684','1','104','1','3','1','2022-07-07','','','JUL/22','','18000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1685','1','107','1','1','1','2022-07-07','2022-07-05 13:49:51','','JUL/22','','15000.00','15000.00','Paid','2022-07-01 16:48:43','2022-07-05 13:49:51');
INSERT INTO invoices VALUES('1686','1','108','1','1','1','2022-07-07','','','JUL/22','','15000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1687','1','111','1','1','1','2022-07-07','2022-07-05 15:34:53','','JUL/22','','7000.00','7000.00','Paid','2022-07-01 16:48:43','2022-07-05 15:34:53');
INSERT INTO invoices VALUES('1688','1','112','1','1','1','2022-07-07','2022-07-07 10:35:15','','JUL/22','','14000.00','14000.00','Paid','2022-07-01 16:48:43','2022-07-07 10:35:15');
INSERT INTO invoices VALUES('1689','1','113','1','12','1','2022-07-07','','','JUL/22','','17500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1690','1','114','3','32','1','2022-07-07','2022-07-05 14:20:25','','JUL/22','','23200.00','19000.00','Unpaid','2022-07-01 16:48:43','2022-07-05 14:20:25');
INSERT INTO invoices VALUES('1691','1','115','1','9','1','2022-07-07','','','JUL/22','','15500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1692','1','121','1','15','1','2022-07-07','2022-07-05 14:05:47','','JUL/22','','13135.00','13135.00','Paid','2022-07-01 16:48:43','2022-07-05 14:05:47');
INSERT INTO invoices VALUES('1693','1','123','3','36','1','2022-07-07','','','JUL/22','','24000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1694','1','126','1','17','1','2022-07-07','','','JUL/22','','9600.00','','Unpaid','2022-07-01 16:48:43','2022-07-07 10:50:06');
INSERT INTO invoices VALUES('1695','1','127','1','17','1','2022-07-07','2022-07-07 10:53:33','','JUL/22','','9600.00','9600.00','Paid','2022-07-01 16:48:43','2022-07-07 10:53:33');
INSERT INTO invoices VALUES('1696','1','128','1','1','1','2022-07-07','2022-07-04 13:56:41','','JUL/22','','15000.00','15000.00','Paid','2022-07-01 16:48:43','2022-07-04 13:56:41');
INSERT INTO invoices VALUES('1697','1','130','1','8','1','2022-07-07','','','JUL/22','','15000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1698','1','131','2','38','1','2022-07-07','2022-07-03 14:15:19','','JUL/22','','19500.00','19500.00','Paid','2022-07-01 16:48:43','2022-07-03 14:15:19');
INSERT INTO invoices VALUES('1699','1','135','2','11','1','2022-07-07','2022-07-07 11:02:39','','JUL/22','','8500.00','8500.00','Paid','2022-07-01 16:48:43','2022-07-07 11:02:39');
INSERT INTO invoices VALUES('1700','1','136','1','8','1','2022-07-07','','','JUL/22','','15000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1701','1','138','3','33','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1702','1','139','1','18','1','2022-07-07','','','JUL/22','','22000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1703','1','141','3','26','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1704','1','142','1','4','1','2022-07-07','2022-07-07 10:36:16','','JUL/22','','17500.00','17500.00','Paid','2022-07-01 16:48:43','2022-07-07 10:36:16');
INSERT INTO invoices VALUES('1705','1','143','2','39','1','2022-07-07','','','JUL/22','','18000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1706','1','145','1','4','1','2022-07-07','2022-07-07 10:36:42','','JUL/22','','17500.00','17500.00','Paid','2022-07-01 16:48:43','2022-07-07 10:36:42');
INSERT INTO invoices VALUES('1707','1','146','3','33','1','2022-07-07','2022-07-05 16:16:58','','JUL/22','','17290.00','17290.00','Paid','2022-07-01 16:48:43','2022-07-05 16:16:58');
INSERT INTO invoices VALUES('1708','1','150','2','11','1','2022-07-07','2022-07-05 13:59:44','','JUL/22','','17000.00','17000.00','Paid','2022-07-01 16:48:43','2022-07-05 13:59:44');
INSERT INTO invoices VALUES('1709','1','154','1','9','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1710','1','158','3','43','1','2022-07-07','2022-07-07 11:12:30','','JUL/22','','22000.00','22000.00','Paid','2022-07-01 16:48:43','2022-07-07 11:12:30');
INSERT INTO invoices VALUES('1711','1','159','2','24','1','2022-07-07','2022-07-03 17:00:25','','JUL/22','','17000.00','17000.00','Paid','2022-07-01 16:48:43','2022-07-03 17:00:25');
INSERT INTO invoices VALUES('1712','1','161','2','13','1','2022-07-07','','','JUL/22','','16000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1713','1','162','2','13','1','2022-07-07','','','JUL/22','','16000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1714','1','163','2','13','1','2022-07-07','','','JUL/22','','16000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1715','1','164','2','10','1','2022-07-07','2022-07-05 16:06:05','','JUL/22','','18830.00','18830.00','Paid','2022-07-01 16:48:43','2022-07-05 16:06:05');
INSERT INTO invoices VALUES('1716','1','168','1','9','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1717','1','169','2','24','1','2022-07-07','2022-07-04 12:29:32','','JUL/22','','8500.00','8500.00','Paid','2022-07-01 16:48:43','2022-07-04 12:29:32');
INSERT INTO invoices VALUES('1718','1','170','1','1','1','2022-07-07','2022-07-07 10:38:20','','JUL/22','','15000.00','15000.00','Paid','2022-07-01 16:48:43','2022-07-07 10:38:20');
INSERT INTO invoices VALUES('1719','1','171','3','32','1','2022-07-07','2022-07-04 12:59:32','','JUL/22','','23200.00','23200.00','Paid','2022-07-01 16:48:43','2022-07-04 12:59:32');
INSERT INTO invoices VALUES('1720','1','172','2','14','1','2022-07-07','','','JUL/22','','15000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1721','1','174','3','30','1','2022-07-07','','','JUL/22','','8950.00','','Unpaid','2022-07-01 16:48:43','2022-07-05 14:14:31');
INSERT INTO invoices VALUES('1722','1','175','3','44','1','2022-07-07','2022-07-07 11:08:40','','JUL/22','','16730.00','16730.00','Paid','2022-07-01 16:48:43','2022-07-07 11:08:40');
INSERT INTO invoices VALUES('1723','1','176','3','29','1','2022-07-07','','','JUL/22','','15500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1724','1','177','3','29','1','2022-07-07','2022-07-05 15:31:31','','JUL/22','','8810.00','8500.00','Unpaid','2022-07-01 16:48:43','2022-07-05 15:31:31');
INSERT INTO invoices VALUES('1725','1','178','2','13','1','2022-07-07','','','JUL/22','','16000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1726','1','179','3','37','1','2022-07-07','2022-07-05 13:43:12','','JUL/22','','22500.00','22500.00','Paid','2022-07-01 16:48:43','2022-07-05 13:43:12');
INSERT INTO invoices VALUES('1727','1','180','3','37','1','2022-07-07','','','JUL/22','','19000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1728','1','181','1','8','1','2022-07-07','2022-07-05 13:57:55','','JUL/22','','16000.00','16000.00','Paid','2022-07-01 16:48:43','2022-07-05 13:57:55');
INSERT INTO invoices VALUES('1740','1','182','1','4','1','2022-07-07','2022-07-05 13:54:50','','JUL/22','','8750.00','8000.00','Unpaid','2022-07-05 13:52:40','2022-07-05 13:54:50');
INSERT INTO invoices VALUES('1730','1','183','2','21','1','2022-07-07','','','JUL/22','','19000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1731','1','184','3','30','1','2022-07-07','2022-07-07 10:57:05','','JUL/22','','8950.00','8950.00','Paid','2022-07-01 16:48:43','2022-07-07 10:57:05');
INSERT INTO invoices VALUES('1732','1','185','3','28','1','2022-07-07','','','JUL/22','','19000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1733','1','186','1','4','1','2022-07-07','','','JUL/22','','17500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1734','1','187','3','30','1','2022-07-07','2022-07-05 14:16:02','','JUL/22','','8950.00','8950.00','Paid','2022-07-01 16:48:43','2022-07-05 14:16:02');
INSERT INTO invoices VALUES('1735','1','188','2','11','1','2022-07-07','2022-07-05 14:00:53','','JUL/22','','8500.00','8500.00','Paid','2022-07-01 16:48:43','2022-07-05 14:00:53');
INSERT INTO invoices VALUES('1736','1','189','3','30','1','2022-07-07','2022-07-05 14:15:41','','JUL/22','','8950.00','8950.00','Paid','2022-07-01 16:48:43','2022-07-05 14:15:41');
INSERT INTO invoices VALUES('1737','1','190','3','30','1','2022-07-07','2022-07-03 17:43:21','','JUL/22','','8950.00','8950.00','Paid','2022-07-01 16:48:43','2022-07-03 17:43:21');
INSERT INTO invoices VALUES('1738','1','191','1','5','1','2022-07-07','','','JUL/22','','17000.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');
INSERT INTO invoices VALUES('1739','1','192','1','16','1','2022-07-07','','','JUL/22','','17500.00','','Unpaid','2022-07-01 16:48:43','2022-07-01 16:48:43');



DROP TABLE IF EXISTS library_members;

CREATE TABLE `library_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `library_id` int(11) NOT NULL,
  `member_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS mark_details;

CREATE TABLE `mark_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `mark_id` int(11) NOT NULL,
  `mark_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mark_value` decimal(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS mark_distributions;

CREATE TABLE `mark_distributions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `mark_distribution_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mark_percentage` decimal(8,2) NOT NULL,
  `is_exam` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `is_active` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS marks;

CREATE TABLE `marks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS messages;

CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS migrations;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS notices;

CREATE TABLE `notices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS packages;

CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `max_user` int(11) DEFAULT 0,
  `price` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS page_contents;

CREATE TABLE `page_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL,
  `page_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_content` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seo_meta_keywords` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seo_meta_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'english',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS pages;

CREATE TABLE `pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_template` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `featured_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS parents;

CREATE TABLE `parents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `parent_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `f_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `m_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `f_profession` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `m_profession` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO parents VALUES('1','1','159','DEFAULT','DEFAULT','HKKHBSHSH','DXC','413131321','923221111111','DFADA','2021-06-17 01:22:14','2021-09-15 20:54:21');
INSERT INTO parents VALUES('2','1','260','Testing Demo','Smith','Jane','','','03000000000','','2021-06-19 07:54:51','2021-06-19 07:54:51');



DROP TABLE IF EXISTS password_resets;

CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS payee_payers;

CREATE TABLE `payee_payers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payee_payers VALUES('5','1','ABID SB','payee','','2021-08-04 21:18:35','2021-08-04 21:18:45');
INSERT INTO payee_payers VALUES('2','1','SHAHBAZ','payee','','2021-06-25 19:47:17','2021-08-04 21:22:51');
INSERT INTO payee_payers VALUES('4','1','USAMA SB','payee','','2021-08-04 21:18:04','2021-08-04 21:18:16');



DROP TABLE IF EXISTS payment_methods;

CREATE TABLE `payment_methods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `school_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_methods VALUES('1','BANK','1','2021-06-17 01:43:59','2021-06-17 01:43:59');
INSERT INTO payment_methods VALUES('4','CASH','1','2021-06-17 01:49:06','2021-06-17 01:49:06');



DROP TABLE IF EXISTS permission_roles;

CREATE TABLE `permission_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `role_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permission_roles VALUES('1','1','Accountant','','2020-01-04 15:04:31','2020-01-05 14:53:21');
INSERT INTO permission_roles VALUES('2','1','admin 2','','2020-04-11 13:50:52','2020-04-11 13:50:52');
INSERT INTO permission_roles VALUES('3','1','Super Admin','','2020-04-11 14:14:21','2020-04-11 14:14:21');
INSERT INTO permission_roles VALUES('5','1','Testing','','2020-04-11 15:20:39','2020-04-11 15:20:39');
INSERT INTO permission_roles VALUES('6','1','students','','2021-03-07 09:09:23','2021-03-07 09:09:23');
INSERT INTO permission_roles VALUES('7','1','Manager','','2021-06-17 02:13:04','2021-06-17 02:13:04');
INSERT INTO permission_roles VALUES('8','1','Chef','','2021-06-17 02:13:17','2021-06-17 02:13:17');
INSERT INTO permission_roles VALUES('9','1','Cook','','2021-06-17 02:13:26','2021-06-17 02:13:26');
INSERT INTO permission_roles VALUES('10','1','Cook Helper','','2021-06-17 02:13:37','2021-06-17 02:13:37');
INSERT INTO permission_roles VALUES('11','1','Sweeper','','2021-06-17 02:13:48','2021-06-17 02:13:48');
INSERT INTO permission_roles VALUES('12','1','Guard','','2021-06-17 02:13:57','2021-06-17 02:13:57');



DROP TABLE IF EXISTS permissions;

CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1349 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('432','1','1','invoices.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('431','1','1','fee_types.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('4','2','1','users.edit','2020-01-04 15:04:55','2020-01-04 15:04:55');
INSERT INTO permissions VALUES('430','1','1','fee_types.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('429','1','1','fee_types.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('428','1','1','fee_types.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('427','1','1','fee_types.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('426','1','1','transactions.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('425','1','1','transactions.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('424','1','1','transactions.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('423','1','1','transactions.store','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('422','1','1','transactions.add_expense','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('421','1','1','transactions.add_income','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('420','1','1','transactions.manage_expense','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('419','1','1','transactions.manage_income','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('418','1','1','payee_payers.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('417','1','1','payee_payers.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('416','1','1','payee_payers.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('415','1','1','payee_payers.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('414','1','1','payee_payers.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('413','1','1','payment_methods.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('412','1','1','payment_methods.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('411','1','1','payment_methods.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('410','1','1','payment_methods.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('409','1','1','payment_methods.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('408','1','1','chart_of_accounts.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('407','1','1','chart_of_accounts.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('406','1','1','chart_of_accounts.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('405','1','1','chart_of_accounts.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('404','1','1','chart_of_accounts.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('403','1','1','accounts.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('402','1','1','accounts.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('401','1','1','accounts.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('400','1','1','accounts.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('399','1','1','accounts.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('398','1','1','users.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('360','1','2','students.promote','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('359','1','2','students.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('358','1','2','students.view_id_card','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('357','1','2','parents.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('356','1','2','parents.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('355','1','2','parents.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('354','1','2','parents.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('353','1','2','parents.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('352','1','2','teachers.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('351','1','2','teachers.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('350','1','2','teachers.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('349','1','2','teachers.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('348','1','2','teachers.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('347','1','2','users.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('346','1','2','users.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('345','1','2','users.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('344','1','2','users.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('343','1','2','users.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('1348','1','3','permission_roles.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1347','1','3','permission_roles.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1346','1','3','permission_roles.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1345','1','3','permission_roles.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1344','1','3','permission_roles.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1343','1','3','permission.manage','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1342','1','3','reports.generate_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1341','1','3','reports.report_area','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1340','1','3','reports.account_balance','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1339','1','3','reports.expense_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1338','1','3','reports.income_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1337','1','3','reports.exam_routine','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1336','1','3','reports.class_routine','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1335','1','3','reports.progress_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1334','1','3','reports.exam_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1333','1','3','reports.student_id_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1332','1','3','reports.staff_attendance_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1331','1','3','reports.student_attendance_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1330','1','3','events.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1329','1','3','events.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1328','1','3','events.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1327','1','3','events.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1326','1','3','notices.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1325','1','3','notices.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1324','1','3','notices.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1323','1','3','notices.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1322','1','3','email.view_logs','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1321','1','3','email.compose','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1320','1','3','sms.view_logs','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1319','1','3','sms.compose','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1318','1','3','student_payments.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1317','1','3','student_payments.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1316','1','3','student_payments.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1315','1','3','student_payments.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1314','1','3','student_payments.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1313','1','3','student_ledger_print','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1312','1','3','student_ledger','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1311','1','3','invoices.fee_receipt_store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1310','1','3','invoices.fee_receipt','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1309','1','3','invoices.as_assigned','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1308','1','3','invoices.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1307','1','3','invoices.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1306','1','3','invoices.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1305','1','3','invoices.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1304','1','3','invoices.feeBill','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1303','1','3','invoices.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1302','1','3','fee_types.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1301','1','3','fee_types.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1300','1','3','fee_types.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1299','1','3','fee_types.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1298','1','3','fee_types.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1297','1','3','transactions.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1296','1','3','transactions.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1295','1','3','transactions.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1294','1','3','transactions.store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1293','1','3','transactions.add_expense','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1292','1','3','transactions.add_income','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1291','1','3','transactions.manage_expense','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1290','1','3','transactions.manage_income','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1289','1','3','payee_payers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1288','1','3','payee_payers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1287','1','3','payee_payers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1286','1','3','payee_payers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1285','1','3','payee_payers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1284','1','3','payment_methods.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1283','1','3','payment_methods.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1282','1','3','payment_methods.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1281','1','3','payment_methods.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1280','1','3','payment_methods.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1279','1','3','chart_of_accounts.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1278','1','3','chart_of_accounts.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1277','1','3','chart_of_accounts.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1276','1','3','chart_of_accounts.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1275','1','3','chart_of_accounts.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1274','1','3','accounts.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1273','1','3','accounts.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1272','1','3','accounts.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1271','1','3','accounts.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1270','1','3','accounts.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1269','1','3','marks.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1268','1','3','marks.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1267','1','3','marks.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1266','1','3','marks.view_student_rank','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1265','1','3','mark_distributions.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1264','1','3','mark_distributions.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1263','1','3','mark_distributions.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1262','1','3','mark_distributions.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1261','1','3','mark_distributions.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1260','1','3','grades.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1259','1','3','grades.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1258','1','3','grades.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1257','1','3','grades.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1256','1','3','grades.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1255','1','3','exams.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1254','1','3','exams.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1253','1','3','exams.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1252','1','3','exams.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1251','1','3','exams.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1250','1','3','exams.store_exam_schedule','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1249','1','3','exams.store_exam_attendance','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1248','1','3','exams.view_schedule','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1247','1','3','hostelmembers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1246','1','3','hostelmembers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1245','1','3','hostelmembers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1244','1','3','hostelmembers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1243','1','3','hostelmembers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1242','1','3','hostelcategories.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1241','1','3','hostelcategories.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1240','1','3','hostelcategories.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1239','1','3','hostelcategories.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1238','1','3','hostelcategories.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1237','1','3','hostels.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1236','1','3','hostels.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1235','1','3','hostels.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1234','1','3','hostels.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1233','1','3','hostels.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1232','1','3','transportmembers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1231','1','3','transportmembers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1230','1','3','transportmembers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1229','1','3','transportmembers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1228','1','3','transportmembers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1227','1','3','transports.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1226','1','3','transports.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1225','1','3','transports.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1224','1','3','transports.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1223','1','3','transports.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1222','1','3','transportvehicles.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1221','1','3','transportvehicles.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1220','1','3','transportvehicles.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1219','1','3','transportvehicles.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1218','1','3','transportvehicles.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1217','1','3','bookcategories.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1216','1','3','bookcategories.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1215','1','3','bookcategories.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1214','1','3','bookcategories.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1213','1','3','bookcategories.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1212','1','3','bookissues.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1211','1','3','bookissues.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1210','1','3','bookissues.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1209','1','3','bookissues.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1208','1','3','bookissues.return','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1207','1','3','bookissues.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1206','1','3','books.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1205','1','3','books.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1204','1','3','books.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1203','1','3','books.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1202','1','3','books.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1201','1','3','librarymembers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1200','1','3','librarymembers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1199','1','3','librarymembers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1198','1','3','librarymembers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1197','1','3','librarymembers.view_library_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1196','1','3','picklists.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1195','1','3','picklists.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1194','1','3','picklists.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1193','1','3','picklists.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1192','1','3','picklists.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1191','1','3','languages.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1190','1','3','languages.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1189','1','3','languages.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1188','1','3','languages.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1184','1','3','staff_attendance.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1185','1','3','general_settings.update','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1186','1','3','theme_option.update','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1187','1','3','utility.backup_database','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('361','1','2','students.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('362','1','2','students.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('363','1','2','students.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('364','1','2','students.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('365','1','2','class.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('366','1','2','class.store','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('367','1','2','class.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('368','1','2','class.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('369','1','4','students.view_id_card','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('370','1','4','students.index','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('371','1','4','students.promote','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('372','1','4','students.create','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('373','1','4','students.show','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('374','1','4','students.edit','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('375','1','4','students.destroy','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('376','1','4','class.index','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('377','1','4','class.store','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('378','1','4','class.edit','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('379','1','4','class.destroy','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('380','1','5','transports.index','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('381','1','5','transports.create','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('382','1','5','transports.show','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('383','1','5','transports.edit','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('384','1','5','transports.destroy','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('385','1','5','transactions.manage_income','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('386','1','5','transactions.manage_expense','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('387','1','5','transactions.add_income','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('388','1','5','transactions.add_expense','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('389','1','5','transactions.store','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('390','1','5','transactions.show','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('391','1','5','transactions.edit','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('392','1','5','transactions.destroy','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('393','1','5','student_payments.create','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('394','1','5','student_payments.index','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('395','1','5','student_payments.show','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('396','1','5','student_payments.edit','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('397','1','5','student_payments.destroy','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('433','1','1','invoices.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('434','1','1','invoices.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('435','1','1','invoices.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('436','1','1','student_payments.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('437','1','1','student_payments.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('438','1','1','student_payments.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('439','1','1','student_payments.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('440','1','1','student_payments.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('441','1','6','invoices.show','2021-03-07 09:12:02','2021-03-07 09:12:02');
INSERT INTO permissions VALUES('442','1','6','notices.index','2021-03-07 09:12:02','2021-03-07 09:12:02');
INSERT INTO permissions VALUES('1183','1','3','student_attendance.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1182','1','3','class_routines.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1181','1','3','class_routines.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1180','1','3','class_routines.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1178','1','3','student_groups.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1179','1','3','student_groups.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1177','1','3','student_groups.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1176','1','3','student_groups.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1175','1','3','student_groups.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1174','1','3','academic_years.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1173','1','3','academic_years.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1171','1','3','academic_years.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1172','1','3','academic_years.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1170','1','3','academic_years.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1169','1','3','assignments.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1168','1','3','assignments.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1167','1','3','assignments.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1166','1','3','assignments.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1165','1','3','assignments.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1164','1','3','syllabus.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1163','1','3','syllabus.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1162','1','3','syllabus.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1161','1','3','syllabus.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1160','1','3','syllabus.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1159','1','3','assignsubjects.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1158','1','3','assignsubjects.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1156','1','3','assignsubjects.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1157','1','3','assignsubjects.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1155','1','3','assignsubjects.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1154','1','3','subjects.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1153','1','3','subjects.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1152','1','3','subjects.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1151','1','3','subjects.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1150','1','3','subjects.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1149','1','3','sections.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1148','1','3','sections.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1147','1','3','sections.store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1146','1','3','sections.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1145','1','3','class.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1144','1','3','class.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1143','1','3','class.store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1142','1','3','class.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1141','1','3','students.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1140','1','3','students.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1139','1','3','students.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1138','1','3','students.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1137','1','3','students.promote','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1136','1','3','students.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1135','1','3','students.view_id_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1134','1','3','parents.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1133','1','3','parents.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1132','1','3','parents.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1131','1','3','parents.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1130','1','3','parents.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1129','1','3','teachers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1128','1','3','teachers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1127','1','3','teachers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1126','1','3','teachers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1125','1','3','teachers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1124','1','3','users.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1123','1','3','users.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1122','1','3','users.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1121','1','3','users.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1120','1','3','users.index','2021-04-05 22:27:30','2021-04-05 22:27:30');



DROP TABLE IF EXISTS picklists;

CREATE TABLE `picklists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO picklists VALUES('1','1','Religion','MUSLIM','2021-08-04 18:46:14','2021-08-04 18:46:14');
INSERT INTO picklists VALUES('2','1','Religion','NON MUSLIM','2021-08-04 18:46:55','2021-08-04 18:46:55');
INSERT INTO picklists VALUES('3','1','Designation','MANAGER','2021-08-04 18:47:32','2021-08-04 18:47:32');
INSERT INTO picklists VALUES('4','1','Designation','COOK','2021-08-04 18:47:57','2021-08-04 18:47:57');
INSERT INTO picklists VALUES('5','1','Designation','SWEEPER','2021-08-04 18:48:22','2021-08-04 18:48:22');
INSERT INTO picklists VALUES('6','1','Designation','QARI','2021-08-04 18:48:41','2021-08-04 18:48:41');



DROP TABLE IF EXISTS post_categories;

CREATE TABLE `post_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trans_category` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS post_contents;

CREATE TABLE `post_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_content` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'english',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS posts;

CREATE TABLE `posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int(11) NOT NULL,
  `author_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS school_invoices;

CREATE TABLE `school_invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `package_id` int(11) DEFAULT NULL,
  `invoice_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_period` int(11) DEFAULT 0,
  `invoice_date` date DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(8,2) DEFAULT 0.00,
  `paid` decimal(8,2) DEFAULT 0.00,
  `status` enum('Due','Paid') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS sections;

CREATE TABLE `sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) DEFAULT NULL,
  `section_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class_id` int(11) NOT NULL,
  `class_teacher_id` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `rank` int(11) DEFAULT NULL,
  `capacity` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO sections VALUES('1','1','101 Attach Bath','101','1','','1','','6','2021-06-17 00:47:43','2021-06-17 00:47:43');
INSERT INTO sections VALUES('3','1','102B COMMON','102','1','','1','','1','2021-06-17 00:48:36','2021-06-17 00:48:36');
INSERT INTO sections VALUES('4','1','102 ATTACH','102','1','','1','','4','2021-06-17 00:50:05','2021-09-29 19:26:53');
INSERT INTO sections VALUES('5','1','103A COMMON','103','1','','1','','3','2021-06-17 00:50:31','2021-06-17 00:50:31');
INSERT INTO sections VALUES('6','1','103B COMMON','103','1','','1','','2','2021-06-17 00:50:56','2021-06-17 00:51:35');
INSERT INTO sections VALUES('7','1','103C COMMON','','1','','1','','2','2021-06-17 00:51:22','2021-06-17 00:51:22');
INSERT INTO sections VALUES('8','1','104A COMMON','','1','','1','','5','2021-06-17 00:52:09','2021-06-17 00:52:09');
INSERT INTO sections VALUES('9','1','104B COMMON','','1','','1','','3','2021-06-17 00:52:25','2021-06-17 00:52:25');
INSERT INTO sections VALUES('10','1','105A COMMON','','2','','1','','3','2021-06-17 00:52:45','2022-04-28 17:37:49');
INSERT INTO sections VALUES('11','1','105B COMMON','105B','2','','1','','3','2021-06-17 00:53:04','2021-09-19 19:44:58');
INSERT INTO sections VALUES('12','1','106 ATTACH','106 ATTACH','1','','1','','4','2021-06-17 00:53:38','2022-03-02 17:23:13');
INSERT INTO sections VALUES('13','1','107 COMMON','107 COMMON','2','','1','','4','2021-06-17 00:54:36','2022-05-07 15:02:47');
INSERT INTO sections VALUES('14','1','108 COMMON','108 COMMON','2','','1','','4','2021-06-17 00:54:52','2021-11-02 19:53:50');
INSERT INTO sections VALUES('15','1','109 ATTACH','','1','','1','','4','2021-06-17 00:55:08','2021-06-17 00:55:08');
INSERT INTO sections VALUES('16','1','110 ATTACH','','1','','1','','4','2021-06-17 00:55:25','2021-06-17 00:55:25');
INSERT INTO sections VALUES('17','1','111 ATTACH','','1','','1','','4','2021-06-17 00:55:41','2021-06-17 00:56:19');
INSERT INTO sections VALUES('18','1','112A COMMON','','1','','1','','2','2021-06-17 00:57:16','2021-06-17 00:57:16');
INSERT INTO sections VALUES('19','1','112B COMMON','','1','','1','','2','2021-06-17 00:57:46','2021-06-17 00:57:46');
INSERT INTO sections VALUES('20','1','113 COMMON','','2','','1','','1','2021-06-17 00:58:37','2021-06-18 15:36:57');
INSERT INTO sections VALUES('21','1','114 COMMON','','2','','1','','2','2021-06-17 00:59:10','2021-06-17 00:59:10');
INSERT INTO sections VALUES('22','1','115 COMMON','115','2','','1','','3','2021-06-17 00:59:41','2021-06-19 13:22:55');
INSERT INTO sections VALUES('23','1','116 Common','','2','','1','','2','2021-06-17 00:59:53','2021-06-18 20:20:54');
INSERT INTO sections VALUES('24','1','117 COMMON','','2','','1','','3','2021-06-17 01:01:09','2021-06-17 01:01:09');
INSERT INTO sections VALUES('25','1','201 ATTACH','','3','','1','','4','2021-06-17 01:02:15','2021-06-17 01:02:15');
INSERT INTO sections VALUES('26','1','202 ATTACH','202 ATTACH','3','','1','','4','2021-06-17 01:02:51','2021-07-10 14:38:14');
INSERT INTO sections VALUES('27','1','203A COMMON','','3','','1','','3','2021-06-17 01:04:03','2021-06-17 01:04:03');
INSERT INTO sections VALUES('28','1','203B COMMON','203B COMMON','3','','1','','2','2021-06-17 01:04:37','2021-09-29 19:56:30');
INSERT INTO sections VALUES('29','1','204 ATTACH','','3','','1','','5','2021-06-17 01:04:55','2021-06-17 01:04:55');
INSERT INTO sections VALUES('30','1','205 ATTACH','205 ATTACH','3','','1','','5','2021-06-17 01:05:34','2022-02-03 21:05:15');
INSERT INTO sections VALUES('32','1','206A  COMMON','206','3','','1','','2','2021-06-17 01:06:46','2021-08-01 18:49:27');
INSERT INTO sections VALUES('33','1','206B  ATTACH','','3','','1','','4','2021-06-17 01:07:08','2021-06-17 01:07:08');
INSERT INTO sections VALUES('34','1','207 ATTACH','','3','','1','','3','2021-06-17 01:07:30','2021-06-17 01:07:30');
INSERT INTO sections VALUES('35','1','208 COMMON','','3','','1','','1','2021-06-17 01:08:24','2021-06-17 01:08:24');
INSERT INTO sections VALUES('36','1','209 COMMON','209','3','','1','','1','2021-06-17 01:08:43','2021-08-05 18:41:28');
INSERT INTO sections VALUES('37','1','210 COMMON','210 COMMON','3','','1','','2','2021-06-17 01:10:42','2022-04-02 10:47:16');
INSERT INTO sections VALUES('38','1','301 Common','','2','','1','','1','2021-06-17 01:11:17','2021-06-18 20:20:34');
INSERT INTO sections VALUES('39','1','302 COMMON','','2','','1','','1','2021-06-17 01:12:03','2021-06-17 01:14:41');
INSERT INTO sections VALUES('41','1','304 Common','','1','','1','','1','2021-06-17 01:13:03','2021-06-18 20:22:13');
INSERT INTO sections VALUES('42','1','305 EXTRA SEAT','305','4','','1','','1','2021-06-30 23:04:40','2021-06-30 23:09:24');
INSERT INTO sections VALUES('43','1','303 ATTACH','303 ATTACH','3','','1','','2','2021-10-07 17:36:37','2021-10-07 17:36:37');
INSERT INTO sections VALUES('44','1','211 COMMON','211 COMMON','3','','1','','5','2021-11-01 17:58:36','2022-03-31 15:46:22');



DROP TABLE IF EXISTS settings;

CREATE TABLE `settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `academic_year` int(11) DEFAULT NULL,
  `timezone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_symbol` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backend_direction` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active_theme` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `disabled_website` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `school_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `package_id` int(11) DEFAULT NULL,
  `site_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(70) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `home_page` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_text_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_border_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active_sidebar_background` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_backend_css` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `mail_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_host` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_port` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_username` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_password` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_encryption` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_footer` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TWILIO_SID` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TWILIO_TOKEN` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TWILIO_MOBILE` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_active` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_currency` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_active` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_currency` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_secret_key` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_publishable_key` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO settings VALUES('1','academic_year','1','Asia/Karachi','Rs.','1556705924_1.png','ltr','default','','','The Imperial Boys Hostel','2021-10-24','5','The Imperial Boys Hostel','03170000419','osama.mirza92@gmail.com','English','House#1 Street#19,  F 8/2  Islamabad,','','#ffffff','#000000','#dddddd','#e78421','','1','smtp','dgedgd','Comfort Cottage','osam','465','sfsdfs','123456','tls','Best Regards','','','','No','USD','test@gmail.com','No','USD','','','','2022-04-12 18:21:09');



DROP TABLE IF EXISTS site_navigation_items;

CREATE TABLE `site_navigation_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_id` int(11) NOT NULL,
  `menu_label` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_id` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menu_order` int(11) NOT NULL DEFAULT 100,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS site_navigations;

CREATE TABLE `site_navigations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS sms_logs;

CREATE TABLE `sms_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `receiver` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS staff_attendances;

CREATE TABLE `staff_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `attendance` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO staff_attendances VALUES('1','1','287','2021-08-04','1','2021-08-04 19:29:01','2021-08-04 19:29:01');
INSERT INTO staff_attendances VALUES('2','1','286','2021-08-04','1','2021-08-04 19:29:01','2021-08-04 19:29:01');
INSERT INTO staff_attendances VALUES('3','1','285','2021-08-04','4','2021-08-04 19:29:01','2021-08-04 19:30:00');
INSERT INTO staff_attendances VALUES('4','1','284','2021-08-04','1','2021-08-04 19:29:01','2021-08-04 19:29:01');
INSERT INTO staff_attendances VALUES('5','1','283','2021-08-04','1','2021-08-04 19:29:01','2021-08-04 19:29:01');
INSERT INTO staff_attendances VALUES('6','1','282','2021-08-04','1','2021-08-04 19:29:01','2021-08-04 19:29:01');
INSERT INTO staff_attendances VALUES('7','1','281','2021-08-04','1','2021-08-04 19:29:01','2021-08-04 19:29:01');
INSERT INTO staff_attendances VALUES('8','1','103','2021-08-04','0','2021-08-04 19:29:01','2021-08-04 19:29:01');
INSERT INTO staff_attendances VALUES('9','1','287','2021-08-03','1','2021-08-04 19:29:30','2021-08-04 19:29:30');
INSERT INTO staff_attendances VALUES('10','1','286','2021-08-03','1','2021-08-04 19:29:30','2021-08-04 19:29:30');
INSERT INTO staff_attendances VALUES('11','1','285','2021-08-03','4','2021-08-04 19:29:30','2021-08-04 19:30:23');
INSERT INTO staff_attendances VALUES('12','1','284','2021-08-03','1','2021-08-04 19:29:30','2021-08-04 19:29:30');
INSERT INTO staff_attendances VALUES('13','1','283','2021-08-03','1','2021-08-04 19:29:30','2021-08-04 19:29:30');
INSERT INTO staff_attendances VALUES('14','1','282','2021-08-03','1','2021-08-04 19:29:30','2021-08-04 19:29:30');
INSERT INTO staff_attendances VALUES('15','1','281','2021-08-03','1','2021-08-04 19:29:30','2021-08-04 19:29:30');
INSERT INTO staff_attendances VALUES('16','1','103','2021-08-03','0','2021-08-04 19:29:30','2021-08-04 19:29:30');
INSERT INTO staff_attendances VALUES('17','1','287','2021-08-02','1','2021-08-04 19:30:57','2021-08-04 19:30:57');
INSERT INTO staff_attendances VALUES('18','1','286','2021-08-02','1','2021-08-04 19:30:58','2021-08-04 19:30:58');
INSERT INTO staff_attendances VALUES('19','1','285','2021-08-02','1','2021-08-04 19:30:58','2021-08-04 19:30:58');
INSERT INTO staff_attendances VALUES('20','1','284','2021-08-02','1','2021-08-04 19:30:58','2021-08-04 19:30:58');
INSERT INTO staff_attendances VALUES('21','1','283','2021-08-02','1','2021-08-04 19:30:58','2021-08-04 19:30:58');
INSERT INTO staff_attendances VALUES('22','1','282','2021-08-02','1','2021-08-04 19:30:58','2021-08-04 19:30:58');
INSERT INTO staff_attendances VALUES('23','1','281','2021-08-02','1','2021-08-04 19:30:58','2021-08-04 19:30:58');
INSERT INTO staff_attendances VALUES('24','1','103','2021-08-02','0','2021-08-04 19:30:58','2021-08-04 19:30:58');
INSERT INTO staff_attendances VALUES('25','1','287','2021-08-01','1','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('26','1','286','2021-08-01','1','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('27','1','285','2021-08-01','1','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('28','1','284','2021-08-01','1','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('29','1','283','2021-08-01','1','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('30','1','282','2021-08-01','1','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('31','1','281','2021-08-01','1','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('32','1','103','2021-08-01','0','2021-08-04 19:38:52','2021-08-04 19:38:52');
INSERT INTO staff_attendances VALUES('33','1','287','2022-04-05','1','2022-04-05 09:29:21','2022-04-05 09:29:21');
INSERT INTO staff_attendances VALUES('34','1','286','2022-04-05','3','2022-04-05 09:29:21','2022-04-05 09:29:21');
INSERT INTO staff_attendances VALUES('35','1','285','2022-04-05','1','2022-04-05 09:29:21','2022-04-05 09:29:21');
INSERT INTO staff_attendances VALUES('36','1','284','2022-04-05','2','2022-04-05 09:29:21','2022-04-05 09:29:21');
INSERT INTO staff_attendances VALUES('37','1','283','2022-04-05','1','2022-04-05 09:29:21','2022-04-05 09:29:21');
INSERT INTO staff_attendances VALUES('38','1','282','2022-04-05','1','2022-04-05 09:29:21','2022-04-05 09:29:21');
INSERT INTO staff_attendances VALUES('39','1','281','2022-04-05','1','2022-04-05 09:29:21','2022-04-05 09:29:21');
INSERT INTO staff_attendances VALUES('40','1','287','2022-05-01','1','2022-05-06 15:39:27','2022-05-06 15:39:27');
INSERT INTO staff_attendances VALUES('41','1','286','2022-05-01','1','2022-05-06 15:39:27','2022-05-06 15:39:27');
INSERT INTO staff_attendances VALUES('42','1','285','2022-05-01','2','2022-05-06 15:39:27','2022-05-06 15:39:27');
INSERT INTO staff_attendances VALUES('43','1','284','2022-05-01','2','2022-05-06 15:39:27','2022-05-06 15:39:27');
INSERT INTO staff_attendances VALUES('44','1','283','2022-05-01','2','2022-05-06 15:39:27','2022-05-06 15:39:27');
INSERT INTO staff_attendances VALUES('45','1','282','2022-05-01','1','2022-05-06 15:39:27','2022-05-06 15:39:27');
INSERT INTO staff_attendances VALUES('46','1','281','2022-05-01','1','2022-05-06 15:39:27','2022-05-06 15:39:27');
INSERT INTO staff_attendances VALUES('47','1','287','2022-05-07','1','2022-05-07 15:25:37','2022-05-07 15:25:37');
INSERT INTO staff_attendances VALUES('48','1','286','2022-05-07','1','2022-05-07 15:25:37','2022-05-07 15:25:37');
INSERT INTO staff_attendances VALUES('49','1','285','2022-05-07','2','2022-05-07 15:25:37','2022-05-07 15:25:37');
INSERT INTO staff_attendances VALUES('50','1','284','2022-05-07','2','2022-05-07 15:25:37','2022-05-07 15:25:37');
INSERT INTO staff_attendances VALUES('51','1','283','2022-05-07','2','2022-05-07 15:25:37','2022-05-07 15:25:37');
INSERT INTO staff_attendances VALUES('52','1','282','2022-05-07','1','2022-05-07 15:25:37','2022-05-07 15:25:37');
INSERT INTO staff_attendances VALUES('53','1','281','2022-05-07','1','2022-05-07 15:25:37','2022-05-07 15:25:37');



DROP TABLE IF EXISTS student_attendances;

CREATE TABLE `student_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `attendance` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS student_fee_assigns;

CREATE TABLE `student_fee_assigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `fee_id` int(11) NOT NULL,
  `amount` double(8,2) NOT NULL DEFAULT 0.00,
  `discount` double(8,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=767 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_fee_assigns VALUES('2','1','1','1','15000','0','2021-06-17 22:45:43','2021-06-17 22:45:43');
INSERT INTO student_fee_assigns VALUES('4','1','3','1','14500','0','2021-06-17 22:59:40','2021-06-17 22:59:40');
INSERT INTO student_fee_assigns VALUES('643','1','2','1','17000','0','2022-02-02 22:08:07','2022-02-02 22:08:07');
INSERT INTO student_fee_assigns VALUES('439','1','4','1','10000','0','2021-10-01 20:23:53','2021-10-01 20:23:53');
INSERT INTO student_fee_assigns VALUES('727','1','5','1','16000','0','2022-05-08 15:25:33','2022-05-08 15:25:33');
INSERT INTO student_fee_assigns VALUES('726','1','6','1','16000','0','2022-05-08 15:25:00','2022-05-08 15:25:00');
INSERT INTO student_fee_assigns VALUES('9','1','7','1','16500','0','2021-06-18 11:38:54','2021-06-18 11:38:54');
INSERT INTO student_fee_assigns VALUES('10','1','8','1','16500','0','2021-06-18 11:42:46','2021-06-18 11:42:46');
INSERT INTO student_fee_assigns VALUES('642','1','9','1','24000','0','2022-02-02 22:07:10','2022-02-02 22:07:10');
INSERT INTO student_fee_assigns VALUES('14','1','10','1','21000','0','2021-06-18 15:27:36','2021-06-18 15:27:36');
INSERT INTO student_fee_assigns VALUES('15','1','11','1','21000','0','2021-06-18 15:34:56','2021-06-18 15:34:56');
INSERT INTO student_fee_assigns VALUES('595','1','12','1','17500','0','2022-02-02 20:46:38','2022-02-02 20:46:38');
INSERT INTO student_fee_assigns VALUES('158','1','13','1','13000','0','2021-08-03 19:04:31','2021-08-03 19:04:31');
INSERT INTO student_fee_assigns VALUES('583','1','14','1','32000','0','2022-02-02 20:16:56','2022-02-02 20:16:56');
INSERT INTO student_fee_assigns VALUES('641','1','15','1','18000','0','2022-02-02 22:05:58','2022-02-02 22:05:58');
INSERT INTO student_fee_assigns VALUES('581','1','16','1','20000','0','2022-02-02 20:14:42','2022-02-02 20:14:42');
INSERT INTO student_fee_assigns VALUES('562','1','17','1','17000','0','2022-02-01 19:58:31','2022-02-01 19:58:31');
INSERT INTO student_fee_assigns VALUES('587','1','18','1','17000','0','2022-02-02 20:20:21','2022-02-02 20:20:21');
INSERT INTO student_fee_assigns VALUES('753','1','19','1','17000','0','2022-06-13 14:52:04','2022-06-13 14:52:04');
INSERT INTO student_fee_assigns VALUES('585','1','20','1','17000','0','2022-02-02 20:18:23','2022-02-02 20:18:23');
INSERT INTO student_fee_assigns VALUES('629','1','21','1','14000','0','2022-02-02 21:44:34','2022-02-02 21:44:34');
INSERT INTO student_fee_assigns VALUES('645','1','22','1','19000','0','2022-02-02 22:14:36','2022-02-02 22:14:36');
INSERT INTO student_fee_assigns VALUES('59','1','23','1','12500','0','2021-06-18 19:06:02','2021-06-18 19:06:02');
INSERT INTO student_fee_assigns VALUES('58','1','24','1','12500','0','2021-06-18 19:04:45','2021-06-18 19:04:45');
INSERT INTO student_fee_assigns VALUES('29','1','25','1','13000','0','2021-06-18 17:24:01','2021-06-18 17:24:01');
INSERT INTO student_fee_assigns VALUES('30','1','26','1','13000','0','2021-06-18 17:25:15','2021-06-18 17:25:15');
INSERT INTO student_fee_assigns VALUES('31','1','27','1','13000','0','2021-06-18 17:26:25','2021-06-18 17:26:25');
INSERT INTO student_fee_assigns VALUES('597','1','28','1','20000','0','2022-02-02 20:49:14','2022-02-02 20:49:14');
INSERT INTO student_fee_assigns VALUES('599','1','29','1','20000','0','2022-02-02 20:50:49','2022-02-02 20:50:49');
INSERT INTO student_fee_assigns VALUES('719','1','30','1','16500','0','2022-04-28 18:47:33','2022-04-28 18:47:33');
INSERT INTO student_fee_assigns VALUES('627','1','31','1','14000','0','2022-02-02 21:43:15','2022-02-02 21:43:15');
INSERT INTO student_fee_assigns VALUES('626','1','32','1','14000','0','2022-02-02 21:42:44','2022-02-02 21:42:44');
INSERT INTO student_fee_assigns VALUES('199','1','33','1','14499','0','2021-09-15 16:54:43','2021-09-15 16:54:43');
INSERT INTO student_fee_assigns VALUES('634','1','34','1','15500','0','2022-02-02 21:49:32','2022-02-02 21:49:32');
INSERT INTO student_fee_assigns VALUES('591','1','35','1','15500','0','2022-02-02 20:27:31','2022-02-02 20:27:31');
INSERT INTO student_fee_assigns VALUES('633','1','36','1','15500','0','2022-02-02 21:48:58','2022-02-02 21:48:58');
INSERT INTO student_fee_assigns VALUES('623','1','37','1','15500','0','2022-02-02 21:39:03','2022-02-02 21:39:03');
INSERT INTO student_fee_assigns VALUES('42','1','38','1','12000','0','2021-06-18 17:46:10','2021-06-18 17:46:10');
INSERT INTO student_fee_assigns VALUES('43','1','39','1','12000','0','2021-06-18 17:48:58','2021-06-18 17:48:58');
INSERT INTO student_fee_assigns VALUES('44','1','40','1','12000','0','2021-06-18 17:50:32','2021-06-18 17:50:32');
INSERT INTO student_fee_assigns VALUES('625','1','41','1','16000','0','2022-02-02 21:41:36','2022-02-02 21:41:36');
INSERT INTO student_fee_assigns VALUES('636','1','42','1','16000','0','2022-02-02 21:55:31','2022-02-02 21:55:31');
INSERT INTO student_fee_assigns VALUES('512','1','43','1','16000','0','2021-10-11 16:59:26','2021-10-11 16:59:26');
INSERT INTO student_fee_assigns VALUES('601','1','44','1','17000','0','2022-02-02 20:57:15','2022-02-02 20:57:15');
INSERT INTO student_fee_assigns VALUES('603','1','45','1','17000','0','2022-02-02 20:59:26','2022-02-02 20:59:26');
INSERT INTO student_fee_assigns VALUES('602','1','46','1','16000','0','2022-02-02 20:58:21','2022-02-02 20:58:21');
INSERT INTO student_fee_assigns VALUES('51','1','47','1','16000','0','2021-06-18 18:34:51','2021-06-18 18:34:51');
INSERT INTO student_fee_assigns VALUES('654','1','48','1','17500','0','2022-02-03 20:57:08','2022-02-03 20:57:08');
INSERT INTO student_fee_assigns VALUES('644','1','49','1','14000','0','2022-02-02 22:10:59','2022-02-02 22:10:59');
INSERT INTO student_fee_assigns VALUES('622','1','50','1','17500','0','2022-02-02 21:38:04','2022-02-02 21:38:04');
INSERT INTO student_fee_assigns VALUES('620','1','51','1','17500','0','2022-02-02 21:36:33','2022-02-02 21:36:33');
INSERT INTO student_fee_assigns VALUES('423','1','52','1','17500','0','2021-10-01 19:57:46','2021-10-01 19:57:46');
INSERT INTO student_fee_assigns VALUES('638','1','53','1','17500','0','2022-02-02 22:01:56','2022-02-02 22:01:56');
INSERT INTO student_fee_assigns VALUES('639','1','54','1','17000','0','2022-02-02 22:03:59','2022-02-02 22:03:59');
INSERT INTO student_fee_assigns VALUES('752','1','55','1','17000','0','2022-06-13 14:51:28','2022-06-13 14:51:28');
INSERT INTO student_fee_assigns VALUES('655','1','56','1','17000','0','2022-02-03 21:00:20','2022-02-03 21:00:20');
INSERT INTO student_fee_assigns VALUES('611','1','57','1','17000','0','2022-02-02 21:23:08','2022-02-02 21:23:08');
INSERT INTO student_fee_assigns VALUES('67','1','58','1','16500','0','2021-06-18 19:27:08','2021-06-18 19:27:08');
INSERT INTO student_fee_assigns VALUES('345','1','59','1','15000','0','2021-09-28 16:56:12','2021-09-28 16:56:12');
INSERT INTO student_fee_assigns VALUES('686','1','60','1','13000','0','2022-03-02 17:30:13','2022-03-02 17:30:13');
INSERT INTO student_fee_assigns VALUES('685','1','61','1','13000','0','2022-03-02 17:29:17','2022-03-02 17:29:17');
INSERT INTO student_fee_assigns VALUES('684','1','62','1','13000','0','2022-03-02 17:28:39','2022-03-02 17:28:39');
INSERT INTO student_fee_assigns VALUES('74','1','63','1','21000','0','2021-06-18 20:10:22','2021-06-18 20:10:22');
INSERT INTO student_fee_assigns VALUES('614','1','64','1','22000','0','2022-02-02 21:26:47','2022-02-02 21:26:47');
INSERT INTO student_fee_assigns VALUES('77','1','65','1','16000','0','2021-06-18 20:39:44','2021-06-18 20:39:44');
INSERT INTO student_fee_assigns VALUES('78','1','66','1','16500','0','2021-06-18 20:41:24','2021-06-18 20:41:24');
INSERT INTO student_fee_assigns VALUES('79','1','67','1','16000','0','2021-06-18 20:43:07','2021-06-18 20:43:07');
INSERT INTO student_fee_assigns VALUES('690','1','68','1','17500','0','2022-03-02 21:31:35','2022-03-02 21:31:35');
INSERT INTO student_fee_assigns VALUES('689','1','69','1','17500','0','2022-03-02 21:31:04','2022-03-02 21:31:04');
INSERT INTO student_fee_assigns VALUES('83','1','70','1','16000','0','2021-06-18 21:02:34','2021-06-18 21:02:34');
INSERT INTO student_fee_assigns VALUES('555','1','71','1','17500','0','2022-01-12 19:27:11','2022-01-12 19:27:11');
INSERT INTO student_fee_assigns VALUES('455','1','72','1','17500','0','2021-10-01 20:48:57','2021-10-01 20:48:57');
INSERT INTO student_fee_assigns VALUES('273','1','73','1','16500','0','2021-09-18 19:54:06','2021-09-18 19:54:06');
INSERT INTO student_fee_assigns VALUES('711','1','74','1','17000','0','2022-04-26 17:21:03','2022-04-26 17:21:03');
INSERT INTO student_fee_assigns VALUES('90','1','75','1','13000','0','2021-06-18 21:15:39','2021-06-18 21:15:39');
INSERT INTO student_fee_assigns VALUES('720','1','76','1','15000','0','2022-05-07 15:10:16','2022-05-07 15:10:16');
INSERT INTO student_fee_assigns VALUES('600','1','77','1','14000','0','2022-02-02 20:56:03','2022-02-02 20:56:03');
INSERT INTO student_fee_assigns VALUES('749','1','78','1','17500','0','2022-06-13 14:49:12','2022-06-13 14:49:12');
INSERT INTO student_fee_assigns VALUES('748','1','79','1','17500','0','2022-06-13 14:48:17','2022-06-13 14:48:17');
INSERT INTO student_fee_assigns VALUES('657','1','80','1','17000','0','2022-02-03 21:01:36','2022-02-03 21:01:36');
INSERT INTO student_fee_assigns VALUES('688','1','81','1','17500','0','2022-03-02 17:40:16','2022-03-02 17:40:16');
INSERT INTO student_fee_assigns VALUES('687','1','82','1','17500','0','2022-03-02 17:39:42','2022-03-02 17:39:42');
INSERT INTO student_fee_assigns VALUES('682','1','83','1','17500','0','2022-03-02 17:21:45','2022-03-02 17:21:45');
INSERT INTO student_fee_assigns VALUES('99','1','84','1','14000','0','2021-06-18 21:35:43','2021-06-18 21:35:43');
INSERT INTO student_fee_assigns VALUES('100','1','85','1','14000','0','2021-06-18 21:37:37','2021-06-18 21:37:37');
INSERT INTO student_fee_assigns VALUES('101','1','86','1','14000','0','2021-06-18 21:39:05','2021-06-18 21:39:05');
INSERT INTO student_fee_assigns VALUES('102','1','87','1','14000','0','2021-06-18 21:40:23','2021-06-18 21:40:23');
INSERT INTO student_fee_assigns VALUES('443','1','88','1','15000','0','2021-10-01 20:30:29','2021-10-01 20:30:29');
INSERT INTO student_fee_assigns VALUES('104','1','89','1','14500','0','2021-06-18 21:43:49','2021-06-18 21:43:49');
INSERT INTO student_fee_assigns VALUES('105','1','90','1','14500','0','2021-06-18 21:45:06','2021-06-18 21:45:06');
INSERT INTO student_fee_assigns VALUES('106','1','91','1','16000','0','2021-06-18 21:48:35','2021-06-18 21:48:35');
INSERT INTO student_fee_assigns VALUES('107','1','92','1','13000','0','2021-06-18 21:51:19','2021-06-18 21:51:19');
INSERT INTO student_fee_assigns VALUES('438','1','93','1','14000','0','2021-10-01 20:22:46','2021-10-01 20:22:46');
INSERT INTO student_fee_assigns VALUES('109','1','94','1','13000','0','2021-06-18 21:53:56','2021-06-18 21:53:56');
INSERT INTO student_fee_assigns VALUES('110','1','95','1','13000','0','2021-06-18 21:55:34','2021-06-18 21:55:34');
INSERT INTO student_fee_assigns VALUES('431','1','96','1','16500','0','2021-10-01 20:05:59','2021-10-01 20:05:59');
INSERT INTO student_fee_assigns VALUES('550','1','97','1','18000','0','2021-12-06 17:25:22','2021-12-06 17:25:22');
INSERT INTO student_fee_assigns VALUES('429','1','98','1','18000','0','2021-10-01 20:04:44','2021-10-01 20:04:44');
INSERT INTO student_fee_assigns VALUES('709','1','99','1','17500','0','2022-04-04 14:29:48','2022-04-04 14:29:48');
INSERT INTO student_fee_assigns VALUES('715','1','100','1','19000','0','2022-04-28 16:49:30','2022-04-28 16:49:30');
INSERT INTO student_fee_assigns VALUES('424','1','101','1','17000','0','2021-10-01 19:58:51','2021-10-01 19:58:51');
INSERT INTO student_fee_assigns VALUES('420','1','103','1','18000','0','2021-10-01 18:52:36','2021-10-01 18:52:36');
INSERT INTO student_fee_assigns VALUES('615','1','104','1','18000','0','2022-02-02 21:29:17','2022-02-02 21:29:17');
INSERT INTO student_fee_assigns VALUES('123','1','105','1','16000','0','2021-06-19 13:50:05','2021-06-19 13:50:05');
INSERT INTO student_fee_assigns VALUES('124','1','106','1','16500','0','2021-06-19 13:54:18','2021-06-19 13:54:18');
INSERT INTO student_fee_assigns VALUES('413','1','107','1','15000','0','2021-10-01 18:42:14','2021-10-01 18:42:14');
INSERT INTO student_fee_assigns VALUES('553','1','108','1','15000','0','2022-01-03 20:02:14','2022-01-03 20:02:14');
INSERT INTO student_fee_assigns VALUES('650','1','109','1','15500','0','2022-02-03 18:02:50','2022-02-03 18:02:50');
INSERT INTO student_fee_assigns VALUES('411','1','110','1','15000','0','2021-10-01 18:23:14','2021-10-01 18:23:14');
INSERT INTO student_fee_assigns VALUES('416','1','111','1','14000','0','2021-10-01 18:45:55','2021-10-01 18:45:55');
INSERT INTO student_fee_assigns VALUES('417','1','112','1','14000','0','2021-10-01 18:46:47','2021-10-01 18:46:47');
INSERT INTO student_fee_assigns VALUES('425','1','102','1','17000','0','2021-10-01 19:59:56','2021-10-01 19:59:56');
INSERT INTO student_fee_assigns VALUES('679','1','113','1','17500','0','2022-03-02 17:13:23','2022-03-02 17:13:23');
INSERT INTO student_fee_assigns VALUES('452','1','121','1','17000','0','2021-10-01 20:46:50','2021-10-01 20:46:50');
INSERT INTO student_fee_assigns VALUES('750','1','114','1','19000','0','2022-06-13 14:49:44','2022-06-13 14:49:44');
INSERT INTO student_fee_assigns VALUES('441','1','115','1','15500','0','2021-10-01 20:25:42','2021-10-01 20:25:42');
INSERT INTO student_fee_assigns VALUES('763','1','116','1','14999','0','2022-06-23 16:55:00','2022-06-23 16:55:00');
INSERT INTO student_fee_assigns VALUES('151','1','117','1','16500','0','2021-07-03 19:35:49','2021-07-03 19:35:49');
INSERT INTO student_fee_assigns VALUES('152','1','118','1','16500','0','2021-07-03 19:40:24','2021-07-03 19:40:24');
INSERT INTO student_fee_assigns VALUES('155','1','119','1','13000','0','2021-07-10 14:30:14','2021-07-10 14:30:14');
INSERT INTO student_fee_assigns VALUES('589','1','123','1','24000','0','2022-02-02 20:22:34','2022-02-02 20:22:34');
INSERT INTO student_fee_assigns VALUES('671','1','122','1','14000','0','2022-02-25 17:32:05','2022-02-25 17:32:05');
INSERT INTO student_fee_assigns VALUES('588','1','124','1','17500','0','2022-02-02 20:21:41','2022-02-02 20:21:41');
INSERT INTO student_fee_assigns VALUES('576','1','137','1','21000','0','2022-02-02 20:08:31','2022-02-02 20:08:31');
INSERT INTO student_fee_assigns VALUES('586','1','125','1','17000','0','2022-02-02 20:19:34','2022-02-02 20:19:34');
INSERT INTO student_fee_assigns VALUES('457','1','127','1','17000','0','2021-10-01 20:55:13','2021-10-01 20:55:13');
INSERT INTO student_fee_assigns VALUES('754','1','126','1','17000','0','2022-06-13 14:52:52','2022-06-13 14:52:52');
INSERT INTO student_fee_assigns VALUES('560','1','138','1','17000','0','2022-02-01 19:55:19','2022-02-01 19:55:19');
INSERT INTO student_fee_assigns VALUES('414','1','128','1','15000','0','2021-10-01 18:43:58','2021-10-01 18:43:58');
INSERT INTO student_fee_assigns VALUES('491','1','129','1','22000','0','2021-10-05 19:22:58','2021-10-05 19:22:58');
INSERT INTO student_fee_assigns VALUES('432','1','130','1','15000','0','2021-10-01 20:07:15','2021-10-01 20:07:15');
INSERT INTO student_fee_assigns VALUES('578','1','131','1','19500','0','2022-02-02 20:13:01','2022-02-02 20:13:01');
INSERT INTO student_fee_assigns VALUES('734','1','132','1','17000','0','2022-05-15 14:31:23','2022-05-15 14:31:23');
INSERT INTO student_fee_assigns VALUES('447','1','133','1','17000','0','2021-10-01 20:35:37','2021-10-01 20:35:37');
INSERT INTO student_fee_assigns VALUES('575','1','134','1','15000','0','2022-02-02 20:02:49','2022-02-02 20:02:49');
INSERT INTO student_fee_assigns VALUES('445','1','135','1','17000','0','2021-10-01 20:34:08','2021-10-01 20:34:08');
INSERT INTO student_fee_assigns VALUES('381','1','136','1','15000','0','2021-09-28 18:26:59','2021-09-28 18:26:59');
INSERT INTO student_fee_assigns VALUES('755','1','139','1','22000','0','2022-06-13 14:53:58','2022-06-13 14:53:58');
INSERT INTO student_fee_assigns VALUES('404','1','140','1','17500','0','2021-09-29 19:55:25','2021-09-29 19:55:25');
INSERT INTO student_fee_assigns VALUES('525','1','141','1','17000','0','2021-11-01 20:00:41','2021-11-01 20:00:41');
INSERT INTO student_fee_assigns VALUES('472','1','142','1','17500','0','2021-10-03 20:12:35','2021-10-03 20:12:35');
INSERT INTO student_fee_assigns VALUES('396','1','143','1','18000','0','2021-09-29 18:52:11','2021-09-29 18:52:11');
INSERT INTO student_fee_assigns VALUES('574','1','144','1','17500','0','2022-02-02 20:00:18','2022-02-02 20:00:18');
INSERT INTO student_fee_assigns VALUES('505','1','145','1','17500','0','2021-10-08 16:11:00','2021-10-08 16:11:00');
INSERT INTO student_fee_assigns VALUES('563','1','146','1','17000','0','2022-02-01 19:59:57','2022-02-01 19:59:57');
INSERT INTO student_fee_assigns VALUES('486','1','148','1','21000','0','2021-10-05 18:20:17','2021-10-05 18:20:17');
INSERT INTO student_fee_assigns VALUES('728','1','149','1','16000','0','2022-05-08 15:26:17','2022-05-08 15:26:17');
INSERT INTO student_fee_assigns VALUES('513','1','150','1','17000','0','2021-10-11 17:31:42','2021-10-11 17:31:42');
INSERT INTO student_fee_assigns VALUES('475','1','151','1','15500','0','2021-10-03 20:18:28','2021-10-03 20:18:28');
INSERT INTO student_fee_assigns VALUES('406','1','152','1','18000','0','2021-09-30 20:12:16','2021-09-30 20:12:16');
INSERT INTO student_fee_assigns VALUES('672','1','153','1','17000','0','2022-02-25 17:43:37','2022-02-25 17:43:37');
INSERT INTO student_fee_assigns VALUES('408','1','154','1','17000','0','2021-10-01 18:04:41','2021-10-01 18:04:41');
INSERT INTO student_fee_assigns VALUES('484','1','147','1','17000','0','2021-10-05 18:09:22','2021-10-05 18:09:22');
INSERT INTO student_fee_assigns VALUES('510','1','155','1','22000','0','2021-10-10 21:20:48','2021-10-10 21:20:48');
INSERT INTO student_fee_assigns VALUES('546','1','156','1','14500','0','2021-11-11 18:40:05','2021-11-11 18:40:05');
INSERT INTO student_fee_assigns VALUES('572','1','158','1','22000','0','2022-02-02 19:54:12','2022-02-02 19:54:12');
INSERT INTO student_fee_assigns VALUES('647','1','159','1','17000','0','2022-02-02 22:23:11','2022-02-02 22:23:11');
INSERT INTO student_fee_assigns VALUES('592','1','120','1','15500','0','2022-02-02 20:33:39','2022-02-02 20:33:39');
INSERT INTO student_fee_assigns VALUES('570','1','160','1','16000','0','2022-02-02 19:50:25','2022-02-02 19:50:25');
INSERT INTO student_fee_assigns VALUES('722','1','161','1','16000','0','2022-05-07 15:21:26','2022-05-07 15:21:26');
INSERT INTO student_fee_assigns VALUES('723','1','162','1','16000','0','2022-05-07 15:22:29','2022-05-07 15:22:29');
INSERT INTO student_fee_assigns VALUES('721','1','163','1','16000','0','2022-05-07 15:20:30','2022-05-07 15:20:30');
INSERT INTO student_fee_assigns VALUES('653','1','157','1','15500','0','2022-02-03 20:56:03','2022-02-03 20:56:03');
INSERT INTO student_fee_assigns VALUES('747','1','164','1','17500','0','2022-06-13 14:47:20','2022-06-13 14:47:20');
INSERT INTO student_fee_assigns VALUES('558','1','165','1','15500','0','2022-02-01 19:52:12','2022-02-01 19:52:12');
INSERT INTO student_fee_assigns VALUES('665','1','166','1','16500','0','2022-02-13 18:14:52','2022-02-13 18:14:52');
INSERT INTO student_fee_assigns VALUES('662','1','167','1','15000','0','2022-02-07 20:19:01','2022-02-07 20:19:01');
INSERT INTO student_fee_assigns VALUES('673','1','168','1','17000','0','2022-03-02 17:02:07','2022-03-02 17:02:07');
INSERT INTO student_fee_assigns VALUES('669','1','169','1','17000','0','2022-02-13 18:48:10','2022-02-13 18:48:10');
INSERT INTO student_fee_assigns VALUES('691','1','170','1','15000','0','2022-03-05 21:08:32','2022-03-05 21:08:32');
INSERT INTO student_fee_assigns VALUES('751','1','171','1','19000','0','2022-06-13 14:50:47','2022-06-13 14:50:47');
INSERT INTO student_fee_assigns VALUES('705','1','172','1','15000','0','2022-04-02 10:43:47','2022-04-02 10:43:47');
INSERT INTO student_fee_assigns VALUES('699','1','173','1','19000','0','2022-03-09 20:59:13','2022-03-09 20:59:13');
INSERT INTO student_fee_assigns VALUES('710','1','174','1','16500','0','2022-04-20 15:45:27','2022-04-20 15:45:27');
INSERT INTO student_fee_assigns VALUES('701','1','175','1','15000','0','2022-03-09 22:22:51','2022-03-09 22:22:51');
INSERT INTO student_fee_assigns VALUES('702','1','176','1','15500','0','2022-03-10 19:56:50','2022-03-10 19:56:50');
INSERT INTO student_fee_assigns VALUES('703','1','177','1','15500','0','2022-03-11 19:08:44','2022-03-11 19:08:44');
INSERT INTO student_fee_assigns VALUES('725','1','178','1','16000','0','2022-05-07 15:24:41','2022-05-07 15:24:41');
INSERT INTO student_fee_assigns VALUES('706','1','179','1','19000','0','2022-04-02 10:55:13','2022-04-02 10:55:13');
INSERT INTO student_fee_assigns VALUES('707','1','180','1','19000','0','2022-04-02 10:59:46','2022-04-02 10:59:46');
INSERT INTO student_fee_assigns VALUES('708','1','181','1','16000','0','2022-04-02 11:04:40','2022-04-02 11:04:40');
INSERT INTO student_fee_assigns VALUES('765','1','182','1','17500','0','2022-07-05 13:53:45','2022-07-05 13:53:45');
INSERT INTO student_fee_assigns VALUES('729','1','183','1','19000','0','2022-05-08 16:47:46','2022-05-08 16:47:46');
INSERT INTO student_fee_assigns VALUES('759','1','184','1','16500','0','2022-06-22 14:52:06','2022-06-22 14:52:06');
INSERT INTO student_fee_assigns VALUES('730','1','185','1','19000','0','2022-05-08 17:40:23','2022-05-08 17:40:23');
INSERT INTO student_fee_assigns VALUES('736','1','186','1','17500','0','2022-05-31 13:47:35','2022-05-31 13:47:35');
INSERT INTO student_fee_assigns VALUES('756','1','187','1','16500','0','2022-06-22 14:47:03','2022-06-22 14:47:03');
INSERT INTO student_fee_assigns VALUES('760','1','188','1','17000','0','2022-06-22 14:53:25','2022-06-22 14:53:25');
INSERT INTO student_fee_assigns VALUES('766','1','189','1','16500','0','2022-07-05 14:13:50','2022-07-05 14:13:50');
INSERT INTO student_fee_assigns VALUES('758','1','190','1','16500','0','2022-06-22 14:49:24','2022-06-22 14:49:24');
INSERT INTO student_fee_assigns VALUES('761','1','191','1','17000','0','2022-06-22 14:58:45','2022-06-22 14:58:45');
INSERT INTO student_fee_assigns VALUES('762','1','192','1','17500','0','2022-06-22 15:01:05','2022-06-22 15:01:05');



DROP TABLE IF EXISTS student_groups;

CREATE TABLE `student_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `group_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_groups VALUES('1','1','JOBIAN','2021-06-17 02:03:45','2021-06-17 02:03:45');
INSERT INTO student_groups VALUES('2','1','STUDENT','2021-06-17 02:04:04','2021-06-17 02:04:04');
INSERT INTO student_groups VALUES('3','1','DEFAULT','2021-06-17 02:04:21','2021-08-04 18:44:32');



DROP TABLE IF EXISTS student_payments;

CREATE TABLE `student_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1846 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_payments VALUES('1','1','143','2021-06-10','14000.00','','2021-06-20 20:50:45','2021-06-20 20:50:45');
INSERT INTO student_payments VALUES('2','1','1','2021-06-10','6000.00','','2021-06-20 20:55:45','2021-06-20 20:55:45');
INSERT INTO student_payments VALUES('3','1','144','2021-06-10','10000.00','','2021-06-20 21:07:42','2021-06-20 21:07:42');
INSERT INTO student_payments VALUES('4','1','145','2021-06-10','13000.00','','2021-06-20 21:09:28','2021-06-20 21:09:28');
INSERT INTO student_payments VALUES('5','1','2','2021-06-10','5000.00','','2021-06-20 21:10:07','2021-06-20 21:10:07');
INSERT INTO student_payments VALUES('6','1','142','2021-06-10','14000.00','','2021-06-20 21:11:10','2021-06-20 21:11:10');
INSERT INTO student_payments VALUES('7','1','4','2021-06-10','14000.00','','2021-06-20 21:11:45','2021-06-20 21:11:45');
INSERT INTO student_payments VALUES('8','1','146','2021-06-10','13000.00','','2021-06-20 21:12:13','2021-06-20 21:12:13');
INSERT INTO student_payments VALUES('9','1','141','2021-06-10','14000.00','','2021-06-20 21:13:10','2021-06-20 21:13:10');
INSERT INTO student_payments VALUES('10','1','3','2021-06-10','5000.00','','2021-06-20 21:13:52','2021-06-20 21:13:52');
INSERT INTO student_payments VALUES('11','1','137','2021-06-10','18000.00','','2021-06-20 21:15:59','2021-06-20 21:15:59');
INSERT INTO student_payments VALUES('12','1','5','2021-06-10','2000.00','','2021-06-20 21:17:16','2021-06-20 21:17:16');
INSERT INTO student_payments VALUES('13','1','138','2021-06-10','18000.00','','2021-06-20 21:18:06','2021-06-20 21:18:06');
INSERT INTO student_payments VALUES('14','1','139','2021-06-10','16000.00','','2021-06-20 21:22:47','2021-06-20 21:22:47');
INSERT INTO student_payments VALUES('1188','1','1021','2022-02-28','8000.00','','2022-02-28 22:29:12','2022-02-28 22:29:12');
INSERT INTO student_payments VALUES('16','1','140','2021-06-10','16500.00','','2021-06-20 21:25:13','2021-06-20 21:25:13');
INSERT INTO student_payments VALUES('17','1','7','2021-06-10','10000.00','','2021-06-20 21:26:06','2021-06-20 21:26:06');
INSERT INTO student_payments VALUES('18','1','147','2021-06-10','16000.00','','2021-06-20 21:37:07','2021-06-20 21:37:07');
INSERT INTO student_payments VALUES('19','1','147','2021-06-10','3000.00','','2021-06-20 21:38:08','2021-06-20 21:38:08');
INSERT INTO student_payments VALUES('20','1','136','2021-06-10','16000.00','','2021-06-20 21:39:22','2021-06-20 21:39:22');
INSERT INTO student_payments VALUES('21','1','135','2021-06-10','16000.00','','2021-06-20 21:40:08','2021-06-20 21:40:08');
INSERT INTO student_payments VALUES('22','1','134','2021-06-10','16000.00','','2021-06-21 18:01:27','2021-06-21 18:01:27');
INSERT INTO student_payments VALUES('1109','1','992','2022-02-07','20000.00','','2022-02-07 17:19:55','2022-02-07 17:19:55');
INSERT INTO student_payments VALUES('24','1','132','2021-06-10','18000.00','','2021-06-21 18:05:03','2021-06-21 18:05:03');
INSERT INTO student_payments VALUES('25','1','131','2021-06-10','16500.00','','2021-06-21 18:06:00','2021-06-21 18:06:00');
INSERT INTO student_payments VALUES('26','1','127','2021-06-10','13000.00','','2021-06-21 18:07:05','2021-06-21 18:07:05');
INSERT INTO student_payments VALUES('27','1','128','2021-06-10','7000.00','','2021-06-21 18:07:51','2021-06-21 18:07:51');
INSERT INTO student_payments VALUES('28','1','129','2021-06-10','13000.00','','2021-06-21 18:09:19','2021-06-21 18:09:19');
INSERT INTO student_payments VALUES('29','1','130','2021-06-10','13000.00','','2021-06-21 18:10:32','2021-06-21 18:10:32');
INSERT INTO student_payments VALUES('30','1','39','2021-06-10','13000.00','','2021-06-21 18:15:09','2021-06-21 18:15:09');
INSERT INTO student_payments VALUES('31','1','39','2021-06-10','5000.00','','2021-06-21 18:16:13','2021-06-21 18:16:13');
INSERT INTO student_payments VALUES('32','1','126','2021-06-10','16000.00','','2021-06-21 18:21:23','2021-06-21 18:21:23');
INSERT INTO student_payments VALUES('33','1','126','2021-06-10','12000.00','','2021-06-21 18:22:02','2021-06-21 18:22:02');
INSERT INTO student_payments VALUES('34','1','36','2021-06-10','7500.00','','2021-06-21 18:23:36','2021-06-21 18:23:36');
INSERT INTO student_payments VALUES('35','1','36','2021-06-10','5000.00','','2021-06-21 18:24:17','2021-06-21 18:24:17');
INSERT INTO student_payments VALUES('36','1','125','2021-06-10','14500.00','','2021-06-21 18:38:09','2021-06-21 18:38:09');
INSERT INTO student_payments VALUES('37','1','9','2021-06-10','7250.00','','2021-06-21 18:38:54','2021-06-21 18:38:54');
INSERT INTO student_payments VALUES('38','1','123','2021-06-10','14500.00','','2021-06-21 18:39:33','2021-06-21 18:39:33');
INSERT INTO student_payments VALUES('39','1','124','2021-06-10','10000.00','','2021-06-21 18:40:30','2021-06-21 18:40:30');
INSERT INTO student_payments VALUES('40','1','38','2021-06-10','14500.00','','2021-06-21 19:01:05','2021-06-21 19:01:05');
INSERT INTO student_payments VALUES('41','1','38','2021-06-10','10000.00','','2021-06-21 19:39:54','2021-06-21 19:39:54');
INSERT INTO student_payments VALUES('1108','1','993','2022-02-07','20000.00','','2022-02-07 17:19:07','2022-02-07 17:19:07');
INSERT INTO student_payments VALUES('43','1','119','2021-06-10','14000.00','','2021-06-21 19:43:31','2021-06-21 19:43:31');
INSERT INTO student_payments VALUES('44','1','120','2021-06-10','14000.00','','2021-06-21 19:45:43','2021-06-21 19:45:43');
INSERT INTO student_payments VALUES('45','1','121','2021-06-10','14000.00','','2021-06-21 19:46:49','2021-06-21 19:46:49');
INSERT INTO student_payments VALUES('46','1','122','2021-06-10','14000.00','','2021-06-21 19:47:37','2021-06-21 19:47:37');
INSERT INTO student_payments VALUES('47','1','148','2021-06-10','16500.00','','2021-06-21 19:53:03','2021-06-21 19:53:03');
INSERT INTO student_payments VALUES('48','1','148','2021-06-10','10000.00','','2021-06-21 19:53:55','2021-06-21 19:53:55');
INSERT INTO student_payments VALUES('49','1','118','2021-06-10','16500.00','','2021-06-21 19:55:19','2021-06-21 19:55:19');
INSERT INTO student_payments VALUES('50','1','117','2021-06-10','16500.00','','2021-06-21 19:55:54','2021-06-21 19:55:54');
INSERT INTO student_payments VALUES('51','1','116','2021-06-10','16500.00','','2021-06-21 19:56:50','2021-06-21 19:56:50');
INSERT INTO student_payments VALUES('52','1','113','2021-06-10','16000.00','','2021-06-21 19:57:52','2021-06-21 19:57:52');
INSERT INTO student_payments VALUES('53','1','114','2021-06-10','16000.00','','2021-06-21 19:58:43','2021-06-21 19:58:43');
INSERT INTO student_payments VALUES('54','1','115','2021-06-10','16900.00','','2021-06-21 20:01:08','2021-06-21 20:01:08');
INSERT INTO student_payments VALUES('55','1','84','2021-06-10','16500.00','','2021-06-21 20:03:39','2021-06-21 20:03:39');
INSERT INTO student_payments VALUES('56','1','111','2021-06-10','13000.00','','2021-06-21 20:04:48','2021-06-21 20:04:48');
INSERT INTO student_payments VALUES('57','1','12','2021-06-10','2000.00','','2021-06-21 20:05:29','2021-06-21 20:05:29');
INSERT INTO student_payments VALUES('58','1','112','2021-06-10','13000.00','','2021-06-21 20:06:06','2021-06-21 20:06:06');
INSERT INTO student_payments VALUES('59','1','109','2021-06-10','16900.00','','2021-06-21 20:08:09','2021-06-21 20:08:09');
INSERT INTO student_payments VALUES('60','1','108','2021-06-10','16500.00','','2021-06-21 20:08:42','2021-06-21 20:08:42');
INSERT INTO student_payments VALUES('61','1','107','2021-06-10','16500.00','','2021-06-21 20:09:13','2021-06-21 20:09:13');
INSERT INTO student_payments VALUES('62','1','106','2021-06-10','16500.00','','2021-06-21 20:09:38','2021-06-21 20:09:38');
INSERT INTO student_payments VALUES('63','1','103','2021-06-10','15000.00','','2021-06-21 20:10:49','2021-06-21 20:10:49');
INSERT INTO student_payments VALUES('64','1','14','2021-06-10','1000.00','','2021-06-21 20:11:14','2021-06-21 20:11:14');
INSERT INTO student_payments VALUES('65','1','105','2021-06-10','17000.00','','2021-06-21 20:13:58','2021-06-21 20:13:58');
INSERT INTO student_payments VALUES('66','1','83','2021-06-10','17000.00','','2021-06-21 20:15:04','2021-06-21 20:15:04');
INSERT INTO student_payments VALUES('67','1','104','2021-06-10','16970.00','','2021-06-21 20:16:07','2021-06-21 20:16:07');
INSERT INTO student_payments VALUES('68','1','93','2021-06-10','16500.00','','2021-06-21 20:31:45','2021-06-21 20:31:45');
INSERT INTO student_payments VALUES('69','1','15','2021-06-10','8000.00','','2021-06-21 20:32:19','2021-06-21 20:32:19');
INSERT INTO student_payments VALUES('70','1','102','2021-06-10','16000.00','','2021-06-21 20:33:40','2021-06-21 20:33:40');
INSERT INTO student_payments VALUES('71','1','101','2021-06-10','16500.00','','2021-06-25 17:27:26','2021-06-25 17:27:26');
INSERT INTO student_payments VALUES('72','1','100','2021-06-10','16000.00','','2021-06-25 17:28:27','2021-06-25 17:28:27');
INSERT INTO student_payments VALUES('73','1','99','2021-06-10','21000.00','','2021-06-25 17:30:38','2021-06-25 17:30:38');
INSERT INTO student_payments VALUES('74','1','98','2021-06-10','23000.00','','2021-06-25 17:31:17','2021-06-25 17:31:17');
INSERT INTO student_payments VALUES('75','1','92','2021-06-10','17000.00','','2021-06-25 17:33:36','2021-06-25 17:33:36');
INSERT INTO student_payments VALUES('76','1','91','2021-06-10','16500.00','','2021-06-25 17:38:11','2021-06-25 17:38:11');
INSERT INTO student_payments VALUES('77','1','44','2021-06-10','35000.00','','2021-06-25 17:39:32','2021-06-25 17:39:32');
INSERT INTO student_payments VALUES('78','1','94','2021-06-10','17000.00','','2021-06-25 17:40:34','2021-06-25 17:40:34');
INSERT INTO student_payments VALUES('79','1','17','2021-06-10','1000.00','','2021-06-25 17:41:08','2021-06-25 17:41:08');
INSERT INTO student_payments VALUES('80','1','90','2021-06-10','16000.00','','2021-06-25 17:41:39','2021-06-25 17:41:39');
INSERT INTO student_payments VALUES('81','1','97','2021-06-10','12000.00','','2021-06-25 17:42:13','2021-06-25 17:42:13');
INSERT INTO student_payments VALUES('82','1','96','2021-06-10','12000.00','','2021-06-25 17:42:39','2021-06-25 17:42:39');
INSERT INTO student_payments VALUES('83','1','95','2021-06-10','12000.00','','2021-06-25 17:43:06','2021-06-25 17:43:06');
INSERT INTO student_payments VALUES('84','1','89','2021-06-10','15000.00','','2021-06-25 17:43:54','2021-06-25 17:43:54');
INSERT INTO student_payments VALUES('85','1','37','2021-06-10','17200.00','','2021-06-25 17:46:13','2021-06-25 17:46:13');
INSERT INTO student_payments VALUES('86','1','88','2021-06-10','16500.00','','2021-06-25 17:48:10','2021-06-25 17:48:10');
INSERT INTO student_payments VALUES('87','1','87','2021-06-10','16500.00','','2021-06-25 17:48:38','2021-06-25 17:48:38');
INSERT INTO student_payments VALUES('88','1','86','2021-06-10','17830.00','','2021-06-25 17:49:03','2021-06-25 17:49:03');
INSERT INTO student_payments VALUES('89','1','85','2021-06-10','16500.00','','2021-06-25 17:49:26','2021-06-25 17:49:26');
INSERT INTO student_payments VALUES('90','1','79','2021-06-10','16000.00','','2021-06-25 17:56:08','2021-06-25 17:56:08');
INSERT INTO student_payments VALUES('91','1','82','2021-06-10','16000.00','','2021-06-25 17:57:37','2021-06-25 17:57:37');
INSERT INTO student_payments VALUES('92','1','81','2021-06-10','16000.00','','2021-06-25 17:58:04','2021-06-25 17:58:04');
INSERT INTO student_payments VALUES('93','1','80','2021-06-10','16000.00','','2021-06-25 17:58:51','2021-06-25 17:58:51');
INSERT INTO student_payments VALUES('94','1','22','2021-06-10','6000.00','','2021-06-25 17:59:26','2021-06-25 17:59:26');
INSERT INTO student_payments VALUES('95','1','77','2021-06-10','15000.00','','2021-06-25 18:00:11','2021-06-25 18:00:11');
INSERT INTO student_payments VALUES('96','1','76','2021-06-10','15000.00','','2021-06-25 18:00:46','2021-06-25 18:00:46');
INSERT INTO student_payments VALUES('97','1','75','2021-06-10','12000.00','','2021-06-25 18:01:20','2021-06-25 18:01:20');
INSERT INTO student_payments VALUES('98','1','74','2021-06-10','12000.00','','2021-06-25 18:01:46','2021-06-25 18:01:46');
INSERT INTO student_payments VALUES('99','1','70','2021-06-10','14500.00','','2021-06-25 18:05:19','2021-06-25 18:05:19');
INSERT INTO student_payments VALUES('100','1','72','2021-06-10','17500.00','','2021-06-25 18:05:53','2021-06-25 18:05:53');
INSERT INTO student_payments VALUES('101','1','71','2021-06-10','17500.00','','2021-06-25 18:06:18','2021-06-25 18:06:18');
INSERT INTO student_payments VALUES('102','1','69','2021-06-10','14500.00','','2021-06-25 18:06:50','2021-06-25 18:06:50');
INSERT INTO student_payments VALUES('103','1','68','2021-06-10','13500.00','','2021-06-25 18:07:25','2021-06-25 18:07:25');
INSERT INTO student_payments VALUES('104','1','66','2021-06-10','13000.00','','2021-06-25 18:08:20','2021-06-25 18:08:20');
INSERT INTO student_payments VALUES('105','1','23','2021-06-10','3500.00','','2021-06-25 18:09:05','2021-06-25 18:09:05');
INSERT INTO student_payments VALUES('106','1','65','2021-06-10','13000.00','','2021-06-25 18:09:50','2021-06-25 18:09:50');
INSERT INTO student_payments VALUES('107','1','24','2021-06-10','2750.00','','2021-06-25 18:10:35','2021-06-25 18:10:35');
INSERT INTO student_payments VALUES('108','1','40','2021-06-10','23000.00','','2021-06-25 18:12:58','2021-06-25 18:12:58');
INSERT INTO student_payments VALUES('109','1','56','2021-06-10','13000.00','','2021-06-25 18:14:20','2021-06-25 18:14:20');
INSERT INTO student_payments VALUES('110','1','25','2021-06-10','7250.00','','2021-06-25 18:14:56','2021-06-25 18:14:56');
INSERT INTO student_payments VALUES('111','1','41','2021-06-10','23000.00','','2021-06-25 18:23:16','2021-06-25 18:23:16');
INSERT INTO student_payments VALUES('112','1','67','2021-06-10','23000.00','','2021-06-25 18:25:29','2021-06-25 18:25:29');
INSERT INTO student_payments VALUES('113','1','60','2021-06-10','18000.00','','2021-06-25 18:38:50','2021-06-25 18:38:50');
INSERT INTO student_payments VALUES('114','1','62','2021-06-10','18000.00','','2021-06-25 18:39:18','2021-06-25 18:39:18');
INSERT INTO student_payments VALUES('115','1','52','2021-06-10','16000.00','','2021-06-25 18:40:00','2021-06-25 18:40:00');
INSERT INTO student_payments VALUES('116','1','54','2021-06-10','16000.00','','2021-06-25 18:40:31','2021-06-25 18:40:31');
INSERT INTO student_payments VALUES('117','1','53','2021-06-10','16000.00','','2021-06-25 18:41:00','2021-06-25 18:41:00');
INSERT INTO student_payments VALUES('118','1','55','2021-06-10','6000.00','','2021-06-25 18:41:43','2021-06-25 18:41:43');
INSERT INTO student_payments VALUES('119','1','27','2021-06-10','1000.00','','2021-06-25 18:42:58','2021-06-25 18:42:58');
INSERT INTO student_payments VALUES('120','1','64','2021-06-10','19000.00','','2021-06-25 18:44:07','2021-06-25 18:44:07');
INSERT INTO student_payments VALUES('121','1','63','2021-06-10','19000.00','','2021-06-25 18:44:36','2021-06-25 18:44:36');
INSERT INTO student_payments VALUES('122','1','51','2021-06-10','19000.00','','2021-06-25 18:44:59','2021-06-25 18:44:59');
INSERT INTO student_payments VALUES('123','1','29','2021-06-10','9500.00','','2021-06-25 18:45:24','2021-06-25 18:45:24');
INSERT INTO student_payments VALUES('124','1','57','2021-06-10','17000.00','','2021-06-25 18:46:27','2021-06-25 18:46:27');
INSERT INTO student_payments VALUES('125','1','59','2021-06-10','12500.00','','2021-06-25 18:47:06','2021-06-25 18:47:06');
INSERT INTO student_payments VALUES('126','1','58','2021-06-10','12500.00','','2021-06-25 18:47:29','2021-06-25 18:47:29');
INSERT INTO student_payments VALUES('127','1','49','2021-06-10','32220.00','','2021-06-25 18:49:52','2021-06-25 18:49:52');
INSERT INTO student_payments VALUES('128','1','31','2021-06-10','31000.00','','2021-06-25 18:51:37','2021-06-25 18:51:37');
INSERT INTO student_payments VALUES('129','1','47','2021-06-10','8500.00','','2021-06-25 18:53:14','2021-06-25 18:53:14');
INSERT INTO student_payments VALUES('130','1','48','2021-06-10','12000.00','','2021-06-25 18:53:50','2021-06-25 18:53:50');
INSERT INTO student_payments VALUES('131','1','33','2021-06-10','5000.00','','2021-06-25 18:54:18','2021-06-25 18:54:18');
INSERT INTO student_payments VALUES('132','1','46','2021-06-10','21000.00','','2021-06-25 18:54:45','2021-06-25 18:54:45');
INSERT INTO student_payments VALUES('133','1','45','2021-06-10','21000.00','','2021-06-25 18:55:10','2021-06-25 18:55:10');
INSERT INTO student_payments VALUES('134','1','50','2021-06-10','18000.00','','2021-06-25 18:56:12','2021-06-25 18:56:12');
INSERT INTO student_payments VALUES('135','1','43','2021-06-10','21500.00','','2021-06-25 19:09:10','2021-06-25 19:09:10');
INSERT INTO student_payments VALUES('136','1','42','2021-06-10','21500.00','','2021-06-25 19:09:45','2021-06-25 19:09:45');
INSERT INTO student_payments VALUES('137','1','35','2021-06-28','10000.00','','2021-06-28 20:04:49','2021-06-28 20:04:49');
INSERT INTO student_payments VALUES('138','1','34','2021-06-28','10000.00','','2021-06-28 20:05:10','2021-06-28 20:05:10');
INSERT INTO student_payments VALUES('139','1','61','2021-06-26','18000.00','','2021-06-28 20:42:26','2021-06-28 20:42:26');
INSERT INTO student_payments VALUES('140','1','149','2021-06-28','8500.00','','2021-06-28 20:58:50','2021-06-28 20:58:50');
INSERT INTO student_payments VALUES('141','1','73','2021-06-30','12000.00','','2021-06-30 22:53:13','2021-06-30 22:53:13');
INSERT INTO student_payments VALUES('142','1','150','2021-06-30','4000.00','','2021-06-30 23:14:32','2021-06-30 23:14:32');
INSERT INTO student_payments VALUES('143','1','227','2021-07-01','13000.00','m/o july','2021-07-02 16:37:07','2021-07-02 16:37:07');
INSERT INTO student_payments VALUES('144','1','249','2021-07-02','16000.00','M/O JULY','2021-07-02 16:41:53','2021-07-02 16:41:53');
INSERT INTO student_payments VALUES('145','1','250','2021-07-03','16140.00','16000+140=16140','2021-07-03 16:03:14','2021-07-03 16:03:14');
INSERT INTO student_payments VALUES('146','1','264','2021-07-02','20000.00','ACCOUNT DEPOSIT
SEC TOTAL 10000','2021-07-03 16:10:26','2021-07-03 16:10:26');
INSERT INTO student_payments VALUES('147','1','43','2021-06-29','5000.00','ADJUSTMENT 
SEC REFUND
10000','2021-07-03 16:25:17','2021-07-03 16:25:17');
INSERT INTO student_payments VALUES('148','1','42','2021-06-28','5000.00','ADJUSTMENT
SEC REFUND 10000
TALK USMA SAB','2021-07-03 16:26:51','2021-07-03 16:26:51');
INSERT INTO student_payments VALUES('149','1','158','2021-07-03','14000.00','','2021-07-03 16:41:14','2021-07-03 16:41:14');
INSERT INTO student_payments VALUES('150','1','256','2021-07-03','6500.00','sec adjustment 10000','2021-07-03 18:49:55','2021-07-03 18:49:55');
INSERT INTO student_payments VALUES('151','1','267','2021-07-03','16500.00','','2021-07-03 19:43:06','2021-07-03 19:43:06');
INSERT INTO student_payments VALUES('152','1','266','2021-07-03','16500.00','','2021-07-03 19:43:34','2021-07-03 19:43:34');
INSERT INTO student_payments VALUES('153','1','204','2021-07-03','15000.00','','2021-07-03 19:49:31','2021-07-03 19:49:31');
INSERT INTO student_payments VALUES('154','1','229','2021-07-03','16000.00','','2021-07-03 20:33:59','2021-07-03 20:33:59');
INSERT INTO student_payments VALUES('155','1','192','2021-07-03','15000.00','','2021-07-03 20:58:41','2021-07-03 20:58:41');
INSERT INTO student_payments VALUES('156','1','201','2021-07-05','16500.00','','2021-07-05 19:18:16','2021-07-05 19:18:16');
INSERT INTO student_payments VALUES('157','1','260','2021-07-05','14000.00','','2021-07-05 19:24:24','2021-07-05 19:24:24');
INSERT INTO student_payments VALUES('158','1','144','2021-07-05','4000.00','','2021-07-05 19:25:14','2021-07-05 19:25:14');
INSERT INTO student_payments VALUES('159','1','171','2021-07-05','14000.00','','2021-07-05 19:59:20','2021-07-05 19:59:20');
INSERT INTO student_payments VALUES('160','1','185','2021-07-05','15500.00','','2021-07-05 20:03:21','2021-07-05 20:03:21');
INSERT INTO student_payments VALUES('161','1','219','2021-07-05','17320.00','','2021-07-05 20:43:01','2021-07-05 20:43:01');
INSERT INTO student_payments VALUES('162','1','248','2021-07-05','17000.00','','2021-07-05 20:43:46','2021-07-05 20:43:46');
INSERT INTO student_payments VALUES('163','1','153','2021-07-05','15500.00','','2021-07-05 20:49:56','2021-07-05 20:49:56');
INSERT INTO student_payments VALUES('164','1','221','2021-07-05','17560.00','','2021-07-05 20:59:08','2021-07-05 20:59:08');
INSERT INTO student_payments VALUES('165','1','23','2021-07-05','3750.00','','2021-07-05 21:43:23','2021-07-05 21:43:23');
INSERT INTO student_payments VALUES('166','1','181','2021-07-05','14000.00','','2021-07-05 21:47:43','2021-07-05 21:47:43');
INSERT INTO student_payments VALUES('167','1','187','2021-07-06','15400.00','','2021-07-06 19:14:44','2021-07-06 19:14:44');
INSERT INTO student_payments VALUES('168','1','186','2021-07-06','15400.00','','2021-07-06 19:15:20','2021-07-06 19:15:20');
INSERT INTO student_payments VALUES('169','1','16','2021-07-06','1000.00','','2021-07-06 19:18:11','2021-07-06 19:18:11');
INSERT INTO student_payments VALUES('170','1','217','2021-07-06','16525.00','','2021-07-06 19:19:39','2021-07-06 19:19:39');
INSERT INTO student_payments VALUES('171','1','208','2021-07-06','525.00','sec adjustment 16500','2021-07-06 19:21:04','2021-07-06 19:21:04');
INSERT INTO student_payments VALUES('172','1','262','2021-07-06','13000.00','','2021-07-06 19:46:26','2021-07-06 19:46:26');
INSERT INTO student_payments VALUES('173','1','165','2021-07-06','18000.00','','2021-07-06 20:01:01','2021-07-06 20:01:01');
INSERT INTO student_payments VALUES('174','1','216','2021-07-06','17025.00','','2021-07-06 20:05:53','2021-07-06 20:05:53');
INSERT INTO student_payments VALUES('175','1','191','2021-07-06','15000.00','','2021-07-06 20:11:02','2021-07-06 20:11:02');
INSERT INTO student_payments VALUES('176','1','242','2021-07-06','13000.00','','2021-07-06 20:14:59','2021-07-06 20:14:59');
INSERT INTO student_payments VALUES('177','1','193','2021-07-06','15000.00','','2021-07-06 20:15:46','2021-07-06 20:15:46');
INSERT INTO student_payments VALUES('178','1','196','2021-07-06','16385.00','','2021-07-06 20:50:25','2021-07-06 20:50:25');
INSERT INTO student_payments VALUES('179','1','230','2021-07-06','16000.00','','2021-07-06 20:52:16','2021-07-06 20:52:16');
INSERT INTO student_payments VALUES('180','1','228','2021-07-06','16000.00','','2021-07-06 20:54:52','2021-07-06 20:54:52');
INSERT INTO student_payments VALUES('181','1','157','2021-07-08','14000.00','','2021-07-08 16:05:47','2021-07-08 16:05:47');
INSERT INTO student_payments VALUES('182','1','222','2021-07-08','18550.00','','2021-07-08 16:22:47','2021-07-08 16:22:47');
INSERT INTO student_payments VALUES('183','1','261','2021-07-06','13000.00','','2021-07-08 16:29:56','2021-07-08 16:29:56');
INSERT INTO student_payments VALUES('184','1','2','2021-07-06','1330.00','','2021-07-08 16:31:20','2021-07-08 16:31:20');
INSERT INTO student_payments VALUES('185','1','3','2021-07-07','5000.00','','2021-07-08 16:31:55','2021-07-08 16:31:55');
INSERT INTO student_payments VALUES('186','1','259','2021-07-07','14000.00','','2021-07-08 16:32:31','2021-07-08 16:32:31');
INSERT INTO student_payments VALUES('187','1','257','2021-07-07','14000.00','','2021-07-08 16:33:01','2021-07-08 16:33:01');
INSERT INTO student_payments VALUES('188','1','156','2021-07-07','10000.00','','2021-07-08 16:35:40','2021-07-08 16:35:40');
INSERT INTO student_payments VALUES('189','1','243','2021-07-07','13000.00','','2021-07-08 16:36:14','2021-07-08 16:36:14');
INSERT INTO student_payments VALUES('190','1','238','2021-07-08','14500.00','','2021-07-08 17:04:41','2021-07-08 17:04:41');
INSERT INTO student_payments VALUES('191','1','152','2021-07-08','15000.00','','2021-07-08 17:05:56','2021-07-08 17:05:56');
INSERT INTO student_payments VALUES('192','1','226','2021-07-08','13000.00','','2021-07-08 17:09:39','2021-07-08 17:09:39');
INSERT INTO student_payments VALUES('193','1','224','2021-07-08','8060.00','','2021-07-08 17:13:24','2021-07-08 17:13:24');
INSERT INTO student_payments VALUES('194','1','215','2021-07-07','16525.00','','2021-07-08 17:16:00','2021-07-08 17:16:00');
INSERT INTO student_payments VALUES('195','1','2','2021-07-06','170.00','','2021-07-08 17:17:42','2021-07-08 17:17:42');
INSERT INTO student_payments VALUES('196','1','207','2021-07-07','19465.00','','2021-07-08 17:22:54','2021-07-08 17:22:54');
INSERT INTO student_payments VALUES('197','1','199','2021-07-07','14000.00','','2021-07-08 18:16:10','2021-07-08 18:16:10');
INSERT INTO student_payments VALUES('198','1','30','2021-07-08','500.00','','2021-07-08 19:18:11','2021-07-08 19:18:11');
INSERT INTO student_payments VALUES('199','1','57','2021-07-08','1000.00','','2021-07-08 19:18:37','2021-07-08 19:18:37');
INSERT INTO student_payments VALUES('200','1','172','2021-07-08','16500.00','','2021-07-08 19:19:09','2021-07-08 19:19:09');
INSERT INTO student_payments VALUES('201','1','200','2021-07-08','16500.00','','2021-07-08 19:34:04','2021-07-08 19:34:04');
INSERT INTO student_payments VALUES('202','1','201','2021-07-08','2240.00','','2021-07-08 19:37:33','2021-07-08 19:37:33');
INSERT INTO student_payments VALUES('203','1','202','2021-07-08','16500.00','','2021-07-08 19:39:23','2021-07-08 19:39:23');
INSERT INTO student_payments VALUES('204','1','206','2021-07-08','19465.00','','2021-07-08 20:55:23','2021-07-08 20:55:23');
INSERT INTO student_payments VALUES('205','1','170','2021-07-10','6000.00','','2021-07-10 13:49:50','2021-07-10 13:49:50');
INSERT INTO student_payments VALUES('206','1','55','2021-07-10','10000.00','','2021-07-10 13:50:15','2021-07-10 13:50:15');
INSERT INTO student_payments VALUES('207','1','168','2021-07-10','16340.00','','2021-07-10 13:52:07','2021-07-10 13:52:07');
INSERT INTO student_payments VALUES('208','1','26','2021-07-10','2000.00','','2021-07-10 13:56:13','2021-07-10 13:56:13');
INSERT INTO student_payments VALUES('209','1','167','2021-07-10','6340.00','','2021-07-10 13:58:17','2021-07-10 13:58:17');
INSERT INTO student_payments VALUES('210','1','27','2021-07-10','1000.00','','2021-07-10 13:58:48','2021-07-10 13:58:48');
INSERT INTO student_payments VALUES('211','1','169','2021-07-10','6340.00','','2021-07-10 14:00:50','2021-07-10 14:00:50');
INSERT INTO student_payments VALUES('212','1','246','2021-07-09','16500.00','','2021-07-10 14:04:53','2021-07-10 14:04:53');
INSERT INTO student_payments VALUES('213','1','244','2021-07-09','13000.00','','2021-07-10 14:05:38','2021-07-10 14:05:38');
INSERT INTO student_payments VALUES('214','1','223','2021-07-09','18560.00','','2021-07-10 14:09:33','2021-07-10 14:09:33');
INSERT INTO student_payments VALUES('215','1','198','2021-07-10','17320.00','','2021-07-10 14:13:26','2021-07-10 14:13:26');
INSERT INTO student_payments VALUES('216','1','159','2021-07-08','24000.00','','2021-07-10 14:14:39','2021-07-10 14:14:39');
INSERT INTO student_payments VALUES('217','1','205','2021-07-08','6000.00','','2021-07-10 14:17:06','2021-07-10 14:17:06');
INSERT INTO student_payments VALUES('218','1','17','2021-07-08','1000.00','','2021-07-10 14:17:46','2021-07-10 14:17:46');
INSERT INTO student_payments VALUES('219','1','209','2021-07-08','8000.00','','2021-07-10 14:19:05','2021-07-10 14:19:05');
INSERT INTO student_payments VALUES('220','1','211','2021-07-09','12000.00','','2021-07-10 14:19:58','2021-07-10 14:19:58');
INSERT INTO student_payments VALUES('221','1','210','2021-07-08','12000.00','','2021-07-10 14:20:30','2021-07-10 14:20:30');
INSERT INTO student_payments VALUES('222','1','154','2021-07-09','17000.00','','2021-07-10 14:21:09','2021-07-10 14:21:09');
INSERT INTO student_payments VALUES('223','1','124','2021-07-09','4500.00','','2021-07-10 14:24:27','2021-07-10 14:24:27');
INSERT INTO student_payments VALUES('224','1','239','2021-07-10','14500.00','','2021-07-10 14:24:59','2021-07-10 14:24:59');
INSERT INTO student_payments VALUES('225','1','268','2021-07-09','13000.00','','2021-07-10 14:31:36','2021-07-10 14:31:36');
INSERT INTO student_payments VALUES('226','1','203','2021-07-08','11500.00','','2021-07-10 14:32:20','2021-07-10 14:32:20');
INSERT INTO student_payments VALUES('227','1','180','2021-07-10','14000.00','','2021-07-10 14:41:35','2021-07-10 14:41:35');
INSERT INTO student_payments VALUES('228','1','182','2021-07-10','14000.00','','2021-07-10 14:43:07','2021-07-10 14:43:07');
INSERT INTO student_payments VALUES('229','1','189','2021-07-08','12000.00','','2021-07-10 14:52:25','2021-07-10 14:52:25');
INSERT INTO student_payments VALUES('1187','1','983','2022-02-24','32000.00','','2022-02-28 22:28:27','2022-02-28 22:28:27');
INSERT INTO student_payments VALUES('231','1','166','2021-07-06','19000.00','','2021-07-10 14:56:06','2021-07-10 14:56:06');
INSERT INTO student_payments VALUES('232','1','178','2021-07-10','13500.00','','2021-07-10 15:00:07','2021-07-10 15:00:07');
INSERT INTO student_payments VALUES('233','1','179','2021-07-10','18000.00','','2021-07-10 15:00:34','2021-07-10 15:00:34');
INSERT INTO student_payments VALUES('234','1','162','2021-07-09','17000.00','','2021-07-10 15:02:14','2021-07-10 15:02:14');
INSERT INTO student_payments VALUES('235','1','163','2021-07-10','13000.00','','2021-07-10 15:03:15','2021-07-10 15:03:15');
INSERT INTO student_payments VALUES('236','1','161','2021-07-10','20000.00','','2021-07-10 15:05:33','2021-07-10 15:05:33');
INSERT INTO student_payments VALUES('237','1','175','2021-07-10','8000.00','','2021-07-10 15:41:12','2021-07-10 15:41:12');
INSERT INTO student_payments VALUES('238','1','128','2021-07-12','6000.00','','2021-07-12 19:24:48','2021-07-12 19:24:48');
INSERT INTO student_payments VALUES('239','1','194','2021-07-12','14000.00','','2021-07-12 19:42:16','2021-07-12 19:42:16');
INSERT INTO student_payments VALUES('1446','1','1309','2022-04-20','22000.00','','2022-04-21 13:29:31','2022-04-21 13:29:31');
INSERT INTO student_payments VALUES('241','1','214','2021-07-12','24440.00','','2021-07-12 21:06:28','2021-07-12 21:06:28');
INSERT INTO student_payments VALUES('242','1','247','2021-07-14','18000.00','','2021-07-14 19:22:59','2021-07-14 19:22:59');
INSERT INTO student_payments VALUES('243','1','254','2021-07-14','18000.00','','2021-07-14 20:31:38','2021-07-14 20:31:38');
INSERT INTO student_payments VALUES('244','1','184','2021-07-15','15000.00','','2021-07-17 19:16:05','2021-07-17 19:16:05');
INSERT INTO student_payments VALUES('245','1','5','2021-07-14','5000.00','','2021-07-17 19:17:49','2021-07-17 19:17:49');
INSERT INTO student_payments VALUES('1443','1','1236','2022-04-19','10000.00','','2022-04-20 16:03:37','2022-04-20 16:03:37');
INSERT INTO student_payments VALUES('247','1','245','2021-07-13','3000.00','','2021-07-17 19:25:17','2021-07-17 19:25:17');
INSERT INTO student_payments VALUES('248','1','241','2021-07-13','16000.00','','2021-07-17 19:26:41','2021-07-17 19:26:41');
INSERT INTO student_payments VALUES('249','1','263','2021-07-15','16500.00','','2021-07-17 19:35:02','2021-07-17 19:35:02');
INSERT INTO student_payments VALUES('250','1','233','2021-07-15','16500.00','','2021-07-17 19:35:27','2021-07-17 19:35:27');
INSERT INTO student_payments VALUES('251','1','232','2021-07-14','16500.00','','2021-07-17 19:35:54','2021-07-17 19:35:54');
INSERT INTO student_payments VALUES('252','1','231','2021-07-14','16500.00','','2021-07-17 19:36:20','2021-07-17 19:36:20');
INSERT INTO student_payments VALUES('253','1','218','2021-07-15','15000.00','','2021-07-17 19:38:03','2021-07-17 19:38:03');
INSERT INTO student_payments VALUES('254','1','220','2021-07-13','8000.00','','2021-07-17 19:39:19','2021-07-17 19:39:19');
INSERT INTO student_payments VALUES('255','1','213','2021-07-14','15000.00','','2021-07-17 19:43:11','2021-07-17 19:43:11');
INSERT INTO student_payments VALUES('256','1','212','2021-07-14','12000.00','','2021-07-17 19:44:08','2021-07-17 19:44:08');
INSERT INTO student_payments VALUES('257','1','21','2021-07-14','1000.00','','2021-07-17 19:47:14','2021-07-17 19:47:14');
INSERT INTO student_payments VALUES('258','1','197','2021-07-15','15000.00','','2021-07-17 19:47:57','2021-07-17 19:47:57');
INSERT INTO student_payments VALUES('259','1','22','2021-07-14','2000.00','','2021-07-17 19:48:59','2021-07-17 19:48:59');
INSERT INTO student_payments VALUES('260','1','195','2021-07-14','14000.00','','2021-07-17 19:49:43','2021-07-17 19:49:43');
INSERT INTO student_payments VALUES('261','1','190','2021-07-15','12000.00','','2021-07-17 19:51:55','2021-07-17 19:51:55');
INSERT INTO student_payments VALUES('262','1','179','2021-07-15','1365.00','','2021-07-17 19:56:16','2021-07-17 19:56:16');
INSERT INTO student_payments VALUES('263','1','173','2021-07-15','12500.00','','2021-07-17 19:57:45','2021-07-17 19:57:45');
INSERT INTO student_payments VALUES('264','1','220','2021-07-22','9320.00','','2021-07-26 19:15:19','2021-07-26 19:15:19');
INSERT INTO student_payments VALUES('265','1','263','2021-07-30','1940.00','','2021-08-01 17:16:39','2021-08-01 17:16:39');
INSERT INTO student_payments VALUES('266','1','233','2021-07-30','1940.00','','2021-08-01 17:17:57','2021-08-01 17:17:57');
INSERT INTO student_payments VALUES('267','1','232','2021-07-30','1940.00','','2021-08-01 17:18:54','2021-08-01 17:18:54');
INSERT INTO student_payments VALUES('268','1','231','2021-07-30','1940.00','','2021-08-01 17:19:30','2021-08-01 17:19:30');
INSERT INTO student_payments VALUES('269','1','13','2021-07-30','6500.00','','2021-08-01 17:21:19','2021-08-01 17:21:19');
INSERT INTO student_payments VALUES('270','1','110','2021-07-30','3500.00','','2021-08-01 17:22:03','2021-08-01 17:22:03');
INSERT INTO student_payments VALUES('271','1','203','2021-07-30','5000.00','','2021-08-01 17:28:50','2021-08-01 17:28:50');
INSERT INTO student_payments VALUES('272','1','177','2021-07-30','7200.00','','2021-08-01 18:00:39','2021-08-01 18:00:39');
INSERT INTO student_payments VALUES('273','1','176','2021-07-30','8000.00','','2021-08-01 18:01:05','2021-08-01 18:01:05');
INSERT INTO student_payments VALUES('274','1','274','2021-08-01','24000.00','','2021-08-01 18:53:01','2021-08-01 18:53:01');
INSERT INTO student_payments VALUES('275','1','370','2021-08-01','17000.00','','2021-08-01 20:14:48','2021-08-01 20:14:48');
INSERT INTO student_payments VALUES('276','1','164','2021-07-30','31000.00','','2021-08-01 20:39:50','2021-08-01 20:39:50');
INSERT INTO student_payments VALUES('277','1','251','2021-07-30','12500.00','','2021-08-01 20:41:29','2021-08-01 20:41:29');
INSERT INTO student_payments VALUES('278','1','331','2021-08-03','19760.00','','2021-08-03 20:05:05','2021-08-03 20:05:05');
INSERT INTO student_payments VALUES('279','1','280','2021-08-03','18000.00','','2021-08-03 20:46:01','2021-08-03 20:46:01');
INSERT INTO student_payments VALUES('280','1','269','2021-08-03','15500.00','','2021-08-03 20:49:45','2021-08-03 20:49:45');
INSERT INTO student_payments VALUES('281','1','271','2021-08-04','10000.00','','2021-08-04 18:39:04','2021-08-04 18:39:04');
INSERT INTO student_payments VALUES('282','1','365','2021-08-04','15000.00','','2021-08-04 18:39:40','2021-08-04 18:39:40');
INSERT INTO student_payments VALUES('283','1','350','2021-08-04','16000.00','','2021-08-04 19:25:31','2021-08-04 19:25:31');
INSERT INTO student_payments VALUES('284','1','320','2021-08-04','12000.00','','2021-08-04 20:41:43','2021-08-04 20:41:43');
INSERT INTO student_payments VALUES('285','1','319','2021-08-04','12000.00','','2021-08-04 20:42:15','2021-08-04 20:42:15');
INSERT INTO student_payments VALUES('286','1','324','2021-08-04','17080.00','','2021-08-04 21:10:14','2021-08-04 21:10:14');
INSERT INTO student_payments VALUES('287','1','353','2021-08-05','8300.00','','2021-08-05 17:26:11','2021-08-05 17:26:11');
INSERT INTO student_payments VALUES('288','1','353','2021-08-05','8300.00','','2021-08-05 17:26:32','2021-08-05 17:26:32');
INSERT INTO student_payments VALUES('289','1','338','2021-08-05','16000.00','','2021-08-05 17:44:51','2021-08-05 17:44:51');
INSERT INTO student_payments VALUES('290','1','310','2021-08-05','16500.00','','2021-08-05 18:05:10','2021-08-05 18:05:10');
INSERT INTO student_payments VALUES('291','1','362','2021-08-05','13000.00','','2021-08-05 18:31:11','2021-08-05 18:31:11');
INSERT INTO student_payments VALUES('292','1','301','2021-08-05','15000.00','','2021-08-05 18:32:02','2021-08-05 18:32:02');
INSERT INTO student_payments VALUES('293','1','311','2021-08-05','16500.00','','2021-08-05 18:34:03','2021-08-05 18:34:03');
INSERT INTO student_payments VALUES('294','1','333','2021-08-06','19210.00','','2021-08-06 17:20:03','2021-08-06 17:20:03');
INSERT INTO student_payments VALUES('295','1','287','2021-08-06','18500.00','','2021-08-06 17:25:45','2021-08-06 17:25:45');
INSERT INTO student_payments VALUES('296','1','172','2021-08-06','1500.00','','2021-08-06 17:26:45','2021-08-06 17:26:45');
INSERT INTO student_payments VALUES('297','1','309','2021-08-08','14000.00','','2021-08-08 19:12:18','2021-08-08 19:12:18');
INSERT INTO student_payments VALUES('298','1','282','2021-08-08','22400.00','','2021-08-08 20:38:11','2021-08-08 20:38:11');
INSERT INTO student_payments VALUES('299','1','311','2021-08-08','2380.00','','2021-08-08 20:44:58','2021-08-08 20:44:58');
INSERT INTO student_payments VALUES('300','1','312','2021-08-08','16500.00','','2021-08-08 20:46:28','2021-08-08 20:46:28');
INSERT INTO student_payments VALUES('301','1','316','2021-08-08','18840.00','','2021-08-08 21:51:30','2021-08-08 21:51:30');
INSERT INTO student_payments VALUES('302','1','349','2021-08-10','17000.00','','2021-08-10 18:37:23','2021-08-10 18:37:23');
INSERT INTO student_payments VALUES('303','1','361','2021-08-10','6500.00','','2021-08-12 18:13:36','2021-08-12 18:13:36');
INSERT INTO student_payments VALUES('304','1','355','2021-08-11','18000.00','','2021-08-12 18:16:43','2021-08-12 18:16:43');
INSERT INTO student_payments VALUES('305','1','353','2021-08-12','560.00','','2021-08-12 18:18:36','2021-08-12 18:18:36');
INSERT INTO student_payments VALUES('306','1','252','2021-08-10','16140.00','','2021-08-12 18:19:29','2021-08-12 18:19:29');
INSERT INTO student_payments VALUES('307','1','351','2021-08-09','8000.00','','2021-08-12 18:20:25','2021-08-12 18:20:25');
INSERT INTO student_payments VALUES('308','1','346','2021-08-10','13000.00','','2021-08-12 18:26:25','2021-08-12 18:26:25');
INSERT INTO student_payments VALUES('309','1','345','2021-08-11','16000.00','','2021-08-12 18:27:01','2021-08-12 18:27:01');
INSERT INTO student_payments VALUES('310','1','343','2021-08-11','7250.00','','2021-08-12 18:29:11','2021-08-12 18:29:11');
INSERT INTO student_payments VALUES('311','1','363','2021-08-11','19760.00','','2021-08-12 18:33:11','2021-08-12 18:33:11');
INSERT INTO student_payments VALUES('312','1','342','2021-08-11','19760.00','','2021-08-12 18:33:38','2021-08-12 18:33:38');
INSERT INTO student_payments VALUES('313','1','341','2021-08-11','19760.00','','2021-08-12 18:34:04','2021-08-12 18:34:04');
INSERT INTO student_payments VALUES('314','1','340','2021-08-11','19770.00','','2021-08-12 18:34:44','2021-08-12 18:34:44');
INSERT INTO student_payments VALUES('315','1','339','2021-08-12','16000.00','','2021-08-12 18:37:09','2021-08-12 18:37:09');
INSERT INTO student_payments VALUES('316','1','335','2021-08-09','13000.00','','2021-08-12 18:39:45','2021-08-12 18:39:45');
INSERT INTO student_payments VALUES('317','1','330','2021-08-12','18710.00','','2021-08-12 18:42:29','2021-08-12 18:42:29');
INSERT INTO student_payments VALUES('318','1','329','2021-08-11','9330.00','','2021-08-12 19:04:49','2021-08-12 19:04:49');
INSERT INTO student_payments VALUES('319','1','218','2021-08-12','1320.00','','2021-08-12 19:06:00','2021-08-12 19:06:00');
INSERT INTO student_payments VALUES('320','1','327','2021-08-10','6680.00','','2021-08-12 19:06:43','2021-08-12 19:06:43');
INSERT INTO student_payments VALUES('321','1','328','2021-08-12','17330.00','','2021-08-12 19:07:09','2021-08-12 19:07:09');
INSERT INTO student_payments VALUES('322','1','308','2021-08-12','17330.00','','2021-08-12 19:07:37','2021-08-12 19:07:37');
INSERT INTO student_payments VALUES('323','1','326','2021-08-12','17080.00','','2021-08-12 19:08:21','2021-08-12 19:08:21');
INSERT INTO student_payments VALUES('324','1','325','2021-08-12','17580.00','','2021-08-12 19:08:46','2021-08-12 19:08:46');
INSERT INTO student_payments VALUES('325','1','322','2021-08-12','24000.00','','2021-08-12 19:09:57','2021-08-12 19:09:57');
INSERT INTO student_payments VALUES('326','1','315','2021-08-09','22000.00','','2021-08-12 19:11:49','2021-08-12 19:11:49');
INSERT INTO student_payments VALUES('327','1','321','2021-08-08','12000.00','','2021-08-12 19:12:56','2021-08-12 19:12:56');
INSERT INTO student_payments VALUES('328','1','314','2021-08-09','7500.00','','2021-08-12 19:15:14','2021-08-12 19:15:14');
INSERT INTO student_payments VALUES('329','1','270','2021-08-08','17000.00','','2021-08-12 19:15:40','2021-08-12 19:15:40');
INSERT INTO student_payments VALUES('330','1','313','2021-08-10','3000.00','','2021-08-12 19:17:11','2021-08-12 19:17:11');
INSERT INTO student_payments VALUES('331','1','194','2021-08-09','2385.00','','2021-08-12 19:19:04','2021-08-12 19:19:04');
INSERT INTO student_payments VALUES('332','1','304','2021-08-09','13615.00','','2021-08-12 19:19:47','2021-08-12 19:19:47');
INSERT INTO student_payments VALUES('333','1','306','2021-08-10','10560.00','','2021-08-12 19:24:12','2021-08-12 19:24:12');
INSERT INTO student_payments VALUES('334','1','195','2021-08-09','2385.00','','2021-08-12 19:24:54','2021-08-12 19:24:54');
INSERT INTO student_payments VALUES('335','1','305','2021-08-09','13615.00','','2021-08-12 19:26:06','2021-08-12 19:26:06');
INSERT INTO student_payments VALUES('336','1','305','2021-08-10','1500.00','','2021-08-12 19:28:15','2021-08-12 19:28:15');
INSERT INTO student_payments VALUES('337','1','302','2021-08-10','13500.00','','2021-08-12 19:29:58','2021-08-12 19:29:58');
INSERT INTO student_payments VALUES('338','1','297','2021-08-11','12394.00','','2021-08-12 19:35:45','2021-08-12 19:35:45');
INSERT INTO student_payments VALUES('339','1','296','2021-08-11','19894.00','','2021-08-12 19:36:13','2021-08-12 19:36:13');
INSERT INTO student_payments VALUES('340','1','294','2021-08-12','14894.00','','2021-08-12 19:36:59','2021-08-12 19:36:59');
INSERT INTO student_payments VALUES('341','1','295','2021-08-12','17894.00','','2021-08-12 19:37:56','2021-08-12 19:37:56');
INSERT INTO student_payments VALUES('342','1','290','2021-08-11','7500.00','','2021-08-12 19:50:09','2021-08-12 19:50:09');
INSERT INTO student_payments VALUES('343','1','291','2021-08-11','7500.00','','2021-08-12 19:50:38','2021-08-12 19:50:38');
INSERT INTO student_payments VALUES('344','1','364','2021-08-09','17000.00','','2021-08-12 19:54:30','2021-08-12 19:54:30');
INSERT INTO student_payments VALUES('345','1','284','2021-08-12','16400.00','','2021-08-12 19:55:48','2021-08-12 19:55:48');
INSERT INTO student_payments VALUES('346','1','289','2021-08-10','10500.00','','2021-08-12 20:02:02','2021-08-12 20:02:02');
INSERT INTO student_payments VALUES('347','1','288','2021-08-10','9500.00','','2021-08-12 20:02:29','2021-08-12 20:02:29');
INSERT INTO student_payments VALUES('348','1','278','2021-08-12','13000.00','','2021-08-12 20:05:27','2021-08-12 20:05:27');
INSERT INTO student_payments VALUES('349','1','279','2021-08-10','32440.00','','2021-08-12 20:06:03','2021-08-12 20:06:03');
INSERT INTO student_payments VALUES('350','1','372','2021-08-12','16500.00','','2021-08-12 20:35:00','2021-08-12 20:35:00');
INSERT INTO student_payments VALUES('351','1','371','2021-08-12','13000.00','','2021-08-12 20:35:32','2021-08-12 20:35:32');
INSERT INTO student_payments VALUES('352','1','293','2021-08-15','12144.00','','2021-08-15 16:18:38','2021-08-15 16:18:38');
INSERT INTO student_payments VALUES('353','1','183','2021-08-15','14420.00','','2021-08-15 16:19:20','2021-08-15 16:19:20');
INSERT INTO student_payments VALUES('354','1','68','2021-08-15','3000.00','','2021-08-15 16:20:08','2021-08-15 16:20:08');
INSERT INTO student_payments VALUES('355','1','360','2021-08-15','5000.00','','2021-08-15 16:21:46','2021-08-15 16:21:46');
INSERT INTO student_payments VALUES('356','1','251','2021-08-15','3640.00','','2021-08-15 16:24:10','2021-08-15 16:24:10');
INSERT INTO student_payments VALUES('357','1','352','2021-08-15','13360.00','','2021-08-15 16:25:26','2021-08-15 16:25:26');
INSERT INTO student_payments VALUES('358','1','336','2021-08-15','6500.00','','2021-08-15 16:28:25','2021-08-15 16:28:25');
INSERT INTO student_payments VALUES('359','1','286','2021-08-15','7500.00','','2021-08-15 16:29:38','2021-08-15 16:29:38');
INSERT INTO student_payments VALUES('360','1','313','2021-08-15','5500.00','','2021-08-15 16:33:43','2021-08-15 16:33:43');
INSERT INTO student_payments VALUES('361','1','161','2021-08-15','1280.00','','2021-08-15 16:57:45','2021-08-15 16:57:45');
INSERT INTO student_payments VALUES('1454','1','1338','2022-04-28','19000.00','','2022-04-28 17:01:57','2022-04-28 17:01:57');
INSERT INTO student_payments VALUES('363','1','364','2021-08-16','5000.00','','2021-08-17 15:55:45','2021-08-17 15:55:45');
INSERT INTO student_payments VALUES('364','1','337','2021-08-16','12000.00','','2021-08-17 16:24:43','2021-08-17 16:24:43');
INSERT INTO student_payments VALUES('365','1','300','2021-08-17','12000.00','','2021-08-17 16:25:54','2021-08-17 16:25:54');
INSERT INTO student_payments VALUES('366','1','197','2021-08-15','1385.00','','2021-08-17 16:31:05','2021-08-17 16:31:05');
INSERT INTO student_payments VALUES('367','1','307','2021-08-15','12915.00','','2021-08-17 16:32:02','2021-08-17 16:32:02');
INSERT INTO student_payments VALUES('368','1','170','2021-08-16','4000.00','','2021-08-17 16:34:21','2021-08-17 16:34:21');
INSERT INTO student_payments VALUES('369','1','285','2021-08-15','4000.00','','2021-08-17 16:35:03','2021-08-17 16:35:03');
INSERT INTO student_payments VALUES('370','1','347','2021-08-17','16500.00','','2021-08-17 16:44:16','2021-08-17 16:44:16');
INSERT INTO student_payments VALUES('371','1','184','2021-08-24','420.00','','2021-08-24 17:42:20','2021-08-24 17:42:20');
INSERT INTO student_payments VALUES('372','1','294','2021-08-24','5000.00','','2021-08-24 17:42:50','2021-08-24 17:42:50');
INSERT INTO student_payments VALUES('373','1','292','2021-08-23','6500.00','','2021-08-24 17:46:46','2021-08-24 17:46:46');
INSERT INTO student_payments VALUES('374','1','273','2021-08-24','8000.00','','2021-08-24 17:47:32','2021-08-24 17:47:32');
INSERT INTO student_payments VALUES('375','1','272','2021-08-24','8000.00','','2021-08-24 17:48:05','2021-08-24 17:48:05');
INSERT INTO student_payments VALUES('376','1','329','2021-08-22','8000.00','','2021-08-24 18:20:31','2021-08-24 18:20:31');
INSERT INTO student_payments VALUES('377','1','281','2021-08-24','9500.00','','2021-08-24 19:46:41','2021-08-24 19:46:41');
INSERT INTO student_payments VALUES('378','1','357','2021-08-24','5000.00','','2021-08-24 20:35:51','2021-08-24 20:35:51');
INSERT INTO student_payments VALUES('379','1','344','2021-08-24','3000.00','','2021-08-24 20:39:42','2021-08-24 20:39:42');
INSERT INTO student_payments VALUES('380','1','277','2021-08-26','8500.00','','2021-08-26 19:00:32','2021-08-26 19:00:32');
INSERT INTO student_payments VALUES('381','1','323','2021-08-25','18750.00','','2021-08-26 19:02:44','2021-08-26 19:02:44');
INSERT INTO student_payments VALUES('382','1','354','2021-08-24','18000.00','','2021-08-26 19:05:04','2021-08-26 19:05:04');
INSERT INTO student_payments VALUES('1442','1','1079','2022-04-19','500.00','','2022-04-20 16:00:30','2022-04-20 16:00:30');
INSERT INTO student_payments VALUES('384','1','283','2021-08-26','8400.00','','2021-08-26 19:17:19','2021-08-26 19:17:19');
INSERT INTO student_payments VALUES('385','1','348','2021-08-27','9000.00','','2021-08-28 16:53:18','2021-08-28 16:53:18');
INSERT INTO student_payments VALUES('386','1','327','2021-08-27','8820.00','','2021-08-28 17:02:48','2021-08-28 17:02:48');
INSERT INTO student_payments VALUES('387','1','258','2021-08-26','14000.00','','2021-08-30 18:29:29','2021-08-30 18:29:29');
INSERT INTO student_payments VALUES('388','1','358','2021-08-26','4000.00','','2021-08-30 18:30:52','2021-08-30 18:30:52');
INSERT INTO student_payments VALUES('389','1','373','2021-08-30','18000.00','','2021-08-31 20:32:31','2021-08-31 20:32:31');
INSERT INTO student_payments VALUES('390','1','379','2021-09-02','24000.00','','2021-09-03 19:10:14','2021-09-03 19:10:14');
INSERT INTO student_payments VALUES('391','1','415','2021-09-04','17000.00','','2021-09-04 19:54:41','2021-09-04 19:54:41');
INSERT INTO student_payments VALUES('392','1','375','2021-09-04','17000.00','','2021-09-04 19:55:06','2021-09-04 19:55:06');
INSERT INTO student_payments VALUES('393','1','428','2021-09-04','16740.00','','2021-09-04 20:02:29','2021-09-04 20:02:29');
INSERT INTO student_payments VALUES('394','1','317','2021-09-04','18840.00','','2021-09-04 20:04:28','2021-09-04 20:04:28');
INSERT INTO student_payments VALUES('395','1','419','2021-09-01','10000.00','','2021-09-04 20:05:37','2021-09-04 20:05:37');
INSERT INTO student_payments VALUES('396','1','365','2021-09-06','500.00','','2021-09-06 20:08:41','2021-09-06 20:08:41');
INSERT INTO student_payments VALUES('397','1','463','2021-09-06','15500.00','','2021-09-06 20:09:23','2021-09-06 20:09:23');
INSERT INTO student_payments VALUES('398','1','412','2021-09-06','24800.00','','2021-09-06 20:17:21','2021-09-06 20:17:21');
INSERT INTO student_payments VALUES('399','1','384','2021-09-07','18000.00','','2021-09-07 19:29:38','2021-09-07 19:29:38');
INSERT INTO student_payments VALUES('400','1','464','2021-09-07','27000.00','','2021-09-07 19:48:10','2021-09-07 19:48:10');
INSERT INTO student_payments VALUES('401','1','404','2021-09-07','16000.00','','2021-09-07 20:50:35','2021-09-07 20:50:35');
INSERT INTO student_payments VALUES('402','1','304','2021-09-07','1445.00','','2021-09-07 20:54:35','2021-09-07 20:54:35');
INSERT INTO student_payments VALUES('403','1','405','2021-09-07','16005.00','','2021-09-07 21:00:25','2021-09-07 21:00:25');
INSERT INTO student_payments VALUES('404','1','403','2021-09-06','16000.00','','2021-09-07 21:17:03','2021-09-07 21:17:03');
INSERT INTO student_payments VALUES('405','1','460','2021-09-08','13000.00','','2021-09-08 17:35:38','2021-09-08 17:35:38');
INSERT INTO student_payments VALUES('406','1','459','2021-09-08','13000.00','','2021-09-08 18:06:32','2021-09-08 18:06:32');
INSERT INTO student_payments VALUES('407','1','411','2021-09-08','17500.00','','2021-09-08 18:25:16','2021-09-08 18:25:16');
INSERT INTO student_payments VALUES('408','1','391','2021-09-08','19000.00','','2021-09-08 20:18:39','2021-09-08 20:18:39');
INSERT INTO student_payments VALUES('409','1','462','2021-09-08','17000.00','','2021-09-08 20:42:45','2021-09-08 20:42:45');
INSERT INTO student_payments VALUES('410','1','467','2021-09-08','34000.00','','2021-09-08 20:51:58','2021-09-08 20:51:58');
INSERT INTO student_payments VALUES('411','1','452','2021-09-09','19260.00','','2021-09-09 16:45:00','2021-09-09 16:45:00');
INSERT INTO student_payments VALUES('412','1','295','2021-09-09','2000.00','','2021-09-09 20:25:58','2021-09-09 20:25:58');
INSERT INTO student_payments VALUES('413','1','399','2021-09-09','15500.00','','2021-09-09 20:29:13','2021-09-09 20:29:13');
INSERT INTO student_payments VALUES('414','1','397','2021-09-09','15375.00','','2021-09-09 20:32:27','2021-09-09 20:32:27');
INSERT INTO student_payments VALUES('415','1','388','2021-09-09','20000.00','','2021-09-09 20:40:05','2021-09-09 20:40:05');
INSERT INTO student_payments VALUES('416','1','386','2021-09-09','19850.00','','2021-09-09 20:41:09','2021-09-09 20:41:09');
INSERT INTO student_payments VALUES('417','1','469','2021-09-09','17000.00','','2021-09-09 21:02:35','2021-09-09 21:02:35');
INSERT INTO student_payments VALUES('418','1','468','2021-09-09','17000.00','','2021-09-09 21:04:06','2021-09-09 21:04:06');
INSERT INTO student_payments VALUES('419','1','416','2021-09-09','11000.00','','2021-09-09 21:10:11','2021-09-09 21:10:11');
INSERT INTO student_payments VALUES('420','1','461','2021-09-11','20480.00','','2021-09-11 19:43:59','2021-09-11 19:43:59');
INSERT INTO student_payments VALUES('421','1','441','2021-09-11','17000.00','','2021-09-11 19:45:45','2021-09-11 19:45:45');
INSERT INTO student_payments VALUES('422','1','440','2021-09-11','17000.00','','2021-09-11 19:46:41','2021-09-11 19:46:41');
INSERT INTO student_payments VALUES('423','1','439','2021-09-11','17000.00','','2021-09-11 19:47:47','2021-09-11 19:47:47');
INSERT INTO student_payments VALUES('424','1','446','2021-09-11','16500.00','','2021-09-11 19:50:30','2021-09-11 19:50:30');
INSERT INTO student_payments VALUES('425','1','418','2021-09-08','17270.00','','2021-09-11 19:54:28','2021-09-11 19:54:28');
INSERT INTO student_payments VALUES('426','1','417','2021-09-11','17270.00','','2021-09-11 19:55:48','2021-09-11 19:55:48');
INSERT INTO student_payments VALUES('427','1','466','2021-09-08','27500.00','','2021-09-12 16:49:49','2021-09-12 16:49:49');
INSERT INTO student_payments VALUES('428','1','449','2021-09-12','17000.00','','2021-09-12 18:51:04','2021-09-12 18:51:04');
INSERT INTO student_payments VALUES('429','1','431','2021-09-09','20300.00','','2021-09-12 18:54:51','2021-09-12 18:54:51');
INSERT INTO student_payments VALUES('430','1','470','2021-09-08','16500.00','','2021-09-12 20:05:18','2021-09-12 20:05:18');
INSERT INTO student_payments VALUES('431','1','360','2021-09-10','2000.00','','2021-09-12 20:07:12','2021-09-12 20:07:12');
INSERT INTO student_payments VALUES('432','1','458','2021-09-09','7500.00','','2021-09-12 20:09:27','2021-09-12 20:09:27');
INSERT INTO student_payments VALUES('433','1','453','2021-09-08','18000.00','','2021-09-12 20:11:16','2021-09-12 20:11:16');
INSERT INTO student_payments VALUES('434','1','376','2021-09-08','10000.00','','2021-09-12 20:19:47','2021-09-12 20:19:47');
INSERT INTO student_payments VALUES('435','1','344','2021-09-11','7500.00','','2021-09-12 20:23:37','2021-09-12 20:23:37');
INSERT INTO student_payments VALUES('436','1','437','2021-09-12','16000.00','','2021-09-12 20:28:43','2021-09-12 20:28:43');
INSERT INTO student_payments VALUES('437','1','436','2021-09-10','16000.00','','2021-09-12 20:30:29','2021-09-12 20:30:29');
INSERT INTO student_payments VALUES('438','1','410','2021-09-12','10000.00','','2021-09-12 20:31:30','2021-09-12 20:31:30');
INSERT INTO student_payments VALUES('439','1','435','2021-09-10','13000.00','','2021-09-12 20:36:00','2021-09-12 20:36:00');
INSERT INTO student_payments VALUES('440','1','430','2021-09-10','17000.00','','2021-09-12 20:38:17','2021-09-12 20:38:17');
INSERT INTO student_payments VALUES('441','1','409','2021-09-10','16740.00','','2021-09-12 20:42:50','2021-09-12 20:42:50');
INSERT INTO student_payments VALUES('442','1','424','2021-09-02','16000.00','','2021-09-12 20:45:12','2021-09-12 20:45:12');
INSERT INTO student_payments VALUES('443','1','421','2021-09-08','12000.00','','2021-09-12 20:48:38','2021-09-12 20:48:38');
INSERT INTO student_payments VALUES('444','1','420','2021-09-11','12000.00','','2021-09-12 20:49:06','2021-09-12 20:49:06');
INSERT INTO student_payments VALUES('445','1','413','2021-09-10','17500.00','','2021-09-12 20:53:18','2021-09-12 20:53:18');
INSERT INTO student_payments VALUES('446','1','414','2021-09-09','8750.00','','2021-09-12 20:54:19','2021-09-12 20:54:19');
INSERT INTO student_payments VALUES('447','1','407','2021-09-09','17000.00','','2021-09-12 20:56:29','2021-09-12 20:56:29');
INSERT INTO student_payments VALUES('448','1','401','2021-09-09','7750.00','','2021-09-12 21:01:04','2021-09-12 21:01:04');
INSERT INTO student_payments VALUES('449','1','285','2021-09-08','4400.00','','2021-09-12 21:06:09','2021-09-12 21:06:09');
INSERT INTO student_payments VALUES('450','1','389','2021-09-09','6100.00','','2021-09-12 21:06:51','2021-09-12 21:06:51');
INSERT INTO student_payments VALUES('451','1','470','2021-09-12','8500.00','','2021-09-12 21:09:13','2021-09-12 21:09:13');
INSERT INTO student_payments VALUES('452','1','387','2021-09-12','8500.00','','2021-09-12 21:10:20','2021-09-12 21:10:20');
INSERT INTO student_payments VALUES('453','1','393','2021-09-07','20000.00','','2021-09-12 21:13:47','2021-09-12 21:13:47');
INSERT INTO student_payments VALUES('454','1','392','2021-09-09','20000.00','','2021-09-12 21:14:31','2021-09-12 21:14:31');
INSERT INTO student_payments VALUES('455','1','383','2021-09-08','15500.00','','2021-09-12 21:16:33','2021-09-12 21:16:33');
INSERT INTO student_payments VALUES('456','1','433','2021-09-13','21200.00','','2021-09-13 16:40:07','2021-09-13 16:40:07');
INSERT INTO student_payments VALUES('457','1','305','2021-09-09','1445.00','','2021-09-13 16:45:26','2021-09-13 16:45:26');
INSERT INTO student_payments VALUES('458','1','406','2021-09-09','15555.00','','2021-09-13 16:46:29','2021-09-13 16:46:29');
INSERT INTO student_payments VALUES('1186','1','1096','2022-02-20','8000.00','','2022-02-25 17:48:16','2022-02-25 17:48:16');
INSERT INTO student_payments VALUES('460','1','472','2021-09-13','17000.00','','2021-09-13 17:19:02','2021-09-13 17:19:02');
INSERT INTO student_payments VALUES('461','1','209','2021-09-13','500.00','','2021-09-13 17:47:07','2021-09-13 17:47:07');
INSERT INTO student_payments VALUES('462','1','318','2021-09-13','8500.00','','2021-09-13 17:48:16','2021-09-13 17:48:16');
INSERT INTO student_payments VALUES('1191','1','1032','2022-03-02','2000.00','','2022-03-02 17:38:48','2022-03-02 17:38:48');
INSERT INTO student_payments VALUES('464','1','430','2021-09-13','4200.00','','2021-09-13 18:00:19','2021-09-13 18:00:19');
INSERT INTO student_payments VALUES('465','1','381','2021-09-13','18000.00','','2021-09-13 19:46:24','2021-09-13 19:46:24');
INSERT INTO student_payments VALUES('466','1','413','2021-09-14','7300.00','','2021-09-14 16:30:34','2021-09-14 16:30:34');
INSERT INTO student_payments VALUES('467','1','411','2021-09-14','7300.00','','2021-09-14 16:31:08','2021-09-14 16:31:08');
INSERT INTO student_payments VALUES('468','1','438','2021-09-15','15000.00','','2021-09-15 20:38:41','2021-09-15 20:38:41');
INSERT INTO student_payments VALUES('469','1','454','2021-09-15','18000.00','','2021-09-16 19:05:45','2021-09-16 19:05:45');
INSERT INTO student_payments VALUES('470','1','445','2021-09-16','13000.00','','2021-09-16 19:08:04','2021-09-16 19:08:04');
INSERT INTO student_payments VALUES('471','1','388','2021-09-16','3000.00','','2021-09-16 19:42:16','2021-09-16 19:42:16');
INSERT INTO student_payments VALUES('472','1','357','2021-09-19','2000.00','','2021-09-20 19:31:06','2021-09-20 19:31:06');
INSERT INTO student_payments VALUES('1190','1','1101','2022-03-02','24000.00','','2022-03-02 17:33:52','2022-03-02 17:33:52');
INSERT INTO student_payments VALUES('474','1','456','2021-09-20','14000.00','','2021-09-20 19:32:47','2021-09-20 19:32:47');
INSERT INTO student_payments VALUES('475','1','351','2021-09-20','1150.00','','2021-09-20 19:50:52','2021-09-20 19:50:52');
INSERT INTO student_payments VALUES('476','1','450','2021-09-20','6850.00','','2021-09-20 19:51:49','2021-09-20 19:51:49');
INSERT INTO student_payments VALUES('477','1','474','2021-09-20','21000.00','','2021-09-20 20:00:00','2021-09-20 20:00:00');
INSERT INTO student_payments VALUES('478','1','475','2021-09-20','16240.00','','2021-09-20 20:05:14','2021-09-20 20:05:14');
INSERT INTO student_payments VALUES('479','1','476','2021-09-20','15000.00','','2021-09-20 20:10:50','2021-09-20 20:10:50');
INSERT INTO student_payments VALUES('480','1','477','2021-09-20','26000.00','','2021-09-20 20:16:03','2021-09-20 20:16:03');
INSERT INTO student_payments VALUES('481','1','471','2021-09-19','6000.00','','2021-09-20 20:16:45','2021-09-20 20:16:45');
INSERT INTO student_payments VALUES('482','1','400','2021-09-19','8000.00','','2021-09-20 20:19:09','2021-09-20 20:19:09');
INSERT INTO student_payments VALUES('483','1','398','2021-09-20','16375.00','','2021-09-20 20:21:35','2021-09-20 20:21:35');
INSERT INTO student_payments VALUES('484','1','465','2021-09-20','20000.00','','2021-09-20 20:23:55','2021-09-20 20:23:55');
INSERT INTO student_payments VALUES('485','1','478','2021-09-20','23500.00','','2021-09-20 20:28:30','2021-09-20 20:28:30');
INSERT INTO student_payments VALUES('486','1','427','2021-09-20','8740.00','','2021-09-20 20:31:30','2021-09-20 20:31:30');
INSERT INTO student_payments VALUES('487','1','450','2021-09-22','3910.00','','2021-09-23 16:19:41','2021-09-23 16:19:41');
INSERT INTO student_payments VALUES('488','1','448','2021-09-22','9000.00','','2021-09-23 16:21:25','2021-09-23 16:21:25');
INSERT INTO student_payments VALUES('489','1','426','2021-09-22','8000.00','','2021-09-23 16:28:55','2021-09-23 16:28:55');
INSERT INTO student_payments VALUES('490','1','395','2021-09-22','7000.00','','2021-09-23 16:33:20','2021-09-23 16:33:20');
INSERT INTO student_payments VALUES('491','1','394','2021-09-22','14000.00','','2021-09-23 16:35:14','2021-09-23 16:35:14');
INSERT INTO student_payments VALUES('492','1','377','2021-09-22','14000.00','','2021-09-23 16:36:33','2021-09-23 16:36:33');
INSERT INTO student_payments VALUES('493','1','390','2021-09-22','7000.00','','2021-09-23 16:39:20','2021-09-23 16:39:20');
INSERT INTO student_payments VALUES('494','1','396','2021-09-22','14000.00','','2021-09-23 16:39:58','2021-09-23 16:39:58');
INSERT INTO student_payments VALUES('495','1','410','2021-09-28','3000.00','','2021-09-28 19:15:14','2021-09-28 19:15:14');
INSERT INTO student_payments VALUES('496','1','380','2021-09-23','21000.00','','2021-09-28 19:16:57','2021-09-28 19:16:57');
INSERT INTO student_payments VALUES('497','1','352','2021-09-28','3800.00','','2021-09-29 20:07:25','2021-09-29 20:07:25');
INSERT INTO student_payments VALUES('498','1','451','2021-09-28','5200.00','','2021-09-29 20:08:06','2021-09-29 20:08:06');
INSERT INTO student_payments VALUES('499','1','344','2021-09-28','4000.00','','2021-09-29 20:13:16','2021-09-29 20:13:16');
INSERT INTO student_payments VALUES('1189','1','1041','2022-02-28','8000.00','','2022-02-28 22:37:35','2022-02-28 22:37:35');
INSERT INTO student_payments VALUES('501','1','479','2021-09-29','5000.00','','2021-09-29 20:19:39','2021-09-29 20:19:39');
INSERT INTO student_payments VALUES('502','1','481','2021-09-29','2500.00','','2021-09-29 20:24:01','2021-09-29 20:24:01');
INSERT INTO student_payments VALUES('503','1','480','2021-09-28','1000.00','','2021-09-29 20:29:16','2021-09-29 20:29:16');
INSERT INTO student_payments VALUES('504','1','480','2021-09-29','1500.00','','2021-09-29 20:30:14','2021-09-29 20:30:14');
INSERT INTO student_payments VALUES('505','1','482','2021-09-28','10000.00','','2021-09-29 20:35:50','2021-09-29 20:35:50');
INSERT INTO student_payments VALUES('506','1','483','2021-09-28','5000.00','','2021-09-29 20:44:09','2021-09-29 20:44:09');
INSERT INTO student_payments VALUES('507','1','484','2021-09-29','19000.00','','2021-09-29 20:55:41','2021-09-29 20:55:41');
INSERT INTO student_payments VALUES('508','1','485','2021-09-29','10000.00','','2021-09-29 20:56:10','2021-09-29 20:56:10');
INSERT INTO student_payments VALUES('509','1','487','2021-09-28','21000.00','','2021-09-29 21:15:04','2021-09-29 21:15:04');
INSERT INTO student_payments VALUES('510','1','486','2021-09-28','21000.00','','2021-09-29 21:15:37','2021-09-29 21:15:37');
INSERT INTO student_payments VALUES('511','1','447','2021-09-30','15000.00','','2021-09-30 20:00:50','2021-09-30 20:00:50');
INSERT INTO student_payments VALUES('512','1','488','2021-09-29','3325.00','','2021-09-30 20:51:31','2021-09-30 20:51:31');
INSERT INTO student_payments VALUES('513','1','523','2021-10-03','17000.00','','2021-10-03 22:01:33','2021-10-03 22:01:33');
INSERT INTO student_payments VALUES('514','1','532','2021-10-04','16500.00','','2021-10-04 17:59:09','2021-10-04 17:59:09');
INSERT INTO student_payments VALUES('515','1','563','2021-10-04','17000.00','','2021-10-04 18:31:39','2021-10-04 18:31:39');
INSERT INTO student_payments VALUES('516','1','554','2021-10-04','10000.00','','2021-10-04 19:23:45','2021-10-04 19:23:45');
INSERT INTO student_payments VALUES('517','1','451','2021-10-04','5570.00','','2021-10-04 19:25:12','2021-10-04 19:25:12');
INSERT INTO student_payments VALUES('518','1','551','2021-10-04','16760.00','','2021-10-04 20:37:01','2021-10-04 20:37:01');
INSERT INTO student_payments VALUES('519','1','549','2021-10-04','17000.00','','2021-10-04 21:38:35','2021-10-04 21:38:35');
INSERT INTO student_payments VALUES('520','1','571','2021-10-04','15000.00','','2021-10-04 21:39:52','2021-10-04 21:39:52');
INSERT INTO student_payments VALUES('521','1','545','2021-10-04','14000.00','','2021-10-04 21:41:15','2021-10-04 21:41:15');
INSERT INTO student_payments VALUES('522','1','577','2021-10-05','14000.00','','2021-10-05 16:50:54','2021-10-05 16:50:54');
INSERT INTO student_payments VALUES('523','1','527','2021-10-05','15000.00','','2021-10-05 17:06:20','2021-10-05 17:06:20');
INSERT INTO student_payments VALUES('524','1','557','2021-10-05','14500.00','','2021-10-05 17:33:18','2021-10-05 17:33:18');
INSERT INTO student_payments VALUES('525','1','592','2021-10-05','18000.00','','2021-10-05 17:38:25','2021-10-05 17:38:25');
INSERT INTO student_payments VALUES('526','1','590','2021-10-05','30000.00','','2021-10-05 17:54:32','2021-10-05 17:54:32');
INSERT INTO student_payments VALUES('527','1','591','2021-10-05','17000.00','','2021-10-05 18:05:56','2021-10-05 18:05:56');
INSERT INTO student_payments VALUES('528','1','539','2021-10-05','15500.00','','2021-10-05 18:07:02','2021-10-05 18:07:02');
INSERT INTO student_payments VALUES('529','1','576','2021-10-05','17000.00','','2021-10-05 18:08:09','2021-10-05 18:08:09');
INSERT INTO student_payments VALUES('530','1','578','2021-10-05','26000.00','','2021-10-05 18:28:03','2021-10-05 18:28:03');
INSERT INTO student_payments VALUES('531','1','536','2021-10-05','24825.00','','2021-10-05 18:30:38','2021-10-05 18:30:38');
INSERT INTO student_payments VALUES('532','1','579','2021-10-05','17000.00','','2021-10-05 18:36:40','2021-10-05 18:36:40');
INSERT INTO student_payments VALUES('1193','1','1175','2022-03-02','22000.00','','2022-03-02 19:53:04','2022-03-02 19:53:04');
INSERT INTO student_payments VALUES('534','1','416','2021-10-05','6000.00','','2021-10-05 18:38:13','2021-10-05 18:38:13');
INSERT INTO student_payments VALUES('535','1','524','2021-10-05','19000.00','','2021-10-05 18:38:56','2021-10-05 18:38:56');
INSERT INTO student_payments VALUES('536','1','572','2021-10-05','21000.00','','2021-10-05 18:58:18','2021-10-05 18:58:18');
INSERT INTO student_payments VALUES('537','1','570','2021-10-05','24135.00','','2021-10-05 19:46:28','2021-10-05 19:46:28');
INSERT INTO student_payments VALUES('538','1','493','2021-10-05','24000.00','','2021-10-05 19:47:33','2021-10-05 19:47:33');
INSERT INTO student_payments VALUES('539','1','592','2021-10-05','10000.00','','2021-10-05 19:52:33','2021-10-05 19:52:33');
INSERT INTO student_payments VALUES('540','1','438','2021-10-05','1000.00','','2021-10-05 19:54:17','2021-10-05 19:54:17');
INSERT INTO student_payments VALUES('541','1','540','2021-10-05','14000.00','','2021-10-05 19:55:07','2021-10-05 19:55:07');
INSERT INTO student_payments VALUES('542','1','562','2021-10-05','15500.00','','2021-10-05 20:05:21','2021-10-05 20:05:21');
INSERT INTO student_payments VALUES('543','1','495','2021-10-05','18000.00','','2021-10-05 20:18:13','2021-10-05 20:18:13');
INSERT INTO student_payments VALUES('544','1','565','2021-10-05','17500.00','','2021-10-05 20:43:26','2021-10-05 20:43:26');
INSERT INTO student_payments VALUES('545','1','589','2021-10-05','33000.00','','2021-10-05 20:45:33','2021-10-05 20:45:33');
INSERT INTO student_payments VALUES('546','1','528','2021-10-05','12000.00','','2021-10-05 20:46:34','2021-10-05 20:46:34');
INSERT INTO student_payments VALUES('547','1','489','2021-10-05','17000.00','','2021-10-05 20:48:53','2021-10-05 20:48:53');
INSERT INTO student_payments VALUES('548','1','522','2021-10-05','17500.00','','2021-10-05 20:59:36','2021-10-05 20:59:36');
INSERT INTO student_payments VALUES('549','1','537','2021-10-05','14000.00','','2021-10-05 21:03:34','2021-10-05 21:03:34');
INSERT INTO student_payments VALUES('550','1','521','2021-10-05','17500.00','','2021-10-05 21:04:24','2021-10-05 21:04:24');
INSERT INTO student_payments VALUES('551','1','389','2021-10-05','2000.00','','2021-10-05 21:05:36','2021-10-05 21:05:36');
INSERT INTO student_payments VALUES('552','1','500','2021-10-05','17000.00','','2021-10-05 21:06:32','2021-10-05 21:06:32');
INSERT INTO student_payments VALUES('553','1','498','2021-10-05','17000.00','','2021-10-05 21:09:39','2021-10-05 21:09:39');
INSERT INTO student_payments VALUES('554','1','497','2021-10-05','22140.00','','2021-10-05 21:12:30','2021-10-05 21:12:30');
INSERT INTO student_payments VALUES('555','1','386','2021-10-05','5990.00','','2021-10-05 21:13:20','2021-10-05 21:13:20');
INSERT INTO student_payments VALUES('556','1','482','2021-10-05','5000.00','','2021-10-05 21:17:00','2021-10-05 21:17:00');
INSERT INTO student_payments VALUES('557','1','582','2021-10-05','17500.00','','2021-10-05 21:17:40','2021-10-05 21:17:40');
INSERT INTO student_payments VALUES('558','1','516','2021-10-05','16000.00','','2021-10-05 21:19:47','2021-10-05 21:19:47');
INSERT INTO student_payments VALUES('559','1','512','2021-10-05','16000.00','','2021-10-05 21:20:22','2021-10-05 21:20:22');
INSERT INTO student_payments VALUES('560','1','513','2021-10-05','16000.00','','2021-10-05 21:23:50','2021-10-05 21:23:50');
INSERT INTO student_payments VALUES('561','1','581','2021-10-05','17500.00','','2021-10-05 21:24:38','2021-10-05 21:24:38');
INSERT INTO student_payments VALUES('562','1','580','2021-10-05','19000.00','','2021-10-05 21:25:08','2021-10-05 21:25:08');
INSERT INTO student_payments VALUES('563','1','511','2021-10-05','15500.00','','2021-10-05 21:26:41','2021-10-05 21:26:41');
INSERT INTO student_payments VALUES('564','1','388','2021-10-05','2840.00','','2021-10-05 21:37:12','2021-10-05 21:37:12');
INSERT INTO student_payments VALUES('565','1','499','2021-10-05','18160.00','','2021-10-05 21:38:02','2021-10-05 21:38:02');
INSERT INTO student_payments VALUES('566','1','555','2021-10-06','14000.00','','2021-10-06 17:19:03','2021-10-06 17:19:03');
INSERT INTO student_payments VALUES('567','1','554','2021-10-06','8000.00','','2021-10-06 17:20:42','2021-10-06 17:20:42');
INSERT INTO student_payments VALUES('568','1','591','2021-10-06','17000.00','','2021-10-06 17:21:34','2021-10-06 17:21:34');
INSERT INTO student_payments VALUES('569','1','517','2021-10-06','16470.00','','2021-10-06 17:26:58','2021-10-06 17:26:58');
INSERT INTO student_payments VALUES('570','1','550','2021-10-06','17000.00','','2021-10-06 17:33:11','2021-10-06 17:33:11');
INSERT INTO student_payments VALUES('571','1','588','2021-10-06','17000.00','','2021-10-06 17:47:26','2021-10-06 17:47:26');
INSERT INTO student_payments VALUES('572','1','542','2021-10-06','14000.00','','2021-10-06 17:48:49','2021-10-06 17:48:49');
INSERT INTO student_payments VALUES('573','1','546','2021-10-05','16500.00','','2021-10-06 17:50:04','2021-10-06 17:50:04');
INSERT INTO student_payments VALUES('574','1','541','2021-10-06','14000.00','','2021-10-06 17:55:20','2021-10-06 17:55:20');
INSERT INTO student_payments VALUES('575','1','164','2021-10-06','490.00','','2021-10-06 18:00:58','2021-10-06 18:00:58');
INSERT INTO student_payments VALUES('576','1','494','2021-10-06','32000.00','','2021-10-06 18:02:35','2021-10-06 18:02:35');
INSERT INTO student_payments VALUES('577','1','529','2021-10-06','12000.00','','2021-10-06 18:05:46','2021-10-06 18:05:46');
INSERT INTO student_payments VALUES('578','1','520','2021-10-06','22590.00','','2021-10-06 19:27:45','2021-10-06 19:27:45');
INSERT INTO student_payments VALUES('579','1','490','2021-10-06','10000.00','','2021-10-06 19:53:56','2021-10-06 19:53:56');
INSERT INTO student_payments VALUES('580','1','594','2021-10-06','24000.00','','2021-10-06 20:07:04','2021-10-06 20:07:04');
INSERT INTO student_payments VALUES('1194','1','1170','2022-03-02','17500.00','','2022-03-02 19:56:56','2022-03-02 19:56:56');
INSERT INTO student_payments VALUES('582','1','535','2021-10-07','20330.00','','2021-10-07 15:55:47','2021-10-07 15:55:47');
INSERT INTO student_payments VALUES('583','1','593','2021-10-07','26000.00','','2021-10-07 16:12:40','2021-10-07 16:12:40');
INSERT INTO student_payments VALUES('584','1','501','2021-10-07','14000.00','','2021-10-07 16:13:23','2021-10-07 16:13:23');
INSERT INTO student_payments VALUES('585','1','525','2021-10-07','18120.00','','2021-10-07 16:18:40','2021-10-07 16:18:40');
INSERT INTO student_payments VALUES('586','1','399','2021-10-07','875.00','','2021-10-07 17:08:04','2021-10-07 17:08:04');
INSERT INTO student_payments VALUES('587','1','509','2021-10-07','17125.00','','2021-10-07 17:09:25','2021-10-07 17:09:25');
INSERT INTO student_payments VALUES('588','1','586','2021-10-07','23500.00','','2021-10-07 18:46:16','2021-10-07 18:46:16');
INSERT INTO student_payments VALUES('589','1','583','2021-10-07','23500.00','','2021-10-07 18:46:52','2021-10-07 18:46:52');
INSERT INTO student_payments VALUES('590','1','574','2021-10-07','17000.00','','2021-10-07 19:40:29','2021-10-07 19:40:29');
INSERT INTO student_payments VALUES('591','1','378','2021-10-07','7000.00','','2021-10-07 19:59:54','2021-10-07 19:59:54');
INSERT INTO student_payments VALUES('592','1','492','2021-10-07','1000.00','','2021-10-07 20:00:40','2021-10-07 20:00:40');
INSERT INTO student_payments VALUES('593','1','515','2021-10-07','17000.00','','2021-10-07 20:02:58','2021-10-07 20:02:58');
INSERT INTO student_payments VALUES('594','1','405','2021-10-07','4560.00','','2021-10-07 20:05:46','2021-10-07 20:05:46');
INSERT INTO student_payments VALUES('595','1','514','2021-10-07','4440.00','','2021-10-07 20:08:31','2021-10-07 20:08:31');
INSERT INTO student_payments VALUES('596','1','575','2021-10-07','15000.00','','2021-10-07 20:09:03','2021-10-07 20:09:03');
INSERT INTO student_payments VALUES('597','1','538','2021-10-07','15500.00','','2021-10-07 20:13:08','2021-10-07 20:13:08');
INSERT INTO student_payments VALUES('598','1','585','2021-10-07','6000.00','','2021-10-07 20:17:55','2021-10-07 20:17:55');
INSERT INTO student_payments VALUES('599','1','505','2021-10-08','14000.00','','2021-10-08 15:09:38','2021-10-08 15:09:38');
INSERT INTO student_payments VALUES('600','1','491','2021-10-08','14000.00','','2021-10-08 15:10:31','2021-10-08 15:10:31');
INSERT INTO student_payments VALUES('601','1','492','2021-10-08','13000.00','','2021-10-08 16:40:50','2021-10-08 16:40:50');
INSERT INTO student_payments VALUES('602','1','514','2021-10-09','12560.00','','2021-10-09 18:45:28','2021-10-09 18:45:28');
INSERT INTO student_payments VALUES('603','1','506','2021-10-09','14000.00','','2021-10-09 18:56:22','2021-10-09 18:56:22');
INSERT INTO student_payments VALUES('604','1','292','2021-10-09','1000.00','','2021-10-09 18:59:57','2021-10-09 18:59:57');
INSERT INTO student_payments VALUES('605','1','507','2021-10-09','14000.00','','2021-10-09 19:00:35','2021-10-09 19:00:35');
INSERT INTO student_payments VALUES('606','1','435','2021-10-09','1000.00','','2021-10-09 19:02:26','2021-10-09 19:02:26');
INSERT INTO student_payments VALUES('607','1','569','2021-10-09','15000.00','','2021-10-09 19:03:23','2021-10-09 19:03:23');
INSERT INTO student_payments VALUES('608','1','595','2021-10-09','34000.00','','2021-10-09 19:16:45','2021-10-09 19:16:45');
INSERT INTO student_payments VALUES('609','1','504','2021-10-09','20000.00','','2021-10-09 19:26:05','2021-10-09 19:26:05');
INSERT INTO student_payments VALUES('610','1','503','2021-10-09','20000.00','','2021-10-09 19:26:44','2021-10-09 19:26:44');
INSERT INTO student_payments VALUES('611','1','598','2021-10-09','14000.00','','2021-10-09 19:35:49','2021-10-09 19:35:49');
INSERT INTO student_payments VALUES('612','1','543','2021-10-09','14000.00','','2021-10-09 19:36:24','2021-10-09 19:36:24');
INSERT INTO student_payments VALUES('613','1','579','2021-10-09','17000.00','','2021-10-09 19:39:02','2021-10-09 19:39:02');
INSERT INTO student_payments VALUES('614','1','573','2021-10-09','16000.00','','2021-10-09 19:46:13','2021-10-09 19:46:13');
INSERT INTO student_payments VALUES('615','1','573','2021-10-09','1000.00','','2021-10-09 19:50:40','2021-10-09 19:50:40');
INSERT INTO student_payments VALUES('616','1','558','2021-10-09','14000.00','','2021-10-09 20:03:12','2021-10-09 20:03:12');
INSERT INTO student_payments VALUES('617','1','599','2021-10-09','27000.00','','2021-10-09 20:08:49','2021-10-09 20:08:49');
INSERT INTO student_payments VALUES('618','1','600','2021-10-09','13000.00','','2021-10-09 21:41:36','2021-10-09 21:41:36');
INSERT INTO student_payments VALUES('619','1','12','2021-10-09','4000.00','','2021-10-09 21:42:07','2021-10-09 21:42:07');
INSERT INTO student_payments VALUES('620','1','587','2021-10-09','20500.00','','2021-10-09 21:47:17','2021-10-09 21:47:17');
INSERT INTO student_payments VALUES('621','1','465','2021-10-10','14000.00','','2021-10-10 19:04:15','2021-10-10 19:04:15');
INSERT INTO student_payments VALUES('622','1','564','2021-10-10','12000.00','','2021-10-10 19:05:26','2021-10-10 19:05:26');
INSERT INTO student_payments VALUES('623','1','602','2021-10-10','44000.00','','2021-10-10 21:32:13','2021-10-10 21:32:13');
INSERT INTO student_payments VALUES('624','1','601','2021-10-10','44000.00','','2021-10-10 21:33:35','2021-10-10 21:33:35');
INSERT INTO student_payments VALUES('625','1','519','2021-10-11','22590.00','','2021-10-11 16:35:20','2021-10-11 16:35:20');
INSERT INTO student_payments VALUES('626','1','400','2021-10-11','8375.00','','2021-10-11 16:37:32','2021-10-11 16:37:32');
INSERT INTO student_payments VALUES('627','1','510','2021-10-11','11625.00','','2021-10-11 16:38:56','2021-10-11 16:38:56');
INSERT INTO student_payments VALUES('628','1','603','2021-10-11','29500.00','','2021-10-11 17:11:14','2021-10-11 17:11:14');
INSERT INTO student_payments VALUES('629','1','442','2021-10-11','7750.00','','2021-10-11 17:36:15','2021-10-11 17:36:15');
INSERT INTO student_payments VALUES('630','1','544','2021-10-11','6750.00','','2021-10-11 17:38:04','2021-10-11 17:38:04');
INSERT INTO student_payments VALUES('631','1','552','2021-10-11','20000.00','','2021-10-11 17:39:46','2021-10-11 17:39:46');
INSERT INTO student_payments VALUES('632','1','502','2021-10-12','18000.00','','2021-10-12 20:39:35','2021-10-12 20:39:35');
INSERT INTO student_payments VALUES('633','1','559','2021-10-12','14000.00','','2021-10-12 20:50:04','2021-10-12 20:50:04');
INSERT INTO student_payments VALUES('634','1','427','2021-10-11','8000.00','','2021-10-12 20:53:44','2021-10-12 20:53:44');
INSERT INTO student_payments VALUES('635','1','531','2021-10-12','1000.00','','2021-10-12 20:54:40','2021-10-12 20:54:40');
INSERT INTO student_payments VALUES('636','1','597','2021-10-12','14000.00','','2021-10-12 20:56:40','2021-10-12 20:56:40');
INSERT INTO student_payments VALUES('637','1','508','2021-10-12','15000.00','','2021-10-12 20:59:56','2021-10-12 20:59:56');
INSERT INTO student_payments VALUES('638','1','604','2021-10-13','1000.00','','2021-10-13 16:16:20','2021-10-13 16:16:20');
INSERT INTO student_payments VALUES('639','1','585','2021-10-13','23500.00','','2021-10-13 16:16:52','2021-10-13 16:16:52');
INSERT INTO student_payments VALUES('640','1','534','2021-10-13','19825.00','','2021-10-13 16:29:43','2021-10-13 16:29:43');
INSERT INTO student_payments VALUES('641','1','605','2021-10-13','27200.00','','2021-10-13 16:37:24','2021-10-13 16:37:24');
INSERT INTO student_payments VALUES('642','1','566','2021-10-13','17000.00','','2021-10-13 18:57:28','2021-10-13 18:57:28');
INSERT INTO student_payments VALUES('643','1','606','2021-10-13','10800.00','','2021-10-13 19:34:07','2021-10-13 19:34:07');
INSERT INTO student_payments VALUES('644','1','548','2021-10-13','18000.00','','2021-10-13 20:54:45','2021-10-13 20:54:45');
INSERT INTO student_payments VALUES('645','1','607','2021-10-14','19000.00','','2021-10-14 18:46:37','2021-10-14 18:46:37');
INSERT INTO student_payments VALUES('646','1','510','2021-10-14','5745.00','','2021-10-14 22:22:52','2021-10-14 22:22:52');
INSERT INTO student_payments VALUES('647','1','556','2021-10-14','15000.00','','2021-10-14 22:50:38','2021-10-14 22:50:38');
INSERT INTO student_payments VALUES('648','1','457','2021-10-14','6000.00','','2021-10-14 22:51:11','2021-10-14 22:51:11');
INSERT INTO student_payments VALUES('649','1','358','2021-10-14','3000.00','','2021-10-14 22:51:46','2021-10-14 22:51:46');
INSERT INTO student_payments VALUES('650','1','560','2021-10-14','14000.00','','2021-10-14 23:24:24','2021-10-14 23:24:24');
INSERT INTO student_payments VALUES('651','1','327','2021-10-20','830.00','','2021-10-20 17:06:46','2021-10-20 17:06:46');
INSERT INTO student_payments VALUES('652','1','531','2021-10-20','7470.00','','2021-10-20 17:07:21','2021-10-20 17:07:21');
INSERT INTO student_payments VALUES('653','1','530','2021-10-20','12000.00','','2021-10-20 17:34:50','2021-10-20 17:34:50');
INSERT INTO student_payments VALUES('654','1','499','2021-10-20','10000.00','','2021-10-20 17:35:30','2021-10-20 17:35:30');
INSERT INTO student_payments VALUES('655','1','526','2021-10-20','18120.00','','2021-10-20 20:18:42','2021-10-20 20:18:42');
INSERT INTO student_payments VALUES('656','1','552','2021-10-20','260.00','','2021-10-20 20:53:05','2021-10-20 20:53:05');
INSERT INTO student_payments VALUES('657','1','410','2021-10-22','1000.00','','2021-10-22 17:53:44','2021-10-22 17:53:44');
INSERT INTO student_payments VALUES('658','1','518','2021-10-22','13000.00','','2021-10-22 17:54:20','2021-10-22 17:54:20');
INSERT INTO student_payments VALUES('659','1','521','2021-10-22','5090.00','','2021-10-22 17:55:15','2021-10-22 17:55:15');
INSERT INTO student_payments VALUES('660','1','608','2021-10-22','1000.00','','2021-10-22 17:57:20','2021-10-22 17:57:20');
INSERT INTO student_payments VALUES('661','1','508','2021-10-22','2000.00','','2021-10-22 17:59:56','2021-10-22 17:59:56');
INSERT INTO student_payments VALUES('662','1','555','2021-10-22','1000.00','','2021-10-22 18:46:41','2021-10-22 18:46:41');
INSERT INTO student_payments VALUES('663','1','594','2021-10-25','3000.00','','2021-10-25 16:43:41','2021-10-25 16:43:41');
INSERT INTO student_payments VALUES('664','1','1','2021-10-25','9000.00','EHSAN SEC 9000','2021-10-25 20:48:26','2021-10-25 20:48:26');
INSERT INTO student_payments VALUES('665','1','609','2021-10-25','14000.00','','2021-10-25 20:49:05','2021-10-25 20:49:05');
INSERT INTO student_payments VALUES('666','1','110','2021-10-31','3000.00','extra seat','2021-11-01 17:38:32','2021-11-01 17:38:32');
INSERT INTO student_payments VALUES('667','1','307','2021-10-31','2145.00','','2021-11-01 17:39:26','2021-11-01 17:39:26');
INSERT INTO student_payments VALUES('668','1','385','2021-10-31','15000.00','','2021-11-01 17:43:48','2021-11-01 17:43:48');
INSERT INTO student_payments VALUES('669','1','477','2021-10-31','3000.00','','2021-11-01 18:03:11','2021-11-01 18:03:11');
INSERT INTO student_payments VALUES('670','1','610','2021-10-31','9800.00','','2021-11-01 18:03:33','2021-11-01 18:03:33');
INSERT INTO student_payments VALUES('671','1','572','2021-10-31','3700.00','','2021-11-01 18:03:58','2021-11-01 18:03:58');
INSERT INTO student_payments VALUES('672','1','611','2021-10-31','6500.00','','2021-11-01 18:10:03','2021-11-01 18:10:03');
INSERT INTO student_payments VALUES('673','1','370','2021-10-31','9000.00','','2021-11-01 18:10:29','2021-11-01 18:10:29');
INSERT INTO student_payments VALUES('674','1','711','2021-11-01','16500.00','','2021-11-01 20:03:43','2021-11-01 20:03:43');
INSERT INTO student_payments VALUES('675','1','694','2021-11-01','17500.00','','2021-11-01 20:05:00','2021-11-01 20:05:00');
INSERT INTO student_payments VALUES('676','1','616','2021-11-01','24000.00','','2021-11-01 20:05:42','2021-11-01 20:05:42');
INSERT INTO student_payments VALUES('677','1','557','2021-11-01','500.00','','2021-11-01 20:08:35','2021-11-01 20:08:35');
INSERT INTO student_payments VALUES('678','1','684','2021-11-01','15000.00','','2021-11-01 20:09:21','2021-11-01 20:09:21');
INSERT INTO student_payments VALUES('679','1','709','2021-11-01','19000.00','','2021-11-01 20:19:54','2021-11-01 20:19:54');
INSERT INTO student_payments VALUES('680','1','706','2021-11-01','15000.00','','2021-11-01 20:30:33','2021-11-01 20:30:33');
INSERT INTO student_payments VALUES('681','1','536','2021-11-01','5000.00','','2021-11-01 20:59:25','2021-11-01 20:59:25');
INSERT INTO student_payments VALUES('682','1','661','2021-11-01','17000.00','','2021-11-01 21:00:22','2021-11-01 21:00:22');
INSERT INTO student_payments VALUES('683','1','619','2021-11-01','18000.00','','2021-11-01 21:30:37','2021-11-01 21:30:37');
INSERT INTO student_payments VALUES('684','1','674','2021-11-01','18000.00','','2021-11-01 21:33:25','2021-11-01 21:33:25');
INSERT INTO student_payments VALUES('685','1','665','2021-11-01','15500.00','','2021-11-01 21:40:52','2021-11-01 21:40:52');
INSERT INTO student_payments VALUES('686','1','648','2021-11-02','17000.00','','2021-11-02 17:27:53','2021-11-02 17:27:53');
INSERT INTO student_payments VALUES('687','1','714','2021-11-02','17500.00','','2021-11-02 17:46:18','2021-11-02 17:46:18');
INSERT INTO student_payments VALUES('688','1','728','2021-11-02','15500.00','','2021-11-02 17:50:36','2021-11-02 17:50:36');
INSERT INTO student_payments VALUES('689','1','675','2021-11-02','17000.00','','2021-11-02 19:45:02','2021-11-02 19:45:02');
INSERT INTO student_payments VALUES('690','1','659','2021-11-02','17000.00','','2021-11-02 19:48:03','2021-11-02 19:48:03');
INSERT INTO student_payments VALUES('691','1','618','2021-11-02','32000.00','','2021-11-02 19:51:49','2021-11-02 19:51:49');
INSERT INTO student_payments VALUES('692','1','732','2021-11-02','10000.00','','2021-11-02 20:18:54','2021-11-02 20:18:54');
INSERT INTO student_payments VALUES('693','1','731','2021-11-02','10000.00','','2021-11-02 20:20:30','2021-11-02 20:20:30');
INSERT INTO student_payments VALUES('694','1','730','2021-11-02','10000.00','','2021-11-02 20:21:10','2021-11-02 20:21:10');
INSERT INTO student_payments VALUES('695','1','671','2021-11-02','14000.00','','2021-11-02 21:21:19','2021-11-02 21:21:19');
INSERT INTO student_payments VALUES('696','1','651','2021-11-02','17000.00','','2021-11-02 22:23:47','2021-11-02 22:23:47');
INSERT INTO student_payments VALUES('697','1','700','2021-11-03','15000.00','','2021-11-03 18:36:19','2021-11-03 18:36:19');
INSERT INTO student_payments VALUES('698','1','707','2021-11-03','21000.00','','2021-11-03 18:38:40','2021-11-03 18:38:40');
INSERT INTO student_payments VALUES('699','1','639','2021-11-03','17000.00','','2021-11-03 18:42:28','2021-11-03 18:42:28');
INSERT INTO student_payments VALUES('700','1','689','2021-11-03','15500.00','','2021-11-03 20:04:16','2021-11-03 20:04:16');
INSERT INTO student_payments VALUES('701','1','705','2021-11-03','17000.00','','2021-11-03 20:32:56','2021-11-03 20:32:56');
INSERT INTO student_payments VALUES('702','1','641','2021-11-03','16000.00','','2021-11-03 21:20:18','2021-11-03 21:20:18');
INSERT INTO student_payments VALUES('703','1','516','2021-11-03','520.00','','2021-11-03 21:21:15','2021-11-03 21:21:15');
INSERT INTO student_payments VALUES('704','1','407','2021-11-03','480.00','','2021-11-03 21:22:07','2021-11-03 21:22:07');
INSERT INTO student_payments VALUES('705','1','613','2021-11-03','10000.00','','2021-11-03 21:46:42','2021-11-03 21:46:42');
INSERT INTO student_payments VALUES('706','1','692','2021-11-04','14000.00','','2021-11-04 19:46:19','2021-11-04 19:46:19');
INSERT INTO student_payments VALUES('707','1','657','2021-11-04','16000.00','','2021-11-04 19:49:34','2021-11-04 19:49:34');
INSERT INTO student_payments VALUES('708','1','686','2021-11-04','14000.00','','2021-11-04 19:53:26','2021-11-04 19:53:26');
INSERT INTO student_payments VALUES('709','1','676','2021-11-04','17000.00','','2021-11-04 19:56:26','2021-11-04 19:56:26');
INSERT INTO student_payments VALUES('710','1','710','2021-11-04','17500.00','','2021-11-04 19:57:54','2021-11-04 19:57:54');
INSERT INTO student_payments VALUES('711','1','650','2021-11-04','17000.00','','2021-11-04 20:30:22','2021-11-04 20:30:22');
INSERT INTO student_payments VALUES('712','1','717','2021-11-04','21000.00','','2021-11-04 20:37:54','2021-11-04 20:37:54');
INSERT INTO student_payments VALUES('713','1','642','2021-11-04','16000.00','','2021-11-04 21:06:03','2021-11-04 21:06:03');
INSERT INTO student_payments VALUES('714','1','615','2021-11-05','14000.00','','2021-11-05 20:25:16','2021-11-05 20:25:16');
INSERT INTO student_payments VALUES('715','1','672','2021-11-05','16500.00','','2021-11-05 20:45:40','2021-11-05 20:45:40');
INSERT INTO student_payments VALUES('716','1','612','2021-11-05','17000.00','','2021-11-05 20:46:21','2021-11-05 20:46:21');
INSERT INTO student_payments VALUES('717','1','646','2021-11-05','17500.00','','2021-11-05 21:03:01','2021-11-05 21:03:01');
INSERT INTO student_payments VALUES('718','1','645','2021-11-05','17500.00','','2021-11-05 21:03:47','2021-11-05 21:03:47');
INSERT INTO student_payments VALUES('719','1','621','2021-11-05','17000.00','','2021-11-05 22:06:34','2021-11-05 22:06:34');
INSERT INTO student_payments VALUES('720','1','691','2021-11-05','17000.00','','2021-11-05 22:08:43','2021-11-05 22:08:43');
INSERT INTO student_payments VALUES('721','1','721','2021-11-05','16170.00','','2021-11-05 22:16:26','2021-11-05 22:16:26');
INSERT INTO student_payments VALUES('722','1','315','2021-11-07','10000.00','sec adjustment','2021-11-07 14:14:18','2021-11-07 14:14:18');
INSERT INTO student_payments VALUES('723','1','649','2021-11-07','9000.00','','2021-11-07 14:16:51','2021-11-07 14:16:51');
INSERT INTO student_payments VALUES('724','1','622','2021-11-06','17000.00','','2021-11-07 14:20:26','2021-11-07 14:20:26');
INSERT INTO student_payments VALUES('725','1','635','2021-11-07','15500.00','','2021-11-07 14:21:08','2021-11-07 14:21:08');
INSERT INTO student_payments VALUES('726','1','685','2021-11-06','14000.00','','2021-11-07 14:21:50','2021-11-07 14:21:50');
INSERT INTO student_payments VALUES('727','1','733','2021-11-07','6000.00','','2021-11-07 14:25:43','2021-11-07 14:25:43');
INSERT INTO student_payments VALUES('728','1','627','2021-11-07','20000.00','','2021-11-07 14:26:25','2021-11-07 14:26:25');
INSERT INTO student_payments VALUES('729','1','728','2021-11-07','14500.00','','2021-11-07 14:30:56','2021-11-07 14:30:56');
INSERT INTO student_payments VALUES('730','1','730','2021-11-07','15500.00','','2021-11-07 14:31:50','2021-11-07 14:31:50');
INSERT INTO student_payments VALUES('731','1','720','2021-11-07','18000.00','','2021-11-07 14:32:35','2021-11-07 14:32:35');
INSERT INTO student_payments VALUES('732','1','726','2021-11-07','17000.00','','2021-11-07 14:34:09','2021-11-07 14:34:09');
INSERT INTO student_payments VALUES('733','1','630','2021-11-07','14000.00','','2021-11-07 14:36:56','2021-11-07 14:36:56');
INSERT INTO student_payments VALUES('734','1','625','2021-11-07','14000.00','','2021-11-07 14:37:48','2021-11-07 14:37:48');
INSERT INTO student_payments VALUES('735','1','656','2021-11-07','16000.00','','2021-11-07 14:57:08','2021-11-07 14:57:08');
INSERT INTO student_payments VALUES('736','1','628','2021-11-07','10000.00','','2021-11-07 15:00:06','2021-11-07 15:00:06');
INSERT INTO student_payments VALUES('737','1','636','2021-11-07','16000.00','','2021-11-07 15:47:06','2021-11-07 15:47:06');
INSERT INTO student_payments VALUES('738','1','663','2021-11-07','14000.00','','2021-11-07 16:02:06','2021-11-07 16:02:06');
INSERT INTO student_payments VALUES('739','1','629','2021-11-07','14000.00','','2021-11-07 16:27:18','2021-11-07 16:27:18');
INSERT INTO student_payments VALUES('740','1','719','2021-11-07','17000.00','','2021-11-07 18:21:46','2021-11-07 18:21:46');
INSERT INTO student_payments VALUES('741','1','577','2021-11-07','3000.00','','2021-11-07 18:29:25','2021-11-07 18:29:25');
INSERT INTO student_payments VALUES('742','1','624','2021-11-07','17000.00','','2021-11-07 19:25:53','2021-11-07 19:25:53');
INSERT INTO student_payments VALUES('743','1','696','2021-11-07','17000.00','','2021-11-07 20:10:37','2021-11-07 20:10:37');
INSERT INTO student_payments VALUES('744','1','697','2021-11-07','17000.00','','2021-11-07 20:11:23','2021-11-07 20:11:23');
INSERT INTO student_payments VALUES('745','1','703','2021-11-07','17000.00','','2021-11-07 20:21:53','2021-11-07 20:21:53');
INSERT INTO student_payments VALUES('746','1','702','2021-11-07','17000.00','','2021-11-07 21:41:35','2021-11-07 21:41:35');
INSERT INTO student_payments VALUES('747','1','667','2021-11-07','14500.00','','2021-11-07 21:49:50','2021-11-07 21:49:50');
INSERT INTO student_payments VALUES('748','1','666','2021-11-07','17000.00','','2021-11-07 22:14:30','2021-11-07 22:14:30');
INSERT INTO student_payments VALUES('749','1','699','2021-11-06','22000.00','','2021-11-08 17:30:05','2021-11-08 17:30:05');
INSERT INTO student_payments VALUES('750','1','623','2021-11-08','17000.00','','2021-11-08 17:31:52','2021-11-08 17:31:52');
INSERT INTO student_payments VALUES('751','1','678','2021-11-08','17000.00','','2021-11-08 17:33:04','2021-11-08 17:33:04');
INSERT INTO student_payments VALUES('752','1','723','2021-11-08','22000.00','','2021-11-08 17:40:05','2021-11-08 17:40:05');
INSERT INTO student_payments VALUES('753','1','693','2021-11-08','24000.00','','2021-11-08 17:42:09','2021-11-08 17:42:09');
INSERT INTO student_payments VALUES('754','1','406','2021-11-08','2510.00','','2021-11-08 17:44:58','2021-11-08 17:44:58');
INSERT INTO student_payments VALUES('755','1','640','2021-11-08','17000.00','','2021-11-08 17:45:57','2021-11-08 17:45:57');
INSERT INTO student_payments VALUES('756','1','725','2021-11-08','22000.00','','2021-11-08 17:50:33','2021-11-08 17:50:33');
INSERT INTO student_payments VALUES('757','1','728','2021-11-08','1000.00','','2021-11-08 17:53:02','2021-11-08 17:53:02');
INSERT INTO student_payments VALUES('758','1','638','2021-11-08','16000.00','','2021-11-08 18:06:15','2021-11-08 18:06:15');
INSERT INTO student_payments VALUES('759','1','687','2021-11-08','14500.00','','2021-11-08 18:25:15','2021-11-08 18:25:15');
INSERT INTO student_payments VALUES('760','1','668','2021-11-08','14500.00','','2021-11-08 18:33:17','2021-11-08 18:33:17');
INSERT INTO student_payments VALUES('761','1','681','2021-11-08','15000.00','','2021-11-08 18:43:18','2021-11-08 18:43:18');
INSERT INTO student_payments VALUES('1441','1','1308','2022-04-19','500.00','','2022-04-20 15:59:25','2022-04-20 15:59:25');
INSERT INTO student_payments VALUES('763','1','634','2021-11-08','15500.00','','2021-11-08 20:09:56','2021-11-08 20:09:56');
INSERT INTO student_payments VALUES('764','1','718','2021-11-08','17000.00','','2021-11-08 20:44:30','2021-11-08 20:44:30');
INSERT INTO student_payments VALUES('765','1','470','2021-11-08','5000.00','','2021-11-08 20:55:19','2021-11-08 20:55:19');
INSERT INTO student_payments VALUES('766','1','698','2021-11-08','15000.00','','2021-11-08 20:55:59','2021-11-08 20:55:59');
INSERT INTO student_payments VALUES('767','1','655','2021-11-08','22000.00','','2021-11-08 21:21:42','2021-11-08 21:21:42');
INSERT INTO student_payments VALUES('768','1','628','2021-11-09','10000.00','','2021-11-09 17:28:56','2021-11-09 17:28:56');
INSERT INTO student_payments VALUES('769','1','677','2021-11-09','17000.00','','2021-11-09 17:31:13','2021-11-09 17:31:13');
INSERT INTO student_payments VALUES('770','1','662','2021-11-09','15000.00','','2021-11-09 17:45:26','2021-11-09 17:45:26');
INSERT INTO student_payments VALUES('771','1','704','2021-11-09','14000.00','','2021-11-09 18:24:12','2021-11-09 18:24:12');
INSERT INTO student_payments VALUES('772','1','643','2021-11-09','13000.00','','2021-11-09 18:24:46','2021-11-09 18:24:46');
INSERT INTO student_payments VALUES('773','1','644','2021-11-09','17500.00','','2021-11-09 18:33:32','2021-11-09 18:33:32');
INSERT INTO student_payments VALUES('774','1','637','2021-11-09','16000.00','','2021-11-09 19:33:00','2021-11-09 19:33:00');
INSERT INTO student_payments VALUES('775','1','722','2021-11-09','17000.00','','2021-11-09 19:54:24','2021-11-09 19:54:24');
INSERT INTO student_payments VALUES('776','1','626','2021-11-09','19000.00','','2021-11-09 20:17:19','2021-11-09 20:17:19');
INSERT INTO student_payments VALUES('777','1','502','2021-11-09','1000.00','','2021-11-09 20:18:01','2021-11-09 20:18:01');
INSERT INTO student_payments VALUES('778','1','599','2021-11-09','9000.00','','2021-11-09 20:38:38','2021-11-09 20:38:38');
INSERT INTO student_payments VALUES('779','1','617','2021-11-09','17000.00','','2021-11-09 20:39:10','2021-11-09 20:39:10');
INSERT INTO student_payments VALUES('780','1','713','2021-11-10','18000.00','','2021-11-10 17:37:41','2021-11-10 17:37:41');
INSERT INTO student_payments VALUES('781','1','584','2021-11-10','5000.00','','2021-11-10 17:38:25','2021-11-10 17:38:25');
INSERT INTO student_payments VALUES('782','1','660','2021-11-10','17500.00','','2021-11-10 17:38:56','2021-11-10 17:38:56');
INSERT INTO student_payments VALUES('783','1','715','2021-11-10','17500.00','','2021-11-10 18:14:15','2021-11-10 18:14:15');
INSERT INTO student_payments VALUES('784','1','712','2021-11-10','17500.00','','2021-11-10 18:14:51','2021-11-10 18:14:51');
INSERT INTO student_payments VALUES('785','1','734','2021-11-10','15500.00','','2021-11-10 18:29:15','2021-11-10 18:29:15');
INSERT INTO student_payments VALUES('786','1','647','2021-11-10','17500.00','','2021-11-10 18:38:05','2021-11-10 18:38:05');
INSERT INTO student_payments VALUES('787','1','735','2021-11-10','2980.00','','2021-11-10 18:40:19','2021-11-10 18:40:19');
INSERT INTO student_payments VALUES('788','1','632','2021-11-10','14630.00','','2021-11-10 18:42:51','2021-11-10 18:42:51');
INSERT INTO student_payments VALUES('789','1','508','2021-11-10','370.00','','2021-11-10 18:43:34','2021-11-10 18:43:34');
INSERT INTO student_payments VALUES('790','1','633','2021-11-10','15500.00','','2021-11-10 20:10:50','2021-11-10 20:10:50');
INSERT INTO student_payments VALUES('791','1','509','2021-11-10','245.00','','2021-11-10 20:11:24','2021-11-10 20:11:24');
INSERT INTO student_payments VALUES('792','1','683','2021-11-10','15500.00','','2021-11-10 20:11:59','2021-11-10 20:11:59');
INSERT INTO student_payments VALUES('793','1','688','2021-11-10','19000.00','','2021-11-10 20:41:00','2021-11-10 20:41:00');
INSERT INTO student_payments VALUES('794','1','708','2021-11-11','17000.00','','2021-11-11 18:38:00','2021-11-11 18:38:00');
INSERT INTO student_payments VALUES('795','1','724','2021-11-11','14500.00','','2021-11-11 18:43:52','2021-11-11 18:43:52');
INSERT INTO student_payments VALUES('796','1','652','2021-11-11','12000.00','','2021-11-11 18:52:00','2021-11-11 18:52:00');
INSERT INTO student_payments VALUES('797','1','737','2021-11-11','10300.00','','2021-11-11 19:02:10','2021-11-11 19:02:10');
INSERT INTO student_payments VALUES('798','1','731','2021-11-12','15500.00','','2021-11-12 17:59:46','2021-11-12 17:59:46');
INSERT INTO student_payments VALUES('799','1','631','2021-11-12','14000.00','','2021-11-12 18:10:44','2021-11-12 18:10:44');
INSERT INTO student_payments VALUES('800','1','701','2021-11-12','19500.00','','2021-11-12 18:13:13','2021-11-12 18:13:13');
INSERT INTO student_payments VALUES('801','1','716','2021-11-12','15500.00','','2021-11-12 18:24:41','2021-11-12 18:24:41');
INSERT INTO student_payments VALUES('802','1','729','2021-11-12','15500.00','','2021-11-12 19:51:01','2021-11-12 19:51:01');
INSERT INTO student_payments VALUES('803','1','682','2021-11-12','15000.00','','2021-11-12 20:00:12','2021-11-12 20:00:12');
INSERT INTO student_payments VALUES('804','1','664','2021-11-15','15500.00','','2021-11-15 18:18:06','2021-11-15 18:18:06');
INSERT INTO student_payments VALUES('805','1','695','2021-11-15','17000.00','','2021-11-15 18:19:20','2021-11-15 18:19:20');
INSERT INTO student_payments VALUES('806','1','614','2021-11-15','14000.00','','2021-11-15 18:20:26','2021-11-15 18:20:26');
INSERT INTO student_payments VALUES('807','1','736','2021-11-15','14500.00','','2021-11-15 18:21:48','2021-11-15 18:21:48');
INSERT INTO student_payments VALUES('808','1','680','2021-11-15','18000.00','','2021-11-15 20:01:38','2021-11-15 20:01:38');
INSERT INTO student_payments VALUES('809','1','721','2021-11-17','830.00','','2021-11-17 18:43:10','2021-11-17 18:43:10');
INSERT INTO student_payments VALUES('810','1','654','2021-11-17','13000.00','','2021-11-17 18:43:52','2021-11-17 18:43:52');
INSERT INTO student_payments VALUES('811','1','653','2021-11-17','10000.00','','2021-11-17 18:44:33','2021-11-17 18:44:33');
INSERT INTO student_payments VALUES('812','1','547','2021-11-19','18000.00','','2021-11-19 17:20:54','2021-11-19 17:20:54');
INSERT INTO student_payments VALUES('813','1','496','2021-11-19','20000.00','','2021-11-19 17:33:08','2021-11-19 17:33:08');
INSERT INTO student_payments VALUES('814','1','620','2021-11-19','18000.00','','2021-11-19 17:33:48','2021-11-19 17:33:48');
INSERT INTO student_payments VALUES('815','1','544','2021-11-11','8750.00','','2021-11-19 17:37:55','2021-11-19 17:37:55');
INSERT INTO student_payments VALUES('816','1','620','2021-11-21','2000.00','','2021-11-21 20:43:17','2021-11-21 20:43:17');
INSERT INTO student_payments VALUES('817','1','669','2021-11-22','5000.00','','2021-11-22 20:25:25','2021-11-22 20:25:25');
INSERT INTO student_payments VALUES('818','1','669','2021-11-24','9500.00','','2021-11-27 18:57:53','2021-11-27 18:57:53');
INSERT INTO student_payments VALUES('819','1','783','2021-12-01','16000.00','','2021-12-01 19:50:00','2021-12-01 19:50:00');
INSERT INTO student_payments VALUES('820','1','807','2021-12-01','15000.00','','2021-12-01 20:06:47','2021-12-01 20:06:47');
INSERT INTO student_payments VALUES('821','1','742','2021-12-01','24000.00','','2021-12-01 20:48:44','2021-12-01 20:48:44');
INSERT INTO student_payments VALUES('822','1','800','2021-12-02','17000.00','','2021-12-02 17:54:09','2021-12-02 17:54:09');
INSERT INTO student_payments VALUES('823','1','790','2021-12-02','15500.00','','2021-12-02 17:54:58','2021-12-02 17:54:58');
INSERT INTO student_payments VALUES('824','1','829','2021-12-02','14000.00','','2021-12-02 17:59:28','2021-12-02 17:59:28');
INSERT INTO student_payments VALUES('825','1','778','2021-12-02','13000.00','','2021-12-02 18:08:33','2021-12-02 18:08:33');
INSERT INTO student_payments VALUES('826','1','774','2021-12-02','17000.00','','2021-12-02 21:10:07','2021-12-02 21:10:07');
INSERT INTO student_payments VALUES('827','1','833','2021-12-03','17500.00','','2021-12-03 17:18:07','2021-12-03 17:18:07');
INSERT INTO student_payments VALUES('828','1','777','2021-12-03','17000.00','','2021-12-03 17:28:41','2021-12-03 17:28:41');
INSERT INTO student_payments VALUES('829','1','779','2021-12-03','13000.00','','2021-12-03 20:04:33','2021-12-03 20:04:33');
INSERT INTO student_payments VALUES('830','1','653','2021-12-03','3000.00','','2021-12-03 20:05:05','2021-12-03 20:05:05');
INSERT INTO student_payments VALUES('831','1','762','2021-12-03','16000.00','','2021-12-03 20:53:52','2021-12-03 20:53:52');
INSERT INTO student_payments VALUES('832','1','815','2021-12-03','10000.00','','2021-12-03 20:55:27','2021-12-03 20:55:27');
INSERT INTO student_payments VALUES('833','1','767','2021-12-03','16000.00','','2021-12-03 21:00:00','2021-12-03 21:00:00');
INSERT INTO student_payments VALUES('834','1','741','2021-12-03','14000.00','','2021-12-03 21:15:12','2021-12-03 21:15:12');
INSERT INTO student_payments VALUES('835','1','821','2021-12-06','15000.00','','2021-12-06 16:41:08','2021-12-06 16:41:08');
INSERT INTO student_payments VALUES('836','1','738','2021-12-06','17000.00','','2021-12-06 16:43:19','2021-12-06 16:43:19');
INSERT INTO student_payments VALUES('837','1','840','2021-12-06','21000.00','','2021-12-06 16:44:30','2021-12-06 16:44:30');
INSERT INTO student_payments VALUES('838','1','830','2021-12-06','21000.00','','2021-12-06 16:45:40','2021-12-06 16:45:40');
INSERT INTO student_payments VALUES('839','1','776','2021-12-06','17000.00','','2021-12-06 16:46:21','2021-12-06 16:46:21');
INSERT INTO student_payments VALUES('840','1','834','2021-12-06','17000.00','','2021-12-06 16:47:18','2021-12-06 16:47:18');
INSERT INTO student_payments VALUES('841','1','828','2021-12-04','17000.00','','2021-12-06 16:50:14','2021-12-06 16:50:14');
INSERT INTO student_payments VALUES('842','1','855','2021-12-06','15500.00','','2021-12-06 16:51:10','2021-12-06 16:51:10');
INSERT INTO student_payments VALUES('843','1','832','2021-12-06','19000.00','','2021-12-06 17:05:02','2021-12-06 17:05:02');
INSERT INTO student_payments VALUES('844','1','837','2021-12-06','17500.00','','2021-12-06 17:16:07','2021-12-06 17:16:07');
INSERT INTO student_payments VALUES('845','1','673','2021-12-06','18000.00','','2021-12-06 17:19:28','2021-12-06 17:19:28');
INSERT INTO student_payments VALUES('846','1','797','2021-12-06','7000.00','','2021-12-06 17:20:21','2021-12-06 17:20:21');
INSERT INTO student_payments VALUES('847','1','464','2021-12-06','7000.00','','2021-12-06 17:50:24','2021-12-06 17:50:24');
INSERT INTO student_payments VALUES('848','1','814','2021-12-06','10000.00','','2021-12-06 17:56:38','2021-12-06 17:56:38');
INSERT INTO student_payments VALUES('849','1','761','2021-12-06','15500.00','','2021-12-06 18:55:21','2021-12-06 18:55:21');
INSERT INTO student_payments VALUES('850','1','795','2021-12-02','14000.00','','2021-12-06 18:59:35','2021-12-06 18:59:35');
INSERT INTO student_payments VALUES('851','1','820','2021-12-06','17000.00','','2021-12-06 19:00:11','2021-12-06 19:00:11');
INSERT INTO student_payments VALUES('852','1','754','2021-12-06','20000.00','','2021-12-06 19:32:20','2021-12-06 19:32:20');
INSERT INTO student_payments VALUES('853','1','753','2021-12-06','20000.00','','2021-12-06 19:33:34','2021-12-06 19:33:34');
INSERT INTO student_payments VALUES('854','1','733','2021-12-06','1000.00','','2021-12-06 19:34:18','2021-12-06 19:34:18');
INSERT INTO student_payments VALUES('855','1','812','2021-12-06','15500.00','','2021-12-06 19:39:26','2021-12-06 19:39:26');
INSERT INTO student_payments VALUES('856','1','757','2021-12-06','14000.00','','2021-12-06 19:51:37','2021-12-06 19:51:37');
INSERT INTO student_payments VALUES('857','1','749','2021-12-06','17000.00','','2021-12-06 20:05:46','2021-12-06 20:05:46');
INSERT INTO student_payments VALUES('858','1','850','2021-12-06','17000.00','','2021-12-06 21:01:27','2021-12-06 21:01:27');
INSERT INTO student_payments VALUES('859','1','764','2021-12-07','16000.00','','2021-12-07 16:57:31','2021-12-07 16:57:31');
INSERT INTO student_payments VALUES('860','1','801','2021-12-07','17000.00','','2021-12-07 17:03:08','2021-12-07 17:03:08');
INSERT INTO student_payments VALUES('861','1','769','2021-12-07','14000.00','','2021-12-07 17:04:23','2021-12-07 17:04:23');
INSERT INTO student_payments VALUES('862','1','643','2021-12-07','500.00','','2021-12-07 17:05:06','2021-12-07 17:05:06');
INSERT INTO student_payments VALUES('863','1','798','2021-12-06','18000.00','','2021-12-07 17:19:48','2021-12-07 17:19:48');
INSERT INTO student_payments VALUES('864','1','775','2021-12-07','17000.00','','2021-12-07 17:24:55','2021-12-07 17:24:55');
INSERT INTO student_payments VALUES('865','1','748','2021-12-07','17000.00','','2021-12-07 17:26:17','2021-12-07 17:26:17');
INSERT INTO student_payments VALUES('866','1','788','2021-12-07','14000.00','','2021-12-07 17:27:35','2021-12-07 17:27:35');
INSERT INTO student_payments VALUES('867','1','827','2021-12-07','15000.00','','2021-12-07 17:28:56','2021-12-07 17:28:56');
INSERT INTO student_payments VALUES('868','1','704','2021-12-07','1000.00','','2021-12-07 17:29:41','2021-12-07 17:29:41');
INSERT INTO student_payments VALUES('869','1','839','2021-12-07','15500.00','','2021-12-07 17:37:00','2021-12-07 17:37:00');
INSERT INTO student_payments VALUES('870','1','804','2021-12-04','15000.00','','2021-12-07 17:41:00','2021-12-07 17:41:00');
INSERT INTO student_payments VALUES('871','1','768','2021-12-07','16000.00','','2021-12-07 17:55:12','2021-12-07 17:55:12');
INSERT INTO student_payments VALUES('872','1','791','2021-12-07','17000.00','','2021-12-07 18:23:11','2021-12-07 18:23:11');
INSERT INTO student_payments VALUES('873','1','745','2021-12-07','18000.00','','2021-12-07 18:23:44','2021-12-07 18:23:44');
INSERT INTO student_payments VALUES('874','1','826','2021-12-07','17000.00','','2021-12-07 18:55:43','2021-12-07 18:55:43');
INSERT INTO student_payments VALUES('875','1','808','2021-12-07','14000.00','','2021-12-07 19:20:24','2021-12-07 19:20:24');
INSERT INTO student_payments VALUES('876','1','771','2021-12-07','17500.00','','2021-12-07 19:42:19','2021-12-07 19:42:19');
INSERT INTO student_payments VALUES('877','1','842','2021-12-07','17000.00','','2021-12-07 19:44:48','2021-12-07 19:44:48');
INSERT INTO student_payments VALUES('878','1','817','2021-12-07','17500.00','','2021-12-07 19:59:21','2021-12-07 19:59:21');
INSERT INTO student_payments VALUES('879','1','824','2021-12-07','19500.00','','2021-12-07 20:02:02','2021-12-07 20:02:02');
INSERT INTO student_payments VALUES('880','1','815','2021-12-08','4000.00','','2021-12-08 18:49:58','2021-12-08 18:49:58');
INSERT INTO student_payments VALUES('881','1','785','2021-12-08','17500.00','','2021-12-08 18:50:44','2021-12-08 18:50:44');
INSERT INTO student_payments VALUES('882','1','756','2021-12-08','14000.00','','2021-12-08 18:52:30','2021-12-08 18:52:30');
INSERT INTO student_payments VALUES('883','1','751','2021-12-08','14000.00','','2021-12-08 18:53:17','2021-12-08 18:53:17');
INSERT INTO student_payments VALUES('884','1','755','2021-12-08','14000.00','','2021-12-08 18:54:01','2021-12-08 18:54:01');
INSERT INTO student_payments VALUES('885','1','811','2021-12-08','19000.00','','2021-12-08 18:54:41','2021-12-08 18:54:41');
INSERT INTO student_payments VALUES('886','1','799','2021-12-08','17000.00','','2021-12-08 18:55:47','2021-12-08 18:55:47');
INSERT INTO student_payments VALUES('887','1','773','2021-12-08','17500.00','','2021-12-08 18:56:45','2021-12-08 18:56:45');
INSERT INTO student_payments VALUES('888','1','787','2021-12-09','15000.00','','2021-12-09 17:32:24','2021-12-09 17:32:24');
INSERT INTO student_payments VALUES('889','1','763','2021-12-09','16000.00','','2021-12-09 17:33:04','2021-12-09 17:33:04');
INSERT INTO student_payments VALUES('890','1','803','2021-12-09','18000.00','','2021-12-09 17:34:04','2021-12-09 17:34:04');
INSERT INTO student_payments VALUES('891','1','784','2021-12-09','15000.00','','2021-12-09 17:51:05','2021-12-09 17:51:05');
INSERT INTO student_payments VALUES('892','1','823','2021-12-09','15000.00','','2021-12-09 17:52:34','2021-12-09 17:52:34');
INSERT INTO student_payments VALUES('893','1','836','2021-12-09','18000.00','','2021-12-09 18:10:38','2021-12-09 18:10:38');
INSERT INTO student_payments VALUES('894','1','584','2021-12-09','3000.00','','2021-12-09 18:11:35','2021-12-09 18:11:35');
INSERT INTO student_payments VALUES('895','1','831','2021-12-09','14000.00','','2021-12-09 18:14:18','2021-12-09 18:14:18');
INSERT INTO student_payments VALUES('896','1','772','2021-12-09','17500.00','','2021-12-09 18:16:34','2021-12-09 18:16:34');
INSERT INTO student_payments VALUES('897','1','752','2021-12-09','19000.00','','2021-12-09 18:29:18','2021-12-09 18:29:18');
INSERT INTO student_payments VALUES('898','1','747','2021-12-09','17000.00','','2021-12-09 18:32:28','2021-12-09 18:32:28');
INSERT INTO student_payments VALUES('899','1','810','2021-12-09','17500.00','','2021-12-09 19:35:47','2021-12-09 19:35:47');
INSERT INTO student_payments VALUES('900','1','760','2021-12-09','15000.00','','2021-12-09 19:40:31','2021-12-09 19:40:31');
INSERT INTO student_payments VALUES('901','1','760','2021-12-09','500.00','','2021-12-09 19:51:46','2021-12-09 19:51:46');
INSERT INTO student_payments VALUES('902','1','586','2021-12-09','6000.00','','2021-12-09 19:57:30','2021-12-09 19:57:30');
INSERT INTO student_payments VALUES('903','1','583','2021-12-09','6000.00','','2021-12-09 19:58:25','2021-12-09 19:58:25');
INSERT INTO student_payments VALUES('904','1','838','2021-12-09','17500.00','','2021-12-09 19:59:05','2021-12-09 19:59:05');
INSERT INTO student_payments VALUES('905','1','835','2021-12-09','17500.00','','2021-12-09 19:59:35','2021-12-09 19:59:35');
INSERT INTO student_payments VALUES('906','1','852','2021-12-09','15500.00','','2021-12-09 20:01:04','2021-12-09 20:01:04');
INSERT INTO student_payments VALUES('907','1','853','2021-12-09','15500.00','','2021-12-09 20:01:38','2021-12-09 20:01:38');
INSERT INTO student_payments VALUES('908','1','851','2021-12-09','15500.00','','2021-12-09 20:08:07','2021-12-09 20:08:07');
INSERT INTO student_payments VALUES('909','1','789','2021-12-09','15500.00','','2021-12-09 20:16:56','2021-12-09 20:16:56');
INSERT INTO student_payments VALUES('910','1','758','2021-12-11','15500.00','','2021-12-11 14:31:27','2021-12-11 14:31:27');
INSERT INTO student_payments VALUES('911','1','750','2021-12-11','17000.00','','2021-12-11 14:32:02','2021-12-11 14:32:02');
INSERT INTO student_payments VALUES('912','1','854','2021-12-11','15500.00','','2021-12-11 14:34:25','2021-12-11 14:34:25');
INSERT INTO student_payments VALUES('913','1','825','2021-12-11','17000.00','','2021-12-11 14:35:50','2021-12-11 14:35:50');
INSERT INTO student_payments VALUES('914','1','782','2021-12-10','16000.00','','2021-12-11 14:37:48','2021-12-11 14:37:48');
INSERT INTO student_payments VALUES('915','1','809','2021-12-12','14000.00','','2021-12-12 16:59:13','2021-12-12 16:59:13');
INSERT INTO student_payments VALUES('916','1','843','2021-12-12','18000.00','','2021-12-12 17:00:40','2021-12-12 17:00:40');
INSERT INTO student_payments VALUES('917','1','841','2021-12-12','17000.00','','2021-12-12 17:01:32','2021-12-12 17:01:32');
INSERT INTO student_payments VALUES('918','1','770','2021-12-12','17500.00','','2021-12-12 17:02:16','2021-12-12 17:02:16');
INSERT INTO student_payments VALUES('919','1','765','2021-12-12','17000.00','','2021-12-12 17:03:22','2021-12-12 17:03:22');
INSERT INTO student_payments VALUES('920','1','609','2021-12-12','2500.00','','2021-12-12 17:04:06','2021-12-12 17:04:06');
INSERT INTO student_payments VALUES('921','1','806','2021-12-12','15500.00','','2021-12-12 17:15:10','2021-12-12 17:15:10');
INSERT INTO student_payments VALUES('922','1','759','2021-12-12','15000.00','','2021-12-12 17:15:56','2021-12-12 17:15:56');
INSERT INTO student_payments VALUES('923','1','845','2021-12-12','17000.00','','2021-12-12 18:09:02','2021-12-12 18:09:02');
INSERT INTO student_payments VALUES('924','1','781','2021-12-12','22000.00','','2021-12-12 18:19:40','2021-12-12 18:19:40');
INSERT INTO student_payments VALUES('925','1','831','2021-12-13','3000.00','','2021-12-13 17:30:42','2021-12-13 17:30:42');
INSERT INTO student_payments VALUES('926','1','740','2021-12-13','14000.00','','2021-12-13 17:31:24','2021-12-13 17:31:24');
INSERT INTO student_payments VALUES('927','1','816','2021-12-13','21000.00','','2021-12-13 17:33:21','2021-12-13 17:33:21');
INSERT INTO student_payments VALUES('928','1','564','2021-12-13','6000.00','','2021-12-13 17:34:02','2021-12-13 17:34:02');
INSERT INTO student_payments VALUES('929','1','848','2021-12-13','17500.00','','2021-12-13 17:47:15','2021-12-13 17:47:15');
INSERT INTO student_payments VALUES('930','1','794','2021-12-13','17500.00','','2021-12-13 17:47:49','2021-12-13 17:47:49');
INSERT INTO student_payments VALUES('931','1','805','2021-12-13','15000.00','','2021-12-13 19:39:07','2021-12-13 19:39:07');
INSERT INTO student_payments VALUES('932','1','784','2021-12-13','2000.00','','2021-12-13 20:04:24','2021-12-13 20:04:24');
INSERT INTO student_payments VALUES('933','1','743','2021-12-13','17000.00','','2021-12-13 21:20:13','2021-12-13 21:20:13');
INSERT INTO student_payments VALUES('934','1','780','2021-12-14','13000.00','','2021-12-14 19:15:33','2021-12-14 19:15:33');
INSERT INTO student_payments VALUES('935','1','739','2021-12-15','10000.00','','2021-12-15 17:38:41','2021-12-15 17:38:41');
INSERT INTO student_payments VALUES('936','1','813','2021-12-15','15500.00','','2021-12-15 17:40:30','2021-12-15 17:40:30');
INSERT INTO student_payments VALUES('937','1','818','2021-12-15','17000.00','','2021-12-15 17:41:19','2021-12-15 17:41:19');
INSERT INTO student_payments VALUES('938','1','802','2021-12-15','17000.00','','2021-12-15 17:43:28','2021-12-15 17:43:28');
INSERT INTO student_payments VALUES('939','1','796','2021-12-14','16500.00','','2021-12-15 17:44:54','2021-12-15 17:44:54');
INSERT INTO student_payments VALUES('940','1','849','2021-12-17','22000.00','','2021-12-17 19:40:17','2021-12-17 19:40:17');
INSERT INTO student_payments VALUES('941','1','822','2021-12-14','9000.00','','2021-12-17 19:52:29','2021-12-17 19:52:29');
INSERT INTO student_payments VALUES('942','1','786','2021-12-23','17000.00','','2021-12-23 17:32:37','2021-12-23 17:32:37');
INSERT INTO student_payments VALUES('943','1','746','2021-12-23','15000.00','','2021-12-23 17:33:33','2021-12-23 17:33:33');
INSERT INTO student_payments VALUES('944','1','846','2021-12-23','18000.00','','2021-12-23 17:35:35','2021-12-23 17:35:35');
INSERT INTO student_payments VALUES('945','1','766','2021-12-23','17000.00','','2021-12-23 17:36:54','2021-12-23 17:36:54');
INSERT INTO student_payments VALUES('946','1','797','2021-12-21','5000.00','','2021-12-24 18:20:00','2021-12-24 18:20:00');
INSERT INTO student_payments VALUES('947','1','744','2021-12-30','32000.00','','2021-12-30 17:35:24','2021-12-30 17:35:24');
INSERT INTO student_payments VALUES('948','1','819','2021-12-30','11000.00','','2021-12-31 18:57:31','2021-12-31 18:57:31');
INSERT INTO student_payments VALUES('949','1','955','2022-01-03','17500.00','','2022-01-03 18:40:59','2022-01-03 18:40:59');
INSERT INTO student_payments VALUES('950','1','909','2022-01-03','17000.00','','2022-01-03 18:41:51','2022-01-03 18:41:51');
INSERT INTO student_payments VALUES('951','1','952','2022-01-03','17000.00','','2022-01-03 18:42:53','2022-01-03 18:42:53');
INSERT INTO student_payments VALUES('952','1','860','2022-01-01','24000.00','','2022-01-03 19:12:29','2022-01-03 19:12:29');
INSERT INTO student_payments VALUES('953','1','743','2022-01-03','500.00','','2022-01-03 19:25:31','2022-01-03 19:25:31');
INSERT INTO student_payments VALUES('954','1','617','2022-01-03','500.00','','2022-01-03 19:26:16','2022-01-03 19:26:16');
INSERT INTO student_payments VALUES('955','1','901','2022-01-03','16000.00','','2022-01-03 19:27:10','2022-01-03 19:27:10');
INSERT INTO student_payments VALUES('956','1','947','2022-01-04','15000.00','','2022-01-04 17:12:07','2022-01-04 17:12:07');
INSERT INTO student_payments VALUES('957','1','956','2022-01-04','17500.00','','2022-01-04 17:41:34','2022-01-04 17:41:34');
INSERT INTO student_payments VALUES('958','1','939','2022-01-04','15000.00','','2022-01-04 17:48:17','2022-01-04 17:48:17');
INSERT INTO student_payments VALUES('959','1','906','2022-01-04','14000.00','','2022-01-04 18:28:35','2022-01-04 18:28:35');
INSERT INTO student_payments VALUES('960','1','892','2022-01-04','17000.00','','2022-01-04 20:11:13','2022-01-04 20:11:13');
INSERT INTO student_payments VALUES('961','1','857','2022-01-04','10000.00','','2022-01-04 20:23:08','2022-01-04 20:23:08');
INSERT INTO student_payments VALUES('962','1','895','2022-01-04','17000.00','','2022-01-04 20:26:11','2022-01-04 20:26:11');
INSERT INTO student_payments VALUES('963','1','880','2022-01-04','16000.00','','2022-01-04 20:30:03','2022-01-04 20:30:03');
INSERT INTO student_payments VALUES('964','1','879','2022-01-04','15500.00','','2022-01-04 20:36:24','2022-01-04 20:36:24');
INSERT INTO student_payments VALUES('965','1','973','2022-01-04','15500.00','','2022-01-04 20:38:40','2022-01-04 20:38:40');
INSERT INTO student_payments VALUES('966','1','974','2022-01-04','500.00','','2022-01-04 20:44:40','2022-01-04 20:44:40');
INSERT INTO student_payments VALUES('967','1','886','2022-01-04','17000.00','','2022-01-04 20:48:10','2022-01-04 20:48:10');
INSERT INTO student_payments VALUES('968','1','870','2022-01-05','19000.00','','2022-01-05 18:17:16','2022-01-05 18:17:16');
INSERT INTO student_payments VALUES('969','1','913','2022-01-05','14000.00','','2022-01-05 18:18:09','2022-01-05 18:18:09');
INSERT INTO student_payments VALUES('970','1','856','2022-01-05','17000.00','','2022-01-05 18:19:42','2022-01-05 18:19:42');
INSERT INTO student_payments VALUES('971','1','878','2022-01-05','15500.00','','2022-01-05 18:21:13','2022-01-05 18:21:13');
INSERT INTO student_payments VALUES('972','1','935','2022-01-05','17500.00','','2022-01-05 19:30:27','2022-01-05 19:30:27');
INSERT INTO student_payments VALUES('973','1','944','2022-01-05','17000.00','','2022-01-05 19:42:51','2022-01-05 19:42:51');
INSERT INTO student_payments VALUES('974','1','946','2022-01-05','17000.00','','2022-01-05 19:51:53','2022-01-05 19:51:53');
INSERT INTO student_payments VALUES('975','1','951','2022-01-05','17500.00','','2022-01-05 20:02:15','2022-01-05 20:02:15');
INSERT INTO student_payments VALUES('976','1','908','2022-01-05','15500.00','','2022-01-05 20:04:28','2022-01-05 20:04:28');
INSERT INTO student_payments VALUES('977','1','907','2022-01-05','15500.00','','2022-01-05 20:05:30','2022-01-05 20:05:30');
INSERT INTO student_payments VALUES('978','1','961','2022-01-05','19000.00','','2022-01-05 20:11:03','2022-01-05 20:11:03');
INSERT INTO student_payments VALUES('979','1','866','2022-01-05','17000.00','','2022-01-05 20:12:14','2022-01-05 20:12:14');
INSERT INTO student_payments VALUES('980','1','882','2022-01-05','16000.00','','2022-01-05 21:35:38','2022-01-05 21:35:38');
INSERT INTO student_payments VALUES('981','1','920','2022-01-06','17000.00','','2022-01-06 17:40:03','2022-01-06 17:40:03');
INSERT INTO student_payments VALUES('982','1','932','2022-01-06','17000.00','','2022-01-06 17:41:01','2022-01-06 17:41:01');
INSERT INTO student_payments VALUES('983','1','904','2022-01-06','17000.00','','2022-01-06 17:45:45','2022-01-06 17:45:45');
INSERT INTO student_payments VALUES('984','1','881','2022-01-06','16000.00','','2022-01-06 18:05:15','2022-01-06 18:05:15');
INSERT INTO student_payments VALUES('985','1','759','2022-01-06','500.00','','2022-01-06 19:36:48','2022-01-06 19:36:48');
INSERT INTO student_payments VALUES('986','1','877','2022-01-06','13500.00','','2022-01-06 19:39:41','2022-01-06 19:39:41');
INSERT INTO student_payments VALUES('987','1','924','2022-01-06','15500.00','','2022-01-06 19:40:57','2022-01-06 19:40:57');
INSERT INTO student_payments VALUES('988','1','905','2022-01-06','15000.00','','2022-01-06 19:52:10','2022-01-06 19:52:10');
INSERT INTO student_payments VALUES('989','1','889','2022-01-06','17500.00','','2022-01-06 19:53:11','2022-01-06 19:53:11');
INSERT INTO student_payments VALUES('990','1','890','2022-01-06','17500.00','','2022-01-06 19:54:36','2022-01-06 19:54:36');
INSERT INTO student_payments VALUES('991','1','957','2022-01-08','15500.00','','2022-01-08 14:32:21','2022-01-08 14:32:21');
INSERT INTO student_payments VALUES('992','1','865','2022-01-07','17000.00','','2022-01-08 14:52:09','2022-01-08 14:52:09');
INSERT INTO student_payments VALUES('993','1','893','2022-01-08','17000.00','','2022-01-08 14:55:47','2022-01-08 14:55:47');
INSERT INTO student_payments VALUES('994','1','918','2022-01-08','17000.00','','2022-01-08 14:57:05','2022-01-08 14:57:05');
INSERT INTO student_payments VALUES('995','1','926','2022-01-08','14000.00','','2022-01-08 14:58:18','2022-01-08 14:58:18');
INSERT INTO student_payments VALUES('996','1','915','2022-01-08','18000.00','','2022-01-08 14:59:06','2022-01-08 14:59:06');
INSERT INTO student_payments VALUES('997','1','797','2022-01-08','6000.00','','2022-01-08 15:01:26','2022-01-08 15:01:26');
INSERT INTO student_payments VALUES('998','1','954','2022-01-08','18000.00','','2022-01-08 15:03:38','2022-01-08 15:03:38');
INSERT INTO student_payments VALUES('999','1','942','2022-01-05','19500.00','','2022-01-08 15:04:30','2022-01-08 15:04:30');
INSERT INTO student_payments VALUES('1000','1','898','2022-01-08','13000.00','','2022-01-08 15:08:19','2022-01-08 15:08:19');
INSERT INTO student_payments VALUES('1001','1','897','2022-01-06','13000.00','','2022-01-08 15:09:18','2022-01-08 15:09:18');
INSERT INTO student_payments VALUES('1002','1','921','2022-01-06','18000.00','','2022-01-08 15:12:16','2022-01-08 15:12:16');
INSERT INTO student_payments VALUES('1003','1','945','2022-01-08','15000.00','','2022-01-08 15:14:10','2022-01-08 15:14:10');
INSERT INTO student_payments VALUES('1004','1','968','2022-01-08','17000.00','','2022-01-08 15:16:54','2022-01-08 15:16:54');
INSERT INTO student_payments VALUES('1005','1','953','2022-01-08','17500.00','','2022-01-08 15:20:13','2022-01-08 15:20:13');
INSERT INTO student_payments VALUES('1006','1','896','2022-01-03','13000.00','','2022-01-08 15:23:41','2022-01-08 15:23:41');
INSERT INTO student_payments VALUES('1007','1','868','2022-01-08','17000.00','','2022-01-08 16:12:40','2022-01-08 16:12:40');
INSERT INTO student_payments VALUES('1008','1','930','2022-01-08','15500.00','','2022-01-08 16:28:33','2022-01-08 16:28:33');
INSERT INTO student_payments VALUES('1009','1','975','2022-01-08','16000.00','','2022-01-08 19:15:07','2022-01-08 19:15:07');
INSERT INTO student_payments VALUES('1010','1','922','2022-01-08','15000.00','','2022-01-08 21:57:10','2022-01-08 21:57:10');
INSERT INTO student_payments VALUES('1011','1','959','2022-01-09','17000.00','','2022-01-09 19:09:57','2022-01-09 19:09:57');
INSERT INTO student_payments VALUES('1012','1','874','2022-01-09','14300.00','','2022-01-09 19:17:00','2022-01-09 19:17:00');
INSERT INTO student_payments VALUES('1013','1','869','2022-01-09','14300.00','','2022-01-09 19:18:25','2022-01-09 19:18:25');
INSERT INTO student_payments VALUES('1014','1','963','2022-01-10','17000.00','','2022-01-10 17:09:33','2022-01-10 17:09:33');
INSERT INTO student_payments VALUES('1015','1','899','2022-01-10','22000.00','','2022-01-10 17:10:32','2022-01-10 17:10:32');
INSERT INTO student_payments VALUES('1016','1','967','2022-01-10','22000.00','','2022-01-10 17:11:35','2022-01-10 17:11:35');
INSERT INTO student_payments VALUES('1017','1','859','2022-01-10','14300.00','','2022-01-10 17:34:37','2022-01-10 17:34:37');
INSERT INTO student_payments VALUES('1018','1','858','2022-01-10','14300.00','','2022-01-10 17:35:24','2022-01-10 17:35:24');
INSERT INTO student_payments VALUES('1019','1','929','2022-01-10','19000.00','','2022-01-10 17:38:15','2022-01-10 17:38:15');
INSERT INTO student_payments VALUES('1020','1','960','2022-01-10','17000.00','','2022-01-10 17:42:02','2022-01-10 17:42:02');
INSERT INTO student_payments VALUES('1021','1','867','2022-01-10','17000.00','','2022-01-10 17:58:20','2022-01-10 17:58:20');
INSERT INTO student_payments VALUES('1022','1','863','2022-01-10','18000.00','','2022-01-10 18:02:30','2022-01-10 18:02:30');
INSERT INTO student_payments VALUES('1023','1','903','2022-01-10','17500.00','','2022-01-10 20:10:48','2022-01-10 20:10:48');
INSERT INTO student_payments VALUES('1024','1','938','2022-01-10','17000.00','','2022-01-10 20:37:48','2022-01-10 20:37:48');
INSERT INTO student_payments VALUES('1025','1','917','2022-01-10','17000.00','','2022-01-10 20:39:26','2022-01-10 20:39:26');
INSERT INTO student_payments VALUES('1026','1','876','2022-01-10','15500.00','','2022-01-10 20:50:43','2022-01-10 20:50:43');
INSERT INTO student_payments VALUES('1027','1','872','2022-01-10','20000.00','','2022-01-10 21:05:16','2022-01-10 21:05:16');
INSERT INTO student_payments VALUES('1028','1','861','2022-01-10','17500.00','','2022-01-10 21:19:02','2022-01-10 21:19:02');
INSERT INTO student_payments VALUES('1029','1','894','2022-01-10','17500.00','','2022-01-10 21:27:22','2022-01-10 21:27:22');
INSERT INTO student_payments VALUES('1030','1','943','2022-01-10','17000.00','','2022-01-10 21:32:58','2022-01-10 21:32:58');
INSERT INTO student_payments VALUES('1031','1','941','2022-01-10','15000.00','','2022-01-10 21:51:27','2022-01-10 21:51:27');
INSERT INTO student_payments VALUES('1032','1','919','2022-01-11','17000.00','','2022-01-11 17:16:21','2022-01-11 17:16:21');
INSERT INTO student_payments VALUES('1033','1','949','2022-01-11','14500.00','','2022-01-11 17:19:53','2022-01-11 17:19:53');
INSERT INTO student_payments VALUES('1034','1','888','2022-01-11','17500.00','','2022-01-11 17:20:53','2022-01-11 17:20:53');
INSERT INTO student_payments VALUES('1035','1','884','2022-01-11','17000.00','','2022-01-11 17:22:15','2022-01-11 17:22:15');
INSERT INTO student_payments VALUES('1036','1','950','2022-01-11','13000.00','','2022-01-11 17:23:32','2022-01-11 17:23:32');
INSERT INTO student_payments VALUES('1037','1','875','2022-01-11','14300.00','','2022-01-11 17:25:32','2022-01-11 17:25:32');
INSERT INTO student_payments VALUES('1038','1','883','2022-01-10','17000.00','','2022-01-11 17:49:25','2022-01-11 17:49:25');
INSERT INTO student_payments VALUES('1039','1','900','2022-01-11','16000.00','','2022-01-11 18:00:17','2022-01-11 18:00:17');
INSERT INTO student_payments VALUES('1040','1','891','2022-01-11','17500.00','','2022-01-11 18:22:50','2022-01-11 18:22:50');
INSERT INTO student_payments VALUES('1041','1','958','2022-01-11','21000.00','','2022-01-11 20:41:21','2022-01-11 20:41:21');
INSERT INTO student_payments VALUES('1042','1','948','2022-01-11','21000.00','','2022-01-11 20:42:04','2022-01-11 20:42:04');
INSERT INTO student_payments VALUES('1043','1','937','2022-01-11','17000.00','','2022-01-11 20:43:44','2022-01-11 20:43:44');
INSERT INTO student_payments VALUES('1044','1','976','2022-01-12','18000.00','','2022-01-12 19:32:11','2022-01-12 19:32:11');
INSERT INTO student_payments VALUES('1045','1','887','2022-01-12','14000.00','','2022-01-12 19:33:59','2022-01-12 19:33:59');
INSERT INTO student_payments VALUES('1046','1','928','2022-01-12','15500.00','','2022-01-12 19:44:42','2022-01-12 19:44:42');
INSERT INTO student_payments VALUES('1047','1','912','2022-01-12','15500.00','','2022-01-12 19:45:33','2022-01-12 19:45:33');
INSERT INTO student_payments VALUES('1048','1','911','2022-01-12','15500.00','','2022-01-12 19:46:19','2022-01-12 19:46:19');
INSERT INTO student_payments VALUES('1049','1','910','2022-01-12','15500.00','','2022-01-12 19:47:09','2022-01-12 19:47:09');
INSERT INTO student_payments VALUES('1050','1','829','2022-01-12','1000.00','','2022-01-12 19:51:49','2022-01-12 19:51:49');
INSERT INTO student_payments VALUES('1051','1','885','2022-01-12','16000.00','','2022-01-12 19:53:24','2022-01-12 19:53:24');
INSERT INTO student_payments VALUES('1052','1','950','2022-01-11','6000.00','','2022-01-12 19:54:49','2022-01-12 19:54:49');
INSERT INTO student_payments VALUES('1053','1','966','2022-01-12','15500.00','','2022-01-12 20:50:29','2022-01-12 20:50:29');
INSERT INTO student_payments VALUES('1054','1','964','2022-01-12','22000.00','','2022-01-13 18:14:58','2022-01-13 18:14:58');
INSERT INTO student_payments VALUES('1055','1','873','2022-01-13','14500.00','','2022-01-13 18:26:13','2022-01-13 18:26:13');
INSERT INTO student_payments VALUES('1056','1','923','2022-01-14','15000.00','','2022-01-14 17:55:48','2022-01-14 17:55:48');
INSERT INTO student_payments VALUES('1057','1','934','2022-01-13','24000.00','','2022-01-14 18:25:55','2022-01-14 18:25:55');
INSERT INTO student_payments VALUES('1058','1','877','2022-01-13','2000.00','','2022-01-14 18:35:57','2022-01-14 18:35:57');
INSERT INTO student_payments VALUES('1059','1','927','2022-01-14','14000.00','','2022-01-14 18:55:28','2022-01-14 18:55:28');
INSERT INTO student_payments VALUES('1060','1','972','2022-01-18','15500.00','','2022-01-18 18:01:32','2022-01-18 18:01:32');
INSERT INTO student_payments VALUES('1061','1','970','2022-01-18','15500.00','','2022-01-18 18:04:22','2022-01-18 18:04:22');
INSERT INTO student_payments VALUES('1192','1','1205','2022-03-02','17000.00','','2022-03-02 19:51:57','2022-03-02 19:51:57');
INSERT INTO student_payments VALUES('1063','1','971','2022-01-20','15500.00','','2022-01-20 16:46:13','2022-01-20 16:46:13');
INSERT INTO student_payments VALUES('1064','1','914','2022-01-20','16500.00','','2022-01-20 19:14:17','2022-01-20 19:14:17');
INSERT INTO student_payments VALUES('1065','1','862','2022-01-28','32000.00','','2022-01-30 16:42:53','2022-01-30 16:42:53');
INSERT INTO student_payments VALUES('1066','1','940','2022-01-29','22000.00','','2022-01-30 16:43:29','2022-01-30 16:43:29');
INSERT INTO student_payments VALUES('1067','1','936','2022-01-31','17000.00','','2022-02-01 17:54:13','2022-02-01 17:54:13');
INSERT INTO student_payments VALUES('1068','1','864','2022-01-31','20000.00','','2022-02-01 17:55:10','2022-02-01 17:55:10');
INSERT INTO student_payments VALUES('1069','1','1002','2022-02-01','16000.00','','2022-02-01 20:35:05','2022-02-01 20:35:05');
INSERT INTO student_payments VALUES('1070','1','981','2022-02-01','24000.00','','2022-02-01 20:35:55','2022-02-01 20:35:55');
INSERT INTO student_payments VALUES('1071','1','1078','2022-02-01','18000.00','','2022-02-01 20:38:31','2022-02-01 20:38:31');
INSERT INTO student_payments VALUES('1072','1','1072','2022-02-01','17500.00','','2022-02-01 20:39:27','2022-02-01 20:39:27');
INSERT INTO student_payments VALUES('1073','1','1069','2022-02-01','17000.00','','2022-02-01 20:40:10','2022-02-01 20:40:10');
INSERT INTO student_payments VALUES('1074','1','1053','2022-02-01','15000.00','','2022-02-01 20:41:25','2022-02-01 20:41:25');
INSERT INTO student_payments VALUES('1075','1','1016','2022-02-01','17500.00','','2022-02-02 21:05:59','2022-02-02 21:05:59');
INSERT INTO student_payments VALUES('1076','1','1022','2022-02-02','17500.00','','2022-02-02 22:39:43','2022-02-02 22:39:43');
INSERT INTO student_payments VALUES('1077','1','1051','2022-02-03','17000.00','','2022-02-03 18:10:47','2022-02-03 18:10:47');
INSERT INTO student_payments VALUES('1078','1','1000','2022-02-03','15500.00','','2022-02-03 18:27:49','2022-02-03 18:27:49');
INSERT INTO student_payments VALUES('1079','1','1062','2022-02-03','17000.00','','2022-02-03 18:28:54','2022-02-03 18:28:54');
INSERT INTO student_payments VALUES('1080','1','986','2022-02-03','17000.00','','2022-02-03 18:35:14','2022-02-03 18:35:14');
INSERT INTO student_payments VALUES('1081','1','1006','2022-02-03','16000.00','','2022-02-03 18:40:14','2022-02-03 18:40:14');
INSERT INTO student_payments VALUES('1082','1','1029','2022-02-03','15500.00','','2022-02-03 19:00:14','2022-02-03 19:00:14');
INSERT INTO student_payments VALUES('1083','1','1026','2022-02-03','15000.00','','2022-02-03 20:04:24','2022-02-03 20:04:24');
INSERT INTO student_payments VALUES('1084','1','999','2022-02-03','15500.00','','2022-02-03 20:22:44','2022-02-03 20:22:44');
INSERT INTO student_payments VALUES('1085','1','1007','2022-02-03','17500.00','','2022-02-03 20:26:34','2022-02-03 20:26:34');
INSERT INTO student_payments VALUES('1086','1','1045','2022-02-03','14000.00','','2022-02-03 20:27:36','2022-02-03 20:27:36');
INSERT INTO student_payments VALUES('1087','1','1025','2022-02-03','17000.00','','2022-02-03 20:31:46','2022-02-03 20:31:46');
INSERT INTO student_payments VALUES('1088','1','1064','2022-02-03','17000.00','','2022-02-03 20:32:32','2022-02-03 20:32:32');
INSERT INTO student_payments VALUES('1089','1','1005','2022-02-04','17000.00','','2022-02-04 17:39:37','2022-02-04 17:39:37');
INSERT INTO student_payments VALUES('1090','1','1032','2022-02-04','10000.00','','2022-02-04 17:52:50','2022-02-04 17:52:50');
INSERT INTO student_payments VALUES('1091','1','1013','2022-02-04','17000.00','','2022-02-04 18:21:03','2022-02-04 18:21:03');
INSERT INTO student_payments VALUES('1092','1','996','2022-02-04','14300.00','','2022-02-04 19:43:15','2022-02-04 19:43:15');
INSERT INTO student_payments VALUES('1093','1','1034','2022-02-05','14000.00','','2022-02-05 18:26:10','2022-02-05 18:26:10');
INSERT INTO student_payments VALUES('1094','1','1068','2022-02-05','19000.00','','2022-02-05 18:27:07','2022-02-05 18:27:07');
INSERT INTO student_payments VALUES('1095','1','1042','2022-02-05','15000.00','','2022-02-05 18:27:58','2022-02-05 18:27:58');
INSERT INTO student_payments VALUES('1096','1','1083','2022-02-05','17000.00','','2022-02-05 19:11:12','2022-02-05 19:11:12');
INSERT INTO student_payments VALUES('1097','1','1001','2022-02-05','16000.00','','2022-02-05 19:18:34','2022-02-05 19:18:34');
INSERT INTO student_payments VALUES('1098','1','978','2022-02-05','10000.00','','2022-02-05 19:40:11','2022-02-05 19:40:11');
INSERT INTO student_payments VALUES('1099','1','1003','2022-02-05','16000.00','','2022-02-05 20:22:02','2022-02-05 20:22:02');
INSERT INTO student_payments VALUES('1100','1','977','2022-02-06','17000.00','','2022-02-06 18:00:54','2022-02-06 18:00:54');
INSERT INTO student_payments VALUES('1101','1','1027','2022-02-06','14000.00','','2022-02-06 18:02:02','2022-02-06 18:02:02');
INSERT INTO student_payments VALUES('1102','1','1010','2022-02-06','17500.00','','2022-02-06 18:02:57','2022-02-06 18:02:57');
INSERT INTO student_payments VALUES('1103','1','1088','2022-02-06','16000.00','','2022-02-06 18:30:06','2022-02-06 18:30:06');
INSERT INTO student_payments VALUES('1104','1','1066','2022-02-06','21000.00','','2022-02-06 20:08:40','2022-02-06 20:08:40');
INSERT INTO student_payments VALUES('1105','1','1075','2022-02-06','21000.00','','2022-02-06 20:09:33','2022-02-06 20:09:33');
INSERT INTO student_payments VALUES('1106','1','1011','2022-02-06','17500.00','','2022-02-06 20:42:15','2022-02-06 20:42:15');
INSERT INTO student_payments VALUES('1110','1','871','2022-02-07','20000.00','','2022-02-07 17:25:35','2022-02-07 17:25:35');
INSERT INTO student_payments VALUES('1111','1','984','2022-02-07','18000.00','','2022-02-07 17:27:41','2022-02-07 17:27:41');
INSERT INTO student_payments VALUES('1112','1','1060','2022-02-07','19500.00','','2022-02-07 17:28:45','2022-02-07 17:28:45');
INSERT INTO student_payments VALUES('1113','1','1014','2022-02-07','17000.00','','2022-02-07 18:25:11','2022-02-07 18:25:11');
INSERT INTO student_payments VALUES('1114','1','1048','2022-02-07','19000.00','','2022-02-07 18:59:34','2022-02-07 18:59:34');
INSERT INTO student_payments VALUES('1115','1','1070','2022-02-07','17500.00','','2022-02-07 19:20:15','2022-02-07 19:20:15');
INSERT INTO student_payments VALUES('1116','1','1084','2022-02-07','16000.00','','2022-02-07 19:36:42','2022-02-07 19:36:42');
INSERT INTO student_payments VALUES('1117','1','1090','2022-02-07','15000.00','','2022-02-07 20:23:18','2022-02-07 20:23:18');
INSERT INTO student_payments VALUES('1118','1','1065','2022-02-07','12000.00','','2022-02-07 20:33:02','2022-02-07 20:33:02');
INSERT INTO student_payments VALUES('1119','1','989','2022-02-07','17000.00','','2022-02-07 20:34:11','2022-02-07 20:34:11');
INSERT INTO student_payments VALUES('1120','1','991','2022-02-07','18500.00','','2022-02-07 21:02:59','2022-02-07 21:02:59');
INSERT INTO student_payments VALUES('1121','1','1038','2022-02-07','17000.00','','2022-02-07 21:05:31','2022-02-07 21:05:31');
INSERT INTO student_payments VALUES('1122','1','1049','2022-02-08','8000.00','','2022-02-08 18:43:05','2022-02-08 18:43:05');
INSERT INTO student_payments VALUES('1123','1','988','2022-02-08','17000.00','','2022-02-08 18:44:13','2022-02-08 18:44:13');
INSERT INTO student_payments VALUES('1124','1','987','2022-02-08','17000.00','','2022-02-08 18:47:12','2022-02-08 18:47:12');
INSERT INTO student_payments VALUES('1125','1','1036','2022-02-08','18000.00','','2022-02-08 18:48:02','2022-02-08 18:48:02');
INSERT INTO student_payments VALUES('1126','1','1061','2022-02-08','17000.00','','2022-02-08 19:07:16','2022-02-08 19:07:16');
INSERT INTO student_payments VALUES('1127','1','1059','2022-02-08','15000.00','','2022-02-08 19:21:33','2022-02-08 19:21:33');
INSERT INTO student_payments VALUES('1128','1','1052','2022-02-08','24000.00','','2022-02-08 20:05:02','2022-02-08 20:05:02');
INSERT INTO student_payments VALUES('1129','1','1024','2022-02-08','17500.00','','2022-02-08 20:05:56','2022-02-08 20:05:56');
INSERT INTO student_payments VALUES('1130','1','1015','2022-02-08','17500.00','','2022-02-08 20:11:24','2022-02-08 20:11:24');
INSERT INTO student_payments VALUES('1131','1','1056','2022-02-08','17000.00','','2022-02-08 20:29:59','2022-02-08 20:29:59');
INSERT INTO student_payments VALUES('1132','1','982','2022-02-08','17500.00','','2022-02-08 20:33:48','2022-02-08 20:33:48');
INSERT INTO student_payments VALUES('1133','1','994','2022-02-08','14000.00','','2022-02-08 21:14:01','2022-02-08 21:14:01');
INSERT INTO student_payments VALUES('1134','1','1058','2022-02-08','22000.00','','2022-02-08 21:25:06','2022-02-08 21:25:06');
INSERT INTO student_payments VALUES('1135','1','1047','2022-02-08','15500.00','','2022-02-08 21:44:04','2022-02-08 21:44:04');
INSERT INTO student_payments VALUES('1136','1','1077','2022-02-09','17000.00','','2022-02-09 17:35:31','2022-02-09 17:35:31');
INSERT INTO student_payments VALUES('1137','1','1028','2022-02-09','15500.00','','2022-02-09 17:39:01','2022-02-09 17:39:01');
INSERT INTO student_payments VALUES('1138','1','1033','2022-02-09','15500.00','','2022-02-09 18:22:15','2022-02-09 18:22:15');
INSERT INTO student_payments VALUES('1139','1','1081','2022-02-09','15500.00','','2022-02-09 18:24:17','2022-02-09 18:24:17');
INSERT INTO student_payments VALUES('1140','1','1065','2022-02-09','3000.00','','2022-02-09 18:35:47','2022-02-09 18:35:47');
INSERT INTO student_payments VALUES('1141','1','980','2022-02-09','14000.00','','2022-02-09 18:37:26','2022-02-09 18:37:26');
INSERT INTO student_payments VALUES('1142','1','979','2022-02-09','14000.00','','2022-02-09 18:39:05','2022-02-09 18:39:05');
INSERT INTO student_payments VALUES('1143','1','1004','2022-02-09','17000.00','','2022-02-09 18:43:28','2022-02-09 18:43:28');
INSERT INTO student_payments VALUES('1144','1','1012','2022-02-09','17500.00','','2022-02-09 20:05:15','2022-02-09 20:05:15');
INSERT INTO student_payments VALUES('1145','1','1020','2022-02-09','22000.00','','2022-02-09 21:20:58','2022-02-09 21:20:58');
INSERT INTO student_payments VALUES('1146','1','1076','2022-02-09','17000.00','','2022-02-09 21:22:24','2022-02-09 21:22:24');
INSERT INTO student_payments VALUES('1147','1','1018','2022-02-09','13000.00','','2022-02-09 21:25:02','2022-02-09 21:25:02');
INSERT INTO student_payments VALUES('1148','1','1055','2022-02-09','17000.00','','2022-02-09 21:38:19','2022-02-09 21:38:19');
INSERT INTO student_payments VALUES('1149','1','1023','2022-02-09','17500.00','','2022-02-09 21:40:24','2022-02-09 21:40:24');
INSERT INTO student_payments VALUES('1150','1','1037','2022-02-09','17500.00','','2022-02-09 21:45:31','2022-02-09 21:45:31');
INSERT INTO student_payments VALUES('1151','1','1008','2022-02-09','14000.00','','2022-02-09 21:47:21','2022-02-09 21:47:21');
INSERT INTO student_payments VALUES('1152','1','1019','2022-02-10','13000.00','','2022-02-10 18:34:29','2022-02-10 18:34:29');
INSERT INTO student_payments VALUES('1153','1','1040','2022-02-10','15000.00','','2022-02-10 18:37:23','2022-02-10 18:37:23');
INSERT INTO student_payments VALUES('1154','1','1031','2022-02-10','15500.00','','2022-02-10 18:56:45','2022-02-10 18:56:45');
INSERT INTO student_payments VALUES('1155','1','1044','2022-02-11','15500.00','','2022-02-11 18:26:04','2022-02-11 18:26:04');
INSERT INTO student_payments VALUES('1156','1','998','2022-02-11','15500.00','','2022-02-11 18:27:01','2022-02-11 18:27:01');
INSERT INTO student_payments VALUES('1157','1','1009','2022-02-11','17500.00','','2022-02-11 18:29:25','2022-02-11 18:29:25');
INSERT INTO student_payments VALUES('1158','1','1091','2022-02-11','9000.00','','2022-02-11 19:05:29','2022-02-11 19:05:29');
INSERT INTO student_payments VALUES('1159','1','1073','2022-02-10','17500.00','','2022-02-11 19:11:18','2022-02-11 19:11:18');
INSERT INTO student_payments VALUES('1160','1','1092','2022-02-11','25000.00','','2022-02-11 20:35:57','2022-02-11 20:35:57');
INSERT INTO student_payments VALUES('1161','1','1057','2022-02-11','15000.00','','2022-02-11 21:11:59','2022-02-11 21:11:59');
INSERT INTO student_payments VALUES('1162','1','1017','2022-02-12','13000.00','','2022-02-12 20:49:18','2022-02-12 20:49:18');
INSERT INTO student_payments VALUES('1163','1','1074','2022-02-13','17000.00','','2022-02-13 15:07:26','2022-02-13 15:07:26');
INSERT INTO student_payments VALUES('1164','1','1079','2022-02-13','15000.00','','2022-02-13 15:08:59','2022-02-13 15:08:59');
INSERT INTO student_payments VALUES('1165','1','1093','2022-02-13','28000.00','','2022-02-13 18:50:08','2022-02-13 18:50:08');
INSERT INTO student_payments VALUES('1166','1','1094','2022-02-13','31200.00','','2022-02-13 20:56:53','2022-02-13 20:56:53');
INSERT INTO student_payments VALUES('1167','1','1071','2022-02-14','18000.00','','2022-02-14 21:00:21','2022-02-14 21:00:21');
INSERT INTO student_payments VALUES('1168','1','1087','2022-02-14','15500.00','','2022-02-14 21:03:04','2022-02-14 21:03:04');
INSERT INTO student_payments VALUES('1169','1','1085','2022-02-14','15000.00','','2022-02-14 21:04:38','2022-02-14 21:04:38');
INSERT INTO student_payments VALUES('1170','1','819','2022-02-14','6000.00','','2022-02-14 21:17:41','2022-02-14 21:17:41');
INSERT INTO student_payments VALUES('1171','1','1067','2022-02-14','17000.00','','2022-02-14 22:11:12','2022-02-14 22:11:12');
INSERT INTO student_payments VALUES('1172','1','584','2022-02-15','3000.00','','2022-02-15 17:34:47','2022-02-15 17:34:47');
INSERT INTO student_payments VALUES('1173','1','1082','2022-02-15','22000.00','','2022-02-15 17:35:36','2022-02-15 17:35:36');
INSERT INTO student_payments VALUES('1174','1','1040','2022-02-15','2000.00','','2022-02-15 18:32:42','2022-02-15 18:32:42');
INSERT INTO student_payments VALUES('1175','1','1035','2022-02-15','11500.00','','2022-02-15 20:01:15','2022-02-15 20:01:15');
INSERT INTO student_payments VALUES('1176','1','1035','2022-02-15','5000.00','','2022-02-15 20:57:48','2022-02-15 20:57:48');
INSERT INTO student_payments VALUES('1177','1','997','2022-02-16','14500.00','','2022-02-16 16:55:42','2022-02-16 16:55:42');
INSERT INTO student_payments VALUES('1178','1','1046','2022-02-16','14000.00','','2022-02-16 19:33:05','2022-02-16 19:33:05');
INSERT INTO student_payments VALUES('1179','1','551','2022-02-16','240.00','','2022-02-16 19:34:50','2022-02-16 19:34:50');
INSERT INTO student_payments VALUES('1180','1','1039','2022-02-16','16000.00','','2022-02-16 19:35:38','2022-02-16 19:35:38');
INSERT INTO student_payments VALUES('1181','1','1043','2022-02-17','15000.00','','2022-02-17 17:08:16','2022-02-17 17:08:16');
INSERT INTO student_payments VALUES('1182','1','1080','2022-02-17','22000.00','','2022-02-17 17:09:20','2022-02-17 17:09:20');
INSERT INTO student_payments VALUES('1183','1','1030','2022-02-17','17000.00','','2022-02-17 18:46:03','2022-02-17 18:46:03');
INSERT INTO student_payments VALUES('1184','1','1086','2022-02-18','15500.00','','2022-02-18 17:15:21','2022-02-18 17:15:21');
INSERT INTO student_payments VALUES('1185','1','1053','2022-02-20','1500.00','','2022-02-20 20:48:39','2022-02-20 20:48:39');
INSERT INTO student_payments VALUES('1195','1','1053','2022-03-02','500.00','','2022-03-02 19:59:29','2022-03-02 19:59:29');
INSERT INTO student_payments VALUES('1196','1','1041','2022-03-02','10000.00','','2022-03-02 20:01:33','2022-03-02 20:01:33');
INSERT INTO student_payments VALUES('1197','1','1130','2022-03-02','17000.00','','2022-03-02 20:14:08','2022-03-02 20:14:08');
INSERT INTO student_payments VALUES('1198','1','1139','2022-03-02','17500.00','','2022-03-02 21:21:01','2022-03-02 21:21:01');
INSERT INTO student_payments VALUES('1199','1','1168','2022-03-03','17000.00','','2022-03-03 18:25:26','2022-03-03 18:25:26');
INSERT INTO student_payments VALUES('1200','1','1202','2022-03-03','15500.00','','2022-03-03 18:29:20','2022-03-03 18:29:20');
INSERT INTO student_payments VALUES('1201','1','1133','2022-03-03','17000.00','','2022-03-03 18:39:36','2022-03-03 18:39:36');
INSERT INTO student_payments VALUES('1202','1','985','2022-03-03','20000.00','','2022-03-03 18:40:48','2022-03-03 18:40:48');
INSERT INTO student_payments VALUES('1203','1','1049','2022-03-02','7000.00','','2022-03-03 18:47:07','2022-03-03 18:47:07');
INSERT INTO student_payments VALUES('1204','1','1118','2022-03-03','16000.00','','2022-03-03 19:01:13','2022-03-03 19:01:13');
INSERT INTO student_payments VALUES('1205','1','1180','2022-03-03','17000.00','','2022-03-03 19:04:57','2022-03-03 19:04:57');
INSERT INTO student_payments VALUES('1206','1','1142','2022-03-03','17000.00','','2022-03-03 19:14:28','2022-03-03 19:14:28');
INSERT INTO student_payments VALUES('1207','1','1185','2022-03-03','14000.00','','2022-03-03 19:43:51','2022-03-03 19:43:51');
INSERT INTO student_payments VALUES('1208','1','1124','2022-03-03','17500.00','','2022-03-03 21:27:22','2022-03-03 21:27:22');
INSERT INTO student_payments VALUES('1209','1','1098','2022-03-03','10000.00','','2022-03-03 21:28:15','2022-03-03 21:28:15');
INSERT INTO student_payments VALUES('1210','1','1151','2022-03-03','14000.00','','2022-03-03 21:32:08','2022-03-03 21:32:08');
INSERT INTO student_payments VALUES('1211','1','1176','2022-03-03','15000.00','','2022-03-03 21:49:23','2022-03-03 21:49:23');
INSERT INTO student_payments VALUES('1212','1','1159','2022-03-03','15000.00','','2022-03-03 21:55:07','2022-03-03 21:55:07');
INSERT INTO student_payments VALUES('1213','1','1188','2022-03-04','17500.00','','2022-03-04 19:31:44','2022-03-04 19:31:44');
INSERT INTO student_payments VALUES('1214','1','1106','2022-03-04','17000.00','','2022-03-04 19:32:56','2022-03-04 19:32:56');
INSERT INTO student_payments VALUES('1215','1','1181','2022-03-04','15000.00','','2022-03-04 19:33:40','2022-03-04 19:33:40');
INSERT INTO student_payments VALUES('1216','1','1173','2022-03-04','17000.00','','2022-03-04 19:39:44','2022-03-04 19:39:44');
INSERT INTO student_payments VALUES('1217','1','1191','2022-03-04','21000.00','','2022-03-04 20:38:07','2022-03-04 20:38:07');
INSERT INTO student_payments VALUES('1218','1','1182','2022-03-04','21000.00','','2022-03-04 20:39:03','2022-03-04 20:39:03');
INSERT INTO student_payments VALUES('1219','1','1162','2022-03-05','14000.00','','2022-03-05 15:15:09','2022-03-05 15:15:09');
INSERT INTO student_payments VALUES('1220','1','1146','2022-03-05','15500.00','','2022-03-05 15:16:35','2022-03-05 15:16:35');
INSERT INTO student_payments VALUES('1221','1','1097','2022-03-05','17000.00','','2022-03-05 15:18:23','2022-03-05 15:18:23');
INSERT INTO student_payments VALUES('1222','1','1121','2022-03-05','17000.00','','2022-03-05 20:12:47','2022-03-05 20:12:47');
INSERT INTO student_payments VALUES('1223','1','1125','2022-03-05','14000.00','','2022-03-05 20:15:22','2022-03-05 20:15:22');
INSERT INTO student_payments VALUES('1224','1','1207','2022-03-05','30000.00','','2022-03-05 21:12:43','2022-03-05 21:12:43');
INSERT INTO student_payments VALUES('1225','1','643','2022-03-05','500.00','','2022-03-05 21:17:38','2022-03-05 21:17:38');
INSERT INTO student_payments VALUES('1226','1','1194','2022-03-06','18000.00','','2022-03-06 16:29:50','2022-03-06 16:29:50');
INSERT INTO student_payments VALUES('1227','1','1127','2022-03-06','17500.00','','2022-03-06 16:32:15','2022-03-06 16:32:15');
INSERT INTO student_payments VALUES('1228','1','1128','2022-03-06','17500.00','','2022-03-06 16:37:05','2022-03-06 16:37:05');
INSERT INTO student_payments VALUES('1229','1','1208','2022-03-06','38000.00','','2022-03-06 18:27:38','2022-03-06 18:27:38');
INSERT INTO student_payments VALUES('1230','1','1144','2022-03-06','14000.00','','2022-03-06 19:10:16','2022-03-06 19:10:16');
INSERT INTO student_payments VALUES('1231','1','1143','2022-03-06','15000.00','','2022-03-06 19:10:58','2022-03-06 19:10:58');
INSERT INTO student_payments VALUES('1232','1','1131','2022-03-06','17000.00','','2022-03-06 19:12:41','2022-03-06 19:12:41');
INSERT INTO student_payments VALUES('1233','1','1129','2022-03-06','17500.00','','2022-03-06 19:22:06','2022-03-06 19:22:06');
INSERT INTO student_payments VALUES('1234','1','1209','2022-03-02','27000.00','','2022-03-06 19:36:54','2022-03-06 19:36:54');
INSERT INTO student_payments VALUES('1235','1','1184','2022-03-06','6500.00','','2022-03-06 19:43:36','2022-03-06 19:43:36');
INSERT INTO student_payments VALUES('1236','1','1108','2022-03-06','17000.00','','2022-03-06 20:34:08','2022-03-06 20:34:08');
INSERT INTO student_payments VALUES('1237','1','1177','2022-03-06','19500.00','','2022-03-06 20:34:40','2022-03-06 20:34:40');
INSERT INTO student_payments VALUES('1238','1','1114','2022-03-06','15000.00','','2022-03-06 20:46:35','2022-03-06 20:46:35');
INSERT INTO student_payments VALUES('1239','1','1032','2022-03-07','2000.00','','2022-03-07 19:36:33','2022-03-07 19:36:33');
INSERT INTO student_payments VALUES('1240','1','1149','2022-03-07','17500.00','','2022-03-07 19:37:26','2022-03-07 19:37:26');
INSERT INTO student_payments VALUES('1241','1','1148','2022-03-07','17500.00','','2022-03-07 19:38:05','2022-03-07 19:38:05');
INSERT INTO student_payments VALUES('1242','1','1206','2022-03-07','17000.00','','2022-03-07 19:39:33','2022-03-07 19:39:33');
INSERT INTO student_payments VALUES('1243','1','1155','2022-03-07','17000.00','','2022-03-07 19:43:03','2022-03-07 19:43:03');
INSERT INTO student_payments VALUES('1244','1','1165','2022-03-07','19000.00','','2022-03-07 20:13:39','2022-03-07 20:13:39');
INSERT INTO student_payments VALUES('1245','1','1104','2022-03-07','18000.00','','2022-03-07 20:31:36','2022-03-07 20:31:36');
INSERT INTO student_payments VALUES('1246','1','1107','2022-03-07','17000.00','','2022-03-07 21:01:09','2022-03-07 21:01:09');
INSERT INTO student_payments VALUES('1247','1','1110','2022-03-08','19000.00','','2022-03-08 16:06:49','2022-03-08 16:06:49');
INSERT INTO student_payments VALUES('1248','1','1172','2022-03-08','17000.00','','2022-03-08 16:08:59','2022-03-08 16:08:59');
INSERT INTO student_payments VALUES('1249','1','1119','2022-03-08','16000.00','','2022-03-08 16:09:41','2022-03-08 16:09:41');
INSERT INTO student_payments VALUES('1250','1','1100','2022-03-07','16000.00','','2022-03-08 16:14:49','2022-03-08 16:14:49');
INSERT INTO student_payments VALUES('1251','1','1099','2022-03-08','16000.00','','2022-03-08 16:15:43','2022-03-08 16:15:43');
INSERT INTO student_payments VALUES('1252','1','1138','2022-03-08','17500.00','','2022-03-08 16:17:09','2022-03-08 16:17:09');
INSERT INTO student_payments VALUES('1253','1','1021','2022-03-08','2500.00','','2022-03-08 16:18:11','2022-03-08 16:18:11');
INSERT INTO student_payments VALUES('1254','1','1163','2022-03-08','14000.00','','2022-03-08 16:36:31','2022-03-08 16:36:31');
INSERT INTO student_payments VALUES('1255','1','1198','2022-03-08','17000.00','','2022-03-08 16:57:30','2022-03-08 16:57:30');
INSERT INTO student_payments VALUES('1256','1','1204','2022-03-08','15000.00','','2022-03-08 16:59:57','2022-03-08 16:59:57');
INSERT INTO student_payments VALUES('1257','1','1190','2022-03-08','17000.00','','2022-03-08 21:43:44','2022-03-08 21:43:44');
INSERT INTO student_payments VALUES('1258','1','1109','2022-03-08','17000.00','','2022-03-08 21:44:36','2022-03-08 21:44:36');
INSERT INTO student_payments VALUES('1259','1','1147','2022-03-08','17000.00','','2022-03-08 21:46:40','2022-03-08 21:46:40');
INSERT INTO student_payments VALUES('1260','1','1113','2022-03-08','15500.00','','2022-03-08 21:48:09','2022-03-08 21:48:09');
INSERT INTO student_payments VALUES('1261','1','1135','2022-03-08','13000.00','','2022-03-08 21:51:22','2022-03-08 21:51:22');
INSERT INTO student_payments VALUES('1262','1','1197','2022-03-08','22000.00','','2022-03-08 21:52:09','2022-03-08 21:52:09');
INSERT INTO student_payments VALUES('1263','1','1189','2022-03-08','17500.00','','2022-03-08 21:58:31','2022-03-08 21:58:31');
INSERT INTO student_payments VALUES('1264','1','1186','2022-03-08','17500.00','','2022-03-08 21:59:02','2022-03-08 21:59:02');
INSERT INTO student_payments VALUES('1265','1','1122','2022-03-08','17000.00','','2022-03-08 22:00:31','2022-03-08 22:00:31');
INSERT INTO student_payments VALUES('1266','1','406','2022-03-08','1000.00','','2022-03-08 22:01:07','2022-03-08 22:01:07');
INSERT INTO student_payments VALUES('1267','1','1132','2022-03-08','17000.00','','2022-03-08 22:01:38','2022-03-08 22:01:38');
INSERT INTO student_payments VALUES('1268','1','1102','2022-03-08','17500.00','','2022-03-08 22:28:15','2022-03-08 22:28:15');
INSERT INTO student_payments VALUES('1269','1','1178','2022-03-09','17000.00','','2022-03-09 20:43:07','2022-03-09 20:43:07');
INSERT INTO student_payments VALUES('1270','1','1153','2022-03-07','18000.00','','2022-03-09 20:43:59','2022-03-09 20:43:59');
INSERT INTO student_payments VALUES('1271','1','1211','2022-03-07','29000.00','','2022-03-09 21:05:51','2022-03-09 21:05:51');
INSERT INTO student_payments VALUES('1272','1','1210','2022-03-09','29000.00','','2022-03-09 21:12:57','2022-03-09 21:12:57');
INSERT INTO student_payments VALUES('1273','1','1174','2022-03-09','11000.00','','2022-03-09 22:30:29','2022-03-09 22:30:29');
INSERT INTO student_payments VALUES('1274','1','1192','2022-03-09','16000.00','','2022-03-09 22:34:07','2022-03-09 22:34:07');
INSERT INTO student_payments VALUES('1275','1','1126','2022-03-10','17500.00','','2022-03-10 19:58:24','2022-03-10 19:58:24');
INSERT INTO student_payments VALUES('1276','1','1150','2022-03-10','17500.00','','2022-03-10 20:00:25','2022-03-10 20:00:25');
INSERT INTO student_payments VALUES('1277','1','1158','2022-03-10','18000.00','','2022-03-10 20:01:17','2022-03-10 20:01:17');
INSERT INTO student_payments VALUES('1278','1','1154','2022-03-10','17500.00','','2022-03-10 20:03:20','2022-03-10 20:03:20');
INSERT INTO student_payments VALUES('1279','1','1117','2022-03-10','15000.00','','2022-03-10 20:06:56','2022-03-10 20:06:56');
INSERT INTO student_payments VALUES('1280','1','1157','2022-03-10','15000.00','','2022-03-10 20:07:57','2022-03-10 20:07:57');
INSERT INTO student_payments VALUES('1281','1','1123','2022-03-10','16000.00','','2022-03-10 20:09:38','2022-03-10 20:09:38');
INSERT INTO student_payments VALUES('1282','1','1187','2022-03-11','18000.00','','2022-03-11 18:05:16','2022-03-11 18:05:16');
INSERT INTO student_payments VALUES('1283','1','1141','2022-03-11','17500.00','','2022-03-11 18:06:15','2022-03-11 18:06:15');
INSERT INTO student_payments VALUES('1284','1','1134','2022-03-11','13000.00','','2022-03-11 18:07:15','2022-03-11 18:07:15');
INSERT INTO student_payments VALUES('1285','1','1116','2022-03-11','15500.00','','2022-03-11 18:09:37','2022-03-11 18:09:37');
INSERT INTO student_payments VALUES('1286','1','1200','2022-03-11','15500.00','','2022-03-11 18:13:44','2022-03-11 18:13:44');
INSERT INTO student_payments VALUES('1287','1','1199','2022-03-11','15500.00','','2022-03-11 18:14:28','2022-03-11 18:14:28');
INSERT INTO student_payments VALUES('1288','1','1160','2022-03-11','15000.00','','2022-03-11 18:28:40','2022-03-11 18:28:40');
INSERT INTO student_payments VALUES('1289','1','1212','2022-03-11','26000.00','','2022-03-11 18:42:50','2022-03-11 18:42:50');
INSERT INTO student_payments VALUES('1290','1','1213','2022-03-09','25650.00','','2022-03-11 18:47:40','2022-03-11 18:47:40');
INSERT INTO student_payments VALUES('1291','1','1214','2022-03-11','27000.00','','2022-03-11 19:10:24','2022-03-11 19:10:24');
INSERT INTO student_payments VALUES('1292','1','1193','2022-03-11','17000.00','','2022-03-11 19:42:13','2022-03-11 19:42:13');
INSERT INTO student_payments VALUES('1293','1','1117','2022-03-11','500.00','','2022-03-11 19:50:45','2022-03-11 19:50:45');
INSERT INTO student_payments VALUES('1294','1','1183','2022-03-11','10000.00','','2022-03-11 20:38:28','2022-03-11 20:38:28');
INSERT INTO student_payments VALUES('1295','1','1169','2022-03-12','22000.00','','2022-03-12 20:09:03','2022-03-12 20:09:03');
INSERT INTO student_payments VALUES('1296','1','1164','2022-03-12','17500.00','','2022-03-12 20:43:05','2022-03-12 20:43:05');
INSERT INTO student_payments VALUES('1297','1','1145','2022-03-15','15500.00','','2022-03-15 14:19:46','2022-03-15 14:19:46');
INSERT INTO student_payments VALUES('1298','1','1136','2022-03-13','13000.00','','2022-03-15 14:21:32','2022-03-15 14:21:32');
INSERT INTO student_payments VALUES('1299','1','1184','2022-03-15','10000.00','','2022-03-15 14:22:22','2022-03-15 14:22:22');
INSERT INTO student_payments VALUES('1300','1','1120','2022-03-13','16000.00','','2022-03-15 14:23:30','2022-03-15 14:23:30');
INSERT INTO student_payments VALUES('1301','1','1201','2022-03-15','14000.00','','2022-03-15 14:24:20','2022-03-15 14:24:20');
INSERT INTO student_payments VALUES('1302','1','1166','2022-03-15','15500.00','','2022-03-15 14:53:02','2022-03-15 14:53:02');
INSERT INTO student_payments VALUES('1303','1','1049','2022-03-15','500.00','','2022-03-15 14:53:40','2022-03-15 14:53:40');
INSERT INTO student_payments VALUES('1304','1','1137','2022-03-15','22000.00','','2022-03-15 14:54:21','2022-03-15 14:54:21');
INSERT INTO student_payments VALUES('1305','1','1179','2022-03-14','17000.00','','2022-03-15 14:57:22','2022-03-15 14:57:22');
INSERT INTO student_payments VALUES('1306','1','1140','2022-03-16','10000.00','','2022-03-16 13:50:07','2022-03-16 13:50:07');
INSERT INTO student_payments VALUES('1307','1','1183','2022-03-17','7000.00','','2022-03-18 13:19:23','2022-03-18 13:19:23');
INSERT INTO student_payments VALUES('1308','1','1140','2022-03-18','7500.00','','2022-03-18 13:40:50','2022-03-18 13:40:50');
INSERT INTO student_payments VALUES('1309','1','1196','2022-03-25','22000.00','','2022-03-27 12:30:47','2022-03-27 12:30:47');
INSERT INTO student_payments VALUES('1310','1','846','2022-03-25','2000.00','','2022-03-27 12:31:37','2022-03-27 12:31:37');
INSERT INTO student_payments VALUES('1311','1','494','2022-03-25','650.00','','2022-03-27 12:32:35','2022-03-27 12:32:35');
INSERT INTO student_payments VALUES('1312','1','1103','2022-03-25','32000.00','','2022-03-27 12:33:10','2022-03-27 12:33:10');
INSERT INTO student_payments VALUES('1313','1','1195','2022-03-25','17000.00','','2022-03-27 12:34:36','2022-03-27 12:34:36');
INSERT INTO student_payments VALUES('1314','1','1112','2022-03-26','20000.00','','2022-03-27 12:35:29','2022-03-27 12:35:29');
INSERT INTO student_payments VALUES('1315','1','1111','2022-03-26','15000.00','','2022-03-27 12:36:18','2022-03-27 12:36:18');
INSERT INTO student_payments VALUES('1316','1','1215','2022-03-26','15000.00','','2022-03-27 12:39:10','2022-03-27 12:39:10');
INSERT INTO student_payments VALUES('1317','1','1185','2022-03-28','3000.00','','2022-03-29 16:56:48','2022-03-29 16:56:48');
INSERT INTO student_payments VALUES('1318','1','1156','2022-03-30','17000.00','','2022-03-31 14:23:59','2022-03-31 14:23:59');
INSERT INTO student_payments VALUES('1319','1','1220','2022-04-01','24000.00','','2022-04-02 15:15:56','2022-04-02 15:15:56');
INSERT INTO student_payments VALUES('1320','1','1272','2022-04-04','17000.00','','2022-04-04 14:27:05','2022-04-04 14:27:05');
INSERT INTO student_payments VALUES('1321','1','1271','2022-04-04','17000.00','','2022-04-04 14:27:35','2022-04-04 14:27:35');
INSERT INTO student_payments VALUES('1322','1','1334','2022-04-04','500.00','','2022-04-04 14:30:26','2022-04-04 14:30:26');
INSERT INTO student_payments VALUES('1323','1','1289','2022-04-04','15000.00','','2022-04-04 14:30:58','2022-04-04 14:30:58');
INSERT INTO student_payments VALUES('1324','1','1330','2022-04-04','16000.00','','2022-04-04 14:31:54','2022-04-04 14:31:54');
INSERT INTO student_payments VALUES('1325','1','1331','2022-04-04','16000.00','','2022-04-04 14:32:13','2022-04-04 14:32:13');
INSERT INTO student_payments VALUES('1326','1','1217','2022-04-04','10000.00','','2022-04-04 14:32:38','2022-04-04 14:32:38');
INSERT INTO student_payments VALUES('1327','1','1263','2022-04-04','16000.00','','2022-04-04 14:34:30','2022-04-04 14:34:30');
INSERT INTO student_payments VALUES('1328','1','1293','2022-04-04','17000.00','','2022-04-04 14:35:36','2022-04-04 14:35:36');
INSERT INTO student_payments VALUES('1329','1','1260','2022-04-04','15000.00','','2022-04-04 14:36:30','2022-04-04 14:36:30');
INSERT INTO student_payments VALUES('1330','1','1261','2022-04-04','14000.00','','2022-04-04 14:36:55','2022-04-04 14:36:55');
INSERT INTO student_payments VALUES('1331','1','1256','2022-04-04','17500.00','','2022-04-04 14:37:39','2022-04-04 14:37:39');
INSERT INTO student_payments VALUES('1332','1','1241','2022-04-04','17500.00','','2022-04-04 14:38:12','2022-04-04 14:38:12');
INSERT INTO student_payments VALUES('1333','1','1248','2022-04-04','17000.00','','2022-04-04 14:39:07','2022-04-04 14:39:07');
INSERT INTO student_payments VALUES('1334','1','1250','2022-04-04','17000.00','','2022-04-04 14:39:53','2022-04-04 14:39:53');
INSERT INTO student_payments VALUES('1335','1','1234','2022-03-28','15500.00','','2022-04-04 14:41:31','2022-04-04 14:41:31');
INSERT INTO student_payments VALUES('1336','1','1233','2022-04-04','15500.00','','2022-04-04 14:42:08','2022-04-04 14:42:08');
INSERT INTO student_payments VALUES('1337','1','1297','2022-04-04','16500.00','','2022-04-04 14:43:05','2022-04-04 14:43:05');
INSERT INTO student_payments VALUES('1338','1','1225','2022-04-04','17000.00','','2022-04-04 14:43:40','2022-04-04 14:43:40');
INSERT INTO student_payments VALUES('1339','1','1327','2022-04-04','15000.00','','2022-04-04 14:44:46','2022-04-04 14:44:46');
INSERT INTO student_payments VALUES('1340','1','1290','2022-04-04','19500.00','','2022-04-04 14:45:21','2022-04-04 14:45:21');
INSERT INTO student_payments VALUES('1341','1','1236','2022-04-04','5000.00','','2022-04-04 14:46:09','2022-04-04 14:46:09');
INSERT INTO student_payments VALUES('1342','1','1252','2022-04-04','13000.00','','2022-04-04 14:46:46','2022-04-04 14:46:46');
INSERT INTO student_payments VALUES('1343','1','1247','2022-04-04','17000.00','','2022-04-04 14:56:06','2022-04-04 14:56:06');
INSERT INTO student_payments VALUES('1344','1','1311','2022-04-04','17000.00','','2022-04-04 17:42:42','2022-04-04 17:42:42');
INSERT INTO student_payments VALUES('1345','1','1326','2022-04-05','15500.00','','2022-04-05 12:59:06','2022-04-05 12:59:06');
INSERT INTO student_payments VALUES('1346','1','1276','2022-04-04','15000.00','','2022-04-05 14:25:11','2022-04-05 14:25:11');
INSERT INTO student_payments VALUES('1347','1','1278','2022-04-04','14000.00','','2022-04-05 14:25:47','2022-04-05 14:25:47');
INSERT INTO student_payments VALUES('1348','1','1319','2022-04-04','15000.00','','2022-04-05 14:26:16','2022-04-05 14:26:16');
INSERT INTO student_payments VALUES('1349','1','1279','2022-04-05','14000.00','','2022-04-05 14:26:41','2022-04-05 14:26:41');
INSERT INTO student_payments VALUES('1350','1','1288','2022-04-05','15000.00','','2022-04-05 14:27:02','2022-04-05 14:27:02');
INSERT INTO student_payments VALUES('1351','1','1265','2022-04-05','17500.00','','2022-04-05 14:27:46','2022-04-05 14:27:46');
INSERT INTO student_payments VALUES('1352','1','1259','2022-04-04','17000.00','','2022-04-05 14:28:34','2022-04-05 14:28:34');
INSERT INTO student_payments VALUES('1353','1','1224','2022-04-05','17000.00','','2022-04-05 14:29:20','2022-04-05 14:29:20');
INSERT INTO student_payments VALUES('1354','1','1317','2022-04-05','17000.00','','2022-04-05 14:29:56','2022-04-05 14:29:56');
INSERT INTO student_payments VALUES('1355','1','1286','2022-04-04','17000.00','','2022-04-05 14:30:53','2022-04-05 14:30:53');
INSERT INTO student_payments VALUES('1356','1','1287','2022-04-04','17000.00','','2022-04-05 14:31:11','2022-04-05 14:31:11');
INSERT INTO student_payments VALUES('1357','1','1318','2022-04-05','17000.00','','2022-04-05 14:32:02','2022-04-05 14:32:02');
INSERT INTO student_payments VALUES('1358','1','1216','2022-04-05','17000.00','','2022-04-05 14:32:32','2022-04-05 14:32:32');
INSERT INTO student_payments VALUES('1359','1','1235','2022-04-05','16000.00','','2022-04-05 14:33:21','2022-04-05 14:33:21');
INSERT INTO student_payments VALUES('1360','1','1236','2022-04-05','1000.00','','2022-04-05 14:34:05','2022-04-05 14:34:05');
INSERT INTO student_payments VALUES('1361','1','1228','2022-04-04','19000.00','','2022-04-05 14:34:53','2022-04-05 14:34:53');
INSERT INTO student_payments VALUES('1362','1','1268','2022-04-05','10000.00','','2022-04-05 14:35:48','2022-04-05 14:35:48');
INSERT INTO student_payments VALUES('1363','1','1244','2022-04-05','17500.00','','2022-04-05 14:38:12','2022-04-05 14:38:12');
INSERT INTO student_payments VALUES('1364','1','1301','2022-04-05','17500.00','','2022-04-05 17:25:46','2022-04-05 17:25:46');
INSERT INTO student_payments VALUES('1365','1','1254','2022-04-06','22000.00','','2022-04-06 17:09:34','2022-04-06 17:09:34');
INSERT INTO student_payments VALUES('1366','1','1226','2022-04-06','17000.00','','2022-04-06 17:16:28','2022-04-06 17:16:28');
INSERT INTO student_payments VALUES('1367','1','1268','2022-04-07','4000.00','','2022-04-07 14:09:15','2022-04-07 14:09:15');
INSERT INTO student_payments VALUES('1368','1','1249','2022-04-07','17000.00','','2022-04-07 15:10:35','2022-04-07 15:10:35');
INSERT INTO student_payments VALUES('1369','1','1321','2022-04-07','15000.00','','2022-04-07 16:52:16','2022-04-07 16:52:16');
INSERT INTO student_payments VALUES('1370','1','1243','2022-04-07','17500.00','','2022-04-07 16:54:05','2022-04-07 16:54:05');
INSERT INTO student_payments VALUES('1371','1','1246','2022-04-07','17500.00','','2022-04-07 16:54:28','2022-04-07 16:54:28');
INSERT INTO student_payments VALUES('1372','1','1328','2022-04-05','19000.00','','2022-04-07 16:55:41','2022-04-07 16:55:41');
INSERT INTO student_payments VALUES('1373','1','1329','2022-04-05','19000.00','','2022-04-07 16:56:03','2022-04-07 16:56:03');
INSERT INTO student_payments VALUES('1374','1','1332','2022-04-05','19000.00','','2022-04-07 16:56:38','2022-04-07 16:56:38');
INSERT INTO student_payments VALUES('1375','1','1333','2022-04-05','19000.00','','2022-04-07 16:57:11','2022-04-07 16:57:11');
INSERT INTO student_payments VALUES('1376','1','1307','2022-04-07','18000.00','','2022-04-07 16:58:10','2022-04-07 16:58:10');
INSERT INTO student_payments VALUES('1377','1','1280','2022-04-07','17500.00','','2022-04-07 17:00:49','2022-04-07 17:00:49');
INSERT INTO student_payments VALUES('1378','1','1315','2022-04-07','17500.00','','2022-04-07 17:02:24','2022-04-07 17:02:24');
INSERT INTO student_payments VALUES('1379','1','1255','2022-04-07','17500.00','','2022-04-07 17:03:15','2022-04-07 17:03:15');
INSERT INTO student_payments VALUES('1380','1','1021','2022-04-07','2500.00','','2022-04-07 17:04:18','2022-04-07 17:04:18');
INSERT INTO student_payments VALUES('1381','1','1258','2022-04-07','17500.00','','2022-04-07 17:16:28','2022-04-07 17:16:28');
INSERT INTO student_payments VALUES('1382','1','1274','2022-04-07','15000.00','','2022-04-08 17:17:04','2022-04-08 17:17:04');
INSERT INTO student_payments VALUES('1383','1','1262','2022-04-08','17500.00','','2022-04-08 17:18:37','2022-04-08 17:18:37');
INSERT INTO student_payments VALUES('1384','1','1291','2022-04-08','17000.00','','2022-04-08 17:19:20','2022-04-08 17:19:20');
INSERT INTO student_payments VALUES('1385','1','1303','2022-04-08','17000.00','','2022-04-08 17:20:16','2022-04-08 17:20:16');
INSERT INTO student_payments VALUES('1386','1','1296','2022-04-08','17000.00','','2022-04-08 17:20:44','2022-04-08 17:20:44');
INSERT INTO student_payments VALUES('1387','1','1312','2022-04-08','15000.00','','2022-04-08 17:21:48','2022-04-08 17:21:48');
INSERT INTO student_payments VALUES('1388','1','1294','2022-04-08','14000.00','','2022-04-08 17:22:50','2022-04-08 17:22:50');
INSERT INTO student_payments VALUES('1389','1','1282','2022-04-08','15000.00','','2022-04-08 17:30:15','2022-04-08 17:30:15');
INSERT INTO student_payments VALUES('1390','1','1257','2022-04-14','17500.00','','2022-04-14 18:03:30','2022-04-14 18:03:30');
INSERT INTO student_payments VALUES('1391','1','1270','2022-04-14','18000.00','','2022-04-14 18:04:14','2022-04-14 18:04:14');
INSERT INTO student_payments VALUES('1392','1','1152','2022-04-14','16500.00','','2022-04-14 18:04:58','2022-04-14 18:04:58');
INSERT INTO student_payments VALUES('1393','1','1269','2022-04-14','16000.00','','2022-04-14 18:05:26','2022-04-14 18:05:26');
INSERT INTO student_payments VALUES('1394','1','1308','2022-04-14','16500.00','','2022-04-14 18:06:43','2022-04-14 18:06:43');
INSERT INTO student_payments VALUES('1395','1','1283','2022-04-14','17000.00','','2022-04-14 18:18:01','2022-04-14 18:18:01');
INSERT INTO student_payments VALUES('1396','1','1221','2022-04-14','17500.00','','2022-04-14 18:18:34','2022-04-14 18:18:34');
INSERT INTO student_payments VALUES('1397','1','1251','2022-04-14','13000.00','','2022-04-14 18:20:16','2022-04-14 18:20:16');
INSERT INTO student_payments VALUES('1398','1','1253','2022-04-14','13000.00','','2022-04-14 18:21:07','2022-04-14 18:21:07');
INSERT INTO student_payments VALUES('1399','1','1245','2022-04-14','17500.00','','2022-04-14 18:23:02','2022-04-14 18:23:02');
INSERT INTO student_payments VALUES('1400','1','1238','2022-04-14','17000.00','','2022-04-14 18:23:52','2022-04-14 18:23:52');
INSERT INTO student_payments VALUES('1401','1','1298','2022-04-14','17000.00','','2022-04-14 18:24:44','2022-04-14 18:24:44');
INSERT INTO student_payments VALUES('1402','1','1240','2022-04-14','16000.00','','2022-04-14 18:25:16','2022-04-14 18:25:16');
INSERT INTO student_payments VALUES('1403','1','1239','2022-04-14','17000.00','','2022-04-14 18:25:56','2022-04-14 18:25:56');
INSERT INTO student_payments VALUES('1404','1','406','2022-04-14','1000.00','','2022-04-14 18:26:28','2022-04-14 18:26:28');
INSERT INTO student_payments VALUES('1405','1','1232','2022-04-14','15500.00','','2022-04-14 18:27:20','2022-04-14 18:27:20');
INSERT INTO student_payments VALUES('1406','1','1114','2022-04-14','500.00','','2022-04-14 18:27:49','2022-04-14 18:27:49');
INSERT INTO student_payments VALUES('1407','1','1325','2022-04-14','15500.00','','2022-04-14 18:28:25','2022-04-14 18:28:25');
INSERT INTO student_payments VALUES('1408','1','1305','2022-04-14','16000.00','','2022-04-14 18:31:12','2022-04-14 18:31:12');
INSERT INTO student_payments VALUES('1409','1','1218','2022-04-14','16000.00','','2022-04-14 18:34:12','2022-04-14 18:34:12');
INSERT INTO student_payments VALUES('1410','1','1219','2022-04-14','16000.00','','2022-04-14 18:34:53','2022-04-14 18:34:53');
INSERT INTO student_payments VALUES('1411','1','1105','2022-04-14','20000.00','','2022-04-14 18:36:43','2022-04-14 18:36:43');
INSERT INTO student_payments VALUES('1412','1','733','2022-04-14','1820.00','','2022-04-14 18:38:17','2022-04-14 18:38:17');
INSERT INTO student_payments VALUES('1413','1','1111','2022-04-14','5000.00','','2022-04-14 18:38:49','2022-04-14 18:38:49');
INSERT INTO student_payments VALUES('1414','1','1229','2022-04-14','8180.00','','2022-04-14 18:39:57','2022-04-14 18:39:57');
INSERT INTO student_payments VALUES('1415','1','1324','2022-04-14','15000.00','','2022-04-14 18:42:17','2022-04-14 18:42:17');
INSERT INTO student_payments VALUES('1416','1','1313','2022-04-14','15500.00','','2022-04-14 18:43:05','2022-04-14 18:43:05');
INSERT INTO student_payments VALUES('1417','1','1314','2022-04-14','15500.00','','2022-04-14 18:43:37','2022-04-14 18:43:37');
INSERT INTO student_payments VALUES('1418','1','1300','2022-04-14','18000.00','','2022-04-14 18:45:28','2022-04-14 18:45:28');
INSERT INTO student_payments VALUES('1419','1','1222','2022-04-14','18000.00','','2022-04-14 18:46:28','2022-04-14 18:46:28');
INSERT INTO student_payments VALUES('1420','1','1277','2022-04-14','15000.00','','2022-04-14 18:52:06','2022-04-14 18:52:06');
INSERT INTO student_payments VALUES('1421','1','1302','2022-04-14','17500.00','','2022-04-14 18:53:16','2022-04-14 18:53:16');
INSERT INTO student_payments VALUES('1422','1','1299','2022-04-14','17500.00','','2022-04-14 18:54:02','2022-04-14 18:54:02');
INSERT INTO student_payments VALUES('1423','1','1275','2022-04-13','18000.00','','2022-04-14 19:22:09','2022-04-14 19:22:09');
INSERT INTO student_payments VALUES('1424','1','1320','2022-04-15','19000.00','','2022-04-14 19:23:27','2022-04-14 19:23:27');
INSERT INTO student_payments VALUES('1425','1','1267','2022-04-15','17500.00','','2022-04-14 19:26:23','2022-04-14 19:26:23');
INSERT INTO student_payments VALUES('1426','1','1266','2022-04-15','17500.00','','2022-04-14 19:26:49','2022-04-14 19:26:49');
INSERT INTO student_payments VALUES('1427','1','1032','2022-04-15','1000.00','','2022-04-14 19:27:39','2022-04-14 19:27:39');
INSERT INTO student_payments VALUES('1428','1','1294','2022-04-15','1000.00','','2022-04-14 19:31:28','2022-04-14 19:31:28');
INSERT INTO student_payments VALUES('1429','1','1281','2022-04-15','19000.00','','2022-04-14 19:34:12','2022-04-14 19:34:12');
INSERT INTO student_payments VALUES('1430','1','1292','2022-04-15','17000.00','','2022-04-14 19:35:43','2022-04-14 19:35:43');
INSERT INTO student_payments VALUES('1431','1','1284','2022-04-16','27000.00','','2022-04-16 06:33:45','2022-04-16 06:33:45');
INSERT INTO student_payments VALUES('1432','1','1227','2022-04-16','15000.00','','2022-04-16 06:38:17','2022-04-16 06:38:17');
INSERT INTO student_payments VALUES('1433','1','1306','2022-04-14','17000.00','','2022-04-16 06:40:38','2022-04-16 06:40:38');
INSERT INTO student_payments VALUES('1434','1','1310','2022-04-15','22000.00','','2022-04-16 09:14:59','2022-04-16 09:14:59');
INSERT INTO student_payments VALUES('1435','1','1174','2022-04-17','4000.00','','2022-04-20 15:18:03','2022-04-20 15:18:03');
INSERT INTO student_payments VALUES('1436','1','1273','2022-04-19','17000.00','','2022-04-20 15:29:57','2022-04-20 15:29:57');
INSERT INTO student_payments VALUES('1437','1','1039','2022-04-19','500.00','','2022-04-20 15:32:08','2022-04-20 15:32:08');
INSERT INTO student_payments VALUES('1438','1','1157','2022-04-19','2000.00','','2022-04-20 15:33:30','2022-04-20 15:33:30');
INSERT INTO student_payments VALUES('1439','1','1274','2022-04-19','2000.00','','2022-04-20 15:34:04','2022-04-20 15:34:04');
INSERT INTO student_payments VALUES('1440','1','1242','2022-04-19','2000.00','','2022-04-20 15:38:21','2022-04-20 15:38:21');
INSERT INTO student_payments VALUES('1444','1','1312','2022-04-19','500.00','','2022-04-20 16:06:11','2022-04-20 16:06:11');
INSERT INTO student_payments VALUES('1445','1','1085','2022-04-19','500.00','','2022-04-20 16:08:15','2022-04-20 16:08:15');
INSERT INTO student_payments VALUES('1447','1','1227','2022-04-21','2000.00','','2022-04-21 15:08:30','2022-04-21 15:08:30');
INSERT INTO student_payments VALUES('1448','1','1335','2022-04-21','16500.00','','2022-04-24 10:32:35','2022-04-24 10:32:35');
INSERT INTO student_payments VALUES('1449','1','1237','2022-04-22','8000.00','','2022-04-24 10:40:58','2022-04-24 10:40:58');
INSERT INTO student_payments VALUES('1450','1','540','2022-04-24','3000.00','','2022-04-24 10:43:00','2022-04-24 10:43:00');
INSERT INTO student_payments VALUES('1451','1','1264','2022-04-22','2000.00','','2022-04-24 10:44:34','2022-04-24 10:44:34');
INSERT INTO student_payments VALUES('1453','1','1340','2022-04-28','10000.00','','2022-04-28 17:00:04','2022-04-28 17:00:04');
INSERT INTO student_payments VALUES('1455','1','1337','2022-04-28','10000.00','','2022-04-28 17:02:35','2022-04-28 17:02:35');
INSERT INTO student_payments VALUES('1456','1','1053','2022-04-28','500.00','','2022-04-28 17:03:01','2022-04-28 17:03:01');
INSERT INTO student_payments VALUES('1457','1','1339','2022-04-28','10000.00','','2022-04-28 17:04:48','2022-04-28 17:04:48');
INSERT INTO student_payments VALUES('1458','1','1341','2022-04-28','17500.00','','2022-04-28 17:10:48','2022-04-28 17:10:48');
INSERT INTO student_payments VALUES('1459','1','1395','2022-05-01','17500.00','','2022-05-06 13:18:47','2022-05-06 13:18:47');
INSERT INTO student_payments VALUES('1460','1','1451','2022-05-06','16000.00','','2022-05-06 13:19:49','2022-05-06 13:19:49');
INSERT INTO student_payments VALUES('1461','1','1413','2022-05-01','15000.00','','2022-05-06 13:29:58','2022-05-06 13:29:58');
INSERT INTO student_payments VALUES('1462','1','1439','2022-05-02','17000.00','','2022-05-06 13:30:58','2022-05-06 13:30:58');
INSERT INTO student_payments VALUES('1463','1','1350','2022-05-02','17000.00','','2022-05-06 13:34:16','2022-05-06 13:34:16');
INSERT INTO student_payments VALUES('1464','1','1381','2022-05-01','17500.00','','2022-05-06 13:35:34','2022-05-06 13:35:34');
INSERT INTO student_payments VALUES('1465','1','1347','2022-05-04','17500.00','','2022-05-06 13:36:03','2022-05-06 13:36:03');
INSERT INTO student_payments VALUES('1466','1','1366','2022-05-01','17500.00','','2022-05-06 13:37:07','2022-05-06 13:37:07');
INSERT INTO student_payments VALUES('1467','1','1374','2022-05-03','17000.00','','2022-05-06 13:38:43','2022-05-06 13:38:43');
INSERT INTO student_payments VALUES('1468','1','1375','2022-05-03','17000.00','','2022-05-06 13:39:09','2022-05-06 13:39:09');
INSERT INTO student_payments VALUES('1469','1','1346','2022-05-01','24000.00','','2022-05-06 13:39:45','2022-05-06 13:39:45');
INSERT INTO student_payments VALUES('1470','1','1440','2022-05-04','17000.00','','2022-05-06 13:40:21','2022-05-06 13:40:21');
INSERT INTO student_payments VALUES('1471','1','1422','2022-05-05','17000.00','','2022-05-06 13:41:57','2022-05-06 13:41:57');
INSERT INTO student_payments VALUES('1472','1','1365','2022-05-06','16000.00','','2022-05-06 13:42:38','2022-05-06 13:42:38');
INSERT INTO student_payments VALUES('1473','1','1237','2022-05-04','8000.00','','2022-05-06 13:44:33','2022-05-06 13:44:33');
INSERT INTO student_payments VALUES('1474','1','1447','2022-05-05','15500.00','','2022-05-06 13:45:29','2022-05-06 13:45:29');
INSERT INTO student_payments VALUES('1475','1','1351','2022-05-02','17000.00','','2022-05-06 13:46:02','2022-05-06 13:46:02');
INSERT INTO student_payments VALUES('1476','1','1353','2022-05-05','17000.00','','2022-05-06 13:46:24','2022-05-06 13:46:24');
INSERT INTO student_payments VALUES('1477','1','1414','2022-05-04','19500.00','','2022-05-06 13:46:55','2022-05-06 13:46:55');
INSERT INTO student_payments VALUES('1478','1','1369','2022-05-06','17500.00','','2022-05-06 14:24:17','2022-05-06 14:24:17');
INSERT INTO student_payments VALUES('1479','1','1418','2022-05-06','15000.00','','2022-05-06 15:42:52','2022-05-06 15:42:52');
INSERT INTO student_payments VALUES('1480','1','1457','2022-05-06','2345.00','','2022-05-06 15:48:54','2022-05-06 15:48:54');
INSERT INTO student_payments VALUES('1481','1','1359','2022-05-06','15500.00','','2022-05-06 15:57:48','2022-05-06 15:57:48');
INSERT INTO student_payments VALUES('1482','1','1434','2022-05-06','17000.00','','2022-05-06 16:19:24','2022-05-06 16:19:24');
INSERT INTO student_payments VALUES('1483','1','1360','2022-05-07','16000.00','','2022-05-07 14:34:38','2022-05-07 14:34:38');
INSERT INTO student_payments VALUES('1484','1','1417','2022-05-07','17000.00','','2022-05-07 14:37:07','2022-05-07 14:37:07');
INSERT INTO student_payments VALUES('1485','1','1402','2022-05-07','14000.00','','2022-05-07 14:37:54','2022-05-07 14:37:54');
INSERT INTO student_payments VALUES('1486','1','1430','2022-05-07','17000.00','','2022-05-07 14:40:01','2022-05-07 14:40:01');
INSERT INTO student_payments VALUES('1487','1','1384','2022-05-07','15000.00','','2022-05-07 14:49:02','2022-05-07 14:49:02');
INSERT INTO student_payments VALUES('1488','1','1385','2022-05-07','15000.00','','2022-05-07 15:11:39','2022-05-07 15:11:39');
INSERT INTO student_payments VALUES('1489','1','1396','2022-05-07','19000.00','','2022-05-07 15:13:39','2022-05-07 15:13:39');
INSERT INTO student_payments VALUES('1490','1','1370','2022-05-07','17500.00','','2022-05-07 15:47:50','2022-05-07 15:47:50');
INSERT INTO student_payments VALUES('1491','1','1263','2022-05-07','1500.00','','2022-05-07 16:16:58','2022-05-07 16:16:58');
INSERT INTO student_payments VALUES('1492','1','1387','2022-05-07','17500.00','','2022-05-07 16:17:30','2022-05-07 16:17:30');
INSERT INTO student_payments VALUES('1493','1','1388','2022-05-07','17500.00','','2022-05-07 16:17:56','2022-05-07 16:17:56');
INSERT INTO student_payments VALUES('1494','1','1446','2022-05-07','15500.00','','2022-05-07 16:41:58','2022-05-07 16:41:58');
INSERT INTO student_payments VALUES('1495','1','1362','2022-05-07','16000.00','','2022-05-08 13:33:22','2022-05-08 13:33:22');
INSERT INTO student_payments VALUES('1496','1','1438','2022-05-08','17500.00','','2022-05-08 13:40:47','2022-05-08 13:40:47');
INSERT INTO student_payments VALUES('1497','1','991','2022-05-08','500.00','','2022-05-08 15:10:17','2022-05-08 15:10:17');
INSERT INTO student_payments VALUES('1498','1','1354','2022-05-08','20790.00','','2022-05-08 15:10:40','2022-05-08 15:10:40');
INSERT INTO student_payments VALUES('1499','1','1400','2022-05-08','15000.00','','2022-05-08 15:19:00','2022-05-08 15:19:00');
INSERT INTO student_payments VALUES('1500','1','1361','2022-05-08','7000.00','','2022-05-08 15:20:05','2022-05-08 15:20:05');
INSERT INTO student_payments VALUES('1501','1','1345','2022-05-08','16000.00','','2022-05-08 15:27:34','2022-05-08 15:27:34');
INSERT INTO student_payments VALUES('1502','1','1453','2022-05-08','19000.00','','2022-05-08 16:54:00','2022-05-08 16:54:00');
INSERT INTO student_payments VALUES('1503','1','1021','2022-05-08','3000.00','','2022-05-08 17:04:57','2022-05-08 17:04:57');
INSERT INTO student_payments VALUES('1504','1','1380','2022-05-08','17500.00','','2022-05-08 17:05:19','2022-05-08 17:05:19');
INSERT INTO student_payments VALUES('1505','1','1442','2022-05-08','19000.00','','2022-05-08 17:10:00','2022-05-08 17:10:00');
INSERT INTO student_payments VALUES('1506','1','1441','2022-05-08','15000.00','','2022-05-08 17:13:20','2022-05-08 17:13:20');
INSERT INTO student_payments VALUES('1507','1','1455','2022-05-08','19000.00','','2022-05-08 17:40:56','2022-05-08 17:40:56');
INSERT INTO student_payments VALUES('1508','1','1444','2022-05-09','16500.00','','2022-05-09 13:45:40','2022-05-09 13:45:40');
INSERT INTO student_payments VALUES('1509','1','1373','2022-05-09','17000.00','','2022-05-09 13:47:47','2022-05-09 13:47:47');
INSERT INTO student_payments VALUES('1510','1','1405','2022-05-09','19000.00','','2022-05-09 13:50:47','2022-05-09 13:50:47');
INSERT INTO student_payments VALUES('1511','1','1344','2022-05-09','16000.00','','2022-05-09 14:24:14','2022-05-09 14:24:14');
INSERT INTO student_payments VALUES('1512','1','1449','2022-05-09','19000.00','','2022-05-09 15:24:12','2022-05-09 15:24:12');
INSERT INTO student_payments VALUES('1513','1','1450','2022-05-09','19000.00','','2022-05-09 15:24:56','2022-05-09 15:24:56');
INSERT INTO student_payments VALUES('1514','1','1407','2022-05-09','17950.00','','2022-05-09 15:28:20','2022-05-09 15:28:20');
INSERT INTO student_payments VALUES('1515','1','1461','2022-05-09','16000.00','','2022-05-09 15:48:22','2022-05-09 15:48:22');
INSERT INTO student_payments VALUES('1516','1','1358','2022-05-09','15880.00','','2022-05-09 16:27:39','2022-05-09 16:27:39');
INSERT INTO student_payments VALUES('1517','1','1386','2022-05-09','14000.00','','2022-05-09 16:39:06','2022-05-09 16:39:06');
INSERT INTO student_payments VALUES('1518','1','12','2022-05-09','500.00','','2022-05-09 16:39:36','2022-05-09 16:39:36');
INSERT INTO student_payments VALUES('1519','1','1443','2022-05-09','15000.00','','2022-05-09 16:40:23','2022-05-09 16:40:23');
INSERT INTO student_payments VALUES('1520','1','1383','2022-05-09','18450.00','','2022-05-09 16:45:58','2022-05-09 16:45:58');
INSERT INTO student_payments VALUES('1521','1','1371','2022-05-09','17500.00','','2022-05-09 17:15:49','2022-05-09 17:15:49');
INSERT INTO student_payments VALUES('1522','1','1423','2022-05-10','17500.00','','2022-05-10 14:23:20','2022-05-10 14:23:20');
INSERT INTO student_payments VALUES('1523','1','1426','2022-05-10','17500.00','','2022-05-10 14:23:55','2022-05-10 14:23:55');
INSERT INTO student_payments VALUES('1524','1','1372','2022-05-10','17000.00','','2022-05-10 14:38:04','2022-05-10 14:38:04');
INSERT INTO student_payments VALUES('1525','1','1459','2022-05-10','16000.00','','2022-05-10 15:11:18','2022-05-10 15:11:18');
INSERT INTO student_payments VALUES('1526','1','846','2022-05-10','2000.00','','2022-05-10 15:32:42','2022-05-10 15:32:42');
INSERT INTO student_payments VALUES('1527','1','1432','2022-05-10','22000.00','','2022-05-10 15:33:27','2022-05-10 15:33:27');
INSERT INTO student_payments VALUES('1528','1','1429','2022-05-10','16000.00','','2022-05-10 16:00:51','2022-05-10 16:00:51');
INSERT INTO student_payments VALUES('1529','1','1454','2022-05-10','17000.00','','2022-05-10 16:56:10','2022-05-10 16:56:10');
INSERT INTO student_payments VALUES('1530','1','1342','2022-05-10','17000.00','','2022-05-10 17:17:14','2022-05-10 17:17:14');
INSERT INTO student_payments VALUES('1531','1','1409','2022-05-10','17000.00','','2022-05-10 17:28:04','2022-05-10 17:28:04');
INSERT INTO student_payments VALUES('1532','1','1406','2022-05-10','15000.00','','2022-05-11 13:16:35','2022-05-11 13:16:35');
INSERT INTO student_payments VALUES('1533','1','1410','2022-05-10','17000.00','','2022-05-11 13:20:07','2022-05-11 13:20:07');
INSERT INTO student_payments VALUES('1534','1','1364','2022-05-10','17000.00','','2022-05-11 13:21:42','2022-05-11 13:21:42');
INSERT INTO student_payments VALUES('1535','1','1394','2022-05-11','18000.00','','2022-05-11 14:24:36','2022-05-11 14:24:36');
INSERT INTO student_payments VALUES('1536','1','1452','2022-05-11','19000.00','','2022-05-11 16:13:51','2022-05-11 16:13:51');
INSERT INTO student_payments VALUES('1537','1','1408','2022-05-11','18000.00','','2022-05-11 16:18:31','2022-05-11 16:18:31');
INSERT INTO student_payments VALUES('1538','1','1352','2022-05-11','17000.00','','2022-05-11 16:24:50','2022-05-11 16:24:50');
INSERT INTO student_payments VALUES('1539','1','1361','2022-05-09','9000.00','','2022-05-11 16:26:54','2022-05-11 16:26:54');
INSERT INTO student_payments VALUES('1540','1','1363','2022-05-11','17000.00','','2022-05-11 16:28:22','2022-05-11 16:28:22');
INSERT INTO student_payments VALUES('1541','1','1427','2022-05-10','17480.00','','2022-05-11 16:33:39','2022-05-11 16:33:39');
INSERT INTO student_payments VALUES('1542','1','1420','2022-05-11','17000.00','','2022-05-11 16:35:23','2022-05-11 16:35:23');
INSERT INTO student_payments VALUES('1543','1','1404','2022-05-12','17500.00','','2022-05-12 14:02:44','2022-05-12 14:02:44');
INSERT INTO student_payments VALUES('1544','1','1389','2022-05-12','17500.00','','2022-05-12 14:03:18','2022-05-12 14:03:18');
INSERT INTO student_payments VALUES('1545','1','1401','2022-05-13','15000.00','','2022-05-13 13:36:47','2022-05-13 13:36:47');
INSERT INTO student_payments VALUES('1546','1','1403','2022-05-13','14000.00','','2022-05-13 13:37:16','2022-05-13 13:37:16');
INSERT INTO student_payments VALUES('1547','1','1411','2022-05-13','15000.00','','2022-05-13 13:37:36','2022-05-13 13:37:36');
INSERT INTO student_payments VALUES('1548','1','1367','2022-05-12','14000.00','','2022-05-13 14:04:52','2022-05-13 14:04:52');
INSERT INTO student_payments VALUES('1549','1','1242','2022-05-12','1000.00','','2022-05-13 14:05:30','2022-05-13 14:05:30');
INSERT INTO student_payments VALUES('1550','1','1230','2022-05-12','20000.00','','2022-05-13 14:33:00','2022-05-13 14:33:00');
INSERT INTO student_payments VALUES('1551','1','1356','2022-05-13','20000.00','','2022-05-13 14:33:55','2022-05-13 14:33:55');
INSERT INTO student_payments VALUES('1552','1','1355','2022-05-12','20000.00','','2022-05-13 14:38:39','2022-05-13 14:38:39');
INSERT INTO student_payments VALUES('1553','1','1445','2022-05-12','15000.00','','2022-05-13 14:44:35','2022-05-13 14:44:35');
INSERT INTO student_payments VALUES('1554','1','1460','2022-05-12','16000.00','','2022-05-13 15:01:12','2022-05-13 15:01:12');
INSERT INTO student_payments VALUES('1555','1','1462','2022-05-13','680.00','','2022-05-13 15:01:33','2022-05-13 15:01:33');
INSERT INTO student_payments VALUES('1556','1','1376','2022-05-13','13000.00','','2022-05-13 15:03:55','2022-05-13 15:03:55');
INSERT INTO student_payments VALUES('1557','1','1377','2022-05-13','13000.00','','2022-05-13 15:04:19','2022-05-13 15:04:19');
INSERT INTO student_payments VALUES('1558','1','1378','2022-05-13','13000.00','','2022-05-13 15:04:49','2022-05-13 15:04:49');
INSERT INTO student_payments VALUES('1559','1','1398','2022-05-12','10000.00','','2022-05-13 15:06:42','2022-05-13 15:06:42');
INSERT INTO student_payments VALUES('1560','1','1368','2022-05-12','17500.00','','2022-05-13 15:37:24','2022-05-13 15:37:24');
INSERT INTO student_payments VALUES('1561','1','1463','2022-05-12','10000.00','','2022-05-13 15:37:59','2022-05-13 15:37:59');
INSERT INTO student_payments VALUES('1562','1','1343','2022-05-11','10000.00','','2022-05-13 15:40:40','2022-05-13 15:40:40');
INSERT INTO student_payments VALUES('1563','1','1392','2022-05-13','14000.00','','2022-05-13 15:41:05','2022-05-13 15:41:05');
INSERT INTO student_payments VALUES('1564','1','1433','2022-05-14','22000.00','','2022-05-14 12:11:45','2022-05-14 12:11:45');
INSERT INTO student_payments VALUES('1565','1','1348','2022-05-15','18000.00','','2022-05-15 14:32:02','2022-05-15 14:32:02');
INSERT INTO student_payments VALUES('1566','1','1465','2022-05-15','1000.00','','2022-05-15 14:35:25','2022-05-15 14:35:25');
INSERT INTO student_payments VALUES('1567','1','1466','2022-05-15','1000.00','','2022-05-15 14:36:14','2022-05-15 14:36:14');
INSERT INTO student_payments VALUES('1568','1','1032','2022-05-15','500.00','','2022-05-15 14:37:14','2022-05-15 14:37:14');
INSERT INTO student_payments VALUES('1569','1','1390','2022-05-15','17500.00','','2022-05-15 14:37:47','2022-05-15 14:37:47');
INSERT INTO student_payments VALUES('1570','1','1464','2022-05-15','2920.00','','2022-05-15 14:54:43','2022-05-15 14:54:43');
INSERT INTO student_payments VALUES('1571','1','1398','2022-05-15','7000.00','','2022-05-15 14:55:13','2022-05-15 14:55:13');
INSERT INTO student_payments VALUES('1572','1','1399','2022-05-15','15000.00','','2022-05-15 14:57:18','2022-05-15 14:57:18');
INSERT INTO student_payments VALUES('1573','1','1467','2022-05-15','480.00','','2022-05-15 15:50:39','2022-05-15 15:50:39');
INSERT INTO student_payments VALUES('1574','1','1468','2022-05-16','10000.00','','2022-05-16 15:17:35','2022-05-16 15:17:35');
INSERT INTO student_payments VALUES('1575','1','1469','2022-05-16','10000.00','','2022-05-16 15:18:04','2022-05-16 15:18:04');
INSERT INTO student_payments VALUES('1576','1','1456','2022-05-16','17500.00','','2022-05-16 15:18:41','2022-05-16 15:18:41');
INSERT INTO student_payments VALUES('1577','1','1379','2022-05-17','18520.00','','2022-05-17 17:14:56','2022-05-17 17:14:56');
INSERT INTO student_payments VALUES('1578','1','1421','2022-05-21','18030.00','','2022-05-22 06:34:00','2022-05-22 06:34:00');
INSERT INTO student_payments VALUES('1579','1','1470','2022-05-19','1530.00','','2022-05-22 06:34:29','2022-05-22 06:34:29');
INSERT INTO student_payments VALUES('1580','1','1471','2022-05-22','1530.00','','2022-05-22 06:34:47','2022-05-22 06:34:47');
INSERT INTO student_payments VALUES('1581','1','1472','2022-05-22','1530.00','','2022-05-22 06:35:06','2022-05-22 06:35:06');
INSERT INTO student_payments VALUES('1582','1','1424','2022-05-18','18000.00','','2022-05-22 06:36:03','2022-05-22 06:36:03');
INSERT INTO student_payments VALUES('1583','1','632','2022-05-21','870.00','','2022-05-22 06:41:11','2022-05-22 06:41:11');
INSERT INTO student_payments VALUES('1584','1','997','2022-05-21','1000.00','','2022-05-22 06:41:32','2022-05-22 06:41:32');
INSERT INTO student_payments VALUES('1585','1','1357','2022-05-21','13630.00','','2022-05-22 06:42:08','2022-05-22 06:42:08');
INSERT INTO student_payments VALUES('1586','1','1475','2022-05-20','380.00','','2022-05-22 06:42:34','2022-05-22 06:42:34');
INSERT INTO student_payments VALUES('1587','1','1477','2022-05-22','480.00','','2022-05-22 06:46:29','2022-05-22 06:46:29');
INSERT INTO student_payments VALUES('1588','1','1412','2022-05-21','23310.00','','2022-05-22 06:53:54','2022-05-22 06:53:54');
INSERT INTO student_payments VALUES('1589','1','1478','2022-05-22','5000.00','','2022-05-22 06:58:45','2022-05-22 06:58:45');
INSERT INTO student_payments VALUES('1590','1','1382','2022-05-20','17500.00','','2022-05-22 07:00:08','2022-05-22 07:00:08');
INSERT INTO student_payments VALUES('1591','1','1458','2022-05-18','16000.00','','2022-05-22 07:01:32','2022-05-22 07:01:32');
INSERT INTO student_payments VALUES('1592','1','1479','2022-05-22','15600.00','','2022-05-22 07:11:43','2022-05-22 07:11:43');
INSERT INTO student_payments VALUES('1593','1','1480','2022-05-22','500.00','','2022-05-22 07:18:04','2022-05-22 07:18:04');
INSERT INTO student_payments VALUES('1594','1','1483','2022-05-22','160.00','','2022-05-22 07:29:43','2022-05-22 07:29:43');
INSERT INTO student_payments VALUES('1595','1','1485','2022-05-22','160.00','','2022-05-22 07:30:08','2022-05-22 07:30:08');
INSERT INTO student_payments VALUES('1596','1','1491','2022-05-22','240.00','','2022-05-22 07:47:25','2022-05-22 07:47:25');
INSERT INTO student_payments VALUES('1597','1','1399','2022-05-27','3000.00','','2022-05-27 15:57:52','2022-05-27 15:57:52');
INSERT INTO student_payments VALUES('1598','1','1416','2022-05-27','17000.00','','2022-05-28 14:43:56','2022-05-28 14:43:56');
INSERT INTO student_payments VALUES('1599','1','1391','2022-05-27','17500.00','','2022-05-28 14:46:34','2022-05-28 14:46:34');
INSERT INTO student_payments VALUES('1600','1','1490','2022-05-27','1000.00','','2022-05-28 14:46:56','2022-05-28 14:46:56');
INSERT INTO student_payments VALUES('1601','1','1474','2022-05-31','380.00','','2022-05-31 13:32:56','2022-05-31 13:32:56');
INSERT INTO student_payments VALUES('1602','1','1492','2022-05-31','6000.00','','2022-05-31 13:36:19','2022-05-31 13:36:19');
INSERT INTO student_payments VALUES('1603','1','1493','2022-05-31','6000.00','','2022-05-31 13:36:43','2022-05-31 13:36:43');
INSERT INTO student_payments VALUES('1604','1','1494','2022-05-31','6000.00','','2022-05-31 13:37:02','2022-05-31 13:37:02');
INSERT INTO student_payments VALUES('1605','1','1495','2022-05-31','10000.00','','2022-05-31 14:01:12','2022-05-31 14:01:12');
INSERT INTO student_payments VALUES('1606','1','1496','2022-05-31','10000.00','','2022-05-31 14:01:32','2022-05-31 14:01:32');
INSERT INTO student_payments VALUES('1607','1','1497','2022-05-31','10000.00','','2022-05-31 14:02:09','2022-05-31 14:02:09');
INSERT INTO student_payments VALUES('1608','1','1498','2022-05-31','10000.00','','2022-05-31 14:02:36','2022-05-31 14:02:36');
INSERT INTO student_payments VALUES('1609','1','1611','2022-06-01','15500.00','','2022-06-01 14:36:36','2022-06-01 14:36:36');
INSERT INTO student_payments VALUES('1610','1','1603','2022-06-01','16000.00','','2022-06-01 14:39:23','2022-06-01 14:39:23');
INSERT INTO student_payments VALUES('1611','1','1612','2022-06-01','15500.00','','2022-06-01 14:42:46','2022-06-01 14:42:46');
INSERT INTO student_payments VALUES('1612','1','1609','2022-06-01','17000.00','','2022-06-01 14:45:25','2022-06-01 14:45:25');
INSERT INTO student_payments VALUES('1613','1','1503','2022-06-01','24000.00','','2022-06-01 14:52:43','2022-06-01 14:52:43');
INSERT INTO student_payments VALUES('1614','1','1515','2022-06-02','16320.00','','2022-06-02 13:30:29','2022-06-02 13:30:29');
INSERT INTO student_payments VALUES('1615','1','1599','2022-06-02','16320.00','','2022-06-02 14:14:34','2022-06-02 14:14:34');
INSERT INTO student_payments VALUES('1616','1','1591','2022-06-02','17000.00','','2022-06-02 17:07:13','2022-06-02 17:07:13');
INSERT INTO student_payments VALUES('1617','1','1607','2022-06-02','19000.00','','2022-06-02 17:08:41','2022-06-02 17:08:41');
INSERT INTO student_payments VALUES('1618','1','1529','2022-06-02','17000.00','','2022-06-02 17:14:57','2022-06-02 17:14:57');
INSERT INTO student_payments VALUES('1619','1','1569','2022-06-03','15000.00','','2022-06-03 16:37:32','2022-06-03 16:37:32');
INSERT INTO student_payments VALUES('1620','1','1522','2022-06-03','16300.00','','2022-06-03 16:44:55','2022-06-03 16:44:55');
INSERT INTO student_payments VALUES('1621','1','1431','2022-06-03','15000.00','','2022-06-03 16:51:05','2022-06-03 16:51:05');
INSERT INTO student_payments VALUES('1622','1','1269','2022-06-03','500.00','','2022-06-03 16:54:38','2022-06-03 16:54:38');
INSERT INTO student_payments VALUES('1623','1','1550','2022-06-03','16500.00','','2022-06-03 16:55:15','2022-06-03 16:55:15');
INSERT INTO student_payments VALUES('1624','1','1393','2022-06-03','7500.00','','2022-06-03 17:09:09','2022-06-03 17:09:09');
INSERT INTO student_payments VALUES('1625','1','1079','2022-06-03','1500.00','','2022-06-03 17:36:17','2022-06-03 17:36:17');
INSERT INTO student_payments VALUES('1626','1','1431','2022-06-03','2000.00','','2022-06-03 17:36:48','2022-06-03 17:36:48');
INSERT INTO student_payments VALUES('1627','1','1583','2022-06-03','6500.00','','2022-06-03 17:37:28','2022-06-03 17:37:28');
INSERT INTO student_payments VALUES('1628','1','1566','2022-06-03','17000.00','','2022-06-03 17:38:14','2022-06-03 17:38:14');
INSERT INTO student_payments VALUES('1629','1','1586','2022-06-03','17000.00','','2022-06-03 17:39:03','2022-06-03 17:39:03');
INSERT INTO student_payments VALUES('1630','1','1592','2022-06-03','17000.00','','2022-06-03 17:42:33','2022-06-03 17:42:33');
INSERT INTO student_payments VALUES('1631','1','1518','2022-06-03','8000.00','','2022-06-03 17:47:37','2022-06-03 17:47:37');
INSERT INTO student_payments VALUES('1632','1','1500','2022-06-03','10000.00','','2022-06-03 18:15:11','2022-06-03 18:15:11');
INSERT INTO student_payments VALUES('1633','1','1553','2022-06-04','20500.00','','2022-06-04 17:13:42','2022-06-04 17:13:42');
INSERT INTO student_payments VALUES('1634','1','1523','2022-06-04','17500.00','','2022-06-04 17:14:43','2022-06-04 17:14:43');
INSERT INTO student_payments VALUES('1635','1','1510','2022-06-04','17000.00','','2022-06-04 17:15:08','2022-06-04 17:15:08');
INSERT INTO student_payments VALUES('1636','1','1572','2022-06-04','17000.00','','2022-06-04 17:17:25','2022-06-04 17:17:25');
INSERT INTO student_payments VALUES('1637','1','1543','2022-06-04','14000.00','','2022-06-04 17:29:34','2022-06-04 17:29:34');
INSERT INTO student_payments VALUES('1638','1','1613','2022-06-04','1540.00','','2022-06-04 17:36:15','2022-06-04 17:36:15');
INSERT INTO student_payments VALUES('1639','1','1511','2022-06-05','20120.00','','2022-06-05 15:27:18','2022-06-05 15:27:18');
INSERT INTO student_payments VALUES('1640','1','1614','2022-06-05','520.00','','2022-06-05 16:02:39','2022-06-05 16:02:39');
INSERT INTO student_payments VALUES('1641','1','1561','2022-06-05','19800.00','','2022-06-05 17:00:39','2022-06-05 17:00:39');
INSERT INTO student_payments VALUES('1642','1','1556','2022-06-05','15000.00','','2022-06-05 17:05:11','2022-06-05 17:05:11');
INSERT INTO student_payments VALUES('1643','1','1499','2022-06-05','17000.00','','2022-06-05 17:05:48','2022-06-05 17:05:48');
INSERT INTO student_payments VALUES('1644','1','1567','2022-06-05','15000.00','','2022-06-05 17:24:06','2022-06-05 17:24:06');
INSERT INTO student_payments VALUES('1645','1','1384','2022-06-05','2950.00','','2022-06-05 17:34:06','2022-06-05 17:34:06');
INSERT INTO student_payments VALUES('1646','1','1541','2022-06-05','18500.00','','2022-06-05 17:35:00','2022-06-05 17:35:00');
INSERT INTO student_payments VALUES('1647','1','1554','2022-06-05','14000.00','','2022-06-05 17:54:31','2022-06-05 17:54:31');
INSERT INTO student_payments VALUES('1648','1','1582','2022-06-05','17000.00','','2022-06-05 17:57:22','2022-06-05 17:57:22');
INSERT INTO student_payments VALUES('1649','1','1590','2022-06-05','17500.00','','2022-06-05 18:12:31','2022-06-05 18:12:31');
INSERT INTO student_payments VALUES('1650','1','1602','2022-06-06','19520.00','','2022-06-06 11:56:38','2022-06-06 11:56:38');
INSERT INTO student_payments VALUES('1651','1','1570','2022-06-06','19500.00','','2022-06-06 11:59:33','2022-06-06 11:59:33');
INSERT INTO student_payments VALUES('1652','1','1593','2022-06-06','15000.00','','2022-06-06 12:15:08','2022-06-06 12:15:08');
INSERT INTO student_payments VALUES('1653','1','1558','2022-06-06','10000.00','','2022-06-06 12:19:38','2022-06-06 12:19:38');
INSERT INTO student_payments VALUES('1654','1','1519','2022-06-06','16000.00','','2022-06-06 14:55:06','2022-06-06 14:55:06');
INSERT INTO student_payments VALUES('1655','1','406','2022-06-06','500.00','','2022-06-06 15:11:27','2022-06-06 15:11:27');
INSERT INTO student_payments VALUES('1656','1','1521','2022-06-06','12500.00','','2022-06-06 15:11:57','2022-06-06 15:11:57');
INSERT INTO student_payments VALUES('1657','1','1576','2022-06-06','17600.00','','2022-06-06 15:13:40','2022-06-06 15:13:40');
INSERT INTO student_payments VALUES('1658','1','1540','2022-06-06','17500.00','','2022-06-06 15:42:10','2022-06-06 15:42:10');
INSERT INTO student_payments VALUES('1659','1','1502','2022-06-06','11520.00','','2022-06-06 15:53:29','2022-06-06 15:53:29');
INSERT INTO student_payments VALUES('1660','1','1526','2022-06-06','22480.00','','2022-06-06 15:59:47','2022-06-06 15:59:47');
INSERT INTO student_payments VALUES('1661','1','1527','2022-06-06','17500.00','','2022-06-06 16:01:05','2022-06-06 16:01:05');
INSERT INTO student_payments VALUES('1662','1','1517','2022-06-06','16000.00','','2022-06-06 17:15:47','2022-06-06 17:15:47');
INSERT INTO student_payments VALUES('1663','1','1596','2022-06-06','10000.00','','2022-06-06 17:31:22','2022-06-06 17:31:22');
INSERT INTO student_payments VALUES('1664','1','1501','2022-06-06','11520.00','','2022-06-06 17:31:44','2022-06-06 17:31:44');
INSERT INTO student_payments VALUES('1665','1','1596','2022-06-06','8420.00','','2022-06-06 18:16:47','2022-06-06 18:16:47');
INSERT INTO student_payments VALUES('1666','1','1504','2022-06-06','17500.00','','2022-06-06 18:48:55','2022-06-06 18:48:55');
INSERT INTO student_payments VALUES('1667','1','1520','2022-06-07','17500.00','','2022-06-07 14:09:08','2022-06-07 14:09:08');
INSERT INTO student_payments VALUES('1668','1','1513','2022-06-07','20000.00','','2022-06-07 14:12:15','2022-06-07 14:12:15');
INSERT INTO student_payments VALUES('1669','1','1229','2022-06-07','11820.00','','2022-06-07 14:20:26','2022-06-07 14:20:26');
INSERT INTO student_payments VALUES('1670','1','1355','2022-06-07','4920.00','','2022-06-07 14:21:03','2022-06-07 14:21:03');
INSERT INTO student_payments VALUES('1671','1','1512','2022-06-07','11960.00','','2022-06-07 14:21:41','2022-06-07 14:21:41');
INSERT INTO student_payments VALUES('1672','1','1549','2022-06-07','14000.00','','2022-06-07 14:46:07','2022-06-07 14:46:07');
INSERT INTO student_payments VALUES('1673','1','1527','2022-06-07','4980.00','','2022-06-07 15:11:33','2022-06-07 15:11:33');
INSERT INTO student_payments VALUES('1674','1','1463','2022-06-07','740.00','','2022-06-07 15:12:59','2022-06-07 15:12:59');
INSERT INTO student_payments VALUES('1675','1','1604','2022-06-07','19000.00','','2022-06-07 15:22:57','2022-06-07 15:22:57');
INSERT INTO student_payments VALUES('1676','1','1476','2022-06-07','480.00','','2022-06-07 15:30:48','2022-06-07 15:30:48');
INSERT INTO student_payments VALUES('1677','1','1508','2022-06-07','17900.00','','2022-06-07 15:31:43','2022-06-07 15:31:43');
INSERT INTO student_payments VALUES('1678','1','1505','2022-06-07','18000.00','','2022-06-07 15:41:17','2022-06-07 15:41:17');
INSERT INTO student_payments VALUES('1679','1','1589','2022-06-07','16000.00','','2022-06-07 16:15:41','2022-06-07 16:15:41');
INSERT INTO student_payments VALUES('1680','1','1600','2022-06-07','16000.00','','2022-06-07 16:16:18','2022-06-07 16:16:18');
INSERT INTO student_payments VALUES('1681','1','1616','2022-06-07','900.00','','2022-06-07 16:23:24','2022-06-07 16:23:24');
INSERT INTO student_payments VALUES('1682','1','1615','2022-06-07','2930.00','','2022-06-07 16:36:55','2022-06-07 16:36:55');
INSERT INTO student_payments VALUES('1683','1','1507','2022-06-07','17000.00','','2022-06-07 16:41:14','2022-06-07 16:41:14');
INSERT INTO student_payments VALUES('1684','1','1481','2022-06-07','950.00','','2022-06-07 16:41:38','2022-06-07 16:41:38');
INSERT INTO student_payments VALUES('1685','1','1563','2022-06-07','19930.00','','2022-06-07 16:45:41','2022-06-07 16:45:41');
INSERT INTO student_payments VALUES('1686','1','1610','2022-06-07','15500.00','','2022-06-07 16:50:53','2022-06-07 16:50:53');
INSERT INTO student_payments VALUES('1687','1','1606','2022-06-07','17000.00','','2022-06-07 17:00:00','2022-06-07 17:00:00');
INSERT INTO student_payments VALUES('1688','1','1530','2022-06-07','17000.00','','2022-06-07 17:21:46','2022-06-07 17:21:46');
INSERT INTO student_payments VALUES('1689','1','1524','2022-06-07','14000.00','','2022-06-07 18:02:34','2022-06-07 18:02:34');
INSERT INTO student_payments VALUES('1690','1','1579','2022-06-10','17500.00','','2022-06-10 12:04:25','2022-06-10 12:04:25');
INSERT INTO student_payments VALUES('1691','1','1551','2022-06-08','18000.00','','2022-06-10 12:11:33','2022-06-10 12:11:33');
INSERT INTO student_payments VALUES('1692','1','1562','2022-06-09','15000.00','','2022-06-10 12:12:31','2022-06-10 12:12:31');
INSERT INTO student_payments VALUES('1693','1','1617','2022-06-10','17000.00','','2022-06-10 12:23:35','2022-06-10 12:23:35');
INSERT INTO student_payments VALUES('1694','1','1039','2022-06-09','500.00','','2022-06-10 12:24:30','2022-06-10 12:24:30');
INSERT INTO student_payments VALUES('1695','1','1546','2022-06-09','17500.00','','2022-06-10 12:31:55','2022-06-10 12:31:55');
INSERT INTO student_payments VALUES('1696','1','1547','2022-06-09','18000.00','','2022-06-10 12:32:26','2022-06-10 12:32:26');
INSERT INTO student_payments VALUES('1697','1','1560','2022-06-09','17500.00','','2022-06-10 12:32:55','2022-06-10 12:32:55');
INSERT INTO student_payments VALUES('1698','1','1595','2022-06-10','15000.00','','2022-06-10 12:59:57','2022-06-10 12:59:57');
INSERT INTO student_payments VALUES('1699','1','1597','2022-06-10','16340.00','','2022-06-10 16:18:36','2022-06-10 16:18:36');
INSERT INTO student_payments VALUES('1700','1','1223','2022-06-10','20000.00','','2022-06-10 16:19:17','2022-06-10 16:19:17');
INSERT INTO student_payments VALUES('1701','1','1574','2022-06-10','17000.00','','2022-06-10 16:20:32','2022-06-10 16:20:32');
INSERT INTO student_payments VALUES('1702','1','1580','2022-06-08','17000.00','','2022-06-10 16:21:19','2022-06-10 16:21:19');
INSERT INTO student_payments VALUES('1703','1','1594','2022-06-08','19000.00','','2022-06-10 16:23:18','2022-06-10 16:23:18');
INSERT INTO student_payments VALUES('1704','1','1598','2022-06-10','15500.00','','2022-06-10 16:26:32','2022-06-10 16:26:32');
INSERT INTO student_payments VALUES('1705','1','1516','2022-06-09','15500.00','','2022-06-10 16:28:16','2022-06-10 16:28:16');
INSERT INTO student_payments VALUES('1706','1','1528','2022-06-10','22480.00','','2022-06-10 16:32:08','2022-06-10 16:32:08');
INSERT INTO student_payments VALUES('1707','1','1463','2022-06-09','2740.00','','2022-06-10 16:46:29','2022-06-10 16:46:29');
INSERT INTO student_payments VALUES('1708','1','1525','2022-06-10','17980.00','','2022-06-10 16:47:09','2022-06-10 16:47:09');
INSERT INTO student_payments VALUES('1709','1','1605','2022-06-10','19000.00','','2022-06-10 16:48:02','2022-06-10 16:48:02');
INSERT INTO student_payments VALUES('1710','1','1509','2022-06-10','22000.00','','2022-06-10 16:52:27','2022-06-10 16:52:27');
INSERT INTO student_payments VALUES('1711','1','1565','2022-06-10','22000.00','','2022-06-10 16:52:54','2022-06-10 16:52:54');
INSERT INTO student_payments VALUES('1712','1','1538','2022-06-03','17500.00','','2022-06-10 16:54:21','2022-06-10 16:54:21');
INSERT INTO student_payments VALUES('1713','1','1577','2022-06-10','17500.00','','2022-06-10 16:55:14','2022-06-10 16:55:14');
INSERT INTO student_payments VALUES('1714','1','1573','2022-06-10','15000.00','','2022-06-10 17:04:43','2022-06-10 17:04:43');
INSERT INTO student_payments VALUES('1715','1','1619','2022-06-12','5000.00','','2022-06-12 12:38:10','2022-06-12 12:38:10');
INSERT INTO student_payments VALUES('1716','1','1534','2022-06-12','13000.00','','2022-06-12 12:39:04','2022-06-12 12:39:04');
INSERT INTO student_payments VALUES('1717','1','1535','2022-06-12','13000.00','','2022-06-12 12:39:23','2022-06-12 12:39:23');
INSERT INTO student_payments VALUES('1718','1','1531','2022-06-12','17000.00','','2022-06-12 12:40:19','2022-06-12 12:40:19');
INSERT INTO student_payments VALUES('1719','1','1608','2022-06-12','17500.00','','2022-06-12 13:25:25','2022-06-12 13:25:25');
INSERT INTO student_payments VALUES('1720','1','1518','2022-06-12','8000.00','','2022-06-12 13:33:21','2022-06-12 13:33:21');
INSERT INTO student_payments VALUES('1721','1','1620','2022-06-12','1330.00','','2022-06-12 14:42:05','2022-06-12 14:42:05');
INSERT INTO student_payments VALUES('1722','1','1542','2022-06-12','15000.00','','2022-06-12 14:48:57','2022-06-12 14:48:57');
INSERT INTO student_payments VALUES('1723','1','1482','2022-06-12','160.00','','2022-06-12 17:00:02','2022-06-12 17:00:02');
INSERT INTO student_payments VALUES('1724','1','1538','2022-06-12','520.00','','2022-06-12 17:01:00','2022-06-12 17:01:00');
INSERT INTO student_payments VALUES('1725','1','1621','2022-06-12','520.00','','2022-06-12 17:02:57','2022-06-12 17:02:57');
INSERT INTO student_payments VALUES('1726','1','1584','2022-06-13','22000.00','','2022-06-13 12:21:47','2022-06-13 12:21:47');
INSERT INTO student_payments VALUES('1727','1','1169','2022-06-13','2000.00','','2022-06-13 13:39:03','2022-06-13 13:39:03');
INSERT INTO student_payments VALUES('1728','1','1284','2022-06-13','1000.00','','2022-06-13 13:39:25','2022-06-13 13:39:25');
INSERT INTO student_payments VALUES('1729','1','1564','2022-06-13','18000.00','','2022-06-13 13:40:37','2022-06-13 13:40:37');
INSERT INTO student_payments VALUES('1730','1','1601','2022-06-13','19500.00','','2022-06-13 13:54:32','2022-06-13 13:54:32');
INSERT INTO student_payments VALUES('1731','1','1622','2022-06-13','22000.00','','2022-06-13 14:57:00','2022-06-13 14:57:00');
INSERT INTO student_payments VALUES('1732','1','1557','2022-06-13','15000.00','','2022-06-13 15:26:38','2022-06-13 15:26:38');
INSERT INTO student_payments VALUES('1733','1','1539','2022-06-13','17500.00','','2022-06-13 15:27:00','2022-06-13 15:27:00');
INSERT INTO student_payments VALUES('1734','1','1484','2022-06-14','160.00','','2022-06-14 12:04:30','2022-06-14 12:04:30');
INSERT INTO student_payments VALUES('1735','1','1623','2022-06-14','520.00','','2022-06-14 12:04:49','2022-06-14 12:04:49');
INSERT INTO student_payments VALUES('1736','1','1594','2022-06-14','800.00','','2022-06-14 12:36:20','2022-06-14 12:36:20');
INSERT INTO student_payments VALUES('1737','1','1585','2022-06-14','22000.00','','2022-06-14 12:42:09','2022-06-14 12:42:09');
INSERT INTO student_payments VALUES('1738','1','1552','2022-06-14','17500.00','','2022-06-14 12:42:55','2022-06-14 12:42:55');
INSERT INTO student_payments VALUES('1739','1','1624','2022-06-14','5000.00','','2022-06-14 12:44:59','2022-06-14 12:44:59');
INSERT INTO student_payments VALUES('1740','1','1512','2022-06-16','10000.00','','2022-06-16 14:22:41','2022-06-16 14:22:41');
INSERT INTO student_payments VALUES('1741','1','1578','2022-06-16','18000.00','','2022-06-16 14:37:05','2022-06-16 14:37:05');
INSERT INTO student_payments VALUES('1742','1','1525','2022-06-17','4500.00','','2022-06-17 13:54:10','2022-06-17 13:54:10');
INSERT INTO student_payments VALUES('1743','1','1574','2022-06-17','900.00','','2022-06-17 14:29:08','2022-06-17 14:29:08');
INSERT INTO student_payments VALUES('1744','1','1580','2022-06-17','900.00','','2022-06-17 14:29:45','2022-06-17 14:29:45');
INSERT INTO student_payments VALUES('1745','1','1558','2022-06-20','4000.00','','2022-06-20 16:47:48','2022-06-20 16:47:48');
INSERT INTO student_payments VALUES('1746','1','1559','2022-06-18','14000.00','','2022-06-20 16:48:11','2022-06-20 16:48:11');
INSERT INTO student_payments VALUES('1747','1','1533','2022-06-20','13000.00','','2022-06-20 16:51:17','2022-06-20 16:51:17');
INSERT INTO student_payments VALUES('1748','1','1536','2022-06-20','26940.00','','2022-06-20 17:12:03','2022-06-20 17:12:03');
INSERT INTO student_payments VALUES('1749','1','1532','2022-06-20','17000.00','','2022-06-20 17:15:09','2022-06-20 17:15:09');
INSERT INTO student_payments VALUES('1750','1','1625','2022-06-20','2480.00','','2022-06-20 17:15:31','2022-06-20 17:15:31');
INSERT INTO student_payments VALUES('1751','1','1519','2022-06-21','500.00','','2022-06-21 14:59:08','2022-06-21 14:59:08');
INSERT INTO student_payments VALUES('1752','1','1517','2022-06-21','500.00','','2022-06-21 14:59:36','2022-06-21 14:59:36');
INSERT INTO student_payments VALUES('1753','1','1581','2022-06-14','11520.00','','2022-06-22 12:57:28','2022-06-22 12:57:28');
INSERT INTO student_payments VALUES('1754','1','1555','2022-06-09','18000.00','','2022-06-22 14:11:23','2022-06-22 14:11:23');
INSERT INTO student_payments VALUES('1755','1','1544','2022-06-10','17500.00','','2022-06-22 14:12:17','2022-06-22 14:12:17');
INSERT INTO student_payments VALUES('1756','1','1545','2022-06-10','17500.00','','2022-06-22 14:12:41','2022-06-22 14:12:41');
INSERT INTO student_payments VALUES('1757','1','1587','2022-06-15','16000.00','','2022-06-22 14:15:04','2022-06-22 14:15:04');
INSERT INTO student_payments VALUES('1758','1','1588','2022-06-15','16000.00','','2022-06-22 14:15:25','2022-06-22 14:15:25');
INSERT INTO student_payments VALUES('1759','1','1626','2022-06-16','8000.00','','2022-06-22 14:15:45','2022-06-22 14:15:45');
INSERT INTO student_payments VALUES('1760','1','1628','2022-06-22','17000.00','','2022-06-22 15:06:51','2022-06-22 15:06:51');
INSERT INTO student_payments VALUES('1761','1','1627','2022-06-22','17500.00','','2022-06-22 15:07:23','2022-06-22 15:07:23');
INSERT INTO student_payments VALUES('1762','1','1629','2022-06-23','500.00','','2022-06-23 14:47:54','2022-06-23 14:47:54');
INSERT INTO student_payments VALUES('1763','1','1357','2022-06-23','2250.00','','2022-06-23 15:13:25','2022-06-23 15:13:25');
INSERT INTO student_payments VALUES('1764','1','1514','2022-06-23','14750.00','','2022-06-23 15:14:21','2022-06-23 15:14:21');
INSERT INTO student_payments VALUES('1765','1','1554','2022-06-23','3000.00','','2022-06-23 16:25:04','2022-06-23 16:25:04');
INSERT INTO student_payments VALUES('1766','1','1620','2022-06-23','3990.00','','2022-06-23 16:25:25','2022-06-23 16:25:25');
INSERT INTO student_payments VALUES('1767','1','1630','2022-06-23','15000.00','','2022-06-23 16:56:51','2022-06-23 16:56:51');
INSERT INTO student_payments VALUES('1768','1','1349','2022-06-26','20000.00','','2022-06-27 12:23:24','2022-06-27 12:23:24');
INSERT INTO student_payments VALUES('1769','1','1618','2022-06-27','12000.00','','2022-06-27 12:26:59','2022-06-27 12:26:59');
INSERT INTO student_payments VALUES('1770','1','1546','2022-06-27','510.00','','2022-06-27 12:27:51','2022-06-27 12:27:51');
INSERT INTO student_payments VALUES('1771','1','1548','2022-06-26','14000.00','','2022-06-27 12:31:34','2022-06-27 12:31:34');
INSERT INTO student_payments VALUES('1772','1','1583','2022-06-29','5000.00','','2022-06-29 16:16:30','2022-06-29 16:16:30');
INSERT INTO student_payments VALUES('1773','1','1521','2022-06-29','5000.00','','2022-06-29 16:17:11','2022-06-29 16:17:11');
INSERT INTO student_payments VALUES('1774','1','1433','2022-06-29','5360.00','','2022-06-29 16:19:22','2022-06-29 16:19:22');
INSERT INTO student_payments VALUES('1775','1','1585','2022-06-29','140.00','','2022-06-29 16:19:57','2022-06-29 16:19:57');
INSERT INTO student_payments VALUES('1776','1','1585','2022-06-30','6620.00','','2022-06-30 15:42:13','2022-06-30 15:42:13');
INSERT INTO student_payments VALUES('1777','1','1680','2022-07-01','17500.00','','2022-07-03 13:55:51','2022-07-03 13:55:51');
INSERT INTO student_payments VALUES('1778','1','1669','2022-07-03','13133.00','','2022-07-03 13:58:06','2022-07-03 13:58:06');
INSERT INTO student_payments VALUES('1779','1','1658','2022-07-02','8500.00','','2022-07-03 13:59:25','2022-07-03 13:59:25');
INSERT INTO student_payments VALUES('1780','1','1473','2022-07-02','380.00','','2022-07-03 14:04:43','2022-07-03 14:04:43');
INSERT INTO student_payments VALUES('1781','1','1516','2022-07-02','820.00','','2022-07-03 14:05:48','2022-07-03 14:05:48');
INSERT INTO student_payments VALUES('1782','1','1646','2022-07-02','16560.00','','2022-07-03 14:06:46','2022-07-03 14:06:46');
INSERT INTO student_payments VALUES('1783','1','1645','2022-07-02','16560.00','','2022-07-03 14:10:10','2022-07-03 14:10:10');
INSERT INTO student_payments VALUES('1784','1','1633','2022-07-01','24000.00','','2022-07-03 14:10:37','2022-07-03 14:10:37');
INSERT INTO student_payments VALUES('1785','1','1638','2022-07-03','8790.00','','2022-07-03 14:13:58','2022-07-03 14:13:58');
INSERT INTO student_payments VALUES('1786','1','1635','2022-07-01','18000.00','','2022-07-03 14:14:57','2022-07-03 14:14:57');
INSERT INTO student_payments VALUES('1787','1','1698','2022-07-02','19500.00','','2022-07-03 14:15:19','2022-07-03 14:15:19');
INSERT INTO student_payments VALUES('1788','1','1652','2022-07-03','17950.00','','2022-07-03 15:51:46','2022-07-03 15:51:46');
INSERT INTO student_payments VALUES('1789','1','1666','2022-07-03','17950.00','','2022-07-03 16:58:57','2022-07-03 16:58:57');
INSERT INTO student_payments VALUES('1790','1','1711','2022-07-03','17000.00','','2022-07-03 17:00:25','2022-07-03 17:00:25');
INSERT INTO student_payments VALUES('1791','1','1737','2022-07-03','8950.00','','2022-07-03 17:43:21','2022-07-03 17:43:21');
INSERT INTO student_payments VALUES('1792','1','1717','2022-07-04','8500.00','','2022-07-04 12:29:32','2022-07-04 12:29:32');
INSERT INTO student_payments VALUES('1793','1','1657','2022-07-04','17500.00','','2022-07-04 12:31:50','2022-07-04 12:31:50');
INSERT INTO student_payments VALUES('1794','1','1719','2022-07-04','23200.00','','2022-07-04 12:59:32','2022-07-04 12:59:32');
INSERT INTO student_payments VALUES('1795','1','1679','2022-07-04','18000.00','','2022-07-04 13:55:01','2022-07-04 13:55:01');
INSERT INTO student_payments VALUES('1796','1','1696','2022-07-04','15000.00','','2022-07-04 13:56:41','2022-07-04 13:56:41');
INSERT INTO student_payments VALUES('1797','1','1656','2022-07-04','23080.00','','2022-07-04 15:06:55','2022-07-04 15:06:55');
INSERT INTO student_payments VALUES('1798','1','1655','2022-07-04','24080.00','','2022-07-04 15:38:08','2022-07-04 15:38:08');
INSERT INTO student_payments VALUES('1799','1','1665','2022-07-04','21000.00','','2022-07-04 15:42:14','2022-07-04 15:42:14');
INSERT INTO student_payments VALUES('1800','1','1242','2022-07-04','4500.00','MEHSUM SEC LESS','2022-07-04 15:45:18','2022-07-04 15:45:18');
INSERT INTO student_payments VALUES('1801','1','1653','2022-07-04','14000.00','MEHSUM SEC LESS','2022-07-04 15:45:49','2022-07-04 15:45:49');
INSERT INTO student_payments VALUES('1802','1','1726','2022-07-05','22500.00','','2022-07-05 13:43:12','2022-07-05 13:43:12');
INSERT INTO student_payments VALUES('1803','1','1685','2022-07-05','15000.00','','2022-07-05 13:49:51','2022-07-05 13:49:51');
INSERT INTO student_payments VALUES('1804','1','1740','2022-07-05','8000.00','','2022-07-05 13:54:50','2022-07-05 13:54:50');
INSERT INTO student_payments VALUES('1805','1','1683','2022-07-05','10000.00','','2022-07-05 13:57:05','2022-07-05 13:57:05');
INSERT INTO student_payments VALUES('1806','1','1728','2022-07-05','16000.00','','2022-07-05 13:57:55','2022-07-05 13:57:55');
INSERT INTO student_payments VALUES('1807','1','1708','2022-07-05','17000.00','','2022-07-05 13:59:44','2022-07-05 13:59:44');
INSERT INTO student_payments VALUES('1808','1','1735','2022-07-05','8500.00','','2022-07-05 14:00:53','2022-07-05 14:00:53');
INSERT INTO student_payments VALUES('1809','1','1548','2022-07-05','4230.00','','2022-07-05 14:02:38','2022-07-05 14:02:38');
INSERT INTO student_payments VALUES('1810','1','1676','2022-07-05','500.00','','2022-07-05 14:03:25','2022-07-05 14:03:25');
INSERT INTO student_payments VALUES('1811','1','1692','2022-07-05','13135.00','','2022-07-05 14:05:47','2022-07-05 14:05:47');
INSERT INTO student_payments VALUES('1812','1','1661','2022-07-05','16330.00','','2022-07-05 14:07:03','2022-07-05 14:07:03');
INSERT INTO student_payments VALUES('1813','1','1681','2022-07-05','19000.00','','2022-07-05 14:11:12','2022-07-05 14:11:12');
INSERT INTO student_payments VALUES('1814','1','1736','2022-07-05','8950.00','','2022-07-05 14:15:41','2022-07-05 14:15:41');
INSERT INTO student_payments VALUES('1815','1','1734','2022-07-05','8950.00','','2022-07-05 14:16:02','2022-07-05 14:16:02');
INSERT INTO student_payments VALUES('1816','1','1634','2022-07-05','17500.00','','2022-07-05 14:18:59','2022-07-05 14:18:59');
INSERT INTO student_payments VALUES('1817','1','1690','2022-07-05','19000.00','','2022-07-05 14:20:25','2022-07-05 14:20:25');
INSERT INTO student_payments VALUES('1818','1','1512','2022-07-05','1200.00','TABLE PAYMENT HUSNAIN','2022-07-05 14:21:27','2022-07-05 14:21:27');
INSERT INTO student_payments VALUES('1819','1','1663','2022-07-05','13000.00','','2022-07-05 14:33:18','2022-07-05 14:33:18');
INSERT INTO student_payments VALUES('1820','1','1678','2022-07-05','16500.00','','2022-07-05 15:18:39','2022-07-05 15:18:39');
INSERT INTO student_payments VALUES('1821','1','1724','2022-07-05','8500.00','','2022-07-05 15:31:31','2022-07-05 15:31:31');
INSERT INTO student_payments VALUES('1822','1','1687','2022-07-05','7000.00','','2022-07-05 15:34:53','2022-07-05 15:34:53');
INSERT INTO student_payments VALUES('1823','1','1722','2022-07-05','15000.00','','2022-07-05 16:03:33','2022-07-05 16:03:33');
INSERT INTO student_payments VALUES('1824','1','1715','2022-07-05','18830.00','','2022-07-05 16:06:05','2022-07-05 16:06:05');
INSERT INTO student_payments VALUES('1825','1','1707','2022-07-05','17290.00','','2022-07-05 16:16:58','2022-07-05 16:16:58');
INSERT INTO student_payments VALUES('1826','1','1656','2022-07-07','1000.00','','2022-07-07 10:06:00','2022-07-07 10:06:00');
INSERT INTO student_payments VALUES('1827','1','1654','2022-07-07','21080.00','','2022-07-07 10:11:50','2022-07-07 10:11:50');
INSERT INTO student_payments VALUES('1828','1','1688','2022-07-06','14000.00','','2022-07-07 10:35:15','2022-07-07 10:35:15');
INSERT INTO student_payments VALUES('1829','1','1704','2022-07-06','17500.00','','2022-07-07 10:36:16','2022-07-07 10:36:16');
INSERT INTO student_payments VALUES('1830','1','1706','2022-07-06','17500.00','','2022-07-07 10:36:42','2022-07-07 10:36:42');
INSERT INTO student_payments VALUES('1831','1','1718','2022-07-06','15000.00','','2022-07-07 10:38:20','2022-07-07 10:38:20');
INSERT INTO student_payments VALUES('1832','1','1673','2022-07-07','18500.00','','2022-07-07 10:40:30','2022-07-07 10:40:30');
INSERT INTO student_payments VALUES('1833','1','1670','2022-07-07','15000.00','','2022-07-07 10:41:16','2022-07-07 10:41:16');
INSERT INTO student_payments VALUES('1834','1','1671','2022-07-07','7000.00','','2022-07-07 10:42:12','2022-07-07 10:42:12');
INSERT INTO student_payments VALUES('1835','1','1637','2022-07-07','16063.00','','2022-07-07 10:48:15','2022-07-07 10:48:15');
INSERT INTO student_payments VALUES('1836','1','1668','2022-07-07','22133.00','','2022-07-07 10:48:33','2022-07-07 10:48:33');
INSERT INTO student_payments VALUES('1837','1','1695','2022-07-07','9600.00','','2022-07-07 10:53:33','2022-07-07 10:53:33');
INSERT INTO student_payments VALUES('1838','1','1639','2022-07-07','9600.00','','2022-07-07 10:54:22','2022-07-07 10:54:22');
INSERT INTO student_payments VALUES('1839','1','1660','2022-07-07','18330.00','','2022-07-07 10:55:24','2022-07-07 10:55:24');
INSERT INTO student_payments VALUES('1840','1','1631','2022-07-06','17000.00','','2022-07-07 10:56:00','2022-07-07 10:56:00');
INSERT INTO student_payments VALUES('1841','1','1647','2022-07-06','13500.00','','2022-07-07 10:56:39','2022-07-07 10:56:39');
INSERT INTO student_payments VALUES('1842','1','1731','2022-07-06','8950.00','','2022-07-07 10:57:05','2022-07-07 10:57:05');
INSERT INTO student_payments VALUES('1843','1','1699','2022-07-07','8500.00','','2022-07-07 11:02:39','2022-07-07 11:02:39');
INSERT INTO student_payments VALUES('1844','1','1722','2022-07-06','1730.00','','2022-07-07 11:08:40','2022-07-07 11:08:40');
INSERT INTO student_payments VALUES('1845','1','1710','2022-07-07','22000.00','abdullah sec refund','2022-07-07 11:12:30','2022-07-07 11:12:30');



DROP TABLE IF EXISTS student_sessions;

CREATE TABLE `student_sessions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `roll` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `optional_subject` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=193 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_sessions VALUES('1','1','1','1','1','9','2','1','','2021-06-17 22:44:04','2021-06-17 22:44:04');
INSERT INTO student_sessions VALUES('2','1','1','2','2','23','2','2','','2021-06-17 22:55:01','2021-06-17 22:55:01');
INSERT INTO student_sessions VALUES('3','1','1','3','2','10','2','3','','2021-06-17 22:58:03','2021-06-17 22:58:03');
INSERT INTO student_sessions VALUES('4','1','1','4','1','8','2','4','','2021-06-17 23:08:07','2021-06-17 23:08:07');
INSERT INTO student_sessions VALUES('5','1','1','5','3','30','2','5','','2021-06-17 23:12:37','2021-06-17 23:12:37');
INSERT INTO student_sessions VALUES('6','1','1','6','3','30','2','6','','2021-06-18 11:33:52','2021-06-18 11:33:52');
INSERT INTO student_sessions VALUES('7','1','1','7','1','4','2','7','','2021-06-18 11:38:54','2021-06-18 11:38:54');
INSERT INTO student_sessions VALUES('8','1','1','8','1','4','2','8','','2021-06-18 11:42:46','2021-06-18 11:42:46');
INSERT INTO student_sessions VALUES('9','1','1','9','2','20','1','9','','2021-06-18 11:48:09','2021-06-18 11:48:09');
INSERT INTO student_sessions VALUES('10','1','1','10','3','40','2','10','','2021-06-18 15:27:36','2021-06-18 15:27:36');
INSERT INTO student_sessions VALUES('11','1','1','11','3','40','2','11','','2021-06-18 15:34:56','2021-06-18 15:34:56');
INSERT INTO student_sessions VALUES('12','1','1','12','1','16','1','12','','2021-06-18 16:19:00','2021-11-09 20:35:56');
INSERT INTO student_sessions VALUES('13','1','1','13','2','39','1','13','','2021-06-18 16:23:05','2021-06-18 16:23:05');
INSERT INTO student_sessions VALUES('14','1','1','14','3','37','2','14','','2021-06-18 16:27:08','2021-06-18 16:27:08');
INSERT INTO student_sessions VALUES('15','1','1','15','1','41','2','15','','2021-06-18 16:30:47','2021-09-15 16:23:04');
INSERT INTO student_sessions VALUES('16','1','1','16','3','34','2','16','','2021-06-18 16:35:15','2021-06-18 16:35:15');
INSERT INTO student_sessions VALUES('17','1','1','17','1','15','2','17','','2021-06-18 16:41:17','2022-02-01 19:58:31');
INSERT INTO student_sessions VALUES('18','1','1','18','3','33','2','18','','2021-06-18 17:05:43','2021-06-18 17:05:43');
INSERT INTO student_sessions VALUES('19','1','1','19','1','17','2','19','','2021-06-18 17:08:37','2022-02-01 19:54:42');
INSERT INTO student_sessions VALUES('20','1','1','20','3','33','2','20','','2021-06-18 17:11:03','2021-06-18 17:11:03');
INSERT INTO student_sessions VALUES('21','1','1','21','3','30','2','21','','2021-06-18 17:16:46','2021-06-18 17:16:46');
INSERT INTO student_sessions VALUES('22','1','1','22','3','35','2','22','','2021-06-18 17:19:18','2021-06-18 17:19:18');
INSERT INTO student_sessions VALUES('23','1','1','23','3','36','2','23','','2021-06-18 17:20:57','2021-06-18 17:20:57');
INSERT INTO student_sessions VALUES('24','1','1','24','3','36','2','24','','2021-06-18 17:22:24','2021-06-18 17:22:24');
INSERT INTO student_sessions VALUES('25','1','1','25','3','32','2','25','','2021-06-18 17:24:01','2021-06-18 17:24:01');
INSERT INTO student_sessions VALUES('26','1','1','26','3','32','2','26','','2021-06-18 17:25:15','2021-06-18 17:25:15');
INSERT INTO student_sessions VALUES('27','1','1','27','3','32','2','27','','2021-06-18 17:26:25','2021-06-18 17:26:25');
INSERT INTO student_sessions VALUES('28','1','1','28','3','34','2','28','','2021-06-18 17:28:09','2021-06-18 17:28:09');
INSERT INTO student_sessions VALUES('29','1','1','29','3','34','2','29','','2021-06-18 17:29:24','2021-06-18 17:29:24');
INSERT INTO student_sessions VALUES('30','1','1','30','3','30','2','30','','2021-06-18 17:31:05','2021-06-18 17:31:05');
INSERT INTO student_sessions VALUES('31','1','1','31','3','30','2','31','','2021-06-18 17:32:46','2021-06-18 17:32:46');
INSERT INTO student_sessions VALUES('32','1','1','32','3','30','2','32','','2021-06-18 17:33:50','2021-06-18 17:33:50');
INSERT INTO student_sessions VALUES('33','1','1','33','3','29','2','33','','2021-06-18 17:35:45','2021-06-18 17:35:45');
INSERT INTO student_sessions VALUES('34','1','1','34','3','29','2','34','','2021-06-18 17:37:09','2021-06-18 17:37:09');
INSERT INTO student_sessions VALUES('35','1','1','35','3','29','2','35','','2021-06-18 17:40:00','2021-06-18 17:40:00');
INSERT INTO student_sessions VALUES('36','1','1','36','3','29','2','36','','2021-06-18 17:42:18','2021-06-18 17:42:18');
INSERT INTO student_sessions VALUES('37','1','1','37','3','29','2','37','','2021-06-18 17:43:34','2021-06-18 17:43:34');
INSERT INTO student_sessions VALUES('38','1','1','38','3','28','2','38','','2021-06-18 17:46:10','2021-06-18 17:46:10');
INSERT INTO student_sessions VALUES('39','1','1','39','3','28','2','39','','2021-06-18 17:48:58','2021-06-18 17:48:58');
INSERT INTO student_sessions VALUES('40','1','1','40','3','28','2','40','','2021-06-18 17:50:32','2021-06-18 17:50:32');
INSERT INTO student_sessions VALUES('41','1','1','41','3','27','2','41','','2021-06-18 17:56:07','2021-06-18 17:56:07');
INSERT INTO student_sessions VALUES('42','1','1','42','3','27','2','42','','2021-06-18 18:05:22','2021-06-18 18:05:22');
INSERT INTO student_sessions VALUES('43','1','1','43','3','27','2','43','','2021-06-18 18:13:03','2021-06-18 18:13:03');
INSERT INTO student_sessions VALUES('44','1','1','44','3','26','2','44','','2021-06-18 18:20:37','2021-06-18 18:20:37');
INSERT INTO student_sessions VALUES('45','1','1','45','3','26','2','45','','2021-06-18 18:24:26','2021-06-18 18:24:26');
INSERT INTO student_sessions VALUES('46','1','1','46','3','26','2','46','','2021-06-18 18:33:18','2021-06-18 18:33:18');
INSERT INTO student_sessions VALUES('47','1','1','47','3','26','2','47','','2021-06-18 18:34:51','2021-06-18 18:34:51');
INSERT INTO student_sessions VALUES('48','1','1','48','1','16','1','48','','2021-06-18 18:55:43','2021-06-18 18:55:43');
INSERT INTO student_sessions VALUES('49','1','1','49','2','14','2','49','','2021-06-18 19:00:15','2021-06-18 19:00:15');
INSERT INTO student_sessions VALUES('50','1','1','50','3','25','2','50','','2021-06-18 19:03:24','2021-06-18 19:03:24');
INSERT INTO student_sessions VALUES('51','1','1','51','3','25','2','51','','2021-06-18 19:10:39','2021-06-18 19:10:39');
INSERT INTO student_sessions VALUES('52','1','1','52','3','25','2','52','','2021-06-18 19:14:21','2021-06-18 19:14:21');
INSERT INTO student_sessions VALUES('53','1','1','53','3','25','2','53','','2021-06-18 19:16:09','2021-06-18 19:16:09');
INSERT INTO student_sessions VALUES('54','1','1','54','2','23','2','54','','2021-06-18 19:19:17','2021-07-03 19:54:49');
INSERT INTO student_sessions VALUES('55','1','1','55','1','17','2','55','','2021-06-18 19:21:24','2021-09-28 17:02:45');
INSERT INTO student_sessions VALUES('56','1','1','56','1','19','1','56','','2021-06-18 19:23:20','2021-06-18 19:23:20');
INSERT INTO student_sessions VALUES('57','1','1','57','1','19','2','57','','2021-06-18 19:25:33','2021-06-18 19:25:33');
INSERT INTO student_sessions VALUES('58','1','1','58','1','17','2','58','','2021-06-18 19:27:08','2021-06-18 19:27:08');
INSERT INTO student_sessions VALUES('59','1','1','59','2','14','2','59','','2021-06-18 19:46:51','2021-09-13 17:43:07');
INSERT INTO student_sessions VALUES('60','1','1','60','2','22','2','60','','2021-06-18 19:54:56','2021-06-19 13:25:38');
INSERT INTO student_sessions VALUES('61','1','1','61','2','22','1','61','','2021-06-18 20:02:31','2021-06-19 13:24:48');
INSERT INTO student_sessions VALUES('62','1','1','62','2','22','1','62','','2021-06-18 20:05:09','2021-06-19 13:26:26');
INSERT INTO student_sessions VALUES('63','1','1','63','1','18','2','63','','2021-06-18 20:10:22','2021-06-18 20:10:22');
INSERT INTO student_sessions VALUES('64','1','1','64','1','18','2','64','','2021-06-18 20:32:02','2021-06-18 20:32:02');
INSERT INTO student_sessions VALUES('65','1','1','65','1','17','2','65','','2021-06-18 20:39:44','2021-06-18 20:39:44');
INSERT INTO student_sessions VALUES('66','1','1','66','1','17','2','66','','2021-06-18 20:41:24','2021-06-18 20:41:24');
INSERT INTO student_sessions VALUES('67','1','1','67','1','17','2','67','','2021-06-18 20:43:07','2021-06-18 20:43:07');
INSERT INTO student_sessions VALUES('68','1','1','68','1','16','2','68','','2021-06-18 20:56:29','2021-06-18 20:56:29');
INSERT INTO student_sessions VALUES('69','1','1','69','1','16','1','69','','2021-06-18 21:00:23','2021-06-18 21:00:23');
INSERT INTO student_sessions VALUES('70','1','1','70','1','16','1','70','','2021-06-18 21:02:34','2021-06-18 21:02:34');
INSERT INTO student_sessions VALUES('71','1','1','71','1','6','2','71','','2021-06-18 21:06:03','2022-01-12 19:27:11');
INSERT INTO student_sessions VALUES('72','1','1','72','1','15','2','72','','2021-06-18 21:09:44','2021-06-18 21:09:44');
INSERT INTO student_sessions VALUES('73','1','1','73','1','15','2','73','','2021-06-18 21:12:11','2021-06-18 21:12:11');
INSERT INTO student_sessions VALUES('74','1','1','74','1','15','2','74','','2021-06-18 21:13:59','2021-06-18 21:13:59');
INSERT INTO student_sessions VALUES('75','1','1','75','2','14','2','75','','2021-06-18 21:15:39','2021-06-18 21:15:39');
INSERT INTO student_sessions VALUES('76','1','1','76','2','14','2','76','','2021-06-18 21:18:35','2021-06-18 21:18:35');
INSERT INTO student_sessions VALUES('77','1','1','77','2','14','2','77','','2021-06-18 21:20:45','2021-06-18 21:20:45');
INSERT INTO student_sessions VALUES('78','1','1','78','2','10','2','78','','2021-06-18 21:22:22','2021-10-03 19:30:06');
INSERT INTO student_sessions VALUES('79','1','1','79','2','10','2','79','','2021-06-18 21:23:48','2021-10-03 19:27:47');
INSERT INTO student_sessions VALUES('80','1','1','80','1','4','2','80','','2021-06-18 21:25:30','2021-10-02 21:15:04');
INSERT INTO student_sessions VALUES('81','1','1','81','1','12','2','81','','2021-06-18 21:27:19','2021-06-18 21:27:19');
INSERT INTO student_sessions VALUES('82','1','1','82','1','12','2','82','','2021-06-18 21:29:49','2021-06-18 21:29:49');
INSERT INTO student_sessions VALUES('83','1','1','83','1','12','2','83','','2021-06-18 21:32:43','2021-06-18 21:32:43');
INSERT INTO student_sessions VALUES('84','1','1','84','2','11','2','84','','2021-06-18 21:35:43','2021-06-18 21:35:43');
INSERT INTO student_sessions VALUES('85','1','1','85','2','11','2','85','','2021-06-18 21:37:37','2021-06-18 21:37:37');
INSERT INTO student_sessions VALUES('86','1','1','86','2','11','2','86','','2021-06-18 21:39:05','2021-06-18 21:39:05');
INSERT INTO student_sessions VALUES('87','1','1','87','2','11','2','87','','2021-06-18 21:40:23','2021-06-18 21:40:23');
INSERT INTO student_sessions VALUES('88','1','1','88','2','10','2','88','','2021-06-18 21:42:11','2021-06-18 21:42:11');
INSERT INTO student_sessions VALUES('89','1','1','89','2','10','2','89','','2021-06-18 21:43:49','2021-06-18 21:43:49');
INSERT INTO student_sessions VALUES('90','1','1','90','2','10','2','90','','2021-06-18 21:45:06','2021-06-18 21:45:06');
INSERT INTO student_sessions VALUES('91','1','1','91','1','9','2','91','','2021-06-18 21:48:35','2021-06-18 21:48:35');
INSERT INTO student_sessions VALUES('92','1','1','92','1','8','2','92','','2021-06-18 21:51:19','2021-06-18 21:51:19');
INSERT INTO student_sessions VALUES('93','1','1','93','1','8','2','93','','2021-06-18 21:52:40','2021-06-18 21:52:40');
INSERT INTO student_sessions VALUES('94','1','1','94','1','8','2','94','','2021-06-18 21:53:56','2021-06-18 21:53:56');
INSERT INTO student_sessions VALUES('95','1','1','95','1','8','2','95','','2021-06-18 21:55:34','2021-06-18 21:55:34');
INSERT INTO student_sessions VALUES('96','1','1','96','1','7','1','96','','2021-06-18 21:58:33','2021-06-18 21:58:33');
INSERT INTO student_sessions VALUES('97','1','1','97','1','7','1','97','','2021-06-18 22:01:29','2021-06-18 22:01:29');
INSERT INTO student_sessions VALUES('98','1','1','98','1','6','1','98','','2021-06-18 22:03:40','2021-06-18 22:03:40');
INSERT INTO student_sessions VALUES('99','1','1','99','1','6','2','99','','2021-06-18 22:05:39','2021-06-18 22:05:39');
INSERT INTO student_sessions VALUES('100','1','1','100','3','28','2','100','','2021-06-18 22:07:17','2022-04-28 16:49:30');
INSERT INTO student_sessions VALUES('101','1','1','101','1','5','2','101','','2021-06-19 08:39:53','2021-06-19 13:08:21');
INSERT INTO student_sessions VALUES('102','1','1','102','1','5','2','102','','2021-06-19 08:42:39','2021-06-19 13:11:22');
INSERT INTO student_sessions VALUES('103','1','1','103','1','2','2','103','','2021-06-19 13:36:38','2021-06-19 13:38:50');
INSERT INTO student_sessions VALUES('104','1','1','104','1','3','1','104','','2021-06-19 13:43:40','2021-06-19 13:43:40');
INSERT INTO student_sessions VALUES('105','1','1','105','1','4','2','105','','2021-06-19 13:50:05','2021-06-19 13:50:05');
INSERT INTO student_sessions VALUES('106','1','1','106','1','4','2','106','','2021-06-19 13:54:18','2021-06-19 13:54:18');
INSERT INTO student_sessions VALUES('107','1','1','107','1','1','2','107','','2021-06-19 13:56:09','2021-06-19 13:56:09');
INSERT INTO student_sessions VALUES('108','1','1','108','1','1','2','108','','2021-06-19 13:58:42','2021-06-19 13:58:42');
INSERT INTO student_sessions VALUES('109','1','1','109','3','29','2','109','','2021-06-19 14:25:25','2021-10-25 20:41:44');
INSERT INTO student_sessions VALUES('110','1','1','110','1','1','2','110','','2021-06-19 14:30:21','2021-06-19 14:30:21');
INSERT INTO student_sessions VALUES('111','1','1','111','1','1','2','111','','2021-06-19 14:32:45','2021-06-19 14:32:45');
INSERT INTO student_sessions VALUES('112','1','1','112','1','1','1','112','','2021-06-19 18:10:11','2021-06-20 19:40:50');
INSERT INTO student_sessions VALUES('113','1','1','113','1','12','2','113','','2021-06-21 19:32:16','2021-06-21 19:33:05');
INSERT INTO student_sessions VALUES('114','1','1','114','3','32','2','114','','2021-06-28 19:04:03','2021-08-01 18:44:34');
INSERT INTO student_sessions VALUES('115','1','1','115','1','9','1','115','','2021-06-30 23:01:11','2021-06-30 23:02:29');
INSERT INTO student_sessions VALUES('116','1','1','116','4','42','2','116','','2021-06-30 23:12:22','2022-05-22 07:09:28');
INSERT INTO student_sessions VALUES('117','1','1','117','1','4','2','117','','2021-07-03 19:35:49','2021-07-03 19:35:49');
INSERT INTO student_sessions VALUES('118','1','1','118','1','4','2','118','','2021-07-03 19:40:24','2021-07-03 19:40:24');
INSERT INTO student_sessions VALUES('119','1','1','119','2','24','2','119','','2021-07-10 14:30:14','2021-07-10 14:30:14');
INSERT INTO student_sessions VALUES('120','1','1','120','3','44','2','120','','2021-08-01 20:11:13','2021-11-01 18:07:26');
INSERT INTO student_sessions VALUES('121','1','1','121','1','15','2','121','','2021-08-12 20:28:57','2021-09-28 17:16:49');
INSERT INTO student_sessions VALUES('122','1','1','122','1','8','2','122','','2021-08-12 20:32:01','2021-08-12 20:32:01');
INSERT INTO student_sessions VALUES('123','1','1','123','3','36','2','123','','2021-08-31 20:01:53','2021-08-31 20:02:37');
INSERT INTO student_sessions VALUES('124','1','1','124','2','21','2','124','','2021-09-02 20:09:54','2021-09-02 20:09:54');
INSERT INTO student_sessions VALUES('125','1','1','125','3','32','2','130','','2021-09-08 20:49:09','2021-09-08 20:49:09');
INSERT INTO student_sessions VALUES('126','1','1','126','1','17','2','131','','2021-09-09 20:49:50','2021-09-28 17:20:39');
INSERT INTO student_sessions VALUES('127','1','1','127','1','17','2','132','','2021-09-09 20:56:53','2021-09-28 17:17:42');
INSERT INTO student_sessions VALUES('128','1','1','128','1','1','2','133','','2021-09-10 18:30:18','2021-09-10 18:30:18');
INSERT INTO student_sessions VALUES('129','1','1','129','1','18','2','136','','2021-09-13 17:16:14','2021-10-05 19:03:28');
INSERT INTO student_sessions VALUES('130','1','1','130','1','8','2','137','','2021-09-15 19:02:10','2021-09-15 19:02:10');
INSERT INTO student_sessions VALUES('131','1','1','131','2','38','2','138','','2021-09-15 19:06:23','2021-11-09 20:41:40');
INSERT INTO student_sessions VALUES('132','1','1','132','2','24','2','139','','2021-09-15 19:10:09','2021-09-15 19:10:09');
INSERT INTO student_sessions VALUES('133','1','1','133','2','11','2','140','','2021-09-18 19:09:36','2021-09-18 19:09:36');
INSERT INTO student_sessions VALUES('134','1','1','134','2','14','2','141','','2021-09-18 19:35:53','2021-09-18 19:35:53');
INSERT INTO student_sessions VALUES('135','1','1','135','2','11','2','142','','2021-09-19 19:40:15','2021-09-19 19:40:15');
INSERT INTO student_sessions VALUES('136','1','1','136','1','8','2','143','','2021-09-19 19:52:14','2021-09-28 18:26:59');
INSERT INTO student_sessions VALUES('137','1','1','137','2','13','2','144','','2021-09-28 18:22:17','2021-09-28 18:27:45');
INSERT INTO student_sessions VALUES('138','1','1','138','3','33','2','145','','2021-09-28 18:32:05','2022-02-01 19:55:19');
INSERT INTO student_sessions VALUES('139','1','1','139','1','18','2','146','','2021-09-28 18:35:14','2022-06-13 14:53:58');
INSERT INTO student_sessions VALUES('140','1','1','140','3','28','2','147','','2021-09-28 18:38:21','2021-09-29 19:52:33');
INSERT INTO student_sessions VALUES('141','1','1','141','3','26','2','148','','2021-09-28 18:43:10','2021-09-28 18:43:10');
INSERT INTO student_sessions VALUES('142','1','1','142','1','4','2','149','','2021-09-29 18:45:08','2021-10-03 20:12:35');
INSERT INTO student_sessions VALUES('143','1','1','143','2','39','2','150','','2021-09-29 18:48:45','2021-09-29 18:48:45');
INSERT INTO student_sessions VALUES('144','1','1','144','1','4','2','151','','2021-09-29 19:22:48','2021-10-03 20:13:24');
INSERT INTO student_sessions VALUES('145','1','1','145','1','4','2','152','','2021-09-29 19:24:51','2021-10-03 19:32:37');
INSERT INTO student_sessions VALUES('146','1','1','146','3','33','2','153','','2021-09-29 19:32:48','2022-02-01 19:59:57');
INSERT INTO student_sessions VALUES('147','1','1','147','2','24','2','154','','2021-09-29 19:37:28','2021-10-05 18:09:22');
INSERT INTO student_sessions VALUES('148','1','1','148','2','13','2','155','','2021-09-29 19:42:25','2021-10-05 18:20:17');
INSERT INTO student_sessions VALUES('149','1','1','149','3','30','2','156','','2021-09-29 19:46:15','2022-02-13 18:36:58');
INSERT INTO student_sessions VALUES('150','1','1','150','2','11','2','157','','2021-09-29 19:48:01','2021-10-09 19:12:18');
INSERT INTO student_sessions VALUES('151','1','1','151','3','29','2','158','','2021-09-29 20:01:53','2021-10-03 20:18:28');
INSERT INTO student_sessions VALUES('152','1','1','152','2','21','2','160','','2021-09-30 20:12:16','2021-09-30 20:12:16');
INSERT INTO student_sessions VALUES('153','1','1','153','1','9','2','162','','2021-10-01 16:06:42','2021-10-01 16:06:42');
INSERT INTO student_sessions VALUES('154','1','1','154','1','9','2','163','','2021-10-01 18:04:41','2021-10-01 18:04:41');
INSERT INTO student_sessions VALUES('155','1','1','155','3','43','2','170','','2021-10-08 16:04:08','2021-10-10 21:20:48');
INSERT INTO student_sessions VALUES('156','1','1','156','1','12','2','171','','2021-10-09 19:20:28','2021-10-09 19:20:28');
INSERT INTO student_sessions VALUES('157','1','1','157','1','12','2','172','','2021-10-09 19:21:55','2021-10-09 19:21:55');
INSERT INTO student_sessions VALUES('158','1','1','158','3','43','2','175','','2021-10-10 21:25:08','2021-10-10 21:25:08');
INSERT INTO student_sessions VALUES('159','1','1','159','2','24','2','176','','2021-10-13 16:23:18','2021-10-13 16:23:18');
INSERT INTO student_sessions VALUES('160','1','1','160','1','1','2','177','','2021-11-02 17:45:15','2022-01-08 19:10:30');
INSERT INTO student_sessions VALUES('161','1','1','161','2','13','2','178','','2021-11-02 20:05:00','2022-05-07 15:21:26');
INSERT INTO student_sessions VALUES('162','1','1','162','2','13','2','179','','2021-11-02 20:09:26','2022-05-07 15:22:29');
INSERT INTO student_sessions VALUES('163','1','1','163','2','13','2','180','','2021-11-02 20:14:15','2022-05-07 15:20:30');
INSERT INTO student_sessions VALUES('164','1','1','164','2','10','2','181','','2021-11-07 17:06:52','2021-11-07 17:06:52');
INSERT INTO student_sessions VALUES('165','1','1','165','3','44','2','182','','2021-11-11 19:00:37','2022-02-01 19:52:12');
INSERT INTO student_sessions VALUES('166','1','1','166','2','10','2','183','','2022-02-01 21:00:39','2022-02-01 21:00:39');
INSERT INTO student_sessions VALUES('167','1','1','167','2','14','2','184','','2022-02-07 20:19:01','2022-02-07 20:19:01');
INSERT INTO student_sessions VALUES('168','1','1','168','1','9','2','185','','2022-02-11 18:54:33','2022-03-02 17:02:07');
INSERT INTO student_sessions VALUES('169','1','1','169','2','24','2','186','','2022-02-13 18:47:45','2022-02-13 18:47:45');
INSERT INTO student_sessions VALUES('170','1','1','170','1','1','2','187','','2022-03-05 21:08:32','2022-03-05 21:08:32');
INSERT INTO student_sessions VALUES('171','1','1','171','3','32','2','188','','2022-03-06 18:24:49','2022-03-06 18:24:49');
INSERT INTO student_sessions VALUES('172','1','1','172','2','14','2','189','','2022-03-06 19:32:39','2022-04-02 10:43:47');
INSERT INTO student_sessions VALUES('173','1','1','173','3','28','2','190','','2022-03-09 20:59:13','2022-03-09 20:59:13');
INSERT INTO student_sessions VALUES('174','1','1','174','3','30','2','191','','2022-03-09 21:03:18','2022-04-20 15:45:27');
INSERT INTO student_sessions VALUES('175','1','1','175','3','44','2','192','','2022-03-09 22:22:51','2022-03-09 22:22:51');
INSERT INTO student_sessions VALUES('176','1','1','176','3','29','2','193','','2022-03-10 19:56:50','2022-03-10 19:56:50');
INSERT INTO student_sessions VALUES('177','1','1','177','3','29','2','194','','2022-03-11 19:08:44','2022-03-11 19:08:44');
INSERT INTO student_sessions VALUES('178','1','1','178','2','13','2','195','','2022-03-11 19:55:23','2022-05-07 15:23:37');
INSERT INTO student_sessions VALUES('179','1','1','179','3','37','2','196','','2022-04-02 10:55:13','2022-04-02 10:55:13');
INSERT INTO student_sessions VALUES('180','1','1','180','3','37','2','197','','2022-04-02 10:59:46','2022-04-02 10:59:46');
INSERT INTO student_sessions VALUES('181','1','1','181','1','8','2','198','','2022-04-02 11:04:40','2022-04-02 11:04:40');
INSERT INTO student_sessions VALUES('182','1','1','182','1','4','2','19975464','','2022-04-28 16:34:26','2022-07-05 13:51:49');
INSERT INTO student_sessions VALUES('183','1','1','183','2','21','2','65765507','','2022-04-28 16:36:18','2022-04-28 16:36:18');
INSERT INTO student_sessions VALUES('184','1','1','184','3','30','2','37712460','','2022-04-28 16:52:24','2022-06-22 14:52:06');
INSERT INTO student_sessions VALUES('185','1','1','185','3','28','2','92305745','','2022-04-28 16:54:34','2022-04-28 16:54:34');
INSERT INTO student_sessions VALUES('186','1','1','186','1','4','2','72096093','','2022-04-28 17:09:20','2022-04-28 17:09:20');
INSERT INTO student_sessions VALUES('187','1','1','187','3','30','2','38192843','','2022-05-31 13:50:53','2022-06-22 14:47:03');
INSERT INTO student_sessions VALUES('188','1','1','188','2','11','2','90569003','','2022-05-31 13:53:11','2022-06-22 14:53:25');
INSERT INTO student_sessions VALUES('189','1','1','189','3','30','2','74846803','','2022-05-31 13:56:01','2022-06-22 14:48:17');
INSERT INTO student_sessions VALUES('190','1','1','190','3','30','2','19391406','','2022-05-31 13:57:20','2022-06-22 14:49:24');
INSERT INTO student_sessions VALUES('191','1','1','191','1','5','1','5979450','','2022-06-22 14:58:45','2022-06-22 14:58:45');
INSERT INTO student_sessions VALUES('192','1','1','192','1','16','1','71419377','','2022-06-22 15:01:05','2022-06-22 15:01:05');



DROP TABLE IF EXISTS students;

CREATE TABLE `students` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `father_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `birthday` date NOT NULL,
  `gender` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) DEFAULT 1,
  `blood_group` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `religion` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `home_phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `register_no` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activities` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=193 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO students VALUES('1','1','0','160','1','0','Khaliq Naeem','','m.Yousuf','1994-03-07','Male','0','A+','','923414719787','9234654991199','Chakno 508 GB Tandliyawala Fasilabad','Punjab','Pakistan','1','2','3310635005223','5000','2021-06-17 22:44:04','2021-09-12 17:07:16');
INSERT INTO students VALUES('2','1','0','161','1','0','Jahangeer Alam','','Alam Din','1999-07-08','Male','1','A+','','92349-5060128','92341-1081305','Muzaffarabad','Ajk','Pakistan','2','2','82203-5354481-1','SEC-7000','2021-06-17 22:55:01','2022-02-02 22:08:07');
INSERT INTO students VALUES('3','1','0','162','1','0','Tashfeen Tayyab','','IFTIKHAR HUSSAIN','2021-06-16','Male','0','A+','','923443547763','','TEH BARNALA DIS BEHMBAR','AJK','Pakistan','3','2','8110163734959','10000','2021-06-17 22:58:03','2021-08-01 18:38:58');
INSERT INTO students VALUES('4','1','0','163','1','0','SYED MUHAMMAD','','AHMED SHAH','2001-06-19','Male','1','A+','','92306-4272749','92333-7802268','QADRI COLONY WALTON LAHORE','PUNJAB','Pakistan','4','2','54400-3759014-9','5000','2021-06-17 23:08:07','2021-10-01 20:23:53');
INSERT INTO students VALUES('5','1','0','164','1','0','ANNAS NOOR','','NOOR-UL-QAMAR','1999-12-18','Male','0','A+','','92305','92314-5076762','MOH MOTIAN H NO 674 HARIPUR','KPK','Pakistan','5','2','13302-9810592-9','10000','2021-06-17 23:12:37','2022-06-22 14:45:16');
INSERT INTO students VALUES('6','1','0','165','1','0','KALEEMULLAH','','SHAKEEL AHMAD','2021-06-17','Male','0','A+','','92314','','TALAB WALI MASJID SIKANDERPUR HARIPUR','KPK','Pakistan','6','2','13302-8127442-9','10000','2021-06-18 11:33:52','2022-06-22 14:44:59');
INSERT INTO students VALUES('7','1','0','166','1','0','ANIS MALIK','','MAZHAR MALIK','2021-06-17','Male','0','A+','','923187233216','','GUJRAT MAIN CITY','PUNJAB','Pakistan','7','2','','','2021-06-18 11:38:54','2021-07-01 19:34:40');
INSERT INTO students VALUES('8','1','0','167','1','0','AHMAD MALIK','','SHAHID','2001-07-19','Male','0','A+','','923127302950','923086487513','GUJRAT MAIN CITY','PUNJAB','Pakistan','8','2','3420129136565','','2021-06-18 11:42:46','2021-07-01 19:34:24');
INSERT INTO students VALUES('9','1','0','168','1','0','RAJA ZEESHAN','','M.NIAZ','1990-07-21','Male','1','A+','','92333-3231162','','H C-246/1 STREET31-D P&T SOCICTY KORNGI KARACHI','SINDH','Pakistan','9','1','42201-3527698-5','11000','2021-06-18 11:48:09','2022-02-02 22:07:10');
INSERT INTO students VALUES('10','1','0','169','1','0','MOHSIN SHAH','','WAQAR SHAH','2001-07-19','Male','0','A+','','923416421623','923168804514','NIL','PUNJAB','Pakistan','10','2','3220295016345','10000','2021-06-18 15:27:36','2021-08-31 20:19:27');
INSERT INTO students VALUES('11','1','0','170','1','0','MALIK ASAD','','MALIK ISHAQ','2002-05-15','Male','0','A+','','92418096543','923168704514','KAROL','PUNJAB','Pakistan','11','2','322029505555','10000','2021-06-18 15:34:56','2021-10-01 15:28:02');
INSERT INTO students VALUES('12','1','0','171','1','0','KHURAM JAMIL','','JAMIL AHMED','1987-01-24','Male','1','A+','','92321-9030352','','HOUSE 176 NEW SHAMI ROAD CANNT PESHWAR','KPK','Pakistan','12','1','17301-7904568-1','18000','2021-06-18 16:19:00','2022-02-02 20:46:38');
INSERT INTO students VALUES('13','1','0','172','1','0','HASSAN SHAH','','NIL','2021-06-15','Male','0','A+','','923001234567','','','KPK','Pakistan','13','1','','','2021-06-18 16:23:05','2021-09-12 17:06:51');
INSERT INTO students VALUES('14','1','0','173','1','0','SHER AFGAN','','SAIFULLAH','2001-07-19','Male','0','N/A','MUSLIM','92305-8878871','92318-6069733','PEOPLE COLONY  W BLOCK H#14 ST 2 KANEWAL','PUNJAB','Pakistan','14','2','36103-1410896-9','10000','2021-06-18 16:27:08','2022-04-02 10:44:33');
INSERT INTO students VALUES('15','1','0','174','1','0','KAMRAN KHAN','','PAINDA KHAN','1989-09-01','Male','1','N/A','MUSLIM','92332-9042723','','RABANIA STREET, NEAR FOREST COLLEGE PALOSI ROAD PESHWAR','KPK','Pakistan','15','1','17201-7689048-7','10000','2021-06-18 16:30:47','2022-02-02 22:05:58');
INSERT INTO students VALUES('16','1','0','175','1','0','IJAZ AHMAD','','RAHMAN GHANI','2000-04-03','Male','1','N/A','MUSLIM','92346-3969498','92310-9837983','MOHALLA SHAHSAR VILLAGE DHERI , P/O DHERI LIKPANI TEH KATTANG , DISTRICT MARDAN','KPK','Pakistan','16','2','16103-0389430-5','12000','2021-06-18 16:35:15','2022-02-02 20:14:42');
INSERT INTO students VALUES('17','1','0','176','1','0','M.AWAIS','','M.SHABBIR','2001-06-16','Male','1','N/A','MUSLIM','92349-7031646','92333-7470539','TAYYAB CROWN CENTER, KACHERI ROAD, LIAQUATPUR','SINDH','Pakistan','17','2','31302-9155901-5','10000','2021-06-18 16:41:17','2022-02-01 19:56:27');
INSERT INTO students VALUES('18','1','0','177','1','0','EHSAN DANISH','','M.SATTAR','2002-03-31','Male','1','N/A','MUSLIM','92312-6229634','92340-6537248','VILLAGE BURJUN , TEH SAMAHNI DIS BHIMBER AZAD KASHMIR','KASHMIR','Pakistan','18','2','81103-4675586-9','8000','2021-06-18 17:05:43','2022-02-02 20:20:21');
INSERT INTO students VALUES('19','1','0','178','1','0','HASSEB','','SALEEM','2000-02-09','Male','1','','','92304','','HOUSE 57, NAWAB COLONY BAHAWALNAGAR','PUNJAB','Pakistan','19','','31103-2390486-9','10000/5000AC','2021-06-18 17:08:37','2022-06-13 14:52:04');
INSERT INTO students VALUES('20','1','0','179','1','0','M HASNAIN','','TARIQ FAREED','2004-01-03','Male','1','N/A','','92337-7526441','92333-6450281','ZAHID SURGICAL HOSPITAL DAJAL CHOWK BYPASS ROAD JAMPUR DIS RAJANPUR','PUNJAB','Pakistan','20','2','32402-1109845-5','10000','2021-06-18 17:11:03','2022-02-02 20:18:23');
INSERT INTO students VALUES('21','1','0','180','1','0','HUZAIFA QURESHI','','FARRUKH IQBAL','2002-04-25','Male','0','N/A','MUSLIM','92313-5011609','92336-8821490','MOHALA MASOOM NAGAR NEAR POLICTTIM KALLAR SYEDAN TEH KALLAR SYEDAN DISTT RAWALPINDI','PUNJAB','Pakistan','21','2','37402-3145508-7','10000','2021-06-18 17:16:46','2022-02-03 21:04:30');
INSERT INTO students VALUES('22','1','0','181','1','0','MUSTAFA ZAHID','','M. ZAHID KHAN','2001-06-03','Male','1','O+','MUSLIM','92333-1222144','92336-7751237','TEHIL PAROA DIST. DIKHAN','KPK','Pakistan','22','','12101-8685230-7','18000','2021-06-18 17:19:18','2022-02-02 22:14:36');
INSERT INTO students VALUES('23','1','0','182','1','0','ZAHID IQBAL','','M.IQBAL','2021-06-18','Male','0','','','923067724728','','','PUNJAB','Pakistan','23','','','','2021-06-18 17:20:57','2021-08-01 18:47:43');
INSERT INTO students VALUES('24','1','0','183','1','0','MAAZ KHAN','','JAHNZAIB','2021-06-11','Male','0','','','923115446072','','','PUNJAB','Pakistan','24','','','','2021-06-18 17:22:24','2021-08-01 18:47:34');
INSERT INTO students VALUES('25','1','0','184','1','0','SALMAN','','ABC','2021-06-18','Male','0','','','92123456789','','','PUNJAB','Pakistan','25','','','','2021-06-18 17:24:01','2021-08-01 18:46:44');
INSERT INTO students VALUES('26','1','0','185','1','0','NOMAN','','ABC','2021-06-18','Male','0','','','92123456789','','','PUNJAB','Pakistan','26','','','','2021-06-18 17:25:15','2021-08-01 18:46:31');
INSERT INTO students VALUES('27','1','0','186','1','0','AFAN','','ABC','2021-06-18','Male','0','','','92123456789','','','PUNJAB','Pakistan','27','','','','2021-06-18 17:26:25','2021-08-01 18:46:21');
INSERT INTO students VALUES('28','1','0','187','1','0','UMER','','JEHANGIR KHAN','1999-08-03','Male','1','N/A','MUSLIM','92317-2000001','','PANEZAI PALZA TANRA ROAD QUATTA','BALOCHISTAN','Pakistan','28','','54401-5124521-9','12000','2021-06-18 17:28:09','2022-02-02 20:48:28');
INSERT INTO students VALUES('29','1','0','188','1','0','BILAL','','JEHANGIR KHAN','2000-03-01','Male','1','','MUSLIM','92312-9990080','','PANEZAI PALZA TANRA ROAD QUATTA','QUATA','Pakistan','29','','54401-5124521-8','12000','2021-06-18 17:29:24','2022-02-02 20:50:22');
INSERT INTO students VALUES('30','1','0','189','1','0','HASSAN S','','ARIF','2003-03-20','Male','0','N/A','MUSLIM','92333','92300-6564774','KOT KOMBHO NEAR NAIZI TERMINAL BUND ROAD LAHORE','PUNJAB','Pakistan','30','','33303-1634021-9','15500','2021-06-18 17:31:05','2022-04-28 18:47:33');
INSERT INTO students VALUES('31','1','0','190','1','0','MUZAMMIL','','AMJAD','2003-03-09','Male','0','N/A','MUSLIM','92311-7539651','92322-6221433','CHAK NO 203 RB 203 RB MALIKPUR FAISLABAD','PUNJAB','Pakistan','31','','33104-9831157-9','8000','2021-06-18 17:32:46','2022-02-03 21:04:46');
INSERT INTO students VALUES('32','1','0','191','1','0','HASSAN ALI','','UMAR NADEEM','2002-08-18','Male','0','N/A','MUSLIM','92343-6148940','92300-7673249','MOHALA MOZAM SHAH CHINIOT','PUNJAB','Pakistan','32','','33401-0506807-3','10000','2021-06-18 17:33:50','2022-03-02 17:03:32');
INSERT INTO students VALUES('33','1','0','192','1','0','ARSLAN','','M. MEHFOOZ','1999-05-12','Male','0','','MUSLIM','923445127911','923110890202','H NO 413B SECTOR F/1 MIRPUR (A.K)','PUNJAB','Pakistan','33','','8110344705423','13500','2021-06-18 17:35:45','2021-10-03 20:20:51');
INSERT INTO students VALUES('34','1','0','193','1','0','NOUMAN CHEEMA','','NAVEED IQBAL','2001-12-04','Male','1','N/A','MUSLIM','92324-6417924','92309-9783922','BAHRIA TOWN PHASE 8','PUNJAB','Pakistan','34','','34104-0381444-3','','2021-06-18 17:37:09','2022-02-02 21:49:32');
INSERT INTO students VALUES('35','1','0','194','1','0','FAIZAN LASHARI','','FAZAL LAZHARI','1998-08-31','Male','0','N/A','MUSLIM','92345-9808021','','LASHARI HOUSE TEH PORA HOUSE NO 121 D I KHAN','PUNJAB','Pakistan','35','','12101-3376209-9','7000','2021-06-18 17:40:00','2022-03-10 19:53:29');
INSERT INTO students VALUES('36','1','0','195','1','0','M. ISHAQ','','M.YOUSAF','1999-08-31','Male','1','','','92333-3282555','','IRFANABAD COLONY JAMPUR DIST RAJABPUR','PUNJAB','Pakistan','36','','32402-6000838-5','10000','2021-06-18 17:42:18','2022-02-02 21:48:58');
INSERT INTO students VALUES('37','1','0','196','1','0','ABDUL HAKEEM','','M. MUQEEM','2004-07-21','Male','1','N/A','MUSLIM','92313-5691111','','MOUZA RUSTAM LIGHARI P/O KOTLA MUGHLAN TEH JAMPUR DISTT RAJANPUR','PUNJAB','Pakistan','37','','32402-2357945-9','10000','2021-06-18 17:43:34','2022-02-02 21:39:03');
INSERT INTO students VALUES('38','1','0','197','1','0','SABTAIN RASOOL','','ISHFAQ AHMAD MALIK','1998-03-24','Male','0','','','923450981003','','VPO DHODA THESIL AND DISTT CHAKWAL','PUNJAB','Pakistan','38','2','37201-5817125-3','','2021-06-18 17:46:10','2021-08-31 20:18:02');
INSERT INTO students VALUES('39','1','0','198','1','0','HASNAIN ASIF','','CH ASIF','1998-03-24','Male','0','','','923349105545','','','PUNJAB','Pakistan','39','','','','2021-06-18 17:48:58','2021-08-31 20:17:36');
INSERT INTO students VALUES('40','1','0','199','1','0','DANISH','','AFTAB HUSSAIN','1999-11-01','Male','0','','','923463916033','','','PUNJAB','Pakistan','40','','','','2021-06-18 17:50:32','2021-09-12 17:04:47');
INSERT INTO students VALUES('41','1','0','200','1','0','SILAL KARIM','','M.KARIM','1998-04-04','Male','1','N/A','MUSLIM','92302-5400849','','TAPPI KORAK TEH DISTT KORAK','KPK','Pakistan','41','','14202-7571517-9','13000','2021-06-18 17:56:07','2022-02-02 21:41:36');
INSERT INTO students VALUES('42','1','0','201','1','0','IQRAR','','IJAZ','2000-06-06','Male','1','','','92321-2358844','','MOHALA PARI VILLAGE CHINJI TEHSIL TALAGANG DISTRIST CHAKWAL','PANJAB','Pakistan','42','','37203-0292991-9','5000','2021-06-18 18:05:22','2022-02-02 21:55:31');
INSERT INTO students VALUES('43','1','0','202','1','0','ABDUL BASIT','','ABDUL REHMAN','1998-11-22','Male','1','N/A','MUSLIM','92346-1427154','92324-1595066','UGOKE WAZERABAD ROAD SIALKOT','PANJAB','Pakistan','43','','34603-9719284-7','16000','2021-06-18 18:13:03','2021-10-11 16:59:26');
INSERT INTO students VALUES('44','1','0','203','1','0','ARSLAN KHAN','','ASLAM NADEEM','1999-06-24','Male','1','N/A','MUSLIM','92307-4957575','92302-7737302','WARD NO 8 H NO 156 MOHALLAHA GURYANVI HAYYAH','PANJAB','Pakistan','44','2','32203-3013177-7','10000','2021-06-18 18:20:37','2022-02-02 20:57:15');
INSERT INTO students VALUES('45','1','0','204','1','0','M.FAZEEL','','MIRZA ROHAIL','2000-09-17','Male','1','N/A','MUSLIM','92311-6782700','92333-8212144','H NO 6 STREET 13 Z BLOCK PEOPLE COLONY GUJRANWALA','PANJAB','Pakistan','45','','34203-8613777-9','10000','2021-06-18 18:24:26','2022-02-02 20:59:26');
INSERT INTO students VALUES('46','1','0','205','1','0','MUSTABIN','','MUHAMMAD AFZAL CH','2000-01-05','Male','1','A+','','92306-8749764','92300-0070010','AIRFWALA','PANJAB','Pakistan','46','2','36401-6046652-3','17500+2000=19500','2021-06-18 18:33:18','2022-02-02 20:58:21');
INSERT INTO students VALUES('47','1','0','206','1','0','M.ALI','','ABC','2021-06-18','Male','0','A+','','923054546455','','','PANJAB','Pakistan','47','','','','2021-06-18 18:34:51','2021-09-12 17:05:40');
INSERT INTO students VALUES('48','1','0','207','1','0','Omer Ghaffar','','Sikander Ghaffar','1988-05-26','Male','1','','MUSLIM','92346-5388788','92345-9146684','P.O BARGAI WAZIRABAD MALAKAND','KPK','Pakistan','48','','15401-8471778-7','16000','2021-06-18 18:55:43','2021-10-11 17:45:07');
INSERT INTO students VALUES('49','1','0','208','1','0','M KASHIF','','M.SAEED','1999-09-09','Male','1','','','92304-0719033','','MULTAN','PANJAB','Pakistan','49','2','36201-4912617-1','2500','2021-06-18 19:00:15','2022-02-02 22:10:59');
INSERT INTO students VALUES('50','1','0','209','1','0','RAI AHMAD','','ASHFAQ HUSSAIN','1999-01-05','Male','1','N/A','MUSLIM','92331-6434221','','H 2503 SHARIF PURA GUJRANWALA CANNT','PANJAB','Pakistan','50','','34101-5505263-1','16500','2021-06-18 19:03:24','2022-02-02 21:37:07');
INSERT INTO students VALUES('51','1','0','210','1','0','WAQAS','','ZAHID MALIK','2000-02-19','Male','1','N/A','MUSLIM','92336-7531194','92305-5607317','5 STADIUM ROAD SARGODHA','PUNJAB','Pakistan','51','','38403-5834843-5','16500','2021-06-18 19:10:39','2022-02-02 21:36:33');
INSERT INTO students VALUES('52','1','0','211','1','0','USMAN','','ASAD ABBAS','2000-01-03','Male','1','','MUSLIM','92311-4773884','923072318112','H NO 18 FATIMA HOUSING SOCIETY MA JINNH ROAD MULTAN','PUNJAB','Pakistan','52','2','36302-7578821-9','16500','2021-06-18 19:14:21','2021-10-01 19:57:46');
INSERT INTO students VALUES('53','1','0','212','1','0','ANS REHMAN','','RIAZ AHMAD','2000-11-12','Male','1','','MUSLIM','92321-4362292','92336-7531194','STREET#2, SHAMSHEER TOWN SARGODHA','punjab','Pakistan','53','','38406-0433804-7','16500','2021-06-18 19:16:09','2022-02-02 22:01:56');
INSERT INTO students VALUES('54','1','0','213','1','0','ABDULL HAKIM','','Abdul Rasheed','2002-07-04','Male','1','','','92334-3619638','92318-1995009','MEMON MUHALLAH KAMBER ALI KHAN','SINDH','Pakistan','54','2','43402-0536999-9','10000/-','2021-06-18 19:19:17','2022-02-02 22:03:59');
INSERT INTO students VALUES('55','1','0','214','1','0','M ALI','','MUHAMMAD MUNIR','2001-08-29','Male','1','N/A','MUSLIM','92312','92316-6008276','H 247 BLOCK Y IQBAL COLONY SARGODHA','PUNJAB','Pakistan','55','2','38403-7359004-1','10000/-5000AC','2021-06-18 19:21:24','2022-06-13 14:51:28');
INSERT INTO students VALUES('56','1','0','215','1','0','M SHAHEEM','','M AYUB','1993-11-13','Male','1','N/A','MUSLIM','92301-5578117','','P/O KHAS MOIAL TEH BARNALA DISTT BHIMAR','KHASMIR','Pakistan','56','1','81101-9536922-3','10000','2021-06-18 19:23:20','2022-02-03 21:00:20');
INSERT INTO students VALUES('57','1','0','216','1','0','SAGAR ALI','','LAL BUX','1995-04-14','Male','1','N/A','','92336-2565454','92333-2305487','FLAT T 2-1 FLORIDA HOMES KARACHI','SINDH','Pakistan','57','2','45202-8164509-3','10000','2021-06-18 19:25:33','2022-02-02 21:22:40');
INSERT INTO students VALUES('58','1','0','217','1','0','USAMAN ALI','','ZAREEN KHAN','2021-06-23','Male','0','','','923454000133','','','PUNJAB','Pakistan','58','2','','16500','2021-06-18 19:27:08','2021-08-01 18:40:34');
INSERT INTO students VALUES('59','1','0','218','1','0','FARHAN','','GHULAM JILANI','2001-06-17','Male','0','','','923181523928','','','KPK','Pakistan','59','2','','','2021-06-18 19:46:51','2021-11-01 19:51:47');
INSERT INTO students VALUES('60','1','0','219','1','0','DILAWAR','','FAREEED','1992-04-07','Male','1','','','92347-5388982','','P/O BOX CHIKAR DISRT HATTAIN BALA','KPK','Pakistan','60','','82703-0339515-7','4000','2021-06-18 19:54:56','2022-02-03 20:52:02');
INSERT INTO students VALUES('61','1','0','220','1','0','MAJID','','MANZOOR','1996-06-12','Male','1','','','92340-8887007','','MAIN TOWN CHIKAR NEAR HOSPITAL  DISTRICT HATTIANBALA','KASHMIR','Pakistan','61','1','82703-0345604-7','4000','2021-06-18 20:02:31','2022-02-02 21:19:34');
INSERT INTO students VALUES('62','1','0','221','1','0','SOHAIB','','TANVEER','2021-06-17','Male','1','','','92301-5612312','','MAIN TOWN CHIKAR NEAR HOSPITAL  DISTRICT HATTIANBALA','KHASMIR','Pakistan','62','','82202-2322391-1','4000','2021-06-18 20:05:09','2022-02-02 21:20:23');
INSERT INTO students VALUES('63','1','0','222','1','0','RISALAT','','ABC','2021-06-17','Male','0','','','923348532102','','','KPK','Pakistan','63','','','','2021-06-18 20:10:22','2021-09-12 17:04:11');
INSERT INTO students VALUES('64','1','0','223','1','0','HUZAIFA','','SAJIDULLAH','2001-12-04','Male','1','N/A','MUSLIM','92306-7003549','92346-6965459','OFFICERS COLONY MIANWALI','PUNJAB','Pakistan','64','','38302-7453882-1','7500','2021-06-18 20:32:02','2022-02-02 21:25:57');
INSERT INTO students VALUES('65','1','0','224','1','0','SOHAIB','','ABC','2021-06-17','Male','0','','','923332353543','','','KPK','Pakistan','65','2','','','2021-06-18 20:39:44','2021-09-28 16:21:51');
INSERT INTO students VALUES('66','1','0','225','1','0','SHAHZAIB','','ABC','2021-06-17','Male','0','A+','','923083865408','','','KPK','Pakistan','66','','','','2021-06-18 20:41:24','2021-09-28 16:21:37');
INSERT INTO students VALUES('67','1','0','226','1','0','AHMAD','','ABC','2021-06-17','Male','0','A+','','923431105244','','','PANJAB','Pakistan','67','','','','2021-06-18 20:43:07','2021-09-28 16:21:23');
INSERT INTO students VALUES('68','1','0','227','1','0','HAMZA MUGHAL','','MAQSOOD MUGHAL','1999-08-07','Male','0','A+','MUSLIM','92304-0090090','','STREET 03 HOUSE 01 ABID COLONY GUJRAWALA','PUNJAB','Pakistan','68','','34101-8840271-1','10000','2021-06-18 20:56:29','2022-06-22 14:54:07');
INSERT INTO students VALUES('69','1','0','228','1','0','GHAFFAR ALI','','NASIR ALI','1987-10-31','Male','1','N/A','MUSLIM','92345-9146684','92300-5885207','FLAT 38 F GATE NO 4 ARMY FLATS BARA ROAD PESHAWAR CATT','KPK','Pakistan','69','','15401-9705263-5','16000','2021-06-18 21:00:23','2022-02-02 21:14:32');
INSERT INTO students VALUES('70','1','0','229','1','0','SHAUR','','ABC','2021-06-17','Male','0','','','923459088710','','','KPK','Pakistan','70','','','','2021-06-18 21:02:34','2021-11-09 20:34:50');
INSERT INTO students VALUES('71','1','0','230','1','0','QAZI TAHA FATEEN','','QAZI TOUQEER','2001-04-10','Male','1','','','92316-0141329','92332-4351213','FLAT NO 16/8 MOHALLA QAZIYA WALA DERA ISMAIL KHAN','PUNJAB','Pakistan','71','','12101-7320808-9','16500','2021-06-18 21:06:03','2021-10-01 20:39:32');
INSERT INTO students VALUES('72','1','0','231','1','0','SHAHBAZ KHAN','','TARIQ MUHAMMAD','1999-08-18','Male','1','','','92317-3955986','92330-05686414','NOESHERA AS COLONY BLOCK E ST 11 H 258','KPK','Pakistan','72','','16202-5608575-7','10000','2021-06-18 21:09:44','2021-10-01 20:48:57');
INSERT INTO students VALUES('73','1','0','232','1','0','HAMZA HAFEEZ','','HAFEEZ UR REHMAN','2000-11-14','Male','0','','','923066660208','923226660208','HOUSE 49 Y IQBAL COLONY SARGODHA','PUNJAB','Pakistan','73','','38403-8988884-3','16500','2021-06-18 21:12:11','2021-09-28 16:57:20');
INSERT INTO students VALUES('74','1','0','233','1','0','USAMA BAIG','','ARSHAD BAIG','2002-03-01','Male','1','','','92331','92331-3275327','STAFF GALA TOHLI PURA GUJRAT','PUNJAB','Pakistan','74','','34201-3667790-5','','2021-06-18 21:13:59','2022-04-26 17:21:03');
INSERT INTO students VALUES('75','1','0','234','1','0','MURAD ALI','','SHAUKAT ALI','1999-10-30','Male','0','','','923419429101','','','KPK','Pakistan','75','','','10000','2021-06-18 21:15:39','2021-08-31 20:15:13');
INSERT INTO students VALUES('76','1','0','235','1','0','HUZAIFA','','AMANT ALI','2004-04-04','Male','1','N/A','','923418448215','923167712721','BEHARIA TOWN PWD','PUNJAB','Pakistan','76','','34602-5389591-3','10000 SAMIULLAH','2021-06-18 21:18:35','2022-05-07 15:10:16');
INSERT INTO students VALUES('77','1','0','236','1','0','M.UMAR','','M.BANARAS','2001-02-13','Male','1','','','92311-8849367','92310-5167386','MOHALLA GUJRAT HAVELIAN VILLAGE ABBOTTABAD','KPK','Pakistan','77','','37405-9902223-1','10000','2021-06-18 21:20:45','2022-02-02 20:56:03');
INSERT INTO students VALUES('78','1','0','237','1','0','ABDUL RAUF','','M. SHAFIQUE','1999-04-13','Male','1','','','92317','','HOUSE NO 310 STREET 50 PAKISTAN TOWN','PUNJAB','Pakistan','78','','34202-9465703-7','12000/6000','2021-06-18 21:22:22','2022-06-13 14:49:12');
INSERT INTO students VALUES('79','1','0','238','1','0','HASSAN','','ISRAR HUSSAIN','1998-07-07','Male','1','','','92303','','SHUBLAN PARACHINAR UPPER KURRAM AGENCY','KPK','Pakistan','79','','21303-4208422-3','14000/6000 AC','2021-06-18 21:23:48','2022-06-13 14:48:17');
INSERT INTO students VALUES('80','1','0','239','1','0','SAAD AHMAD','','AHMAD YAR','2002-08-14','Male','0','','','92342-5609190','92317-8402830','JAND DISTT ATTOCK','PUNJAB','Pakistan','80','','37104-3710646-7','7000','2021-06-18 21:25:30','2022-04-28 17:06:35');
INSERT INTO students VALUES('81','1','0','240','1','0','QAZI SOBAN HABIB','','ARSHAD ZAMAN','2001-07-21','Male','1','B+','MUSLIM','92309-1817719','92347-8010335','GHAIR KHAN ROAD PANDAK HARIPUR','KPK','Pakistan','81','','13302-5921005-7','16500','2021-06-18 21:27:19','2021-11-07 21:54:01');
INSERT INTO students VALUES('82','1','0','241','1','0','SAUD IRSHAD','','M IRSHAD','2000-07-18','Male','1','','','92311-8938559','','HARIPUR SIKANDARPUR','PUNJAB','Pakistan','82','','13302-2675176-7','10000','2021-06-18 21:29:49','2022-02-02 22:17:19');
INSERT INTO students VALUES('83','1','0','242','1','0','HARIS','','SHAHZAD KHAN','2001-07-29','Male','1','','MUSLIM','92335-2364046','92331-5707145','MAIN BAZAR HARIPUR','KPK','Pakistan','83','','13302-9685927-1','5000','2021-06-18 21:32:43','2022-03-02 17:21:45');
INSERT INTO students VALUES('84','1','0','243','1','0','AMMAR','','ABC','2021-06-18','Male','0','','','923165005577','','','PUNJAB','Pakistan','84','','','','2021-06-18 21:35:43','2021-08-01 18:39:50');
INSERT INTO students VALUES('85','1','0','244','1','0','HAZRAT ALI','','ABC','2021-06-18','Male','0','','','923499001990','','','KPK','Pakistan','85','','','','2021-06-18 21:37:37','2021-08-01 18:39:40');
INSERT INTO students VALUES('86','1','0','245','1','0','SAUD','','ABC','2021-06-18','Male','0','','','923034093917','','','PUNJAB','Pakistan','86','','','','2021-06-18 21:39:05','2021-08-01 18:39:30');
INSERT INTO students VALUES('87','1','0','246','1','0','IBNE ALI','','ABC','2021-06-18','Male','0','','','923340807447','','','PUNJAB','Pakistan','87','','','','2021-06-18 21:40:23','2021-08-01 18:39:18');
INSERT INTO students VALUES('88','1','0','247','1','0','M HUSNAIN','','M. AZEEM','2001-03-18','Male','0','N/A','MUSLIM','92333-5820613','92345-5716713','177/2 AZIZ BHATTI ROAD JEHLUM CANTT','PUNJAB','Pakistan','88','','37301-4329996-5','12500','2021-06-18 21:42:11','2021-11-07 17:02:38');
INSERT INTO students VALUES('89','1','0','248','1','0','JAWAD','','ABC','2021-06-18','Male','0','','','923180725686','','','PUNJAB','Pakistan','89','','','','2021-06-18 21:43:49','2021-10-01 15:30:10');
INSERT INTO students VALUES('90','1','0','249','1','0','HAMZA DURANI','','AMIR ASLAM','2021-06-18','Male','0','','','923005843200','','','PUNJAB','Pakistan','90','','','7000','2021-06-18 21:45:06','2021-08-01 18:38:46');
INSERT INTO students VALUES('91','1','0','250','1','0','SAIF','','ABC','2021-06-18','Male','0','','','923105306929','','','PUNJAB','Pakistan','91','','','12000','2021-06-18 21:48:35','2021-09-12 17:02:15');
INSERT INTO students VALUES('92','1','0','251','1','0','AWAIS','','ABC','2021-06-18','Male','0','','','92123456789','','','PUNJAB','Pakistan','92','','','','2021-06-18 21:51:19','2021-08-01 18:37:39');
INSERT INTO students VALUES('93','1','0','252','1','0','M.JUNAID','','M.JAHANGIR','1999-11-08','Male','1','','MUSLIM','92306-8470794','92317-3990889','GREEN TOWN MIANWALI','PUNJAB','Pakistan','93','','38302-9898924-7','','2021-06-18 21:52:40','2021-10-01 20:22:46');
INSERT INTO students VALUES('94','1','0','253','1','0','HASEEB','','ABC','2021-06-18','Male','0','','','923101530741','','','PUNJAB','Pakistan','94','','','','2021-06-18 21:53:56','2021-08-01 18:36:51');
INSERT INTO students VALUES('95','1','0','254','1','0','M. MAAZ AMJAD','','AMJAD ALI','2001-01-31','Male','0','','','923013015218','','','KPK','Pakistan','95','','','10000','2021-06-18 21:55:34','2021-08-01 18:37:13');
INSERT INTO students VALUES('96','1','0','255','1','0','M. IRFAN','','MANZOOR HUSSAIN','1990-03-15','Male','1','','','92300-3872009','','H 297-C MODLE TOWN N BLOCK LAHORE','PUNJAB','Pakistan','96','','36102-1659391-5','','2021-06-18 21:58:33','2021-10-01 20:05:59');
INSERT INTO students VALUES('97','1','0','256','1','0','M.UMAR','','iftkikhar ahmed','2010-07-14','Male','1','A+','MUSLIM','92332-4048216','','house 210, st 2, block c, wapda town, lahore','PUNJAB','Pakistan','97','1','54400-5561231-1','18000','2021-06-18 22:01:29','2021-11-19 17:26:20');
INSERT INTO students VALUES('98','1','0','257','1','0','DR. IMRAN','','FAZAL MUHAMMAD','1988-03-10','Male','0','N/A','MUSLIM','92333-9880158','92334-9321879','MOH BACLA AMANKOT MINGORA SAWAT','KPK','Pakistan','98','','15602-1523064-7','10000','2021-06-18 22:03:40','2022-02-11 18:55:56');
INSERT INTO students VALUES('99','1','0','258','1','0','SIBT UL HASSAN','','LIAQAT ALI','1999-10-12','Male','1','N/A','NON MUSLIM','92344','92320-1257112','DASKA SIALKOT','PUNJAB','Pakistan','99','','34601-8053575-9','NIL','2021-06-18 22:05:39','2022-04-04 14:29:48');
INSERT INTO students VALUES('100','1','0','259','1','0','HAMZA F','','M.FAROOQ','2000-08-19','Male','1','','','92343','','HOUSE NO 05 SHAMI ROAD CANNT D.I KHAN','PUNJAB','Pakistan','100','','12101-8901188-1','10000','2021-06-18 22:07:17','2022-04-28 16:49:30');
INSERT INTO students VALUES('101','1','0','261','1','0','HASSAN KHAN','','ILYAS KHAN','2002-03-05','Male','1','N/A','MUSLIM','92313-5653071','92316-5734738','IRSHAD NAGAR JOIRA MAIRA TEH HAWALIYAN DISTT','Punjab','Pakistan','101','','13101-6962250-3','10000','2021-06-19 08:39:53','2022-06-10 12:14:55');
INSERT INTO students VALUES('102','1','0','262','1','0','HAMZA ALI','','ZULFIQAR ALI','2000-05-11','Male','1','N/A','MUSLIM','92303-2267544','','AZAD KASHMIR','KHASHMIR','Pakistan','102','','81205-0138351-3','10000','2021-06-19 08:42:39','2021-10-01 19:59:56');
INSERT INTO students VALUES('103','1','0','263','1','0','M.HASEEB','','M.AKHTAR','1996-05-12','Male','0','A+','MUSLIM','92331-5346344','','LAHORE','PUNJAB','Pakistan','103','2','35201-3256000-3','1000','2021-06-19 13:36:38','2021-11-10 18:16:43');
INSERT INTO students VALUES('104','1','0','264','1','0','GHAZAN KHAN','','MINHAJ M','1997-06-26','Male','1','N/A','MUSLIM','92308-5777958','92313-6764673','MOH KALIKOT VILL KALABAT TEH TOPI DISTT SWABI','KPK','Pakistan','104','2','16203-0381825-3','15000','2021-06-19 13:43:40','2022-02-02 21:29:17');
INSERT INTO students VALUES('105','1','0','265','1','0','ASIM','','ABC','2021-06-09','Male','0','','','923152963445','','','KPK','Pakistan','105','','','','2021-06-19 13:50:05','2021-09-12 17:01:20');
INSERT INTO students VALUES('106','1','0','266','1','0','AHMAD BIN WAHID','','ABDUL WAHID','2003-02-06','Male','0','','','923164192377','','','KPK','Pakistan','106','','3540427685915','10000','2021-06-19 13:54:18','2021-08-01 18:35:53');
INSERT INTO students VALUES('107','1','0','267','1','0','ABDULLAH','','SAFIR','2001-07-10','Male','1','N/A','MUSLIM','92314-4767545','92334-4372369','H NO151 ST 6 MEHAR SARGODHA','PUNJAB','Pakistan','107','','33302-2172084-1','10000','2021-06-19 13:56:09','2021-10-01 18:39:48');
INSERT INTO students VALUES('108','1','0','268','1','0','DAOUD','','ZAFAR IQBAL','2001-07-24','Male','1','N/A','MUSLIM','92324-4000774','92302-8471803','SADIQBAD RAHIM YAR KHAN','PUNJAB','Pakistan','108','','31304-9821113-1','','2021-06-19 13:58:42','2022-01-03 20:02:14');
INSERT INTO students VALUES('109','1','0','269','1','0','EHSAN','','FAZAL LASHARI','2021-06-07','Male','0','','','92345-9808021','','LASHARI HOUSE TEH PORA HOUSE NO 121 D I KHAN','PUNJAB','Pakistan','109','','12101-9390892-5','','2021-06-19 14:25:25','2022-03-10 19:53:42');
INSERT INTO students VALUES('110','1','0','270','1','0','JAWAD AHMAD','','M.ZUBAIR','2002-11-06','Male','0','N/A','MUSLIM','92307-8620818','92300-5222458','Q J3/7 APF COLONY KAMRA ATTOCK','PUNJAB','Pakistan','110','','37105-3915736-1','10000','2021-06-19 14:30:21','2022-01-08 19:09:48');
INSERT INTO students VALUES('111','1','0','271','1','0','M.SAEED','','M.YOUNAS','2001-03-04','Male','1','','MUSLIM','92342-0767536','92332-9860383','DEFENSE COLONY SHAHBAZ GHARI MARDAN','KPK','Pakistan','111','','16101-1119932-3','10000','2021-06-19 14:32:45','2021-10-01 18:44:57');
INSERT INTO students VALUES('112','1','0','272','1','0','SHAN ALI','','AMANAT ALI','1994-07-09','Male','1','A+','','92300-7633339','92304-4373339','339-JB GOJRA DISTT TOBA TAKE SINGH','PUNJAB','Pakistan','112','1','33301-986211-5','10000','2021-06-19 18:10:11','2021-10-01 18:46:47');
INSERT INTO students VALUES('113','1','0','273','1','0','AHMED KHAN','','UMER KHAN','2002-07-08','Male','1','B+','','92317-0085197','92307-9121120','CIRCULAR ROAD,HARIPUR, KPK','KPK','Pakistan','113','','13302-5202777-5','10000','2021-06-21 19:32:16','2021-11-08 18:23:43');
INSERT INTO students VALUES('114','1','0','274','1','0','MUJTABA KHAN','','NAEEM KHAN','2000-10-20','Male','1','N/A','','92314','92300-8305424','ST 16 H NO 330 D G-10/2 ISB','FEDRAL','Pakistan','114','2','15602-5458013-5','19000/10000 AC','2021-06-28 19:04:03','2022-06-13 14:49:44');
INSERT INTO students VALUES('115','1','0','275','1','0','M.Faisal','','M.HAYAT','1992-11-19','Male','1','','','92343-1188121','92301-5722740','VILLAGE CHINNI P-O-B TARAKHEL, TEH HAJIA DISTT POONCH','ISLAMABAD','Pakistan','115','','82302-7066706-9','','2021-06-30 23:01:11','2021-10-01 20:24:36');
INSERT INTO students VALUES('116','1','0','276','1','0','EXTRA SEAT','','SDVFDFVG','2021-06-29','Male','1','','','923000000000','','','PUNJAB','Pakistan','116','','12113-1654552','','2021-06-30 23:12:22','2022-05-22 07:10:06');
INSERT INTO students VALUES('117','1','0','277','1','0','M.HAROON','','M.SADIQ','2021-07-07','Male','0','','','923445574788','','','PUNJAB','Pakistan','117','','','','2021-07-03 19:35:49','2021-08-31 20:13:18');
INSERT INTO students VALUES('118','1','0','278','1','0','SANGAR KHAN','','AAAAAAA','2021-07-12','Male','0','','','923139618006','','','PUNJAB','Pakistan','118','','','','2021-07-03 19:40:24','2021-08-31 20:13:08');
INSERT INTO students VALUES('119','1','0','279','1','0','SHAHID','','AAAAAA','2021-07-05','Male','0','','','9212345678','','','KASHMIR','Pakistan','119','','','','2021-07-10 14:30:14','2021-08-31 20:12:48');
INSERT INTO students VALUES('120','1','0','280','1','0','M TAHA','','ASIF GULAB','2001-02-14','Male','0','A+','','92301-3735140','92312-8055071','MADINA MARKET WARD 10 MUZAFARABAD','KASHMIR','Pakistan','120','','37405-1043643-5','15500','2021-08-01 20:11:13','2022-03-11 18:59:22');
INSERT INTO students VALUES('121','1','0','288','1','0','Hafiz Sarmad','','Abdul Latif','2000-12-22','Male','1','','MUSLIM','92347-0537937','92305-6965079','house 9 Indus Colony DG khan','punjab','Pakistan','121','2','32102-3403198-5','10000','2021-08-12 20:28:57','2021-10-01 20:41:18');
INSERT INTO students VALUES('122','1','0','289','1','0','PHOOL M','','M.YOUSAF','1993-02-01','Male','0','N/A','MUSLIM','92302-7805934','','CHAK NO 89 JB RATTAN FAISLABAD','PUNJAB','Pakistan','122','','33103-0601050-1','14000','2021-08-12 20:32:01','2022-03-02 17:00:47');
INSERT INTO students VALUES('123','1','0','290','1','0','ANEES KHAN','','MUHAMMAD IDREES','2001-01-01','Male','1','A+','MUSLIM','92341-2410452','92341-2410452','street 41C, g7/4, Islamabad','Federal','Pakistan','123','2','15402-2652160-1','8000','2021-08-31 20:01:53','2022-02-02 20:22:34');
INSERT INTO students VALUES('124','1','0','291','1','0','Ahtisham uddin','','Nizamud din','1995-02-15','Male','0','B+','MUSLIM','92311-5000999','92311-9816499','salman and bros gen store airport road gilgit','Pakistan','Pakistan','124','2','71501-5773646-3','10000','2021-09-02 20:09:54','2022-04-28 16:30:11');
INSERT INTO students VALUES('125','1','0','292','1','0','M ABDULLAH','','IFTIKHAR AHMED','2002-03-16','Male','0','','MUSLIM','92305-8247244','92302-7653994','RAHIM YAR KHAN','PUNJAB','Pakistan','130','2','31303-2556606-3','17000','2021-09-08 20:49:09','2022-03-06 18:11:35');
INSERT INTO students VALUES('126','1','0','293','1','0','M TAYYAB','','AFSAR WAHAB KHAN','2000-01-01','Male','1','A+','MUSLIM','92333','92333-4053330','HOUSE NO. 444 BLOCK NO. 17 DERA GHAZI KHAN','PUNJAB','Pakistan','131','2','32102-1030594-7','10000/5000AC','2021-09-09 20:49:50','2022-06-13 14:52:52');
INSERT INTO students VALUES('127','1','0','294','1','0','SHAHZAIB NADEEM','','MUHAMMAD NADEEM','2000-08-07','Male','1','A+','MUSLIM','92311-6415069','92300-6415069','STREET 1MADINAH COLONY ALLAH WALA BAZAR GRW','PUNJAB','Pakistan','132','2','34103-1157061-3','','2021-09-09 20:56:53','2021-10-01 20:54:47');
INSERT INTO students VALUES('128','1','0','295','1','0','SAIFULLAH','','ALLAH DITTA','2000-04-20','Male','1','A+','MUSLIM','92301-5757256','92304-6699948','FAISALABAD','PUNJAB','Pakistan','133','2','33101-4794131-5','15000','2021-09-10 18:30:18','2021-10-01 18:43:58');
INSERT INTO students VALUES('129','1','0','296','1','0','MUNEEB','','RAFIQ','2003-02-10','Male','0','A+','MUSLIM','92315-8101545','92302-0181709','KASRI TOWN QUETTA CANNT','BALOCHISTAN','Pakistan','136','2','54401-3547886-1','12000','2021-09-13 17:16:14','2022-06-13 14:45:35');
INSERT INTO students VALUES('160','1','0','327','1','0','SAQLAIN HAIDER','','SHAKIR HUSSAIN','1999-09-09','Male','0','A+','MUSLIM','92343-5564123','92346-8484382','PECHAN BAKRY ALAMEDAER CHOWK SKERDU','KPK','Pakistan','177','2','72301-0343210-7','15500','2021-11-02 17:45:15','2022-03-02 17:24:17');
INSERT INTO students VALUES('130','1','0','297','1','0','FAHAD FAHEEM','','FAHEEM NAWAZ','2021-07-23','Male','1','A+','MUSLIM','92312-5097748','92334-4482128','NEAR DARA MEHRAL MANSEHRA DISTT KHUSHAB','PUNJAB','Pakistan','137','2','38201-2252817-5','15000','2021-09-15 19:02:10','2021-10-01 20:07:15');
INSERT INTO students VALUES('131','1','0','298','1','0','FARUKH','','UMAR KHAN','2000-09-03','Male','1','A+','MUSLIM','92315-8862881','92317-2000001','QURESHI BUILDING FATIMA JINNAH ROAD QUETTA','KPK','Pakistan','138','2','54401-5440021-7','16500','2021-09-15 19:06:23','2022-02-02 20:13:01');
INSERT INTO students VALUES('132','1','0','299','1','0','M.SAAD','','SHAHID HUSSAIN','2004-09-12','Male','0','A+','MUSLIM','92307','92301-6020079','H NO 6 ST 01 BOSAN ROAD MULTAN','PUNJAB','Pakistan','139','2','36302-2118095-7','17000','2021-09-15 19:10:09','2022-05-31 13:38:26');
INSERT INTO students VALUES('133','1','0','300','1','0','SAHIBZADA HASNAIN','','ARIF','2000-04-15','Male','0','A+','MUSLIM','92311-9333511','','ANWER MEDICAL CENTER THE MALL MARDAN','KPK','Pakistan','140','2','16101-5809510-1','12500','2021-09-18 19:09:36','2022-06-07 16:55:55');
INSERT INTO students VALUES('167','1','0','334','1','0','TALAL SAJID','','SAJID KHAN','2004-04-11','Male','0','B+','MUSLIM','92314-4127151','92312-5387151','VILLAGE P/O BURHAN TEH HASSAN ABDAL DISRT ATTOK','PUNJAB','Pakistan','184','2','37103-6192705-9','15000','2022-02-07 20:19:01','2022-04-02 10:43:09');
INSERT INTO students VALUES('134','1','0','301','1','0','ABDULLAH KIYANI','','ZAHOOR AHMED','2000-06-11','Male','0','A+','MUSLIM','92318-5086871','92349-5352674','MOHALA MADNI POST OFFICE KHAS NERA TEH KEHOTA RWP','PUNJAB','Pakistan','141','2','37402-2544007-9','15000','2021-09-18 19:35:53','2022-02-07 20:16:20');
INSERT INTO students VALUES('135','1','0','302','1','0','HASEEB SHAHID','','SHAHID','2001-06-16','Male','1','A+','MUSLIM','92300-0692795','92300-8612927','GULSHAN E MUSA BLOCK H NO 70-A P/O KHAS SAHIWAL','PUNJAB','Pakistan','142','2','35202-5655388-3','10000','2021-09-19 19:40:15','2021-10-01 20:33:30');
INSERT INTO students VALUES('136','1','0','303','1','0','ABDULL REHMAN','','SAEED MALIK','1999-08-25','Male','1','A+','MUSLIM','92342-1898549','','404 MALIK HAWLI SALAL BABA CHOWK MAILKPURA ABTTABAD','KPK','Pakistan','143','2','13101-3940078-5','13000','2021-09-19 19:52:14','2021-09-28 18:26:59');
INSERT INTO students VALUES('137','1','0','304','1','0','HASSAN KHAN','','IJAZ ANWAR','1999-10-10','Male','0','A+','MUSLIM','92334-9107225','92334-5536750','SHAMI ROAD PESHAWAR','KPK','Pakistan','144','2','17301-8695915-7','21000','2021-09-28 18:22:17','2022-05-07 16:06:14');
INSERT INTO students VALUES('138','1','0','305','1','0','SHEHROZ KHAN','','ASLAM HAYAT','2004-11-20','Male','1','A+','MUSLIM','92315-4446782','923164692818','85 CANAL VIEW PARK HOUSING COLONY SHEKHOPURA','PUNJAB','Pakistan','145','2','34302-8881615-9','17000','2021-09-28 18:32:05','2021-09-28 18:32:05');
INSERT INTO students VALUES('139','1','0','306','1','0','ZAIN ALI','','NADEEM','2003-11-07','Male','1','A+','MUSLIM','92313','92346-5165924','H KN 450 ST 2 LANE 4 RAWALPINDI','PUNJAB','Pakistan','146','','37201-3845128-5','19000','2021-09-28 18:35:14','2022-06-13 14:46:22');
INSERT INTO students VALUES('140','1','0','307','1','0','JAWAD MUSTAFA','','M MUSTAFA','2003-04-04','Male','0','A+','MUSLIM','92301-7893195','92346-2495191','91/EB ARIFWALA','PUNJAB','Pakistan','147','2','36401-9652987-1','10000','2021-09-28 18:38:21','2022-02-01 19:48:07');
INSERT INTO students VALUES('141','1','0','308','1','0','SHAHRUKH KHAN','','IMTIAZ ALI','2002-02-11','Male','1','A+','MUSLIM','92310-5446838','92315-5855120','H NO1832 ST 145 NEW ABADI SHAHEEN COLONY MADNI ST KAMRA','PUNJAB','Pakistan','148','2','42501-7849546-9','5000','2021-09-28 18:43:10','2021-09-28 18:43:10');
INSERT INTO students VALUES('142','1','0','309','1','0','ZAIN YAQOOB','','YAQOOB','2001-01-25','Male','1','A+','MUSLIM','92301-8179798','92315-5975262','KHUIRATTA KOTLI','KASHMIR','Pakistan','149','2','81202-2662255-9','6000','2021-09-29 18:45:08','2021-09-29 18:45:08');
INSERT INTO students VALUES('143','1','0','310','1','0','HAIDER TANOLI','','FAISAL TANOLI','1999-07-27','Male','1','A+','MUSLIM','92311-1785577','92334-5536750','BLOCK NO 2 MANSEHRA','KPK','Pakistan','150','2','13503-9579046-1','','2021-09-29 18:48:45','2021-09-29 18:48:45');
INSERT INTO students VALUES('144','1','0','311','1','0','M.YOUSAF','','HIDAYAT ULLAH','2004-12-05','Male','0','A+','MUSLIM','92324-0562580','92333-6823332','JABL-E-NOOR HOUSING SCHEME D.I.KHAN','PUNJAB','Pakistan','151','2','12101-9145873-1','17500','2021-09-29 19:22:48','2022-05-31 13:48:15');
INSERT INTO students VALUES('145','1','0','312','1','0','SAQIB','','ABDULL HANAN','1999-01-01','Male','1','A+','MUSLIM','92346-1357730','','TOWNSHIP MANSEHRA','KASMIR','Pakistan','152','2','13503-8142819-5','6000','2021-09-29 19:24:51','2021-10-08 16:11:00');
INSERT INTO students VALUES('146','1','0','313','1','0','AHMAD BIN WAHID','','FAIZ UR REHMAN','2000-03-15','Male','1','A+','MUSLIM','92344-4400165','92334-5536750','BAGH KARORA NEAR RAILWYSATION MALAKAND','KPK','Pakistan','153','2','16102-0816065-3','10000','2021-09-29 19:32:48','2021-10-09 21:44:36');
INSERT INTO students VALUES('147','1','0','314','1','0','HASSAN SARDAR','','SARDAR BAHADER','1999-05-12','Male','0','N/A','MUSLIM','92300-9595101','','MALA BABA CHAM RAPORY P/O LAHORE T&D SAWABI','KPK','Pakistan','154','2','16201-9769190-9','5000','2021-09-29 19:37:28','2021-10-13 16:18:53');
INSERT INTO students VALUES('148','1','0','315','1','0','SAJID FAIZ','','FAIZUREHMAN','2000-03-15','Male','0','N/A','MUSLIM','92344-4400165','92334-5536750','BAGH KORONA NEAR RAILWAY STATION MALAKAND','KPK','Pakistan','155','2','16102-0816065-3','21000+5000','2021-09-29 19:42:25','2022-05-07 16:05:55');
INSERT INTO students VALUES('149','1','0','316','1','0','M.UZAIR ALI','','MANZAR HUSSAIN','2001-11-25','Male','0','N/A','MUSLIM','92303','92300-7347613','J-10 DHA MULTAN','PUNJAB','Pakistan','156','','32203-0552538-5','10000','2021-09-29 19:46:15','2022-06-22 14:45:33');
INSERT INTO students VALUES('150','1','0','317','1','0','M.OWAIS','','M.YOUSAF','2001-02-14','Male','1','N/A','MUSLIM','92336-7386716','92305-3797323','H NO 1/200 MOH MARKAZI JAMIA MASJID LALAMUSA GUJRAT','PUNJAB','Pakistan','157','','34202-2508471-9','17000','2021-09-29 19:48:01','2021-10-11 17:31:42');
INSERT INTO students VALUES('151','1','0','318','1','0','ATHAR MUBARAK','','FGGDGDGD','2021-09-22','Male','0','','','925454545445','','','PUNJAB','Pakistan','158','','','','2021-09-29 20:01:53','2021-10-25 20:40:20');
INSERT INTO students VALUES('152','1','0','319','1','0','SAQLAIN MUSHTAQ','','MUSHTAQ','2003-06-11','Male','0','','MUSLIM','92317-0348718','92344-0333494','H NO 1 MOHALLA SACHAL COLONY LARKANA','SINDH','Pakistan','160','','43205-4262586-7','15000','2021-09-30 20:12:16','2022-04-28 16:29:53');
INSERT INTO students VALUES('153','1','0','320','1','0','ALI','','M.ASLAM','1999-08-16','Male','0','A+','MUSLIM','92348-8833480','92310-1532380','VPO PIND AZIZ TEH SARAI ALAMGIR DIST GUJRAT','PUNJAB','Pakistan','162','2','34203-9073593-7','13000','2021-10-01 16:06:42','2022-03-02 17:03:05');
INSERT INTO students VALUES('154','1','0','321','1','0','IDREES AHMED','','TAJ WALI KHAN','2002-09-11','Male','1','A+','MUSLIM','92347-9654793','','MOHALLA DORAN KHAIL P/O KHAS PARNOLI SAWABI','KPK','Pakistan','163','2','16204-0483737-5','17000','2021-10-01 18:04:41','2021-10-01 18:04:41');
INSERT INTO students VALUES('165','1','0','332','1','0','Qaswar','','MUQEEM','2005-05-02','Male','0','A+','MUSLIM','92315-5691111','92313-5691111','KOTLA MUGHLAN TEHSIL JAMPUR DISTRICT RAJNPUR','PUNJAB','Pakistan','182','2','32402-4232741-7','NIL','2021-11-11 19:00:37','2022-02-01 19:52:30');
INSERT INTO students VALUES('155','1','0','322','1','0','ABDULLAH','','SHERAZ KHAN','2002-07-01','Male','1','A+','MUSLIM','92317-5669991','92314-5555513','MOHALLA KHAN BAHADUR KHAN GARHI HABIBULLAH TEH BALAKOT DIS MANSEHRA','KPK','Pakistan','170','','13501-0725473-1','22000','2021-10-08 16:04:08','2021-10-10 21:21:31');
INSERT INTO students VALUES('156','1','0','323','1','0','HAMZA ALI','','SSAFSFS','2021-09-27','Male','0','','MUSLIM','92354545444','','','KPK','Pakistan','171','','','','2021-10-09 19:20:28','2022-02-01 20:12:02');
INSERT INTO students VALUES('157','1','0','324','1','0','AMEER HAMZA','','SHAHZADA KHAN','1996-03-29','Male','0','A+','MUSLIM','92331-5727145','','NEAR AFAQ HOTEL HARIPUR','KPK','Pakistan','172','','13302-1104190-3','','2021-10-09 19:21:55','2022-03-02 17:12:46');
INSERT INTO students VALUES('158','1','0','325','1','0','M.AYESH','','RUSTAM KHAN','2000-08-09','Male','1','A+','MUSLIM','92311-5862858','92343-8922022','MARI KHANKHAIL MANSEHRA','KPK','Pakistan','175','2','13503-5321222-7','22000','2021-10-10 21:25:08','2022-02-02 19:54:12');
INSERT INTO students VALUES('159','1','0','326','1','0','M.AMAAR','','RIAZ AHMAD','2000-01-03','Male','1','N/A','MUSLIM','92333-8314243','92313-6043078','DAJAL TEH JAMPUR DIST RAJANPUR','PUNJAB','Pakistan','176','','32402-0610134-5','17000','2021-10-13 16:23:18','2022-02-02 22:23:11');
INSERT INTO students VALUES('161','1','0','328','1','0','M.AFAN','','M.TAHIR','2001-10-15','Male','1','A+','MUSLIM','923347633126','923347633126','ZIARAT SHEIKH YOUSAF D I KHAN','PUNJAB','Pakistan','178','2','12101-2346165-5','10000','2021-11-02 20:05:00','2022-05-07 15:21:26');
INSERT INTO students VALUES('162','1','0','329','1','0','M.NOMAN','','JEHNZAIB','2003-11-16','Male','1','A+','MUSLIM','923339827388','923339827388','QURESHION WALA MOH DERA ISMAIL KHAN','PUNJAB','Pakistan','179','2','12101-9431858-5','10000','2021-11-02 20:09:26','2022-05-07 15:22:29');
INSERT INTO students VALUES('163','1','0','330','1','0','M.SALMAN','','M.ALAMZAIB','2003-11-17','Male','1','A+','MUSLIM','923349273355','923349273355/0313-9','QURESHION WALA MOH DERA ISMAIL KHAN','PUNJAB','Pakistan','180','2','12101-0304931-7','10000','2021-11-02 20:14:15','2022-05-07 15:20:30');
INSERT INTO students VALUES('164','1','0','331','1','0','ANEES UR REHMAN','','NAZAKAT UR REHMAN','2002-06-13','Male','1','A+','MUSLIM','92312','92311-5548201','H NO 660 SECTOR 3 KTS HARIPUR','KPK','Pakistan','181','2','13302-9818770-1','15500/6000 AC','2021-11-07 17:06:52','2022-06-13 14:47:20');
INSERT INTO students VALUES('166','1','0','333','1','0','M.SALMAN','','ABDUL RAZZAQ','1994-05-18','Male','0','A+','MUSLIM','92332-5615170','92321-5740918','H NO, 414 ARF COLONY PAC KAMRA DISTRICT ATTOCK','PUNJAB','Pakistan','183','','37101-4438889-1','15000','2022-02-01 21:00:39','2022-04-28 17:35:22');
INSERT INTO students VALUES('168','1','0','335','1','0','MEHSUM SHAHZAD','','TAHIR SHAHZAD','2001-03-13','Male','1','A+','MUSLIM','92317-1821235','92333-6227922','JATALA TOWN MIAN CHANNU','PUNJAB','Pakistan','185','2','36104-0690832-3','19000','2022-02-11 18:54:33','2022-02-11 18:54:33');
INSERT INTO students VALUES('169','1','0','336','1','0','ABDUL MOGHEES','','ALLAH DITTA','2002-07-01','Male','1','B+','MUSLIM','92346-3826759','92345-6929478','MOH SHAREEF PURA ST 9 MEERAN SAB ROAD GUJRAT','PUNJAB','Pakistan','186','','34201-8653223-5','17000','2022-02-13 18:47:45','2022-02-13 18:47:45');
INSERT INTO students VALUES('170','1','0','337','1','0','ABDUL MAJID','','ABDUL QAYUM','2003-04-17','Male','1','A+','MUSLIM','92336-4809943','92337-4636141','SHAIKH ELAHI COLNY GTR GUJRAT','PUNJAB','Pakistan','187','2','37105-69949976-7','15000','2022-03-05 21:08:32','2022-03-05 21:08:32');
INSERT INTO students VALUES('171','1','0','338','1','0','MOAZAM ALI','','ABU-UL-HASSAN','2001-09-23','Male','1','A+','MUSLIM','92314','92321-5402545','VILLAGE SHAMASPUR JEHLUM','PUNJAB','Pakistan','188','2','37301-9687486-9','19000/10000','2022-03-06 18:24:49','2022-06-13 14:50:47');
INSERT INTO students VALUES('172','1','0','339','1','0','MUDASAR ELAHI','','FATEH ELAHI','2022-02-28','Male','1','A+','MUSLIM','92333-5686337','92302-4355443','MADINA TOWN FAISALABAD','PUNJAB','Pakistan','189','2','33303-8286864-3','15000','2022-03-06 19:32:39','2022-03-06 19:32:39');
INSERT INTO students VALUES('173','1','0','340','1','0','SHAHEER AHMED','','WASEEM SHAHID','2000-05-21','Male','0','A+','MUSLIM','92332-7186039','92305-0006569','HOUSE NO 35 CANEL VIEW VEHARI','PUNJAB','Pakistan','190','2','36603-2689521-5','10000','2022-03-09 20:59:13','2022-04-28 16:47:08');
INSERT INTO students VALUES('174','1','0','341','1','0','SHOAIB BUKHARI','','TARIQ SHAH','1998-08-24','Male','1','A+','MUSLIM','92342','92344-7009161','22/A MODEL TOWN B GOC BWP','PUNJAB','Pakistan','191','2','31202-3741224-3','10000','2022-03-09 21:03:18','2022-04-20 15:45:27');
INSERT INTO students VALUES('175','1','0','342','1','0','AMEER HAMZA','','ALTAF HUSSAIN','2002-10-14','Male','1','A+','MUSLIM','92344-5008784','','BASTI KHARI SIANWAN MUZZAFFAR DIST MUZZAFFAR SARH TEHSIL KOT ADDU','PUNJAB','Pakistan','192','2','32303-9745827-1','15000','2022-03-09 22:22:51','2022-03-09 22:22:51');
INSERT INTO students VALUES('176','1','0','343','1','0','M.USAMA','','IRSHAD AHMED','2001-04-02','Male','1','A+','MUSLIM','92307-2281790','92300-3177208','KEHMAN COLONY 3RD STREET KHAN PUR','PUNJAB','Pakistan','193','2','31302-6703992-5','15500','2022-03-10 19:56:50','2022-03-10 19:56:50');
INSERT INTO students VALUES('177','1','0','344','1','0','MALIK SADAM','','M.YOUNIS','2002-03-16','Male','1','','MUSLIM','92349-6817330','92333-3364402','TATERWALA JAMPUR DIST RAJANPR','PUNJAB','Pakistan','194','2','32402-14333990-3','15500','2022-03-11 19:08:44','2022-03-11 19:08:44');
INSERT INTO students VALUES('178','1','0','345','1','0','NOUMAN SAQIB','','SAEED SAQIB','1999-07-23','Male','1','A+','MUSLIM','923102232609','923102232609','BUSINESS COLNY RAHIM YAR KHAN','PUNJAB','Pakistan','195','2','31304-2868249-7','','2022-03-11 19:55:23','2022-05-07 15:23:37');
INSERT INTO students VALUES('179','1','0','346','1','0','ARYAN KHAN','','INAM KHAN','1999-05-05','Male','1','A+','MUSLIM','92317-9775587','92300-5262807','GADAPUR COTTAGE MOHALLA BARAKHEL DERA ISMAIL KHAN','KPK','Pakistan','196','2','17301-3320681-7','19000','2022-04-02 10:55:13','2022-04-02 10:55:13');
INSERT INTO students VALUES('180','1','0','347','1','0','AFGHAN KHAN','','IKRAMULLAH KHAN','2002-04-26','Male','1','A+','MUSLIM','92311-8412645','92300-5262807','BANGALA NAAWAB SAHAB MOHALLA BARAKHAIL DERA ISMAIL KHAN','KPK','Pakistan','197','2','12102-2524036-1','19000','2022-04-02 10:59:46','2022-04-02 10:59:46');
INSERT INTO students VALUES('181','1','0','348','1','0','UBEDULLAH','','ASHQUE ALI','2001-03-15','Male','1','A+','MUSLIM','92300-0864644','92300-3476077','ADUL KATHERA SINDH PAKISTAN','SINDH','Pakistan','198','','43407-0472843-9','16000','2022-04-02 11:04:40','2022-04-02 11:04:40');
INSERT INTO students VALUES('182','1','0','349','1','0','M Imad','','M Naeem','1999-12-11','Male','1','A+','MUSLIM','923047911188','03047911188','Jewan city phase 5 house 136 sahiwal','punjab','Pakistan','19975464','2','36502-0803618-9','10000','2022-04-28 16:34:26','2022-05-11 15:55:04');
INSERT INTO students VALUES('183','1','0','350','1','0','M.IMRAN','','AMER NAWSHAD','1996-10-19','Male','1','A+','MUSLIM','923152528825','','','punjab','Pakistan','65765507','','42301-9561867-3','19000','2022-04-28 16:36:18','2022-05-08 16:47:46');
INSERT INTO students VALUES('184','1','0','351','1','0','M Ahmed','','Irfan Ahmed','2001-09-13','Male','1','B+','MUSLIM','923226433666','923131093000','2 Ahmed Pura Gujranwala','Punjab','Pakistan','37712460','2','34101-2701894-9','10000','2022-04-28 16:52:24','2022-05-10 16:54:41');
INSERT INTO students VALUES('185','1','0','352','1','0','M.ADIL','','M.RIAZ','1999-05-09','Male','1','B+','MUSLIM','923098221719','','41 A SATELLITE TOWN GUJARAWALA','PUNJAB','Pakistan','92305745','','34101-2476916-5','10000','2022-04-28 16:54:34','2022-05-08 17:40:23');
INSERT INTO students VALUES('186','1','0','353','1','0','UMAR FAROOQ','','BASHIR AHMED','2002-10-24','Male','1','','MUSLIM','923363039850','','DOHS KHARIAN CANTT TEH KHARIAN DISTT GUJRAT','PUNJAB','Pakistan','72096093','','34202-7298342-1','17500','2022-04-28 17:09:20','2022-05-31 13:47:35');
INSERT INTO students VALUES('187','1','0','354','1','0','M. JUNAID','','M.HUSSAIN','1999-11-14','Male','1','','','923374891399','923334414064','991 NIZAM BLOCK ALLAMA IQBAL TOWN LAHORE','PUNJAB','Pakistan','38192843','','35202-3432224-3','10000','2022-05-31 13:50:53','2022-06-01 14:19:25');
INSERT INTO students VALUES('188','1','0','355','1','0','M. BILAL ZAFAR','','ZAFAR IQBAL','2001-02-24','Male','1','','','923005449633','923338206687','BILAL MANZIL ST 47GHAKHR CITY GUJRAWALA','PUNJAB','Pakistan','90569003','','34104-3918504-7','10000','2022-05-31 13:53:11','2022-06-01 14:14:53');
INSERT INTO students VALUES('189','1','0','356','1','0','M. HUZAIFA','','MAZHAR IQBAL','2000-12-13','Male','1','','MUSLIM','923177129900','92333-8131416','ST, 3 RIGHT SIDE RATTA ROAD QASIM TOWN GUJRAWALA','PUNJAB','Pakistan','74846803','','34101-8380988-3','10000','2022-05-31 13:56:01','2022-06-01 14:11:33');
INSERT INTO students VALUES('190','1','0','357','1','0','M. UMAIR','','JAVAID IQBAL','1999-11-06','Male','1','N/A','MUSLIM','923000330466','','H, 23 ST , 7 JINNAH TOWN MIAN CHANNU','PUNJAB','Pakistan','19391406','','36104-2087421-9','10000','2022-05-31 13:57:20','2022-06-01 14:08:47');
INSERT INTO students VALUES('191','1','0','358','1','0','ABDUL HASEEB','','MAIN ATHAR ILAHI','1994-11-20','Male','1','','MUSLIM','923014709579','0483222557','H, 23 ST, ES-1 BLOCK Y SARGODHA','PUNJAB','Pakistan','5979450','1','38201-3993127-5','17000','2022-06-22 14:58:45','2022-06-22 14:58:45');
INSERT INTO students VALUES('192','1','0','359','1','0','HAMADULLAH','','FSFASD','2022-06-09','Male','1','','','923055456464','','','PUNJAB','Pakistan','71419377','','','','2022-06-22 15:01:05','2022-06-22 15:01:05');



DROP TABLE IF EXISTS subjects;

CREATE TABLE `subjects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `subject_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_id` int(11) NOT NULL,
  `full_mark` int(11) NOT NULL,
  `pass_mark` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS syllabus;

CREATE TABLE `syllabus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class_id` int(11) NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS teachers;

CREATE TABLE `teachers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `designation` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `birthday` date NOT NULL,
  `gender` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `religion` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `joining_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO teachers VALUES('1','1','281','M.SHAHBAZ','MANAGER','1996-01-25','Male','MUSLIM','923170000419','ISLAMABAD','2021-02-24','2021-08-04 18:54:40','2021-08-04 18:54:40');
INSERT INTO teachers VALUES('2','1','282','M.NASIR','COOK','2021-08-10','Male','MUSLIM','923009528624','LAHORE','2021-01-01','2021-08-04 18:56:56','2021-08-04 18:56:56');
INSERT INTO teachers VALUES('3','1','283','MATIUALLAH','COOK','1990-07-25','Male','MUSLIM','923411672629','HARIPUR','2021-01-01','2021-08-04 18:59:29','2021-08-04 18:59:29');
INSERT INTO teachers VALUES('4','1','284','MUZAMIL','QARI','1998-07-22','Male','MUSLIM','923117728227','VEHARI','2021-06-18','2021-08-04 19:02:21','2021-08-04 19:02:21');
INSERT INTO teachers VALUES('5','1','285','KHIZAR','COOK','1990-06-26','Male','MUSLIM','923497604118','HARIPUR','2021-07-01','2021-08-04 19:05:00','2021-08-04 19:05:00');
INSERT INTO teachers VALUES('6','1','286','IFTIKHAR','SWEEPER','1990-02-20','Male','NON MUSLIM','923035823453','ISLAMABAD','2021-01-11','2021-08-04 19:19:52','2021-08-04 19:19:52');
INSERT INTO teachers VALUES('7','1','287','SABAR','SWEEPER','1989-07-12','Male','NON MUSLIM','923412274725','RAWALPINDI','2021-06-22','2021-08-04 19:24:29','2021-08-04 19:24:29');



DROP TABLE IF EXISTS transactions;

CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `trans_date` date NOT NULL,
  `account_id` int(11) NOT NULL,
  `trans_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receipt_no` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `trans_source_type` enum('Income','Expense','Student','Teacher') COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `dr_cr` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `chart_id` int(11) NOT NULL,
  `payee_payer_id` int(11) DEFAULT NULL,
  `payment_method_id` int(11) DEFAULT NULL,
  `create_user_id` int(11) NOT NULL,
  `update_user_id` int(11) DEFAULT NULL,
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3385 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO transactions VALUES('1','1','2021-06-10','2','income','','143','Student','14000.00','cr','1','109','4','158','','','','','2021-06-20 20:50:45','2021-06-20 20:50:45');
INSERT INTO transactions VALUES('2','1','2021-06-10','2','income','','1','Student','6000.00','cr','1','109','4','158','','','','','2021-06-20 20:55:45','2021-06-20 20:55:45');
INSERT INTO transactions VALUES('3','1','2021-06-10','2','income','','144','Student','10000.00','cr','1','110','4','158','','','','','2021-06-20 21:07:42','2021-06-20 21:07:42');
INSERT INTO transactions VALUES('4','1','2021-06-10','2','income','','145','Student','13000.00','cr','1','111','4','158','','','','','2021-06-20 21:09:28','2021-06-20 21:09:28');
INSERT INTO transactions VALUES('5','1','2021-06-10','2','income','','2','Student','5000.00','cr','1','111','4','158','','','','','2021-06-20 21:10:07','2021-06-20 21:10:07');
INSERT INTO transactions VALUES('6','1','2021-06-10','2','income','','142','Student','14000.00','cr','1','108','4','158','','','','','2021-06-20 21:11:10','2021-06-20 21:11:10');
INSERT INTO transactions VALUES('7','1','2021-06-10','2','income','','4','Student','14000.00','cr','1','108','1','158','','','','','2021-06-20 21:11:45','2021-06-20 21:11:45');
INSERT INTO transactions VALUES('8','1','2021-06-10','2','income','','146','Student','13000.00','cr','1','112','4','158','','','','','2021-06-20 21:12:13','2021-06-20 21:12:13');
INSERT INTO transactions VALUES('9','1','2021-06-10','2','income','','141','Student','14000.00','cr','1','107','4','158','','','','','2021-06-20 21:13:10','2021-06-20 21:13:10');
INSERT INTO transactions VALUES('10','1','2021-06-10','2','income','','3','Student','5000.00','cr','1','107','4','158','','','','','2021-06-20 21:13:52','2021-06-20 21:13:52');
INSERT INTO transactions VALUES('11','1','2021-06-10','2','income','','137','Student','18000.00','cr','1','103','4','158','','','','','2021-06-20 21:15:59','2021-06-20 21:15:59');
INSERT INTO transactions VALUES('12','1','2021-06-10','2','income','','5','Student','2000.00','cr','1','103','4','158','','','','','2021-06-20 21:17:16','2021-06-20 21:17:16');
INSERT INTO transactions VALUES('13','1','2021-06-10','2','income','','138','Student','18000.00','cr','1','104','4','158','','','','','2021-06-20 21:18:06','2021-06-20 21:18:06');
INSERT INTO transactions VALUES('14','1','2021-06-10','2','income','','139','Student','16000.00','cr','1','105','4','158','','','','','2021-06-20 21:22:47','2021-06-20 21:22:47');
INSERT INTO transactions VALUES('15','1','2021-06-10','2','income','','6','Student','9000.00','cr','1','105','4','158','','','','','2021-06-20 21:23:56','2021-06-20 21:23:56');
INSERT INTO transactions VALUES('16','1','2021-06-10','2','income','','140','Student','16500.00','cr','1','106','4','158','','','','','2021-06-20 21:25:13','2021-06-20 21:25:13');
INSERT INTO transactions VALUES('17','1','2021-06-10','2','income','','7','Student','10000.00','cr','1','106','4','158','','','','','2021-06-20 21:26:06','2021-06-20 21:26:06');
INSERT INTO transactions VALUES('18','1','2021-06-10','2','income','','147','Student','16000.00','cr','1','102','4','158','','','','','2021-06-20 21:37:07','2021-06-20 21:37:07');
INSERT INTO transactions VALUES('19','1','2021-06-10','2','income','','147','Student','3000.00','cr','4','102','4','158','','','','','2021-06-20 21:38:08','2021-06-20 21:38:08');
INSERT INTO transactions VALUES('20','1','2021-06-10','2','income','','136','Student','16000.00','cr','1','101','4','158','','','','','2021-06-20 21:39:22','2021-06-20 21:39:22');
INSERT INTO transactions VALUES('21','1','2021-06-10','2','income','','135','Student','16000.00','cr','1','100','4','158','','','','','2021-06-20 21:40:08','2021-06-20 21:40:08');
INSERT INTO transactions VALUES('23','1','2021-06-10','2','income','','134','Student','16000.00','cr','1','99','4','158','','','','','2021-06-21 18:01:27','2021-06-21 18:01:27');
INSERT INTO transactions VALUES('24','1','2021-06-10','2','income','','133','Student','8500.00','cr','1','98','1','158','','','','','2021-06-21 18:04:08','2021-06-21 18:04:08');
INSERT INTO transactions VALUES('25','1','2021-06-10','2','income','','132','Student','18000.00','cr','1','97','4','158','','','','','2021-06-21 18:05:03','2021-06-21 18:05:03');
INSERT INTO transactions VALUES('26','1','2021-06-10','2','income','','131','Student','16500.00','cr','1','96','4','158','','','','','2021-06-21 18:06:00','2021-06-21 18:06:00');
INSERT INTO transactions VALUES('27','1','2021-06-10','2','income','','127','Student','13000.00','cr','1','92','4','158','','','','','2021-06-21 18:07:05','2021-06-21 18:07:05');
INSERT INTO transactions VALUES('28','1','2021-06-10','2','income','','128','Student','7000.00','cr','1','93','4','158','','','','','2021-06-21 18:07:51','2021-06-21 18:07:51');
INSERT INTO transactions VALUES('29','1','2021-06-10','2','income','','129','Student','13000.00','cr','1','94','4','158','','','','','2021-06-21 18:09:19','2021-06-21 18:09:19');
INSERT INTO transactions VALUES('30','1','2021-06-10','2','income','','130','Student','13000.00','cr','1','95','4','158','','','','','2021-06-21 18:10:32','2021-06-21 18:10:32');
INSERT INTO transactions VALUES('31','1','2021-06-10','2','income','','39','Student','13000.00','cr','1','4','1','158','','','','','2021-06-21 18:15:09','2021-06-21 18:15:09');
INSERT INTO transactions VALUES('32','1','2021-06-10','2','income','','39','Student','5000.00','cr','3','4','4','158','','','','','2021-06-21 18:16:13','2021-06-21 18:16:13');
INSERT INTO transactions VALUES('33','1','2021-06-10','2','income','','126','Student','16000.00','cr','1','91','4','158','','','','','2021-06-21 18:21:23','2021-06-21 18:21:23');
INSERT INTO transactions VALUES('34','1','2021-06-10','2','income','','126','Student','12000.00','cr','3','91','4','158','','','','','2021-06-21 18:22:02','2021-06-21 18:22:02');
INSERT INTO transactions VALUES('35','1','2021-06-10','2','income','','36','Student','7500.00','cr','1','1','4','158','','','','','2021-06-21 18:23:36','2021-06-21 18:23:36');
INSERT INTO transactions VALUES('36','1','2021-06-10','2','income','','36','Student','5000.00','cr','3','1','4','158','','','','','2021-06-21 18:24:17','2021-06-21 18:24:17');
INSERT INTO transactions VALUES('37','1','2021-06-10','2','income','','125','Student','14500.00','cr','1','90','4','158','','','','','2021-06-21 18:38:09','2021-06-21 18:38:09');
INSERT INTO transactions VALUES('38','1','2021-06-10','2','income','','9','Student','7250.00','cr','2','90','4','158','','','','','2021-06-21 18:38:54','2021-06-21 18:38:54');
INSERT INTO transactions VALUES('39','1','2021-06-10','2','income','','123','Student','14500.00','cr','1','88','4','158','','','','','2021-06-21 18:39:33','2021-06-21 18:39:33');
INSERT INTO transactions VALUES('40','1','2021-06-10','2','income','','124','Student','10000.00','cr','1','89','4','158','','','','','2021-06-21 18:40:30','2021-06-21 18:40:30');
INSERT INTO transactions VALUES('41','1','2021-06-10','2','income','','38','Student','14500.00','cr','1','3','4','158','','','','','2021-06-21 19:01:05','2021-06-21 19:01:05');
INSERT INTO transactions VALUES('42','1','2021-06-10','2','income','','38','Student','10000.00','cr','3','3','4','158','','','','','2021-06-21 19:39:54','2021-06-21 19:39:54');
INSERT INTO transactions VALUES('43','1','2021-06-10','2','income','','133','Student','9500.00','cr','1','98','4','158','','','','','2021-06-21 19:41:34','2021-06-21 19:41:34');
INSERT INTO transactions VALUES('44','1','2021-06-10','2','income','','119','Student','14000.00','cr','1','84','4','158','','','','','2021-06-21 19:43:31','2021-06-21 19:43:31');
INSERT INTO transactions VALUES('45','1','2021-06-10','2','income','','120','Student','14000.00','cr','1','85','4','158','','','','','2021-06-21 19:45:43','2021-06-21 19:45:43');
INSERT INTO transactions VALUES('46','1','2021-06-10','2','income','','121','Student','14000.00','cr','1','86','4','158','','','','','2021-06-21 19:46:49','2021-06-21 19:46:49');
INSERT INTO transactions VALUES('47','1','2021-06-10','2','income','','122','Student','14000.00','cr','1','87','4','158','','','','','2021-06-21 19:47:37','2021-06-21 19:47:37');
INSERT INTO transactions VALUES('48','1','2021-06-10','2','income','','148','Student','16500.00','cr','1','81','4','158','','','','','2021-06-21 19:53:03','2021-06-21 19:53:03');
INSERT INTO transactions VALUES('49','1','2021-06-10','2','income','','148','Student','10000.00','cr','3','81','4','158','','','','','2021-06-21 19:53:55','2021-06-21 19:53:55');
INSERT INTO transactions VALUES('50','1','2021-06-10','2','income','','118','Student','16500.00','cr','1','83','4','158','','','','','2021-06-21 19:55:19','2021-06-21 19:55:19');
INSERT INTO transactions VALUES('51','1','2021-06-10','2','income','','117','Student','16500.00','cr','1','82','4','158','','','','','2021-06-21 19:55:54','2021-06-21 19:55:54');
INSERT INTO transactions VALUES('52','1','2021-06-10','2','income','','116','Student','16500.00','cr','1','81','4','158','','','','','2021-06-21 19:56:50','2021-06-21 19:56:50');
INSERT INTO transactions VALUES('53','1','2021-06-10','2','income','','113','Student','16000.00','cr','1','78','4','158','','','','','2021-06-21 19:57:52','2021-06-21 19:57:52');
INSERT INTO transactions VALUES('54','1','2021-06-10','2','income','','114','Student','16000.00','cr','1','79','4','158','','','','','2021-06-21 19:58:43','2021-06-21 19:58:43');
INSERT INTO transactions VALUES('55','1','2021-06-10','2','income','','115','Student','16900.00','cr','1','80','4','158','','','','','2021-06-21 20:01:08','2021-06-21 20:01:08');
INSERT INTO transactions VALUES('56','1','2021-06-10','2','income','','84','Student','16500.00','cr','1','49','4','158','','','','','2021-06-21 20:03:39','2021-06-21 20:03:39');
INSERT INTO transactions VALUES('57','1','2021-06-10','2','income','','111','Student','13000.00','cr','1','76','4','158','','','','','2021-06-21 20:04:48','2021-06-21 20:04:48');
INSERT INTO transactions VALUES('58','1','2021-06-10','2','income','','12','Student','2000.00','cr','1','76','4','158','','','','','2021-06-21 20:05:29','2021-06-21 20:05:29');
INSERT INTO transactions VALUES('59','1','2021-06-10','2','income','','112','Student','13000.00','cr','1','77','4','158','','','','','2021-06-21 20:06:06','2021-06-21 20:06:06');
INSERT INTO transactions VALUES('60','1','2021-06-10','2','income','','109','Student','16900.00','cr','1','71','4','158','','','','','2021-06-21 20:08:09','2021-06-21 20:08:09');
INSERT INTO transactions VALUES('61','1','2021-06-10','2','income','','108','Student','16500.00','cr','1','73','4','158','','','','','2021-06-21 20:08:42','2021-06-21 20:08:42');
INSERT INTO transactions VALUES('62','1','2021-06-10','2','income','','107','Student','16500.00','cr','1','72','4','158','','','','','2021-06-21 20:09:13','2021-06-21 20:09:13');
INSERT INTO transactions VALUES('63','1','2021-06-10','2','income','','106','Student','16500.00','cr','1','71','4','158','','','','','2021-06-21 20:09:38','2021-06-21 20:09:38');
INSERT INTO transactions VALUES('64','1','2021-06-10','2','income','','103','Student','15000.00','cr','1','68','4','158','','','','','2021-06-21 20:10:49','2021-06-21 20:10:49');
INSERT INTO transactions VALUES('65','1','2021-06-10','2','income','','14','Student','1000.00','cr','1','68','4','158','','','','','2021-06-21 20:11:14','2021-06-21 20:11:14');
INSERT INTO transactions VALUES('66','1','2021-06-10','2','income','','105','Student','17000.00','cr','1','70','4','158','','','','','2021-06-21 20:13:58','2021-06-21 20:13:58');
INSERT INTO transactions VALUES('67','1','2021-06-10','2','income','','83','Student','17000.00','cr','1','48','4','158','','','','','2021-06-21 20:15:04','2021-06-21 20:15:04');
INSERT INTO transactions VALUES('68','1','2021-06-10','2','income','','104','Student','16970.00','cr','1','48','4','158','','','','','2021-06-21 20:16:07','2021-06-21 20:16:07');
INSERT INTO transactions VALUES('69','1','2021-06-10','2','income','','93','Student','16500.00','cr','1','58','4','158','','','','','2021-06-21 20:31:45','2021-06-21 20:31:45');
INSERT INTO transactions VALUES('70','1','2021-06-10','2','income','','15','Student','8000.00','cr','1','58','4','158','','','','','2021-06-21 20:32:19','2021-06-21 20:32:19');
INSERT INTO transactions VALUES('71','1','2021-06-10','2','income','','102','Student','16000.00','cr','1','67','4','158','','','','','2021-06-21 20:33:40','2021-06-21 20:33:40');
INSERT INTO transactions VALUES('72','1','2021-06-10','2','income','','101','Student','16500.00','cr','1','66','4','158','','','','','2021-06-25 17:27:26','2021-06-25 17:27:26');
INSERT INTO transactions VALUES('73','1','2021-06-10','2','income','','100','Student','16000.00','cr','1','65','4','158','','','','','2021-06-25 17:28:27','2021-06-25 17:28:27');
INSERT INTO transactions VALUES('74','1','2021-06-10','2','income','','99','Student','21000.00','cr','1','64','4','158','','','','','2021-06-25 17:30:38','2021-06-25 17:30:38');
INSERT INTO transactions VALUES('75','1','2021-06-10','2','income','','98','Student','23000.00','cr','1','63','4','158','','','','','2021-06-25 17:31:17','2021-06-25 17:31:17');
INSERT INTO transactions VALUES('76','1','2021-06-10','2','income','','92','Student','17000.00','cr','1','57','4','158','','','','','2021-06-25 17:33:36','2021-06-25 17:33:36');
INSERT INTO transactions VALUES('77','1','2021-06-10','2','income','','91','Student','16500.00','cr','1','56','4','158','','','','','2021-06-25 17:38:11','2021-06-25 17:38:11');
INSERT INTO transactions VALUES('78','1','2021-06-10','2','income','','44','Student','35000.00','cr','1','9','4','158','','','','','2021-06-25 17:39:32','2021-06-25 17:39:32');
INSERT INTO transactions VALUES('79','1','2021-06-10','2','income','','94','Student','17000.00','cr','1','59','4','158','','','','','2021-06-25 17:40:34','2021-06-25 17:40:34');
INSERT INTO transactions VALUES('80','1','2021-06-10','2','income','','17','Student','1000.00','cr','1','59','4','158','','','','','2021-06-25 17:41:08','2021-06-25 17:41:08');
INSERT INTO transactions VALUES('81','1','2021-06-10','2','income','','90','Student','16000.00','cr','1','55','4','158','','','','','2021-06-25 17:41:39','2021-06-25 17:41:39');
INSERT INTO transactions VALUES('82','1','2021-06-10','2','income','','97','Student','12000.00','cr','1','62','4','158','','','','','2021-06-25 17:42:13','2021-06-25 17:42:13');
INSERT INTO transactions VALUES('83','1','2021-06-10','2','income','','96','Student','12000.00','cr','1','61','4','158','','','','','2021-06-25 17:42:39','2021-06-25 17:42:39');
INSERT INTO transactions VALUES('84','1','2021-06-10','2','income','','95','Student','12000.00','cr','1','60','4','158','','','','','2021-06-25 17:43:06','2021-06-25 17:43:06');
INSERT INTO transactions VALUES('85','1','2021-06-10','2','income','','89','Student','15000.00','cr','1','54','4','158','','','','','2021-06-25 17:43:54','2021-06-25 17:43:54');
INSERT INTO transactions VALUES('86','1','2021-06-10','2','income','','37','Student','17200.00','cr','1','2','4','158','','','','','2021-06-25 17:46:13','2021-06-25 17:46:13');
INSERT INTO transactions VALUES('87','1','2021-06-10','2','income','','88','Student','16500.00','cr','1','53','4','158','','','','','2021-06-25 17:48:10','2021-06-25 17:48:10');
INSERT INTO transactions VALUES('88','1','2021-06-10','2','income','','87','Student','16500.00','cr','1','52','4','158','','','','','2021-06-25 17:48:38','2021-06-25 17:48:38');
INSERT INTO transactions VALUES('89','1','2021-06-10','2','income','','86','Student','17830.00','cr','1','51','4','158','','','','','2021-06-25 17:49:03','2021-06-25 17:49:03');
INSERT INTO transactions VALUES('90','1','2021-06-10','2','income','','85','Student','16500.00','cr','1','50','4','158','','','','','2021-06-25 17:49:26','2021-06-25 17:49:26');
INSERT INTO transactions VALUES('91','1','2021-06-10','2','income','','79','Student','16000.00','cr','1','44','4','158','','','','','2021-06-25 17:56:08','2021-06-25 17:56:08');
INSERT INTO transactions VALUES('92','1','2021-06-10','2','income','','82','Student','16000.00','cr','1','47','4','158','','','','','2021-06-25 17:57:37','2021-06-25 17:57:37');
INSERT INTO transactions VALUES('93','1','2021-06-10','2','income','','81','Student','16000.00','cr','1','46','4','158','','','','','2021-06-25 17:58:04','2021-06-25 17:58:04');
INSERT INTO transactions VALUES('94','1','2021-06-10','2','income','','80','Student','16000.00','cr','1','45','4','158','','','','','2021-06-25 17:58:51','2021-06-25 17:58:51');
INSERT INTO transactions VALUES('95','1','2021-06-10','2','income','','22','Student','6000.00','cr','1','45','4','158','','','','','2021-06-25 17:59:26','2021-06-25 17:59:26');
INSERT INTO transactions VALUES('96','1','2021-06-10','2','income','','77','Student','15000.00','cr','1','42','4','158','','','','','2021-06-25 18:00:11','2021-06-25 18:00:11');
INSERT INTO transactions VALUES('97','1','2021-06-10','2','income','','76','Student','15000.00','cr','1','41','4','158','','','','','2021-06-25 18:00:46','2021-06-25 18:00:46');
INSERT INTO transactions VALUES('98','1','2021-06-10','2','income','','75','Student','12000.00','cr','1','40','4','158','','','','','2021-06-25 18:01:20','2021-06-25 18:01:20');
INSERT INTO transactions VALUES('99','1','2021-06-10','2','income','','74','Student','12000.00','cr','1','39','4','158','','','','','2021-06-25 18:01:46','2021-06-25 18:01:46');
INSERT INTO transactions VALUES('100','1','2021-06-10','2','income','','70','Student','14500.00','cr','1','35','4','158','','','','','2021-06-25 18:05:19','2021-06-25 18:05:19');
INSERT INTO transactions VALUES('101','1','2021-06-10','2','income','','72','Student','17500.00','cr','1','37','4','158','','','','','2021-06-25 18:05:53','2021-06-25 18:05:53');
INSERT INTO transactions VALUES('102','1','2021-06-10','2','income','','71','Student','17500.00','cr','1','36','4','158','','','','','2021-06-25 18:06:18','2021-06-25 18:06:18');
INSERT INTO transactions VALUES('103','1','2021-06-10','2','income','','69','Student','14500.00','cr','1','34','4','158','','','','','2021-06-25 18:06:50','2021-06-25 18:06:50');
INSERT INTO transactions VALUES('104','1','2021-06-10','2','income','','68','Student','13500.00','cr','1','33','4','158','','','','','2021-06-25 18:07:25','2021-06-25 18:07:25');
INSERT INTO transactions VALUES('105','1','2021-06-10','2','income','','66','Student','13000.00','cr','1','31','4','158','','','','','2021-06-25 18:08:20','2021-06-25 18:08:20');
INSERT INTO transactions VALUES('106','1','2021-06-10','2','income','','23','Student','3500.00','cr','1','31','4','158','','','','','2021-06-25 18:09:05','2021-06-25 18:09:05');
INSERT INTO transactions VALUES('107','1','2021-06-10','2','income','','65','Student','13000.00','cr','1','30','4','158','','','','','2021-06-25 18:09:50','2021-06-25 18:09:50');
INSERT INTO transactions VALUES('108','1','2021-06-10','2','income','','24','Student','2750.00','cr','1','30','4','158','','','','','2021-06-25 18:10:35','2021-06-25 18:10:35');
INSERT INTO transactions VALUES('109','1','2021-06-10','2','income','','40','Student','23000.00','cr','1','5','4','158','','','','','2021-06-25 18:12:58','2021-06-25 18:12:58');
INSERT INTO transactions VALUES('110','1','2021-06-10','2','income','','56','Student','13000.00','cr','1','21','4','158','','','','','2021-06-25 18:14:20','2021-06-25 18:14:20');
INSERT INTO transactions VALUES('111','1','2021-06-10','2','income','','25','Student','7250.00','cr','1','21','4','158','','','','','2021-06-25 18:14:56','2021-06-25 18:14:56');
INSERT INTO transactions VALUES('112','1','2021-06-10','2','income','','41','Student','23000.00','cr','1','6','4','158','','','','','2021-06-25 18:23:16','2021-06-25 18:23:16');
INSERT INTO transactions VALUES('113','1','2021-06-10','2','income','','67','Student','23000.00','cr','1','32','4','158','','','','','2021-06-25 18:25:29','2021-06-25 18:25:29');
INSERT INTO transactions VALUES('114','1','2021-06-10','2','income','','60','Student','18000.00','cr','1','25','4','158','','','','','2021-06-25 18:38:50','2021-06-25 18:38:50');
INSERT INTO transactions VALUES('115','1','2021-06-10','2','income','','62','Student','18000.00','cr','1','27','4','158','','','','','2021-06-25 18:39:18','2021-06-25 18:39:18');
INSERT INTO transactions VALUES('116','1','2021-06-10','2','income','','52','Student','16000.00','cr','1','17','4','158','','','','','2021-06-25 18:40:00','2021-06-25 18:40:00');
INSERT INTO transactions VALUES('117','1','2021-06-10','2','income','','54','Student','16000.00','cr','1','19','4','158','','','','','2021-06-25 18:40:31','2021-06-25 18:40:31');
INSERT INTO transactions VALUES('118','1','2021-06-10','2','income','','53','Student','16000.00','cr','1','18','4','158','','','','','2021-06-25 18:41:00','2021-06-25 18:41:00');
INSERT INTO transactions VALUES('119','1','2021-06-10','2','income','','55','Student','6000.00','cr','1','20','4','158','','','','','2021-06-25 18:41:43','2021-06-25 18:41:43');
INSERT INTO transactions VALUES('120','1','2021-06-10','2','income','','27','Student','1000.00','cr','1','19','4','158','','','','','2021-06-25 18:42:58','2021-06-25 18:42:58');
INSERT INTO transactions VALUES('121','1','2021-06-10','2','income','','64','Student','19000.00','cr','1','29','4','158','','','','','2021-06-25 18:44:07','2021-06-25 18:44:07');
INSERT INTO transactions VALUES('122','1','2021-06-10','2','income','','63','Student','19000.00','cr','1','28','4','158','','','','','2021-06-25 18:44:36','2021-06-25 18:44:36');
INSERT INTO transactions VALUES('123','1','2021-06-10','2','income','','51','Student','19000.00','cr','1','16','4','158','','','','','2021-06-25 18:44:59','2021-06-25 18:44:59');
INSERT INTO transactions VALUES('124','1','2021-06-10','2','income','','29','Student','9500.00','cr','1','16','4','158','','','','','2021-06-25 18:45:24','2021-06-25 18:45:24');
INSERT INTO transactions VALUES('125','1','2021-06-10','2','income','','57','Student','17000.00','cr','1','22','4','158','','','','','2021-06-25 18:46:27','2021-06-25 18:46:27');
INSERT INTO transactions VALUES('126','1','2021-06-10','2','income','','59','Student','12500.00','cr','1','24','4','158','','','','','2021-06-25 18:47:06','2021-06-25 18:47:06');
INSERT INTO transactions VALUES('127','1','2021-06-10','2','income','','58','Student','12500.00','cr','1','23','4','158','','','','','2021-06-25 18:47:29','2021-06-25 18:47:29');
INSERT INTO transactions VALUES('128','1','2021-06-10','2','income','','49','Student','32220.00','cr','1','14','4','158','','','','','2021-06-25 18:49:52','2021-06-25 18:49:52');
INSERT INTO transactions VALUES('129','1','2021-06-10','2','income','','31','Student','31000.00','cr','1','14','4','158','','','','','2021-06-25 18:51:37','2021-06-25 18:51:37');
INSERT INTO transactions VALUES('130','1','2021-06-10','2','income','','47','Student','8500.00','cr','1','12','4','158','','','','','2021-06-25 18:53:14','2021-06-25 18:53:14');
INSERT INTO transactions VALUES('131','1','2021-06-10','2','income','','48','Student','12000.00','cr','1','13','4','158','','','','','2021-06-25 18:53:50','2021-06-25 18:53:50');
INSERT INTO transactions VALUES('132','1','2021-06-10','2','income','','33','Student','5000.00','cr','1','13','4','158','','','','','2021-06-25 18:54:18','2021-06-25 18:54:18');
INSERT INTO transactions VALUES('133','1','2021-06-10','2','income','','46','Student','21000.00','cr','1','11','4','158','','','','','2021-06-25 18:54:45','2021-06-25 18:54:45');
INSERT INTO transactions VALUES('134','1','2021-06-10','2','income','','45','Student','21000.00','cr','1','10','4','158','','','','','2021-06-25 18:55:10','2021-06-25 18:55:10');
INSERT INTO transactions VALUES('135','1','2021-06-10','2','income','','50','Student','18000.00','cr','1','15','4','158','','','','','2021-06-25 18:56:12','2021-06-25 18:56:12');
INSERT INTO transactions VALUES('136','1','2021-06-10','2','income','','43','Student','21500.00','cr','1','8','4','158','','','','','2021-06-25 19:09:10','2021-06-25 19:09:10');
INSERT INTO transactions VALUES('137','1','2021-06-10','2','income','','42','Student','21500.00','cr','1','7','4','158','','','','','2021-06-25 19:09:45','2021-06-25 19:09:45');
INSERT INTO transactions VALUES('138','1','2021-06-08','2','expense','','','Income','570000.00','dr','11','','4','158','','ABID SB','','','2021-06-25 19:52:26','2021-06-25 19:52:26');
INSERT INTO transactions VALUES('154','1','2021-06-30','2','expense','','','Income','13810.00','dr','8','','4','158','','','','','2021-06-30 22:46:03','2021-06-30 22:46:03');
INSERT INTO transactions VALUES('153','1','2021-06-30','2','expense','','','Income','238531.00','dr','6','','4','158','','','','','2021-06-30 22:45:35','2021-06-30 22:45:35');
INSERT INTO transactions VALUES('141','1','2021-06-24','2','expense','','','Income','8320.00','dr','7','','4','158','','','','PAY SHAHBAZ','2021-06-25 20:15:18','2021-06-25 20:15:18');
INSERT INTO transactions VALUES('142','1','2021-06-24','2','expense','','','Income','120640.00','dr','9','','4','158','','','','PAY SHAHBAZ','2021-06-25 20:35:51','2021-06-25 20:35:51');
INSERT INTO transactions VALUES('143','1','2021-06-24','2','expense','','','Income','17000.00','dr','12','','4','158','','SECURITY REFUND','','PAY SHAHBAZ','2021-06-25 20:37:12','2021-06-25 20:37:12');
INSERT INTO transactions VALUES('147','1','2021-06-24','2','expense','','','Income','91835.00','dr','7','','4','158','','ELE BILL','','PAY USAMA SB','2021-06-25 21:22:29','2021-06-25 21:22:29');
INSERT INTO transactions VALUES('148','1','2021-06-24','2','expense','','','Income','132253.00','dr','7','','4','158','','ELE BILL','','PAY USAMA','2021-06-25 21:23:14','2021-06-25 21:23:14');
INSERT INTO transactions VALUES('149','1','2021-06-28','2','income','','35','Student','10000.00','cr','1','11','4','158','','','','','2021-06-28 20:04:49','2021-06-28 20:04:49');
INSERT INTO transactions VALUES('150','1','2021-06-28','2','income','','34','Student','10000.00','cr','1','10','4','158','','','','','2021-06-28 20:05:10','2021-06-28 20:05:10');
INSERT INTO transactions VALUES('151','1','2021-06-26','2','income','','61','Student','18000.00','cr','1','26','4','158','','','','','2021-06-28 20:42:26','2021-06-28 20:42:26');
INSERT INTO transactions VALUES('152','1','2021-06-28','2','income','','149','Student','8500.00','cr','1','114','4','158','','','','','2021-06-28 20:58:50','2021-06-28 20:58:50');
INSERT INTO transactions VALUES('155','1','2021-06-30','2','expense','','','Income','149500.00','dr','12','','4','158','','','','','2021-06-30 22:48:43','2021-06-30 22:48:43');
INSERT INTO transactions VALUES('156','1','2021-06-30','2','income','','73','Student','12000.00','cr','1','38','4','158','','','','','2021-06-30 22:53:13','2021-06-30 22:53:13');
INSERT INTO transactions VALUES('157','1','2021-06-30','2','income','','150','Student','4000.00','cr','1','116','4','158','','','','','2021-06-30 23:14:32','2021-06-30 23:14:32');
INSERT INTO transactions VALUES('158','1','2021-07-01','2','income','','227','Student','13000.00','cr','1','77','4','158','','','','m/o july','2021-07-02 16:37:07','2021-07-02 16:37:07');
INSERT INTO transactions VALUES('159','1','2021-07-02','2','income','','249','Student','16000.00','cr','1','99','4','158','','','','M/O JULY','2021-07-02 16:41:53','2021-07-02 16:41:53');
INSERT INTO transactions VALUES('160','1','2021-07-03','2','income','','250','Student','16140.00','cr','1','100','4','158','','','','16000+140=16140','2021-07-03 16:03:14','2021-07-03 16:03:14');
INSERT INTO transactions VALUES('161','1','2021-07-02','3','income','','264','Student','20000.00','cr','1','114','1','158','','','','ACCOUNT DEPOSIT
SEC TOTAL 10000','2021-07-03 16:10:26','2021-07-03 16:10:26');
INSERT INTO transactions VALUES('162','1','2021-06-29','2','income','','43','Student','5000.00','cr','1','8','4','158','','','','ADJUSTMENT 
SEC REFUND
10000','2021-07-03 16:25:17','2021-07-03 16:25:17');
INSERT INTO transactions VALUES('163','1','2021-06-28','2','income','','42','Student','5000.00','cr','1','7','4','158','','','','ADJUSTMENT
SEC REFUND 10000
TALK USMA SAB','2021-07-03 16:26:51','2021-07-03 16:26:51');
INSERT INTO transactions VALUES('164','1','2021-07-03','2','income','','158','Student','14000.00','cr','1','6','4','158','','','','','2021-07-03 16:41:14','2021-07-03 16:41:14');
INSERT INTO transactions VALUES('165','1','2021-07-03','2','income','','256','Student','6500.00','cr','1','106','4','158','','','','sec adjustment 10000','2021-07-03 18:49:55','2021-07-03 18:49:55');
INSERT INTO transactions VALUES('166','1','2021-07-03','2','income','','267','Student','16500.00','cr','1','118','4','158','','','','','2021-07-03 19:43:06','2021-07-03 19:43:06');
INSERT INTO transactions VALUES('167','1','2021-07-03','2','income','','266','Student','16500.00','cr','1','117','4','158','','','','','2021-07-03 19:43:34','2021-07-03 19:43:34');
INSERT INTO transactions VALUES('168','1','2021-07-03','2','income','','204','Student','15000.00','cr','1','54','4','158','','','','','2021-07-03 19:49:31','2021-07-03 19:49:31');
INSERT INTO transactions VALUES('169','1','2021-07-03','2','income','','229','Student','16000.00','cr','1','79','4','158','','','','','2021-07-03 20:33:59','2021-07-03 20:33:59');
INSERT INTO transactions VALUES('170','1','2021-07-03','2','income','','192','Student','15000.00','cr','1','42','4','158','','','','','2021-07-03 20:58:41','2021-07-03 20:58:41');
INSERT INTO transactions VALUES('171','1','2021-07-05','2','income','','201','Student','16500.00','cr','1','51','4','158','','','','','2021-07-05 19:18:16','2021-07-05 19:18:16');
INSERT INTO transactions VALUES('172','1','2021-07-05','2','income','','260','Student','14000.00','cr','1','110','4','158','','','','','2021-07-05 19:24:24','2021-07-05 19:24:24');
INSERT INTO transactions VALUES('173','1','2021-07-05','2','income','','144','Student','4000.00','cr','1','110','4','158','','','','','2021-07-05 19:25:14','2021-07-05 19:25:14');
INSERT INTO transactions VALUES('174','1','2021-07-05','2','income','','171','Student','14000.00','cr','1','21','4','158','','','','','2021-07-05 19:59:20','2021-07-05 19:59:20');
INSERT INTO transactions VALUES('175','1','2021-07-05','2','income','','185','Student','15500.00','cr','1','35','4','158','','','','','2021-07-05 20:03:21','2021-07-05 20:03:21');
INSERT INTO transactions VALUES('176','1','2021-07-05','2','income','','219','Student','17320.00','cr','1','69','4','158','','','','','2021-07-05 20:43:01','2021-07-05 20:43:01');
INSERT INTO transactions VALUES('177','1','2021-07-05','2','income','','248','Student','17000.00','cr','1','98','4','158','','','','','2021-07-05 20:43:46','2021-07-05 20:43:46');
INSERT INTO transactions VALUES('178','1','2021-07-05','2','income','','153','Student','15500.00','cr','1','1','4','158','','','','','2021-07-05 20:49:56','2021-07-05 20:49:56');
INSERT INTO transactions VALUES('179','1','2021-07-05','3','income','','221','Student','17560.00','cr','1','71','1','158','','','','','2021-07-05 20:59:08','2021-07-05 20:59:08');
INSERT INTO transactions VALUES('180','1','2021-07-05','2','income','','23','Student','3750.00','cr','1','31','4','158','','','','','2021-07-05 21:43:23','2021-07-05 21:43:23');
INSERT INTO transactions VALUES('181','1','2021-07-05','2','income','','181','Student','14000.00','cr','1','31','4','158','','','','','2021-07-05 21:47:43','2021-07-05 21:47:43');
INSERT INTO transactions VALUES('182','1','2021-07-06','2','income','','187','Student','15400.00','cr','1','37','4','158','','','','','2021-07-06 19:14:44','2021-07-06 19:14:44');
INSERT INTO transactions VALUES('183','1','2021-07-06','2','income','','186','Student','15400.00','cr','1','36','4','158','','','','','2021-07-06 19:15:20','2021-07-06 19:15:20');
INSERT INTO transactions VALUES('184','1','2021-07-06','2','income','','16','Student','1000.00','cr','1','67','4','158','','','','','2021-07-06 19:18:11','2021-07-06 19:18:11');
INSERT INTO transactions VALUES('185','1','2021-07-06','2','income','','217','Student','16525.00','cr','1','67','4','158','','','','','2021-07-06 19:19:39','2021-07-06 19:19:39');
INSERT INTO transactions VALUES('186','1','2021-07-06','2','income','','208','Student','525.00','cr','1','58','4','158','','','','sec adjustment 16500','2021-07-06 19:21:04','2021-07-06 19:21:04');
INSERT INTO transactions VALUES('187','1','2021-07-06','2','income','','262','Student','13000.00','cr','1','112','4','158','','','','','2021-07-06 19:46:26','2021-07-06 19:46:26');
INSERT INTO transactions VALUES('188','1','2021-07-06','2','income','','165','Student','18000.00','cr','1','15','4','158','','','','','2021-07-06 20:01:01','2021-07-06 20:01:01');
INSERT INTO transactions VALUES('189','1','2021-07-06','2','income','','216','Student','17025.00','cr','1','66','4','158','','','','','2021-07-06 20:05:53','2021-07-06 20:05:53');
INSERT INTO transactions VALUES('190','1','2021-07-06','2','income','','191','Student','15000.00','cr','1','41','4','158','','','','','2021-07-06 20:11:02','2021-07-06 20:11:02');
INSERT INTO transactions VALUES('191','1','2021-07-06','2','income','','242','Student','13000.00','cr','1','92','4','158','','','','','2021-07-06 20:14:59','2021-07-06 20:14:59');
INSERT INTO transactions VALUES('192','1','2021-07-06','2','income','','193','Student','15000.00','cr','1','43','4','158','','','','','2021-07-06 20:15:46','2021-07-06 20:15:46');
INSERT INTO transactions VALUES('193','1','2021-07-06','2','income','','196','Student','16385.00','cr','1','46','4','158','','','','','2021-07-06 20:50:25','2021-07-06 20:50:25');
INSERT INTO transactions VALUES('194','1','2021-07-06','3','income','','230','Student','16000.00','cr','1','80','1','158','','','','','2021-07-06 20:52:16','2021-07-06 20:52:16');
INSERT INTO transactions VALUES('195','1','2021-07-06','2','income','','228','Student','16000.00','cr','1','78','4','158','','','','','2021-07-06 20:54:52','2021-07-06 20:54:52');
INSERT INTO transactions VALUES('196','1','2021-07-08','2','income','','157','Student','14000.00','cr','1','5','4','158','','','','','2021-07-08 16:05:47','2021-07-08 16:05:47');
INSERT INTO transactions VALUES('197','1','2021-07-08','2','income','','222','Student','18550.00','cr','1','72','4','158','','','','','2021-07-08 16:22:47','2021-07-08 16:22:47');
INSERT INTO transactions VALUES('198','1','2021-07-06','2','income','','261','Student','13000.00','cr','1','111','4','158','','','','','2021-07-08 16:29:56','2021-07-08 16:29:56');
INSERT INTO transactions VALUES('199','1','2021-07-06','2','income','','2','Student','1330.00','cr','1','111','4','158','','','','','2021-07-08 16:31:20','2021-07-08 16:31:20');
INSERT INTO transactions VALUES('200','1','2021-07-07','3','income','','3','Student','5000.00','cr','1','107','1','158','','','','','2021-07-08 16:31:55','2021-07-08 16:31:55');
INSERT INTO transactions VALUES('201','1','2021-07-07','2','income','','259','Student','14000.00','cr','1','109','4','158','','','','','2021-07-08 16:32:31','2021-07-08 16:32:31');
INSERT INTO transactions VALUES('202','1','2021-07-07','3','income','','257','Student','14000.00','cr','1','107','1','158','','','','','2021-07-08 16:33:01','2021-07-08 16:33:01');
INSERT INTO transactions VALUES('203','1','2021-07-07','2','income','','156','Student','10000.00','cr','1','4','4','158','','','','','2021-07-08 16:35:40','2021-07-08 16:35:40');
INSERT INTO transactions VALUES('204','1','2021-07-07','2','income','','243','Student','13000.00','cr','1','93','4','158','','','','','2021-07-08 16:36:14','2021-07-08 16:36:14');
INSERT INTO transactions VALUES('205','1','2021-07-08','2','income','','238','Student','14500.00','cr','1','88','4','158','','','','','2021-07-08 17:04:41','2021-07-08 17:04:41');
INSERT INTO transactions VALUES('206','1','2021-07-08','2','income','','152','Student','15000.00','cr','1','115','4','158','','','','','2021-07-08 17:05:56','2021-07-08 17:05:56');
INSERT INTO transactions VALUES('207','1','2021-07-08','2','income','','226','Student','13000.00','cr','1','76','4','158','','','','','2021-07-08 17:09:39','2021-07-08 17:09:39');
INSERT INTO transactions VALUES('208','1','2021-07-08','3','income','','224','Student','8060.00','cr','1','74','1','158','','','','','2021-07-08 17:13:24','2021-07-08 17:13:24');
INSERT INTO transactions VALUES('209','1','2021-07-07','3','income','','215','Student','16525.00','cr','1','65','1','158','','','','','2021-07-08 17:16:00','2021-07-08 17:16:00');
INSERT INTO transactions VALUES('210','1','2021-07-06','2','income','','2','Student','170.00','cr','1','111','4','158','','','','','2021-07-08 17:17:42','2021-07-08 17:17:42');
INSERT INTO transactions VALUES('211','1','2021-07-07','2','income','','207','Student','19465.00','cr','1','57','4','158','','','','','2021-07-08 17:22:54','2021-07-08 17:22:54');
INSERT INTO transactions VALUES('212','1','2021-07-07','2','income','','199','Student','14000.00','cr','1','49','4','158','','','','','2021-07-08 18:16:10','2021-07-08 18:16:10');
INSERT INTO transactions VALUES('213','1','2021-07-08','2','income','','30','Student','500.00','cr','1','22','4','158','','','','','2021-07-08 19:18:11','2021-07-08 19:18:11');
INSERT INTO transactions VALUES('214','1','2021-07-08','2','income','','57','Student','1000.00','cr','1','22','4','158','','','','','2021-07-08 19:18:37','2021-07-08 19:18:37');
INSERT INTO transactions VALUES('215','1','2021-07-08','2','income','','172','Student','16500.00','cr','1','22','4','158','','','','','2021-07-08 19:19:09','2021-07-08 19:19:09');
INSERT INTO transactions VALUES('216','1','2021-07-08','2','income','','200','Student','16500.00','cr','1','50','4','158','','','','','2021-07-08 19:34:04','2021-07-08 19:34:04');
INSERT INTO transactions VALUES('217','1','2021-07-08','2','income','','201','Student','2240.00','cr','1','51','4','158','','','','','2021-07-08 19:37:33','2021-07-08 19:37:33');
INSERT INTO transactions VALUES('218','1','2021-07-08','2','income','','202','Student','16500.00','cr','1','52','4','158','','','','','2021-07-08 19:39:23','2021-07-08 19:39:23');
INSERT INTO transactions VALUES('219','1','2021-07-08','2','income','','206','Student','19465.00','cr','1','56','4','158','','','','','2021-07-08 20:55:23','2021-07-08 20:55:23');
INSERT INTO transactions VALUES('220','1','2021-07-10','2','income','','170','Student','6000.00','cr','1','20','4','158','','','','','2021-07-10 13:49:50','2021-07-10 13:49:50');
INSERT INTO transactions VALUES('221','1','2021-07-10','2','income','','55','Student','10000.00','cr','1','20','4','158','','','','','2021-07-10 13:50:15','2021-07-10 13:50:15');
INSERT INTO transactions VALUES('222','1','2021-07-10','2','income','','168','Student','16340.00','cr','1','18','4','158','','','','','2021-07-10 13:52:07','2021-07-10 13:52:07');
INSERT INTO transactions VALUES('223','1','2021-07-10','2','income','','26','Student','2000.00','cr','1','17','4','158','','','','','2021-07-10 13:56:13','2021-07-10 13:56:13');
INSERT INTO transactions VALUES('224','1','2021-07-10','3','income','','167','Student','6340.00','cr','1','17','1','158','','','','','2021-07-10 13:58:17','2021-07-10 13:58:17');
INSERT INTO transactions VALUES('225','1','2021-07-10','3','income','','27','Student','1000.00','cr','1','19','1','158','','','','','2021-07-10 13:58:48','2021-07-10 13:58:48');
INSERT INTO transactions VALUES('226','1','2021-07-10','3','income','','169','Student','6340.00','cr','1','19','1','158','','','','','2021-07-10 14:00:50','2021-07-10 14:00:50');
INSERT INTO transactions VALUES('227','1','2021-07-09','2','income','','246','Student','16500.00','cr','1','96','4','158','','','','','2021-07-10 14:04:53','2021-07-10 14:04:53');
INSERT INTO transactions VALUES('228','1','2021-07-09','3','income','','244','Student','13000.00','cr','1','94','1','158','','','','','2021-07-10 14:05:38','2021-07-10 14:05:38');
INSERT INTO transactions VALUES('229','1','2021-07-09','2','income','','223','Student','18560.00','cr','1','73','4','158','','','','','2021-07-10 14:09:33','2021-07-10 14:09:33');
INSERT INTO transactions VALUES('230','1','2021-07-10','3','income','','198','Student','17320.00','cr','1','48','1','158','','','','','2021-07-10 14:13:26','2021-07-10 14:13:26');
INSERT INTO transactions VALUES('231','1','2021-07-08','2','income','','159','Student','24000.00','cr','1','9','4','158','','','','','2021-07-10 14:14:39','2021-07-10 14:14:39');
INSERT INTO transactions VALUES('232','1','2021-07-08','3','income','','205','Student','6000.00','cr','1','55','1','158','','','','','2021-07-10 14:17:06','2021-07-10 14:17:06');
INSERT INTO transactions VALUES('233','1','2021-07-08','2','income','','17','Student','1000.00','cr','1','59','4','158','','','','','2021-07-10 14:17:46','2021-07-10 14:17:46');
INSERT INTO transactions VALUES('234','1','2021-07-08','2','income','',