
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title">
					<?php echo e(_lang('Add New Student')); ?>

				</div>
			</div>
			<div class="panel-body">
				<div class="col-md-12">
					<form action="<?php echo e(route('students.store')); ?>" autocomplete="off" class="form-horizontal form-groups-bordered validate" enctype="multipart/form-data" method="post" accept-charset="utf-8">
						<?php echo csrf_field(); ?>
						<div class="row" style="margin-top: 10px">
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('First Name')); ?></label>
									<div class="col-sm-9">
										<input type="text" class="form-control" name="first_name" value="<?php echo e(old('first_name')); ?>" required>
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang("Father's Name")); ?></label>
									<div class="col-sm-9">
										<input type="text" class="form-control" name="father_name" value="<?php echo e(old('father_name')); ?>" required>
									</div>
								</div>
							</div>
						</div>

						<div class="row">
							
							<input type="hidden" value="1" name="guardian">
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Gender')); ?></label>
									<div class="col-sm-9">
										<select name="gender" class="form-control niceselect wide" required>
											<option value=""><?php echo e(_lang('Select One')); ?></option>
										    <option value="Male" <?php echo e(old('gender') == 'Male' ? 'selected' : ''); ?>><?php echo e(_lang('Male')); ?></option>
    										<option value="Female" <?php echo e(old('gender') == 'Female' ? 'selected' : ''); ?>><?php echo e(_lang('Female')); ?></option>
										</select>
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Birthday')); ?></label>
									<div class="col-sm-9">
										<input type="text" class="form-control datepicker" name="birthday" value="<?php echo e(old('birthday')); ?>" required>
									</div>
								</div>
							</div>
						</div>

						<div class="row">
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Blood Group')); ?></label>
									<div class="col-sm-9">
										<select name="blood_group" class="form-control select2" id="blood_group">
											<option value=""><?php echo e(_lang('Select One')); ?></option>
											<option value="N/A" <?php if(old('blood_group') == 'N/A'): echo 'selected'; endif; ?>><?php echo e(_lang('N/A')); ?></option>
											<option value="A+" <?php if(old('blood_group') == 'A+'): echo 'selected'; endif; ?>><?php echo e(_lang('A+')); ?></option>
											<option value="A-" <?php if(old('blood_group') == 'A-'): echo 'selected'; endif; ?>><?php echo e(_lang('A-')); ?></option>
											<option value="B+" <?php if(old('blood_group') == 'B+'): echo 'selected'; endif; ?>><?php echo e(_lang('B+')); ?></option>
											<option value="B-" <?php if(old('blood_group') == 'B-'): echo 'selected'; endif; ?>><?php echo e(_lang('B-')); ?></option>
											<option value="AB+" <?php if(old('blood_group') == 'AB+'): echo 'selected'; endif; ?>><?php echo e(_lang('AB+')); ?></option>
											<option value="AB-" <?php if(old('blood_group') == 'AB-'): echo 'selected'; endif; ?>><?php echo e(_lang('AB-')); ?></option>
											<option value="O+" <?php if(old('blood_group') == 'O+'): echo 'selected'; endif; ?>><?php echo e(_lang('O+')); ?></option>
											<option value="O-" <?php if(old('blood_group') == 'O-'): echo 'selected'; endif; ?>><?php echo e(_lang('O-')); ?></option>
										</select>
									</div>
								</div>
							</div>
								<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Religion')); ?></label>
									<div class="col-sm-9">
										<select name="religion" class="form-control niceselect wide">
											<option value=""><?php echo e(_lang('Select One')); ?></option>
											<?php echo e(create_option("picklists","value","value",old('religion'),array("type="=>"Religion"))); ?>	
										</select>
									</div>
								</div>
							</div>
						</div>

						<div class="row">
						
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Cell Phone')); ?></label>
									<div class="col-sm-9">
										<input type="text" class="form-control phoneNumber" name="phone" value="<?php echo e(old('phone')); ?>"
												placeholder="(123) 456-7890"
												required>
									</div>
								</div>
							</div>

							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Home Phone')); ?></label>
									<div class="col-sm-9">
										<input type="text" class="form-control phoneNumber" name="home_phone" value="<?php echo e(old('home_phone')); ?>">
									</div>
								</div>
							</div>
						</div>

						<div class="row">
							
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Address')); ?></label>
									<div class="col-sm-9">
										<input class="form-control" name="address" value="<?php echo e(old('address')); ?>" />
									</div>
								</div>
							</div>
								<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 keratoconus is an eye condition in which the cornea thins and gradually bulges outward into a cone shape, causing blurry vision and light sensitivity. control-label"><?php echo e(_lang('State')); ?></label>
									<div class="col-sm-9">
										<select name="state" class="form-control select2" required>
											<?php echo e(get_country_states(old('state'), 'Pakistan')); ?>

										</select>
									</div>
								</div>
							</div>
						</div>

						<div class="row">
						
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Country')); ?></label>
									<div class="col-sm-9">
										<select name="country" class="form-control select2" required>
											<?php echo e(get_country_list(old('country')??'Pakistan')); ?>

										</select>
									</div>
								</div>
							</div>

							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Floor')); ?></label>
									<div class="col-sm-9">
										<select name="class" class="form-control select2" id="class" required>
											<option value=""><?php echo e(_lang('Select One')); ?></option>
											<?php echo e(create_option('classes','id','class_name',old('class'))); ?>

										</select>
									</div>
								</div>
							</div>
						</div>

						<div class="row">
						
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Room')); ?></label>
									<div class="col-sm-9">
										<select name="section" class="form-control" id="section" required>
											<option value=""><?php echo e(_lang('Select One')); ?></option>
											<?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option data-class="<?php echo e($data->class_id); ?>" value="<?php echo e($data->id); ?>" <?php if(old('section') == $data->id): echo 'selected'; endif; ?>><?php echo e($data->section_name); ?></option>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</select>
									</div>
								</div>
							</div>

								<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Group')); ?></label>
									<div class="col-sm-9">
										<select name="department" class="form-control select2" required>
											<option value=""><?php echo e(_lang('Select One')); ?></option>
											<?php echo e(create_option('departments','id','department_name',old('department'))); ?>

										</select>
									</div>
								</div>
							</div>
						</div>

						<div class="row">
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('CNIC ')); ?></label>
									<div class="col-sm-9">
										<input type="text" class="form-control" id="activities" name="activities" value="<?php echo e(old('activities')); ?>">
									</div>
								</div>
							</div>

								<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Register NO')); ?></label>
									<div class="col-sm-9">
										<input type="number" class="form-control" id="register_no" name="register_no" value="<?php echo e(old('register_no')); ?>" required>
									</div>
								</div>
							</div>
						</div>

						<div class="row">
						
							
							
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"><?php echo e(_lang('Remarks')); ?></label>
									<div class="col-sm-9">
										<input type="text" class="form-control" name="remarks" value="<?php echo e(old('remarks')); ?>">
									</div>
								</div>
							</div>
						</div>


						<div class="form-group" style="margin-top:20px">
							<div class="col-md-12">
								<div class="panel panel-default">
									<div class="panel-heading">
										<span><?php echo e(_lang('Student Fees')); ?></span>
										<button type="button" class="btn btn-danger pull-right" id="add-item-row-assign" style="margin-top:-7px;margin-left:10px;"><?php echo e(_lang('Add New Row')); ?></button>
									</div>
									<div class="panel-body d-none" id="invoice_assign_div">
										<table class="table">
											<thead style="background:#dce9f9;">
												<th><?php echo e(_lang('Fee Type')); ?></th>
												<th style="text-align:left"><?php echo e(_lang('Amount')." ".get_option('currency_symbol')); ?></th>
												<th style="text-align:left"><?php echo e(_lang('Discount')." ".get_option('currency_symbol')); ?></th>
												<th style="text-align:left"><?php echo e(_lang('Total')." ".get_option('currency_symbol')); ?></th>		  
											</thead>
											<tbody id="invoice_assign">
											</tbody>
											<tfoot>
												<tr>
													<td class="text-right" colspan="3"><label class="control-label"><?php echo e(_lang('Total')); ?></label></td>
													<td><input type="text" class="form-control" id="total_assign" name="total" value="<?php echo e(old('total')); ?>" readOnly="true"></td>
												</tr>
											</tfoot>
										</table>
									</div>
								</div>
							</div>
						</div>

						<hr>
						<div class="row">
							<div class="col-md-6">
								<div class="form-group">
									<label class="col-sm-3 control-label"></label>
									<div class="col-sm-9">
										<label class="c-container" style="padding-top: 2px;">Need Login Details<input name="need_login" class="need_login_click" value="1" type="checkbox"><span class="checkmark"></span></label>
									</div>
								</div>
							</div>
						</div>

						<div id="need_login_div" class="d-none">
							<div class="page-header">
								<h4>Login Details</h4>
							</div>
							<div class="row">
								<div class="col-md-8">
									<div class="form-group">
										<label class="col-sm-3 control-label"><?php echo e(_lang('Email')); ?></label>
										<div class="col-sm-9">
											<input type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" required>
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-8">
									<div class="form-group">
										<label class="col-sm-3 control-label"><?php echo e(_lang('Password')); ?></label>
										<div class="col-sm-9">
											<input type="password" class="form-control" name="password" required>
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-8">
									<div class="form-group">
										<label class="col-sm-3 control-label"><?php echo e(_lang('Confirm Password')); ?></label>
										<div class="col-sm-9">
											<input type="password" class="form-control" name="password_confirmation" required>
										</div>
									</div>
								</div>
							</div>
							
							<div class="row">
								<div class="col-md-8">
									<div class="form-group">
										<label class="col-sm-3 control-label"><?php echo e(_lang('Profile Picture')); ?></label>
										<div class="col-sm-9">
 											<input type="file" class="form-control dropify" name="image" data-allowed-file-extensions="jpg jpeg JPG JPEG png PNG">
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="form-group mt-2">
							<div class="col-sm-offset-11">
								<button type="submit" class="btn btn-info">Add Student</button>
							</div>
						</div>
					</form>
				</div>
				<table style="display:none;">
					<tr id="fee_row_assign">
						<td width="40%"><?php echo get_fee_selectbox(); ?></td>
						<td><input type="number" min="0" value="0" class="form-control float-field amount" name="amount[]" required></td>
						<td><input type="number" value="0" class="form-control float-field discount" min="0" name="discount[]" required></td>
						<td><input type="number" value="0" class="form-control float-field total" name="sub_total[]" readOnly="true" required></td>
					</tr>
				</table>	
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
$(window).on('load', function() {
	$('#phone').mask("929999999999");
	$('#activities').mask("09999-9999999-9");
	if($('#register_no').val()=="") {
		$('#register_no').val(Math.floor((Math.random() * 99999999) + 1));
	}
	
	$("#section").next().find("ul li").css("display","none");
	$(document).on("change","#class",function(){
		$("#section").next().find("ul li").css("display","none");
		var class_id = $(this).val();
		$('#section option[data-class="' + class_id + '"]').each(function(){
			var section_id = $(this).val();
			$("#section").next().find("ul li[data-value='" + section_id + "']").css("display","block");
		});
	});

	$(document).on('click','#add-item-row-assign',function(){
		var row = $("#fee_row_assign").clone();
		$('#invoice_assign_div').removeClass('d-none');		
		$(row).removeAttr("id");		
		$(row).find('select').select2();		
		$("#invoice_assign").append(row);		
	});
	
	$(document).on('keyup','.amount,.discount',function(){
		var amount = parseFloat($(this).closest("tr").find(".amount").val());
		var discount = parseFloat($(this).closest("tr").find(".discount").val());
		$(this).closest("tr").find(".total").val(amount-discount);
		
		var total = 0;
		jQuery("#invoice_assign > tr").each(function () {
			var sub_total = parseFloat($(this).find(".total").val());
			total += sub_total;
		});	
		$("#total_assign").val(total);		
	});
	
	$(document).on('change','#class',function(){
		load_option_subject();
	});
	
	$(document).on('change','.need_login_click',function(){
		if ($(this).is(":checked")) {
			$('#need_login_div').removeClass('d-none');
		} else {
			$('#need_login_div').addClass('d-none');
		}
	});
	
	function load_option_subject(){
		var class_id = $("#class").val();
		var link = "<?php echo e(url('students/get_subjects/')); ?>";
		$.ajax({
			url: link+"/"+class_id,
			success: function(data){		
				$('#optional_subject').html(data);				
			}
		});
	}

	$('#section').select2();

	$('#guardian').select2({
		placeholder: "<?php echo e(_lang('Select One')); ?>",
		ajax: {
			dataType: "json",
			url: "<?php echo e(url('parents/get_parents')); ?>",
			delay: 400,
			data: function(params) {
				return {
					term: params.term
				}
			},
			processResults: function (data, page) {
				return {
					results: data
				};
			},
		}
	});


	$('.phoneNumber').on('input', function () {
	 let input = $(this).val().replace(/\D/g, ''); // Remove non-digits
    if (input.length > 11) input = input.substring(0, 11); // Limit to 11 digits

    let formatted = '';

    if (input.length < 5) {
        formatted = '(' + input;
    } else if (input.length < 8) {
        formatted = '(' + input.substring(0, 4) + ') ' + input.substring(4);
    } else {
        formatted = '(' + input.substring(0, 4) + ') ' + input.substring(4, 7) + ' ' + input.substring(7, 11);
    }

    $(this).val(formatted);
	});

	
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\hms_fatima\hms_fatima\resources\views/backend/students/student-add.blade.php ENDPATH**/ ?>